/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.video.InterfaceNativeKeyEventListener;
import com.avocent.video.NativeKeyTranslator;
import java.awt.Component;

public abstract class NativeAvocentLibrary {
    public static final String TRACE_CONTEXT = "NativeAvocentLibrary";
    private static NativeAvocentLibrary m_nal = null;

    private static boolean loadLibrary(String string) {
        m_nal = null;
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            if (obj instanceof NativeAvocentLibrary) {
                NativeAvocentLibrary nativeAvocentLibrary = (NativeAvocentLibrary)obj;
                if (nativeAvocentLibrary.isLibraryLoadedImpl()) {
                    m_nal = nativeAvocentLibrary;
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("Successfully loaded the shared library: " + string));
                }
            } else {
                m_nal = new StubLibrary();
            }
        }
        catch (LinkageError linkageError) {
            Trace.logError((String)TRACE_CONTEXT, (String)("LinkageError while loading (" + string + "), "), (Throwable)linkageError);
        }
        catch (SecurityException securityException) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Security exception while loading (" + string + ")"), (Throwable)securityException);
        }
        catch (Throwable throwable) {
            Trace.logError((String)TRACE_CONTEXT, (String)(" FAILED to load (" + string + ").dll"), (Throwable)throwable);
        }
        return m_nal != null;
    }

    public static void setEnableLogging(boolean bl) {
        if (m_nal != null) {
            m_nal.setEnableLoggingImpl(bl);
        }
    }

    public static boolean isLibraryLoaded() {
        return m_nal == null ? false : m_nal.isLibraryLoadedImpl();
    }

    public static NativeKeyTranslator getKeyTranslator() {
        return m_nal == null ? null : m_nal.getKeyTranslatorImpl();
    }

    public static NativeAvocentLibrary getInstance() {
        return m_nal;
    }

    public static void registerNativeKeyListener(InterfaceNativeKeyEventListener interfaceNativeKeyEventListener, Component component) {
        if (NativeAvocentLibrary.isLibraryLoaded()) {
            NativeAvocentLibrary.getInstance().registerNativeKeyListenerImpl(interfaceNativeKeyEventListener, component);
        }
    }

    public static void unregisterNativeKeyListener(InterfaceNativeKeyEventListener interfaceNativeKeyEventListener, Component component) {
        if (NativeAvocentLibrary.isLibraryLoaded()) {
            NativeAvocentLibrary.getInstance().unregisterNativeKeyListenerImpl(interfaceNativeKeyEventListener, component);
        }
    }

    public static void setKeyboardPassThru(boolean bl, Component component) {
        if (NativeAvocentLibrary.isLibraryLoaded()) {
            NativeAvocentLibrary.getInstance().setNativeKeyboardPassThru(bl, component);
        }
    }

    protected abstract void registerNativeKeyListenerImpl(InterfaceNativeKeyEventListener var1, Component var2);

    protected abstract void setEnableLoggingImpl(boolean var1);

    public abstract NativeKeyTranslator getKeyTranslatorImpl();

    public abstract boolean isLibraryLoadedImpl();

    public abstract void unregisterNativeKeyListenerImpl(InterfaceNativeKeyEventListener var1, Component var2);

    public abstract void setNativeKeyboardPassThru(boolean var1, Component var2);

    static {
        String[] stringArray = new String[]{"com.avocent.video.LinuxLibrary", "com.avocent.video.SolarisLibrary"};
        for (int i = 0; i < stringArray.length && !NativeAvocentLibrary.loadLibrary(stringArray[i]); ++i) {
        }
    }

    private static class StubLibrary
    extends NativeAvocentLibrary {
        private StubLibrary() {
        }

        public void unregisterNativeKeyListenerImpl(InterfaceNativeKeyEventListener interfaceNativeKeyEventListener, Component component) {
            throw new UnsupportedOperationException("Native Library Does NOT Implement NativeAvocentLibrary");
        }

        public NativeKeyTranslator getKeyTranslatorImpl() {
            throw new UnsupportedOperationException("Native Library Does NOT Implement NativeAvocentLibrary");
        }

        protected void registerNativeKeyListenerImpl(InterfaceNativeKeyEventListener interfaceNativeKeyEventListener, Component component) {
            throw new UnsupportedOperationException("Native Library Does NOT Implement NativeAvocentLibrary");
        }

        public void setNativeKeyboardPassThru(boolean bl, Component component) {
            throw new UnsupportedOperationException("Native Library Does NOT Implement NativeAvocentLibrary");
        }

        protected void setEnableLoggingImpl(boolean bl) {
            throw new UnsupportedOperationException("Native Library Does NOT Implement NativeAvocentLibrary");
        }

        public boolean isLibraryLoadedImpl() {
            return true;
        }
    }
}

