/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogLogin;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.OS;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.UsernamePassword;
import com.avocent.protocols.socket.SSLHelper;
import com.avocent.video.AVSPStatus;
import com.avocent.video.ApcpSessionSetup;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionAVSP;
import com.avocent.video.BrandNaming;
import com.avocent.video.DSConnect;
import com.avocent.video.DSEncryptValues;
import com.avocent.video.DSPath;
import com.avocent.video.DataInputStreamEndian;
import com.avocent.video.DataOutputStreamEndian;
import com.avocent.video.InterfaceElapsedTimeDialog;
import com.avocent.video.InterfaceNotifyOnClosing;
import com.avocent.video.JDialogElapsedTime;
import com.avocent.video.JDialogWaitingForPreemption;
import com.avocent.video.PersistentStorage;
import com.avocent.video.ProtocolAPCP;
import com.avocent.video.SessionManager;
import com.avocent.video.UserNotification;
import com.avocent.video.Win32Library;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Random;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class Nec
implements InterfaceNotifyOnClosing {
    public static final String CNAME = "Nec";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    private static final String CL_TITLE = "title=";
    private static final String CL_USER = "user=";
    private static final String CL_PASSWORD = "password=";
    private static final String CL_IFACEVIEWER = "ifaceviewer3=";
    private static final String CL_MODE = "mode=";
    private static final String CL_PATH = "path=";
    private static final String CL_HELPURL = "helpurl=";
    private static final String CL_REMOTE = "remote=";
    public static final String CL_DONTCHECKSESSIONRUNNING = "dontchecksession=";
    private static final String MODE_NORMAL = "normal";
    private static final String MODE_SCAN = "scan";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final int PORT_NUMBER_AVSP_SSL = 2068;
    private static final int PORT_NUMBER_AVSP_VIDEO = 8192;
    private static final int PORT_NUMBER_EMBEDDED_TCP = 2000;
    private static final int PORT_NUMBER_EMBEDDED_UDP = 623;
    private static final int CONNECT_WAIT_TIME = 100;
    private static final int INPUT_BUFFER_SIZE = 32768;
    private DataOutputStreamEndian m_dosAppliance;
    private DataInputStreamEndian m_disAppliance;
    private DataOutputStreamEndian m_dosApplianceVideo;
    private DataInputStreamEndian m_disApplianceVideo;
    private DSEncryptValues m_encryptValues;
    private DatagramSocket m_udpConnection;
    private static boolean m_bStartedFromCommandLine = true;
    private static boolean m_bRemote = false;
    InterfaceElapsedTimeDialog m_dlgElapsed;
    boolean m_bUserCancelled = false;
    boolean m_bApplianceSessionRunning = false;
    public static Hashtable m_htPendingConnections = new Hashtable(1);
    private static Object m_syncConnectionPending = new Object();
    String m_szUser = "";
    String m_szPassword = "";
    String m_szTitle = "";
    String m_szIFaceViewer = "";
    boolean m_bVirtualMediaAvailable = false;
    String m_szOEM = "";
    String m_szApplianceType;
    String m_szApplianceEID;
    String m_szHelpURL;
    boolean m_bEnablePPP = false;
    boolean m_bVideoEncryptEnable = false;
    DSPath m_dsPath;
    UsernamePassword m_userCredentials;
    boolean m_bDontCheckSessionRunning = false;
    protected Frame m_fLoginDialogParent;
    boolean m_bLocalUserUsingChannelWeArePreempting = false;
    private Win32Library m_libWin32;
    private int m_nApplication = 3;
    private int m_nConnectionType = 0;
    private AVSPStatus m_avspStatus = new AVSPStatus();

    public Nec(String[] stringArray) throws ExceptionRequestFailed {
        this(stringArray, null);
    }

    public Nec(String[] stringArray, Frame frame) throws ExceptionRequestFailed {
        int n;
        if (OS.isWindows()) {
            this.m_libWin32 = new Win32Library();
            Nec nec = this;
            nec.m_libWin32.initLib();
        }
        this.m_fLoginDialogParent = frame;
        boolean bl = false;
        this.m_bApplianceSessionRunning = false;
        this.m_bUserCancelled = false;
        try {
            int n2 = UIManager.getColor("MenuItem.foreground").getRGB();
            n = UIManager.getColor("MenuItem.background").getRGB();
            if ((n2 == -1 || n2 == -16711936) && n == -16777216) {
                UIManager.put("MenuItem.disabledForeground", new ColorUIResource(Color.gray));
            }
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            return;
        }
        String string = "";
        for (n = 0; n < stringArray.length; ++n) {
            string = string + stringArray[n];
            string = string + " ";
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer) Command line: " + string));
        this.parseCommandLine(stringArray);
        try {
            this.m_userCredentials = new UsernamePassword(this.m_szUser, this.m_szPassword);
            this.desktopMode();
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
            this.closeUserCancelDialog();
        }
    }

    private void parseCommandLine(String[] stringArray) throws ExceptionRequestFailed {
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            int n = stringArray[i].indexOf(CL_TITLE);
            if (n >= 0) {
                int n2;
                bl = true;
                this.m_szTitle = stringArray[i].substring(n + CL_TITLE.length());
                if (this.m_szTitle.charAt(0) == '\"') {
                    this.m_szTitle = this.m_szTitle.substring(1);
                }
                if ((n2 = this.m_szTitle.lastIndexOf(34)) <= 0) continue;
                this.m_szTitle = this.m_szTitle.substring(0, n2);
                continue;
            }
            n = stringArray[i].indexOf(CL_USER);
            if (n >= 0) {
                bl = true;
                this.m_szUser = stringArray[i].substring(n + CL_USER.length());
                continue;
            }
            n = stringArray[i].indexOf(CL_PASSWORD);
            if (n >= 0) {
                bl = true;
                this.m_szPassword = stringArray[i].substring(n + CL_PASSWORD.length());
                continue;
            }
            n = stringArray[i].indexOf(CL_REMOTE);
            if (n >= 0) {
                bl = true;
                m_bRemote = true;
                m_bStartedFromCommandLine = false;
                continue;
            }
            n = stringArray[i].indexOf(CL_PATH);
            if (n >= 0) {
                bl = true;
                this.m_dsPath = new DSPath(stringArray[i].substring(n + CL_PATH.length()), "");
                continue;
            }
            n = stringArray[i].indexOf(CL_DONTCHECKSESSIONRUNNING);
            if (n >= 0) {
                bl = true;
                this.m_bDontCheckSessionRunning = true;
                continue;
            }
            n = stringArray[i].indexOf(CL_HELPURL);
            if (n < 0) continue;
            bl = true;
            this.m_szHelpURL = stringArray[i].substring(n + CL_HELPURL.length());
        }
    }

    public static Socket doApcp(String string, boolean bl) throws ExceptionRequestFailed {
        Socket socket = null;
        try {
            byte[] byArray = new byte[32];
            Random random = new Random();
            random.nextBytes(byArray);
            int n = 2068;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.doApcp using APCP creating normal/clear socket");
            Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.doApcp connecting socket to IP address=" + string + " port=" + n));
            socket = new Socket(string, n);
            socket.setTcpNoDelay(true);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
            DataOutputStreamEndian dataOutputStreamEndian = new DataOutputStreamEndian(bufferedOutputStream);
            DataInputStreamEndian dataInputStreamEndian = new DataInputStreamEndian(bufferedInputStream, socket);
            Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.doApcp calling ProtocolAPCP.sendSessionRequest");
            ProtocolAPCP.sendSessionRequest(dataOutputStreamEndian, bl ? (byte)4 : 3, (byte)0, (byte)0, 8, byArray);
            Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.doApcp calling ProtocolAPCP.receiveSessionSetup");
            ApcpSessionSetup apcpSessionSetup = ProtocolAPCP.receiveSessionSetup(dataInputStreamEndian, socket);
            if (apcpSessionSetup.getTcpPort() != 0) {
                socket.close();
                socket = new Socket(string, (int)apcpSessionSetup.getTcpPort());
                socket.setTcpNoDelay(true);
            }
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
            throw new ExceptionRequestFailed("Failure in setting up APCP");
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void desktopMode() throws ExceptionRequestFailed {
        block30: {
            boolean bl = false;
            boolean bl2 = true;
            String string = "";
            boolean bl3 = false;
            PersistentStorage persistentStorage = null;
            try {
                Object object;
                Object object2;
                boolean bl4;
                new ThreadCheckForUserCancel(this.m_dsPath.getDisplayName());
                bl = false;
                String string2 = "NEC";
                if (Win32Library.isWin32LibLoaded()) {
                    string2 = this.m_libWin32.getLocalAppDataPath() + "\\NEC";
                }
                File file = new File(string2);
                file.mkdir();
                persistentStorage = new PersistentStorage(this.m_dsPath.getIPAddress(), this.m_dsPath.getPortNumber(), this.m_dsPath.getRIPId(), this.m_dsPath.getCascadeChannel(), "\\", string2);
                String string3 = this.m_dsPath.getDeviceID();
                if (string3 == null || string3.length() == 0) {
                    string3 = this.m_dsPath.getPortNumber() != 0 ? this.m_dsPath.getIPAddress() + this.m_dsPath.getPortNumber() + this.m_dsPath.getCascadeChannel() : this.m_dsPath.getIPAddress() + this.m_dsPath.getRIPId() + this.m_dsPath.getCascadeChannel();
                }
                if (bl4 = SessionManager.isThisDeviceIDSessionRunning(this.m_dsPath.toString(), false)) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer.desktopMode) session already exists for path: " + this.m_dsPath.toString()));
                    object2 = SessionManager.getSessionFromPath(this.m_dsPath);
                    if (object2 != null) {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer.desktopMode) got appliance session through getSessionFromPath");
                        SessionManager.bringSessionToForeground(string3);
                        throw new ExceptionRequestFailed("Session for this device ID is already running");
                    }
                }
                object2 = m_htPendingConnections.keys();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    if (((String)object).compareTo(this.m_dsPath.toString()) != 0) continue;
                    JDialog jDialog = (JDialog)m_htPendingConnections.get(this.m_dsPath.toString());
                    jDialog.toFront();
                    throw new ExceptionRequestFailed("This device ID already has a pending connection session");
                }
                object = m_syncConnectionPending;
                synchronized (object) {
                    Object object3;
                    m_htPendingConnections.put(this.m_dsPath.toString(), this.m_dlgElapsed);
                    bl2 = true;
                    this.showUserCancelDialog(false);
                    if (this.m_userCredentials.getUsername().length() == 0) {
                        try {
                            object3 = new JDialogLogin(this.m_fLoginDialogParent, RES.getString("Nec_Login"), this.m_userCredentials);
                            object3.setModal(true);
                            object3.setVisible(true);
                            if (!object3.wasOkPressed()) {
                                throw new ExceptionRequestFailed("User cancelled login dialog");
                            }
                        }
                        catch (ExceptionConstructorFailed exceptionConstructorFailed) {
                            Trace.logError((String)TRACE_CONTEXT, (String)exceptionConstructorFailed.getMessage(), (Throwable)exceptionConstructorFailed);
                            throw new ExceptionRequestFailed("Login dialog constructor failed");
                        }
                    }
                    this.showUserCancelDialog(true);
                    object3 = null;
                    if (this.m_dsPath.hasApcp()) {
                        object3 = Nec.doApcp(this.m_dsPath.getIPAddress(), false);
                    }
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("(VideoViewer) about to avspConnect userCredentialsThisPath username=" + this.m_userCredentials.getUsername() + " password=" + this.m_userCredentials.getPassword()));
                    bl = this.avspConnect((Socket)object3, true);
                }
                if (this.m_bUserCancelled) {
                    this.closeUserCancelDialog();
                }
                m_htPendingConnections.remove(this.m_dsPath.toString());
                bl2 = false;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (bl) {
                    if (this.m_bUserCancelled) {
                        this.closeUserCancelDialog();
                        throw new ExceptionRequestFailed("User cancelled");
                    }
                    object = null;
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"(VideoViewer) connected to appliance calling constructor for ApplianceSessionAVSP");
                    object = new ApplianceSessionAVSP(persistentStorage, null, this.m_dsPath, this.m_szTitle, this.m_disAppliance, this.m_dosAppliance, this.m_disApplianceVideo, this.m_dosApplianceVideo, this.m_szHelpURL, false, m_bRemote, false, false, this.m_nApplication, this.m_avspStatus.getClientRandom(), this.m_avspStatus.getApplianceRandom());
                    ((ApplianceSession)object).setNotifyOnClosing(this);
                    boolean bl5 = false;
                    ((ApplianceSession)object).setVirtualMediaAvailableForTD(false);
                    ((ApplianceSession)object).setUserHasRightsToLaunchVirtualMedia(false);
                    while (((Thread)object).isAlive()) {
                        if (!this.m_bApplianceSessionRunning) {
                            if (((ApplianceSession)object).isSessionRunning() && ((ApplianceSession)object).getApplianceWindow() != null && ((ApplianceSession)object).getApplianceWindow().isVisible()) {
                                Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer desktopMode) setting m_bApplianceSessionRunning flag true");
                                this.m_bApplianceSessionRunning = true;
                                this.m_dlgElapsed.setVisible(false);
                                this.m_dlgElapsed.dispose();
                                this.m_dlgElapsed = null;
                                ((ApplianceSession)object).removeNotifyOnClosing(this);
                            } else if (this.m_bUserCancelled) {
                                Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer desktopMode) user cancelled");
                                this.closeUserCancelDialog();
                                ((ApplianceSession)object).terminateSession();
                                ((ApplianceSession)object).getApplianceWindow().terminate();
                                this.m_bApplianceSessionRunning = true;
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    if (!this.m_bUserCancelled) {
                        this.closeUserCancelDialog();
                        Message.show(null, (String)(RES.getString("Nec_No_connection_could_be_established") + this.m_dsPath.getIPAddress()));
                    }
                    throw new ExceptionRequestFailed(RES.getString("Nec_Connection_not_established"));
                }
                Object var15_19 = null;
                if (!bl2) break block30;
                m_htPendingConnections.remove(this.m_dsPath.toString());
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                if (bl2) {
                    m_htPendingConnections.remove(this.m_dsPath.toString());
                }
                throw throwable;
            }
            {
            }
        }
    }

    private boolean avspConnect(Socket socket, boolean bl) {
        boolean bl2 = false;
        try {
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            do {
                Object[] objectArray;
                int n;
                String string;
                SSLSocket sSLSocket = null;
                Socket socket2 = null;
                socket2 = socket == null ? new Socket(this.m_dsPath.getIPAddress(), 2068) : socket;
                String[] stringArray = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5"};
                sSLSocket = SSLHelper.createSSLSocket((Socket)socket2, (String)this.m_dsPath.getIPAddress(), (int)socket2.getPort(), (int)30000, (String[])stringArray, (SSLSocketFactory)SSLHelper.getSSLSocketFactory());
                if (sSLSocket == null || this.m_bUserCancelled) {
                    return false;
                }
                sSLSocket.setTcpNoDelay(true);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(sSLSocket.getOutputStream());
                BufferedInputStream bufferedInputStream = new BufferedInputStream(sSLSocket.getInputStream());
                this.m_dosAppliance = new DataOutputStreamEndian(bufferedOutputStream);
                this.m_disAppliance = new DataInputStreamEndian(bufferedInputStream, sSLSocket);
                sSLSocket.setSoTimeout(30000);
                DSConnect.dsConnectApplianceAVSP(this.m_dosAppliance, this.m_disAppliance, this.m_dsPath, this.m_userCredentials.getUsername(), this.m_userCredentials.getPassword(), bl3, this.m_avspStatus);
                sSLSocket.setSoTimeout(0);
                if (this.m_avspStatus.getLoginStatus() == 0) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect login succeeded");
                    socket2 = null;
                    boolean bl7 = false;
                    string = "";
                    bl7 = this.m_dsPath.hasApcp();
                    string = this.m_dsPath.getIPAddress();
                    int n2 = n = bl7 ? 2068 : 8192;
                    if (bl7) {
                        int n3 = 1;
                        if (this.m_avspStatus.isVideoEncrypted()) {
                            n3 = 4;
                        }
                        socket2 = Nec.doApcp(string, true);
                    }
                    if (this.m_avspStatus.isVideoEncrypted()) {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect video is to be encrypted");
                        if (socket2 == null) {
                            socket2 = new Socket(string, n);
                        }
                        if ((objectArray = SSLHelper.createSSLSocket((Socket)socket2, (String)string, (int)n, (int)30000, (String[])stringArray, (SSLSocketFactory)SSLHelper.getSSLSocketFactory())) != null) {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.avspConnect Cipher Suite=" + ((SSLSocket)objectArray).getSession().getCipherSuite()));
                        } else {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect socketVideo = null");
                        }
                    } else if (socket2 == null) {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.avspConnect video is NOT to be encrypted, connecting to " + string + " port=" + 8192));
                        objectArray = new Socket(string, n);
                    } else {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.avspConnect video is NOT to be encrypted, connecting to " + socket2.getInetAddress().getHostAddress() + " port=" + socket2.getPort()));
                        objectArray = socket2;
                    }
                    if (objectArray == null) {
                        return false;
                    }
                    objectArray.setTcpNoDelay(true);
                    objectArray.setReceiveBufferSize(32768);
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("Video Socket connected to: " + objectArray.getInetAddress().getHostAddress().toString() + " port=" + objectArray.getPort()));
                    BufferedOutputStream bufferedOutputStream2 = new BufferedOutputStream(objectArray.getOutputStream());
                    BufferedInputStream bufferedInputStream2 = new BufferedInputStream(objectArray.getInputStream());
                    this.m_dosApplianceVideo = new DataOutputStreamEndian(bufferedOutputStream2);
                    this.m_disApplianceVideo = new DataInputStreamEndian(bufferedInputStream2, (Socket)objectArray);
                    objectArray.setSoTimeout(30000);
                    if (DSConnect.dsConnectVideoAVSP(this.m_dosApplianceVideo, this.m_disApplianceVideo, this.m_avspStatus.getClientRandom(), this.m_avspStatus.getApplianceRandom())) {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect dsConnectVideoAVSP succeeded");
                        objectArray.setSoTimeout(0);
                        bl2 = true;
                        bl3 = false;
                        bl5 = false;
                        if (this.m_bUserCancelled) {
                            this.m_dosAppliance.close();
                            this.m_disAppliance.close();
                            this.m_disAppliance.getSocket().close();
                            this.m_dosApplianceVideo.close();
                            this.m_disApplianceVideo.close();
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) returning false the user cancelled after login succeeded");
                            return false;
                        }
                        break;
                    }
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect dsConnectVideoAVSP failed, closing all data streams");
                    this.m_dosAppliance.close();
                    this.m_disAppliance.close();
                    this.m_dosApplianceVideo.close();
                    this.m_disApplianceVideo.close();
                    continue;
                }
                Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect dsConnectApplianceAVSP failed, closing all data streams");
                this.m_dosAppliance.close();
                this.m_disAppliance.getSocket().close();
                this.m_disAppliance.close();
                if (this.m_bUserCancelled) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) returning false the login failed and the user cancelled");
                    return false;
                }
                if (!bl) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) returning false the login failed and bDisplayErrorMessage false");
                    return false;
                }
                switch (this.m_avspStatus.getLoginStatus()) {
                    case 1: 
                    case 2: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, INVALID USER NAME returned by appliance");
                        bl3 = false;
                        this.showUserCancelDialog(false);
                        Message.show((Component)this.m_fLoginDialogParent, (String)RES.getString("Nec_Invalid_UserName"));
                        objectArray = new JDialogLogin(this.m_fLoginDialogParent, RES.getString("Nec_Login"), this.m_userCredentials);
                        objectArray.setModal(true);
                        objectArray.setVisible(true);
                        if (objectArray.wasOkPressed()) {
                            bl4 = true;
                            this.showUserCancelDialog(true);
                            break;
                        }
                        this.closeUserCancelDialog();
                        bl3 = false;
                        break;
                    }
                    case 3: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL ACCESS DENIED returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        UserNotification.ServerNotAvailableForViewing(this.m_dsPath.getDisplayName(), RES.getString("Nec_Channel_Access_Denied"));
                        break;
                    }
                    case 4: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        UserNotification.ServerNotAvailableForViewingChannelInUse(this.m_dsPath.getDisplayName(), RES.getString("Nec_Channel_In_Use"), this.m_avspStatus.getUserName());
                        break;
                    }
                    case 5: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL NOT FOUND returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        UserNotification.ServerNotAvailableForViewing(this.m_dsPath.getDisplayName(), RES.getString("Nec_Channel_Not_Found"));
                        break;
                    }
                    case 6: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, SERVER NOT AVAILABLE, CAN PRE-EMPT returned by appliance");
                        this.showUserCancelDialog(false);
                        bl3 = UserNotification.ServerNotAvailableCanBePreempted(this.m_dsPath.getDisplayName(), RES.getString("Nec_Another_User"), bl6);
                        if (bl3) {
                            this.showUserCancelDialog(true);
                            break;
                        }
                        this.closeUserCancelDialog();
                        break;
                    }
                    case 7: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE BY LOCAL USER returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        UserNotification.ServerNotAvailableForViewing(this.m_dsPath.getDisplayName(), RES.getString("Nec_Channel_In_Use_By_Local_User"));
                        break;
                    }
                    case 12: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE BY EXCLUSIVE LOCAL USER returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        UserNotification.ServerNotAvailableForViewing(this.m_dsPath.getDisplayName(), RES.getString("Nec_Channel_In_Use_By_Exclusive_Local_User"));
                        break;
                    }
                    case 11: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE BY LOCAL USER, CAN PRE-EMPT returned by appliance");
                        this.showUserCancelDialog(false);
                        bl3 = UserNotification.ServerNotAvailableCanBePreempted(this.m_dsPath.getDisplayName(), RES.getString("Nec_Switch_Local_Port"), bl6);
                        if (bl3) {
                            this.showUserCancelDialog(true);
                            break;
                        }
                        this.closeUserCancelDialog();
                        break;
                    }
                    case 8: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, ALL CHANNELS IN USE returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        UserNotification.ServerNotAvailableForViewing(this.m_dsPath.getDisplayName(), RES.getString("Nec_All_Channels_In_Use"));
                        break;
                    }
                    case 9: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, INSUFFICIENT ACCESS RIGHTS returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        UserNotification.ServerNotAvailableForViewing(this.m_dsPath.getDisplayName(), RES.getString("Nec_Insufficient_Access_Rights"));
                        break;
                    }
                    case 22: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, Network Authentication Error returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        Message.show(null, (String)RES.getString("Nec_Login_Failure_Auth_Server"));
                        break;
                    }
                    case 23: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, Invalid or Expired Certificate Error returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        Message.show(null, (String)RES.getString("Nec_Login_Failure_Invalid_Expired_Cert_Auth_Server"));
                        break;
                    }
                    case 10: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, USER LOCKED OUT returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        UserNotification.ServerNotAvailableForViewing(this.m_dsPath.getDisplayName(), RES.getString("Nec_User_Locked_Out"));
                        break;
                    }
                    case 13: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL UPGRADE IN PROGRESS returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        UserNotification.ServerNotAvailableForViewing(this.m_dsPath.getDisplayName(), RES.getString("Nec_Channel_Upgrade_In_Progress"));
                        break;
                    }
                    case 14: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE BY EXCLUSIVE USER returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        UserNotification.ServerNotAvailableForViewing(this.m_dsPath.getDisplayName(), RES.getString("Nec_Channel_In_Use_By_Exclusive_User"));
                        break;
                    }
                    case 15: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, SHARE REQUEST DENIED returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        UserNotification.ServerNotAvailableForViewing(this.m_dsPath.getDisplayName(), RES.getString("Nec_Channel_Share_Request_Denied"));
                        break;
                    }
                    case 16: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, SHARE REQUEST TIMED OUT returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        UserNotification.ServerNotAvailableForViewing(this.m_dsPath.getDisplayName(), RES.getString("Nec_Channel_Share_Request_Timed_Out"));
                        break;
                    }
                    case 17: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, EXCLUSIVE REQUEST FAILED returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        UserNotification.ServerNotAvailableForViewing(this.m_dsPath.getDisplayName(), RES.getString("Nec_Channel_Exclusive_Request_Failed"));
                        break;
                    }
                    case 18: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE, or PEM BLOCKAGE returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        objectArray = new Object[]{BrandNaming.getServerName(false, true)};
                        String string2 = MessageFormat.format(RES.getString("Nec_Server_Not_Available_For_Viewing_Title"), objectArray);
                        objectArray = new Object[]{this.m_avspStatus.getUserName()};
                        string = MessageFormat.format(RES.getString("Nec_CHANNEL_IN_USE_BY"), objectArray);
                        objectArray = new Object[]{this.m_dsPath.getDisplayName(), string};
                        String string3 = MessageFormat.format(RES.getString("Nec_CHANNEL_IN_USE_WITH_REASON"), objectArray);
                        JOptionPane.showMessageDialog(null, string3, string2, 1);
                        break;
                    }
                    case 19: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PEM BLOCKAGE, CAN PRE-EMPT returned by appliance");
                        this.showUserCancelDialog(false);
                        objectArray = new Object[]{this.m_avspStatus.getUserName()};
                        String string4 = MessageFormat.format(RES.getString("Nec_CHANNEL_IN_USE_BY"), objectArray);
                        objectArray = new Object[]{this.m_dsPath.getDisplayName(), string4};
                        string = MessageFormat.format(RES.getString("Nec_CHANNEL_IN_USE_WITH_REASON_CAN_PREEMPT"), objectArray);
                        objectArray = new Object[]{BrandNaming.getServerName(bl6, true)};
                        String string5 = MessageFormat.format(RES.getString("Nec_Server_Not_Available_For_Viewing_Title"), objectArray);
                        int n4 = JOptionPaneFixedSize.showConfirmDialog(null, (Object)string, (String)string5, (int)0, (int)3);
                        boolean bl8 = bl3 = n4 == 0;
                        if (bl3) {
                            this.showUserCancelDialog(true);
                            break;
                        }
                        this.closeUserCancelDialog();
                        break;
                    }
                    case 20: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE BY LOCAL USER returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        objectArray = new Object[]{BrandNaming.getServerName(false, true)};
                        String string6 = MessageFormat.format(RES.getString("Nec_Server_Not_Available_For_Viewing_Title"), objectArray);
                        objectArray = new Object[]{this.m_dsPath.getDisplayName(), RES.getString("Nec_Channel_In_Use_By_Local_User")};
                        string = MessageFormat.format(RES.getString("Nec_CHANNEL_IN_USE_WITH_REASON"), objectArray);
                        JOptionPane.showMessageDialog(null, string, string6, 1);
                        break;
                    }
                    case 21: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PEM BLOCKAGE, CAN PRE-EMPT returned by appliance");
                        this.showUserCancelDialog(false);
                        objectArray = new Object[]{this.m_dsPath.getDisplayName(), RES.getString("Nec_Channel_In_Use_By_Local_User")};
                        String string7 = MessageFormat.format(RES.getString("Nec_CHANNEL_IN_USE_WITH_REASON_CAN_PREEMPT"), objectArray);
                        objectArray = new Object[]{BrandNaming.getServerName(bl6, true)};
                        string = MessageFormat.format(RES.getString("Nec_Server_Not_Available_For_Viewing_Title"), objectArray);
                        n = JOptionPaneFixedSize.showConfirmDialog(null, (Object)string7, (String)string, (int)0, (int)3);
                        boolean bl9 = bl3 = n == 0;
                        if (bl3) {
                            this.showUserCancelDialog(true);
                            break;
                        }
                        this.closeUserCancelDialog();
                        break;
                    }
                    case 50: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE BY LOCAL USER, CAN PRE-EMPT, TIMEOUT INFO returned by appliance");
                        this.m_bLocalUserUsingChannelWeArePreempting = true;
                        this.showUserCancelDialog(false);
                        bl3 = UserNotification.ServerNotAvailableCanBePreempted(this.m_dsPath.getDisplayName(), RES.getString("Nec_Switch_Local_Port"), bl6);
                        if (bl3) {
                            this.m_dlgElapsed = new JDialogWaitingForPreemption(null, RES.getString("Nec_Switch_Local_Port"), this.m_avspStatus.canOtherUserRejectPreemption(), this.m_avspStatus.getPreemptionTimeout());
                            this.showUserCancelDialog(true);
                            break;
                        }
                        this.closeUserCancelDialog();
                        break;
                    }
                    case 51: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, SERVER NOT AVAILABLE, CAN PRE-EMPT, TIMEOUT INFO returned by appliance");
                        this.m_bLocalUserUsingChannelWeArePreempting = false;
                        this.showUserCancelDialog(false);
                        bl3 = UserNotification.ServerNotAvailableCanBePreempted(this.m_dsPath.getDisplayName(), this.m_avspStatus.getUserName(), bl6);
                        if (bl3) {
                            this.m_dlgElapsed = new JDialogWaitingForPreemption(null, this.m_avspStatus.getUserName(), this.m_avspStatus.canOtherUserRejectPreemption(), this.m_avspStatus.getPreemptionTimeout());
                            this.showUserCancelDialog(true);
                            break;
                        }
                        this.closeUserCancelDialog();
                        break;
                    }
                    case 52: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PREEMPT REJECTED returned by appliance");
                        bl3 = false;
                        this.closeUserCancelDialog();
                        objectArray = this.m_bLocalUserUsingChannelWeArePreempting ? new Object[]{RES.getString("Nec_Switch_Local_Port_Cap"), this.m_dsPath.getDisplayName()} : new Object[]{this.m_avspStatus.getUserName(), this.m_dsPath.getDisplayName()};
                        String string8 = MessageFormat.format(RES.getString("Nec_PREEMPTION_REJECTED"), objectArray);
                        JOptionPane.showMessageDialog(null, string8, RES.getString("Nec_PREEMPTION_REJECTED_TITLE"), 1);
                        break;
                    }
                    case 53: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PEM BLOCKAGE BY LOCAL USER, CAN PRE-EMPT, TIMEOUT INFO returned by appliance");
                        this.m_bLocalUserUsingChannelWeArePreempting = true;
                        this.showUserCancelDialog(false);
                        objectArray = new Object[]{this.m_avspStatus.getUserName()};
                        String string9 = MessageFormat.format(RES.getString("Nec_CHANNEL_IN_USE_BY"), objectArray);
                        objectArray = new Object[]{this.m_dsPath.getDisplayName(), string9};
                        string = MessageFormat.format(RES.getString("Nec_CHANNEL_IN_USE_WITH_REASON_CAN_PREEMPT"), objectArray);
                        objectArray = new Object[]{BrandNaming.getServerName(bl6, true)};
                        String string10 = MessageFormat.format(RES.getString("Nec_Server_Not_Available_For_Viewing_Title"), objectArray);
                        int n5 = JOptionPaneFixedSize.showConfirmDialog(null, (Object)string, (String)string10, (int)0, (int)3);
                        boolean bl10 = bl3 = n5 == 0;
                        if (bl3) {
                            this.m_dlgElapsed = new JDialogWaitingForPreemption(null, RES.getString("Nec_Switch_Local_Port"), this.m_avspStatus.canOtherUserRejectPreemption(), this.m_avspStatus.getPreemptionTimeout());
                            this.showUserCancelDialog(true);
                            break;
                        }
                        this.closeUserCancelDialog();
                        break;
                    }
                    case 54: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PEM BLOCKAGE, CAN PRE-EMPT, TIMEOUT INFO returned by appliance");
                        this.m_bLocalUserUsingChannelWeArePreempting = false;
                        this.showUserCancelDialog(false);
                        objectArray = new Object[]{this.m_avspStatus.getUserName()};
                        String string11 = MessageFormat.format(RES.getString("Nec_CHANNEL_IN_USE_BY"), objectArray);
                        objectArray = new Object[]{this.m_dsPath.getDisplayName(), string11};
                        string = MessageFormat.format(RES.getString("Nec_CHANNEL_IN_USE_WITH_REASON_CAN_PREEMPT"), objectArray);
                        objectArray = new Object[]{BrandNaming.getServerName(bl6, true)};
                        String string12 = MessageFormat.format(RES.getString("Nec_Server_Not_Available_For_Viewing_Title"), objectArray);
                        int n6 = JOptionPaneFixedSize.showConfirmDialog(null, (Object)string, (String)string12, (int)0, (int)3);
                        boolean bl11 = bl3 = n6 == 0;
                        if (bl3) {
                            this.m_dlgElapsed = new JDialogWaitingForPreemption(null, this.m_avspStatus.getUserName(), this.m_avspStatus.canOtherUserRejectPreemption(), this.m_avspStatus.getPreemptionTimeout());
                            this.showUserCancelDialog(true);
                            break;
                        }
                        this.closeUserCancelDialog();
                        break;
                    }
                    case 60: {
                        break;
                    }
                    case 61: {
                        break;
                    }
                    case 62: {
                        break;
                    }
                    case 63: {
                        break;
                    }
                    case 64: {
                        break;
                    }
                    default: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer avspConnect) default returned by appliance avspStatus.getLoginStatus()=" + this.m_avspStatus.getLoginStatus()));
                        bl3 = false;
                        this.closeUserCancelDialog();
                        UserNotification.ServerNotAvailableForViewing(this.m_dsPath.getDisplayName(), RES.getString("Nec_Unknown_error"));
                    }
                }
                if (!bl3 && !bl4 && this.m_bUserCancelled || !this.m_dsPath.hasApcp()) continue;
                socket = Nec.doApcp(this.m_dsPath.getIPAddress(), false);
            } while (bl3 || bl4 || !this.m_bUserCancelled);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            Message.show(null, (String)RES.getString("Nec_Network_Connect_Error"));
            this.m_bUserCancelled = true;
        }
        return bl2;
    }

    private void closeUserCancelDialog() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer closeUserCancelDialog)");
        this.m_bUserCancelled = true;
        if (this.m_dlgElapsed != null) {
            this.m_dlgElapsed.setVisible(false);
            this.m_dlgElapsed.dispose();
        }
    }

    private void showUserCancelDialog(boolean bl) {
        this.m_bUserCancelled = false;
        this.m_dlgElapsed.setVisible(bl);
    }

    public static void launch(String[] stringArray, Frame frame) {
        if (!Trace.isTraceEnabled()) {
            Trace.startLogging(null);
        }
        try {
            new Nec(stringArray, frame);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"VideoViewer", (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
        }
        System.gc();
        if (m_bStartedFromCommandLine && !SessionManager.isAnySessionRunning()) {
            Trace.logInfo((String)"VideoViewer", (String)"Video Viewer was started from the command line, stopping logging");
            Trace.stopLogging();
            System.exit(0);
        } else {
            Trace.logInfo((String)"VideoViewer", (String)"Video Viewer not started from the command line, exiting main method");
        }
    }

    public void applianceSessionClosing() {
        this.closeUserCancelDialog();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            return;
        }
        Nec.launch(stringArray, null);
    }

    private class ThreadCheckForUserCancel
    extends Thread {
        public ThreadCheckForUserCancel(String string) {
            Object[] objectArray = new Object[]{string};
            String string2 = MessageFormat.format(RES.getString("Nec_ElapsedTime_Msg"), objectArray);
            Nec.this.m_dlgElapsed = new JDialogElapsedTime(null, RES.getString("Nec_ElapsedTime_Title"), string2);
            Nec.this.m_dlgElapsed.setEnableCancelButton(true);
            this.start();
        }

        public void run() {
            try {
                do {
                    try {
                        ThreadCheckForUserCancel.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (Nec.this.m_bUserCancelled) continue;
                    Nec.this.m_bUserCancelled = Nec.this.m_dlgElapsed.checkCancelButton();
                    if (!Nec.this.m_bUserCancelled) continue;
                    if (Nec.this.m_disAppliance != null) {
                        Nec.this.m_disAppliance.getSocket().close();
                    }
                    Nec.this.m_dlgElapsed.setEnableCancelButton(false);
                    Trace.logInfo((String)Nec.TRACE_CONTEXT, (String)"(videoViewer ThreadCheckForUserCancel) user cancelled from elapsed dialog");
                } while (Nec.this.m_dlgElapsed.isDisplayable() && !Nec.this.m_bUserCancelled && !Nec.this.m_bApplianceSessionRunning);
            }
            catch (Exception exception) {
                Trace.logError((String)Nec.TRACE_CONTEXT, (String)("Exception in ThreadCheckForUserCancel: " + exception.getMessage()));
            }
            Trace.logInfo((String)Nec.TRACE_CONTEXT, (String)("Leaving ThreadCheckForUserCancel m_bUserCancelled:" + Nec.this.m_bUserCancelled + " m_bApplianceSessionRunning:" + Nec.this.m_bApplianceSessionRunning));
        }
    }
}

