/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.video.DSData;

public abstract class Packet {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    protected static final int VSP_PACKET_HEADER_LENGTH = 8;
    protected static final int VSP_MIN_PACKET_LENGTH = 16;
    protected static final int VSP_PACKET_LENGTH_OFFSET = 6;
    protected static final int VSP_NUM_BYTES_PACKET_LENGTH = 2;
    private DSData m_dsData;
    private int m_nPacketHeaderLength;
    private int m_nMinimumPacketLength;
    private int m_nPacketLengthOffset;
    private int m_nNumBytesPacketLength;

    public Packet() {
        this.m_dsData = new DSData(8, 6);
        this.m_nPacketHeaderLength = 8;
        this.m_nMinimumPacketLength = 16;
        this.m_nPacketLengthOffset = 6;
        this.m_nNumBytesPacketLength = 2;
    }

    public Packet(int n, int n2, int n3, int n4) {
        this.m_dsData = new DSData(n, n3);
        this.m_nPacketHeaderLength = n;
        this.m_nMinimumPacketLength = n2;
        this.m_nPacketLengthOffset = n3;
        this.m_nNumBytesPacketLength = n4;
    }

    public Packet(DSData dSData, int n, int n2, int n3, int n4) {
        this.m_dsData = dSData;
        this.m_nPacketHeaderLength = n;
        this.m_nMinimumPacketLength = n2;
        this.m_nPacketLengthOffset = n3;
        this.m_nNumBytesPacketLength = n4;
    }

    public DSData getData() {
        return this.m_dsData;
    }

    public void setData(DSData dSData) {
        this.m_dsData = dSData;
    }

    public void setData(byte by, int n) {
        byte[] byArray = this.m_dsData.getData();
        byArray[n] = by;
    }

    protected void transferDataObject(Packet packet) {
        this.m_dsData = packet.m_dsData;
        packet.m_dsData = null;
    }

    public byte getData(int n) {
        byte[] byArray = this.m_dsData.getData();
        return byArray[n];
    }

    public void setDataAndType(DSData dSData, short s, short s2) {
        this.setData(dSData);
        this.setPacketRecognizablePattern();
        this.setPacketType(s);
        if (this.m_nNumBytesPacketLength == 4) {
            this.setPacketLength((int)s2);
        } else {
            this.setPacketLength(s2);
        }
    }

    protected void clearDataObject() {
        this.m_dsData = null;
    }

    public abstract void setPacketType(short var1);

    public void setPacketLength(short s) {
        byte[] byArray = this.m_dsData.getData();
        byArray[this.m_nPacketLengthOffset] = (byte)(s >> 8 & 0xFF);
        byArray[this.m_nPacketLengthOffset + 1] = (byte)(s & 0xFF);
        this.m_dsData.setUsedLength(s);
    }

    public void setPacketLength(int n) {
        byte[] byArray = this.m_dsData.getData();
        byArray[this.m_nPacketLengthOffset + 0] = (byte)(n >> 24 & 0xFF);
        byArray[this.m_nPacketLengthOffset + 1] = (byte)(n >> 16 & 0xFF);
        byArray[this.m_nPacketLengthOffset + 2] = (byte)(n >> 8 & 0xFF);
        byArray[this.m_nPacketLengthOffset + 3] = (byte)(n & 0xFF);
        this.m_dsData.setUsedLength(n);
    }

    public abstract void setPacketRecognizablePattern();

    protected short getPacketLength() {
        byte[] byArray = this.m_dsData.getData();
        if (this.m_nNumBytesPacketLength == 2) {
            return (short)(byArray[this.m_nPacketLengthOffset] << 8 & 0xFF00 | byArray[this.m_nPacketLengthOffset + 1] & 0xFF);
        }
        if (this.m_nNumBytesPacketLength == 4) {
            return (short)(byArray[this.m_nPacketLengthOffset + 2] << 8 & 0xFF00 | byArray[this.m_nPacketLengthOffset + 3] & 0xFF);
        }
        Trace.logError((String)TRACE_CONTEXT, (String)("getPacketLength Invalid number of bytes: " + this.m_nNumBytesPacketLength));
        return 0;
    }

    protected byte getHeaderLength() {
        return (byte)this.m_nPacketHeaderLength;
    }
}

