/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.video.DSData;
import com.avocent.video.PacketProtocolVSP;
import java.io.IOException;

class PacketProtocolAERP
extends PacketProtocolVSP {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    protected static final int AERP_PACKET_HEADER_LENGTH = 8;
    protected static final int AERP_MIN_PACKET_LENGTH = 8;
    protected static final int AERP_PACKET_LENGTH_OFFSET = 0;
    protected static final int AERP_NUM_BYTES_PACKET_LENGTH = 4;
    protected static final int PACKET_FLAG_OFFSET_AERP = 4;
    protected static final int PACKET_TYPE_OFFSET_AERP = 7;
    protected static final int PACKET_DATA_OFFSET_AERP = 8;
    protected static final int PACKET_VIDEO_DATA_OFFSET_MIN = 16;
    protected static final byte CMD_VIDEO_START_LAN = 0;
    protected static final byte CMD_VIDEO_START_DIAL = 1;
    protected static final byte VIDEO_DATA_1024X768 = 2;
    protected static final byte VIDEO_DATA_800X600 = 3;
    protected static final byte VIDEO_DATA_640X480 = 4;
    protected static final byte CMD_VIDEO_DATA_NAK = 5;
    protected static final byte VIDEO_DATA_LOST_SYNC = 6;
    protected static final byte CMD_VIDEO_PAUSE = 7;
    protected static final byte CMD_VIDEO_RESUME = 8;
    protected static final byte CMD_VIDEO_FRAME_COMPLETE = 35;
    protected static final byte CMD_RESEND_VIDEO_DATA = 36;
    protected static final byte CMD_SET_BIT_RATE = 10;
    protected static final byte CMD_USERNAME = 11;
    protected static final byte CMD_HEARTBEAT = 12;
    protected static final byte CMD_CLIENT_VERSION = 13;
    protected static final byte RESP_SERVER_VERSION = 13;
    protected static final byte CMD_IDLE_TIME_REQ = 16;
    protected static final byte CMD_IDLE_TIME_RESP = 16;
    protected static final byte EXCHANGE_CAPABILITIES = 33;
    protected static final byte INITIALIZE_ENCRYPTION = 34;
    protected static final byte MESSAGE_ACKNOWLEDGE = 37;
    protected static final byte CMD_DISCONNECT_SESSION = 38;
    protected static final byte MESSAGE_WRAPPER = 39;
    protected static final byte CMD_KEYBOARD_STATUS = 9;
    protected static final byte RESP_KEYBOARD_STATUS = 9;
    protected static final byte CMD_KEYBOARD_ACTION = 15;
    protected static final int KEY_PRESSED = 10;
    protected static final int KEY_RELEASED = 11;
    protected static final int STANDARD_KEY = 1;
    protected static final int LEFT_KEY = 2;
    protected static final int RIGHT_KEY = 3;
    protected static final int NUM_PAD_KEY = 4;
    protected static final byte CMD_MOUSE_ACTION = 14;
    protected static final byte MOUSE_MOVEMENT = 0;
    protected static final int MOUSE_PRESSED = 1;
    protected static final int MOUSE_RELEASED = 2;
    protected static final int MOUSE_ENTERED_FRAME = 3;
    protected static final int MOUSE_EXITED_FRAME = 4;
    protected static final int MOUSE_CALIBRATE = 5;
    protected static final int MOUSE_RESYNC = 6;
    protected static final int MOUSE_SCROLL_WHEEL = 7;
    protected static final byte MASK_TYPE_V1_CLEAR = -64;
    protected static final byte MASK_TYPE_V1 = 63;
    protected static final byte MASK_TYPE_V2 = -1;
    protected static final int MASK_BEG_OF_FRAME_V1 = 64;
    protected static final int MASK_END_OF_FRAME_V1 = 128;
    protected static final int MASK_BEG_OF_FRAME = 256;
    protected static final int MASK_END_OF_FRAME = 512;
    protected static final int MASK_VIDEO_ENCRYPTED = 1024;
    protected static final int MASK_SHORT_VIDEO_PACKET = 2048;
    protected static final int MASK_SEQ_NUMBER_RECV_ENABLE = 65536;
    protected static final int MASK_SEQ_NUMBER_SENT_ENABLE = 131072;
    protected static final int MASK_SEQ_NUMBER_RECV = 0x1C0000;
    protected static final int MASK_SEQ_NUMBER_SENT = 0xE00000;
    private static final int SCROLL_LOCK_STATE = 1;
    private static final int NUM_LOCK_STATE = 2;
    private static final int CAPS_LOCK_STATE = 4;
    private static final int RIGHT_MOUSE_BUTTON = 4;
    private static final int MIDDLE_MOUSE_BUTTON = 8;
    private static final int LEFT_MOUSE_BUTTON = 16;
    protected static final int VIDEO_ENCRYPTION_RC4 = 1;
    protected static final int VERSION_2_MESSAGES = 2;
    protected static final int VIDEO_HANDSHAKE = 4;
    protected static final int SHORT_VIDEO_PACKETS = 8;
    private static final int ALL_CAPABILITIES = 15;
    private static final int MAX_RECEIVE_SIZE = 32768;
    private boolean m_bIsV2Appliance;
    private short m_sXVideoResolution;
    private short m_sYVideoResolution;

    public PacketProtocolAERP(boolean bl) {
        super(8, 8, 0, 4);
        this.m_bIsV2Appliance = bl;
        this.m_sXVideoResolution = (short)-1;
        this.m_sYVideoResolution = (short)-1;
    }

    public PacketProtocolAERP(DSData dSData, boolean bl) {
        super(dSData, 8, 8, 0, 4);
        this.m_bIsV2Appliance = bl;
        this.m_sXVideoResolution = (short)-1;
        this.m_sYVideoResolution = (short)-1;
    }

    public byte getPacketType() {
        byte by = super.getData(7);
        if (!this.m_bIsV2Appliance) {
            by = (byte)(by & 0x3F);
        }
        return by;
    }

    public void setPacketType(short s) {
        byte by = super.getData(7);
        if (!this.m_bIsV2Appliance) {
            by = (byte)(by & 0xFFFFFFC0);
            byte by2 = (byte)(s & 0x3F);
            by = (byte)(by | by2);
        } else {
            by = (byte)(s & 0xFFFFFFFF);
        }
        super.setData(by, 7);
    }

    public void setPacketRecognizablePattern() {
    }

    public boolean isLEDStatusScrollLock() throws IOException {
        int n = this.getDataAsInt(8);
        return (n & 1) != 0;
    }

    public boolean isLEDStatusNumLock() throws IOException {
        int n = this.getDataAsInt(8);
        return (n & 2) != 0;
    }

    public boolean isLEDStatusCapsLock() throws IOException {
        int n = this.getDataAsInt(8);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(PacketProtocolAERP isLEDStatusCapsLock) Keyboard State=" + n));
        return (n & 4) != 0;
    }

    public boolean isStartOfFrame() throws IOException {
        boolean bl = false;
        try {
            int n = this.getDataAsInt(4);
            bl = !this.m_bIsV2Appliance ? (n & 0x40) != 0 : (n & 0x100) != 0;
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        return bl;
    }

    public boolean isEndOfFrame() throws IOException {
        boolean bl = false;
        try {
            int n = this.getDataAsInt(4);
            bl = !this.m_bIsV2Appliance ? (n & 0x80) != 0 : (n & 0x200) != 0;
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        return bl;
    }

    public boolean isFlagSet(int n) {
        boolean bl = false;
        try {
            int n2 = this.getDataAsInt(4);
            bl = (n2 & n) != 0;
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        return bl;
    }

    public void setFlag(int n) {
        boolean bl = false;
        try {
            int n2 = this.getDataAsInt(4);
            this.setDataAsInt(4, n2 |= n);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void setSeqNumSent(int n) {
        this.setFlag(131072);
        int n2 = n << 21;
        this.setFlag(n2);
    }

    public boolean isSeqNumSentSet() {
        return this.isFlagSet(131072);
    }

    public boolean isVideoPacket() {
        byte by = this.getPacketType();
        return (by & 2) != 0 || (by & 3) != 0 || (by & 4) != 0;
    }

    public void setSeqNumRecv(int n) {
        this.setFlag(65536);
        int n2 = n << 18;
        this.setFlag(n2);
    }

    public int getSeqNumRecv() {
        if (!this.isFlagSet(65536)) {
            return -1;
        }
        byte by = super.getData(5);
        int n = by >> 2 & 7;
        return n;
    }

    public int getSeqNumSent() {
        if (!this.isFlagSet(131072)) {
            return -1;
        }
        byte by = super.getData(5);
        int n = by >> 5 & 7;
        return n;
    }

    public int getDataAsInt(int n) throws IOException {
        byte by = super.getData(n);
        byte by2 = super.getData(n + 1);
        byte by3 = super.getData(n + 2);
        byte by4 = super.getData(n + 3);
        int n2 = by << 24 & 0xFF000000 | by2 << 16 & 0xFF0000 | by3 << 8 & 0xFF00 | by4 & 0xFF;
        return n2;
    }

    public void setDataAsInt(int n, int n2) throws IOException {
        super.setData((byte)(n2 >> 24 & 0xFF), n + 0);
        super.setData((byte)(n2 >> 16 & 0xFF), n + 1);
        super.setData((byte)(n2 >> 8 & 0xFF), n + 2);
        super.setData((byte)(n2 & 0xFF), n + 3);
    }

    public void setDataAsShort(int n, short s) throws IOException {
        super.setData((byte)(s >> 8 & 0xFF), n + 0);
        super.setData((byte)(s & 0xFF), n + 1);
    }

    public short getXResolution() {
        return this.m_sXVideoResolution;
    }

    public short getYResolution() {
        return this.m_sYVideoResolution;
    }

    public void setXResolution(short s) {
        this.m_sXVideoResolution = s;
    }

    public void setYResolution(short s) {
        this.m_sYVideoResolution = s;
    }

    public void setCmdMouseData(DSData dSData, short s, short s2, short s3) throws IOException {
        if (s != 0) {
            this.setDataAndType(dSData, (short)14, (short)16);
            this.setDataAsInt(8, 7);
            this.setDataAsInt(12, s);
        } else {
            this.setDataAndType(dSData, (short)14, (short)20);
            this.setDataAsInt(8, 0);
            this.setDataAsInt(12, s2);
            this.setDataAsInt(16, s3);
        }
    }

    public void setCmdMouseData(DSData dSData, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws IOException {
        int n = 0;
        int n2 = 2;
        this.setDataAndType(dSData, (short)14, (short)16);
        if (bl4 && !bl) {
            n2 = 2;
            n |= 0x10;
        }
        if (bl) {
            n2 = 1;
            n |= 0x10;
        }
        if (bl5 && !bl2) {
            n2 = 2;
            n |= 8;
        } else if (bl2) {
            n2 = 1;
            n |= 8;
        }
        if (bl6 && !bl3) {
            n2 = 2;
            n |= 4;
        } else if (bl3) {
            n2 = 1;
            n |= 4;
        }
        this.setDataAsInt(8, n2);
        this.setDataAsInt(12, n);
    }

    public void setCmdMouseFocus(DSData dSData, boolean bl, int n, int n2) throws IOException {
        if (bl) {
            this.setDataAndType(dSData, (short)14, (short)20);
            this.setDataAsInt(8, 3);
            this.setDataAsInt(12, n);
            this.setDataAsInt(16, n2);
        } else {
            this.setDataAndType(dSData, (short)14, (short)12);
            this.setDataAsInt(8, 4);
        }
    }

    public void setKeyboardPressedCommand(DSData dSData, int n, int n2) {
        try {
            this.setDataAndType(dSData, (short)15, (short)20);
            this.setDataAsInt(8, 10);
            this.setDataAsInt(12, n);
            this.setDataAsInt(16, n2);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void setKeyboardReleasedCommand(DSData dSData, int n, int n2) {
        try {
            this.setDataAndType(dSData, (short)15, (short)20);
            this.setDataAsInt(8, 11);
            this.setDataAsInt(12, n);
            this.setDataAsInt(16, n2);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void getServerCapabilities(DSData dSData, boolean bl, boolean bl2) throws IOException {
        this.setDataAndType(dSData, (short)33, (short)16);
        int n = this.getDataAsInt(8);
        if (bl) {
            n |= 4;
        }
        if (bl2) {
            n |= 1;
        }
        n |= 8;
        this.setDataAsInt(8, n |= 2);
        this.setDataAsInt(12, 32768);
    }

    public void setInitEncryptKey(DSData dSData, byte[] byArray) throws IOException {
        this.setDataAndType(dSData, (short)34, (short)(12 + byArray.length));
        this.setDataAsInt(8, byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            super.setData(byArray[i], 12 + i);
        }
    }

    public void setCombinedCommand(DSData dSData, int n) throws IOException {
        this.setDataAndType(dSData, (short)39, (short)n);
    }

    public void setResendVideoData(DSData dSData, int n, int n2) throws IOException {
        this.setDataAndType(dSData, (short)36, (short)(12 + 2 * n2));
        this.setDataAsInt(8, n);
    }

    public void setResendVideoSeqNum(DSData dSData, int n, int n2) throws IOException {
        this.setDataAsShort(12 + 2 * n2, (short)n);
    }

    public boolean isCapabilitySet(int n) {
        boolean bl = false;
        try {
            int n2 = this.getDataAsInt(8);
            bl = (n2 & n) != 0;
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        return bl;
    }

    public int getMaxReceiveSizeCapability() {
        int n = 0;
        boolean bl = false;
        try {
            n = this.getDataAsInt(12);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        return n;
    }

    public int getPixelStartOffset() throws IOException {
        return this.getDataAsInt(12);
    }

    public int getPixelCount() throws IOException {
        return this.getDataAsInt(16);
    }

    public int getFrameNumber() throws IOException {
        byte by = super.getData(8);
        byte by2 = super.getData(9);
        int n = by << 8 & 0xFF00 | by2 & 0xFF;
        return n;
    }

    public int getSequenceNumber() throws IOException {
        byte by = super.getData(10);
        byte by2 = super.getData(11);
        int n = by << 8 & 0xFF00 | by2 & 0xFF;
        return n;
    }

    public int getEncryptionSeqCtr() throws IOException {
        int n = 24;
        if (this.isFlagSet(2048)) {
            n -= 8;
        }
        return this.getDataAsInt(n);
    }
}

