/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.DSData;
import com.avocent.video.PacketProtocolVSP;
import java.io.IOException;
import java.util.Properties;

class PacketProtocolAVSP
extends PacketProtocolVSP {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    public static final String CNAME = "PacketProtocolAVSP";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private static final int PACKET_TYPE_OFFSET_AVSP = 4;
    protected static final short RESPONSE_VIDEOCONTROL_INPUTRESOLUTION = -32256;
    protected static final short RESPONSE_VIDEOCONTROL_DISPLAYRESOLUTION = -32255;
    protected static final short RESPONSE_VIDEOCONTROL_VIDEOSETUP = -32254;
    protected static final short RESPONSE_VIDEOCONTROL_ENABLESCALING = -32253;
    protected static final short RESPONSE_VIDEOCONTROL_COLORDEPTH = -32252;
    protected static final short RESPONSE_VIDEOCONTROL_DISPLAYRESOLUTION_NOT_ATTAINED = -32251;
    protected static final short RESPONSE_VIDEOCONTROL_INPUTRESOLUTION_WITH_VIDEO_MODE = -32250;
    protected static final short RESPONSE_VIDEOCONTROL_VIDEO_TEMPORARY_STOP = -32249;
    protected static final byte CMD_VIDEO_AVC = -128;
    protected static final byte CMD_VIDEO_DVC15 = -127;
    protected static final byte CMD_VIDEO_DVC7 = -126;
    protected static final byte CMD_VIDEO_TEMPORARY_STOP = -123;
    protected static final short CMD_VIDEOCONTROL_REQUESTSETUPDATA = 768;
    protected static final short CMD_VIDEOCONTROL_FULLSCREENREFRESH = 769;
    private static final short CMD_VIDEOCONTROL_SETDISPLAYAREA = 770;
    protected static final short CMD_VIDEOCONTROL_GETINPUTRESOLUTION = 771;
    protected static final short CMD_VIDEOCONTROL_FULLSCALEMODE = 772;
    protected static final short CMD_VIDEOCONTROL_SETNOISETHRESHOLD = 773;
    protected static final short CMD_VIDEOCONTROL_AUTOADJUST = 774;
    protected static final short CMD_VIDEOCONTROL_TESTPATTERN = 775;
    protected static final short CMD_VIDEOCONTROL_WIDTHADJUST = 776;
    protected static final short CMD_VIDEOCONTROL_FINEADJUST = 777;
    protected static final short CMD_VIDEOCONTROL_VERTICALPOSITION = 778;
    protected static final short CMD_VIDEOCONTROL_HORIZONTALPOSITION = 779;
    protected static final short CMD_VIDEOCONTROL_BRIGHTNESS = 780;
    protected static final short CMD_VIDEOCONTROL_CONTRAST = 781;
    protected static final short CMD_VIDEOCONTROL_VIDEOENABLE = 782;
    protected static final short CMD_VIDEOCONTROL_SETPRIORITYTHRESHOLD = 783;
    private static final short CMD_VIDEOCONTROL_VIDEOPARAMETERS = 784;
    private static final byte CMD_VIDEO_CONFIRM = 0;
    protected static final short RESPONSE_USERDISCONNECT_PENDING = -31999;
    protected static final short RESPONSE_PROTOCOL_VERSION = -31998;
    protected static final short RESPONSE_USERDISCONNECT_PENDING_WITH_TIMEOUT = -31997;
    protected static final short RESPONSE_USER_CANCEL_DISCONNECT_PENDING = -31996;
    protected static final short RESPONSE_USER_SHARE_REQUEST = -31744;
    protected static final short RESPONSE_USER_SHARE_REQUEST_WITH_USERNAME = -31743;
    protected static final short RESPONSE_SHARED_USER_RESPONSE = -31728;
    protected static final short RESPONSE_EXCLUSIVE_MODE = -31727;
    protected static final short RESPONSE_LOCKED = -31726;
    protected static final short RESPONSE_RESERVE = -31725;
    protected static final short RESPONSE_VM_AVAILABLE = -31724;
    protected static final short RESPONSE_USER_PRIVILEGE_PARAMETERS = -31712;
    protected static final short CMD_SESSIONCONTROL_HEARTBEAT = 1024;
    protected static final short CMD_SESSIONCONTROL_VIDEOTRANSMITLIMIT = 1026;
    protected static final short CMD_SESSIONCONTROL_COLORDEPTH = 1027;
    protected static final short CMD_USER_SHARE_REQUEST = 1040;
    protected static final short CMD_GET_SHARED_USERS_REQUEST = 1041;
    protected static final short CMD_SESSIONCONTROL_PREEMPTIONREJECTIONRESPONSE = 1042;
    protected static final short CMD_USER_SHARE_REQUEST_WITH_ID = 1043;
    protected static final short CMD_EXCLUSIVE_MODE = 1044;
    protected static final short RESPONSE_KEYBOARD_LEDSTATUS = -32512;
    private static final short CMD_KEYBOARD = 512;
    protected static final short RESPONSE_MOUSE_ACKNOWLEDGE = -32511;
    protected static final short RESPONSE_SESSION_MOUSE_ACC = -32510;
    protected static final short CMD_MOUSE_DATA = 513;
    protected static final short CMD_MOUSE_ORIGIN = 514;
    protected static final short CMD_MOUSE_RESET = 515;
    protected static final short CMD_MOUSE_KEYBOARDLEDSTATUS = 516;
    protected static final short CMD_MOUSE_ADJUST = 517;
    protected static final short CMD_MOUSE_ENABLE = 518;
    protected static final short CMD_MOUSE_SCANCODESET = 519;
    protected static final short CMD_MOUSE_FOCUSCONTROL = 520;
    protected static final short CMD_MOUSE_DATA_RELATIVE = 521;
    protected static final short CMD_MOUSE_ACCELERATION = 522;
    protected static final byte MOUSE_ACC_NONE = 0;
    protected static final byte MOUSE_ACC_WINDOWS = 1;
    protected static final byte MOUSE_ACC_LINUX = 2;
    protected static final byte MOUSE_ACC_NETWARE = 3;
    private static final byte MOUSE_LEFT_DOWN = 1;
    private static final byte MOUSE_RIGHT_DOWN = 2;
    private static final byte MOUSE_MIDDLE_DOWN = 4;
    private static final byte MOUSE_4_DOWN = 8;
    private static final byte MOUSE_5_DOWN = 16;
    public static final byte USER_PRIVILEGE_VIRTUAL_MEDIA_LAUNCH_AVAILABLE = 1;
    public static final byte USER_PRIVILEGE_RESERVE_MODE_AVAILABLE = 2;
    public static final byte USER_PRIVILEGE_EXCLUSIVE_MODE_AVAILABLE = 3;
    public static final byte USER_PRIVILEGE_ENCRYPT_VIRTUAL_MEDIA = 4;

    public PacketProtocolAVSP() {
    }

    public PacketProtocolAVSP(DSData dSData) {
        super(dSData, 8, 16, 6, 2);
    }

    public short getPacketType() {
        byte by = super.getData(4);
        byte by2 = super.getData(5);
        return (short)(by << 8 & 0xFF00 | by2 & 0xFF);
    }

    public void setPacketType(short s) {
        byte by = (byte)(s >> 8 & 0xFF);
        byte by2 = (byte)(s & 0xFF);
        super.setData(by, 4);
        super.setData(by2, 5);
    }

    public void setPacketRecognizablePattern() {
        super.setData((byte)66, 0);
        super.setData((byte)69, 1);
        super.setData((byte)69, 2);
        super.setData((byte)70, 3);
    }

    public void setKeyboardData(DSData dSData) throws IOException {
        this.setDataAndType(dSData, (short)512, (short)16);
    }

    public boolean setKeyboardCommand(boolean bl, int n) {
        boolean bl2 = false;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("setKeyboardCommand nUSBKeyCode: " + n + " bKeyMake:" + bl));
        if (n != 0) {
            super.setData((byte)1, 8);
            super.setData(bl ? (byte)0 : 1, 9);
            super.setData((byte)(n >> 8 & 0xFF), 10);
            super.setData((byte)(n & 0xFF), 11);
            bl2 = true;
        }
        if (!bl2) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(setKeyboardCommand) unknown keyboard character:" + n));
        }
        return bl2;
    }

    public void setCmdMouseData(DSData dSData, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, short s, short s2, short s3) throws IOException {
        this.setDataAndType(dSData, (short)513, (short)16);
        byte by = 0;
        if (bl) {
            by = (byte)(by | 1);
        }
        if (bl2) {
            by = (byte)(by | 4);
        }
        if (bl3) {
            by = (byte)(by | 2);
        }
        if (bl4) {
            by = (byte)(by | 8);
        }
        if (bl5) {
            by = (byte)(by | 0x10);
        }
        super.setData((byte)0, 8);
        super.setData(by, 9);
        super.setData((byte)(s2 >> 8 & 0xFF), 10);
        super.setData((byte)(s2 & 0xFF), 11);
        super.setData((byte)(s3 >> 8 & 0xFF), 12);
        super.setData((byte)(s3 & 0xFF), 13);
        super.setData((byte)(s >> 8 & 0xFF), 14);
        super.setData((byte)(s & 0xFF), 15);
    }

    public void setCmdMouseDataRelative(DSData dSData, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, short s, short s2, short s3) throws IOException {
        this.setDataAndType(dSData, (short)521, (short)16);
        byte by = 0;
        if (bl) {
            by = (byte)(by | 1);
        }
        if (bl2) {
            by = (byte)(by | 4);
        }
        if (bl3) {
            by = (byte)(by | 2);
        }
        if (bl4) {
            by = (byte)(by | 8);
        }
        if (bl5) {
            by = (byte)(by | 0x10);
        }
        super.setData((byte)0, 8);
        super.setData(by, 9);
        super.setData((byte)(s2 >> 8 & 0xFF), 10);
        super.setData((byte)(s2 & 0xFF), 11);
        super.setData((byte)(s3 >> 8 & 0xFF), 12);
        super.setData((byte)(s3 & 0xFF), 13);
        super.setData((byte)(s >> 8 & 0xFF), 14);
        super.setData((byte)(s & 0xFF), 15);
    }

    public void setCmdVideoParameters(DSData dSData, short s, short s2, short s3, boolean bl, short s4, short s5, short s6, short s7, short s8, short s9, short s10, short s11, byte by, boolean bl2) throws IOException {
        this.setDataAndType(dSData, (short)784, (short)36);
        super.setData((byte)(s >> 8 & 0xFF), 8);
        super.setData((byte)(s & 0xFF), 9);
        super.setData((byte)(s2 >> 8 & 0xFF), 10);
        super.setData((byte)(s2 & 0xFF), 11);
        super.setData((byte)(s3 >> 8 & 0xFF), 12);
        super.setData((byte)(s3 & 0xFF), 13);
        super.setData((byte)(s4 >> 8 & 0xFF), 14);
        super.setData((byte)(s4 & 0xFF), 15);
        super.setData((byte)(s5 >> 8 & 0xFF), 16);
        super.setData((byte)(s5 & 0xFF), 17);
        super.setData((byte)(s6 >> 8 & 0xFF), 18);
        super.setData((byte)(s6 & 0xFF), 19);
        super.setData((byte)(s7 >> 8 & 0xFF), 20);
        super.setData((byte)(s7 & 0xFF), 21);
        super.setData((byte)(s8 >> 8 & 0xFF), 22);
        super.setData((byte)(s8 & 0xFF), 23);
        super.setData((byte)(s9 >> 8 & 0xFF), 24);
        super.setData((byte)(s9 & 0xFF), 25);
        super.setData((byte)(s10 >> 8 & 0xFF), 26);
        super.setData((byte)(s10 & 0xFF), 27);
        super.setData((byte)(s11 >> 8 & 0xFF), 28);
        super.setData((byte)(s11 & 0xFF), 29);
        super.setData(by, 30);
        super.setData(bl2 ? (byte)1 : 0, 31);
        super.setData(bl ? (byte)1 : 0, 32);
    }

    public void setCmdSetDisplayArea(DSData dSData, short s, short s2) throws IOException {
        this.setDataAndType(dSData, (short)770, (short)16);
        super.setData((byte)(s >> 8 & 0xFF), 8);
        super.setData((byte)(s & 0xFF), 9);
        super.setData((byte)(s2 >> 8 & 0xFF), 10);
        super.setData((byte)(s2 & 0xFF), 11);
    }

    public void setCmdVideoControl(DSData dSData, short s, short s2) throws IOException {
        this.setDataAndType(dSData, s, (short)16);
        super.setData((byte)(s2 >> 8 & 0xFF), 8);
        super.setData((byte)(s2 & 0xFF), 9);
    }

    public void setCmdSetColorDepth(DSData dSData, byte by, byte by2, byte by3) throws IOException {
        this.setDataAndType(dSData, (short)1027, (short)16);
        super.setData((byte)0, 8);
        super.setData(by, 9);
        super.setData(by2, 10);
        super.setData(by3, 11);
    }

    public boolean isLEDStatusScrollLock() throws IOException {
        return (super.getData(8) & 1) != 0;
    }

    public boolean isLEDStatusNumLock() throws IOException {
        return (super.getData(8) & 2) != 0;
    }

    public boolean isLEDStatusCapsLock() throws IOException {
        return (super.getData(8) & 4) != 0;
    }

    public boolean isLEDStatusKanaLock() throws IOException {
        return (super.getData(8) & 8) != 0;
    }

    public int getAckCount() throws IOException {
        return super.getData(8);
    }

    public int getAccSetting() throws IOException {
        return super.getData(8);
    }

    public short getXResolution() throws IOException {
        byte by = super.getData(8);
        byte by2 = super.getData(9);
        return (short)(by << 8 & 0xFF00 | by2 & 0xFF);
    }

    public short getYResolution() throws IOException {
        byte by = super.getData(10);
        byte by2 = super.getData(11);
        return (short)(by << 8 & 0xFF00 | by2 & 0xFF);
    }

    public short getVideoMode() throws IOException {
        byte by = super.getData(12);
        byte by2 = super.getData(13);
        return (short)(by << 8 & 0xFF00 | by2 & 0xFF);
    }

    public short getBrightness() throws IOException {
        byte by = super.getData(8);
        byte by2 = super.getData(9);
        return (short)(by << 8 & 0xFF00 | by2 & 0xFF);
    }

    public short getContrast() throws IOException {
        byte by = super.getData(10);
        byte by2 = super.getData(11);
        return (short)(by << 8 & 0xFF00 | by2 & 0xFF);
    }

    public short getHorizontalPosition() throws IOException {
        byte by = super.getData(12);
        byte by2 = super.getData(13);
        return (short)(by << 8 & 0xFF00 | by2 & 0xFF);
    }

    public short getVerticalPosition() throws IOException {
        byte by = super.getData(14);
        byte by2 = super.getData(15);
        return (short)(by << 8 & 0xFF0 | by2 & 0xFF);
    }

    public short getWidth() throws IOException {
        byte by = super.getData(16);
        byte by2 = super.getData(17);
        return (short)(by << 8 & 0xFF00 | by2 & 0xFF);
    }

    public short getFine() throws IOException {
        byte by = super.getData(18);
        byte by2 = super.getData(19);
        return (short)(by << 8 & 0xFF00 | by2 & 0xFF);
    }

    public short getHorizontalResolution() throws IOException {
        byte by = super.getData(20);
        byte by2 = super.getData(21);
        return (short)(by << 8 & 0xFF00 | by2 & 0xFF);
    }

    public short getVerticalResolution() throws IOException {
        byte by = super.getData(22);
        byte by2 = super.getData(23);
        return (short)(by << 8 & 0xFF00 | by2 & 0xFF);
    }

    public short getNoiseThreshold() throws IOException {
        byte by = super.getData(24);
        byte by2 = super.getData(25);
        return (short)(by << 8 & 0xFF00 | by2 & 0xFF);
    }

    public short getPriorityThreshold() throws IOException {
        byte by = super.getData(26);
        byte by2 = super.getData(27);
        return (short)(by << 8 & 0xFF00 | by2 & 0xFF);
    }

    public int getColorDepth() throws IOException {
        byte by = super.getData(8);
        byte by2 = super.getData(9);
        int n = 0;
        n = by2 == 0 ? 3 : (int)by;
        return n;
    }

    public boolean getBackgroundRefresh() throws IOException {
        return super.getData(10) == 1;
    }

    public byte getDisconnectStatus() throws IOException {
        return super.getData(9);
    }

    public short getShareRequestId() throws IOException {
        byte by = super.getData(8);
        byte by2 = super.getData(9);
        return (short)(by << 8 & 0xFF00 | by2 & 0xFF);
    }

    public byte getShareRequestTimeout() throws IOException {
        return super.getData(10);
    }

    public String getShareRequestUsername() throws IOException {
        byte[] byArray = super.getData().getData();
        int n = 0;
        for (n = 11; n < 64 && byArray[n] != 0; ++n) {
        }
        String string = new String(byArray, 11, n - 8 - 3);
        return string;
    }

    public byte getCancelReason() throws IOException {
        return super.getData(8);
    }

    public byte getDisconnectTimeout() throws IOException {
        return super.getData(10);
    }

    public byte getProtocolMajorVersion() {
        return super.getData(8);
    }

    public byte getProtocolMinorVersion() {
        return super.getData(9);
    }

    public void setCmdVideoConfirm(DSData dSData, byte by) throws IOException {
        super.setData(dSData);
        super.setPacketLength((short)16);
        super.setData((byte)0, 5);
        super.setData(by, 8);
    }

    public void setCmdPreemptionRejectionResponse(DSData dSData) throws IOException {
        this.setDataAndType(dSData, (short)1042, (short)16);
    }

    public byte getPacketTypeVideo() {
        return super.getData(5);
    }

    public byte getLockedStatus() {
        return super.getData(8);
    }

    public byte getReserveStatus() {
        return super.getData(8);
    }

    public byte getVmAvailableStatus() {
        return super.getData(8);
    }

    public boolean canUserRejectPreemption() throws IOException {
        return (super.getData(9) & 0xFFFFFF80) != 0;
    }

    public boolean isLocalUserPreempting() throws IOException {
        return (super.getData(9) & 0x20) != 0;
    }

    public int getPreemptionTimeout() throws IOException {
        return super.getData(10) & 0xFF;
    }

    public String getUserRequestingPreemption() throws IOException {
        String string;
        int n = this.getDisconnectReason();
        if (n == 0 || n == 5 && !this.isLocalUserPreempting()) {
            byte[] byArray = super.getData().getData();
            byte by = byArray[11];
            string = new String(byArray, 12, (int)by);
        } else {
            string = RES.getString("PacketProtocolAVSP_LOCAL_USER");
        }
        return string;
    }

    public boolean isExclusiveModeActive() throws IOException {
        return (super.getData(8) & 0xFF) == 1;
    }

    public Properties getUserPrivilegeProperties() throws IOException {
        int n = super.getData(8);
        Properties properties = new Properties();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            byte by = super.getData(8 + n2++);
            byte by2 = super.getData(8 + n2++);
            switch (by) {
                case 1: 
                case 2: 
                case 3: {
                    Boolean bl = new Boolean(super.getData(8 + n2) != 0);
                    properties.put(new String("" + by), bl);
                    n2 += by2;
                }
            }
        }
        return properties;
    }

    private int getDisconnectReason() throws IOException {
        return super.getData(8);
    }

    public void dumpPacketHeader() {
        Trace.logError((String)TRACE_CONTEXT, (String)("(PacketProtocolAVSP dumpPacketHeader) Packet data: [" + Integer.toHexString(super.getData(0)) + "] [" + Integer.toHexString(super.getData(1)) + "] [" + Integer.toHexString(super.getData(2)) + "] [" + Integer.toHexString(super.getData(3)) + "] [" + Integer.toHexString(super.getData(4)) + "] [" + Integer.toHexString(super.getData(5)) + "] [" + Integer.toHexString(super.getData(6)) + "] [" + Integer.toHexString(super.getData(7)) + "] [" + Integer.toHexString(super.getData(8)) + "] [" + Integer.toHexString(super.getData(9)) + "] [" + Integer.toHexString(super.getData(10)) + "] [" + Integer.toHexString(super.getData(11)) + "] [" + Integer.toHexString(super.getData(12)) + "] [" + Integer.toHexString(super.getData(13)) + "] [" + Integer.toHexString(super.getData(14)) + "] [" + Integer.toHexString(super.getData(15)) + "]"));
    }
}

