/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.video.DSData;
import com.avocent.video.Packet;
import java.io.IOException;

public abstract class PacketProtocolVSP
extends Packet {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    private int m_nPacketHeaderLength;
    private int m_nMinimumPacketLength;

    public PacketProtocolVSP() {
        super(8, 16, 6, 2);
        this.m_nPacketHeaderLength = 8;
        this.m_nMinimumPacketLength = 16;
    }

    public PacketProtocolVSP(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.m_nPacketHeaderLength = n;
        this.m_nMinimumPacketLength = n2;
    }

    public PacketProtocolVSP(DSData dSData, int n, int n2, int n3, int n4) {
        super(dSData, n, n2, n3, n4);
        this.m_nPacketHeaderLength = n;
        this.m_nMinimumPacketLength = n2;
    }

    public abstract short getXResolution() throws IOException;

    public abstract short getYResolution() throws IOException;

    public boolean isVideoResolutionSane(int n, int n2) throws IOException {
        boolean bl = false;
        if (this.getYResolution() >= 0 && this.getYResolution() <= n2 && this.getXResolution() >= 0 && this.getXResolution() <= n) {
            bl = true;
        }
        return bl;
    }

    public boolean isMaxDisplayResponseSane(int n, int n2) throws IOException {
        boolean bl = false;
        if (this.getYResolution() >= 0 && this.getYResolution() <= n2 && this.getXResolution() >= 0 && this.getXResolution() <= n) {
            bl = true;
        }
        return bl;
    }

    public void setCommand(DSData dSData, short s) {
        this.setDataAndType(dSData, s, (short)this.m_nMinimumPacketLength);
    }

    public void setCommand(DSData dSData, short s, byte by) {
        this.setDataAndType(dSData, s, (short)this.m_nMinimumPacketLength);
        byte[] byArray = dSData.getData();
        byArray[this.m_nPacketHeaderLength] = by;
    }

    public void setCommand(DSData dSData, short s, byte by, byte by2) {
        this.setDataAndType(dSData, s, (short)this.m_nMinimumPacketLength);
        byte[] byArray = dSData.getData();
        byArray[this.m_nPacketHeaderLength] = by;
        byArray[this.m_nPacketHeaderLength + 1] = by2;
    }

    public void setCommand(DSData dSData, short s, byte by, byte by2, byte by3) {
        this.setDataAndType(dSData, s, (short)this.m_nMinimumPacketLength);
        byte[] byArray = dSData.getData();
        byArray[this.m_nPacketHeaderLength] = by;
        byArray[this.m_nPacketHeaderLength + 1] = by2;
        byArray[this.m_nPacketHeaderLength + 2] = by3;
    }

    public void setCommand(DSData dSData, short s, byte by, byte by2, byte by3, byte by4) {
        this.setDataAndType(dSData, s, (short)this.m_nMinimumPacketLength);
        byte[] byArray = dSData.getData();
        byArray[this.m_nPacketHeaderLength] = by;
        byArray[this.m_nPacketHeaderLength + 1] = by2;
        byArray[this.m_nPacketHeaderLength + 2] = by3;
        byArray[this.m_nPacketHeaderLength + 3] = by4;
    }

    public void setCommand(DSData dSData, short s, byte by, byte by2, short s2) {
        this.setDataAndType(dSData, s, (short)this.m_nMinimumPacketLength);
        byte[] byArray = dSData.getData();
        byArray[this.m_nPacketHeaderLength] = by;
        byArray[this.m_nPacketHeaderLength + 1] = by2;
        byArray[this.m_nPacketHeaderLength + 2] = (byte)(s2 >> 8 & 0xFF);
        byArray[this.m_nPacketHeaderLength + 3] = (byte)(s2 & 0xFF);
    }

    public void setCommand(DSData dSData, short s, int n) {
        this.setDataAndType(dSData, s, (short)(this.m_nMinimumPacketLength + 4));
        byte[] byArray = dSData.getData();
        byArray[this.m_nPacketHeaderLength + 0] = (byte)(n >> 24 & 0xFF);
        byArray[this.m_nPacketHeaderLength + 1] = (byte)(n >> 16 & 0xFF);
        byArray[this.m_nPacketHeaderLength + 2] = (byte)(n >> 8 & 0xFF);
        byArray[this.m_nPacketHeaderLength + 3] = (byte)(n & 0xFF);
    }

    public boolean getEnableScaling() throws IOException {
        byte by = this.getData(this.m_nPacketHeaderLength);
        return by != 0;
    }

    public byte getReason() {
        return this.getData(this.m_nPacketHeaderLength);
    }

    public byte getNumberOfUsers() {
        return this.getData(this.m_nPacketHeaderLength);
    }

    public String[] getUsers(int n) {
        int n2 = this.getNumberOfUsers();
        byte[] byArray = this.getData().getData();
        String[] stringArray = new String[n2];
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            byte by = byArray[this.m_nPacketHeaderLength + n3++];
            stringArray[i] = n == 1 ? new String(byArray, this.m_nPacketHeaderLength + n3, (int)by) : new String(byArray, this.m_nPacketHeaderLength + n3, by - 1);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("PacketProtocolVSP getUsers user cnt=" + i + " nUserNameLen=" + by + " aszUsers[nCnt]=" + stringArray[i]));
            n3 += by;
        }
        return stringArray;
    }
}

