/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.video.DSData;
import com.avocent.video.JPanelAppliance;
import com.avocent.video.Packet;
import java.awt.image.WritableRaster;
import java.util.Arrays;

class PacketVideoAVC
extends Packet {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    private short m_sPacketType;
    private int m_nPacketHeaderLength;
    private int[] m_anPB = new int[0];
    private short[] m_asPB = new short[0];
    private byte[] m_abPB = new byte[0];
    private JPanelAppliance m_panelRender;
    Object[] m_aoColorLUT;
    WritableRaster m_raster;
    int m_nImageType;

    public PacketVideoAVC(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.m_nPacketHeaderLength = n;
    }

    public PacketVideoAVC(DSData dSData, int n, int n2, int n3, int n4) {
        super(dSData, n, n2, n3, n4);
        this.m_nPacketHeaderLength = n;
    }

    public void setRenderPanel(JPanelAppliance jPanelAppliance) {
        this.m_panelRender = jPanelAppliance;
    }

    public void setPacketType(short s) {
        this.m_sPacketType = s;
    }

    public void setPacketRecognizablePattern() {
    }

    public short getYLocation() {
        byte by = super.getData(this.m_nPacketHeaderLength + 8);
        byte by2 = super.getData(this.m_nPacketHeaderLength + 9);
        int n = by2 & 0xFF;
        int n2 = by << 8 & 0xFF00;
        return (short)(n2 | n);
    }

    public short getXLocation() {
        byte by = super.getData(this.m_nPacketHeaderLength + 10);
        byte by2 = super.getData(this.m_nPacketHeaderLength + 11);
        int n = by2 & 0xFF;
        int n2 = by << 8 & 0xFF00;
        return (short)(n2 | n);
    }

    public void decodePixels(byte[] byArray) {
        byte[] byArray2 = super.getData().getData();
        short s = this.getXLocation();
        short s2 = this.getYLocation();
        int n = this.m_nPacketHeaderLength + 12;
        int n2 = 0;
        for (int i = 0; i < 16; ++i) {
            int n3;
            for (int j = 0; j < 64; j += n3) {
                int n4;
                byte by;
                int n5;
                if ((n5 = (int)((by = byArray2[n++]) & 0x1F)) == 0) {
                    n5 = 32;
                }
                if ((n4 = 64 - j) < (n3 = n5 * 2)) {
                    n3 = n4;
                }
                if ((by & 0x80) != 0) {
                    byte by2 = byArray2[n++];
                    byte by3 = byArray2[n++];
                    Arrays.fill(byArray, n2, n2 + n3, by3);
                    if (by3 != by2) {
                        int n6 = n2;
                        for (int k = 0; k < n3; k += 2) {
                            byArray[n6] = by2;
                            n6 += 2;
                        }
                    }
                } else {
                    System.arraycopy(byArray2, n, byArray, n2, n3);
                    n += n3;
                }
                n2 += n3;
            }
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, byte[] byArray) {
        switch (this.m_nImageType) {
            case 13: {
                if (this.m_abPB.length < byArray.length) {
                    this.m_abPB = new byte[byArray.length];
                }
                try {
                    boolean bl = false;
                    for (int i = 0; i < byArray.length; ++i) {
                        this.m_abPB[i] = ((byte[])this.m_aoColorLUT[byArray[i] & 0xFF])[0];
                    }
                    this.m_raster.setDataElements(n, n2, n3, n4, this.m_abPB);
                }
                catch (NullPointerException nullPointerException) {}
                break;
            }
            case 5: {
                if (this.m_abPB.length < byArray.length * 3) {
                    this.m_abPB = new byte[byArray.length * 3];
                }
                try {
                    int n5 = 0;
                    boolean bl = false;
                    for (int i = 0; i < byArray.length / 3; ++i) {
                        this.m_abPB[n5++] = ((byte[])this.m_aoColorLUT[byArray[i] & 0xFF])[0];
                        this.m_abPB[n5++] = ((byte[])this.m_aoColorLUT[byArray[i] & 0xFF])[1];
                        this.m_abPB[n5++] = ((byte[])this.m_aoColorLUT[byArray[i] & 0xFF])[2];
                    }
                    this.m_raster.setDataElements(n, n2, n3, n4, this.m_abPB);
                }
                catch (NullPointerException nullPointerException) {}
                break;
            }
            case 8: 
            case 9: {
                if (this.m_asPB.length < byArray.length) {
                    this.m_asPB = new short[byArray.length];
                }
                try {
                    boolean bl = false;
                    for (int i = 0; i < byArray.length; ++i) {
                        this.m_asPB[i] = ((short[])this.m_aoColorLUT[byArray[i] & 0xFF])[0];
                    }
                    this.m_raster.setDataElements(n, n2, n3, n4, this.m_asPB);
                }
                catch (NullPointerException nullPointerException) {}
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.m_anPB.length < byArray.length) {
                    this.m_anPB = null;
                    this.m_anPB = new int[byArray.length];
                }
                try {
                    boolean bl = false;
                    for (int i = 0; i < byArray.length; ++i) {
                        this.m_anPB[i] = ((int[])this.m_aoColorLUT[byArray[i] & 0xFF])[0];
                    }
                    this.m_raster.setDataElements(n, n2, n3, n4, this.m_anPB);
                    break;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public void initPixelArray(int n, int n2) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(PacketVideoAVC initPixelArray) nWidth=" + n));
        switch (n2) {
            case 13: {
                if (this.m_abPB.length >= n) break;
                this.m_abPB = null;
                this.m_abPB = new byte[n];
                break;
            }
            case 5: {
                if (this.m_abPB.length >= n * 3) break;
                this.m_abPB = null;
                this.m_abPB = new byte[n * 3];
                break;
            }
            case 8: 
            case 9: {
                if (this.m_asPB.length >= n) break;
                this.m_asPB = null;
                this.m_asPB = new short[n];
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.m_anPB.length >= n) break;
                this.m_anPB = null;
                this.m_anPB = new int[n];
            }
        }
    }

    public void videoConfigChanged(JPanelAppliance jPanelAppliance) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"PacketVideoAVC.videoConfigChanged");
        this.m_panelRender = jPanelAppliance;
        this.m_aoColorLUT = this.m_panelRender.getColorLUT();
        this.m_raster = this.m_panelRender.getRaster();
        this.m_nImageType = this.m_panelRender.getImageType();
        this.initPixelArray(jPanelAppliance.getBitmapWidth(), this.m_nImageType);
    }
}

