/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.video.DvcCommand;
import com.avocent.video.DvcCommand15;
import com.avocent.video.DvcCommand7;
import com.avocent.video.JPanelAppliance;
import com.avocent.video.Packet;
import java.awt.image.WritableRaster;
import java.util.Arrays;

class PacketVideoDVC
extends Packet {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    protected static final int PACKET_VIDEO_TYPE_DVC7 = 1;
    protected static final int PACKET_VIDEO_TYPE_DVC15 = 2;
    private short m_sPacketType;
    private int m_nPacketHeaderLength;
    private int m_nPacketLengthOffset;
    private int m_nNumBytesPacketLength;
    private int m_nVideoType;
    private int m_nFrameFlagOffset;
    private int m_nVideoDataBlockOffset;
    private int m_nCmdOffset;
    private int m_nCmdPending = 0;
    private int m_nValuePending = 0;
    private int m_nCmdByteCnt = 0;
    protected int m_nPBLastDvc7Pixel = 0;
    protected int m_nPBPrevDvc7Pixel = 0;
    private short m_sPBLastDvc7Pixel = 0;
    private short m_sPBPrevDvc7Pixel = 0;
    private byte m_bPBLastDvc7Pixel = 0;
    private byte m_bPBPrevDvc7Pixel = 0;
    protected byte[] m_abPBLastDvc7Pixel = new byte[3];
    protected byte[] m_abPBPrevDvc7Pixel = new byte[3];
    protected int m_nDvcCurrentPixel;
    private int[] m_anPB = new int[0];
    private short[] m_asPB = new short[0];
    private byte[] m_abPB = new byte[0];
    protected JPanelAppliance m_panelRender;
    protected int m_nBitmapWidth;
    protected int m_nBitmapHeight;
    private WritableRaster m_raster;
    private int m_nImageType;
    private byte[] m_ab15BitTo8BitLUT;

    public PacketVideoDVC(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.m_nPacketHeaderLength = n;
        this.m_nPacketLengthOffset = n3;
        this.m_nNumBytesPacketLength = n4;
        this.m_nVideoType = 2;
        this.m_nFrameFlagOffset = this.m_nPacketHeaderLength + 8;
        this.m_nVideoDataBlockOffset = this.m_nPacketHeaderLength + 12;
    }

    public void setRenderPanel(JPanelAppliance jPanelAppliance) {
        this.m_panelRender = jPanelAppliance;
    }

    public void setPacketType(short s) {
        this.m_sPacketType = s;
    }

    public void setVideoDataOffset(int n) {
        this.m_nVideoDataBlockOffset = n;
    }

    public int getDvcCurrentPixel() {
        return this.m_nDvcCurrentPixel;
    }

    public void setDvcCurrentPixel(int n) {
        this.m_nDvcCurrentPixel = n;
    }

    public void setPacketRecognizablePattern() {
    }

    public void setPacketVideoType(int n) {
        this.m_nVideoType = n;
    }

    public short getVideoYResolution() {
        byte by = super.getData(this.m_nPacketHeaderLength + 4);
        byte by2 = super.getData(this.m_nPacketHeaderLength + 5);
        int n = by2 & 0xFF;
        int n2 = by << 8 & 0xFF00;
        return (short)(n2 | n);
    }

    public short getVideoXResolution() {
        byte by = super.getData(this.m_nPacketHeaderLength + 6);
        byte by2 = super.getData(this.m_nPacketHeaderLength + 7);
        int n = by2 & 0xFF;
        int n2 = by << 8 & 0xFF00;
        return (short)(n2 | n);
    }

    public void checkDVCStartOfFrame() {
        if (this.isStartOfFrame()) {
            this.setDVCStartOfFrameParameters();
        } else {
            this.setCommandOffset(this.m_nVideoDataBlockOffset);
        }
    }

    public void setDVCStartOfFrameParameters() {
        this.setCommandOffset(this.m_nVideoDataBlockOffset);
        this.m_nCmdPending = 0;
        this.m_nValuePending = 0;
        this.m_nCmdByteCnt = 0;
    }

    public int getCommandOffset() {
        return this.m_nCmdOffset;
    }

    public void setCommandOffset(int n) {
        this.m_nCmdOffset = n;
    }

    public boolean isStartOfFrame() {
        byte by = super.getData(this.m_nFrameFlagOffset);
        boolean bl = (by & 1) != 0;
        return bl;
    }

    public boolean isEndOfFrame() {
        byte by = super.getData(this.m_nFrameFlagOffset);
        boolean bl = (by & 2) != 0;
        return bl;
    }

    public DvcCommand getNextCommand(DvcCommand15 dvcCommand15, boolean bl) throws ExceptionRequestFailed {
        if (this.m_nCmdOffset >= super.getData().getUsedLength()) {
            dvcCommand15.clear();
            return dvcCommand15;
        }
        byte[] byArray = super.getData().getData();
        switch (this.m_nCmdPending) {
            case 1: {
                this.m_nValuePending <<= 8;
                this.m_nValuePending |= byArray[this.m_nCmdOffset++] & 0xFF;
                dvcCommand15.setCommandAndPixel(1, (short)(this.m_nValuePending & Short.MAX_VALUE));
                this.m_nValuePending = 0;
                this.m_nCmdByteCnt = 0;
                this.m_nCmdPending = 0;
                return dvcCommand15;
            }
            case 5: {
                this.getCommandRepeating(byArray, dvcCommand15, this.m_nCmdPending, (byte)64, bl);
                return dvcCommand15;
            }
            case 4: {
                this.getCommandRepeating(byArray, dvcCommand15, this.m_nCmdPending, (byte)32, bl);
                return dvcCommand15;
            }
            case 3: {
                this.getCommandRepeating(byArray, dvcCommand15, this.m_nCmdPending, (byte)0, bl);
                return dvcCommand15;
            }
            case 2: {
                this.getMSCommand(byArray, dvcCommand15);
                throw new ExceptionRequestFailed();
            }
        }
        if ((byArray[this.m_nCmdOffset] & 0x80) != 0) {
            this.m_nValuePending = byArray[this.m_nCmdOffset++] & 0x7F;
            if (this.m_nCmdOffset < super.getData().getUsedLength()) {
                this.m_nValuePending <<= 8;
                this.m_nValuePending |= byArray[this.m_nCmdOffset++] & 0xFF;
                dvcCommand15.setCommandAndPixel(1, (short)(this.m_nValuePending & Short.MAX_VALUE));
                this.m_nValuePending = 0;
                this.m_nCmdByteCnt = 0;
                this.m_nCmdPending = 0;
                return dvcCommand15;
            }
            this.m_nCmdPending = 1;
            dvcCommand15.setCommand(0);
            return dvcCommand15;
        }
        switch (byArray[this.m_nCmdOffset] & 0xE0) {
            case 0: {
                this.getCommandRepeating(byArray, dvcCommand15, 3, (byte)0, bl);
                break;
            }
            case 32: {
                this.getCommandRepeating(byArray, dvcCommand15, 4, (byte)32, bl);
                break;
            }
            case 64: {
                this.getCommandRepeating(byArray, dvcCommand15, 5, (byte)64, bl);
                break;
            }
            case 96: {
                this.getMSCommand(byArray, dvcCommand15);
                break;
            }
            default: {
                Trace.logError((String)TRACE_CONTEXT, (String)"UNKNOWN DVC COMMAND!!!");
            }
        }
        return dvcCommand15;
    }

    public DvcCommand getNextCommand(DvcCommand7 dvcCommand7, boolean bl) throws ExceptionRequestFailed {
        if (this.m_nCmdOffset >= super.getData().getUsedLength()) {
            dvcCommand7.clear();
            return dvcCommand7;
        }
        byte[] byArray = super.getData().getData();
        switch (this.m_nCmdPending) {
            case 1: {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(PacketVideoDVC getNextCommand Pending MP command -  SHOULD NOT HAPPEN)");
                return dvcCommand7;
            }
            case 5: {
                this.getCommandRepeating(byArray, dvcCommand7, this.m_nCmdPending, (byte)64, bl);
                return dvcCommand7;
            }
            case 4: {
                this.getCommandRepeating(byArray, dvcCommand7, this.m_nCmdPending, (byte)32, bl);
                return dvcCommand7;
            }
            case 3: {
                this.getCommandRepeating(byArray, dvcCommand7, this.m_nCmdPending, (byte)0, bl);
                return dvcCommand7;
            }
            case 2: {
                this.getMSCommand(byArray, dvcCommand7);
                return dvcCommand7;
            }
        }
        if ((byArray[this.m_nCmdOffset] & 0x80) != 0) {
            byte by = (byte)(byArray[this.m_nCmdOffset++] & 0x7F);
            dvcCommand7.setCommandAndPixel(1, by);
            this.m_nValuePending = 0;
            this.m_nCmdByteCnt = 0;
            this.m_nCmdPending = 0;
            return dvcCommand7;
        }
        switch (byArray[this.m_nCmdOffset] & 0xE0) {
            case 0: {
                this.getCommandRepeating(byArray, dvcCommand7, 3, (byte)0, bl);
                break;
            }
            case 32: {
                this.getCommandRepeating(byArray, dvcCommand7, 4, (byte)32, bl);
                break;
            }
            case 64: {
                this.getCommandRepeating(byArray, dvcCommand7, 5, (byte)64, bl);
                break;
            }
            case 96: {
                this.getMSCommand(byArray, dvcCommand7);
                break;
            }
            default: {
                Trace.logError((String)TRACE_CONTEXT, (String)"UNKNOWN DVC COMMAND!!!");
            }
        }
        return dvcCommand7;
    }

    public void setDvcMPData(DvcCommand dvcCommand) {
        int n = this.m_nDvcCurrentPixel % this.m_nBitmapWidth;
        int n2 = this.m_nDvcCurrentPixel / this.m_nBitmapWidth;
        switch (this.m_nImageType) {
            case 13: {
                this.m_abPB[0] = this.m_ab15BitTo8BitLUT[dvcCommand.getPixel()];
                this.m_raster.setDataElements(n, n2, 1, 1, this.m_abPB);
                break;
            }
            case 5: {
                short s = dvcCommand.getPixel();
                this.m_abPB[0] = (byte)((s & 0x7C00) >> 7);
                this.m_abPB[1] = (byte)((s & 0x3E0) >> 2);
                this.m_abPB[2] = (byte)((s & 0x1F) << 3);
                this.m_raster.setDataElements(n, n2, 1, 1, this.m_abPB);
                break;
            }
            case 8: {
                int n3 = dvcCommand.getPixel();
                int n4 = (n3 & 0x7C00) << 1;
                int n5 = (n3 & 0x3E0) << 1;
                int n6 = n3 & 0x1F;
                n3 = n4 | n5 | n6;
                this.m_asPB[0] = (short)n3;
                this.m_raster.setDataElements(n, n2, 1, 1, this.m_asPB);
                break;
            }
            case 9: {
                int n7 = dvcCommand.getPixel();
                int n8 = n7 & 0x7C00;
                int n9 = n7 & 0x3E0;
                int n10 = n7 & 0x1F;
                n7 = n8 | n9 | n10;
                this.m_asPB[0] = (short)n7;
                this.m_raster.setDataElements(n, n2, 1, 1, this.m_asPB);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                int n11 = dvcCommand.getPixel();
                int n12 = (n11 & 0x7C00) << 9;
                int n13 = (n11 & 0x3E0) << 6;
                int n14 = (n11 & 0x1F) << 3;
                this.m_anPB[0] = n11 = n12 | n13 | n14;
                this.m_raster.setDataElements(n, n2, 1, 1, this.m_anPB);
            }
        }
        ++this.m_nDvcCurrentPixel;
        this.m_panelRender.updateDirtyRegion(n, n2, n + 1, n2 + 1);
    }

    public int setDvcCAData(DvcCommand dvcCommand, int n, int n2) {
        int n3 = dvcCommand.getRepeatCount();
        int n4 = 0;
        if (n3 + n >= this.m_nBitmapWidth) {
            n3 = this.m_nBitmapWidth - n;
            n4 = dvcCommand.getRepeatCount() - n3;
        }
        switch (this.m_nImageType) {
            case 5: 
            case 13: {
                this.m_raster.getDataElements(n, n2 - 1, n3, 1, this.m_abPB);
                this.m_raster.setDataElements(n, n2, n3, 1, this.m_abPB);
                break;
            }
            case 8: 
            case 9: {
                this.m_raster.getDataElements(n, n2 - 1, n3, 1, this.m_asPB);
                this.m_raster.setDataElements(n, n2, n3, 1, this.m_asPB);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.m_raster.getDataElements(n, n2 - 1, n3, 1, this.m_anPB);
                this.m_raster.setDataElements(n, n2, n3, 1, this.m_anPB);
            }
        }
        this.m_panelRender.updateDirtyRegion(n, n2, n + n3, n2 + 1);
        return n4;
    }

    public int setDvcCADataNext(int n, int n2, int n3) {
        int n4 = n3 > this.m_nBitmapWidth ? this.m_nBitmapWidth : n3;
        switch (this.m_nImageType) {
            case 5: 
            case 13: {
                this.m_raster.getDataElements(n, n2 - 1, n4, 1, this.m_abPB);
                this.m_raster.setDataElements(n, n2, n4, 1, this.m_abPB);
                break;
            }
            case 8: 
            case 9: {
                this.m_raster.getDataElements(n, n2 - 1, n4, 1, this.m_asPB);
                this.m_raster.setDataElements(n, n2, n4, 1, this.m_asPB);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.m_raster.getDataElements(n, n2 - 1, n4, 1, this.m_anPB);
                this.m_raster.setDataElements(n, n2, n4, 1, this.m_anPB);
            }
        }
        this.m_panelRender.updateDirtyRegion(n, n2, n + n4, n2 + 1);
        return n3 -= this.m_nBitmapWidth;
    }

    public int setDvcCLData(DvcCommand dvcCommand, int n, int n2) {
        int n3 = dvcCommand.getRepeatCount();
        int n4 = 0;
        if (n3 + n >= this.m_nBitmapWidth) {
            n3 = this.m_nBitmapWidth - n;
            n4 = dvcCommand.getRepeatCount() - n3;
        }
        switch (this.m_nImageType) {
            case 13: {
                if (n > 0) {
                    this.m_raster.getDataElements(n - 1, n2, 1, 1, this.m_abPB);
                } else {
                    this.m_raster.getDataElements(this.m_nBitmapWidth - 1, n2 - 1, 1, 1, this.m_abPB);
                }
                Arrays.fill(this.m_abPB, 1, n3, this.m_abPB[0]);
                this.m_raster.setDataElements(n, n2, n3, 1, this.m_abPB);
                break;
            }
            case 5: {
                if (n > 0) {
                    this.m_raster.getDataElements(n - 1, n2, 1, 1, this.m_abPB);
                } else {
                    this.m_raster.getDataElements(this.m_nBitmapWidth - 1, n2 - 1, 1, 1, this.m_abPB);
                }
                for (int i = 3; i < n3 * 3; i += 3) {
                    this.m_abPB[i] = this.m_abPB[0];
                    this.m_abPB[i + 1] = this.m_abPB[1];
                    this.m_abPB[i + 2] = this.m_abPB[2];
                }
                this.m_raster.setDataElements(n, n2, n3, 1, this.m_abPB);
                break;
            }
            case 8: 
            case 9: {
                if (n > 0) {
                    this.m_raster.getDataElements(n - 1, n2, 1, 1, this.m_asPB);
                } else {
                    this.m_raster.getDataElements(this.m_nBitmapWidth - 1, n2 - 1, 1, 1, this.m_asPB);
                }
                Arrays.fill(this.m_asPB, 1, n3, this.m_asPB[0]);
                this.m_raster.setDataElements(n, n2, n3, 1, this.m_asPB);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (n > 0) {
                    this.m_raster.getDataElements(n - 1, n2, 1, 1, this.m_anPB);
                } else {
                    this.m_raster.getDataElements(this.m_nBitmapWidth - 1, n2 - 1, 1, 1, this.m_anPB);
                }
                Arrays.fill(this.m_anPB, 1, n3, this.m_anPB[0]);
                this.m_raster.setDataElements(n, n2, n3, 1, this.m_anPB);
            }
        }
        this.m_panelRender.updateDirtyRegion(n, n2, n + n3, n2 + 1);
        return n4;
    }

    public int setDvcCLDataNext(int n, int n2, int n3) {
        int n4 = n3 > this.m_nBitmapWidth ? this.m_nBitmapWidth : n3;
        switch (this.m_nImageType) {
            case 13: {
                Arrays.fill(this.m_abPB, 1, n4, this.m_abPB[0]);
                this.m_raster.setDataElements(n, n2, n4, 1, this.m_abPB);
                break;
            }
            case 5: {
                for (int i = 3; i < n4 * 3; i += 3) {
                    this.m_abPB[i] = this.m_abPB[0];
                    this.m_abPB[i + 1] = this.m_abPB[1];
                    this.m_abPB[i + 2] = this.m_abPB[2];
                }
                this.m_raster.setDataElements(n, n2, n4, 1, this.m_abPB);
                break;
            }
            case 8: 
            case 9: {
                Arrays.fill(this.m_asPB, 1, n4, this.m_asPB[0]);
                this.m_raster.setDataElements(n, n2, n4, 1, this.m_asPB);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Arrays.fill(this.m_anPB, 1, n4, this.m_anPB[0]);
                this.m_raster.setDataElements(n, n2, n4, 1, this.m_anPB);
            }
        }
        this.m_panelRender.updateDirtyRegion(n, n2, n + n4, n2 + 1);
        return n3 -= this.m_nBitmapWidth;
    }

    public void setDvcMSData(DvcCommand dvcCommand) {
        short s;
        int n;
        int n2;
        int n3;
        int n4 = this.m_nDvcCurrentPixel % this.m_nBitmapWidth;
        int n5 = this.m_nDvcCurrentPixel / this.m_nBitmapWidth;
        if (n4 >= this.m_nBitmapWidth || n5 >= this.m_nBitmapHeight) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)(" (PacketVideoDVC setDvcMSData) EXCEEDED BOUNDARIES Number MS Bits=" + dvcCommand.getNumMSBits() + " BitmapWidth= " + this.m_nBitmapWidth + " X= " + n4 + " Y=" + n5 + " Image Type=" + this.m_nImageType + " Current Pixel=" + this.m_nDvcCurrentPixel));
            return;
        }
        if (dvcCommand.getNumMSBits() == 4) {
            this.m_nPBLastDvc7Pixel = 0;
            this.m_nPBPrevDvc7Pixel = 0;
            this.m_sPBLastDvc7Pixel = 0;
            this.m_sPBPrevDvc7Pixel = 0;
            this.m_bPBLastDvc7Pixel = 0;
            this.m_bPBPrevDvc7Pixel = 0;
            for (n3 = 0; n3 < 3; ++n3) {
                this.m_abPBLastDvc7Pixel[n3] = 0;
                this.m_abPBPrevDvc7Pixel[n3] = 0;
            }
            n3 = 0;
            if (n4 > 0) {
                n2 = n4 - 1;
                n = n5;
            } else {
                n2 = this.m_nBitmapWidth - 1;
                n = n5 - 1;
            }
            switch (this.m_nImageType) {
                case 13: {
                    this.m_raster.getDataElements(n2, n, 1, 1, this.m_abPB);
                    this.m_bPBLastDvc7Pixel = this.m_abPB[0];
                    while (n3 == 0) {
                        if (n2 > 0) {
                            --n2;
                        } else {
                            n2 = this.m_nBitmapWidth - 1;
                            --n;
                        }
                        this.m_raster.getDataElements(n2, n, 1, 1, this.m_abPB);
                        if (this.m_abPB[0] == this.m_bPBLastDvc7Pixel) continue;
                        n3 = 1;
                        this.m_bPBPrevDvc7Pixel = this.m_abPB[0];
                    }
                    break;
                }
                case 5: {
                    this.m_raster.getDataElements(n2, n, 1, 1, this.m_abPB);
                    this.m_abPBLastDvc7Pixel[0] = this.m_abPB[0];
                    this.m_abPBLastDvc7Pixel[1] = this.m_abPB[1];
                    this.m_abPBLastDvc7Pixel[2] = this.m_abPB[2];
                    while (n3 == 0) {
                        if (n2 > 0) {
                            --n2;
                        } else {
                            n2 = this.m_nBitmapWidth - 1;
                            --n;
                        }
                        this.m_raster.getDataElements(n2, n, 1, 1, this.m_abPB);
                        if (this.m_abPB[0] == this.m_abPBLastDvc7Pixel[0] && this.m_abPB[1] == this.m_abPBLastDvc7Pixel[1] && this.m_abPB[2] == this.m_abPBLastDvc7Pixel[2]) continue;
                        n3 = 1;
                        this.m_abPBPrevDvc7Pixel[0] = this.m_abPB[0];
                        this.m_abPBPrevDvc7Pixel[1] = this.m_abPB[1];
                        this.m_abPBPrevDvc7Pixel[2] = this.m_abPB[2];
                    }
                    break;
                }
                case 8: 
                case 9: {
                    this.m_raster.getDataElements(n2, n, 1, 1, this.m_asPB);
                    this.m_sPBLastDvc7Pixel = this.m_asPB[0];
                    while (n3 == 0) {
                        if (n2 > 0) {
                            --n2;
                        } else {
                            n2 = this.m_nBitmapWidth - 1;
                            --n;
                        }
                        this.m_raster.getDataElements(n2, n, 1, 1, this.m_asPB);
                        if (this.m_asPB[0] == this.m_sPBLastDvc7Pixel) continue;
                        n3 = 1;
                        this.m_sPBPrevDvc7Pixel = this.m_asPB[0];
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.m_raster.getDataElements(n2, n, 1, 1, this.m_anPB);
                    this.m_nPBLastDvc7Pixel = this.m_anPB[0];
                    while (n3 == 0) {
                        if (n2 > 0) {
                            --n2;
                        } else {
                            n2 = this.m_nBitmapWidth - 1;
                            --n;
                        }
                        this.m_raster.getDataElements(n2, n, 1, 1, this.m_anPB);
                        if (this.m_anPB[0] == this.m_nPBLastDvc7Pixel) continue;
                        n3 = 1;
                        this.m_nPBPrevDvc7Pixel = this.m_anPB[0];
                    }
                    break;
                }
            }
            if (this.m_sPBPrevDvc7Pixel == 0) {
                s = 1;
            }
        }
        n3 = 0;
        s = 0;
        byte by = 0;
        byte[] byArray = new byte[3];
        n2 = n4;
        n = n5;
        for (int i = 0; i < dvcCommand.getNumMSBits(); ++i) {
            if (dvcCommand.isLastColorPixel(i)) {
                n3 = this.m_nPBLastDvc7Pixel;
                s = this.m_sPBLastDvc7Pixel;
                by = this.m_bPBLastDvc7Pixel;
                byArray = this.m_abPBLastDvc7Pixel;
            } else {
                n3 = this.m_nPBPrevDvc7Pixel;
                s = this.m_sPBPrevDvc7Pixel;
                by = this.m_bPBPrevDvc7Pixel;
                byArray = this.m_abPBPrevDvc7Pixel;
            }
            switch (this.m_nImageType) {
                case 13: {
                    this.m_abPB[0] = by;
                    this.m_raster.setDataElements(n2, n, 1, 1, this.m_abPB);
                    break;
                }
                case 5: {
                    this.m_abPB[0] = byArray[0];
                    this.m_abPB[1] = byArray[1];
                    this.m_abPB[2] = byArray[2];
                    this.m_raster.setDataElements(n2, n, 1, 1, this.m_abPB);
                    break;
                }
                case 8: 
                case 9: {
                    this.m_asPB[0] = s;
                    this.m_raster.setDataElements(n2, n, 1, 1, this.m_asPB);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.m_anPB[0] = n3;
                    this.m_raster.setDataElements(n2, n, 1, 1, this.m_anPB);
                }
            }
            ++this.m_nDvcCurrentPixel;
            n2 = this.m_nDvcCurrentPixel % this.m_nBitmapWidth;
            n = this.m_nDvcCurrentPixel / this.m_nBitmapWidth;
            if (this.m_nDvcCurrentPixel < this.m_nBitmapWidth * this.m_nBitmapHeight) continue;
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(PacketVideoDVC setDvcMSData) Invalid MS Request CurrentPixel= " + this.m_nDvcCurrentPixel + " Width= " + this.m_nBitmapWidth + " Height=" + this.m_nBitmapHeight + " Command pixel count=" + i));
            break;
        }
        if (n2 < n4) {
            this.m_panelRender.updateDirtyRegion(0, n5, this.m_nBitmapWidth - 1, n5 + 1);
        } else {
            this.m_panelRender.updateDirtyRegion(n4, n5, n2, n5 + 1);
        }
    }

    private boolean getCommandRepeating(byte[] byArray, DvcCommand dvcCommand, int n, byte by, boolean bl) {
        while (this.m_nCmdOffset < super.getData().getUsedLength() && this.m_nCmdByteCnt < 5 && (byArray[this.m_nCmdOffset] & 0xE0) == by) {
            this.m_nValuePending |= (byArray[this.m_nCmdOffset] & 0x1F) << this.m_nCmdByteCnt * 5;
            ++this.m_nCmdByteCnt;
            ++this.m_nCmdOffset;
        }
        if (this.m_nCmdOffset < super.getData().getUsedLength() || bl) {
            dvcCommand.setCommandAndRepeatCount(n, this.m_nValuePending);
            this.m_nValuePending = 0;
            this.m_nCmdByteCnt = 0;
            this.m_nCmdPending = 0;
            return true;
        }
        this.m_nCmdPending = n;
        dvcCommand.setCommand(0);
        return false;
    }

    private boolean getMSCommand(byte[] byArray, DvcCommand15 dvcCommand15) {
        Trace.logError((String)TRACE_CONTEXT, (String)"DVC MS COMMAND NOT YET IMPLEMENTED!!!");
        return false;
    }

    private boolean getMSCommand(byte[] byArray, DvcCommand7 dvcCommand7) {
        dvcCommand7.setCommand(2);
        if (this.m_nCmdPending != 2) {
            dvcCommand7.setMSPixel(0, (byArray[this.m_nCmdOffset] & 8) == 0);
            dvcCommand7.setMSPixel(1, (byArray[this.m_nCmdOffset] & 4) == 0);
            dvcCommand7.setMSPixel(2, (byArray[this.m_nCmdOffset] & 2) == 0);
            dvcCommand7.setMSPixel(3, (byArray[this.m_nCmdOffset] & 1) == 0);
            dvcCommand7.setNumMSBits(4);
            if ((byArray[this.m_nCmdOffset] & 0x10) != 0) {
                this.m_nCmdPending = 2;
            }
        } else {
            dvcCommand7.setMSPixel(0, (byArray[this.m_nCmdOffset] & 0x40) == 0);
            dvcCommand7.setMSPixel(1, (byArray[this.m_nCmdOffset] & 0x20) == 0);
            dvcCommand7.setMSPixel(2, (byArray[this.m_nCmdOffset] & 0x10) == 0);
            dvcCommand7.setMSPixel(3, (byArray[this.m_nCmdOffset] & 8) == 0);
            dvcCommand7.setMSPixel(4, (byArray[this.m_nCmdOffset] & 4) == 0);
            dvcCommand7.setMSPixel(5, (byArray[this.m_nCmdOffset] & 2) == 0);
            dvcCommand7.setMSPixel(6, (byArray[this.m_nCmdOffset] & 1) == 0);
            dvcCommand7.setNumMSBits(7);
            this.m_nCmdPending = (byArray[this.m_nCmdOffset] & 0x80) != 0 ? 2 : 0;
        }
        ++this.m_nCmdOffset;
        return true;
    }

    public void initPixelArray(int n, int n2) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(PacketVideoDVC initPixelArray) nWidth=" + n));
        switch (n2) {
            case 13: {
                if (this.m_abPB.length >= n) break;
                this.m_abPB = null;
                this.m_abPB = new byte[n];
                break;
            }
            case 5: {
                if (this.m_abPB.length >= n * 3) break;
                this.m_abPB = null;
                this.m_abPB = new byte[n * 3];
                break;
            }
            case 8: 
            case 9: {
                if (this.m_asPB.length >= n) break;
                this.m_asPB = null;
                this.m_asPB = new short[n];
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.m_anPB.length >= n) break;
                this.m_anPB = null;
                this.m_anPB = new int[n];
            }
        }
    }

    public void setDvcVideo(DvcCommand dvcCommand) {
        int[] nArray = new int[4];
        int n = 0;
        switch (dvcCommand.getCommand()) {
            case 1: {
                this.setDvcMPData(dvcCommand);
                break;
            }
            case 2: {
                this.setDvcMSData(dvcCommand);
                break;
            }
            case 5: {
                int n2 = this.m_nDvcCurrentPixel % this.m_nBitmapWidth;
                int n3 = this.m_nDvcCurrentPixel / this.m_nBitmapWidth;
                n = this.setDvcCAData(dvcCommand, n2, n3);
                while (n > 0) {
                    n2 = 0;
                    n = this.setDvcCADataNext(n2, ++n3, n);
                }
                this.m_nDvcCurrentPixel += dvcCommand.getRepeatCount();
                break;
            }
            case 4: {
                int n4 = this.m_nDvcCurrentPixel % this.m_nBitmapWidth;
                int n5 = this.m_nDvcCurrentPixel / this.m_nBitmapWidth;
                n = this.setDvcCLData(dvcCommand, n4, n5);
                while (n > 0) {
                    n4 = 0;
                    n = this.setDvcCLDataNext(n4, ++n5, n);
                }
                this.m_nDvcCurrentPixel += dvcCommand.getRepeatCount();
                break;
            }
            case 3: {
                this.m_nDvcCurrentPixel += dvcCommand.getRepeatCount();
                if (dvcCommand.getRepeatCount() <= this.m_nBitmapWidth * 2) break;
                this.m_panelRender.drawDvc();
            }
        }
    }

    public void videoConfigChanged(JPanelAppliance jPanelAppliance) {
        this.m_panelRender = jPanelAppliance;
        this.m_nBitmapWidth = this.m_panelRender.getBitmapWidth();
        this.m_nBitmapHeight = this.m_panelRender.getBitmapHeight();
        this.m_raster = this.m_panelRender.getRaster();
        this.m_nImageType = this.m_panelRender.getImageType();
        this.m_ab15BitTo8BitLUT = this.m_panelRender.get15BitTo8BitLUT();
        this.initPixelArray(this.m_nBitmapWidth, this.m_nImageType);
    }
}

