/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.video.DvcCommand;
import com.avocent.video.PacketVideoDVC;
import java.util.Arrays;

public class PacketVideoDvcNB
extends PacketVideoDVC {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";

    public PacketVideoDvcNB(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public void setDvcVideo(DvcCommand dvcCommand) {
        int n = this.m_panelRender.getBitmapWidth();
        int n2 = this.m_panelRender.getBitmapHeight();
        int[] nArray = this.m_panelRender.getPixelArray();
        if (nArray == null) {
            return;
        }
        switch (dvcCommand.getCommand()) {
            case 1: {
                int n3 = this.m_nDvcCurrentPixel % n;
                int n4 = this.m_nDvcCurrentPixel / n;
                this.setDvcMPDataNB(dvcCommand, n3, n4, nArray);
                this.m_panelRender.updateDirtyRegion(n3, n4, n3 + 1, n4 + 1);
                break;
            }
            case 2: {
                int n5 = this.m_nDvcCurrentPixel % n;
                int n6 = this.m_nDvcCurrentPixel / n;
                this.setDvcMSDataNB(dvcCommand, n5, n6, nArray);
                this.m_nDvcCurrentPixel = this.m_nDvcCurrentPixel;
                if (this.m_nDvcCurrentPixel % n < n5) {
                    this.m_panelRender.updateDirtyRegion(0, n6, n, this.m_nDvcCurrentPixel / n + 1);
                    break;
                }
                this.m_panelRender.updateDirtyRegion(n5, n6, this.m_nDvcCurrentPixel % n + 1, this.m_nDvcCurrentPixel / n + 1);
                break;
            }
            case 5: {
                int n7 = this.m_nDvcCurrentPixel % n;
                int n8 = this.m_nDvcCurrentPixel / n;
                this.setDvcCADataNB(dvcCommand, n7, n8, nArray, n);
                if (this.m_nDvcCurrentPixel % n < n7) {
                    this.m_panelRender.updateDirtyRegion(0, n8, n, this.m_nDvcCurrentPixel / n + 1);
                    break;
                }
                this.m_panelRender.updateDirtyRegion(n7, n8, this.m_nDvcCurrentPixel % n + 1, this.m_nDvcCurrentPixel / n + 1);
                break;
            }
            case 4: {
                int n9 = this.m_nDvcCurrentPixel % n;
                int n10 = this.m_nDvcCurrentPixel / n;
                this.setDvcCLDataNB(dvcCommand, n9, n10, nArray, n);
                if (this.m_nDvcCurrentPixel % n < n9) {
                    this.m_panelRender.updateDirtyRegion(0, n10, n, this.m_nDvcCurrentPixel / n + 1);
                    break;
                }
                this.m_panelRender.updateDirtyRegion(n9, n10, this.m_nDvcCurrentPixel % n + 1, this.m_nDvcCurrentPixel / n + 1);
                break;
            }
            case 3: {
                this.m_nDvcCurrentPixel += dvcCommand.getRepeatCount();
                if (dvcCommand.getRepeatCount() <= n * 2) break;
                this.m_panelRender.drawDvc();
            }
        }
    }

    public void setDvcMSDataNB(DvcCommand dvcCommand, int n, int n2, int[] nArray) {
        int n3;
        int n4;
        int n5;
        if (n >= this.m_nBitmapWidth || n2 >= this.m_nBitmapHeight) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)(" (PacketVideoDVC setDvcMSData) EXCEEDED BOUNDARIES Number MS Bits=" + dvcCommand.getNumMSBits() + " BitmapWidth= " + this.m_nBitmapWidth + " X= " + n + " Y=" + n2 + " Current Pixel=" + this.m_nDvcCurrentPixel));
            return;
        }
        if (dvcCommand.getNumMSBits() == 4) {
            this.m_nPBLastDvc7Pixel = 0;
            this.m_nPBPrevDvc7Pixel = 0;
            for (n5 = 0; n5 < 3; ++n5) {
                this.m_abPBLastDvc7Pixel[n5] = 0;
                this.m_abPBPrevDvc7Pixel[n5] = 0;
            }
            n5 = 0;
            if (n > 0) {
                n4 = n - 1;
                n3 = n2;
            } else {
                n4 = this.m_nBitmapWidth - 1;
                n3 = n2 - 1;
            }
            this.m_nPBLastDvc7Pixel = nArray[n4 + n3 * this.m_nBitmapWidth];
            while (n5 == 0) {
                if (n4 > 0) {
                    --n4;
                } else {
                    n4 = this.m_nBitmapWidth - 1;
                    --n3;
                }
                if (nArray[n4 + n3 * this.m_nBitmapWidth] == this.m_nPBLastDvc7Pixel) continue;
                n5 = 1;
                this.m_nPBPrevDvc7Pixel = nArray[n4 + n3 * this.m_nBitmapWidth];
            }
        }
        n5 = 0;
        n4 = n;
        n3 = n2;
        for (int i = 0; i < dvcCommand.getNumMSBits(); ++i) {
            n5 = dvcCommand.isLastColorPixel(i) ? this.m_nPBLastDvc7Pixel : this.m_nPBPrevDvc7Pixel;
            nArray[n4 + n3 * this.m_nBitmapWidth] = n5;
            ++this.m_nDvcCurrentPixel;
            n4 = this.m_nDvcCurrentPixel % this.m_nBitmapWidth;
            n3 = this.m_nDvcCurrentPixel / this.m_nBitmapWidth;
            if (this.m_nDvcCurrentPixel < this.m_nBitmapWidth * this.m_nBitmapHeight) continue;
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(PacketVideoDVC setDvcMSData) Invalid MS Request CurrentPixel= " + this.m_nDvcCurrentPixel + " Width= " + this.m_nBitmapWidth + " Height=" + this.m_nBitmapHeight + " Command pixel count=" + i));
            break;
        }
        if (n4 < n) {
            this.m_panelRender.updateDirtyRegion(0, n2, this.m_nBitmapWidth - 1, n2 + 1);
        } else {
            this.m_panelRender.updateDirtyRegion(n, n2, n4, n2 + 1);
        }
    }

    public void setDvcCLDataNB(DvcCommand dvcCommand, int n, int n2, int[] nArray, int n3) {
        int n4 = dvcCommand.getRepeatCount();
        Arrays.fill(nArray, this.m_nDvcCurrentPixel, this.m_nDvcCurrentPixel + n4, nArray[this.m_nDvcCurrentPixel - 1]);
        this.m_nDvcCurrentPixel += n4;
    }

    public void setDvcCADataNB(DvcCommand dvcCommand, int n, int n2, int[] nArray, int n3) {
        int n4;
        for (n4 = dvcCommand.getRepeatCount(); n4 > n3; n4 -= n3) {
            System.arraycopy(nArray, this.m_nDvcCurrentPixel - n3, nArray, this.m_nDvcCurrentPixel, n3);
            this.m_nDvcCurrentPixel += n3;
        }
        System.arraycopy(nArray, this.m_nDvcCurrentPixel - n3, nArray, this.m_nDvcCurrentPixel, n4);
        this.m_nDvcCurrentPixel += n4;
    }

    public void setDvcMPDataNB(DvcCommand dvcCommand, int n, int n2, int[] nArray) {
        int n3 = dvcCommand.getPixel();
        int n4 = (n3 & 0x7C00) << 9;
        int n5 = (n3 & 0x3E0) << 6;
        int n6 = (n3 & 0x1F) << 3;
        nArray[this.m_nDvcCurrentPixel] = n3 = 0xFF000000 | n4 | n5 | n6;
        ++this.m_nDvcCurrentPixel;
    }
}

