/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.ApplianceSession;
import com.avocent.video.GuiUtils;
import com.avocent.video.Help;
import com.avocent.video.JFrameViewerCmdPanel;
import com.avocent.video.JPanelAppliance;
import com.avocent.video.KeyboardMacro;
import com.avocent.video.Win32Library;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class PanelCommandButtons
extends JPanel {
    public static final String CNAME = "PanelCommandButtons";
    static ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private ApplianceSession m_applianceSession;
    private JPanelAppliance m_appliancePanel;
    private int m_nPanelHeight = 0;
    private int m_nPanelWidth = 0;
    private GridBagLayout m_gridBagLayout2 = new GridBagLayout();
    private JPanel m_jbButtonPanel = new JPanel();
    private GridBagLayout m_gridBagLayout4 = new GridBagLayout();
    private JPanel m_jPanel5 = new JPanel();
    private GridBagLayout m_gridBagLayout5 = new GridBagLayout();
    private JCheckBox m_jcControl = new JCheckBox();
    private JCheckBox m_jcAlt = new JCheckBox();
    private JPanel m_jPanel2 = new JPanel();
    private GridBagLayout gridBagLayout6 = new GridBagLayout();
    private JPanel m_jPanel6 = new JPanel();
    private JButton m_jbClose = new JButton();
    private JButton m_jbHelp = new JButton();
    private Image m_fileImage = null;
    private JPanel m_jPanel4 = new JPanel();
    private GridBagLayout m_gridBagLayout8 = new GridBagLayout();
    private JButton m_jbSendMacro = new JButton();
    private Border m_border1;
    private Border m_border3;
    private TitledBorder m_titledBorder1;
    private JComboBox m_jcbMacroList = new JComboBox();
    private JCheckBox m_jcbSysReq = new JCheckBox();
    private JButton m_jbRefresh = new JButton();
    private JButton m_jbCreateSnap = new JButton();
    private GridLayout m_gridLayout1 = new GridLayout();
    private Border m_border2;
    private TitledBorder m_titledBorder2;
    private JComboBox m_jcbxMouseAcc = new JComboBox();
    private JPanel m_jPanel3 = new JPanel();
    private Border m_border4;
    private GridBagLayout m_gridBagLayout3 = new GridBagLayout();
    private TitledBorder m_titledBorder4;
    private JButton m_jbVideoCalibration = new JButton();
    protected Frame m_parent;
    private int m_nHWND;
    private String m_szHelpURL;
    private boolean m_bCtrlButton = false;
    private boolean m_bAltButton = false;
    private boolean m_bSysReqButton = false;
    private KeyboardMacro[] m_km;
    protected Win32Library m_libWin32;

    public PanelCommandButtons(Frame frame, int n, JPanelAppliance jPanelAppliance, ApplianceSession applianceSession, String string) {
        this.m_applianceSession = applianceSession;
        this.m_appliancePanel = jPanelAppliance;
        this.m_parent = frame;
        if (this.m_parent == null || this.m_parent instanceof JFrame) {
            // empty if block
        }
        this.m_nHWND = n;
        this.m_szHelpURL = string;
        this.createComponents();
    }

    private void createComponents() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.logInfo((String)"VideoViewerTrace", (String)("PanelCommandButtons aListener actionCommand:" + actionEvent.getActionCommand() + " actionSource:" + actionEvent.getSource()));
                Object object = actionEvent.getSource();
                if (object == PanelCommandButtons.this.m_jbSendMacro) {
                    Trace.logInfo((String)"VideoViewerTrace", (String)"PanelCommandButtons send macro menu item action listener");
                    KeyboardMacro keyboardMacro = (KeyboardMacro)PanelCommandButtons.this.m_jcbMacroList.getSelectedItem();
                    PanelCommandButtons.this.m_applianceSession.cmdSendMacroKeystrokes(keyboardMacro);
                } else if (object == PanelCommandButtons.this.m_jbVideoCalibration) {
                    Trace.logInfo((String)"VideoViewerTrace", (String)"PanelCommandButtons calibrate menu item action listener");
                    PanelCommandButtons.this.m_applianceSession.displayManualVideoAdjustDlg();
                } else if (object == PanelCommandButtons.this.m_jbHelp) {
                    Trace.logInfo((String)"VideoViewerTrace", (String)"PanelCommandButtons help menu item action listener");
                    Help.launchHelp(PanelCommandButtons.this.m_szHelpURL, "IDH_HELP_CONTENTS_AND_INDEX");
                } else if (object == PanelCommandButtons.this.m_jbClose) {
                    Trace.logInfo((String)"VideoViewerTrace", (String)"PanelCommandButtons close menu item action listener");
                    PanelCommandButtons.this.m_applianceSession.getApplianceWindow().terminate();
                } else if (object == PanelCommandButtons.this.m_jbCreateSnap) {
                    Trace.logInfo((String)"VideoViewerTrace", (String)"PanelCommandButtons capture to file menu item action listener");
                    GuiUtils guiUtils = new GuiUtils();
                    guiUtils.captureToFile(PanelCommandButtons.this.m_appliancePanel);
                } else if (object == PanelCommandButtons.this.m_jbRefresh) {
                    Trace.logInfo((String)"VideoViewerTrace", (String)"PanelCommandButtons refresh menu item action listener");
                    try {
                        PanelCommandButtons.this.m_applianceSession.cmdRefreshPane();
                    }
                    catch (Exception exception) {
                        Trace.logError((String)"VideoViewerTrace", (String)"refresh error", (Throwable)exception);
                    }
                }
            }
        };
        this.m_jbSendMacro.addActionListener(actionListener);
        this.m_jbHelp.addActionListener(actionListener);
        this.m_jbClose.addActionListener(actionListener);
        this.m_jbCreateSnap.addActionListener(actionListener);
        this.m_jbRefresh.addActionListener(actionListener);
        this.m_jbVideoCalibration.addActionListener(actionListener);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Object object = itemEvent.getSource();
                if (object == PanelCommandButtons.this.m_jcControl) {
                    if (itemEvent.getStateChange() == 1) {
                        PanelCommandButtons.this.m_bCtrlButton = true;
                    } else {
                        PanelCommandButtons.this.m_bCtrlButton = false;
                    }
                    JFrameViewerCmdPanel jFrameViewerCmdPanel = (JFrameViewerCmdPanel)PanelCommandButtons.this.m_applianceSession.getApplianceWindow();
                    jFrameViewerCmdPanel.activateCtrlButtonState(PanelCommandButtons.this.m_bCtrlButton);
                } else if (object == PanelCommandButtons.this.m_jcAlt) {
                    if (itemEvent.getStateChange() == 1) {
                        PanelCommandButtons.this.m_bAltButton = true;
                    } else {
                        PanelCommandButtons.this.m_bAltButton = false;
                    }
                    JFrameViewerCmdPanel jFrameViewerCmdPanel = (JFrameViewerCmdPanel)PanelCommandButtons.this.m_applianceSession.getApplianceWindow();
                    jFrameViewerCmdPanel.activateAltButtonState(PanelCommandButtons.this.m_bAltButton);
                } else if (object == PanelCommandButtons.this.m_jcbSysReq) {
                    if (itemEvent.getStateChange() == 1) {
                        PanelCommandButtons.this.m_bSysReqButton = true;
                    } else {
                        PanelCommandButtons.this.m_bSysReqButton = false;
                    }
                    JFrameViewerCmdPanel jFrameViewerCmdPanel = (JFrameViewerCmdPanel)PanelCommandButtons.this.m_applianceSession.getApplianceWindow();
                    jFrameViewerCmdPanel.activateSysReqButtonState(PanelCommandButtons.this.m_bSysReqButton);
                } else if (object == PanelCommandButtons.this.m_jcbxMouseAcc && itemEvent.getStateChange() == 1) {
                    String string = (String)itemEvent.getItem();
                    JFrameViewerCmdPanel jFrameViewerCmdPanel = (JFrameViewerCmdPanel)PanelCommandButtons.this.m_applianceSession.getApplianceWindow();
                    if (string == RES.getString("PanelCommandButtons_Linux")) {
                        jFrameViewerCmdPanel.setMouseAcceleration(5);
                    } else if (string == RES.getString("PanelCommandButtons_Windows")) {
                        jFrameViewerCmdPanel.setMouseAcceleration(4);
                    } else {
                        jFrameViewerCmdPanel.setMouseAcceleration(0);
                    }
                }
            }
        };
        this.m_jcControl.addItemListener(itemListener);
        this.m_jcAlt.addItemListener(itemListener);
        this.m_jcbSysReq.addItemListener(itemListener);
        this.m_km = KeyboardMacro.createMacrosGlacierD();
        for (int i = 0; i < this.m_km.length; ++i) {
            this.m_jcbMacroList.addItem(this.m_km[i]);
        }
        this.m_jcAlt.setSelected(false);
        this.m_jcControl.setSelected(false);
        this.m_jcbSysReq.setSelected(false);
        this.m_jcbxMouseAcc.addItem(RES.getString("PanelCommandButtons_None"));
        this.m_jcbxMouseAcc.addItem(RES.getString("PanelCommandButtons_Windows"));
        this.m_jcbxMouseAcc.addItem(RES.getString("PanelCommandButtons_Linux"));
        this.m_jcbxMouseAcc.addItemListener(itemListener);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.m_gridBagLayout2);
        this.m_border1 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.m_titledBorder1 = new TitledBorder(this.m_border1, RES.getString("PanelCommandButtons_Keyboard_Macros"));
        this.m_border2 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.m_titledBorder2 = new TitledBorder(this.m_border2, RES.getString("PanelCommandButtons_Mouse_Acceleration"));
        this.m_border3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), RES.getString("PanelCommandButtons_Keystroke_Prefix"));
        this.m_border4 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        this.m_titledBorder4 = new TitledBorder(this.m_border4, RES.getString("PanelCommandButtons_Video_Calibration"));
        this.m_jbButtonPanel.setLayout(this.m_gridBagLayout4);
        this.m_jbButtonPanel.setBorder(null);
        this.m_jPanel5.setLayout(this.m_gridBagLayout5);
        this.m_jPanel5.setBorder(this.m_border3);
        this.m_jcbSysReq.setText(RES.getString("PanelCommandButtons_SysReq"));
        this.m_jcControl.setText(RES.getString("PanelCommandButtons_Cntrl_"));
        this.m_jcAlt.setText(RES.getString("PanelCommandButtons_Alt_"));
        this.m_jPanel6.setLayout(this.m_gridLayout1);
        this.m_gridLayout1.setColumns(2);
        this.m_gridLayout1.setHgap(5);
        this.m_gridLayout1.setRows(2);
        this.m_gridLayout1.setVgap(5);
        this.m_jbClose.setText(RES.getString("PanelCommandButtons_Close"));
        this.m_jbHelp.setText(RES.getString("PanelCommandButtons_Help"));
        this.m_jbRefresh.setText(RES.getString("PanelCommandButtons_Refresh"));
        this.m_jbCreateSnap.setText(RES.getString("PanelCommandButtons_Create_Snapshot"));
        this.m_jPanel2.setLayout(this.gridBagLayout6);
        this.m_jPanel2.setBorder(this.m_titledBorder2);
        this.m_jPanel4.setLayout(this.m_gridBagLayout8);
        this.m_jPanel4.setBorder(this.m_titledBorder1);
        this.m_jbSendMacro.setText(RES.getString("PanelCommandButtons_Send_Macro"));
        this.m_jcbMacroList.setPreferredSize(new Dimension(110, 24));
        this.m_jPanel3.setLayout(this.m_gridBagLayout3);
        this.m_jPanel3.setBorder(this.m_titledBorder4);
        this.m_jbVideoCalibration.setText(RES.getString("PanelCommandButtons_Calibrate"));
        this.add((Component)this.m_jbButtonPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.m_jbButtonPanel.add((Component)this.m_jPanel5, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 5, 0, 5), 0, 3));
        this.m_jPanel5.add((Component)this.m_jcControl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.m_jPanel5.add((Component)this.m_jcAlt, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.m_jPanel5.add((Component)this.m_jcbSysReq, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.m_jbButtonPanel.add((Component)this.m_jPanel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 5), 0, 6));
        this.m_jPanel2.add((Component)this.m_jcbxMouseAcc, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.m_jbButtonPanel.add((Component)this.m_jPanel3, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 5), 0, 6));
        this.m_jPanel3.add((Component)this.m_jbVideoCalibration, null);
        this.m_jbButtonPanel.add((Component)this.m_jPanel6, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.m_jPanel6.add((Component)this.m_jbRefresh, null);
        this.m_jPanel6.add((Component)this.m_jbHelp, null);
        this.m_jPanel6.add((Component)this.m_jbCreateSnap, null);
        this.m_jPanel6.add((Component)this.m_jbClose, null);
        this.m_jbButtonPanel.add((Component)this.m_jPanel4, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.m_jPanel4.add((Component)this.m_jbSendMacro, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 5, 3, 5), 0, 0));
        this.m_jPanel4.add((Component)this.m_jcbMacroList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.m_nPanelHeight = (int)this.getPreferredSize().getHeight();
        this.m_nPanelWidth = (int)this.getPreferredSize().getWidth();
        if (this.m_szHelpURL == null || this.m_szHelpURL.length() == 0) {
            this.m_jbHelp.setEnabled(false);
        }
    }

    public void initToolbar(ApplianceSession applianceSession) {
        this.m_applianceSession = applianceSession;
        this.setVisible(true);
    }

    public int getPanelHeight() {
        return this.m_nPanelHeight;
    }

    public int getPanelWidth() {
        return this.m_nPanelWidth;
    }

    public void setMouseAcceleration(int n) {
        switch (n) {
            case 0: {
                this.m_jcbxMouseAcc.setSelectedItem(RES.getString("PanelCommandButtons_None"));
                break;
            }
            case 5: {
                this.m_jcbxMouseAcc.setSelectedItem(RES.getString("PanelCommandButtons_Linux"));
                break;
            }
            default: {
                this.m_jcbxMouseAcc.setSelectedItem(RES.getString("PanelCommandButtons_Windows"));
            }
        }
    }
}

