/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.util.OS;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.Win32Library;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class PanelToolbar
extends JPanel {
    public static final String CNAME = "PanelToolbar";
    static ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    public static final int MAX_BUTTONS = 10;
    private Image m_imageBarLeft = null;
    private Image m_imageBarRight = null;
    private Image m_imageBarLeftDoubleHeight = null;
    private Image m_imageBarRightDoubleHeight = null;
    private Image m_imagePinned = null;
    private Image m_imagePinnedRollover = null;
    private Image m_imageUnpinned = null;
    private Image m_imageUnpinnedRollover = null;
    private int m_nHeight;
    protected boolean m_bToolbarLockedInPlace = false;
    private boolean m_bToolbarInitiallyLockedInPlace = false;
    private boolean m_bToolbarPermanentlyLockedInPlace = false;
    private boolean m_bMouseInToolbar = false;
    private long m_lTimeLastMouseEvent = 0L;
    private int m_nHideTimeout = 2;
    private Thread m_threadScrollToolbarShow = null;
    private Thread m_threadScrollToolbarHide = null;
    private boolean m_bToolbarHidden = false;
    private boolean m_bMouseDown = false;
    private boolean m_bMenuSelected = false;
    private boolean m_bFirstPaintOccurred = false;
    private Point m_ptMouse = new Point(0, 0);
    private boolean m_bMenuDown = false;
    protected ApplianceSession m_applianceSession;
    protected ToolbarButton[] m_aToolbarButtons;
    protected ToolbarToggleButton m_buttonPinned;
    protected PanelMenuButtons m_panelInner;
    protected ToolbarButton m_buttonConnectionStatus;
    protected ToolbarButton m_buttonLockedAndReserveStatus;
    protected int m_nInnerPanelLeftOffset = 0;
    private int m_nMaxWidth = 0;
    protected Frame m_parent;
    private int m_nHWND;
    private int m_nXCentered = 0;
    private int m_nY = 0;
    private KeyAdapterMenu m_keyAdapterMenu;
    private boolean m_bDoubleRow = false;
    private boolean m_bPainting = false;
    protected Win32Library m_libWin32;
    static /* synthetic */ Class class$com$avocent$video$PanelToolbar;

    public PanelToolbar(int n, int n2, int n3, Frame frame, int n4, ApplianceSession applianceSession, boolean bl, boolean bl2, int n5) {
        this.setLayout(null);
        this.m_applianceSession = applianceSession;
        this.m_nMaxWidth = n3;
        this.m_parent = frame;
        if (this.m_parent != null && this.m_parent instanceof JFrame) {
            this.m_keyAdapterMenu = new KeyAdapterMenu();
            ((JFrame)this.m_parent).getRootPane().addKeyListener(this.m_keyAdapterMenu);
        }
        this.m_nHWND = n4;
        this.m_nXCentered = n;
        this.m_nY = n2;
        this.m_nHideTimeout = n5;
        this.m_bToolbarInitiallyLockedInPlace = bl;
        this.m_bToolbarPermanentlyLockedInPlace = bl2;
        boolean bl3 = this.m_bToolbarLockedInPlace = this.m_bToolbarInitiallyLockedInPlace || this.m_bToolbarPermanentlyLockedInPlace;
        if (OS.isWindows()) {
            try {
                this.m_libWin32 = new Win32Library();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Trace.logError((String)"VideoViewerTrace", (String)unsatisfiedLinkError.getMessage(), (Throwable)unsatisfiedLinkError);
            }
        }
        this.m_imageBarLeft = this.getToolkit().createImage((class$com$avocent$video$PanelToolbar == null ? (class$com$avocent$video$PanelToolbar = PanelToolbar.class$("com.avocent.video.PanelToolbar")) : class$com$avocent$video$PanelToolbar).getResource("images/bar_left.gif"));
        this.m_imageBarLeftDoubleHeight = this.getToolkit().createImage((class$com$avocent$video$PanelToolbar == null ? (class$com$avocent$video$PanelToolbar = PanelToolbar.class$("com.avocent.video.PanelToolbar")) : class$com$avocent$video$PanelToolbar).getResource("images/bar_left_double_height.gif"));
        this.m_imageBarRight = this.getToolkit().createImage((class$com$avocent$video$PanelToolbar == null ? (class$com$avocent$video$PanelToolbar = PanelToolbar.class$("com.avocent.video.PanelToolbar")) : class$com$avocent$video$PanelToolbar).getResource("images/bar_right.gif"));
        this.m_imageBarRightDoubleHeight = this.getToolkit().createImage((class$com$avocent$video$PanelToolbar == null ? (class$com$avocent$video$PanelToolbar = PanelToolbar.class$("com.avocent.video.PanelToolbar")) : class$com$avocent$video$PanelToolbar).getResource("images/bar_right_double_height.gif"));
        this.m_imagePinned = this.getToolkit().createImage((class$com$avocent$video$PanelToolbar == null ? (class$com$avocent$video$PanelToolbar = PanelToolbar.class$("com.avocent.video.PanelToolbar")) : class$com$avocent$video$PanelToolbar).getResource("images/pinned.gif"));
        this.m_imagePinnedRollover = this.getToolkit().createImage((class$com$avocent$video$PanelToolbar == null ? (class$com$avocent$video$PanelToolbar = PanelToolbar.class$("com.avocent.video.PanelToolbar")) : class$com$avocent$video$PanelToolbar).getResource("images/pinnedRollover.gif"));
        this.m_imageUnpinned = this.getToolkit().createImage((class$com$avocent$video$PanelToolbar == null ? (class$com$avocent$video$PanelToolbar = PanelToolbar.class$("com.avocent.video.PanelToolbar")) : class$com$avocent$video$PanelToolbar).getResource("images/unpinned.gif"));
        this.m_imageUnpinnedRollover = this.getToolkit().createImage((class$com$avocent$video$PanelToolbar == null ? (class$com$avocent$video$PanelToolbar = PanelToolbar.class$("com.avocent.video.PanelToolbar")) : class$com$avocent$video$PanelToolbar).getResource("images/unpinnedRollover.gif"));
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(this.m_imageBarLeft, 0);
        mediaTracker.addImage(this.m_imageBarLeftDoubleHeight, 1);
        mediaTracker.addImage(this.m_imageBarRight, 2);
        mediaTracker.addImage(this.m_imageBarRightDoubleHeight, 3);
        mediaTracker.addImage(this.m_imagePinned, 4);
        mediaTracker.addImage(this.m_imageUnpinned, 5);
        mediaTracker.addImage(this.m_imagePinnedRollover, 6);
        mediaTracker.addImage(this.m_imageUnpinnedRollover, 7);
        try {
            mediaTracker.waitForID(0);
            mediaTracker.waitForID(1);
            mediaTracker.waitForID(2);
            mediaTracker.waitForID(3);
            mediaTracker.waitForID(4);
            mediaTracker.waitForID(5);
            mediaTracker.waitForID(6);
            mediaTracker.waitForID(7);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_nInnerPanelLeftOffset = this.m_imageBarLeft.getWidth(null);
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setBounds(this.m_nMaxWidth / 2, 0, 1, 1);
        int n6 = 26;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PanelToolbar.this.m_lTimeLastMouseEvent = System.currentTimeMillis();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                PanelToolbar.this.m_lTimeLastMouseEvent = System.currentTimeMillis();
                PanelToolbar.this.m_bMouseInToolbar = true;
                if (PanelToolbar.this.m_bToolbarHidden) {
                    PanelToolbar.this.showToolbar();
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                PanelToolbar.this.m_lTimeLastMouseEvent = System.currentTimeMillis();
                PanelToolbar.this.m_bMouseInToolbar = false;
                PanelToolbar.this.hideToolbar();
            }

            public void mousePressed(MouseEvent mouseEvent) {
                PanelToolbar.this.m_lTimeLastMouseEvent = System.currentTimeMillis();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                PanelToolbar.this.m_lTimeLastMouseEvent = System.currentTimeMillis();
            }
        });
    }

    public void initToolbar(ApplianceSession applianceSession) {
        this.m_applianceSession = applianceSession;
        this.setVisible(true);
    }

    public boolean isToolbarLockedInPlace() {
        return this.m_bToolbarLockedInPlace;
    }

    public void lockToolbarInPlace(boolean bl) {
        this.m_bToolbarLockedInPlace = bl;
    }

    public void setToolbarHideTimeout(int n) {
        this.m_nHideTimeout = n;
    }

    public int getToolbarHideTimeout() {
        return this.m_nHideTimeout;
    }

    protected void hideToolbar() {
        this.hideToolbar(false);
    }

    protected void restorePinPush() {
        this.m_buttonPinned.setSelected(true);
        this.m_buttonPinned.setSelectedIcon(this.m_buttonPinned.getSelectedIcon());
        this.lockToolbarInPlace(true);
        if (this.m_bToolbarHidden) {
            this.showToolbar();
            this.m_bToolbarHidden = false;
        }
        this.hideToolbar();
    }

    protected void hideToolbar(boolean bl) {
        if (bl) {
            this.m_bMouseInToolbar = true;
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    Point point = PanelToolbar.this.getLocation();
                    for (int i = 0; i < 11; ++i) {
                        point.y -= PanelToolbar.this.m_nHeight / 12;
                        PanelToolbar.this.setLocation(point);
                        try {
                            Thread.sleep(20L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    point.y -= PanelToolbar.this.m_nHeight / 24;
                    PanelToolbar.this.setLocation(point);
                    PanelToolbar.this.m_bToolbarHidden = true;
                }
            });
            thread.start();
            return;
        }
        if (this.m_threadScrollToolbarHide != null || this.m_bToolbarHidden || this.m_bToolbarLockedInPlace || this.m_bToolbarPermanentlyLockedInPlace) {
            return;
        }
        this.m_threadScrollToolbarHide = new Thread(new Runnable(){

            public void run() {
                while (System.currentTimeMillis() - PanelToolbar.this.m_lTimeLastMouseEvent < (long)(PanelToolbar.this.m_nHideTimeout * 1000)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!PanelToolbar.this.m_bToolbarLockedInPlace && !PanelToolbar.this.m_bMenuDown && !PanelToolbar.this.m_bMouseInToolbar) continue;
                    PanelToolbar.this.m_threadScrollToolbarHide = null;
                    return;
                }
                Point point = PanelToolbar.this.getLocation();
                for (int i = 0; i < 11; ++i) {
                    point.y -= PanelToolbar.this.m_nHeight / 12;
                    PanelToolbar.this.setLocation(point);
                    try {
                        Thread.sleep(40L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                point.y -= PanelToolbar.this.m_nHeight / 24;
                PanelToolbar.this.setLocation(point);
                PanelToolbar.this.m_bToolbarHidden = true;
                PanelToolbar.this.m_threadScrollToolbarHide = null;
            }
        });
        this.m_threadScrollToolbarHide.start();
    }

    private void showToolbar() {
        if (this.m_threadScrollToolbarShow != null) {
            return;
        }
        this.m_threadScrollToolbarShow = new Thread(new Runnable(){

            public void run() {
                Point point = PanelToolbar.this.getLocation();
                for (int i = 0; i < 11; ++i) {
                    point.y += PanelToolbar.this.m_nHeight / 12;
                    PanelToolbar.this.setLocation(point);
                    try {
                        Thread.sleep(40L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                point.y += PanelToolbar.this.m_nHeight / 24;
                PanelToolbar.this.setLocation(point);
                PanelToolbar.this.m_bToolbarHidden = false;
                PanelToolbar.this.m_threadScrollToolbarShow = null;
                PanelToolbar.this.m_lTimeLastMouseEvent = System.currentTimeMillis();
            }
        });
        this.m_threadScrollToolbarShow.start();
    }

    public boolean activateMenu() {
        if (this.m_bToolbarHidden) {
            this.showToolbar();
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                while (PanelToolbar.this.m_bToolbarHidden) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        MenuButton menuButton = PanelMenuButtons.access$1100(6.access$1000(this.this$1).m_panelInner, 0);
                        MenuButton.access$1200(menuButton);
                        menuButton.repaint();
                    }
                });
            }

            static /* synthetic */ PanelToolbar access$1000(6 var0) {
                return var0.PanelToolbar.this;
            }
        });
        thread.start();
        return true;
    }

    protected abstract int createMenus(PanelMenuButtons var1, int var2, Graphics var3);

    protected int createTitle(PanelMenuButtons panelMenuButtons, int n, Graphics graphics) {
        return n;
    }

    protected abstract int createToolbarButtons(JPanel var1, int var2, int var3, Graphics var4);

    protected abstract int getNumberToolbarButtons();

    public void paint(Graphics graphics) {
        Rectangle rectangle;
        this.m_bPainting = true;
        Font font = new Font("Arial", 0, 12);
        graphics.setFont(font);
        if (!this.m_bFirstPaintOccurred) {
            this.m_bFirstPaintOccurred = true;
            this.firstPaint(graphics);
        }
        if ((rectangle = this.getBounds()).getHeight() > (double)this.m_imageBarLeft.getHeight(null)) {
            graphics.drawImage(this.m_imageBarLeftDoubleHeight, 0, 0, null);
            graphics.drawImage(this.m_imageBarRightDoubleHeight, rectangle.width - this.m_imageBarLeftDoubleHeight.getWidth(null) + 2, 0, null);
        } else {
            graphics.drawImage(this.m_imageBarLeft, 0, 0, null);
            graphics.drawImage(this.m_imageBarRight, rectangle.width - this.m_imageBarLeft.getWidth(null) + 2, 0, null);
        }
        this.paintChildren(graphics);
        this.m_bPainting = false;
    }

    private void firstPaint(Graphics graphics) {
        this.m_panelInner = new PanelMenuButtons(null);
        this.add(this.m_panelInner);
        this.m_buttonPinned = new ToolbarToggleButton(new ImageIcon(this.m_imageUnpinned), new ImageIcon(this.m_imageUnpinnedRollover), new ImageIcon(this.m_imagePinned), new ImageIcon(this.m_imagePinnedRollover), 5, RES.getString("PanelToolbar_Pinned"));
        this.m_buttonPinned.setSelected(this.m_bToolbarPermanentlyLockedInPlace || this.m_bToolbarInitiallyLockedInPlace);
        this.m_buttonPinned.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                PanelToolbar.this.m_lTimeLastMouseEvent = System.currentTimeMillis();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                PanelToolbar.this.m_lTimeLastMouseEvent = System.currentTimeMillis();
            }

            public void mousePressed(MouseEvent mouseEvent) {
                PanelToolbar.this.m_lTimeLastMouseEvent = System.currentTimeMillis();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                PanelToolbar.this.m_lTimeLastMouseEvent = System.currentTimeMillis();
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!PanelToolbar.this.m_bToolbarPermanentlyLockedInPlace) {
                    PanelToolbar.this.m_bToolbarLockedInPlace = PanelToolbar.this.m_buttonPinned.isSelected();
                    PanelToolbar.this.hideToolbar();
                    ApplianceSessionInfo applianceSessionInfo = PanelToolbar.this.m_applianceSession.getPersistentDataReference();
                    if (applianceSessionInfo != null) {
                        applianceSessionInfo.setPinPushed(PanelToolbar.this.m_bToolbarLockedInPlace);
                    }
                }
            }
        });
        this.m_buttonPinned.setFocusable(false);
        this.m_panelInner.add(this.m_buttonPinned);
        this.m_buttonPinned.setVisible(true);
        int n = 25;
        PanelSeparator panelSeparator = new PanelSeparator(n, 20);
        this.m_panelInner.add(panelSeparator);
        n += 5;
        this.m_panelInner.setBounds(0, 0, 1, 1);
        n = this.createMenus(this.m_panelInner, n, graphics);
        panelSeparator = new PanelSeparator(n, 20);
        this.m_panelInner.add(panelSeparator);
        n += panelSeparator.getBounds().width;
        n = this.createTitle(this.m_panelInner, n, graphics);
        int n2 = this.getNumberToolbarButtons();
        if (n2 > 0 && this.m_nMaxWidth - n < n2 * 24 + 30 + 25 + this.m_imageBarRight.getWidth(null)) {
            this.m_bDoubleRow = true;
            int n3 = this.m_imageBarLeftDoubleHeight.getWidth(null) + n2 * 24 + 20 + this.m_imageBarRightDoubleHeight.getWidth(null);
            Trace.logInfo((String)"VideoViewerTrace", (String)("PanelToolbar.firstPaint double row toolbar required nWidth=" + n3));
            if (n > n3) {
                n3 = n + this.m_imageBarRightDoubleHeight.getWidth(null);
                Trace.logInfo((String)"VideoViewerTrace", (String)("PanelToolbar.firstPaint double row toolbar required nCurrentX > nWidth, new nWidth=" + n3));
            }
            this.m_nHeight = this.m_imageBarLeftDoubleHeight.getHeight(null);
            this.setSize(n3, this.m_nHeight);
            this.setLocation(this.m_nMaxWidth / 2 - n3 / 2, 0);
            Trace.logInfo((String)"VideoViewerTrace", (String)("PanelToolbar.firstPaint double row toolbar required location x=" + (this.m_nMaxWidth / 2 - n3 / 2)));
            this.m_panelInner.setBounds(this.m_imageBarLeftDoubleHeight.getWidth(null), 0, n3 - this.m_imageBarRightDoubleHeight.getWidth(null) - this.m_imageBarLeftDoubleHeight.getWidth(null) + 1, this.m_imageBarLeftDoubleHeight.getHeight(null));
            Rectangle rectangle = this.m_panelInner.getBounds();
            n = this.createToolbarButtons(this.m_panelInner, 25, this.m_imageBarLeftDoubleHeight.getHeight(null) / 2, graphics);
        } else {
            Trace.logInfo((String)"VideoViewerTrace", (String)"PanelToolbar.firstPaint single row toolbar");
            this.m_bDoubleRow = false;
            int n4 = (n += 10) + n2 * 24 + 30 + this.m_imageBarRight.getWidth(null);
            this.m_nHeight = this.m_imageBarLeft.getHeight(null);
            this.setSize(n4, this.m_nHeight);
            this.setLocation(this.m_nMaxWidth / 2 - n4 / 2, 0);
            this.m_panelInner.setBounds(this.m_imageBarLeft.getWidth(null), 0, n4 - this.m_imageBarRight.getWidth(null) - this.m_imageBarLeft.getWidth(null) + 1, this.m_imageBarLeft.getHeight(null));
            Rectangle rectangle = this.m_panelInner.getBounds();
            n = this.createToolbarButtons(this.m_panelInner, n, 0, graphics);
        }
        this.m_lTimeLastMouseEvent = System.currentTimeMillis();
        this.hideToolbar();
    }

    public boolean isMenuDown() {
        return this.m_bMenuDown;
    }

    protected void setMenuDown(boolean bl) {
        this.m_bMenuDown = bl;
        if (OS.isWindows() && this.m_nHWND != 0) {
            this.m_libWin32.processWindowsMessages(!this.m_bMenuDown);
        }
    }

    public void terminate() {
        int n;
        while (this.m_threadScrollToolbarHide != null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (this.m_threadScrollToolbarShow != null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.m_parent != null && this.m_parent instanceof JFrame) {
            ((JFrame)this.m_parent).getRootPane().removeKeyListener(this.m_keyAdapterMenu);
        }
        this.m_parent = null;
        this.m_buttonConnectionStatus = null;
        this.m_buttonLockedAndReserveStatus = null;
        this.m_buttonPinned = null;
        this.m_imageBarLeft = null;
        this.m_imageBarLeftDoubleHeight = null;
        this.m_imageBarRight = null;
        this.m_imageBarRightDoubleHeight = null;
        this.m_imagePinned = null;
        this.m_imagePinnedRollover = null;
        this.m_imageUnpinned = null;
        this.m_imageUnpinnedRollover = null;
        this.m_libWin32 = null;
        for (n = 0; n < this.m_aToolbarButtons.length; ++n) {
            MouseListener[] mouseListenerArray = this.m_aToolbarButtons[n].getMouseListeners();
            for (int i = 0; i < mouseListenerArray.length; ++i) {
                this.m_aToolbarButtons[n].removeMouseListener(mouseListenerArray[i]);
            }
        }
        for (n = 0; n < this.m_aToolbarButtons.length; ++n) {
            this.m_aToolbarButtons[n] = null;
        }
        this.m_aToolbarButtons = null;
        this.m_panelInner.terminate();
        this.m_panelInner = null;
        this.m_ptMouse = null;
        this.m_applianceSession = null;
        this.m_buttonPinned = null;
        this.m_buttonConnectionStatus = null;
        this.m_buttonLockedAndReserveStatus = null;
        this.m_parent = null;
        this.m_keyAdapterMenu = null;
    }

    public void setLocationOnParentResize(int n) {
        Trace.logInfo((String)"VideoViewerTrace", (String)("setLocationOnParentResize nParentWidth=" + n));
        Rectangle rectangle = this.getBounds();
        this.setLocation((n - rectangle.width) / 2, rectangle.y);
    }

    public void closeAllMenus() {
        if (this.m_panelInner != null) {
            this.m_panelInner.closeAllDropdownMenus();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class PanelSeparator
    extends JPanel {
        protected PanelSeparator(int n, int n2) {
            this.setBounds(n, 0, 2, n2);
            this.setVisible(true);
        }

        public void paintComponent(Graphics graphics) {
            Rectangle rectangle = this.getBounds();
            graphics.setColor(Color.lightGray);
            graphics.drawLine(0, 0, 0, rectangle.height);
        }
    }

    private class KeyAdapterMenu
    extends KeyAdapter {
        private KeyAdapterMenu() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            block2: {
                block3: {
                    if (!PanelToolbar.this.m_bMenuDown) break block2;
                    if (keyEvent.getKeyCode() != 37) break block3;
                    keyEvent.consume();
                    Vector vector = PanelToolbar.this.m_panelInner.getMenuButtons();
                    for (int i = 1; i < vector.size(); ++i) {
                        MenuButton menuButton = (MenuButton)vector.get(i);
                        if (!menuButton.isYourMenuVisible()) continue;
                        menuButton.closeMenu();
                        menuButton = (MenuButton)vector.get(i - 1);
                        menuButton.showMenu();
                        menuButton.repaint();
                        break block2;
                    }
                    break block2;
                }
                if (keyEvent.getKeyCode() != 39) break block2;
                keyEvent.consume();
                Vector vector = PanelToolbar.this.m_panelInner.getMenuButtons();
                for (int i = 0; i < vector.size() - 1; ++i) {
                    MenuButton menuButton = (MenuButton)vector.get(i);
                    if (!menuButton.isYourMenuVisible()) continue;
                    menuButton.closeMenu();
                    menuButton = (MenuButton)vector.get(i + 1);
                    menuButton.showMenu();
                    menuButton.repaint();
                    break;
                }
            }
        }
    }

    protected class JPopupMenuToolbar
    extends JPopupMenu {
        PanelMenuButtons m_panelMenuButtons;
        KeyAdapterMenu m_keyAdapterMenuPopup;

        public JPopupMenuToolbar(PanelMenuButtons panelMenuButtons) {
            this.m_panelMenuButtons = panelMenuButtons;
            this.m_keyAdapterMenuPopup = new KeyAdapterMenu();
            this.addKeyListener(this.m_keyAdapterMenuPopup);
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (!bl) {
                PanelToolbar.this.hideToolbar();
            }
        }

        public void terminate() {
            PopupMenuListener[] popupMenuListenerArray = this.getPopupMenuListeners();
            for (int i = 0; i < popupMenuListenerArray.length; ++i) {
                this.removePopupMenuListener(popupMenuListenerArray[i]);
            }
            this.removeKeyListener(this.m_keyAdapterMenuPopup);
            this.m_keyAdapterMenuPopup = null;
        }
    }

    protected class PanelMenuButtons
    extends JPanel
    implements InterfaceNotifyMenuButtons {
        private Vector m_vMenuButtons = new Vector();

        public PanelMenuButtons(LayoutManager layoutManager) {
            super(layoutManager);
            this.setOpaque(true);
            this.setVisible(true);
            this.setDoubleBuffered(true);
            this.addMouseMotionListener(new MouseMotionListener(this){
                private final /* synthetic */ PanelMenuButtons this$1;
                {
                    this.this$1 = panelMenuButtons;
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                }
            });
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ PanelMenuButtons this$1;
                {
                    this.this$1 = panelMenuButtons;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    PanelToolbar.access$102(PanelMenuButtons.access$1700(this.this$1), System.currentTimeMillis());
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    PanelToolbar.access$102(PanelMenuButtons.access$1700(this.this$1), System.currentTimeMillis());
                    if (PanelToolbar.access$300(PanelMenuButtons.access$1700(this.this$1))) {
                        PanelToolbar.access$400(PanelMenuButtons.access$1700(this.this$1));
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    PanelToolbar.access$102(PanelMenuButtons.access$1700(this.this$1), System.currentTimeMillis());
                    PanelMenuButtons.access$1700(this.this$1).hideToolbar();
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    PanelToolbar.access$102(PanelMenuButtons.access$1700(this.this$1), System.currentTimeMillis());
                }
            });
        }

        public void addMenuButton(MenuButton menuButton) {
            this.add(menuButton);
            this.m_vMenuButtons.add(menuButton);
        }

        public void notifyMouseInMenuButton(MenuButton menuButton) {
            MenuButton menuButton2;
            int n;
            boolean bl = false;
            for (n = 0; n < this.m_vMenuButtons.size(); ++n) {
                menuButton2 = (MenuButton)this.m_vMenuButtons.get(n);
                if (menuButton2 == menuButton || !menuButton2.isYourMenuVisible()) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (n = 0; n < this.m_vMenuButtons.size(); ++n) {
                    menuButton2 = (MenuButton)this.m_vMenuButtons.get(n);
                    if (menuButton2 == menuButton) continue;
                    menuButton2.closeMenu();
                }
                menuButton.showMenu();
            }
        }

        public void paintComponent(Graphics graphics) {
            Rectangle rectangle = this.getBounds();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            graphics.setColor(Color.darkGray);
            graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
        }

        private MenuButton getMenuButton(int n) {
            if (n < this.m_vMenuButtons.size()) {
                return (MenuButton)this.m_vMenuButtons.get(n);
            }
            return null;
        }

        private Vector getMenuButtons() {
            return this.m_vMenuButtons;
        }

        private void terminate() {
            while (this.m_vMenuButtons.size() > 0) {
                this.m_vMenuButtons.remove(0);
            }
        }

        public void closeAllDropdownMenus() {
            Trace.logInfo((String)"VideoViewerTrace", (String)"PanelMenuButtons closeAllDropdownMenus");
            for (int i = 0; i < this.m_vMenuButtons.size(); ++i) {
                MenuButton menuButton = (MenuButton)this.m_vMenuButtons.get(i);
                menuButton.closeMenu();
            }
        }

        static /* synthetic */ MenuButton access$1100(PanelMenuButtons panelMenuButtons, int n) {
            return panelMenuButtons.getMenuButton(n);
        }

        static /* synthetic */ PanelToolbar access$1700(PanelMenuButtons panelMenuButtons) {
            return panelMenuButtons.PanelToolbar.this;
        }
    }

    private static interface InterfaceNotifyMenuButtons {
        public void notifyMouseInMenuButton(MenuButton var1);
    }

    protected class ToolbarToggleButton
    extends JToggleButton {
        boolean m_bMouseInButton = false;

        protected ToolbarToggleButton(ImageIcon imageIcon, ImageIcon imageIcon2, ImageIcon imageIcon3, ImageIcon imageIcon4, int n, String string) {
            super(imageIcon);
            this.setBounds(n - 1, 1, imageIcon.getIconWidth() + 2, imageIcon.getIconHeight() + 2);
            this.setOpaque(true);
            this.setVisible(true);
            this.setBorderPainted(false);
            this.setBackground(Color.white);
            this.setFocusPainted(false);
            if (imageIcon2 != null) {
                this.setRolloverEnabled(true);
                this.setRolloverIcon(imageIcon2);
            }
            if (imageIcon3 != null) {
                this.setSelectedIcon(imageIcon3);
            }
            if (imageIcon4 != null) {
                this.setRolloverSelectedIcon(imageIcon4);
            }
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ ToolbarToggleButton this$1;
                {
                    this.this$1 = toolbarToggleButton;
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    PanelToolbar.access$102(ToolbarToggleButton.access$1600(this.this$1), System.currentTimeMillis());
                    PanelToolbar.access$202(ToolbarToggleButton.access$1600(this.this$1), true);
                    if (PanelToolbar.access$300(ToolbarToggleButton.access$1600(this.this$1))) {
                        PanelToolbar.access$400(ToolbarToggleButton.access$1600(this.this$1));
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    PanelToolbar.access$102(ToolbarToggleButton.access$1600(this.this$1), System.currentTimeMillis());
                    PanelToolbar.access$202(ToolbarToggleButton.access$1600(this.this$1), false);
                    ToolbarToggleButton.access$1600(this.this$1).hideToolbar();
                }
            });
        }

        static /* synthetic */ PanelToolbar access$1600(ToolbarToggleButton toolbarToggleButton) {
            return toolbarToggleButton.PanelToolbar.this;
        }
    }

    protected class ToolbarButton
    extends JButton {
        boolean m_bMouseInButton = false;

        protected ToolbarButton(Icon icon, Icon icon2, int n, int n2, String string) {
            super(icon);
            this.setBounds(n - 1, n2 + 1, icon.getIconWidth() + 2, icon.getIconHeight() + 1);
            this.setOpaque(true);
            this.setVisible(true);
            this.setBorderPainted(false);
            this.setBackground(Color.white);
            this.setFocusPainted(false);
            this.setToolTipText(string);
            if (icon2 != null) {
                this.setRolloverEnabled(true);
                this.setRolloverIcon(icon2);
            }
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ ToolbarButton this$1;
                {
                    this.this$1 = toolbarButton;
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    PanelToolbar.access$102(ToolbarButton.access$1500(this.this$1), System.currentTimeMillis());
                    PanelToolbar.access$202(ToolbarButton.access$1500(this.this$1), true);
                    if (PanelToolbar.access$300(ToolbarButton.access$1500(this.this$1))) {
                        PanelToolbar.access$400(ToolbarButton.access$1500(this.this$1));
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    PanelToolbar.access$102(ToolbarButton.access$1500(this.this$1), System.currentTimeMillis());
                    PanelToolbar.access$202(ToolbarButton.access$1500(this.this$1), false);
                    ToolbarButton.access$1500(this.this$1).hideToolbar();
                }
            });
        }

        static /* synthetic */ PanelToolbar access$1500(ToolbarButton toolbarButton) {
            return toolbarButton.PanelToolbar.this;
        }
    }

    protected class MenuButton
    extends JLabel {
        JPopupMenu m_menuDropdown;
        boolean m_bMouseInButton = false;
        PanelMenuButtons m_panelHost;

        protected MenuButton(PanelMenuButtons panelMenuButtons, String string, int n, JPopupMenu jPopupMenu) {
            super(string);
            this.m_menuDropdown = jPopupMenu;
            this.m_panelHost = panelMenuButtons;
            this.m_panelHost.addMenuButton(this);
            this.setBackground(Color.white);
            Graphics graphics = panelMenuButtons.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.dispose();
            char[] cArray = string.toCharArray();
            int n2 = fontMetrics.getHeight();
            int n3 = fontMetrics.charsWidth(cArray, 0, cArray.length) + 5;
            this.setBounds(n - 2, 20 - n2 - 3, n3 + 2, n2 + 1);
            this.setDoubleBuffered(true);
            this.setOpaque(true);
            this.setVisible(true);
            this.addMouseListener(new MouseAdapter(this, PanelToolbar.this){
                private final /* synthetic */ PanelToolbar val$this$0;
                private final /* synthetic */ MenuButton this$1;
                {
                    this.this$1 = menuButton;
                    this.val$this$0 = panelToolbar;
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$1.m_bMouseInButton = true;
                    PanelToolbar.access$202(MenuButton.access$1400(this.this$1), true);
                    this.this$1.m_panelHost.notifyMouseInMenuButton(this.this$1);
                    this.this$1.repaint();
                    PanelToolbar.access$102(MenuButton.access$1400(this.this$1), System.currentTimeMillis());
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    this.this$1.m_bMouseInButton = false;
                    PanelToolbar.access$202(MenuButton.access$1400(this.this$1), false);
                    this.this$1.repaint();
                    PanelToolbar.access$102(MenuButton.access$1400(this.this$1), System.currentTimeMillis());
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (!this.this$1.m_menuDropdown.isVisible()) {
                        MenuButton.access$1200(this.this$1);
                    }
                }
            });
            this.m_menuDropdown.addPopupMenuListener(new PopupMenuListener(this, PanelToolbar.this){
                private final /* synthetic */ PanelToolbar val$this$0;
                private final /* synthetic */ MenuButton this$1;
                {
                    this.this$1 = menuButton;
                    this.val$this$0 = panelToolbar;
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    this.this$1.repaint();
                    PanelToolbar.access$702(MenuButton.access$1400(this.this$1), false);
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    this.this$1.repaint();
                    PanelToolbar.access$702(MenuButton.access$1400(this.this$1), false);
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    PanelToolbar.access$702(MenuButton.access$1400(this.this$1), true);
                }
            });
        }

        private boolean isYourMenuVisible() {
            return this.m_menuDropdown.isVisible();
        }

        private void closeMenu() {
            this.m_menuDropdown.setVisible(false);
            this.repaint();
            PanelToolbar.this.m_bMenuDown = false;
            PanelToolbar.this.m_lTimeLastMouseEvent = System.currentTimeMillis();
        }

        private void showMenu() {
            this.m_menuDropdown.show(PanelToolbar.this, this.getLocation().x + PanelToolbar.this.m_nInnerPanelLeftOffset, this.getLocation().y + this.getHeight());
            PanelToolbar.this.m_bMenuDown = true;
            PanelToolbar.this.m_lTimeLastMouseEvent = System.currentTimeMillis();
        }

        public void paint(Graphics graphics) {
            Rectangle rectangle = this.getBounds();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            graphics.setFont(new Font("SansSerif", 0, 11));
            graphics.setColor(Color.black);
            String string = this.getText();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.drawString(this.getText(), 4, rectangle.height - fontMetrics.getDescent());
            if (this.m_bMouseInButton && !this.m_menuDropdown.isVisible()) {
                graphics.setColor(Color.lightGray);
                graphics.drawLine(0, 0, rectangle.width, 0);
                graphics.drawLine(0, 0, 0, rectangle.height);
                graphics.setColor(Color.darkGray);
                graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height);
                graphics.drawLine(0, rectangle.height - 1, rectangle.width, rectangle.height - 1);
            } else if (this.m_menuDropdown.isVisible()) {
                graphics.setColor(Color.darkGray);
                graphics.drawLine(0, 0, rectangle.width, 0);
                graphics.drawLine(0, 0, 0, rectangle.height);
                graphics.setColor(Color.lightGray);
                graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height);
            }
        }

        static /* synthetic */ PanelToolbar access$1400(MenuButton menuButton) {
            return menuButton.PanelToolbar.this;
        }
    }
}

