/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.util.OS;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.BrandNaming;
import com.avocent.video.GuiUtils;
import com.avocent.video.Help;
import com.avocent.video.Icons;
import com.avocent.video.IconsStingray;
import com.avocent.video.JDialogAbout;
import com.avocent.video.JDialogConnectedUsers;
import com.avocent.video.JDialogMacroGroups;
import com.avocent.video.JDialogMacros;
import com.avocent.video.JDialogMessage;
import com.avocent.video.JDialogPowerControl;
import com.avocent.video.JDialogSessionOptions;
import com.avocent.video.JPanelAppliance;
import com.avocent.video.KeyStroke;
import com.avocent.video.KeyboardMacro;
import com.avocent.video.KeyboardMacroGroup;
import com.avocent.video.MajorFunction;
import com.avocent.video.PanelToolbar;
import com.avocent.video.SessionManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;

public class PanelToolbarNormal
extends PanelToolbar {
    public static final String CNAME = "PanelToolbarNormal";
    static ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private static final int MENU_BUTTON_SPACING = 5;
    private static final String VIDEO_VIEWER_MACRO_EDITOR_KEY = "VideoViewerMacroEditor";
    private Image m_imageFullScreen = null;
    private Image m_imageCloseUp = null;
    private boolean m_bFileMenuSelected = false;
    private boolean m_bViewMenuSelected = false;
    private boolean m_bMacrosMenuSelected = false;
    private boolean m_bToolsMenuSelected = false;
    private boolean m_bHelpMenuSelected = false;
    private boolean m_bDisplayMacroEditor = true;
    private boolean m_bVirtualMediaLaunching = false;
    private JPanelAppliance m_appliancePanel;
    private String m_szHelpURL;
    private boolean m_bFullScreen = false;
    private JCheckBoxMenuItem m_cbMenuItemFullScreen;
    private PanelToolbar.JPopupMenuToolbar m_puMenuFile;
    private PanelToolbar.JPopupMenuToolbar m_puMenuView;
    private PanelToolbar.JPopupMenuToolbar m_puMenuMacros;
    private PanelToolbar.JPopupMenuToolbar m_puMenuTools;
    private PanelToolbar.JPopupMenuToolbar m_puMenuHelp;
    private JMenu m_cascadeMenuScale;
    private JMenu m_cascadeMenuColor;
    private JMenuItem m_miAutomaticVideoAdjust;
    private JMenuItem m_miManualVideoAdjust;
    private JMenuItem m_miSessionOptions;
    private JMenuItem m_miPowerControl;
    private JMenuItem m_miSingleCursorMode;
    private JMenuItem m_miVirtualMedia;
    private JMenuItem m_miConnectedUsers;
    private JCheckBoxMenuItem m_cbmiExclusiveMode;
    private int m_nSingleCursorModeToolbarButtonIndex = -1;
    private int m_nVirtualMediaToolbarButtonIndex = -1;
    private Icons m_icons;
    private MenuMacroActionListener m_menuMacroActionListener;
    private int m_nAutoVideoAdjustToolbarButtonIndex = -1;
    private int m_nManualVideoAdjustToolbarButtonIndex = -1;
    static /* synthetic */ Class class$com$avocent$video$PanelToolbar;
    static /* synthetic */ Class class$com$avocent$video$JFrameViewer;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$com$avocent$video$Icons;

    public PanelToolbarNormal(int n, int n2, int n3, Frame frame, int n4, JPanelAppliance jPanelAppliance, String string, ApplianceSession applianceSession, boolean bl, boolean bl2, int n5) {
        super(n, n2, n3, frame, n4, applianceSession, bl, bl2, n5);
        this.m_appliancePanel = jPanelAppliance;
        this.m_szHelpURL = string;
        this.m_icons = this.isStingray() ? new IconsStingray() : new Icons();
        this.m_imageFullScreen = this.getToolkit().createImage((class$com$avocent$video$PanelToolbar == null ? (class$com$avocent$video$PanelToolbar = PanelToolbarNormal.class$("com.avocent.video.PanelToolbar")) : class$com$avocent$video$PanelToolbar).getResource("images/full screen up.gif"));
        this.m_imageCloseUp = this.getToolkit().createImage((class$com$avocent$video$PanelToolbar == null ? (class$com$avocent$video$PanelToolbar = PanelToolbarNormal.class$("com.avocent.video.PanelToolbar")) : class$com$avocent$video$PanelToolbar).getResource("images/close up.gif"));
        MediaTracker mediaTracker = new MediaTracker(new Container());
        mediaTracker.addImage(this.m_imageFullScreen, 0);
        mediaTracker.addImage(this.m_imageCloseUp, 1);
        try {
            mediaTracker.waitForID(0);
            mediaTracker.waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_bDisplayMacroEditor = BrandNaming.getBoolean(VIDEO_VIEWER_MACRO_EDITOR_KEY, true) && !this.m_applianceSession.isPPPConnection() && !this.isStingray();
    }

    public PanelToolbarNormal(int n, int n2, int n3, JFrame jFrame, int n4, JPanelAppliance jPanelAppliance, String string, ApplianceSession applianceSession, boolean bl, boolean bl2, boolean bl3, int n5) {
        this(n, n2, n3, jFrame, n4, jPanelAppliance, string, applianceSession, bl, bl2, n5);
        this.m_bFullScreen = bl3;
    }

    private void displayMacrosDialog() {
        JDialogMacros jDialogMacros = new JDialogMacros(this.m_parent, this.m_appliancePanel.getApplianceSession(), this.m_szHelpURL);
        jDialogMacros.setModal(true);
        jDialogMacros.setVisible(true);
    }

    private void displayMacroGroupsDialog() {
        JDialogMacroGroups jDialogMacroGroups = new JDialogMacroGroups((Frame)((Object)this.m_applianceSession.getApplianceWindow()), this.m_applianceSession, this.m_szHelpURL);
        jDialogMacroGroups.setModal(true);
        jDialogMacroGroups.setVisible(true);
    }

    protected int createMenus(PanelToolbar.PanelMenuButtons panelMenuButtons, int n, Graphics graphics) {
        boolean bl;
        int n2 = n;
        this.m_menuMacroActionListener = new MenuMacroActionListener();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.logInfo((String)"VideoViewerTrace", (String)("PanelToolbarNormal menuMacroActionListener actionCommand:" + actionEvent.getActionCommand()));
                if (!PanelToolbarNormal.this.m_bDisplayMacroEditor) {
                    ApplianceSessionInfo applianceSessionInfo = PanelToolbarNormal.this.m_applianceSession.getPersistentData();
                    KeyboardMacroGroup[] keyboardMacroGroupArray = applianceSessionInfo.getMacroGroups(true, true);
                    for (int i = 0; i < keyboardMacroGroupArray.length; ++i) {
                        if (!actionEvent.getActionCommand().equalsIgnoreCase(keyboardMacroGroupArray[i].getName())) continue;
                        try {
                            applianceSessionInfo.setSelectedMacroGroup(keyboardMacroGroupArray[i]);
                            PanelToolbarNormal.this.m_applianceSession.setPersistentData(applianceSessionInfo);
                        }
                        catch (ExceptionRequestFailed exceptionRequestFailed) {
                            Trace.logError((String)"VideoViewerTrace", (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                        }
                        return;
                    }
                    KeyboardMacro keyboardMacro = applianceSessionInfo.getMacro(actionEvent.getActionCommand());
                    if (keyboardMacro != null) {
                        PanelToolbarNormal.this.m_applianceSession.cmdSendMacroKeystrokes(keyboardMacro);
                    }
                } else if (actionEvent.getActionCommand().equalsIgnoreCase(RES.getString("PanelToolbarNormal_Configure_Macros"))) {
                    PanelToolbarNormal.this.m_appliancePanel.setVideoQueueSleepTimeDeactivated();
                    JDialogMacros jDialogMacros = new JDialogMacros(PanelToolbarNormal.this.m_parent, PanelToolbarNormal.this.m_appliancePanel.getApplianceSession(), PanelToolbarNormal.this.m_szHelpURL);
                    jDialogMacros.setModal(true);
                    jDialogMacros.setVisible(true);
                    PanelToolbarNormal.this.m_appliancePanel.setVideoQueueSleepTimeActivated();
                } else if (actionEvent.getActionCommand().compareTo(RES.getString("PanelToolbarNormal_Configure_Macro_Groups")) == 0) {
                    JDialogMacroGroups jDialogMacroGroups = new JDialogMacroGroups((Frame)((Object)PanelToolbarNormal.this.m_applianceSession.getApplianceWindow()), PanelToolbarNormal.this.m_applianceSession, PanelToolbarNormal.this.m_szHelpURL);
                    jDialogMacroGroups.setModal(true);
                    jDialogMacroGroups.setVisible(true);
                } else {
                    ApplianceSessionInfo applianceSessionInfo = PanelToolbarNormal.this.m_applianceSession.getPersistentDataReference();
                    KeyboardMacro keyboardMacro = applianceSessionInfo.getMacro(actionEvent.getActionCommand());
                    if (keyboardMacro != null) {
                        PanelToolbarNormal.this.m_applianceSession.cmdSendMacroKeystrokes(keyboardMacro);
                    }
                }
            }
        };
        this.m_puMenuFile = new PanelToolbar.JPopupMenuToolbar(panelMenuButtons);
        this.m_puMenuFile.addPopupMenuListener(new ToolbarPopupMenuListener());
        MenuItemToolbar menuItemToolbar = new MenuItemToolbar(RES.getString("PanelToolbarNormal_CaptureToClipboard"), 4, 4, RES.getString("PanelToolbarNormal_CaptureToClipboard_Mnemonic"));
        menuItemToolbar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.logInfo((String)"VideoViewerTrace", (String)"PanelToolbarNormal capture to clipboard menu item action listener");
                PanelToolbarNormal.this.m_appliancePanel.setCursor(Cursor.getPredefinedCursor(3));
                GuiUtils guiUtils = new GuiUtils();
                guiUtils.captureToClipboard(PanelToolbarNormal.this.m_appliancePanel);
                PanelToolbarNormal.this.m_appliancePanel.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.m_puMenuFile.add(menuItemToolbar);
        menuItemToolbar.setEnabled(!OS.isLinux() && !OS.isSolaris());
        menuItemToolbar = new MenuItemToolbar(RES.getString("PanelToolbarNormal_CaptureToFile"), 3, 3, RES.getString("PanelToolbarNormal_CaptureToFile_Mnemonic"));
        menuItemToolbar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.logInfo((String)"VideoViewerTrace", (String)"PanelToolbarNormal capture to file menu item action listener");
                PanelToolbarNormal.this.m_appliancePanel.setCursor(Cursor.getPredefinedCursor(3));
                GuiUtils guiUtils = new GuiUtils();
                guiUtils.captureToFile(PanelToolbarNormal.this.m_appliancePanel);
                PanelToolbarNormal.this.m_appliancePanel.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.m_puMenuFile.add(menuItemToolbar);
        this.m_puMenuFile.addSeparator();
        menuItemToolbar = new MenuItemToolbar(RES.getString("PanelToolbarNormal_Exit"), new ImageIcon((class$com$avocent$video$JFrameViewer == null ? (class$com$avocent$video$JFrameViewer = PanelToolbarNormal.class$("com.avocent.video.JFrameViewer")) : class$com$avocent$video$JFrameViewer).getResource("images/clear.gif")), new ImageIcon((class$com$avocent$video$JFrameViewer == null ? (class$com$avocent$video$JFrameViewer = PanelToolbarNormal.class$("com.avocent.video.JFrameViewer")) : class$com$avocent$video$JFrameViewer).getResource("images/clear.gif")), RES.getString("PanelToolbarNormal_Exit_Mnemonic"));
        menuItemToolbar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                int n;
                Trace.logInfo((String)"VideoViewerTrace", (String)"PanelToolbarNormal exit menu item action listener");
                if (PanelToolbarNormal.this.m_applianceSession.isLockedMode() && !PanelToolbarNormal.this.m_applianceSession.isReserveModeActive() && (n = JOptionPane.showConfirmDialog(PanelToolbarNormal.this.m_parent, string = RES.getString("PanelToolbarNormal_DO_YOU_WANT_TO_CLOSE_THIS_SESSION_LOCK_WARNING"), RES.getString("PanelToolbarNormal_CLOSE_SESSION_REQUESTED"), 0, 3)) != 0) {
                    return;
                }
                PanelToolbarNormal.this.m_applianceSession.logEventSession(1);
                Trace.logInfo((String)"VideoViewerTrace", (String)"PanelToolbarNormal menu exit pressed, terminating session");
                PanelToolbarNormal.this.m_applianceSession.terminateSession();
            }
        });
        this.m_puMenuFile.add(menuItemToolbar);
        PanelToolbar.MenuButton menuButton = new PanelToolbar.MenuButton(panelMenuButtons, RES.getString("PanelToolbarNormal_File"), n2, this.m_puMenuFile);
        n2 += menuButton.getBounds().width + 5;
        this.m_puMenuView = new PanelToolbar.JPopupMenuToolbar(panelMenuButtons);
        this.m_puMenuView.addPopupMenuListener(new ToolbarPopupMenuListener());
        menuItemToolbar = new MenuItemToolbar(RES.getString("PanelToolbarNormal_Refresh"), 1, 1, RES.getString("PanelToolbarNormal_Refresh_Mnemonic"));
        menuItemToolbar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.logInfo((String)"VideoViewerTrace", (String)"PanelToolbarNormal refresh menu item action listener");
                try {
                    PanelToolbarNormal.this.m_applianceSession.cmdRefreshPane();
                }
                catch (IOException iOException) {
                    Trace.logError((String)"VideoViewerTrace", (String)"refresh error", (Throwable)iOException);
                }
            }
        });
        this.m_puMenuView.add(menuItemToolbar);
        String string = "       " + RES.getString("PanelToolbarNormal_Full_Screen");
        if (OS.isLinux() || OS.isSolaris()) {
            string = "   " + RES.getString("PanelToolbarNormal_Full_Screen");
        }
        this.m_cbMenuItemFullScreen = new JCheckBoxMenuItem(string);
        this.m_cbMenuItemFullScreen.setSelected(this.m_bFullScreen);
        String string2 = RES.getString("PanelToolbarNormal_Full_Screen_Mnemonic");
        if (string2 != null && string2.length() > 0) {
            this.m_cbMenuItemFullScreen.setMnemonic(string2.charAt(0));
        }
        this.m_cbMenuItemFullScreen.setBackground(Color.white);
        this.m_cbMenuItemFullScreen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(new Runnable(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        7.access$900(this.this$1).m_applianceSession.getApplianceWindow().fullScreenToggle();
                    }
                });
                thread.start();
                PanelToolbarNormal.this.m_cbMenuItemFullScreen.setSelected(!PanelToolbarNormal.this.m_cbMenuItemFullScreen.isSelected());
            }

            static /* synthetic */ PanelToolbarNormal access$900(7 var0) {
                return var0.PanelToolbarNormal.this;
            }
        });
        this.m_puMenuView.add(this.m_cbMenuItemFullScreen);
        this.m_puMenuView.addSeparator();
        this.m_cascadeMenuScale = new JMenu(RES.getString("PanelToolbarNormal_Manual_Scale"));
        this.m_cascadeMenuScale.setIcon(new ImageIcon((class$com$avocent$video$JFrameViewer == null ? (class$com$avocent$video$JFrameViewer = PanelToolbarNormal.class$("com.avocent.video.JFrameViewer")) : class$com$avocent$video$JFrameViewer).getResource("images/clear.gif")));
        string2 = RES.getString("PanelToolbarNormal_Manual_Scale_Mnemonic");
        if (string2 != null && string2.length() > 0) {
            this.m_cascadeMenuScale.setMnemonic(string2.charAt(0));
        }
        this.m_cascadeMenuScale.setBackground(Color.white);
        this.m_cascadeMenuScale.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuSelected(MenuEvent menuEvent) {
                Trace.logInfo((String)"VideoViewerTrace", (String)"PanelToolbarNormal.cascadeMenuManualScale menuSelected)");
                PanelToolbarNormal.this.setViewSizeMenuItems(PanelToolbarNormal.this.m_cascadeMenuScale);
            }
        });
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_Auto_Scale"));
        string2 = RES.getString("PanelToolbarNormal_Auto_Scale_Mnemonic");
        if (string2 != null && string2.length() > 0) {
            jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
        }
        jRadioButtonMenuItem.setBackground(Color.white);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 640;
                int n2 = 480;
                int n3 = 1;
                try {
                    ApplianceSessionInfo applianceSessionInfo = PanelToolbarNormal.this.m_applianceSession.getPersistentData();
                    applianceSessionInfo.setAutoScale(true);
                    applianceSessionInfo.setFullScale(false);
                    n = applianceSessionInfo.getPanedWidth();
                    n2 = applianceSessionInfo.getPanedHeight();
                    n3 = applianceSessionInfo.getDecimationFactor();
                    PanelToolbarNormal.this.m_applianceSession.setPersistentData(applianceSessionInfo);
                }
                catch (Exception exception) {
                    Trace.logError((String)"VideoViewerTrace", (String)"auto scale error", (Throwable)exception);
                }
            }
        });
        this.m_cascadeMenuScale.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_Full_Scale"));
        string2 = RES.getString("PanelToolbarNormal_Full_Scale_Mnemonic");
        if (string2 != null && string2.length() > 0) {
            jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
        }
        jRadioButtonMenuItem.setBackground(Color.white);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ApplianceSessionInfo applianceSessionInfo = PanelToolbarNormal.this.m_applianceSession.getPersistentData();
                if (applianceSessionInfo.getVideoHeight() != applianceSessionInfo.getPanedHeight() || applianceSessionInfo.getVideoWidth() != applianceSessionInfo.getPanedWidth()) {
                    // empty if block
                }
                try {
                    boolean bl = false;
                    applianceSessionInfo.setFullScale(true);
                    applianceSessionInfo.setAutoScale(false);
                    if (applianceSessionInfo.getVideoHeight() == applianceSessionInfo.getPanedHeight() && applianceSessionInfo.getVideoWidth() == applianceSessionInfo.getPanedWidth() && applianceSessionInfo.getDecimationFactor() > 1) {
                        applianceSessionInfo.setDecimationFactor(1);
                        bl = true;
                    } else if (applianceSessionInfo.getDecimationFactor() > 1) {
                        applianceSessionInfo.setDecimationFactor(1);
                    }
                    PanelToolbarNormal.this.m_applianceSession.setPersistentData(applianceSessionInfo);
                    PanelToolbarNormal.this.m_applianceSession.cmdFullScale();
                    if (bl) {
                        PanelToolbarNormal.this.m_applianceSession.cmdRefreshPane();
                    }
                }
                catch (Exception exception) {
                    Trace.logError((String)"VideoViewerTrace", (String)"full scale error", (Throwable)exception);
                }
            }
        });
        this.m_cascadeMenuScale.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_1024x768"));
        string2 = RES.getString("PanelToolbarNormal_1024x768_Mnemonic");
        if (string2 != null && string2.length() > 0) {
            jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
        }
        jRadioButtonMenuItem.setBackground(Color.white);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiUtils guiUtils = new GuiUtils();
                guiUtils.setScaling(PanelToolbarNormal.this.m_applianceSession, false, 1024, 768);
            }
        });
        this.m_cascadeMenuScale.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_960x720"));
        string2 = RES.getString("PanelToolbarNormal_960x720_Mnemonic");
        if (string2 != null && string2.length() > 0) {
            jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
        }
        jRadioButtonMenuItem.setBackground(Color.white);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiUtils guiUtils = new GuiUtils();
                guiUtils.setScaling(PanelToolbarNormal.this.m_applianceSession, false, 960, 720);
            }
        });
        this.m_cascadeMenuScale.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_896x672"));
        string2 = RES.getString("PanelToolbarNormal_896x672_Mnemonic");
        if (string2 != null && string2.length() > 0) {
            jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
        }
        jRadioButtonMenuItem.setBackground(Color.white);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiUtils guiUtils = new GuiUtils();
                guiUtils.setScaling(PanelToolbarNormal.this.m_applianceSession, false, 896, 672);
            }
        });
        this.m_cascadeMenuScale.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_832x624"));
        string2 = RES.getString("PanelToolbarNormal_832x624_Mnemonic");
        if (string2 != null && string2.length() > 0) {
            jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
        }
        jRadioButtonMenuItem.setBackground(Color.white);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiUtils guiUtils = new GuiUtils();
                guiUtils.setScaling(PanelToolbarNormal.this.m_applianceSession, false, 832, 624);
            }
        });
        this.m_cascadeMenuScale.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_768x576"));
        string2 = RES.getString("PanelToolbarNormal_768x576_Mnemonic");
        if (string2 != null && string2.length() > 0) {
            jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
        }
        jRadioButtonMenuItem.setBackground(Color.white);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiUtils guiUtils = new GuiUtils();
                guiUtils.setScaling(PanelToolbarNormal.this.m_applianceSession, false, 768, 576);
            }
        });
        this.m_cascadeMenuScale.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_704x528"));
        string2 = RES.getString("PanelToolbarNormal_704x528_Mnemonic");
        if (string2 != null && string2.length() > 0) {
            jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
        }
        jRadioButtonMenuItem.setBackground(Color.white);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiUtils guiUtils = new GuiUtils();
                guiUtils.setScaling(PanelToolbarNormal.this.m_applianceSession, false, 704, 528);
            }
        });
        this.m_cascadeMenuScale.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_640x480"));
        string2 = RES.getString("PanelToolbarNormal_640x480_Mnemonic");
        if (string2 != null && string2.length() > 0) {
            jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
        }
        jRadioButtonMenuItem.setBackground(Color.white);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiUtils guiUtils = new GuiUtils();
                guiUtils.setScaling(PanelToolbarNormal.this.m_applianceSession, false, 640, 480);
            }
        });
        this.m_cascadeMenuScale.add(jRadioButtonMenuItem);
        this.m_puMenuView.add(this.m_cascadeMenuScale);
        this.m_cascadeMenuColor = new JMenu(RES.getString("PanelToolbarNormal_Color"));
        this.m_cascadeMenuColor.setIcon(new ImageIcon((class$com$avocent$video$JFrameViewer == null ? (class$com$avocent$video$JFrameViewer = PanelToolbarNormal.class$("com.avocent.video.JFrameViewer")) : class$com$avocent$video$JFrameViewer).getResource("images/clear.gif")));
        string2 = RES.getString("PanelToolbarNormal_Color_Mnemonic");
        if (string2 != null && string2.length() > 0) {
            this.m_cascadeMenuColor.setMnemonic(string2.charAt(0));
        }
        this.m_cascadeMenuColor.setBackground(Color.white);
        this.m_cascadeMenuColor.setEnabled(this.m_applianceSession.areScalingControlsEnabled());
        this.m_cascadeMenuColor.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuSelected(MenuEvent menuEvent) {
                Trace.logInfo((String)"VideoViewerTrace", (String)"PanelToolbarNormal.cascadeMenuColor menuSelected)");
                PanelToolbarNormal.this.setViewColorMenuItems(PanelToolbarNormal.this.m_cascadeMenuColor);
            }
        });
        if (!this.isNEC()) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_Color15Bit"));
            string2 = RES.getString("PanelToolbarNormal_Color15Bit_Mnemonic");
            if (string2 != null && string2.length() > 0) {
                jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
            }
            jRadioButtonMenuItem.setBackground(Color.white);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ApplianceSessionInfo applianceSessionInfo = PanelToolbarNormal.this.m_applianceSession.getPersistentDataReference();
                        PanelToolbarNormal.this.m_applianceSession.cmdVideoSetColorDepth(15, applianceSessionInfo.isBackgroundRefresh());
                    }
                    catch (IOException iOException) {
                        Trace.logError((String)"VideoViewerTrace", (String)iOException.getMessage(), (Throwable)iOException);
                    }
                }
            });
            this.m_cascadeMenuColor.add(jRadioButtonMenuItem);
        }
        if (!this.isNEC()) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_Color12Bit"));
            string2 = RES.getString("PanelToolbarNormal_Color12Bit_Mnemonic");
            if (string2 != null && string2.length() > 0) {
                jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
            }
            jRadioButtonMenuItem.setBackground(Color.white);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ApplianceSessionInfo applianceSessionInfo = PanelToolbarNormal.this.m_applianceSession.getPersistentDataReference();
                        PanelToolbarNormal.this.m_applianceSession.cmdVideoSetColorDepth(12, applianceSessionInfo.isBackgroundRefresh());
                    }
                    catch (IOException iOException) {
                        Trace.logError((String)"VideoViewerTrace", (String)iOException.getMessage(), (Throwable)iOException);
                    }
                }
            });
            this.m_cascadeMenuColor.add(jRadioButtonMenuItem);
        }
        if (!this.isNEC()) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_Color9Bit"));
            string2 = RES.getString("PanelToolbarNormal_Color9Bit_Mnemonic");
            if (string2 != null && string2.length() > 0) {
                jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
            }
        } else {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_Color"));
            string2 = RES.getString("PanelToolbarNormal_Color_Mnemonic");
            if (string2 != null && string2.length() > 0) {
                jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
            }
        }
        jRadioButtonMenuItem.setBackground(Color.white);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ApplianceSessionInfo applianceSessionInfo = PanelToolbarNormal.this.m_applianceSession.getPersistentDataReference();
                    PanelToolbarNormal.this.m_applianceSession.cmdVideoSetColorDepth(9, applianceSessionInfo.isBackgroundRefresh());
                }
                catch (IOException iOException) {
                    Trace.logError((String)"VideoViewerTrace", (String)iOException.getMessage(), (Throwable)iOException);
                }
            }
        });
        this.m_cascadeMenuColor.add(jRadioButtonMenuItem);
        if (!this.isNEC()) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_ColorGrayScale"));
            string2 = RES.getString("PanelToolbarNormal_ColorGrayScale_Mnemonic");
            if (string2 != null && string2.length() > 0) {
                jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
            }
        } else {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(RES.getString("PanelToolbarNormal_Gray_Scale"));
            string2 = RES.getString("PanelToolbarNormal_Gray_Scale_Mnemonic");
            if (string2 != null && string2.length() > 0) {
                jRadioButtonMenuItem.setMnemonic(string2.charAt(0));
            }
        }
        jRadioButtonMenuItem.setBackground(Color.white);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ApplianceSessionInfo applianceSessionInfo = PanelToolbarNormal.this.m_applianceSession.getPersistentDataReference();
                    PanelToolbarNormal.this.m_applianceSession.cmdVideoSetColorDepth(3, applianceSessionInfo.isBackgroundRefresh());
                }
                catch (IOException iOException) {
                    Trace.logError((String)"VideoViewerTrace", (String)iOException.getMessage(), (Throwable)iOException);
                }
            }
        });
        this.m_cascadeMenuColor.add(jRadioButtonMenuItem);
        this.m_puMenuView.add(this.m_cascadeMenuColor);
        this.m_puMenuView.addSeparator();
        this.m_miConnectedUsers = new MenuItemToolbar(RES.getString("PanelToolbarNormal_ConnectedUsers"), 5, 5, RES.getString("PanelToolbarNormal_ConnectedUsers_Mnemonic"));
        this.m_miConnectedUsers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if ((OS.isLinux() || OS.isSolaris()) && PanelToolbarNormal.this.m_bFullScreen) {
                    object = new Thread(new Runnable(this){
                        private final /* synthetic */ 24 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            Trace.logInfo((String)"VideoViewerTrace", (String)"Display message");
                            JDialogMessage jDialogMessage = new JDialogMessage(null, false);
                            jDialogMessage.setModal(false);
                            jDialogMessage.setVisible(false);
                            jDialogMessage.dispose();
                        }
                    });
                    ((Thread)object).start();
                }
                object = new JDialogConnectedUsers((Frame)((Object)PanelToolbarNormal.this.m_applianceSession.getApplianceWindow()), PanelToolbarNormal.this.m_applianceSession, PanelToolbarNormal.this.m_szHelpURL);
                object.setModal(true);
                ((JDialogConnectedUsers)object).setVisible(true);
            }
        });
        this.m_puMenuView.add(this.m_miConnectedUsers);
        menuButton = new PanelToolbar.MenuButton(panelMenuButtons, RES.getString("PanelToolbarNormal_View"), n2, this.m_puMenuView);
        this.m_puMenuMacros = new PanelToolbar.JPopupMenuToolbar(panelMenuButtons);
        this.m_puMenuMacros.addPopupMenuListener(new ToolbarPopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                Serializable serializable;
                Serializable serializable2;
                JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
                jPopupMenu.removeAll();
                ApplianceSessionInfo applianceSessionInfo = PanelToolbarNormal.this.m_applianceSession.getPersistentDataReference();
                KeyboardMacroGroup keyboardMacroGroup = applianceSessionInfo.getSelectedMacroGroup();
                if (keyboardMacroGroup != null) {
                    serializable2 = PanelToolbarNormal.this.m_applianceSession.getPersistentDataReference();
                    for (int i = 0; i < keyboardMacroGroup.size(); ++i) {
                        serializable = ((ApplianceSessionInfo)serializable2).getMacro(keyboardMacroGroup.getMacroInGroup(i));
                        if (serializable != null) {
                            MenuItemToolbar menuItemToolbar = ((KeyboardMacro)serializable).getIconIndex() >= 0 ? new MenuItemToolbar(((KeyboardMacro)serializable).getName(), ((KeyboardMacro)serializable).getIconIndex(), ((KeyboardMacro)serializable).getIconIndex(), "") : new MenuItemToolbar(((KeyboardMacro)serializable).getName(), new ImageIcon((class$com$avocent$video$JFrameViewer == null ? PanelToolbarNormal.class$("com.avocent.video.JFrameViewer") : class$com$avocent$video$JFrameViewer).getResource("images/clear.gif")), new ImageIcon((class$com$avocent$video$JFrameViewer == null ? PanelToolbarNormal.class$("com.avocent.video.JFrameViewer") : class$com$avocent$video$JFrameViewer).getResource("images/clear.gif")), "");
                            menuItemToolbar.addActionListener(PanelToolbarNormal.this.m_menuMacroActionListener);
                            menuItemToolbar.setActionCommand(((KeyboardMacro)serializable).getID());
                            menuItemToolbar.setEnabled(!PanelToolbarNormal.this.m_applianceSession.isStealthConnection() && !PanelToolbarNormal.this.m_applianceSession.isPassiveConnection());
                            jPopupMenu.add(menuItemToolbar);
                            continue;
                        }
                        Trace.logInfo((String)"VideoViewerTrace", (String)("keyboard macro null, macro group=" + keyboardMacroGroup.getName() + " nCnt=" + i + " ID=" + keyboardMacroGroup.getMacroIDs()[i]));
                    }
                }
                jPopupMenu.addSeparator();
                if (!PanelToolbarNormal.this.m_bDisplayMacroEditor) {
                    serializable2 = new JMenu(RES.getString("PanelToolbarNormal_Display_On_Menu"));
                    ((JComponent)serializable2).setBackground(Color.white);
                    KeyboardMacroGroup[] keyboardMacroGroupArray = applianceSessionInfo.getMacroGroups(true, true);
                    serializable = applianceSessionInfo.getSelectedMacroGroup();
                    for (int i = 0; i < keyboardMacroGroupArray.length; ++i) {
                        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(keyboardMacroGroupArray[i].getName());
                        jRadioButtonMenuItem.setBackground(Color.white);
                        jRadioButtonMenuItem.addActionListener(PanelToolbarNormal.this.m_menuMacroActionListener);
                        jRadioButtonMenuItem.setActionCommand(keyboardMacroGroupArray[i].getName());
                        ((JMenu)serializable2).add(jRadioButtonMenuItem);
                        if (!keyboardMacroGroupArray[i].getName().equalsIgnoreCase(((KeyboardMacroGroup)serializable).getName())) continue;
                        jRadioButtonMenuItem.setSelected(true);
                    }
                    jPopupMenu.add((JMenuItem)serializable2);
                } else {
                    serializable2 = new JMenu(RES.getString("PanelToolbarNormal_Configure"));
                    ((JComponent)serializable2).setBackground(Color.white);
                    JMenuItem jMenuItem = new JMenuItem(RES.getString("PanelToolbarNormal_Configure_Macros"));
                    jMenuItem.setIcon(PanelToolbarNormal.this.m_icons.getIcon(6));
                    jMenuItem.setBackground(Color.white);
                    jMenuItem.addActionListener(PanelToolbarNormal.this.m_menuMacroActionListener);
                    jMenuItem.setActionCommand(RES.getString("PanelToolbarNormal_Configure_Macros"));
                    ((JMenu)serializable2).add(jMenuItem);
                    jMenuItem = new JMenuItem(RES.getString("PanelToolbarNormal_Configure_Macro_Groups"));
                    jMenuItem.setIcon(PanelToolbarNormal.this.m_icons.getIcon(7));
                    jMenuItem.setBackground(Color.white);
                    jMenuItem.addActionListener(PanelToolbarNormal.this.m_menuMacroActionListener);
                    jMenuItem.setActionCommand(RES.getString("PanelToolbarNormal_Configure_Macro_Groups"));
                    ((JMenu)serializable2).add(jMenuItem);
                    jPopupMenu.add((JMenuItem)serializable2);
                }
                super.popupMenuWillBecomeVisible(popupMenuEvent);
            }
        });
        menuButton = new PanelToolbar.MenuButton(panelMenuButtons, RES.getString("PanelToolbarNormal_Macros"), n2 += menuButton.getBounds().width + 5, this.m_puMenuMacros);
        n2 += menuButton.getBounds().width + 5;
        this.m_puMenuTools = new PanelToolbar.JPopupMenuToolbar(panelMenuButtons);
        this.m_puMenuTools.addPopupMenuListener(new ToolbarPopupMenuListener());
        this.m_miAutomaticVideoAdjust = new MenuItemToolbar(RES.getString("PanelToolbarNormal_Automatic_Video_Adjust"), 8, 8, RES.getString("PanelToolbarNormal_Automatic_Video_Adjust_Mnemonic"));
        this.m_miAutomaticVideoAdjust.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PanelToolbarNormal.this.m_applianceSession.cmdAutoAdjustVideo();
                }
                catch (IOException iOException) {
                    Trace.logError((String)"VideoViewerTrace", (String)"Automatic video adjust error", (Throwable)iOException);
                }
            }
        });
        this.m_puMenuTools.add(this.m_miAutomaticVideoAdjust);
        this.m_miManualVideoAdjust = new MenuItemToolbar(RES.getString("PanelToolbarNormal_Manual_Video_Adjust_"), 9, 9, RES.getString("PanelToolbarNormal_Manual_Video_Adjust_Mnemonic"));
        this.m_miManualVideoAdjust.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelToolbarNormal.this.m_appliancePanel.setVideoQueueSleepTimeDeactivated();
                if (PanelToolbarNormal.this.m_nSingleCursorModeToolbarButtonIndex >= 0) {
                    PanelToolbarNormal.this.m_aToolbarButtons[PanelToolbarNormal.this.m_nSingleCursorModeToolbarButtonIndex].setEnabled(false);
                }
                if ((OS.isLinux() || OS.isSolaris()) && PanelToolbarNormal.this.m_bFullScreen) {
                    Thread thread = new Thread(new Runnable(this){
                        private final /* synthetic */ 28 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            Trace.logInfo((String)"VideoViewerTrace", (String)"Display message");
                            JDialogMessage jDialogMessage = new JDialogMessage(null, false);
                            jDialogMessage.setModal(false);
                            jDialogMessage.setVisible(false);
                            jDialogMessage.dispose();
                        }
                    });
                    thread.start();
                }
                PanelToolbarNormal.this.m_applianceSession.displayManualVideoAdjustDlg();
                PanelToolbarNormal.this.m_appliancePanel.setVideoQueueSleepTimeActivated();
            }
        });
        this.m_puMenuTools.add(this.m_miManualVideoAdjust);
        this.m_puMenuTools.addSeparator();
        this.m_miSessionOptions = new MenuItemToolbar(RES.getString("PanelToolbarNormal_Session_Options_"), 10, 10, RES.getString("PanelToolbarNormal_Session_Options_Mnemonic"));
        this.m_miSessionOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelAppliance jPanelAppliance = PanelToolbarNormal.this.m_appliancePanel;
                jPanelAppliance.setVideoQueueSleepTimeDeactivated();
                PanelToolbarNormal.this.doSessionOptions();
                jPanelAppliance.setVideoQueueSleepTimeActivated();
            }
        });
        this.m_puMenuTools.add(this.m_miSessionOptions);
        this.m_miPowerControl = new MenuItemToolbar(RES.getString("PanelToolbarNormal_Power_Control"), 11, 11, RES.getString("PanelToolbarNormal_Power_Control_Mnemonic"));
        if (!(this.isNEC() || this.isNautilus() || this.isStingray())) {
            this.m_puMenuTools.addSeparator();
            this.m_miPowerControl.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JDialogPowerControl jDialogPowerControl = new JDialogPowerControl(PanelToolbarNormal.this.m_parent, PanelToolbarNormal.this.m_applianceSession);
                    jDialogPowerControl.setModal(true);
                    jDialogPowerControl.setVisible(true);
                }
            });
            this.m_puMenuTools.add(this.m_miPowerControl);
        }
        this.m_puMenuTools.addSeparator();
        this.m_miSingleCursorMode = new MenuItemToolbar(RES.getString("PanelToolbarNormal_Single_Cursor_Mode"), 2, 2, RES.getString("PanelToolbarNormal_Single_Cursor_Mode_Mnemonic"));
        this.m_miSingleCursorMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelToolbarNormal.this.m_applianceSession.getApplianceWindow().activateSingleCursorMode(true);
            }
        });
        this.m_puMenuTools.add(this.m_miSingleCursorMode);
        boolean bl2 = bl = !this.isNEC() && !this.isStingray();
        if (bl) {
            bl = !BrandNaming.getString("VirtualMediaSupport", "true").equalsIgnoreCase("false");
        }
        this.m_miVirtualMedia = new MenuItemToolbar(RES.getString("PanelToolbarNormal_Virtual_Media"), 64, 64, RES.getString("PanelToolbarNormal_Virtual_Media_Mnemonic"));
        if (bl) {
            this.m_puMenuTools.addSeparator();
            this.m_miVirtualMedia.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PanelToolbarNormal.this.launchVirtualMedia();
                }
            });
            this.m_puMenuTools.add(this.m_miVirtualMedia);
        }
        this.m_cbmiExclusiveMode = new JCheckBoxMenuItem("        " + RES.getString("PanelToolbarNormal_Exclusive_Mode"));
        if (this.isNautilus()) {
            this.m_puMenuTools.addSeparator();
            string2 = RES.getString("PanelToolbarNormal_Exclusive_Mode_Mnemonic");
            if (string2 != null && string2.length() > 0) {
                this.m_cbmiExclusiveMode.setMnemonic(string2.charAt(0));
            }
            this.m_cbmiExclusiveMode.setBackground(Color.white);
            this.m_cbmiExclusiveMode.setSelected(this.m_applianceSession.getConnectionType() == 2);
            this.m_cbmiExclusiveMode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    if (PanelToolbarNormal.this.m_cbmiExclusiveMode.isSelected() && PanelToolbarNormal.this.m_applianceSession.isConnectionShared() && (n = JOptionPane.showConfirmDialog(PanelToolbarNormal.this.m_parent, RES.getString("PanelToolbarNormal_EXCLUSIVE_MODE_WILL_PREEMPT_OTHERS_CONTINUE"), RES.getString("PanelToolbarNormal_SESSION_BEING_SHARED"), 0, 1)) != 0) {
                        PanelToolbarNormal.this.m_cbmiExclusiveMode.setSelected(false);
                        return;
                    }
                    try {
                        PanelToolbarNormal.this.m_applianceSession.cmdExclusiveMode(PanelToolbarNormal.this.m_cbmiExclusiveMode.isSelected());
                    }
                    catch (IOException iOException) {
                        Trace.logError((String)"VideoViewerTrace", (String)iOException.getMessage(), (Throwable)iOException);
                    }
                }
            });
            this.m_puMenuTools.add(this.m_cbmiExclusiveMode);
        }
        menuButton = new PanelToolbar.MenuButton(panelMenuButtons, RES.getString("PanelToolbarNormal_Tools"), n2, this.m_puMenuTools);
        n2 += menuButton.getBounds().width + 5;
        this.m_puMenuHelp = new PanelToolbar.JPopupMenuToolbar(panelMenuButtons);
        this.m_puMenuHelp.addPopupMenuListener(new ToolbarPopupMenuListener());
        menuItemToolbar = new MenuItemToolbar(RES.getString("PanelToolbarNormal_About_DS_Video_Viewer"), -1, -1, RES.getString("PanelToolbarNormal_About_DS_Video_Viewer_Mnemonic"));
        menuItemToolbar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelToolbarNormal.this.m_appliancePanel.setVideoQueueSleepTimeDeactivated();
                JDialogAbout jDialogAbout = new JDialogAbout(PanelToolbarNormal.this.m_parent, "", true, PanelToolbarNormal.this.m_applianceSession);
                jDialogAbout.setVisible(true);
                PanelToolbarNormal.this.m_appliancePanel.setVideoQueueSleepTimeActivated();
            }
        });
        this.m_puMenuHelp.add(menuItemToolbar);
        if (this.m_szHelpURL != null && this.m_szHelpURL.length() > 0) {
            menuItemToolbar = new MenuItemToolbar(RES.getString("PanelToolbarNormal_Contents_and_Index"), -1, -1, RES.getString("PanelToolbarNormal_Contents_and_Index_Mnemonic"));
            menuItemToolbar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Help.launchHelp(PanelToolbarNormal.this.m_szHelpURL, "IDH_HELP_CONTENTS_AND_INDEX");
                }
            });
            this.m_puMenuHelp.add(menuItemToolbar);
        }
        menuButton = new PanelToolbar.MenuButton(panelMenuButtons, RES.getString("PanelToolbarNormal_Help"), n2, this.m_puMenuHelp);
        return n2 += menuButton.getSize().width + 10;
    }

    private void launchVirtualMedia() {
        Object object;
        if ((OS.isLinux() || OS.isSolaris()) && this.m_bFullScreen) {
            object = new Thread(new Runnable(){

                public void run() {
                    Trace.logInfo((String)"VideoViewerTrace", (String)"Display message of Virtual Media");
                    JDialogMessage jDialogMessage = new JDialogMessage(null, RES.getString("PanelToolbarNormal_VIRTUAL_MEDIA_FULL_SCREEN"), PanelToolbarNormal.this.m_applianceSession.getDeviceID(), false, "");
                    jDialogMessage.setModal(false);
                    jDialogMessage.setVisible(false);
                    jDialogMessage.dispose();
                }
            });
            ((Thread)object).start();
        }
        if (!SessionManager.isThisVMDeviceIDSessionRunning(this.m_applianceSession.getDeviceID(), true) && !this.m_bVirtualMediaLaunching) {
            this.m_bVirtualMediaLaunching = true;
            object = this.m_applianceSession.getLaunchProperties();
            if (object != null) {
                Object object2;
                final String[] stringArray = new String[((Properties)object).size() + 3];
                Enumeration<Object> enumeration = ((Properties)object).keys();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    object2 = (String)enumeration.nextElement();
                    if (((String)object2).equalsIgnoreCase("viewerType")) {
                        object2 = (String)object2 + "=virtualMedia";
                    } else if (((String)object2).equalsIgnoreCase("tdid")) {
                        object2 = (String)object2 + "=" + this.m_applianceSession.getDeviceID();
                    } else if (((String)object2).equalsIgnoreCase("tdnames") || ((String)object2).equalsIgnoreCase("title")) {
                        object2 = (String)object2 + "=" + this.m_applianceSession.getApplianceName();
                    } else if (((String)object2).equalsIgnoreCase("path")) {
                        String string = "a:" + this.m_applianceSession.getApplianceIP();
                        string = this.m_applianceSession.getRipID().length() > 0 ? string + ",r:" + this.m_applianceSession.getRipID() : string + ",p:" + this.m_applianceSession.getAppliancePort();
                        string = string + ",d:" + this.m_applianceSession.getDeviceID() + ",s:\"" + this.m_applianceSession.getApplianceName() + "\",e:" + this.m_applianceSession.isApcp() + ",l:" + this.m_applianceSession.getLoginTimeOut();
                        object2 = (String)object2 + "=" + string;
                    } else {
                        object2 = (String)object2 + "=" + (String)((Properties)object).get(object2);
                    }
                    Trace.logInfo((String)"VideoViewerTrace", (String)("launchVirtualMedia szArg=" + (String)object2));
                    stringArray[n++] = object2;
                }
                stringArray[n++] = "client_random=" + this.m_applianceSession.getClientRandomNumber();
                stringArray[n++] = "appliance_random=" + this.m_applianceSession.getApplianceRandomNumber();
                stringArray[n++] = "encrypt_vm_non_cert=" + (this.m_applianceSession.getEncryptVirtualMedia() ? "true" : "false");
                object2 = new Thread(new Runnable(){

                    public void run() {
                        try {
                            Class<?> clazz = Class.forName("com.avocent.vm.VirtualMedia");
                            Class[] classArray = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = PanelToolbarNormal.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
                            Method method = clazz.getMethod("main", classArray);
                            method.invoke(null, new Object[]{stringArray});
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            PanelToolbarNormal.this.m_bVirtualMediaLaunching = false;
                        }
                        catch (Exception exception) {
                            Trace.logError((String)"VideoViewerTrace", (String)exception.getMessage(), (Throwable)exception);
                        }
                    }
                });
                ((Thread)object2).start();
            }
        }
    }

    protected int getNumberToolbarButtons() {
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
        KeyboardMacro[] keyboardMacroArray = applianceSessionInfo.getMacros(true, true);
        int n = 0;
        for (int i = 0; i < keyboardMacroArray.length; ++i) {
            if (!keyboardMacroArray[i].isMacroOnToolbar()) continue;
            ++n;
        }
        MajorFunction[] majorFunctionArray = applianceSessionInfo.getMajorFunctions(true);
        int n2 = majorFunctionArray.length + n + (this.m_bFullScreen ? 2 : 0);
        if (!this.isNEC() && !this.isGlacierD()) {
            ++n2;
        }
        return n2;
    }

    protected int createTitle(PanelToolbar.PanelMenuButtons panelMenuButtons, int n, Graphics graphics) {
        if (this.m_bFullScreen) {
            Object[] objectArray;
            Object object;
            Serializable serializable;
            String string = this.m_applianceSession.getTitle();
            if (this.m_applianceSession.getApplianceWindow().isSingleCursorActive()) {
                serializable = new KeyStroke(2, 67, RES.getString("PanelToolbarNormal_KEYCAP_F10"));
                object = this.m_applianceSession.getPersistentDataReference();
                try {
                    serializable = ((ApplianceSessionInfo)object).getSingleCursorTerminateKey();
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)"VideoViewerTrace", (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                }
                objectArray = new Object[]{((KeyStroke)serializable).toString()};
                String string2 = MessageFormat.format(RES.getString("PanelToolbarNormal_Single_Mouse_Caption_Addition"), objectArray);
                string = string + string2;
            }
            serializable = graphics.getFontMetrics();
            object = ((FontMetrics)serializable).getStringBounds(string, graphics);
            objectArray = new JLabel(string);
            objectArray.setBounds(n + 5, 5, (int)((RectangularShape)object).getWidth(), (int)((RectangularShape)object).getHeight());
            objectArray.setVisible(true);
            panelMenuButtons.add((Component)objectArray);
            int n2 = n + 5 + (int)((RectangularShape)object).getWidth() + 5;
            PanelToolbar.PanelSeparator panelSeparator = new PanelToolbar.PanelSeparator(n2, 20);
            panelMenuButtons.add(panelSeparator);
            return (n2 += panelSeparator.getBounds().width) + 10;
        }
        return n;
    }

    protected int createToolbarButtons(JPanel jPanel, int n, int n2, Graphics graphics) {
        int n3;
        int n4 = n;
        Vector vector = new Vector();
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
        KeyboardMacro[] keyboardMacroArray = applianceSessionInfo.getMacros(true, true);
        int n5 = 0;
        for (int i = 0; i < keyboardMacroArray.length; ++i) {
            if (!keyboardMacroArray[i].isMacroOnToolbar()) continue;
            ++n5;
        }
        MajorFunction[] majorFunctionArray = applianceSessionInfo.getMajorFunctions(true);
        this.m_aToolbarButtons = new PanelToolbar.ToolbarButton[majorFunctionArray.length + n5 + (this.m_bFullScreen ? 2 : 0)];
        for (int i = 0; i < majorFunctionArray.length; ++i) {
            switch (majorFunctionArray[i].getFunctionCode()) {
                case 0: {
                    this.m_aToolbarButtons[i] = new PanelToolbar.ToolbarButton(this.m_icons.getIcon(majorFunctionArray[i].getIconIndex()), this.m_icons.getRolloverIcon(majorFunctionArray[i].getIconIndex()), n4, n2, RES.getString("PanelToolbarNormal_Align_Mouse"));
                    this.m_aToolbarButtons[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                PanelToolbarNormal.this.m_applianceSession.cmdMouseAlign();
                            }
                            catch (IOException iOException) {
                                Trace.logError((String)"VideoViewerTrace", (String)iOException.getMessage(), (Throwable)iOException);
                            }
                        }
                    });
                    this.m_aToolbarButtons[i].setEnabled(!this.m_applianceSession.isPassiveConnection() && !this.m_applianceSession.isStealthConnection());
                    break;
                }
                case 8: {
                    this.m_nAutoVideoAdjustToolbarButtonIndex = i;
                    this.m_aToolbarButtons[i] = new PanelToolbar.ToolbarButton(this.m_icons.getIcon(majorFunctionArray[i].getIconIndex()), this.m_icons.getRolloverIcon(majorFunctionArray[i].getIconIndex()), n4, n2, RES.getString("PanelToolbarNormal_Automatic_Video_Adjust"));
                    this.m_aToolbarButtons[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                PanelToolbarNormal.this.m_applianceSession.cmdAutoAdjustVideo();
                            }
                            catch (IOException iOException) {
                                Trace.logError((String)"VideoViewerTrace", (String)"Automatic video adjust error", (Throwable)iOException);
                            }
                        }
                    });
                    this.m_aToolbarButtons[i].setEnabled(!this.m_applianceSession.isPassiveConnection() && !this.m_applianceSession.isStealthConnection() && this.m_applianceSession.areScalingControlsEnabled());
                    break;
                }
                case 4: {
                    this.m_aToolbarButtons[i] = new PanelToolbar.ToolbarButton(this.m_icons.getIcon(majorFunctionArray[i].getIconIndex()), this.m_icons.getRolloverIcon(majorFunctionArray[i].getIconIndex()), n4, n2, RES.getString("PanelToolbarNormal_CaptureToClipboard"));
                    this.m_aToolbarButtons[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            PanelToolbarNormal.this.m_appliancePanel.requestDefaultFocus();
                            PanelToolbarNormal.this.setCursor(Cursor.getPredefinedCursor(3));
                            GuiUtils guiUtils = new GuiUtils();
                            guiUtils.captureToClipboard(PanelToolbarNormal.this.m_appliancePanel);
                            PanelToolbarNormal.this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    });
                    break;
                }
                case 3: {
                    this.m_aToolbarButtons[i] = new PanelToolbar.ToolbarButton(this.m_icons.getIcon(majorFunctionArray[i].getIconIndex()), this.m_icons.getRolloverIcon(majorFunctionArray[i].getIconIndex()), n4, n2, RES.getString("PanelToolbarNormal_CaptureToFile_"));
                    this.m_aToolbarButtons[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            PanelToolbarNormal.this.m_appliancePanel.requestDefaultFocus();
                            PanelToolbarNormal.this.setCursor(Cursor.getPredefinedCursor(3));
                            GuiUtils guiUtils = new GuiUtils();
                            guiUtils.captureToFile(PanelToolbarNormal.this.m_appliancePanel);
                            PanelToolbarNormal.this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    });
                    break;
                }
                case 5: {
                    if (this.isStingray()) break;
                    this.m_aToolbarButtons[i] = new PanelToolbar.ToolbarButton(this.m_icons.getIcon(majorFunctionArray[i].getIconIndex()), this.m_icons.getRolloverIcon(majorFunctionArray[i].getIconIndex()), n4, n2, RES.getString("PanelToolbarNormal_ConnectedUsers_"));
                    this.m_aToolbarButtons[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Object object;
                            if ((OS.isLinux() || OS.isSolaris()) && PanelToolbarNormal.this.m_bFullScreen) {
                                object = new Thread(new Runnable(this){
                                    private final /* synthetic */ 43 this$1;
                                    {
                                        this.this$1 = var1_1;
                                    }

                                    public void run() {
                                        Trace.logInfo((String)"VideoViewerTrace", (String)"Display message");
                                        JDialogMessage jDialogMessage = new JDialogMessage(null, false);
                                        jDialogMessage.setModal(false);
                                        jDialogMessage.setVisible(false);
                                        jDialogMessage.dispose();
                                    }
                                });
                                ((Thread)object).start();
                            }
                            object = new JDialogConnectedUsers((Frame)((Object)PanelToolbarNormal.this.m_applianceSession.getApplianceWindow()), PanelToolbarNormal.this.m_applianceSession, PanelToolbarNormal.this.m_szHelpURL);
                            object.setModal(true);
                            ((JDialogConnectedUsers)object).setVisible(true);
                        }
                    });
                    break;
                }
                case 6: {
                    this.m_aToolbarButtons[i] = new PanelToolbar.ToolbarButton(this.m_icons.getIcon(majorFunctionArray[i].getIconIndex()), this.m_icons.getRolloverIcon(majorFunctionArray[i].getIconIndex()), n4, n2, RES.getString("PanelToolbarNormal_Macros"));
                    this.m_aToolbarButtons[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            JDialogMacros jDialogMacros = new JDialogMacros((Frame)((Object)PanelToolbarNormal.this.m_applianceSession.getApplianceWindow()), PanelToolbarNormal.this.m_applianceSession, PanelToolbarNormal.this.m_szHelpURL);
                            jDialogMacros.setModal(true);
                            jDialogMacros.setVisible(true);
                        }
                    });
                    break;
                }
                case 7: {
                    if (this.isStingray()) break;
                    this.m_aToolbarButtons[i] = new PanelToolbar.ToolbarButton(this.m_icons.getIcon(majorFunctionArray[i].getIconIndex()), this.m_icons.getRolloverIcon(majorFunctionArray[i].getIconIndex()), n4, n2, RES.getString("PanelToolbarNormal_Macro_Groups"));
                    this.m_aToolbarButtons[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            JDialogMacroGroups jDialogMacroGroups = new JDialogMacroGroups((Frame)((Object)PanelToolbarNormal.this.m_applianceSession.getApplianceWindow()), PanelToolbarNormal.this.m_applianceSession, PanelToolbarNormal.this.m_szHelpURL);
                            jDialogMacroGroups.setModal(true);
                            jDialogMacroGroups.setVisible(true);
                        }
                    });
                    break;
                }
                case 9: {
                    this.m_nManualVideoAdjustToolbarButtonIndex = i;
                    this.m_aToolbarButtons[i] = new PanelToolbar.ToolbarButton(this.m_icons.getIcon(majorFunctionArray[i].getIconIndex()), this.m_icons.getRolloverIcon(majorFunctionArray[i].getIconIndex()), n4, n2, RES.getString("PanelToolbarNormal_Manual_Video_Adjust"));
                    this.m_aToolbarButtons[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            PanelToolbarNormal.this.m_appliancePanel.setVideoQueueSleepTimeDeactivated();
                            if (PanelToolbarNormal.this.m_nSingleCursorModeToolbarButtonIndex >= 0) {
                                PanelToolbarNormal.this.m_aToolbarButtons[PanelToolbarNormal.this.m_nSingleCursorModeToolbarButtonIndex].setEnabled(false);
                            }
                            if ((OS.isLinux() || OS.isSolaris()) && PanelToolbarNormal.this.m_bFullScreen) {
                                Thread thread = new Thread(new Runnable(this){
                                    private final /* synthetic */ 47 this$1;
                                    {
                                        this.this$1 = var1_1;
                                    }

                                    public void run() {
                                        Trace.logInfo((String)"VideoViewerTrace", (String)"Display message");
                                        JDialogMessage jDialogMessage = new JDialogMessage(null, false);
                                        jDialogMessage.setModal(false);
                                        jDialogMessage.setVisible(false);
                                        jDialogMessage.dispose();
                                    }
                                });
                                thread.start();
                            }
                            PanelToolbarNormal.this.m_applianceSession.displayManualVideoAdjustDlg();
                            PanelToolbarNormal.this.m_appliancePanel.setVideoQueueSleepTimeActivated();
                        }
                    });
                    this.m_aToolbarButtons[i].setEnabled(!this.m_applianceSession.isPassiveConnection() && !this.m_applianceSession.isStealthConnection() && this.m_applianceSession.areScalingControlsEnabled());
                    break;
                }
                case 1: {
                    this.m_aToolbarButtons[i] = new PanelToolbar.ToolbarButton(this.m_icons.getIcon(majorFunctionArray[i].getIconIndex()), this.m_icons.getRolloverIcon(majorFunctionArray[i].getIconIndex()), n4, n2, RES.getString("PanelToolbarNormal_Refresh_Screen"));
                    this.m_aToolbarButtons[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                PanelToolbarNormal.this.m_applianceSession.cmdRefreshPane();
                            }
                            catch (IOException iOException) {
                                Trace.logError((String)"VideoViewerTrace", (String)"Refresh Screen button", (Throwable)iOException);
                            }
                        }
                    });
                    break;
                }
                case 10: {
                    this.m_aToolbarButtons[i] = new PanelToolbar.ToolbarButton(this.m_icons.getIcon(majorFunctionArray[i].getIconIndex()), this.m_icons.getRolloverIcon(majorFunctionArray[i].getIconIndex()), n4, n2, RES.getString("PanelToolbarNormal_Session_Options"));
                    this.m_aToolbarButtons[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            PanelToolbarNormal.this.m_appliancePanel.setVideoQueueSleepTimeDeactivated();
                            PanelToolbarNormal.this.doSessionOptions();
                            PanelToolbarNormal.this.m_appliancePanel.setVideoQueueSleepTimeActivated();
                        }
                    });
                    this.m_aToolbarButtons[i].setEnabled(!this.m_applianceSession.isStealthConnection());
                    break;
                }
                case 2: {
                    this.m_nSingleCursorModeToolbarButtonIndex = i;
                    this.m_aToolbarButtons[i] = new PanelToolbar.ToolbarButton(this.m_icons.getIcon(majorFunctionArray[i].getIconIndex()), this.m_icons.getRolloverIcon(majorFunctionArray[i].getIconIndex()), n4, n2, RES.getString("PanelToolbarNormal_Single_Cursor_Mode"));
                    this.m_aToolbarButtons[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            if (!PanelToolbarNormal.this.m_bToolbarLockedInPlace) {
                                PanelToolbarNormal.this.hideToolbar(true);
                            }
                            PanelToolbarNormal.this.m_applianceSession.getApplianceWindow().activateSingleCursorMode(true);
                        }
                    });
                    this.m_aToolbarButtons[i].setEnabled(!this.m_applianceSession.isPassiveConnection() && !this.m_applianceSession.isStealthConnection() && OS.isWindows() && !this.m_applianceSession.isManualVideoAdjustDlgDisplayed());
                    break;
                }
                case 64: {
                    this.m_nVirtualMediaToolbarButtonIndex = i;
                    int n6 = n3 = !this.isNEC() && !this.isStingray() ? 1 : 0;
                    if (n3 != 0) {
                        int n7 = n3 = !BrandNaming.getString("VirtualMediaSupport", "true").equalsIgnoreCase("false") ? 1 : 0;
                    }
                    if (n3 == 0) break;
                    this.m_aToolbarButtons[i] = new PanelToolbar.ToolbarButton(this.m_icons.getIcon(majorFunctionArray[i].getIconIndex()), this.m_icons.getRolloverIcon(majorFunctionArray[i].getIconIndex()), n4, n2, RES.getString("PanelToolbarNormal_Virtual_Media"));
                    this.m_aToolbarButtons[i].setEnabled(this.m_applianceSession.isVirtualMediaAvailableForTD() && this.m_applianceSession.doesUserHaveRightsToLaunchVirtualMedia() && this.isUserThePrimaryUser() && !this.m_applianceSession.isPPPConnection() && !this.isStingray());
                    this.m_aToolbarButtons[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            PanelToolbarNormal.this.launchVirtualMedia();
                        }
                    });
                    break;
                }
                case 11: {
                    if (this.isStingray()) break;
                    this.m_aToolbarButtons[i] = new PanelToolbar.ToolbarButton(this.m_icons.getIcon(majorFunctionArray[i].getIconIndex()), this.m_icons.getRolloverIcon(majorFunctionArray[i].getIconIndex()), n4, n2, RES.getString("PanelToolbarNormal_Power_Control_"));
                    this.m_aToolbarButtons[i].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            JDialogPowerControl jDialogPowerControl = new JDialogPowerControl((Frame)((Object)PanelToolbarNormal.this.m_applianceSession.getApplianceWindow()), PanelToolbarNormal.this.m_applianceSession);
                            jDialogPowerControl.setModal(true);
                            jDialogPowerControl.setVisible(true);
                        }
                    });
                    this.m_aToolbarButtons[i].setEnabled(!this.m_applianceSession.isPassiveConnection() && !this.m_applianceSession.isStealthConnection() && this.m_applianceSession.canUserControlPower());
                }
            }
            this.m_aToolbarButtons[i].setFocusable(false);
            jPanel.add(this.m_aToolbarButtons[i]);
            n4 += 24;
        }
        PanelToolbar.PanelSeparator panelSeparator = new PanelToolbar.PanelSeparator(n4, 20);
        jPanel.add(panelSeparator);
        n4 += 10;
        n5 = 0;
        for (n3 = 0; n3 < keyboardMacroArray.length; ++n3) {
            if (!keyboardMacroArray[n3].isMacroOnToolbar()) continue;
            final KeyboardMacro keyboardMacro = keyboardMacroArray[n3];
            this.m_aToolbarButtons[majorFunctionArray.length + n5] = new PanelToolbar.ToolbarButton(this.m_icons.getIcon(keyboardMacro.getIconIndex()), this.m_icons.getRolloverIcon(keyboardMacro.getIconIndex()), n4, n2, keyboardMacro.getName());
            this.m_aToolbarButtons[majorFunctionArray.length + n5].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PanelToolbarNormal.this.m_applianceSession.cmdSendMacroKeystrokes(keyboardMacro);
                }
            });
            this.m_aToolbarButtons[majorFunctionArray.length + n5].setEnabled(!this.m_applianceSession.isPassiveConnection() && !this.m_applianceSession.isStealthConnection());
            this.m_aToolbarButtons[majorFunctionArray.length + n5].setFocusable(false);
            jPanel.add(this.m_aToolbarButtons[majorFunctionArray.length + n5]);
            n4 += 22;
            ++n5;
        }
        if (!this.isNEC() && !this.isGlacierD()) {
            panelSeparator = new PanelToolbar.PanelSeparator(n4, 20);
            jPanel.add(panelSeparator);
            this.m_buttonConnectionStatus = new PanelToolbar.ToolbarButton(new ImageIcon((class$com$avocent$video$Icons == null ? (class$com$avocent$video$Icons = PanelToolbarNormal.class$("com.avocent.video.Icons")) : class$com$avocent$video$Icons).getResource("images/connection_active.gif")), null, n4 += 3, n2, "");
            jPanel.add(this.m_buttonConnectionStatus);
            this.setConnectionStatus(this.m_applianceSession.getConnectionType());
            this.m_buttonLockedAndReserveStatus = new PanelToolbar.ToolbarButton(new ImageIcon((class$com$avocent$video$Icons == null ? (class$com$avocent$video$Icons = PanelToolbarNormal.class$("com.avocent.video.Icons")) : class$com$avocent$video$Icons).getResource("images/NoLockedNoReserve.gif")), null, n4 += 20, n2 - 2, "");
            jPanel.add(this.m_buttonLockedAndReserveStatus);
            this.setLockedAndReserveButton();
            n4 += 12;
        }
        if (this.m_bFullScreen) {
            panelSeparator = new PanelToolbar.PanelSeparator(n4, 20);
            jPanel.add(panelSeparator);
            this.m_aToolbarButtons[majorFunctionArray.length + n5] = new PanelToolbar.ToolbarButton(new ImageIcon(this.m_imageFullScreen), null, n4 += 10, n2, RES.getString("PanelToolbarNormal_Normal_Window_Mode"));
            this.m_aToolbarButtons[majorFunctionArray.length + n5].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Trace.logInfo((String)"VideoViewerTrace", (String)"PanelToolbarNormal Normal Window Mode button pressed, returning to normal window mode");
                    Thread thread = new Thread(new Runnable(this){
                        private final /* synthetic */ 55 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            55.access$2200(this.this$1).m_applianceSession.getApplianceWindow().fullScreenToggle();
                        }
                    });
                    thread.start();
                }

                static /* synthetic */ PanelToolbarNormal access$2200(55 var0) {
                    return var0.PanelToolbarNormal.this;
                }
            });
            jPanel.add(this.m_aToolbarButtons[majorFunctionArray.length + n5]);
            this.m_aToolbarButtons[majorFunctionArray.length + n5 + 1] = new PanelToolbar.ToolbarButton(new ImageIcon(this.m_imageCloseUp), null, n4 += 24, n2, RES.getString("PanelToolbarNormal_Close"));
            this.m_aToolbarButtons[majorFunctionArray.length + n5 + 1].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Trace.logInfo((String)"VideoViewerTrace", (String)"PanelToolbarNormal close button pressed, terminating session");
                    PanelToolbarNormal.this.m_applianceSession.terminateSession();
                }
            });
            jPanel.add(this.m_aToolbarButtons[majorFunctionArray.length + n5 + 1]);
            n4 += 24;
        }
        return n4 += 24;
    }

    private void setViewSizeMenuItems(JMenu jMenu) {
        jMenu.getItem(0).setSelected(false);
        jMenu.getItem(1).setSelected(false);
        jMenu.getItem(2).setSelected(false);
        jMenu.getItem(3).setSelected(false);
        jMenu.getItem(4).setSelected(false);
        jMenu.getItem(5).setSelected(false);
        jMenu.getItem(6).setSelected(false);
        jMenu.getItem(7).setSelected(false);
        jMenu.getItem(8).setSelected(false);
        int n = this.m_appliancePanel.getBitmapWidth();
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
        if (applianceSessionInfo.isAutoScale()) {
            jMenu.getItem(0).setSelected(true);
        } else if (applianceSessionInfo.isFullScale()) {
            jMenu.getItem(1).setSelected(true);
        } else if (n >= 1024) {
            jMenu.getItem(2).setSelected(true);
        } else if (n >= 960) {
            jMenu.getItem(3).setSelected(true);
        } else if (n >= 896) {
            jMenu.getItem(4).setSelected(true);
        } else if (n >= 832) {
            jMenu.getItem(5).setSelected(true);
        } else if (n >= 768) {
            jMenu.getItem(6).setSelected(true);
        } else if (n >= 704) {
            jMenu.getItem(7).setSelected(true);
        } else {
            jMenu.getItem(8).setSelected(true);
        }
    }

    private void setViewColorMenuItems(JMenu jMenu) {
        if (!this.isNEC()) {
            ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
            if (applianceSessionInfo.isBackgroundRefresh()) {
                jMenu.getItem(0).setSelected(true);
                jMenu.getItem(1).setSelected(false);
                jMenu.getItem(1).setEnabled(false);
                jMenu.getItem(2).setSelected(false);
                jMenu.getItem(2).setEnabled(false);
                jMenu.getItem(3).setSelected(false);
                jMenu.getItem(3).setEnabled(false);
            } else {
                jMenu.getItem(0).setEnabled(true);
                jMenu.getItem(1).setEnabled(true);
                jMenu.getItem(2).setEnabled(true);
                jMenu.getItem(3).setEnabled(true);
                switch (this.m_applianceSession.getColorDepth()) {
                    case 15: {
                        jMenu.getItem(0).setSelected(true);
                        jMenu.getItem(1).setSelected(false);
                        jMenu.getItem(2).setSelected(false);
                        jMenu.getItem(3).setSelected(false);
                        break;
                    }
                    case 12: {
                        jMenu.getItem(0).setSelected(false);
                        jMenu.getItem(1).setSelected(true);
                        jMenu.getItem(2).setSelected(false);
                        jMenu.getItem(3).setSelected(false);
                        break;
                    }
                    case 9: {
                        jMenu.getItem(0).setSelected(false);
                        jMenu.getItem(1).setSelected(false);
                        jMenu.getItem(2).setSelected(true);
                        jMenu.getItem(3).setSelected(false);
                        break;
                    }
                    case 3: {
                        jMenu.getItem(0).setSelected(false);
                        jMenu.getItem(1).setSelected(false);
                        jMenu.getItem(2).setSelected(false);
                        jMenu.getItem(3).setSelected(true);
                    }
                }
            }
        } else {
            switch (this.m_applianceSession.getColorDepth()) {
                case 15: {
                    jMenu.getItem(0).setSelected(false);
                    jMenu.getItem(1).setSelected(false);
                    break;
                }
                case 12: {
                    jMenu.getItem(0).setSelected(false);
                    jMenu.getItem(1).setSelected(false);
                    break;
                }
                case 9: {
                    jMenu.getItem(0).setSelected(true);
                    jMenu.getItem(1).setSelected(false);
                    break;
                }
                case 3: {
                    jMenu.getItem(0).setSelected(false);
                    jMenu.getItem(1).setSelected(true);
                }
            }
        }
    }

    public void setConnectionStatus(final int n) {
        if (this.m_buttonConnectionStatus != null) {
            this.setConnectionStatusButton(n);
        } else {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    while (PanelToolbarNormal.this.m_buttonConnectionStatus == null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    PanelToolbarNormal.this.setConnectionStatusButton(n);
                }
            });
            thread.start();
        }
    }

    private void setVirtualMediaToolbarButtonEnabled() {
        if (this.m_nVirtualMediaToolbarButtonIndex >= 0) {
            this.m_aToolbarButtons[this.m_nVirtualMediaToolbarButtonIndex].setEnabled(this.m_applianceSession.isVirtualMediaAvailableForTD() && this.m_applianceSession.doesUserHaveRightsToLaunchVirtualMedia() && this.isUserThePrimaryUser() && !this.m_applianceSession.isPPPConnection() && !this.isStingray());
        }
    }

    private void setConnectionStatusButton(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                switch (n) {
                    case 0: {
                        PanelToolbarNormal.this.m_buttonConnectionStatus.setIcon(new ImageIcon((class$com$avocent$video$Icons == null ? (class$com$avocent$video$Icons = PanelToolbarNormal.class$("com.avocent.video.Icons")) : class$com$avocent$video$Icons).getResource("images/clear.gif")));
                        PanelToolbarNormal.this.m_buttonConnectionStatus.setToolTipText("");
                        break;
                    }
                    case 1: {
                        PanelToolbarNormal.this.m_buttonConnectionStatus.setIcon(new ImageIcon((class$com$avocent$video$Icons == null ? (class$com$avocent$video$Icons = PanelToolbarNormal.class$("com.avocent.video.Icons")) : class$com$avocent$video$Icons).getResource("images/connection_active.gif")));
                        PanelToolbarNormal.this.m_buttonConnectionStatus.setToolTipText(RES.getString("PanelToolbarNormal_Active_Connection"));
                        PanelToolbarNormal.this.setVirtualMediaToolbarButtonEnabled();
                        break;
                    }
                    case 2: {
                        PanelToolbarNormal.this.m_buttonConnectionStatus.setIcon(new ImageIcon((class$com$avocent$video$Icons == null ? (class$com$avocent$video$Icons = PanelToolbarNormal.class$("com.avocent.video.Icons")) : class$com$avocent$video$Icons).getResource("images/connection_exclusive.gif")));
                        PanelToolbarNormal.this.m_buttonConnectionStatus.setToolTipText(RES.getString("PanelToolbarNormal_Exclusive_Mode"));
                        PanelToolbarNormal.this.setVirtualMediaToolbarButtonEnabled();
                        break;
                    }
                    case 3: {
                        PanelToolbarNormal.this.m_buttonConnectionStatus.setIcon(new ImageIcon((class$com$avocent$video$Icons == null ? (class$com$avocent$video$Icons = PanelToolbarNormal.class$("com.avocent.video.Icons")) : class$com$avocent$video$Icons).getResource("images/connection_active_sharing_primary.gif")));
                        PanelToolbarNormal.this.m_buttonConnectionStatus.setToolTipText(RES.getString("PanelToolbarNormal_Active_Sharing_Primary_User"));
                        PanelToolbarNormal.this.setVirtualMediaToolbarButtonEnabled();
                        break;
                    }
                    case 4: {
                        PanelToolbarNormal.this.m_buttonConnectionStatus.setIcon(new ImageIcon((class$com$avocent$video$Icons == null ? (class$com$avocent$video$Icons = PanelToolbarNormal.class$("com.avocent.video.Icons")) : class$com$avocent$video$Icons).getResource("images/connection_active_sharing_secondary.gif")));
                        PanelToolbarNormal.this.m_buttonConnectionStatus.setToolTipText(RES.getString("PanelToolbarNormal_Active_Sharing_Secondary_User"));
                        PanelToolbarNormal.this.setVirtualMediaToolbarButtonEnabled();
                        break;
                    }
                    case 5: {
                        PanelToolbarNormal.this.m_buttonConnectionStatus.setIcon(new ImageIcon((class$com$avocent$video$Icons == null ? (class$com$avocent$video$Icons = PanelToolbarNormal.class$("com.avocent.video.Icons")) : class$com$avocent$video$Icons).getResource("images/connection_passive.gif")));
                        PanelToolbarNormal.this.m_buttonConnectionStatus.setToolTipText(RES.getString("PanelToolbarNormal_Passive_Sharing"));
                        PanelToolbarNormal.this.setVirtualMediaToolbarButtonEnabled();
                        break;
                    }
                    case 6: {
                        PanelToolbarNormal.this.m_buttonConnectionStatus.setIcon(new ImageIcon((class$com$avocent$video$Icons == null ? (class$com$avocent$video$Icons = PanelToolbarNormal.class$("com.avocent.video.Icons")) : class$com$avocent$video$Icons).getResource("images/connection_stealth.gif")));
                        PanelToolbarNormal.this.m_buttonConnectionStatus.setToolTipText(RES.getString("PanelToolbarNormal_Stealth_Connection"));
                        PanelToolbarNormal.this.setVirtualMediaToolbarButtonEnabled();
                    }
                }
            }
        });
    }

    private boolean isUserThePrimaryUser() {
        int n = this.m_applianceSession.getConnectionType();
        return n == 1 || n == 2 || n == 3;
    }

    public void notifyManualVideoAdjustDialogClosed() {
        Trace.logInfo((String)"VideoViewerTrace", (String)"PanelToolbarNormal notifyManualVideoAdjustDialogClosed");
        if (this.m_nSingleCursorModeToolbarButtonIndex >= 0) {
            this.m_aToolbarButtons[this.m_nSingleCursorModeToolbarButtonIndex].setEnabled(!this.m_applianceSession.isPassiveConnection() && !this.m_applianceSession.isStealthConnection() && OS.isWindows());
        }
    }

    public void notifyVmAvailableChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setVirtualMediaToolbarButtonEnabled();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PanelToolbarNormal.this.setVirtualMediaToolbarButtonEnabled();
                }
            });
        }
    }

    public void notifyEnableScalingChanged() {
        Trace.logInfo((String)"VideoViewerTrace", (String)"PanelToolbarNormal notifyEnableScalingChanged");
        this.setManualVideoAdjustButton();
        this.setAutoVideoAdjustButton();
    }

    public void notifyLockedOrReserveModeChanged() {
        Trace.logInfo((String)"VideoViewerTrace", (String)"PanelToolbarNormal notifyLockedOrReserveModeChanged");
        if (this.m_buttonLockedAndReserveStatus != null) {
            this.setLockedAndReserveButton();
        } else {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    while (PanelToolbarNormal.this.m_buttonLockedAndReserveStatus == null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    PanelToolbarNormal.this.setLockedAndReserveButton();
                }
            });
            thread.start();
        }
    }

    private void setManualVideoAdjustButton() {
        if (this.m_nManualVideoAdjustToolbarButtonIndex >= 0) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.m_aToolbarButtons[this.m_nManualVideoAdjustToolbarButtonIndex].setEnabled(!this.m_applianceSession.isPassiveConnection() && !this.m_applianceSession.isStealthConnection() && this.m_applianceSession.areScalingControlsEnabled());
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PanelToolbarNormal.this.m_aToolbarButtons[PanelToolbarNormal.this.m_nManualVideoAdjustToolbarButtonIndex].setEnabled(!PanelToolbarNormal.this.m_applianceSession.isPassiveConnection() && !PanelToolbarNormal.this.m_applianceSession.isStealthConnection() && PanelToolbarNormal.this.m_applianceSession.areScalingControlsEnabled());
                    }
                });
            }
        }
    }

    private void setAutoVideoAdjustButton() {
        if (this.m_nAutoVideoAdjustToolbarButtonIndex >= 0) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.m_aToolbarButtons[this.m_nAutoVideoAdjustToolbarButtonIndex].setEnabled(!this.m_applianceSession.isPassiveConnection() && !this.m_applianceSession.isStealthConnection() && this.m_applianceSession.areScalingControlsEnabled());
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PanelToolbarNormal.this.m_aToolbarButtons[PanelToolbarNormal.this.m_nAutoVideoAdjustToolbarButtonIndex].setEnabled(!PanelToolbarNormal.this.m_applianceSession.isPassiveConnection() && !PanelToolbarNormal.this.m_applianceSession.isStealthConnection() && PanelToolbarNormal.this.m_applianceSession.areScalingControlsEnabled());
                    }
                });
            }
        }
    }

    private void setLockedAndReservedButtonOnDispatchThread() {
        boolean bl = this.m_applianceSession.isLockedMode();
        boolean bl2 = this.m_applianceSession.isReserveModeActive();
        Trace.logInfo((String)"VideoViewerTrace", (String)("PanelToolbarNormal setLockedAndReserveButton bLocked=" + bl + " bReserve=" + bl2));
        if (bl && bl2) {
            this.m_buttonLockedAndReserveStatus.setIcon(new ImageIcon((class$com$avocent$video$Icons == null ? (class$com$avocent$video$Icons = PanelToolbarNormal.class$("com.avocent.video.Icons")) : class$com$avocent$video$Icons).getResource("images/LockedReserve.gif")));
            this.m_buttonLockedAndReserveStatus.setToolTipText(RES.getString("PanelToolbarNormal_LOCKED_RESERVE"));
            this.m_buttonLockedAndReserveStatus.setVisible(true);
        } else if (bl && !bl2) {
            this.m_buttonLockedAndReserveStatus.setIcon(new ImageIcon((class$com$avocent$video$Icons == null ? (class$com$avocent$video$Icons = PanelToolbarNormal.class$("com.avocent.video.Icons")) : class$com$avocent$video$Icons).getResource("images/LockedNoReserve.gif")));
            this.m_buttonLockedAndReserveStatus.setToolTipText(RES.getString("PanelToolbarNormal_LOCKED_NO_RESERVE"));
            this.m_buttonLockedAndReserveStatus.setVisible(true);
        } else if (!bl && bl2) {
            this.m_buttonLockedAndReserveStatus.setIcon(new ImageIcon((class$com$avocent$video$Icons == null ? (class$com$avocent$video$Icons = PanelToolbarNormal.class$("com.avocent.video.Icons")) : class$com$avocent$video$Icons).getResource("images/NoLockedReserve.gif")));
            this.m_buttonLockedAndReserveStatus.setToolTipText(RES.getString("PanelToolbarNormal_NO_LOCKED_RESERVE"));
            this.m_buttonLockedAndReserveStatus.setVisible(true);
        } else {
            this.m_buttonLockedAndReserveStatus.setIcon(new ImageIcon((class$com$avocent$video$Icons == null ? (class$com$avocent$video$Icons = PanelToolbarNormal.class$("com.avocent.video.Icons")) : class$com$avocent$video$Icons).getResource("images/NoLockedNoReserve.gif")));
            this.m_buttonLockedAndReserveStatus.setToolTipText("");
            this.m_buttonLockedAndReserveStatus.setVisible(false);
        }
    }

    private synchronized void setLockedAndReserveButton() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setLockedAndReservedButtonOnDispatchThread();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PanelToolbarNormal.this.setLockedAndReservedButtonOnDispatchThread();
                }
            });
        }
    }

    public void terminate() {
        this.m_imageFullScreen = null;
        this.m_imageCloseUp = null;
        this.m_appliancePanel = null;
        this.m_puMenuFile.terminate();
        this.m_puMenuView.terminate();
        this.m_puMenuMacros.terminate();
        this.m_puMenuTools.terminate();
        this.m_puMenuHelp.terminate();
        this.m_cbMenuItemFullScreen = null;
        this.m_cascadeMenuScale = null;
        this.m_cascadeMenuColor = null;
        this.m_miAutomaticVideoAdjust = null;
        this.m_miManualVideoAdjust = null;
        this.m_miSessionOptions = null;
        this.m_miPowerControl = null;
        this.m_miSingleCursorMode = null;
        this.m_miVirtualMedia = null;
        this.m_cbmiExclusiveMode = null;
        super.terminate();
    }

    private boolean isStingray() {
        return this.m_applianceSession.getApplication() == 5;
    }

    private boolean isNEC() {
        return this.m_applianceSession.getApplication() == 3;
    }

    private boolean isGlacierD() {
        return this.m_applianceSession.getApplication() == 4;
    }

    private boolean isNautilus() {
        return this.m_applianceSession.getApplication() == 1;
    }

    private void doSessionOptions() {
        Object object;
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        if ((OS.isLinux() || OS.isSolaris()) && this.m_bFullScreen) {
            object = new Thread(new Runnable(){

                public void run() {
                    Trace.logInfo((String)"VideoViewerTrace", (String)"Display message");
                    JDialogMessage jDialogMessage = new JDialogMessage(null, false);
                    jDialogMessage.setModal(false);
                    jDialogMessage.setVisible(false);
                    jDialogMessage.dispose();
                }
            });
            ((Thread)object).start();
        }
        object = new JDialogSessionOptions(this.m_parent, this.m_applianceSession, this.m_szHelpURL);
        object.setModal(true);
        ((JDialogSessionOptions)((Object)object)).setVisible(true);
        if (((JDialogSessionOptions)((Object)object)).isSessionInfoChanged()) {
            ApplianceSessionInfo applianceSessionInfo2 = this.m_applianceSession.getPersistentDataReference();
            if (applianceSessionInfo.getLocalCursorType() != applianceSessionInfo2.getLocalCursorType()) {
                this.m_appliancePanel.setLocalCursorType(applianceSessionInfo2.getLocalCursorType());
            }
            if (applianceSessionInfo.isBackgroundRefresh() != applianceSessionInfo2.isBackgroundRefresh()) {
                try {
                    this.m_applianceSession.cmdVideoSetColorDepth(applianceSessionInfo2.getColorDepth(), applianceSessionInfo2.isBackgroundRefresh());
                }
                catch (IOException iOException) {
                    Trace.logError((String)"VideoViewerTrace", (String)("Video Set Color Depth error " + iOException.getMessage()), (Throwable)iOException);
                }
            }
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    PanelToolbarNormal.this.m_applianceSession.getApplianceWindow().initToolbar(PanelToolbarNormal.this.m_applianceSession);
                }
            });
            thread.start();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class FileFilterBMP
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isHidden()) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return string.toLowerCase().endsWith(".bmp");
        }

        public String getDescription() {
            return RES.getString("PanelToolbarNormal_CaptureFileDescriptionBMP");
        }
    }

    public class FileFilterJPEG
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isHidden()) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return string.endsWith(".jpg") || string.endsWith(".jpeg");
        }

        public String getDescription() {
            return RES.getString("PanelToolbarNormal_CaptureFileDescription");
        }
    }

    public class TransferableVideo
    implements Transferable {
        private Image m_image;

        public TransferableVideo(Image image) {
            this.m_image = image;
        }

        public Object getTransferData(DataFlavor dataFlavor) {
            if (dataFlavor.equals(DataFlavor.imageFlavor)) {
                return this.m_image;
            }
            return null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
            return dataFlavorArray;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(DataFlavor.imageFlavor);
        }
    }

    public class ClipboardOwnerVideo
    implements ClipboardOwner {
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    private class ToolbarPopupMenuListener
    implements PopupMenuListener {
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            PanelToolbarNormal.this.setMenuDown(false);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            PanelToolbarNormal.this.setMenuDown(false);
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            PanelToolbarNormal.this.setMenuDown(true);
            ((JPopupMenu)popupMenuEvent.getSource()).requestFocus();
            if (popupMenuEvent.getSource() == PanelToolbarNormal.this.m_puMenuView) {
                PanelToolbarNormal.this.m_cbMenuItemFullScreen.setEnabled(PanelToolbarNormal.this.m_applianceSession.isFullScreenSupportEnabled() && PanelToolbarNormal.this.m_applianceSession.areScalingControlsEnabled());
                PanelToolbarNormal.this.m_cascadeMenuScale.setEnabled(!PanelToolbarNormal.this.m_bFullScreen && PanelToolbarNormal.this.m_applianceSession.areScalingControlsEnabled());
                PanelToolbarNormal.this.m_cascadeMenuColor.setEnabled(PanelToolbarNormal.this.m_applianceSession.getColorDepth() != 0 && PanelToolbarNormal.this.m_applianceSession.areScalingControlsEnabled() && PanelToolbarNormal.this.m_applianceSession.getVideoEncodingType() == 2);
                PanelToolbarNormal.this.m_miConnectedUsers.setEnabled(!PanelToolbarNormal.this.m_applianceSession.isPPPConnection() && PanelToolbarNormal.this.m_applianceSession.isConnectedUserSupportEnabled());
            } else if (popupMenuEvent.getSource() == PanelToolbarNormal.this.m_puMenuTools) {
                PanelToolbarNormal.this.m_miAutomaticVideoAdjust.setEnabled(PanelToolbarNormal.this.m_applianceSession.isVideoAdjustSupportEnabled() && PanelToolbarNormal.this.m_applianceSession.areScalingControlsEnabled());
                PanelToolbarNormal.this.m_miManualVideoAdjust.setEnabled(PanelToolbarNormal.this.m_applianceSession.isVideoAdjustSupportEnabled() && PanelToolbarNormal.this.m_applianceSession.areScalingControlsEnabled());
                PanelToolbarNormal.this.m_miSessionOptions.setEnabled(!PanelToolbarNormal.this.m_applianceSession.isStealthConnection() && !PanelToolbarNormal.this.m_applianceSession.isPassiveConnection());
                PanelToolbarNormal.this.m_miPowerControl.setEnabled(PanelToolbarNormal.this.m_applianceSession.canUserControlPower());
                PanelToolbarNormal.this.m_miSingleCursorMode.setEnabled(!PanelToolbarNormal.this.m_applianceSession.isStealthConnection() && PanelToolbarNormal.this.m_applianceSession.getConnectionType() != 5 && OS.isWindows() && !PanelToolbarNormal.this.m_applianceSession.isManualVideoAdjustDlgDisplayed() && !PanelToolbarNormal.this.m_applianceSession.getApplianceWindow().isSingleCursorActive());
                PanelToolbarNormal.this.m_cbmiExclusiveMode.setEnabled(PanelToolbarNormal.this.m_applianceSession.isExclusiveModeAvailable() && PanelToolbarNormal.this.m_applianceSession.areScalingControlsEnabled());
                PanelToolbarNormal.this.m_miVirtualMedia.setEnabled(PanelToolbarNormal.this.m_applianceSession.isVirtualMediaAvailableForTD() && PanelToolbarNormal.this.m_applianceSession.doesUserHaveRightsToLaunchVirtualMedia() && PanelToolbarNormal.this.isUserThePrimaryUser() && !PanelToolbarNormal.this.m_applianceSession.isPPPConnection() && !PanelToolbarNormal.this.isStingray());
            }
        }
    }

    private class MenuMacroActionListener
    implements ActionListener {
        private MenuMacroActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Trace.logInfo((String)"VideoViewerTrace", (String)("PanelToolbarNormal menuMacroActionListener actionCommand:" + actionEvent.getActionCommand()));
            if (!PanelToolbarNormal.this.m_bDisplayMacroEditor) {
                ApplianceSessionInfo applianceSessionInfo = PanelToolbarNormal.this.m_applianceSession.getPersistentData();
                KeyboardMacroGroup[] keyboardMacroGroupArray = applianceSessionInfo.getMacroGroups(true, true);
                for (int i = 0; i < keyboardMacroGroupArray.length; ++i) {
                    if (!actionEvent.getActionCommand().equalsIgnoreCase(keyboardMacroGroupArray[i].getName())) continue;
                    try {
                        applianceSessionInfo.setSelectedMacroGroup(keyboardMacroGroupArray[i]);
                        PanelToolbarNormal.this.m_applianceSession.setPersistentData(applianceSessionInfo);
                    }
                    catch (ExceptionRequestFailed exceptionRequestFailed) {
                        Trace.logError((String)"VideoViewerTrace", (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                    }
                    return;
                }
                KeyboardMacro keyboardMacro = applianceSessionInfo.getMacro(actionEvent.getActionCommand());
                if (keyboardMacro != null) {
                    PanelToolbarNormal.this.m_applianceSession.cmdSendMacroKeystrokes(keyboardMacro);
                }
                applianceSessionInfo.terminate();
            } else if (actionEvent.getActionCommand().equalsIgnoreCase(RES.getString("PanelToolbarNormal_Configure_Macros"))) {
                PanelToolbarNormal.this.m_appliancePanel.setVideoQueueSleepTimeDeactivated();
                PanelToolbarNormal.this.displayMacrosDialog();
                PanelToolbarNormal.this.m_appliancePanel.setVideoQueueSleepTimeActivated();
            } else if (actionEvent.getActionCommand().compareTo(RES.getString("PanelToolbarNormal_Configure_Macro_Groups")) == 0) {
                PanelToolbarNormal.this.displayMacroGroupsDialog();
            } else {
                ApplianceSessionInfo applianceSessionInfo = PanelToolbarNormal.this.m_applianceSession.getPersistentDataReference();
                KeyboardMacro keyboardMacro = applianceSessionInfo.getMacro(actionEvent.getActionCommand());
                if (keyboardMacro != null) {
                    PanelToolbarNormal.this.m_applianceSession.cmdSendMacroKeystrokes(keyboardMacro);
                }
            }
        }
    }

    private class MenuItemToolbar
    extends JMenuItem {
        Icon m_iconNormal;
        Icon m_iconRollover;

        private MenuItemToolbar(String string, int n, int n2, String string2) {
            super(string);
            if (n >= 0) {
                this.m_iconNormal = PanelToolbarNormal.this.m_icons.getIcon(n);
            }
            if (n2 >= 0) {
                this.m_iconRollover = PanelToolbarNormal.this.m_icons.getRolloverIcon(n2);
            }
            this.initMenuItemToolbar(string2);
        }

        private MenuItemToolbar(String string, Icon icon, Icon icon2, String string2) {
            super(string);
            this.m_iconNormal = icon;
            this.m_iconRollover = icon2;
            this.initMenuItemToolbar(string2);
        }

        private void initMenuItemToolbar(String string) {
            if (this.m_iconNormal != null) {
                this.setIcon(this.m_iconNormal);
            }
            if (string != null && string.length() > 0) {
                this.setMnemonic(string.charAt(0));
            }
            this.setBackground(Color.white);
            this.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JMenuItem jMenuItem = (JMenuItem)changeEvent.getSource();
                    if (jMenuItem.isArmed()) {
                        if (m_iconRollover != null) {
                            this.setIcon(m_iconRollover);
                        }
                    } else if (m_iconNormal != null) {
                        this.setIcon(m_iconNormal);
                    }
                }
            });
        }
    }
}

