/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.video.ApcpSessionSetup;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class ProtocolAPCP {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    public static final byte PROTOCOL_APCP = 1;
    public static final byte PROTOCOL_AVMP = 2;
    public static final byte PROTOCOL_AVSP_PRIMARY = 3;
    public static final byte PROTOCOL_AVSP_SECONDARY = 4;
    public static final byte PROTOCOL_ASMP = 5;
    public static final int CONNECTION_TYPE_NONE = 0;
    public static final int CONNECTION_TYPE_TCP_CLEARTEXT = 1;
    public static final int CONNECTION_TYPE_TCP_RC4 = 2;
    public static final int CONNECTION_TYPE_SSL_ANONYMOUS = 4;
    public static final int CONNECTION_TYPE_SSL_CERT = 8;
    public static final int CONNECTION_TYPE_KEEP_ALIVE = 256;

    public static void sendSessionRequest(DataOutputStream dataOutputStream, byte by, byte by2, byte by3, int n, byte[] byArray) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ProtocolAPCP.sendSessionRequest nConnectionType=" + n));
        if (byArray.length > 32) {
            throw new IOException("Random number too long");
        }
        dataOutputStream.writeBytes("APCP");
        dataOutputStream.writeInt(53);
        dataOutputStream.writeShort(256);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeByte(by);
        dataOutputStream.writeByte(by2);
        dataOutputStream.writeByte(by3);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeByte(byArray.length);
        dataOutputStream.write(byArray);
        for (int i = 32 - byArray.length; i > 0; --i) {
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.flush();
    }

    public static ApcpSessionSetup receiveSessionSetup(DataInputStream dataInputStream, Socket socket) throws IOException, ExceptionRequestFailed {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"ProtocolAPCP.receieveSessionSetup");
        byte[] byArray = new byte[4];
        socket.setSoTimeout(2000);
        int n = 90;
        int n2 = 0;
        do {
            try {
                n2 = dataInputStream.read(byArray);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                // empty catch block
            }
        } while (n2 == 0 && --n > 0);
        if (n == 0) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"ProtocolAPCP.receieveSessionSetup socket timed out");
            throw new IOException("Header read timed out");
        }
        socket.setSoTimeout(0);
        if (byArray[0] != 65 || byArray[1] != 80 || byArray[2] != 67 || byArray[3] != 80) {
            throw new IOException("Header incorrect");
        }
        int n3 = dataInputStream.readInt();
        short s = dataInputStream.readShort();
        if (s != -32512) {
            throw new IOException("Incorrect message type");
        }
        short s2 = dataInputStream.readShort();
        ApcpSessionSetup apcpSessionSetup = new ApcpSessionSetup();
        apcpSessionSetup.m_bVersionMajor = dataInputStream.readByte();
        apcpSessionSetup.m_bVersionMinor = dataInputStream.readByte();
        apcpSessionSetup.m_nConnectionCapabilities = dataInputStream.readInt();
        apcpSessionSetup.m_sTcpPort = dataInputStream.readShort();
        byte by = dataInputStream.readByte();
        apcpSessionSetup.m_abRandomAuth = new byte[by];
        dataInputStream.read(apcpSessionSetup.m_abRandomAuth);
        for (int i = 32 - apcpSessionSetup.m_abRandomAuth.length; i > 0; --i) {
            dataInputStream.readByte();
        }
        return apcpSessionSetup;
    }
}

