/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import java.io.IOException;

public class Queue {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    private static final int MAX_WAIT_TIME = 50;
    private Object[] m_list;
    private int m_nHead;
    private int m_nTail;
    private int m_nElements;
    private int m_nUsedElements;

    public Queue(int n) {
        try {
            this.m_list = new Object[n];
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            negativeArraySizeException.printStackTrace();
            this.m_list = new Object[0];
        }
        this.m_nHead = 0;
        this.m_nTail = 0;
        this.m_nElements = n;
        this.m_nUsedElements = 0;
    }

    public Queue(Object[] objectArray) {
        this.m_list = new Object[objectArray.length];
        this.m_nHead = 0;
        this.m_nTail = 0;
        this.m_nElements = objectArray.length;
        this.m_nUsedElements = objectArray.length;
        System.arraycopy(objectArray, 0, this.m_list, 0, objectArray.length);
    }

    private synchronized void putObject(Object object) throws IOException {
        if (object == null) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(Queue putObject) NULL Object for queue insert");
            throw new IOException("Put in Queue failed.  NULL Object");
        }
        if (this.m_nUsedElements < this.m_nElements) {
            this.m_list[this.m_nHead] = object;
            ++this.m_nUsedElements;
            if (++this.m_nHead >= this.m_nElements) {
                this.m_nHead = 0;
            }
        } else {
            throw new IOException("Put in Queue failed.  No more room in the queue");
        }
        this.notifyAll();
    }

    public void put(Object object) {
        boolean bl = false;
        while (!bl) {
            try {
                this.putObject(object);
                bl = true;
            }
            catch (IOException iOException) {
                this.waitForData();
            }
        }
    }

    private synchronized Object getObject() {
        Object object = null;
        if (this.m_nUsedElements > 0) {
            object = this.m_list[this.m_nTail];
            this.m_list[this.m_nTail] = null;
            --this.m_nUsedElements;
            if (++this.m_nTail >= this.m_nElements) {
                this.m_nTail = 0;
            }
            this.notifyAll();
        }
        return object;
    }

    public Object get() {
        Object object;
        do {
            if ((object = this.getObject()) != null) continue;
            this.waitForData();
        } while (object == null);
        return object;
    }

    public final synchronized int getSize() {
        return this.m_nElements;
    }

    public final synchronized int getUsedElements() {
        return this.m_nUsedElements;
    }

    public synchronized boolean hasData() {
        return this.m_nUsedElements > 0;
    }

    public synchronized int getAvailableSpace() {
        return this.m_nElements - this.m_nUsedElements;
    }

    public synchronized void waitForData() {
        try {
            this.wait(50L);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

