/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.interfaces.InterfaceVmSession;
import com.avocent.video.ApplianceSession;
import com.avocent.video.DSPath;
import com.avocent.video.videoViewer;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public class SessionManager {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    private static final String SESSION_RUNNING_LAUNCH_SESSION = "DSVIEW LAUNCH SESSION ";
    private static final String SESSION_RUNNING_SESSION_LAUNCHING = "DSVIEW SESSION LAUNCHING";
    private static final String SESSION_CLOSE_OPEN_SESSIONS = "CLOSE OPEN SESSIONS";
    private static Thread m_thread = null;
    private static final Vector m_vectorSessions = new Vector(1);
    private static String m_szSessionID = "";
    private static String m_szPathTcpPortFile = "";
    private static File m_fileTcpPort;
    private ServerSocket m_socket = null;

    public SessionManager(String string, String string2) throws ExceptionRequestFailed {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            throw new ExceptionRequestFailed("szSessionID or szPathTcpPortFile not specified");
        }
        if (m_thread != null && string.equalsIgnoreCase(m_szSessionID) && string2.equalsIgnoreCase(m_szPathTcpPortFile)) {
            return;
        }
        m_szSessionID = string;
        m_szPathTcpPortFile = string2;
        Random random = new Random();
        this.m_socket = null;
        while (this.m_socket == null) {
            try {
                int n = random.nextInt(65535);
                this.m_socket = new ServerSocket(n);
            }
            catch (IOException iOException) {}
        }
        m_fileTcpPort = new File(m_szPathTcpPortFile);
        m_fileTcpPort.deleteOnExit();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(m_fileTcpPort);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            int n = this.m_socket.getLocalPort();
            Trace.logInfo((String)TRACE_CONTEXT, (String)("SessionManager saving listening port of " + n + " to " + m_szPathTcpPortFile));
            dataOutputStream.writeInt(n);
            dataOutputStream.flush();
            dataOutputStream.close();
            FileInputStream fileInputStream = new FileInputStream(m_fileTcpPort);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            int n2 = dataInputStream.readInt();
            int n3 = 0;
            ++n3;
        }
        catch (Exception exception) {
            throw new ExceptionRequestFailed("FileNotFoundException thrown for TcpPortFile");
        }
        this.sessionRunningCommunicator();
    }

    public void sessionRunningCommunicator() {
        m_thread = new Thread(new Runnable(){

            public void run() {
                try {
                    while (m_thread == Thread.currentThread()) {
                        Socket socket = SessionManager.this.m_socket.accept();
                        Trace.logInfo((String)SessionManager.TRACE_CONTEXT, (String)("(SessionManager.SessionRunningCommunicator) socket accepted, port=" + socket.getLocalPort()));
                        Thread thread = new Thread(new Runnable(this, socket){
                            private final /* synthetic */ Socket val$socket;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$socket = socket;
                            }

                            public void run() {
                                try {
                                    this.val$socket.setSoTimeout(1000);
                                    byte[] byArray = new byte[2000];
                                    BufferedInputStream bufferedInputStream = new BufferedInputStream(this.val$socket.getInputStream());
                                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.val$socket.getOutputStream());
                                    int n = bufferedInputStream.read(byArray);
                                    Trace.logInfo((String)"VideoViewerTrace", (String)("(SessionManager.SessionRunningCommunicator) socket read bytes=" + n));
                                    String string = new String(byArray, 0, n);
                                    Trace.logInfo((String)"VideoViewerTrace", (String)("(SessionManager.SessionRunningCommunicator) szRecv=" + string));
                                    if (string.startsWith(SessionManager.access$200() + "DSVIEW LAUNCH SESSION ")) {
                                        Trace.logInfo((String)"VideoViewerTrace", (String)("(SessionManager.SessionRunningCommunicator) szRecv == SESSION_RUNNING_LAUNCH_SESSION + deviceID szRecv=" + string));
                                        String string2 = string.substring((SessionManager.access$200() + "DSVIEW LAUNCH SESSION ").length());
                                        Trace.logInfo((String)"VideoViewerTrace", (String)("(SessionManager.SessionRunningCommunicator) szCommandLine=" + string2));
                                        String[] stringArray = string2.split(new String(new char[]{'\n'}));
                                        String string3 = SessionManager.access$200() + "DSVIEW SESSION LAUNCHING";
                                        bufferedOutputStream.write(string3.getBytes());
                                        bufferedOutputStream.flush();
                                        SessionManager.access$400(1.access$300(this.this$1), stringArray);
                                    } else if (string.equalsIgnoreCase(SessionManager.access$200() + "CLOSE OPEN SESSIONS")) {
                                        Trace.logInfo((String)"VideoViewerTrace", (String)"(SessionManager.SessionRunningCommunicator) closing all sessions");
                                        SessionManager.closeAllSessions();
                                    } else {
                                        Trace.logInfo((String)"VideoViewerTrace", (String)"(SessionManager.SessionRunningCommunicator) unknown szRecv");
                                    }
                                }
                                catch (Exception exception) {
                                    Trace.logError((String)"VideoViewerTrace", (String)exception.getMessage(), (Throwable)exception);
                                }
                                try {
                                    this.val$socket.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        });
                        if (socket.getInetAddress().getHostAddress().equalsIgnoreCase("127.0.0.1")) {
                            thread.start();
                            continue;
                        }
                        socket.close();
                    }
                    SessionManager.this.m_socket.close();
                }
                catch (Exception exception) {
                    Trace.logError((String)SessionManager.TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                }
                m_thread = null;
            }

            static /* synthetic */ SessionManager access$300(1 var0) {
                return var0.SessionManager.this;
            }
        });
        m_thread.start();
    }

    private void launchViewer(final String[] stringArray) {
        boolean bl = true;
        String string = "tdid=";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            if (!stringArray[i].startsWith(string) || !SessionManager.isThisDeviceIDSessionRunning(string2 = stringArray[i].substring(string.length()), true)) continue;
            bl = false;
            break;
        }
        if (bl) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    Trace.logInfo((String)SessionManager.TRACE_CONTEXT, (String)"(SessionManager.launchViewer) starting a new video viewer session");
                    videoViewer.launch(stringArray, null);
                }
            });
            thread.start();
        }
    }

    public boolean isSessionManagerRunning() {
        return m_thread != null;
    }

    public static void stopCommunicator() {
        Thread thread = m_thread;
        m_thread = null;
        if (thread != null) {
            thread.interrupt();
        }
    }

    public static void addSession(Object object) {
        m_vectorSessions.add(object);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("SessionManager added session to m_vectorSessions m_vectorSessions.size=" + m_vectorSessions.size()));
    }

    public static void removeSession(Object object) {
        m_vectorSessions.remove(object);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("SessionManager just removed session from m_vectorSessions m_vectorSessions.size=" + m_vectorSessions.size()));
    }

    public static synchronized int getNumSessionsInProgress() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager.getNumSessionsInProgress)");
        return m_vectorSessions.size();
    }

    public static boolean isAnySessionRunning() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager.isAnySessionRunning)");
        return m_vectorSessions.size() > 0;
    }

    public static void bringSessionToForeground(String string) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager.bringSessionToForeground) szDeviceID=" + string));
        for (int i = 0; i < m_vectorSessions.size(); ++i) {
            Object e = m_vectorSessions.get(i);
            if (!(e instanceof ApplianceSession)) continue;
            ApplianceSession applianceSession = (ApplianceSession)e;
            if (applianceSession.getDeviceID() != null && applianceSession.getDeviceID().length() > 0) {
                if (!applianceSession.getDeviceID().equalsIgnoreCase(string)) continue;
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager.bringSessionToForeground) session found, calling bringWindowToTop");
                applianceSession.getApplianceWindow().bringWindowToTop();
                break;
            }
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager.bringSessionToForeground) getDeviceID null or zero length");
            DSPath dSPath = applianceSession.m_dsPath;
            String string2 = dSPath.getPortNumber() != 0 ? dSPath.getIPAddress() + dSPath.getPortNumber() + dSPath.getCascadeChannel() : dSPath.getIPAddress() + dSPath.getRIPId() + dSPath.getCascadeChannel();
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager.bringSessionToForeground) szUniqueID=" + string2));
            if (!string2.equalsIgnoreCase(string)) continue;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager.bringSessionToForeground) session found, calling bringWindowToTop");
            applianceSession.getApplianceWindow().bringWindowToTop();
            break;
        }
    }

    public static boolean isThisDeviceIDSessionRunning(String string, boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager.isThisDeviceIDSessionRunning) szDeviceID=" + string + " bBringToFront=" + bl));
        boolean bl2 = false;
        for (int i = 0; i < m_vectorSessions.size(); ++i) {
            Object e = m_vectorSessions.get(i);
            if (!(e instanceof ApplianceSession)) continue;
            ApplianceSession applianceSession = (ApplianceSession)e;
            if (applianceSession.getDeviceID() != null && applianceSession.getDeviceID().length() > 0) {
                if (!applianceSession.getDeviceID().equalsIgnoreCase(string)) continue;
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager.isThisDeviceIDSessionRunning) found szDeviceID");
                bl2 = true;
                if (!bl) break;
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager.isThisDeviceIDSessionRunning) found szDeviceID, calling bringWindowToTop");
                applianceSession.getApplianceWindow().bringWindowToTop();
                break;
            }
            DSPath dSPath = applianceSession.m_dsPath;
            String string2 = dSPath.getPortNumber() != 0 ? dSPath.getIPAddress() + dSPath.getPortNumber() + dSPath.getCascadeChannel() : dSPath.getIPAddress() + dSPath.getRIPId() + dSPath.getCascadeChannel();
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager.isThisDeviceIDSessionRunning) szUniqueID=" + string2));
            if (!string2.equalsIgnoreCase(string)) continue;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager.isThisDeviceIDSessionRunning) szUniqueID=szDeviceID");
            bl2 = true;
            if (!bl) break;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager.isThisDeviceIDSessionRunning) szUniqueID=szDeviceID, calling bringWindowToTop");
            applianceSession.getApplianceWindow().bringWindowToTop();
            break;
        }
        return bl2;
    }

    public static Frame getFrameForSession(String string, boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager.getFrameForSession) szDeviceID=" + string + " bBringToFront=" + bl));
        Frame frame = null;
        for (int i = 0; i < m_vectorSessions.size(); ++i) {
            Object e = m_vectorSessions.get(i);
            if (!(e instanceof ApplianceSession)) continue;
            ApplianceSession applianceSession = (ApplianceSession)e;
            if (applianceSession.getDeviceID() != null && applianceSession.getDeviceID().length() > 0) {
                if (!applianceSession.getDeviceID().equalsIgnoreCase(string)) continue;
                try {
                    frame = (Frame)((Object)applianceSession.getApplianceWindow());
                    if (!bl) break;
                    applianceSession.getApplianceWindow().bringWindowToTop();
                }
                catch (Exception exception) {}
                break;
            }
            DSPath dSPath = applianceSession.m_dsPath;
            String string2 = dSPath.getPortNumber() != 0 ? dSPath.getIPAddress() + dSPath.getPortNumber() + dSPath.getCascadeChannel() : dSPath.getIPAddress() + dSPath.getRIPId() + dSPath.getCascadeChannel();
            if (!string2.equalsIgnoreCase(string)) continue;
            try {
                frame = (Frame)((Object)applianceSession.getApplianceWindow());
                if (!bl) break;
                applianceSession.getApplianceWindow().bringWindowToTop();
            }
            catch (Exception exception) {}
            break;
        }
        return frame;
    }

    public static boolean isThisVMDeviceIDSessionRunning(String string, boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager.isThisVMDeviceIDSessionRunning) szDeviceID=" + string + " bBringToFront=" + bl));
        boolean bl2 = false;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.avocent.vm.ApplianceSession");
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager.isThisVMDeviceIDSessionRunning) classVM=" + clazz.toString()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.logError((String)TRACE_CONTEXT, (String)classNotFoundException.getMessage(), (Throwable)classNotFoundException);
            return false;
        }
        for (int i = 0; i < m_vectorSessions.size(); ++i) {
            Object e = m_vectorSessions.get(i);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager.isThisVMDeviceIDSessionRunning) object=" + e.toString()));
            if (!clazz.isInstance(e)) continue;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager.isThisVMDeviceIDSessionRunning) object is instance of class object");
            InterfaceVmSession interfaceVmSession = (InterfaceVmSession)e;
            if (!interfaceVmSession.getDeviceID().equalsIgnoreCase(string)) continue;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager.isThisVMDeviceIDSessionRunning) getDeviceID == szDeviceID");
            bl2 = true;
            if (!bl) break;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager.isThisVMDeviceIDSessionRunning) getDeviceID == szDeviceID, bringing to front");
            interfaceVmSession.toFront();
            break;
        }
        return bl2;
    }

    public static ApplianceSession getSessionFromPath(DSPath dSPath) {
        Enumeration enumeration = m_vectorSessions.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof ApplianceSession)) continue;
            ApplianceSession applianceSession = (ApplianceSession)e;
            if (applianceSession.m_dsPath.toString().compareTo(dSPath.toString()) != 0) continue;
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager getSessionFromPath) Session already running for path: " + dSPath.toString()));
            return applianceSession;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager getSessionFromPath) No session already running for path: " + dSPath.toString()));
        return null;
    }

    public static void closeAllSessions() {
        Object object;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager closeAllSessions)");
        Vector vector = new Vector();
        for (int i = 0; i < m_vectorSessions.size(); ++i) {
            object = m_vectorSessions.get(i);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager closeAllSessions) adding object to vectorSessionsCopy object=" + object.toString()));
            vector.add(object);
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager closeAllSessions) vectorSessionsCopy.size=" + vector.size()));
        Class<?> clazz = null;
        object = null;
        try {
            clazz = Class.forName("com.avocent.vm.ApplianceSession");
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager closeAllSessions) classVM=" + clazz.toString()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.logError((String)TRACE_CONTEXT, (String)classNotFoundException.getMessage(), (Throwable)classNotFoundException);
        }
        try {
            object = Class.forName("com.avocent.video.JFrameThumbnail");
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager closeAllSessions) classFrameThumbnail=" + ((Class)object).toString()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.logError((String)TRACE_CONTEXT, (String)classNotFoundException.getMessage(), (Throwable)classNotFoundException);
        }
        for (int i = 0; i < vector.size(); ++i) {
            Thread thread;
            Object object2;
            Object e = vector.get(i);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(SessionManager closeAllSessions) object=" + e.toString() + " class=" + e.getClass().toString()));
            if (clazz != null && clazz.isInstance(e)) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager closeAllSessions) object isInstance(objectClassVM), calling terminate");
                object2 = (InterfaceVmSession)e;
                thread = new Thread(new Runnable((InterfaceVmSession)object2){
                    private final /* synthetic */ InterfaceVmSession val$session;
                    {
                        this.val$session = interfaceVmSession;
                    }

                    public void run() {
                        this.val$session.logEventSession(1);
                        this.val$session.terminate();
                    }
                });
                thread.start();
                continue;
            }
            if (e instanceof ApplianceSession) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager closeAllSessions) object instanceof(ApplianceSession), calling terminateSession");
                object2 = (ApplianceSession)e;
                thread = new Thread(new Runnable((ApplianceSession)object2){
                    private final /* synthetic */ ApplianceSession val$session;
                    {
                        this.val$session = applianceSession;
                    }

                    public void run() {
                        this.val$session.logEventSession(1);
                        this.val$session.terminateSession();
                    }
                });
                thread.start();
                continue;
            }
            if (object == null || !((Class)object).isInstance(e)) continue;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(SessionManager closeAllSessions) object isInstance(objectClassFrameThumbnail), dispatching WindowEvent");
            object2 = (Window)e;
            thread = new Thread(new Runnable((Window)object2){
                private final /* synthetic */ Window val$window;
                {
                    this.val$window = window;
                }

                public void run() {
                    this.val$window.dispatchEvent(new WindowEvent(this.val$window, 201));
                }
            });
            thread.start();
        }
    }

    static /* synthetic */ String access$200() {
        return m_szSessionID;
    }

    static /* synthetic */ void access$400(SessionManager sessionManager, String[] stringArray) {
        sessionManager.launchViewer(stringArray);
    }
}

