/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.dialogs.JDialogLogin;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.CachedCredentials;
import com.avocent.lib.util.UsernamePassword;
import com.avocent.video.AVSPStatus;
import com.avocent.video.DSPath;
import com.avocent.video.JFrameThumbnail;
import java.awt.Component;
import java.awt.Frame;
import java.text.MessageFormat;

class ThreadScan
extends Thread {
    public static final String TRACE_CONTEXT = "ThreadScan";
    JFrameThumbnail m_frame;
    boolean m_bThreadScanActive;
    boolean m_bConnectionChanged;
    int m_nCurrentPanel;

    public ThreadScan(JFrameThumbnail jFrameThumbnail) {
        super("Scan Mode Thread");
        this.m_frame = jFrameThumbnail;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n;
        this.m_bThreadScanActive = true;
        boolean bl = true;
        boolean bl2 = true;
        AVSPStatus aVSPStatus = new AVSPStatus();
        while (this.m_frame.isAlive() && !this.m_frame.isClosing()) {
            n = 0;
            this.m_bConnectionChanged = false;
            DSPath dSPath = this.m_frame.m_appliancePanels[this.m_nCurrentPanel].getDSPathInteractiveSession();
            if (this.m_frame.m_appliancePanels[this.m_nCurrentPanel].isScanEnabled() && dSPath == null) {
                do {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameThumbnail.threadScan connecting to appliance");
                    this.m_frame.m_appliancePanels[this.m_nCurrentPanel].connectAppliance(true, aVSPStatus);
                    if (!bl2 || aVSPStatus.getLoginStatus() != 2 && aVSPStatus.getLoginStatus() != 1) continue;
                    try {
                        Boolean bl3 = JFrameThumbnail.m_bModalDlgRequest;
                        synchronized (bl3) {
                            String string;
                            JDialogLogin jDialogLogin;
                            if (this.m_frame.m_appliancePanels[this.m_nCurrentPanel].getFirstDSPath().getUCC()) {
                                jDialogLogin = new JDialogLogin[]{this.m_frame.m_appliancePanels[this.m_nCurrentPanel].getServerName()};
                                string = MessageFormat.format(JFrameThumbnail.RES.getString("JFrameThumbnail_Invalid_Server_Credentials"), (Object[])jDialogLogin);
                                Message.show((Component)this.m_frame, (String)string);
                            }
                            jDialogLogin = new JDialogLogin((Frame)this.m_frame, JFrameThumbnail.RES.getString("JFrameThumbnail_Login"), this.m_frame.m_appliancePanels[this.m_nCurrentPanel].getUserCredentials());
                            jDialogLogin.setModal(true);
                            jDialogLogin.setVisible(true);
                            if (jDialogLogin.wasOkPressed()) {
                                string = this.m_frame.m_appliancePanels[this.m_nCurrentPanel].getUserCredentials();
                                String string2 = this.m_frame.m_appliancePanels[this.m_nCurrentPanel].getIPAddress();
                                this.m_frame.m_userCredentials = string;
                                if (this.m_frame.m_appliancePanels[this.m_nCurrentPanel].getFirstDSPath().getUCC()) {
                                    CachedCredentials.setCredentials((UsernamePassword)this.m_frame.m_userCredentials);
                                }
                                for (int i = 0; i < this.m_frame.m_appliancePanels.length; ++i) {
                                    if (this.m_frame.m_appliancePanels[i].getIPAddress().compareTo(string2) != 0) continue;
                                    this.m_frame.m_appliancePanels[i].setUserCredentials((UsernamePassword)string, true);
                                }
                            } else {
                                n = 1;
                                break;
                            }
                        }
                    }
                    catch (ExceptionConstructorFailed exceptionConstructorFailed) {
                        Trace.logError((String)TRACE_CONTEXT, (String)exceptionConstructorFailed.getMessage(), (Throwable)exceptionConstructorFailed);
                    }
                } while (bl2 && (aVSPStatus.getLoginStatus() == 2 || aVSPStatus.getLoginStatus() == 1));
                if (n == 0) {
                    try {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail.threadScan starting time per server seconds: " + this.m_frame.m_nSecondsPerServer));
                        for (int i = 0; i < this.m_frame.m_nSecondsPerServer; ++i) {
                            if (!this.m_frame.isAlive()) {
                                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameThumbnail.threadScan JFrameThumbnail is not alive");
                                break;
                            }
                            Thread.sleep(1000L);
                            if (!this.m_frame.isScanPaused()) continue;
                            if (this.m_bConnectionChanged) {
                                this.m_frame.m_appliancePanels[this.m_nCurrentPanel].connectAppliance(true, aVSPStatus);
                                this.m_bConnectionChanged = false;
                            }
                            --i;
                        }
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail.threadScan ending time per server seconds: " + this.m_frame.m_nSecondsPerServer));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.m_frame.m_appliancePanels[this.m_nCurrentPanel].isConnectedForThumbnail()) {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameThumbnail.threadScan disconnecting appliance");
                        this.m_frame.m_appliancePanels[this.m_nCurrentPanel].disconnect();
                    }
                }
                try {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail.threadScan starting time between servers seconds: " + this.m_frame.m_nSecondsBetweenServers));
                    for (int i = 0; i < this.m_frame.getTimeBetweenServers(); ++i) {
                        if (!this.m_frame.isAlive()) {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameThumbnail.threadScan JFrameThumbnail is not alive");
                            break;
                        }
                        Thread.sleep(1000L);
                        if (!this.m_frame.isScanPaused()) continue;
                        --i;
                    }
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail.threadScan ending time between servers seconds: " + this.m_frame.m_nSecondsBetweenServers));
                }
                catch (InterruptedException interruptedException) {}
            } else {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail.threadScan did not scan, isScanEnabled:" + this.m_frame.m_appliancePanels[this.m_nCurrentPanel].isScanEnabled() + " isThisDeviceIDSessionRunning:" + (dSPath != null)));
            }
            ++this.m_nCurrentPanel;
            if (this.m_nCurrentPanel >= this.m_frame.m_appliancePanels.length) {
                this.m_nCurrentPanel = 0;
                bl2 = false;
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (n = 0; n < this.m_frame.m_appliancePanels.length; ++n) {
            if (this.m_frame.m_appliancePanels[n] != null) {
                this.m_frame.m_appliancePanels[n].terminateThumbnail();
            }
            this.m_frame.m_appliancePanels[n] = null;
        }
        this.m_frame.getContentPane().removeAll();
        this.m_frame.m_toolbar = null;
        this.m_frame.dispose();
        this.m_frame = null;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameThumbnail.threadScan leaving threadScan");
        this.m_bThreadScanActive = false;
    }
}

