/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import java.awt.Rectangle;
import java.awt.Window;

public class Win32Library {
    static boolean m_bAcvvWin32LibLoaded = false;

    private native String GetDesktopWorkArea();

    private native String GetDefaultBrowser();

    private native String GetSpecialFolderPath(int var1);

    private native void SetMouseWheelHook(int var1, Object var2);

    private native void ResetMouseWheelHook(int var1, Object var2);

    private native void ProcessWindowsMessages(boolean var1);

    private native boolean IsNumLockSet();

    private native boolean IsCapsLockSet();

    private native boolean IsScrollLockSet();

    private native boolean IsKanaLockSet();

    private native boolean IsLeftShiftDown();

    private native boolean IsRightShiftDown();

    private native boolean IsLeftCtrlDown();

    private native boolean IsRightCtrlDown();

    private native boolean IsLeftAltDown();

    private native boolean IsRightAltDown();

    private native boolean TopMost(int var1);

    private native boolean AlwaysOnTop(int var1);

    private native int WindowsKeyToScanCode(int var1);

    private native int ScanCodeToWindowsKey(int var1);

    private native int GetWindowHandle(Window var1);

    private native void SetSingleMouseMode(int var1, Window var2, int var3, int var4, int var5, int var6);

    private native void ResetSingleMouseMode();

    private native boolean SetLowLevelKeyboardHook(int var1, boolean var2);

    private native void ResetLowLevelKeyboardHook();

    private native String GetLocalAppDataPath();

    private native void WriteParallelPort(byte var1);

    static void initLib() {
        Trace.logInfo((String)"Win32Library", (String)"Loading acvvWin32Lib.dll");
        try {
            System.loadLibrary("acvvWin32Lib");
            m_bAcvvWin32LibLoaded = true;
            Trace.logInfo((String)"Win32Library", (String)"acvvWin32Lib.dll Loaded successfully");
        }
        catch (LinkageError linkageError) {
            Trace.logError((String)"Win32Library", (String)"LinkageError");
        }
        catch (SecurityException securityException) {
            Trace.logError((String)"Win32Library", (String)"SecurityException");
        }
        catch (Exception exception) {
            Trace.logError((String)"Win32Library", (String)" FAILED to load acvvWin32Lib.dll", (Throwable)exception);
        }
    }

    public Rectangle getDesktopWorkArea() throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"GetWorkArea Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        try {
            Trace.logInfo((String)"Win32Library", (String)"Calling acvvWin32Lib.dll to get Work Area");
            String string = this.GetDesktopWorkArea();
            int n = string.indexOf(",");
            if (n == -1) {
                throw new ExceptionRequestFailed();
            }
            String string2 = string.substring(0, n);
            string = string.substring(n + 1);
            int n2 = Integer.parseInt(string2);
            n = string.indexOf(",");
            if (n == -1) {
                throw new ExceptionRequestFailed();
            }
            String string3 = string.substring(0, n);
            string = string.substring(n + 1);
            int n3 = Integer.parseInt(string3);
            n = string.indexOf(",");
            if (n == -1) {
                throw new ExceptionRequestFailed();
            }
            String string4 = string.substring(0, n);
            string = string.substring(n + 1);
            int n4 = Integer.parseInt(string4);
            String string5 = string;
            int n5 = Integer.parseInt(string5);
            Rectangle rectangle = new Rectangle(n2, n3, n4 - n2, n5 - n3);
            Trace.logInfo((String)"Win32Library", (String)("Returning Work Area " + rectangle.toString()));
            return rectangle;
        }
        catch (Exception exception) {
            Trace.logError((String)"Win32Library", (String)"GetWorkArea Failed", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    public String getSpecialFolderPath(int n) throws ExceptionRequestFailed {
        try {
            Trace.logInfo((String)"Win32Library", (String)"Calling acvvWin32Lib.dll to get FolderPath");
            String string = this.GetSpecialFolderPath(n);
            Trace.logInfo((String)"Win32Library", (String)("Successful. FolderPath=" + string));
            return string;
        }
        catch (Exception exception) {
            Trace.logError((String)"Win32Library", (String)"FolderPath Failed", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    public String getDefaultBrowser() throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"GetDefaultBrowser Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        try {
            Trace.logInfo((String)"Win32Library", (String)"Calling acvvWin32Lib.dll to get Default Browser");
            String string = this.GetDefaultBrowser();
            Trace.logInfo((String)"Win32Library", (String)("GetDefaultBrowser Successful. Return=" + string));
            return string;
        }
        catch (Exception exception) {
            Trace.logError((String)"Win32Library", (String)"GetDefaultBrowser Failed", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    public boolean setMouseWheelHook(int n, Object object) {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"setMouseWheelHook Failed - DLL Not Loaded");
            return false;
        }
        try {
            this.SetMouseWheelHook(n, object);
            return true;
        }
        catch (Exception exception) {
            Trace.logError((String)"Win32Library", (String)"setMouseWheelHook Failed - Exception", (Throwable)exception);
            return false;
        }
    }

    public boolean resetMouseWheelHook(int n, Object object) {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"setMouseWheelHook Failed - DLL Not Loaded");
            return false;
        }
        try {
            this.ResetMouseWheelHook(n, object);
            return true;
        }
        catch (Exception exception) {
            Trace.logError((String)"Win32Library", (String)"setMouseWheelHook Failed - Exception", (Throwable)exception);
            return false;
        }
    }

    public void processWindowsMessages(boolean bl) {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"processWindowsMessages Failed - DLL Not Loaded");
        }
        try {
            this.ProcessWindowsMessages(bl);
        }
        catch (Exception exception) {
            Trace.logError((String)"Win32Library", (String)"processWindowsMessages Failed - Exception", (Throwable)exception);
        }
    }

    public boolean isNumLockSet() throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"isNumLockSet Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        return this.IsNumLockSet();
    }

    public boolean isCapsLockSet() throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"isCapsLockSet Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        return this.IsCapsLockSet();
    }

    public boolean isScrollLockSet() throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"isScrollLockSet Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        return this.IsScrollLockSet();
    }

    public boolean isKanaLockSet() throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"isKanaLockSet Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        return this.IsKanaLockSet();
    }

    public boolean isLeftShiftDown() throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"isLeftShiftDown Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        return this.IsLeftShiftDown();
    }

    public boolean isRightShiftDown() throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"isRightShiftDown Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        return this.IsRightShiftDown();
    }

    public boolean isLeftCtrlDown() throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"isLeftCtrlDown Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        return this.IsLeftCtrlDown();
    }

    public boolean isRightCtrlDown() throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"isRightCtrlDown Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        return this.IsRightCtrlDown();
    }

    public boolean isLeftAltDown() throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"isLeftAltDown Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        return this.IsLeftAltDown();
    }

    public boolean isRightAltDown() throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library", (String)"isRightAltDown Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        return this.IsRightAltDown();
    }

    public static boolean isWin32LibLoaded() {
        return m_bAcvvWin32LibLoaded;
    }

    public boolean topMost(Window window) throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library:alwaysOnTop", (String)"topMost Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        int n = this.getHWND(window);
        Trace.logInfo((String)"Win32Library:alwaysOnTop", (String)("topMost hwnd:" + n));
        if (n != 0) {
            return this.TopMost(n);
        }
        return false;
    }

    public boolean alwaysOnTop(Window window) throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library:alwaysOnTop", (String)"alwaysOnTop Failed - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        int n = this.getHWND(window);
        Trace.logInfo((String)"Win32Library:alwaysOnTop", (String)("alwaysOnTopMost hwnd:" + n));
        if (n != 0) {
            return this.AlwaysOnTop(n);
        }
        return false;
    }

    public int windowsKeyToScanCode(int n) throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library:windowsKeyToScanCode", (String)"WindowsKeyToScanCode - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        return this.WindowsKeyToScanCode(n);
    }

    public int scanCodeToWindowsKey(int n) throws ExceptionRequestFailed {
        if (!m_bAcvvWin32LibLoaded) {
            Trace.logError((String)"Win32Library:ScanCodeToWindowsKey", (String)"ScanCodeToWindowsKey - DLL Not Loaded");
            throw new ExceptionRequestFailed();
        }
        return this.ScanCodeToWindowsKey(n);
    }

    public int getHWND(Window window) {
        int n = this.GetWindowHandle(window);
        Trace.logInfo((String)"Win32Library:getHWND", (String)("JFrameViewer.getHWND returning hwnd:" + n));
        return n;
    }

    public void setSingleMouseMode(int n, Window window, int n2, int n3, int n4, int n5) {
        this.SetSingleMouseMode(n, window, n2, n3, n4, n5);
    }

    public void resetSingleMouseMode() {
        this.ResetSingleMouseMode();
    }

    public String getLocalAppDataPath() {
        return this.GetLocalAppDataPath();
    }

    public boolean setLowLevelKeyboardHook(int n, boolean bl) {
        return this.SetLowLevelKeyboardHook(n, bl);
    }

    public void resetLowLevelKeyboardHook() {
        this.ResetLowLevelKeyboardHook();
    }

    public void writeParallelPort(byte by) {
        this.WriteParallelPort(by);
    }
}

