/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogLogin;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.interfaces.InterfaceViewer3;
import com.avocent.lib.interfaces.SessionStatus;
import com.avocent.lib.util.CachedCredentials;
import com.avocent.lib.util.OS;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.StringUtilities;
import com.avocent.lib.util.UsernamePassword;
import com.avocent.protocols.app.ProxyClient;
import com.avocent.protocols.socket.SSLHelper;
import com.avocent.video.AVSPStatus;
import com.avocent.video.ApcpSessionSetup;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionAERP;
import com.avocent.video.ApplianceSessionAVSP;
import com.avocent.video.BrandNaming;
import com.avocent.video.DSConnect;
import com.avocent.video.DSEncryptValues;
import com.avocent.video.DSPath;
import com.avocent.video.DataInputStreamEndian;
import com.avocent.video.DataOutputStreamEndian;
import com.avocent.video.InterfaceElapsedTimeDialog;
import com.avocent.video.InterfaceNotifyOnClosing;
import com.avocent.video.JDialogConnectionMode;
import com.avocent.video.JDialogElapsedTime;
import com.avocent.video.JDialogWaitingForPreemption;
import com.avocent.video.JDialogWaitingForShareRequest;
import com.avocent.video.JFrameThumbnail;
import com.avocent.video.JPanelApplianceThumbnailTitle;
import com.avocent.video.PersistentStorage;
import com.avocent.video.ProtocolAPCP;
import com.avocent.video.SessionManager;
import com.avocent.video.UserNotification;
import com.avocent.video.Win32Library;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class videoViewer
implements InterfaceNotifyOnClosing {
    public static final String CNAME = "videoViewer";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    private static final String CL_TITLE = "title=";
    private static final String CL_USER = "user=";
    private static final String CL_PASSWORD = "password=";
    private static final String CL_IFACEVIEWER = "ifaceviewer3=";
    private static final String CL_MODE = "mode=";
    private static final String CL_PATH = "path=";
    private static final String CL_CONN = "conn=";
    private static final String CL_DEVICETYPE = "devicetype=";
    private static final String CL_APPLIANCETYPE = "appliancetype=";
    private static final String CL_APPLIANCEEID = "applianceeid=";
    private static final String CL_HELPURL = "helpurl=";
    private static final String CL_CERT = "cert=";
    private static final String CL_SESSIONTYPE = "sessionType=";
    private static final String CL_TDID = "tdid=";
    private static final String CL_TDNAMES = "tdnames=";
    private static final String CL_REMOTE = "remote=";
    private static final String CL_VMAVAILABLE = "vm_supported=";
    private static final String CL_OEM = "oem=";
    private static final String CL_APPLICATION = "application_name=";
    private static final String CL_SID = "sid=";
    private static final String CL_FID = "fid=";
    public static final String CL_DONTCHECKSESSIONRUNNING = "dontchecksession=";
    private static final String MODE_NORMAL = "normal";
    private static final String MODE_SCAN = "scan";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final int PORT_NUMBER_AVSP_SSL = 2068;
    private static final int PORT_NUMBER_AVSP_VIDEO = 8192;
    private static final int PORT_NUMBER_EMBEDDED_TCP = 2000;
    private static final int PORT_NUMBER_EMBEDDED_UDP = 623;
    private static final int CONNECT_WAIT_TIME = 100;
    private static final int INPUT_BUFFER_SIZE = 32768;
    private DataOutputStreamEndian m_dosAppliance;
    private DataInputStreamEndian m_disAppliance;
    private DataOutputStreamEndian m_dosApplianceVideo;
    private DataInputStreamEndian m_disApplianceVideo;
    private DSEncryptValues m_encryptValues;
    private DatagramSocket m_udpConnection;
    private static boolean m_bStartedFromCommandLine = true;
    private static boolean m_bRemote = false;
    InterfaceElapsedTimeDialog m_dlgElapsed;
    boolean m_bUserCancelled = false;
    boolean m_bApplianceSessionRunning = false;
    public static Hashtable m_htPendingConnections = new Hashtable(1);
    private static Object m_syncConnectionPending = new Object();
    String m_szUser = "";
    String m_szPassword = "";
    String m_szTitle = "";
    String m_szIFaceViewer = "";
    String m_szSessionID = "";
    String m_szSessionManagerTcpPortFileID = "";
    String m_szConnection = "AVSP-SSL";
    boolean m_bConnectionSet = false;
    String m_szDeviceType = "avsp";
    boolean m_bDeviceSet = false;
    String m_szSessionType = "NORMAL";
    String[] m_aszTDIDs = new String[0];
    String[] m_aszTDNames = new String[]{"SERVER NAME GOES HERE"};
    boolean m_bUseCert = false;
    boolean m_bVirtualMediaAvailable = false;
    boolean m_bVirtualMediaOnCommandLine = false;
    String m_szOEM = "";
    String m_szApplianceType;
    String m_szApplianceEID;
    String m_szHelpURL;
    boolean m_bEnablePPP = false;
    boolean m_bVideoEncryptEnable = false;
    Vector m_vDSPaths = new Vector(1);
    Properties m_propertiesLaunchArgs;
    String[] m_aszArgs;
    boolean m_bDontCheckSessionRunning = false;
    protected Frame m_fLoginDialogParent;
    boolean m_bLocalUserUsingChannelWeArePreempting = false;
    private Win32Library m_libWin32;
    private static int m_nApplication = 0;
    private int m_nConnectionType = 0;
    private AVSPStatus m_avspStatus = new AVSPStatus();
    private InterfaceViewer3 m_iFaceViewer = null;
    private boolean m_bAllowCancel = true;

    public videoViewer(String[] stringArray) {
        this(stringArray, null);
    }

    public videoViewer(String[] stringArray, Frame frame) {
        int n;
        int n2;
        if (OS.isWindows()) {
            this.m_libWin32 = new Win32Library();
            videoViewer videoViewer2 = this;
            videoViewer2.m_libWin32.initLib();
        }
        this.m_fLoginDialogParent = frame;
        Vector<String> vector = new Vector<String>(1);
        boolean bl = false;
        this.m_bApplianceSessionRunning = false;
        this.m_bUserCancelled = false;
        this.m_aszArgs = stringArray;
        this.m_propertiesLaunchArgs = new Properties();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String string = stringArray[n2];
            String[] stringArray2 = string.split("=", 2);
            this.m_propertiesLaunchArgs.setProperty(stringArray2[0], stringArray2[1]);
        }
        try {
            n2 = UIManager.getColor("MenuItem.foreground").getRGB();
            n = UIManager.getColor("MenuItem.background").getRGB();
            if ((n2 == -1 || n2 == -16711936) && n == -16777216) {
                UIManager.put("MenuItem.disabledForeground", new ColorUIResource(Color.gray));
            }
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            return;
        }
        String string = "";
        for (n = 0; n < stringArray.length; ++n) {
            string = string + stringArray[n];
            string = string + " ";
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer) Command line: " + string));
        for (n = 0; n < stringArray.length; ++n) {
            boolean bl2 = false;
            int n3 = stringArray[n].indexOf(CL_TITLE);
            if (n3 >= 0) {
                int n4;
                bl2 = true;
                this.m_szTitle = stringArray[n].substring(n3 + CL_TITLE.length());
                if (this.m_szTitle.charAt(0) == '\"') {
                    this.m_szTitle = this.m_szTitle.substring(1);
                }
                if ((n4 = this.m_szTitle.lastIndexOf(34)) <= 0) continue;
                this.m_szTitle = this.m_szTitle.substring(0, n4);
                continue;
            }
            n3 = stringArray[n].indexOf(CL_USER);
            if (n3 >= 0) {
                bl2 = true;
                this.m_szUser = stringArray[n].substring(n3 + CL_USER.length());
                continue;
            }
            n3 = stringArray[n].indexOf(CL_PASSWORD);
            if (n3 >= 0) {
                bl2 = true;
                this.m_szPassword = stringArray[n].substring(n3 + CL_PASSWORD.length());
                continue;
            }
            n3 = stringArray[n].indexOf(CL_IFACEVIEWER);
            if (n3 >= 0) {
                bl2 = true;
                this.m_szIFaceViewer = stringArray[n].substring(n3 + CL_IFACEVIEWER.length());
                m_bStartedFromCommandLine = this.m_bUseCert;
                continue;
            }
            n3 = stringArray[n].indexOf(CL_SID);
            if (n3 >= 0) {
                bl2 = true;
                this.m_szSessionID = stringArray[n].substring(n3 + CL_SID.length());
                continue;
            }
            n3 = stringArray[n].indexOf(CL_FID);
            if (n3 >= 0) {
                bl2 = true;
                this.m_szSessionManagerTcpPortFileID = stringArray[n].substring(n3 + CL_FID.length());
                continue;
            }
            n3 = stringArray[n].indexOf(CL_REMOTE);
            if (n3 >= 0) {
                bl2 = true;
                m_bRemote = true;
                m_bStartedFromCommandLine = false;
                continue;
            }
            n3 = stringArray[n].indexOf(CL_MODE);
            if (n3 >= 0) {
                bl2 = true;
                String string2 = stringArray[n].substring(n3 + CL_MODE.length());
                if (string2.compareToIgnoreCase(MODE_SCAN) == 0) {
                    bl = true;
                    continue;
                }
                if (string2.compareToIgnoreCase(MODE_NORMAL) == 0) {
                    bl = false;
                    continue;
                }
                UserNotification.InvalidParameterMessageBox(stringArray[n]);
                return;
            }
            n3 = stringArray[n].indexOf(CL_PATH);
            if (n3 >= 0) {
                bl2 = true;
                vector.add(new String(stringArray[n].substring(n3 + CL_PATH.length())));
                continue;
            }
            n3 = stringArray[n].indexOf(CL_CONN);
            if (n3 >= 0) {
                bl2 = true;
                this.m_szConnection = stringArray[n].substring(n3 + CL_CONN.length());
                this.m_bConnectionSet = true;
                continue;
            }
            n3 = stringArray[n].indexOf(CL_SESSIONTYPE);
            if (n3 >= 0) {
                bl2 = true;
                this.m_szSessionType = stringArray[n].substring(n3 + CL_SESSIONTYPE.length());
                continue;
            }
            n3 = stringArray[n].indexOf(CL_DONTCHECKSESSIONRUNNING);
            if (n3 >= 0) {
                bl2 = true;
                this.m_bDontCheckSessionRunning = true;
                continue;
            }
            n3 = stringArray[n].indexOf(CL_TDID);
            if (n3 >= 0) {
                bl2 = true;
                String string3 = stringArray[n].substring(n3 + CL_TDID.length());
                this.m_aszTDIDs = string3.split(",");
                continue;
            }
            n3 = stringArray[n].indexOf(CL_TDNAMES);
            if (n3 >= 0) {
                bl2 = true;
                String string4 = stringArray[n].substring(n3 + CL_TDNAMES.length());
                this.m_aszTDNames = string4.split("(?<!\\\\),");
                for (int i = 0; i < this.m_aszTDNames.length; ++i) {
                    this.m_aszTDNames[i] = this.m_aszTDNames[i].replaceAll("\\\\(.)", "$1");
                }
                continue;
            }
            n3 = stringArray[n].indexOf(CL_CERT);
            if (n3 >= 0) {
                bl2 = true;
                this.m_bUseCert = true;
                m_bStartedFromCommandLine = true;
                continue;
            }
            n3 = stringArray[n].indexOf(CL_DEVICETYPE);
            if (n3 >= 0) {
                bl2 = true;
                this.m_szDeviceType = stringArray[n].substring(n3 + CL_DEVICETYPE.length());
                this.m_bDeviceSet = true;
                continue;
            }
            n3 = stringArray[n].indexOf(CL_HELPURL);
            if (n3 >= 0) {
                bl2 = true;
                this.m_szHelpURL = stringArray[n].substring(n3 + CL_HELPURL.length());
                continue;
            }
            n3 = stringArray[n].indexOf(CL_OEM);
            if (n3 >= 0) {
                bl2 = true;
                this.m_szOEM = stringArray[n].substring(n3 + CL_OEM.length());
                if (this.m_szOEM.equalsIgnoreCase("nec")) {
                    m_nApplication = 3;
                    continue;
                }
                if (!this.m_szOEM.equalsIgnoreCase("glacierd")) continue;
                m_nApplication = 4;
                continue;
            }
            n3 = stringArray[n].indexOf(CL_APPLICATION);
            if (n3 >= 0) {
                bl2 = true;
                String string5 = stringArray[n].substring(n3 + CL_APPLICATION.length());
                if (string5.equalsIgnoreCase("avworks")) {
                    m_nApplication = 1;
                    continue;
                }
                if (!string5.equalsIgnoreCase("dsview")) continue;
                m_nApplication = 2;
                continue;
            }
            n3 = stringArray[n].indexOf(CL_VMAVAILABLE);
            if (n3 < 0) continue;
            bl2 = true;
            this.m_bVirtualMediaAvailable = stringArray[n].substring(n3 + CL_VMAVAILABLE.length()).equalsIgnoreCase("true");
            this.m_bVirtualMediaOnCommandLine = true;
        }
        if (this.m_szTitle.length() == 0) {
            UserNotification.InvalidParameterMessageBox(RES.getString("videoViewer_Title_not_specified"));
            return;
        }
        if (vector.size() == 0 && !this.m_bUseCert) {
            UserNotification.InvalidParameterMessageBox(RES.getString("videoViewer_Path_not_specified"));
            return;
        }
        if (m_nApplication == 2) {
            try {
                SessionManager sessionManager = new SessionManager(this.m_szSessionID, this.m_szSessionManagerTcpPortFileID);
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
            }
        }
        if (!this.m_bUseCert) {
            for (int i = 0; i < vector.size(); ++i) {
                try {
                    DSPath dSPath = new DSPath((String)vector.get(i), this.m_szIFaceViewer);
                    this.m_vDSPaths.add(dSPath);
                    continue;
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"(videoViewer constructor) DSPath failed", (Throwable)exceptionRequestFailed);
                    return;
                }
            }
        }
        if (!bl) {
            try {
                UsernamePassword usernamePassword = new UsernamePassword(this.m_szUser, this.m_szPassword);
                this.desktopMode(this.m_szTitle, usernamePassword, this.m_bUseCert, this.m_szIFaceViewer, this.m_szConnection, this.m_szDeviceType, this.m_vDSPaths);
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                this.closeUserCancelDialog();
            }
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer) Thumbnail mode");
            JFrameThumbnail jFrameThumbnail = new JFrameThumbnail(this.m_fLoginDialogParent, this.m_szTitle, this.m_szUser, this.m_szPassword, this.m_szIFaceViewer, this.m_vDSPaths, m_nApplication, this.m_propertiesLaunchArgs, this.m_szHelpURL);
            while (jFrameThumbnail.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void waitForApplianceSessionToStart(ApplianceSession applianceSession) {
        try {
            while (applianceSession.isSessionRunning() && applianceSession.getApplianceWindow() == null && !applianceSession.getApplianceWindow().isVisible()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Socket doApcp(String string, SessionStatus sessionStatus, int n, boolean bl) throws ExceptionRequestFailed {
        Socket socket = null;
        try {
            BufferedOutputStream bufferedOutputStream;
            byte[] byArray = new byte[32];
            Random random = new Random();
            random.nextBytes(byArray);
            int n2 = 2068;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.doApcp using APCP creating normal/clear socket");
            if (sessionStatus != null) {
                if (sessionStatus.isProxied()) {
                    n2 = bl ? sessionStatus.getPortVideo() : sessionStatus.getPort();
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.doApcp using proxy, creating proxy to IP address=" + string + " TCP port=" + n2));
                    bufferedOutputStream = new ProxyClient(string, n2, 0);
                    n2 = bufferedOutputStream.openServerSocket(bl ? sessionStatus.getProxySessionIdVideo() : sessionStatus.getProxySessionId());
                    string = "127.0.0.1";
                } else {
                    n2 = 2068;
                }
            }
            socket = videoViewer.ProxySelectorOffSocket(string, n2);
            socket.setTcpNoDelay(true);
            bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
            DataOutputStreamEndian dataOutputStreamEndian = new DataOutputStreamEndian(bufferedOutputStream);
            DataInputStreamEndian dataInputStreamEndian = new DataInputStreamEndian(bufferedInputStream, socket);
            Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.doApcp calling ProtocolAPCP.sendSessionRequest");
            ProtocolAPCP.sendSessionRequest(dataOutputStreamEndian, bl ? (byte)4 : 3, (byte)0, (byte)0, n, byArray);
            Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.doApcp calling ProtocolAPCP.receiveSessionSetup");
            ApcpSessionSetup apcpSessionSetup = ProtocolAPCP.receiveSessionSetup(dataInputStreamEndian, socket);
            if (apcpSessionSetup.getTcpPort() != 0) {
                socket.close();
                socket = videoViewer.ProxySelectorOffSocket(string, apcpSessionSetup.getTcpPort());
                socket.setTcpNoDelay(true);
            }
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
            throw new ExceptionRequestFailed("Failure in setting up APCP");
        }
        return socket;
    }

    public static Socket ProxySelectorOffSocket(String string, int n) throws ExceptionRequestFailed {
        Object object = null;
        Socket socket = null;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ProxySelectorOffSocket szIpAddress=" + string + " nTcpPort=" + n));
        try {
            if (System.getProperty("java.version", "").startsWith("1.5")) {
                try {
                    int n2;
                    Class<?> clazz = Class.forName("java.net.ProxySelector");
                    Method[] methodArray = clazz.getDeclaredMethods();
                    for (n2 = 0; n2 < methodArray.length; ++n2) {
                        if (!Modifier.isPublic(methodArray[n2].getModifiers()) || !methodArray[n2].getName().equals("getDefault")) continue;
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"getDefault Found");
                        object = methodArray[n2].invoke(clazz, null);
                    }
                    for (n2 = 0; n2 < methodArray.length; ++n2) {
                        if (!Modifier.isPublic(methodArray[n2].getModifiers()) || !methodArray[n2].getName().equals("setDefault") || methodArray[n2].getParameterTypes().length != 1) continue;
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"setDefault Found");
                        Object[] objectArray = new Object[]{null};
                        methodArray[n2].invoke(clazz, objectArray);
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"ProxySelector Deactivated");
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.doApcp connecting socket to IP address=" + string + " port=" + n));
                        socket = new Socket(string, n);
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"Connection Established. Reset the ProxySelector");
                        Object[] objectArray2 = new Object[]{object};
                        methodArray[n2].invoke(clazz, objectArray2);
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"ProxySelector Reactivated");
                    }
                }
                catch (Exception exception) {
                    throw new ExceptionRequestFailed("Failure in setting up ProxySelectorOffSocket Exception:" + exception.getMessage());
                }
            } else {
                socket = new Socket(string, n);
            }
            return socket;
        }
        catch (IOException iOException) {
            throw new ExceptionRequestFailed("Failure in setting up ProxySelectorOffSocket Exception:" + iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void desktopMode(String string, UsernamePassword usernamePassword, boolean bl, String string2, String string3, String string4, Vector vector) throws ExceptionRequestFailed {
        boolean bl2;
        SessionStatus sessionStatus;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        DSPath dSPath;
        boolean bl6;
        block92: {
            Object object;
            boolean bl7;
            block91: {
                Vector<DSPath> vector2;
                block90: {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("(VideoViewer) desktopMode Parameters: Title=" + string + " IFaceViewer=" + string2 + " Connection=" + string3 + " DeviceType=" + string4));
                    bl6 = false;
                    dSPath = null;
                    String string5 = "";
                    bl5 = false;
                    bl4 = false;
                    bl3 = false;
                    sessionStatus = null;
                    try {
                        try {
                            int n;
                            if (this.m_bUseCert) {
                                this.m_iFaceViewer = this.getIFaceViewer(string2, null);
                                n = this.m_iFaceViewer.init(this.m_propertiesLaunchArgs);
                                if (n != 0) {
                                    Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer iFaceViewer.init failed nResult=" + n));
                                    throw new ExceptionRequestFailed("InterfaceViewer3 init failed");
                                }
                                bl2 = false;
                                if (this.m_szSessionType.compareToIgnoreCase("SCAN") == 0) {
                                    vector2 = new Vector<DSPath>(this.m_aszTDIDs.length);
                                    break block90;
                                }
                                if (!this.m_bDontCheckSessionRunning && (bl7 = SessionManager.isThisDeviceIDSessionRunning(this.m_aszTDIDs[0], true))) {
                                    throw new ExceptionRequestFailed("Session for this device ID is already running");
                                }
                                if (m_nApplication == 1) {
                                    new ThreadCheckForUserCancel(this.m_aszTDNames[0], dSPath.getLoginTimeOut());
                                } else {
                                    new ThreadCheckForUserCancel(this.m_aszTDNames[0], 0);
                                }
                                this.showUserCancelDialog(true);
                                bl7 = false;
                                if (this.m_szSessionType.compareTo("EXCLUSIVE") == 0) {
                                    bl2 = true;
                                    bl7 = true;
                                }
                                break block91;
                            }
                            dSPath = (DSPath)vector.get(0);
                            if (m_nApplication == 1) {
                                new ThreadCheckForUserCancel(dSPath.getDisplayName(), dSPath.getLoginTimeOut());
                            } else {
                                new ThreadCheckForUserCancel(dSPath.getDisplayName(), 0);
                            }
                            for (n = 0; n < vector.size(); ++n) {
                                Enumeration enumeration;
                                Object object2;
                                bl6 = false;
                                dSPath = (DSPath)vector.get(n);
                                string5 = dSPath.getDeviceID();
                                if (!this.m_bDeviceSet) {
                                    string4 = dSPath.getDeviceType();
                                }
                                bl5 = dSPath.isPPPEnabled();
                                bl4 = dSPath.isVideoEncryptionEnabled();
                                if (!this.m_bConnectionSet) {
                                    string3 = dSPath.getConnectionType();
                                }
                                this.m_iFaceViewer = this.getIFaceViewer(string2, dSPath);
                                try {
                                    Vector vector3 = JFrameThumbnail.getJFrameThumbnailList();
                                    block35: for (int i = 0; i < vector3.size(); ++i) {
                                        object2 = (JFrameThumbnail)vector3.elementAt(i);
                                        object = ((JFrameThumbnail)object2).getThumbnailList();
                                        for (int j = 0; j < ((JPanelApplianceThumbnailTitle[])object).length; ++j) {
                                            JPanelApplianceThumbnailTitle jPanelApplianceThumbnailTitle = object[j];
                                            String string6 = jPanelApplianceThumbnailTitle.getServerName();
                                            if (!string6.equals(dSPath.getServerName()) || !jPanelApplianceThumbnailTitle.isConnecting()) continue;
                                            this.showUserCancelDialog(true);
                                            boolean bl8 = ((JFrameThumbnail)object2).isScanPaused();
                                            ((JFrameThumbnail)object2).pauseScan(true);
                                            ((JFrameThumbnail)object2).disableServerMenuItem(dSPath.getServerName());
                                            jPanelApplianceThumbnailTitle.enableMouseClicks(false);
                                            jPanelApplianceThumbnailTitle.disconnectAppliance();
                                            ((JFrameThumbnail)object2).pauseScan(bl8);
                                            ((JFrameThumbnail)object2).disableServerMenuItem(null);
                                            jPanelApplianceThumbnailTitle.enableMouseClicks(true);
                                            continue block35;
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                                }
                                bl2 = SessionManager.isThisDeviceIDSessionRunning(dSPath.getDeviceID(), false);
                                Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.desktopMode bSessionRunning=" + bl2));
                                if (bl2) {
                                    Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer.desktopMode) session already exists for path: " + dSPath.toString()));
                                    ApplianceSession applianceSession = SessionManager.getSessionFromPath(dSPath);
                                    if (applianceSession != null) {
                                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer.desktopMode) got appliance session through getSessionFromPath");
                                        if (!(applianceSession.getApplianceWindow() instanceof JPanelApplianceThumbnailTitle)) {
                                            SessionManager.bringSessionToForeground(dSPath.getDeviceID());
                                            throw new ExceptionRequestFailed("Session for this device ID is already running");
                                        }
                                        object2 = (JPanelApplianceThumbnailTitle)applianceSession.getApplianceWindow();
                                        object = ((JPanelApplianceThumbnailTitle)object2).getThumbnailFrame();
                                        this.showUserCancelDialog(true);
                                        boolean bl9 = ((JFrameThumbnail)object).isScanPaused();
                                        ((JFrameThumbnail)object).pauseScan(true);
                                        ((JFrameThumbnail)object).disableServerMenuItem(dSPath.getServerName());
                                        ((JPanelApplianceThumbnailTitle)object2).enableMouseClicks(false);
                                        ((JPanelApplianceThumbnailTitle)object2).disconnectAppliance();
                                        ((JFrameThumbnail)object).pauseScan(bl9);
                                        ((JFrameThumbnail)object).disableServerMenuItem(null);
                                        ((JPanelApplianceThumbnailTitle)object2).enableMouseClicks(true);
                                    }
                                } else {
                                    Trace.logInfo((String)TRACE_CONTEXT, (String)"(VideoViewer) Session was not already running");
                                }
                                if ((enumeration = m_htPendingConnections.keys()) != null) {
                                    while (enumeration.hasMoreElements()) {
                                        object2 = ((DSPath)enumeration.nextElement()).toString();
                                        Trace.logInfo((String)TRACE_CONTEXT, (String)("(VideoViewer) Checking if m_htPendingConnections has path, nextElement szPath=" + (String)object2));
                                        if (((String)object2).compareTo(dSPath.toString()) != 0) continue;
                                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(VideoViewer) This path in hashtable of pending connections");
                                        object = (JDialog)m_htPendingConnections.get(dSPath);
                                        ((Window)object).toFront();
                                        throw new ExceptionRequestFailed("This device ID already has a pending connection session");
                                    }
                                    Trace.logInfo((String)TRACE_CONTEXT, (String)"(VideoViewer) out of while enum.hasMoreElements loop");
                                } else {
                                    Trace.logInfo((String)TRACE_CONTEXT, (String)"(VideoViewer) enum was null");
                                }
                                Trace.logInfo((String)TRACE_CONTEXT, (String)"(VideoViewer) assigning userCredentialsThisPath");
                                object2 = usernamePassword;
                                Trace.logInfo((String)TRACE_CONTEXT, (String)"(VideoViewer) got userCredentialsThisPath");
                                object = m_syncConnectionPending;
                                // MONITORENTER : object
                                Trace.logInfo((String)TRACE_CONTEXT, (String)"(VideoViewer) pending session not found for this device ID, add it to the hashtable");
                                m_htPendingConnections.put(dSPath, this.m_dlgElapsed);
                                bl3 = true;
                                if (dSPath.isEmbeddedAppliance()) {
                                    bl6 = this.embeddedConnect(dSPath, string3);
                                } else {
                                    if (!dSPath.getUCC()) {
                                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(VideoViewer) Not using cached credentials");
                                        object2 = new UsernamePassword("", "");
                                    }
                                    if (object2.getUsername().length() == 0) {
                                        this.showUserCancelDialog(false);
                                        try {
                                            JDialogLogin jDialogLogin = new JDialogLogin(this.m_fLoginDialogParent, RES.getString("videoViewer_Login"), (UsernamePassword)object2);
                                            jDialogLogin.setModal(true);
                                            jDialogLogin.setVisible(true);
                                            if (!jDialogLogin.wasOkPressed()) {
                                                throw new ExceptionRequestFailed("User cancelled login dialog");
                                            }
                                            if (dSPath.getUCC()) {
                                                Trace.logInfo((String)TRACE_CONTEXT, (String)"(VideoViewer) Saving cached credentials");
                                                usernamePassword.setUsername(object2.getUsername());
                                                usernamePassword.setPassword(object2.getPassword());
                                            }
                                        }
                                        catch (ExceptionConstructorFailed exceptionConstructorFailed) {
                                            Trace.logError((String)TRACE_CONTEXT, (String)exceptionConstructorFailed.getMessage(), (Throwable)exceptionConstructorFailed);
                                            throw new ExceptionRequestFailed("Login dialog constructor failed");
                                        }
                                    }
                                    this.showUserCancelDialog(true);
                                    Socket socket = null;
                                    if (dSPath.hasApcp()) {
                                        socket = videoViewer.doApcp(dSPath.getIPAddress(), sessionStatus, 4, false);
                                    }
                                    Trace.logInfo((String)TRACE_CONTEXT, (String)("(VideoViewer) about to avspConnect userCredentialsThisPath username=" + object2.getUsername() + " password=" + object2.getPassword()));
                                    bl6 = this.avspConnect(socket, dSPath, (UsernamePassword)object2, null, string3, string2.length() == 0, n == vector.size() - 1);
                                }
                                // MONITOREXIT : object
                                if (this.m_bUserCancelled) {
                                    this.closeUserCancelDialog();
                                    break block92;
                                }
                                if (bl6 && usernamePassword.getUsername().length() > 0) {
                                    if (dSPath.getUCC()) {
                                        CachedCredentials.setCredentials((UsernamePassword)usernamePassword);
                                    }
                                    break block92;
                                }
                                m_htPendingConnections.remove(dSPath);
                                bl3 = false;
                                try {
                                    Thread.sleep(100L);
                                    continue;
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            break block92;
                        }
                        catch (Exception exception) {
                            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                            Object var26_48 = null;
                            Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.desktopMode.finally bRemoveDeviceIDFromHashtable=" + bl3));
                            if (!bl3) return;
                            m_htPendingConnections.remove(dSPath);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var26_49 = null;
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.desktopMode.finally bRemoveDeviceIDFromHashtable=" + bl3));
                        if (!bl3) throw throwable;
                        m_htPendingConnections.remove(dSPath);
                        throw throwable;
                    }
                }
                for (int i = 0; i < this.m_aszTDIDs.length; ++i) {
                    String string7 = i < this.m_aszTDNames.length ? this.m_aszTDNames[i] : "";
                    DSPath dSPath2 = new DSPath("", this.m_aszTDIDs[i], string7, false);
                    vector2.add(dSPath2);
                }
                JFrameThumbnail jFrameThumbnail = new JFrameThumbnail(null, this.m_szTitle, this.m_iFaceViewer, vector2, m_nApplication, this.m_propertiesLaunchArgs, this.m_szHelpURL);
                while (jFrameThumbnail.isAlive()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                throw new ExceptionRequestFailed("End of thumbnail mode");
            }
            while (!bl6) {
                sessionStatus = this.m_iFaceViewer.startSession(this.m_aszTDIDs[0], bl2 ? 1 : 0);
                if (sessionStatus == null) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer iFaceViewer.startSessson failed returned null");
                    Message.show(null, (String)RES.getString("videoViewer_Session_Start_Failed_Notice"));
                    throw new ExceptionRequestFailed("InterfaceViewer3 startSession failed");
                }
                if (this.m_bUserCancelled) {
                    this.closeUserCancelDialog();
                    throw new ExceptionRequestFailed("User cancelled");
                }
                int n = sessionStatus.getSessionStatusCode();
                Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.desktopMode nSessionStatusCode=" + n));
                switch (n) {
                    case 0: {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.desktopMode session status = STATUS_CONNECTED");
                        dSPath = new DSPath(sessionStatus.getIpAddress().getHostAddress(), this.m_aszTDIDs[0], this.m_aszTDNames[0], sessionStatus.hasApcp());
                        switch (bl2 ? 1 : 0) {
                            case 0: {
                                this.m_nConnectionType = 1;
                                break;
                            }
                            case 1: {
                                this.m_nConnectionType = 2;
                                break;
                            }
                            case 5: {
                                this.m_nConnectionType = 4;
                                this.logEventSession(5, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                                break;
                            }
                            case 6: {
                                this.m_nConnectionType = 5;
                                this.logEventSession(5, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                                break;
                            }
                            case 4: {
                                this.m_nConnectionType = 6;
                                break;
                            }
                        }
                        object = null;
                        if (sessionStatus.hasApcp()) {
                            try {
                                object = videoViewer.doApcp(sessionStatus.getIpAddress().getHostAddress(), sessionStatus, 8, false);
                            }
                            catch (Exception exception) {
                                Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                                Message.show(null, (String)RES.getString("videoViewer_FAILED_APCP_CONNECTION"));
                                throw new ExceptionRequestFailed("APCP connection failed");
                            }
                        }
                        bl6 = this.avspConnect((Socket)object, dSPath, null, sessionStatus, string3, false, true);
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.desktopMode returned from avspConnect bConnected=" + bl6));
                        break;
                    }
                    case 1: 
                    case 2: {
                        bl2 = this.userSelectSessionType(sessionStatus, bl7);
                        break;
                    }
                    case 7: {
                        this.closeUserCancelDialog();
                        JOptionPaneFixedSize.showFailureMessage((String)RES.getString("videoViewer_TOO_MANY_SESSIONS"));
                        throw new ExceptionRequestFailed("too many sessions");
                    }
                    case 5: {
                        this.closeUserCancelDialog();
                        JOptionPaneFixedSize.showFailureMessage((String)RES.getString("videoViewer_AUTHORIZATION_ERROR"));
                        throw new ExceptionRequestFailed("authorization error");
                    }
                    case 3: {
                        this.closeUserCancelDialog();
                        JOptionPaneFixedSize.showFailureMessage((String)RES.getString("videoViewer_UNAUTHORIZED_ERROR"));
                        throw new ExceptionRequestFailed("unauthorized error");
                    }
                    case 6: {
                        this.closeUserCancelDialog();
                        JOptionPaneFixedSize.showFailureMessage((String)RES.getString("videoViewer_UNAVAILABLE_ERROR"));
                        throw new ExceptionRequestFailed("unavailable error");
                    }
                    case 4: {
                        this.closeUserCancelDialog();
                        JOptionPaneFixedSize.showFailureMessage((String)RES.getString("videoViewer_UNGRADING_ERROR"));
                        throw new ExceptionRequestFailed("upgrading error");
                    }
                    default: {
                        this.closeUserCancelDialog();
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer desktopMode) unknown session status, throwing ExceptionRequestFailed");
                        throw new ExceptionRequestFailed("unknown session status result");
                    }
                }
                if (!this.m_bUserCancelled) continue;
                this.closeUserCancelDialog();
                throw new ExceptionRequestFailed("User cancelled");
            }
        }
        if (!bl6) {
            if (this.m_bUserCancelled) throw new ExceptionRequestFailed(RES.getString("videoViewer_Connection_not_established"));
            this.closeUserCancelDialog();
            Message.show(null, (String)(RES.getString("videoViewer_No_connection_could_be_established") + dSPath.getIPAddress()));
            throw new ExceptionRequestFailed(RES.getString("videoViewer_Connection_not_established"));
        }
        this.m_bAllowCancel = false;
        this.m_dlgElapsed.setEnableCancelButton(false);
        if (this.m_bUserCancelled) {
            this.closeUserCancelDialog();
            throw new ExceptionRequestFailed("User cancelled or login timeout has been exceeded");
        }
        ApplianceSession applianceSession = null;
        if (string4.compareToIgnoreCase("avsp") == 0 || string4.compareToIgnoreCase("jalapeno") == 0) {
            bl2 = this.m_nConnectionType == 4 || this.m_nConnectionType == 5 || this.m_nConnectionType == 6;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(VideoViewer) connected to appliance calling constructor for ApplianceSessionAVSP");
            applianceSession = new ApplianceSessionAVSP(this.m_iFaceViewer, sessionStatus, dSPath, string, this.m_disAppliance, this.m_dosAppliance, this.m_disApplianceVideo, this.m_dosApplianceVideo, this.m_szHelpURL, bl2, m_bRemote, this.m_nConnectionType == 6, this.m_nConnectionType == 5 || this.m_nConnectionType == 6, m_nApplication, this.m_avspStatus.getClientRandom(), this.m_avspStatus.getApplianceRandom());
        } else if (dSPath.isEmbeddedAppliance()) {
            int n;
            bl2 = false;
            boolean bl10 = false;
            if (string3.compareToIgnoreCase("tcpudp") == 0) {
                bl10 = true;
            } else if (string3.compareToIgnoreCase("udp") == 0) {
                bl2 = true;
                bl10 = true;
            }
            if (string4.compareToIgnoreCase("embeddedV1") == 0) {
                n = 3;
                if (bl10) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer.desktopMode) Connection type: " + string4 + " invalid for V1 appliance. Resetting to TCP"));
                    bl10 = false;
                    bl2 = false;
                }
            } else {
                n = 4;
            }
            applianceSession = new ApplianceSessionAERP(this.m_iFaceViewer, sessionStatus, dSPath, string, dSPath.getServerName(), n, this.m_disAppliance, this.m_dosAppliance, this.m_udpConnection, this.m_szHelpURL, bl5, bl2, bl10, bl4, m_nApplication);
        }
        applianceSession.setNotifyOnClosing(this);
        bl2 = false;
        if (sessionStatus != null) {
            bl2 = (sessionStatus.getSpecialRights() & 8) != 0;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("m_bVirtualMediaOnCommandLine=" + this.m_bVirtualMediaOnCommandLine));
        if (this.m_bVirtualMediaOnCommandLine) {
            applianceSession.setVirtualMediaAvailableForTD(this.m_bVirtualMediaAvailable);
        }
        applianceSession.setUserHasRightsToLaunchVirtualMedia(bl2);
        applianceSession.setLaunchProperties(this.m_propertiesLaunchArgs);
        applianceSession.setConnectionType(this.m_nConnectionType);
        while (applianceSession.isAlive()) {
            if (!this.m_bApplianceSessionRunning) {
                if (applianceSession.isSessionRunning() && applianceSession.getApplianceWindow() != null && applianceSession.getApplianceWindow().isVisible()) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer desktopMode) setting m_bApplianceSessionRunning flag true");
                    this.m_bApplianceSessionRunning = true;
                    this.m_dlgElapsed.setVisible(false);
                    this.m_dlgElapsed.dispose();
                    this.m_dlgElapsed = null;
                    applianceSession.removeNotifyOnClosing(this);
                    if (OS.isSolaris() && this.m_nConnectionType != 6 && this.m_nConnectionType != 5 && this.m_nConnectionType != 4) {
                        applianceSession.cmdAutoAdjustVideo();
                    }
                } else if (this.m_bUserCancelled) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer desktopMode) user cancelled");
                    this.closeUserCancelDialog();
                    applianceSession.terminateSession();
                    applianceSession.getApplianceWindow().terminate();
                    this.m_bApplianceSessionRunning = true;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Object var26_47 = null;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.desktopMode.finally bRemoveDeviceIDFromHashtable=" + bl3));
        if (!bl3) return;
        m_htPendingConnections.remove(dSPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int userSelectSessionType(SessionStatus sessionStatus, boolean bl) throws ExceptionRequestFailed {
        int n = 0;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer userSelectSessionType) getting connect possibilities");
        byte by = sessionStatus.getConnectPossibilities();
        boolean bl2 = (by & 1) == 1;
        boolean bl3 = (by & 2) == 2;
        boolean bl4 = (by & 4) == 4;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer desktopMode) sessionstatus.getConnectPossibilities bModesAvailable=" + Integer.toHexString(by) + " bPreempt=" + bl2 + " bShare=" + bl3 + " bStealth=" + bl4));
        if (!(bl2 || bl3 || bl4)) {
            this.closeUserCancelDialog();
            Message.show(null, (String)RES.getString("videoViewer_Server_Not_Available"));
            throw new ExceptionRequestFailed("sessionstatus.STATUS_BLOCKED");
        }
        String string = sessionStatus.getConnectedUserName();
        if ((sessionStatus.getSpecialRights() & 4) == 0) {
            string = null;
        }
        JDialogConnectionMode jDialogConnectionMode = new JDialogConnectionMode(null, bl3, bl2, bl4, true, this.m_aszTDNames[0], string, this.m_szHelpURL);
        jDialogConnectionMode.setModal(true);
        jDialogConnectionMode.setVisible(true);
        if (!jDialogConnectionMode.wasOkPressed()) throw new ExceptionRequestFailed("user cancelled from connection mode dialog");
        if (jDialogConnectionMode.getConnectionMode() == 2) {
            if (!bl) return 2;
            return 3;
        }
        if (jDialogConnectionMode.getConnectionMode() == 1) {
            if (!jDialogConnectionMode.wasPassiveShareSet()) return 5;
            return 6;
        }
        if (jDialogConnectionMode.getConnectionMode() != 3) throw new ExceptionRequestFailed("unknown connection type from connection mode dialog");
        return 4;
    }

    /*
     * Unable to fully structure code
     */
    private InterfaceViewer3 getIFaceViewer(String var1_1, DSPath var2_2) throws ExceptionRequestFailed {
        block9: {
            block6: {
                block8: {
                    block7: {
                        if (var1_1.length() != 0) break block6;
                        if (videoViewer.m_nApplication != 3 || !OS.isWindows()) break block7;
                        v0 = this;
                        if (!v0.m_libWin32.isWin32LibLoaded()) break block7;
                        var5_3 = this.m_libWin32.getLocalAppDataPath() + "\\NEC";
                        var6_8 = new File(var5_3);
                        var6_8.mkdir();
                        var4_13 = new PersistentStorage(var2_2.getIPAddress(), var2_2.getPortNumber(), var2_2.getRIPId(), var2_2.getCascadeChannel(), "\\", var5_3);
                        break block8;
                    }
                    if (videoViewer.m_nApplication != 4 || !OS.isWindows()) ** GOTO lbl-1000
                    v1 = this;
                    if (v1.m_libWin32.isWin32LibLoaded()) {
                        var5_4 = this.m_libWin32.getLocalAppDataPath() + "\\Dell";
                        var6_9 = new File(var5_4);
                        var6_9.mkdir();
                        var5_4 = var5_4 + "\\Rialto";
                        var6_9 = new File(var5_4);
                        var6_9.mkdir();
                        var4_13 = new PersistentStorage(var2_2.getIPAddress(), var2_2.getPortNumber(), var2_2.getRIPId(), var2_2.getCascadeChannel(), "\\", var5_4);
                    } else lbl-1000:
                    // 2 sources

                    {
                        var4_13 = new PersistentStorage(var2_2.getIPAddress(), var2_2.getPortNumber(), var2_2.getRIPId(), var2_2.getCascadeChannel());
                    }
                }
                var3_18 = var4_13;
                break block9;
            }
            try {
                var4_14 = Class.forName(var1_1);
                var3_18 = (InterfaceViewer3)var4_14.newInstance();
            }
            catch (ClassNotFoundException var4_15) {
                var5_5 = new Object[]{var1_1};
                var6_10 = MessageFormat.format(videoViewer.RES.getString("videoViewer_Bad_interface_class"), var5_5);
                UserNotification.InvalidParameterMessageBox(var6_10);
                throw new ExceptionRequestFailed("Class could not be found" + var4_15.getMessage());
            }
            catch (IllegalAccessException var4_16) {
                var5_6 = new Object[]{var1_1};
                var6_11 = MessageFormat.format(videoViewer.RES.getString("videoViewer_Bad_interface_class"), var5_6);
                UserNotification.InvalidParameterMessageBox(var6_11);
                throw new ExceptionRequestFailed("Illegal access exception" + var4_16.getMessage());
            }
            catch (InstantiationException var4_17) {
                var5_7 = new Object[]{var1_1};
                var6_12 = MessageFormat.format(videoViewer.RES.getString("videoViewer_Bad_interface_class"), var5_7);
                UserNotification.InvalidParameterMessageBox(var6_12);
                throw new ExceptionRequestFailed("Instantiation exception" + var4_17.getMessage());
            }
        }
        return var3_18;
    }

    private boolean avspConnect(Socket socket, DSPath dSPath, UsernamePassword usernamePassword, SessionStatus sessionStatus, String string, boolean bl, boolean bl2) {
        boolean bl3;
        block134: {
            bl3 = false;
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                int n = 0;
                do {
                    Object object;
                    int n2;
                    Closeable closeable;
                    Socket socket2 = null;
                    if (sessionStatus != null) {
                        socket2 = videoViewer.connectSSLSession(socket, sessionStatus, false, sessionStatus.hasApcp());
                    } else {
                        if (socket == null && string.equalsIgnoreCase("AVSP-CLEAR")) {
                            socket2 = videoViewer.ProxySelectorOffSocket(dSPath.getIPAddress(), 2068);
                        } else {
                            closeable = null;
                            closeable = socket == null ? videoViewer.ProxySelectorOffSocket(dSPath.getIPAddress(), 2068) : socket;
                            socket2 = SSLHelper.createSSLSocket((Socket)closeable, (String)dSPath.getIPAddress(), (int)closeable.getPort(), (int)30000, null, null, null);
                        }
                        if (socket2 == null || this.m_bUserCancelled) {
                            return false;
                        }
                        socket2.setTcpNoDelay(true);
                    }
                    closeable = new BufferedOutputStream(socket2.getOutputStream());
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(socket2.getInputStream());
                    this.m_dosAppliance = new DataOutputStreamEndian((OutputStream)closeable);
                    this.m_disAppliance = new DataInputStreamEndian(bufferedInputStream, socket2);
                    socket2.setSoTimeout(30000);
                    if (sessionStatus != null) {
                        DSConnect.dsConnectApplianceAVSP(this.m_dosAppliance, this.m_disAppliance, this.m_avspStatus);
                    } else if (m_nApplication == 1 && dSPath.hasApcp()) {
                        DSConnect.dsConnectApplianceAVSP(this.m_dosAppliance, this.m_disAppliance, dSPath, usernamePassword.getUsername(), usernamePassword.getPassword(), (byte)n, this.m_avspStatus);
                    } else {
                        DSConnect.dsConnectApplianceAVSP(this.m_dosAppliance, this.m_disAppliance, dSPath, usernamePassword.getUsername(), usernamePassword.getPassword(), bl4, this.m_avspStatus);
                    }
                    socket2.setSoTimeout(0);
                    if (this.m_avspStatus.getLoginStatus() == 0) {
                        Object object2;
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect login succeeded");
                        Socket socket3 = null;
                        boolean bl6 = false;
                        String string2 = "";
                        if (sessionStatus != null) {
                            bl6 = sessionStatus.hasApcp();
                            string2 = sessionStatus.getIpAddress().getHostAddress();
                        } else if (dSPath != null) {
                            bl6 = dSPath.hasApcp();
                            string2 = dSPath.getIPAddress();
                        }
                        if (sessionStatus == null) {
                            switch (n) {
                                case 0: {
                                    Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect setting connection type to normal");
                                    this.m_nConnectionType = 1;
                                    break;
                                }
                                case 1: {
                                    Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect setting connection type to share");
                                    this.m_nConnectionType = 4;
                                    if (!this.m_avspStatus.isPassiveSession()) break;
                                    Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect setting connection type to passive");
                                    this.m_nConnectionType = 5;
                                    break;
                                }
                                case 2: {
                                    Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect setting connection type to stealth");
                                    this.m_nConnectionType = 6;
                                }
                            }
                        }
                        int n3 = n2 = bl6 ? 2068 : 8192;
                        if (bl6) {
                            int n4 = 1;
                            if (this.m_avspStatus.isVideoEncrypted()) {
                                n4 = sessionStatus == null ? 4 : 8;
                            }
                            socket3 = videoViewer.doApcp(string2, sessionStatus, n4, true);
                        } else if (sessionStatus != null && sessionStatus.isProxied()) {
                            n2 = sessionStatus.getPortVideo();
                            Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.avspConnect using proxy, creating proxy to IP address=" + dSPath.getIPAddress() + " TCP port=" + n2));
                            object2 = new ProxyClient(dSPath.getIPAddress(), n2, 0);
                            n2 = object2.openServerSocket(sessionStatus.getProxySessionIdVideo());
                            string2 = "127.0.0.1";
                            socket3 = videoViewer.ProxySelectorOffSocket(string2, n2);
                        }
                        if (this.m_avspStatus.isVideoEncrypted()) {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect video is to be encrypted");
                            if (sessionStatus != null) {
                                object = videoViewer.connectSSLSession(socket3, sessionStatus, true, sessionStatus.hasApcp());
                            } else {
                                if (socket3 == null) {
                                    socket3 = videoViewer.ProxySelectorOffSocket(string2, n2);
                                }
                                object = SSLHelper.createSSLSocket((Socket)socket3, (String)string2, (int)n2, (int)30000, null, null, null);
                            }
                            if (object != null) {
                                Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.avspConnect Cipher Suite=" + ((SSLSocket)object).getSession().getCipherSuite()));
                            } else {
                                Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect socketVideo = null");
                            }
                        } else {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)("videoViewer.avspConnect video is NOT to be encrypted, connecting to " + string2 + " port=" + n2));
                            object = socket3 == null ? videoViewer.ProxySelectorOffSocket(string2, n2) : socket3;
                        }
                        if (object == null) {
                            return false;
                        }
                        ((Socket)object).setTcpNoDelay(true);
                        ((Socket)object).setReceiveBufferSize(32768);
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("Video Socket connected to: " + ((Socket)object).getInetAddress().getHostAddress().toString()));
                        object2 = new BufferedOutputStream(((Socket)object).getOutputStream());
                        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(((Socket)object).getInputStream());
                        this.m_dosApplianceVideo = new DataOutputStreamEndian((OutputStream)object2);
                        this.m_disApplianceVideo = new DataInputStreamEndian(bufferedInputStream2, (Socket)object);
                        ((Socket)object).setSoTimeout(30000);
                        if (DSConnect.dsConnectVideoAVSP(this.m_dosApplianceVideo, this.m_disApplianceVideo, this.m_avspStatus.getClientRandom(), this.m_avspStatus.getApplianceRandom())) {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect dsConnectVideoAVSP succeeded");
                            ((Socket)object).setSoTimeout(0);
                            bl3 = true;
                            bl4 = false;
                            n = 0;
                            if (this.m_bUserCancelled) {
                                this.m_dosAppliance.close();
                                this.m_disAppliance.close();
                                this.m_disAppliance.getSocket().close();
                                this.m_dosApplianceVideo.close();
                                this.m_disApplianceVideo.close();
                                Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) returning false the user cancelled after login succeeded");
                                return false;
                            }
                            break;
                        }
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect dsConnectVideoAVSP failed, closing all data streams");
                        this.m_dosAppliance.close();
                        this.m_disAppliance.close();
                        this.m_dosApplianceVideo.close();
                        this.m_disApplianceVideo.close();
                        continue;
                    }
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect dsConnectApplianceAVSP failed, closing all data streams");
                    this.m_dosAppliance.close();
                    this.m_disAppliance.getSocket().close();
                    this.m_disAppliance.close();
                    if (this.m_bUserCancelled) {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) returning false the login failed and the user cancelled");
                        return false;
                    }
                    if (!bl2) {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) returning false the login failed and bDisplayErrorMessage false");
                        return false;
                    }
                    switch (this.m_avspStatus.getLoginStatus()) {
                        case 1: 
                        case 2: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, INVALID USER NAME returned by appliance");
                            bl4 = false;
                            this.showUserCancelDialog(false);
                            Message.show((Component)this.m_fLoginDialogParent, (String)RES.getString("videoViewer_Invalid_UserName"));
                            object = new JDialogLogin(this.m_fLoginDialogParent, RES.getString("videoViewer_Login"), usernamePassword);
                            object.setModal(true);
                            object.setVisible(true);
                            if (object.wasOkPressed()) {
                                bl5 = true;
                                this.showUserCancelDialog(true);
                                break;
                            }
                            this.closeUserCancelDialog();
                            bl4 = false;
                            break;
                        }
                        case -2: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN_FAILED_TIMEOUT, login timeout at socket");
                            bl4 = false;
                            this.closeUserCancelDialog();
                            this.logEventSession(4, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            object = new Object[]{dSPath.getDisplayName()};
                            String string3 = MessageFormat.format(RES.getString("videoViewer_Time_Time_Out_Error"), (Object[])object);
                            Message.show(null, (String)string3);
                            break;
                        }
                        case 3: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL ACCESS DENIED returned by appliance");
                            bl4 = false;
                            this.closeUserCancelDialog();
                            this.logEventSession(4, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("videoViewer_Channel_Access_Denied"));
                            break;
                        }
                        case 4: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE returned by appliance");
                            bl4 = false;
                            this.showUserCancelDialog(false);
                            if (this.m_avspStatus.isSharingAvailable() || this.m_avspStatus.isPreemptionAvailable() || this.m_avspStatus.isStealthModeAvailable()) {
                                object = new JDialogConnectionMode(null, this.m_avspStatus.isSharingAvailable(), this.m_avspStatus.isPreemptionAvailable(), this.m_avspStatus.isStealthModeAvailable(), false, dSPath.getServerName(), this.m_avspStatus.getUserName(), this.m_szHelpURL);
                                object.setModal(true);
                                object.setVisible(true);
                                if (((JDialogConnectionMode)((Object)object)).wasOkPressed()) {
                                    int n5 = ((JDialogConnectionMode)((Object)object)).getConnectionMode();
                                    switch (n5) {
                                        case 1: {
                                            n = 1;
                                            bl4 = true;
                                            this.m_dlgElapsed = new JDialogWaitingForShareRequest(null, this.m_avspStatus.getUserName(), this.m_avspStatus.getShareRequestTimeout());
                                            this.showUserCancelDialog(true);
                                            break;
                                        }
                                        case 2: {
                                            n = 6;
                                            bl4 = true;
                                            if (this.m_avspStatus.isPreemptionTimeoutAvailable()) {
                                                this.m_dlgElapsed = new JDialogWaitingForPreemption(null, this.m_avspStatus.getUserName(), this.m_avspStatus.doesPreemptedUserHaveRightToRejectPreemption(), this.m_avspStatus.getPreemptionTimeout());
                                            }
                                            this.showUserCancelDialog(true);
                                            break;
                                        }
                                        case 3: {
                                            n = 2;
                                            bl4 = true;
                                            this.showUserCancelDialog(true);
                                        }
                                    }
                                    this.showUserCancelDialog(true);
                                    break;
                                }
                                this.closeUserCancelDialog();
                                break;
                            }
                            this.closeUserCancelDialog();
                            UserNotification.ServerNotAvailableForViewingChannelInUse(dSPath.getDisplayName(), RES.getString("videoViewer_Channel_In_Use"), this.m_avspStatus.getUserName());
                            break;
                        }
                        case 5: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL NOT FOUND returned by appliance");
                            bl4 = false;
                            this.closeUserCancelDialog();
                            this.logEventSession(4, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("videoViewer_Channel_Not_Found"));
                            break;
                        }
                        case 6: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, SERVER NOT AVAILABLE, CAN PRE-EMPT returned by appliance");
                            this.showUserCancelDialog(false);
                            bl4 = UserNotification.ServerNotAvailableCanBePreempted(dSPath.getDisplayName(), this.m_avspStatus.getUserName(), bl);
                            if (bl4) {
                                this.showUserCancelDialog(true);
                                break;
                            }
                            this.closeUserCancelDialog();
                            break;
                        }
                        case 7: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE BY LOCAL USER returned by appliance");
                            bl4 = false;
                            this.showUserCancelDialog(false);
                            if (this.m_avspStatus.isSharingAvailable() || this.m_avspStatus.isPreemptionAvailable() || this.m_avspStatus.isStealthModeAvailable()) {
                                object = new JDialogConnectionMode(null, this.m_avspStatus.isSharingAvailable(), this.m_avspStatus.isPreemptionAvailable(), this.m_avspStatus.isStealthModeAvailable(), false, dSPath.getServerName(), this.m_avspStatus.getUserName(), this.m_szHelpURL);
                                object.setModal(true);
                                object.setVisible(true);
                                if (((JDialogConnectionMode)((Object)object)).wasOkPressed()) {
                                    int n6 = ((JDialogConnectionMode)((Object)object)).getConnectionMode();
                                    switch (n6) {
                                        case 1: {
                                            n = 1;
                                            bl4 = true;
                                            this.m_dlgElapsed = new JDialogWaitingForShareRequest(null, this.m_avspStatus.getUserName(), this.m_avspStatus.getShareRequestTimeout());
                                            this.showUserCancelDialog(true);
                                            break;
                                        }
                                        case 2: {
                                            n = 6;
                                            bl4 = true;
                                            if (this.m_avspStatus.isPreemptionTimeoutAvailable()) {
                                                this.m_dlgElapsed = new JDialogWaitingForPreemption(null, this.m_avspStatus.getUserName(), this.m_avspStatus.doesPreemptedUserHaveRightToRejectPreemption(), this.m_avspStatus.getPreemptionTimeout());
                                            }
                                            this.showUserCancelDialog(true);
                                            break;
                                        }
                                        case 3: {
                                            n = 2;
                                            bl4 = true;
                                            this.showUserCancelDialog(true);
                                        }
                                    }
                                    this.showUserCancelDialog(true);
                                    break;
                                }
                                this.closeUserCancelDialog();
                                break;
                            }
                            this.closeUserCancelDialog();
                            UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("videoViewer_Channel_In_Use_By_Local_User"));
                            break;
                        }
                        case 12: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE BY EXCLUSIVE LOCAL USER returned by appliance");
                            bl4 = false;
                            this.showUserCancelDialog(false);
                            if (this.m_avspStatus.isSharingAvailable() || this.m_avspStatus.isPreemptionAvailable() || this.m_avspStatus.isStealthModeAvailable()) {
                                object = new JDialogConnectionMode(null, this.m_avspStatus.isSharingAvailable(), this.m_avspStatus.isPreemptionAvailable(), this.m_avspStatus.isStealthModeAvailable(), false, dSPath.getServerName(), this.m_avspStatus.getUserName(), this.m_szHelpURL);
                                object.setModal(true);
                                object.setVisible(true);
                                if (((JDialogConnectionMode)((Object)object)).wasOkPressed()) {
                                    int n7 = ((JDialogConnectionMode)((Object)object)).getConnectionMode();
                                    switch (n7) {
                                        case 1: {
                                            n = 1;
                                            bl4 = true;
                                            this.m_dlgElapsed = new JDialogWaitingForShareRequest(null, this.m_avspStatus.getUserName(), this.m_avspStatus.getShareRequestTimeout());
                                            this.showUserCancelDialog(true);
                                            break;
                                        }
                                        case 2: {
                                            n = 6;
                                            bl4 = true;
                                            if (this.m_avspStatus.isPreemptionTimeoutAvailable()) {
                                                this.m_dlgElapsed = new JDialogWaitingForPreemption(null, this.m_avspStatus.getUserName(), this.m_avspStatus.doesPreemptedUserHaveRightToRejectPreemption(), this.m_avspStatus.getPreemptionTimeout());
                                            }
                                            this.showUserCancelDialog(true);
                                            break;
                                        }
                                        case 3: {
                                            n = 2;
                                            bl4 = true;
                                            this.showUserCancelDialog(true);
                                        }
                                    }
                                    this.showUserCancelDialog(true);
                                    break;
                                }
                                this.closeUserCancelDialog();
                                break;
                            }
                            this.closeUserCancelDialog();
                            UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("videoViewer_Channel_In_Use_By_Exclusive_Local_User"));
                            break;
                        }
                        case 11: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE BY LOCAL USER, CAN PRE-EMPT returned by appliance");
                            this.showUserCancelDialog(false);
                            bl4 = UserNotification.ServerNotAvailableCanBePreempted(dSPath.getDisplayName(), RES.getString("videoViewer_Switch_Local_Port"), bl);
                            if (bl4) {
                                this.showUserCancelDialog(true);
                                break;
                            }
                            this.closeUserCancelDialog();
                            break;
                        }
                        case 8: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, ALL CHANNELS IN USE returned by appliance");
                            bl4 = false;
                            this.closeUserCancelDialog();
                            this.logEventSession(4, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("videoViewer_All_Channels_In_Use"));
                            break;
                        }
                        case 9: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, INSUFFICIENT ACCESS RIGHTS returned by appliance");
                            bl4 = false;
                            this.closeUserCancelDialog();
                            this.logEventSession(4, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            Message.show(null, (String)RES.getString("videoViewer_Insufficient_Access_Rights"));
                            break;
                        }
                        case 22: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, Network Authentication Error returned by appliance");
                            bl4 = false;
                            this.closeUserCancelDialog();
                            this.logEventSession(4, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            Message.show(null, (String)RES.getString("videoViewer_Login_Failure_Auth_Server"));
                            break;
                        }
                        case 23: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, Invalid or Expired Certificate Error returned by appliance");
                            bl4 = false;
                            this.closeUserCancelDialog();
                            this.logEventSession(4, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            Message.show(null, (String)RES.getString("videoViewer_Login_Failure_Invalid_Expired_Cert_Auth_Server"));
                            break;
                        }
                        case 10: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, USER LOCKED OUT returned by appliance");
                            bl4 = false;
                            this.closeUserCancelDialog();
                            this.logEventSession(4, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("videoViewer_User_Locked_Out"));
                            break;
                        }
                        case 13: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL UPGRADE IN PROGRESS returned by appliance");
                            bl4 = false;
                            this.closeUserCancelDialog();
                            this.logEventSession(4, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("videoViewer_Channel_Upgrade_In_Progress"));
                            break;
                        }
                        case 14: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE BY EXCLUSIVE USER returned by appliance");
                            bl4 = false;
                            this.showUserCancelDialog(false);
                            if (this.m_avspStatus.isSharingAvailable() || this.m_avspStatus.isPreemptionAvailable() || this.m_avspStatus.isStealthModeAvailable()) {
                                object = new JDialogConnectionMode(null, this.m_avspStatus.isSharingAvailable(), this.m_avspStatus.isPreemptionAvailable(), this.m_avspStatus.isStealthModeAvailable(), false, dSPath.getServerName(), this.m_avspStatus.getUserName(), this.m_szHelpURL);
                                object.setModal(true);
                                object.setVisible(true);
                                if (((JDialogConnectionMode)((Object)object)).wasOkPressed()) {
                                    int n8 = ((JDialogConnectionMode)((Object)object)).getConnectionMode();
                                    switch (n8) {
                                        case 1: {
                                            n = 1;
                                            bl4 = true;
                                            this.m_dlgElapsed = new JDialogWaitingForShareRequest(null, this.m_avspStatus.getUserName(), this.m_avspStatus.getShareRequestTimeout());
                                            this.showUserCancelDialog(true);
                                            break;
                                        }
                                        case 2: {
                                            n = 6;
                                            bl4 = true;
                                            if (this.m_avspStatus.isPreemptionTimeoutAvailable()) {
                                                this.m_dlgElapsed = new JDialogWaitingForPreemption(null, this.m_avspStatus.getUserName(), this.m_avspStatus.doesPreemptedUserHaveRightToRejectPreemption(), this.m_avspStatus.getPreemptionTimeout());
                                            }
                                            this.showUserCancelDialog(true);
                                            break;
                                        }
                                        case 3: {
                                            n = 2;
                                            bl4 = true;
                                            this.showUserCancelDialog(true);
                                        }
                                    }
                                    this.showUserCancelDialog(true);
                                    break;
                                }
                                this.closeUserCancelDialog();
                                break;
                            }
                            this.closeUserCancelDialog();
                            UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("videoViewer_Channel_In_Use_By_Exclusive_User"));
                            break;
                        }
                        case 15: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, SHARE REQUEST DENIED returned by appliance");
                            bl4 = false;
                            this.closeUserCancelDialog();
                            this.logEventSession(6, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("videoViewer_Channel_Share_Request_Denied"));
                            break;
                        }
                        case 16: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, SHARE REQUEST TIMED OUT returned by appliance");
                            bl4 = false;
                            this.closeUserCancelDialog();
                            this.logEventSession(7, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("videoViewer_Channel_Share_Request_Timed_Out"));
                            break;
                        }
                        case 17: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, EXCLUSIVE REQUEST FAILED returned by appliance");
                            bl4 = false;
                            this.closeUserCancelDialog();
                            UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("videoViewer_Channel_Exclusive_Request_Failed"));
                            break;
                        }
                        case 18: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE, or PEM BLOCKAGE returned by appliance");
                            bl4 = false;
                            this.showUserCancelDialog(false);
                            if (this.m_avspStatus.isSharingAvailable() || this.m_avspStatus.isPreemptionAvailable() || this.m_avspStatus.isStealthModeAvailable()) {
                                object = new JDialogConnectionMode(null, this.m_avspStatus.isSharingAvailable(), this.m_avspStatus.isPreemptionAvailable(), this.m_avspStatus.isStealthModeAvailable(), false, dSPath.getServerName(), this.m_avspStatus.getUserName(), this.m_szHelpURL);
                                object.setModal(true);
                                object.setVisible(true);
                                if (((JDialogConnectionMode)((Object)object)).wasOkPressed()) {
                                    int n9 = ((JDialogConnectionMode)((Object)object)).getConnectionMode();
                                    switch (n9) {
                                        case 1: {
                                            n = 1;
                                            bl4 = true;
                                            this.m_dlgElapsed = new JDialogWaitingForShareRequest(null, this.m_avspStatus.getUserName(), this.m_avspStatus.getShareRequestTimeout());
                                            this.showUserCancelDialog(true);
                                            break;
                                        }
                                        case 2: {
                                            n = 6;
                                            bl4 = true;
                                            if (this.m_avspStatus.isPreemptionTimeoutAvailable()) {
                                                this.m_dlgElapsed = new JDialogWaitingForPreemption(null, this.m_avspStatus.getUserName(), this.m_avspStatus.doesPreemptedUserHaveRightToRejectPreemption(), this.m_avspStatus.getPreemptionTimeout());
                                            }
                                            this.showUserCancelDialog(true);
                                            break;
                                        }
                                        case 3: {
                                            n = 2;
                                            bl4 = true;
                                            this.showUserCancelDialog(true);
                                        }
                                    }
                                    this.showUserCancelDialog(true);
                                    break;
                                }
                                this.closeUserCancelDialog();
                                break;
                            }
                            this.closeUserCancelDialog();
                            object = new Object[]{BrandNaming.getServerName(false, true)};
                            String string4 = MessageFormat.format(RES.getString("videoViewer_Server_Not_Available_For_Viewing_Title"), (Object[])object);
                            object = new Object[]{this.m_avspStatus.getUserName()};
                            String string5 = MessageFormat.format(RES.getString("videoViewer_CHANNEL_IN_USE_BY"), (Object[])object);
                            object = new Object[]{dSPath.getDisplayName(), string5};
                            String string6 = MessageFormat.format(RES.getString("videoViewer_CHANNEL_IN_USE_WITH_REASON"), (Object[])object);
                            JOptionPane.showMessageDialog(null, string6, string4, 1);
                            break;
                        }
                        case 19: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PEM BLOCKAGE, CAN PRE-EMPT returned by appliance");
                            this.showUserCancelDialog(false);
                            object = new Object[]{this.m_avspStatus.getUserName()};
                            String string7 = MessageFormat.format(RES.getString("videoViewer_CHANNEL_IN_USE_BY"), (Object[])object);
                            object = new Object[]{dSPath.getDisplayName(), string7};
                            String string8 = MessageFormat.format(RES.getString("videoViewer_CHANNEL_IN_USE_WITH_REASON_CAN_PREEMPT"), (Object[])object);
                            object = new Object[]{BrandNaming.getServerName(bl, true)};
                            String string9 = MessageFormat.format(RES.getString("videoViewer_Server_Not_Available_For_Viewing_Title"), (Object[])object);
                            n2 = JOptionPaneFixedSize.showConfirmDialog(null, (Object)string8, (String)string9, (int)0, (int)3);
                            boolean bl7 = bl4 = n2 == 0;
                            if (bl4) {
                                this.showUserCancelDialog(true);
                                break;
                            }
                            this.closeUserCancelDialog();
                            break;
                        }
                        case 20: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE BY LOCAL USER returned by appliance");
                            bl4 = false;
                            this.showUserCancelDialog(false);
                            this.logEventSession(4, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            if (this.m_avspStatus.isSharingAvailable() || this.m_avspStatus.isPreemptionAvailable() || this.m_avspStatus.isStealthModeAvailable()) {
                                object = new JDialogConnectionMode(null, this.m_avspStatus.isSharingAvailable(), this.m_avspStatus.isPreemptionAvailable(), this.m_avspStatus.isStealthModeAvailable(), false, dSPath.getServerName(), this.m_avspStatus.getUserName(), this.m_szHelpURL);
                                object.setModal(true);
                                object.setVisible(true);
                                if (((JDialogConnectionMode)((Object)object)).wasOkPressed()) {
                                    int n10 = ((JDialogConnectionMode)((Object)object)).getConnectionMode();
                                    switch (n10) {
                                        case 1: {
                                            n = 1;
                                            bl4 = true;
                                            this.m_dlgElapsed = new JDialogWaitingForShareRequest(null, this.m_avspStatus.getUserName(), this.m_avspStatus.getShareRequestTimeout());
                                            this.showUserCancelDialog(true);
                                            break;
                                        }
                                        case 2: {
                                            n = 6;
                                            bl4 = true;
                                            if (this.m_avspStatus.isPreemptionTimeoutAvailable()) {
                                                this.m_dlgElapsed = new JDialogWaitingForPreemption(null, this.m_avspStatus.getUserName(), this.m_avspStatus.doesPreemptedUserHaveRightToRejectPreemption(), this.m_avspStatus.getPreemptionTimeout());
                                            }
                                            this.showUserCancelDialog(true);
                                            break;
                                        }
                                        case 3: {
                                            n = 2;
                                            bl4 = true;
                                            this.showUserCancelDialog(true);
                                        }
                                    }
                                    this.showUserCancelDialog(true);
                                    break;
                                }
                                this.closeUserCancelDialog();
                                break;
                            }
                            this.closeUserCancelDialog();
                            object = new Object[]{BrandNaming.getServerName(false, true)};
                            String string10 = MessageFormat.format(RES.getString("videoViewer_Server_Not_Available_For_Viewing_Title"), (Object[])object);
                            object = new Object[]{dSPath.getDisplayName(), RES.getString("videoViewer_Channel_In_Use_By_Local_User")};
                            String string11 = MessageFormat.format(RES.getString("videoViewer_CHANNEL_IN_USE_WITH_REASON"), (Object[])object);
                            JOptionPane.showMessageDialog(null, string11, string10, 1);
                            break;
                        }
                        case 21: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PEM BLOCKAGE, CAN PRE-EMPT returned by appliance");
                            this.showUserCancelDialog(false);
                            object = new Object[]{dSPath.getDisplayName(), RES.getString("videoViewer_Channel_In_Use_By_Local_User")};
                            String string12 = MessageFormat.format(RES.getString("videoViewer_CHANNEL_IN_USE_WITH_REASON_CAN_PREEMPT"), (Object[])object);
                            object = new Object[]{BrandNaming.getServerName(bl, true)};
                            String string13 = MessageFormat.format(RES.getString("videoViewer_Server_Not_Available_For_Viewing_Title"), (Object[])object);
                            int n11 = JOptionPaneFixedSize.showConfirmDialog(null, (Object)string12, (String)string13, (int)0, (int)3);
                            boolean bl8 = bl4 = n11 == 0;
                            if (bl4) {
                                this.showUserCancelDialog(true);
                                break;
                            }
                            this.closeUserCancelDialog();
                            break;
                        }
                        case 50: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE BY LOCAL USER, CAN PRE-EMPT, TIMEOUT INFO returned by appliance");
                            this.m_bLocalUserUsingChannelWeArePreempting = true;
                            this.showUserCancelDialog(false);
                            bl4 = UserNotification.ServerNotAvailableCanBePreempted(dSPath.getDisplayName(), RES.getString("videoViewer_Switch_Local_Port"), bl);
                            if (bl4) {
                                if (this.m_avspStatus.isPreemptionTimeoutAvailable()) {
                                    this.m_dlgElapsed = new JDialogWaitingForPreemption(null, RES.getString("videoViewer_Switch_Local_Port"), this.m_avspStatus.canOtherUserRejectPreemption(), this.m_avspStatus.getPreemptionTimeout());
                                }
                                this.showUserCancelDialog(true);
                                break;
                            }
                            this.closeUserCancelDialog();
                            break;
                        }
                        case 51: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, SERVER NOT AVAILABLE, CAN PRE-EMPT, TIMEOUT INFO returned by appliance");
                            this.m_bLocalUserUsingChannelWeArePreempting = false;
                            this.showUserCancelDialog(false);
                            bl4 = UserNotification.ServerNotAvailableCanBePreempted(dSPath.getDisplayName(), this.m_avspStatus.getUserName(), bl);
                            if (bl4) {
                                if (this.m_avspStatus.isPreemptionTimeoutAvailable()) {
                                    this.m_dlgElapsed = new JDialogWaitingForPreemption(null, this.m_avspStatus.getUserName(), this.m_avspStatus.canOtherUserRejectPreemption(), this.m_avspStatus.getPreemptionTimeout());
                                }
                                this.showUserCancelDialog(true);
                                break;
                            }
                            this.closeUserCancelDialog();
                            break;
                        }
                        case 52: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PREEMPT REJECTED returned by appliance");
                            bl4 = false;
                            this.closeUserCancelDialog();
                            this.logEventSession(4, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            object = this.m_bLocalUserUsingChannelWeArePreempting ? new Object[]{RES.getString("videoViewer_Switch_Local_Port_Cap"), dSPath.getDisplayName()} : new Object[]{this.m_avspStatus.getUserName(), dSPath.getDisplayName()};
                            String string14 = MessageFormat.format(RES.getString("videoViewer_PREEMPTION_REJECTED"), (Object[])object);
                            JOptionPane.showMessageDialog(null, string14, RES.getString("videoViewer_PREEMPTION_REJECTED_TITLE"), 1);
                            break;
                        }
                        case 53: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PEM BLOCKAGE BY LOCAL USER, CAN PRE-EMPT, TIMEOUT INFO returned by appliance");
                            this.m_bLocalUserUsingChannelWeArePreempting = true;
                            this.showUserCancelDialog(false);
                            object = new Object[]{this.m_avspStatus.getUserName()};
                            String string15 = MessageFormat.format(RES.getString("videoViewer_CHANNEL_IN_USE_BY"), (Object[])object);
                            object = new Object[]{dSPath.getDisplayName(), string15};
                            String string16 = MessageFormat.format(RES.getString("videoViewer_CHANNEL_IN_USE_WITH_REASON_CAN_PREEMPT"), (Object[])object);
                            object = new Object[]{BrandNaming.getServerName(bl, true)};
                            String string17 = MessageFormat.format(RES.getString("videoViewer_Server_Not_Available_For_Viewing_Title"), (Object[])object);
                            n2 = JOptionPaneFixedSize.showConfirmDialog(null, (Object)string16, (String)string17, (int)0, (int)3);
                            boolean bl9 = bl4 = n2 == 0;
                            if (bl4) {
                                if (this.m_avspStatus.isPreemptionTimeoutAvailable()) {
                                    this.m_dlgElapsed = new JDialogWaitingForPreemption(null, RES.getString("videoViewer_Switch_Local_Port"), this.m_avspStatus.canOtherUserRejectPreemption(), this.m_avspStatus.getPreemptionTimeout());
                                }
                                this.showUserCancelDialog(true);
                                break;
                            }
                            this.closeUserCancelDialog();
                            break;
                        }
                        case 54: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PEM BLOCKAGE, CAN PRE-EMPT, TIMEOUT INFO returned by appliance");
                            this.m_bLocalUserUsingChannelWeArePreempting = false;
                            this.showUserCancelDialog(false);
                            object = new Object[]{this.m_avspStatus.getUserName()};
                            String string18 = MessageFormat.format(RES.getString("videoViewer_CHANNEL_IN_USE_BY"), (Object[])object);
                            object = new Object[]{dSPath.getDisplayName(), string18};
                            String string19 = MessageFormat.format(RES.getString("videoViewer_CHANNEL_IN_USE_WITH_REASON_CAN_PREEMPT"), (Object[])object);
                            object = new Object[]{BrandNaming.getServerName(bl, true)};
                            String string20 = MessageFormat.format(RES.getString("videoViewer_Server_Not_Available_For_Viewing_Title"), (Object[])object);
                            n2 = JOptionPaneFixedSize.showConfirmDialog(null, (Object)string19, (String)string20, (int)0, (int)3);
                            boolean bl10 = bl4 = n2 == 0;
                            if (bl4) {
                                if (this.m_avspStatus.isPreemptionTimeoutAvailable()) {
                                    this.m_dlgElapsed = new JDialogWaitingForPreemption(null, this.m_avspStatus.getUserName(), this.m_avspStatus.canOtherUserRejectPreemption(), this.m_avspStatus.getPreemptionTimeout());
                                }
                                this.showUserCancelDialog(true);
                                break;
                            }
                            this.closeUserCancelDialog();
                            break;
                        }
                        case 60: {
                            this.logEventSession(4, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            break;
                        }
                        case 61: {
                            this.logEventSession(4, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            break;
                        }
                        case 62: {
                            break;
                        }
                        case 63: {
                            break;
                        }
                        case 64: {
                            break;
                        }
                        default: {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer avspConnect) default returned by appliance avspStatus.getLoginStatus()=" + this.m_avspStatus.getLoginStatus()));
                            bl4 = false;
                            this.closeUserCancelDialog();
                            this.logEventSession(4, dSPath.getDeviceID(), sessionStatus, this.m_iFaceViewer);
                            UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("videoViewer_Unknown_error"));
                        }
                    }
                    if (!bl4 && !bl5 && this.m_bUserCancelled || !dSPath.hasApcp()) continue;
                    socket = videoViewer.doApcp(dSPath.getIPAddress(), sessionStatus, sessionStatus == null ? 4 : 8, false);
                } while (bl4 || bl5 || !this.m_bUserCancelled);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                if (this.m_bUserCancelled) break block134;
                Message.show(null, (String)RES.getString("videoViewer_Network_Connect_Error"));
                this.m_bUserCancelled = true;
            }
        }
        return bl3;
    }

    private boolean embeddedConnect(DSPath dSPath, String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.compareToIgnoreCase("tcpudp") == 0) {
            bl3 = true;
        } else if (string.compareToIgnoreCase("udp") == 0) {
            bl2 = true;
            bl3 = true;
        }
        String string2 = dSPath.getDeviceType();
        if (string2.compareToIgnoreCase("embeddedV1") == 0 && bl3) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer embeddedConnect) Connection type: " + string + " invalid for V1 appliance. Resetting to TCP"));
            bl3 = false;
            bl2 = false;
        }
        try {
            Object object;
            if (!bl2) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer embeddedConnect)Attempting TCP Socket connection to: " + dSPath.getIPAddress() + " Port=" + 2000));
                object = new Socket(InetAddress.getByName(dSPath.getIPAddress()), 2000);
                ((Socket)object).setTcpNoDelay(true);
                ((Socket)object).setReceiveBufferSize(32768);
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer embeddedConnect)Socket connected to: " + ((Socket)object).getInetAddress().getHostAddress().toString()));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(((Socket)object).getOutputStream());
                BufferedInputStream bufferedInputStream = new BufferedInputStream(((Socket)object).getInputStream());
                this.m_dosAppliance = new DataOutputStreamEndian(bufferedOutputStream);
                this.m_disAppliance = new DataInputStreamEndian(bufferedInputStream, (Socket)object);
            }
            if (bl2 || bl3) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer embeddedConnect)Attempting UDP socket connection to: " + dSPath.getIPAddress() + " Port=" + 623));
                this.m_udpConnection = new DatagramSocket();
                int n = 4;
                int n2 = 8;
                int n3 = 16;
                this.m_udpConnection.setTrafficClass(n | n2 | n3);
                this.m_udpConnection.setSendBufferSize(1500);
                this.m_udpConnection.setReceiveBufferSize(131072);
            }
            if (!bl2 && bl3) {
                object = new DSConnect();
                ((DSConnect)object).dsConnectEmbedded(this.m_udpConnection, dSPath.getIPAddress(), 2000);
            }
            bl = true;
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(videoViewer embeddedConnect) error", (Throwable)exception);
            Message.show(null, (String)RES.getString("videoViewer_Network_Connect_Error"));
            this.m_bUserCancelled = true;
        }
        return bl;
    }

    public static Socket connectSSLSession(Socket socket, SessionStatus sessionStatus, boolean bl, boolean bl2) throws IOException, ExceptionRequestFailed {
        Socket socket2;
        int n;
        long l;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer connectSSLSession) socket=" + (socket == null ? "null" : socket.toString()) + " sessionStatus=" + (sessionStatus == null ? "null" : sessionStatus.toString()) + " bVideo=" + bl + " bUseAPCP=" + bl2));
        SSLSocket sSLSocket = null;
        String string = sessionStatus.getIpAddress().getHostAddress();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer connectSSLSession) sessionStatus: ipAddress=" + sessionStatus.getIpAddress().getHostAddress() + " port=" + sessionStatus.getPort() + " portVideo=" + sessionStatus.getPortVideo() + " proxySessionId=" + sessionStatus.getProxySessionId() + " proxySessionIdVideo=" + sessionStatus.getProxySessionIdVideo()));
        if (bl) {
            l = sessionStatus.getProxySessionIdVideo();
            n = sessionStatus.getPortVideo();
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer connectSSLSession) video lProxyId=" + l + " nPort=" + n));
        } else {
            l = sessionStatus.getProxySessionId();
            n = sessionStatus.getPort();
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer connectSSLSession) NOT video lProxyId=" + l + " nPort=" + n));
        }
        if (sessionStatus.isProxied() && socket == null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer connectSSLSession) isProxied szIpAddress=" + string + " nPort=" + n));
            socket2 = new ProxyClient(string, n, 0);
            n = socket2.openServerSocket(l);
            string = "127.0.0.1";
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer connectSSLSession) proxy using nPort=" + n + " ipAddress=" + string));
        }
        socket2 = null;
        if (socket == null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer connectSSLSession) socket was null, creating socketPrime at address=" + string + " + nPort=" + n));
            socket2 = videoViewer.ProxySelectorOffSocket(string, n);
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer connectSSLSession) socket was not, socketPrime = socket address=" + socket.getInetAddress().getHostAddress() + " + nPort=" + socket.getPort()));
            socket2 = socket;
        }
        try {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(videoViewer connectSSLSession) calling SSLHelper.createSSLSocket with hostAddress=" + string + " port=" + socket2.getPort()));
            if (bl) {
                String[] stringArray = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5"};
                sSLSocket = SSLHelper.createSSLSocket((Socket)socket2, (String)string, (int)socket2.getPort(), (int)30000, (String[])stringArray, (SSLSocketFactory)SSLHelper.getSSLSocketFactory());
            } else {
                sSLSocket = SSLHelper.createSSLSocket((Socket)socket2, (String)string, (int)socket2.getPort(), (int)30000, (PrivateKey)sessionStatus.getAdsapKey(), (X509Certificate)sessionStatus.getAdsapCert(), (X509Certificate)sessionStatus.getMACert(), (boolean)false);
            }
        }
        catch (SSLException sSLException) {
            try {
                Trace.logError((String)TRACE_CONTEXT, (String)"Failed to connectSSL due to SSL exception, trying with DES only", (Throwable)sSLException);
                sSLSocket = SSLHelper.createSSLSocket((Socket)socket2, (String)string, (int)socket2.getPort(), (int)30000, (PrivateKey)(bl ? null : sessionStatus.getAdsapKey()), (X509Certificate)(bl ? null : sessionStatus.getAdsapCert()), (X509Certificate)(bl ? null : sessionStatus.getMACert()), (boolean)true);
            }
            catch (SSLException sSLException2) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Failed to connectSSL due to SSL exception with DES", (Throwable)sSLException2);
                return null;
            }
        }
        return sSLSocket;
    }

    private Socket connectSSLSocket(String string, X509Certificate x509Certificate, X509Certificate x509Certificate2, PrivateKey privateKey, int n, String string2, boolean bl) throws IOException, SSLException, ExceptionRequestFailed {
        Socket socket = null;
        if (string2.compareToIgnoreCase("avsp-clear") == 0) {
            socket = videoViewer.ProxySelectorOffSocket(string, n);
        } else {
            Socket socket2 = videoViewer.ProxySelectorOffSocket(string, n);
            socket = x509Certificate != null && privateKey != null ? SSLHelper.createSSLSocket((Socket)socket2, (String)string, (int)n, (int)30000, (PrivateKey)privateKey, (X509Certificate)x509Certificate, (X509Certificate)x509Certificate2, (boolean)false) : SSLHelper.createSSLSocket((Socket)socket2, (String)string, (int)n, (int)30000, null, null, null);
        }
        socket.setTcpNoDelay(true);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Socket connected to: " + socket.getInetAddress().getHostAddress().toString()));
        return socket;
    }

    private boolean logEventSession(int n, String string, SessionStatus sessionStatus, InterfaceViewer3 interfaceViewer3) {
        String[] stringArray = new String[3];
        stringArray[0] = string;
        if (sessionStatus != null) {
            try {
                stringArray[1] = StringUtilities.encodeAsBase64((byte[])sessionStatus.getAdsapCert().getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                Trace.logError((String)TRACE_CONTEXT, (String)certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            }
        }
        stringArray[2] = "video";
        return this.logEvent(n, stringArray, interfaceViewer3);
    }

    private boolean logEvent(int n, String[] stringArray, InterfaceViewer3 interfaceViewer3) {
        if (interfaceViewer3 != null) {
            int n2 = interfaceViewer3.logEvent(n, stringArray);
            return n2 == 0;
        }
        return false;
    }

    private void closeUserCancelDialog() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer closeUserCancelDialog)");
        this.m_bUserCancelled = true;
        if (this.m_dlgElapsed != null) {
            this.m_dlgElapsed.setVisible(false);
            this.m_dlgElapsed.dispose();
        }
    }

    private void showUserCancelDialog(boolean bl) {
        this.m_bUserCancelled = false;
        this.m_dlgElapsed.setVisible(bl);
    }

    public static void launch(String[] stringArray, Frame frame) {
        if (!Trace.isTraceEnabled()) {
            Trace.startLogging(null);
        }
        new videoViewer(stringArray, frame);
        System.gc();
        if (m_bStartedFromCommandLine && !SessionManager.isAnySessionRunning() && m_nApplication != 1) {
            Trace.logInfo((String)"VideoViewer", (String)"Video Viewer was started from the command line, stopping logging");
            Trace.stopLogging();
            System.exit(0);
        } else {
            Trace.logInfo((String)"VideoViewer", (String)"Video Viewer not started from the command line, exiting main method");
        }
    }

    public void applianceSessionClosing() {
        this.closeUserCancelDialog();
    }

    public static void main(String[] stringArray) {
        try {
            if (OS.isWindows()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            return;
        }
        videoViewer.launch(stringArray, null);
    }

    private class ThreadCheckForUserCancel
    extends Thread {
        int m_nTimeOut = 0;
        boolean TimeOutReached = false;
        String szName = "";

        public ThreadCheckForUserCancel(String string, int n) {
            this.szName = string;
            Object[] objectArray = new Object[]{string};
            String string2 = MessageFormat.format(RES.getString("videoViewer_ElapsedTime_Msg"), objectArray);
            videoViewer.this.m_dlgElapsed = new JDialogElapsedTime(null, RES.getString("videoViewer_ElapsedTime_Title"), string2);
            videoViewer.this.m_dlgElapsed.setEnableCancelButton(true);
            this.m_nTimeOut = n;
            this.start();
        }

        public void run() {
            try {
                do {
                    try {
                        ThreadCheckForUserCancel.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (videoViewer.this.m_bUserCancelled) continue;
                    videoViewer.this.m_bUserCancelled = videoViewer.this.m_dlgElapsed.checkCancelButton();
                    if (videoViewer.this.m_bAllowCancel && this.m_nTimeOut != 0 && videoViewer.this.m_dlgElapsed.getDialogTime() >= this.m_nTimeOut) {
                        if (videoViewer.this.m_disAppliance != null) {
                            videoViewer.this.m_disAppliance.getSocket().close();
                        }
                        videoViewer.this.m_dlgElapsed.setEnableCancelButton(false);
                        this.TimeOutReached = true;
                        videoViewer.this.closeUserCancelDialog();
                        Object[] objectArray = new Object[]{this.szName};
                        String string = MessageFormat.format(RES.getString("videoViewer_Time_Time_Out_Error"), objectArray);
                        Message.show(null, (String)string);
                    }
                    if (!videoViewer.this.m_bUserCancelled) continue;
                    if (videoViewer.this.m_disAppliance != null && videoViewer.this.m_bAllowCancel) {
                        videoViewer.this.m_disAppliance.getSocket().close();
                    }
                    videoViewer.this.m_dlgElapsed.setEnableCancelButton(false);
                    Trace.logInfo((String)videoViewer.TRACE_CONTEXT, (String)"(videoViewer ThreadCheckForUserCancel) user cancelled from elapsed dialog");
                } while (videoViewer.this.m_dlgElapsed.isDisplayable() && !videoViewer.this.m_bUserCancelled && !videoViewer.this.m_bApplianceSessionRunning && !this.TimeOutReached);
            }
            catch (Exception exception) {
                Trace.logError((String)videoViewer.TRACE_CONTEXT, (String)("Exception in ThreadCheckForUserCancel: " + exception.getMessage()));
            }
            Trace.logInfo((String)videoViewer.TRACE_CONTEXT, (String)("Leaving ThreadCheckForUserCancel m_bUserCancelled:" + videoViewer.this.m_bUserCancelled + " m_bApplianceSessionRunning:" + videoViewer.this.m_bApplianceSessionRunning));
        }
    }
}

