/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.net;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.net.NetworkingNativeLibrary;
import java.util.Arrays;

public class InterfaceInfo {
    private static final boolean m_bLibLoaded = NetworkingNativeLibrary.isLoaded();
    private byte[] m_abyIp;
    private byte[] m_abyBroadcastIp;
    private byte[] m_abyNetmask;
    private boolean m_bUp;
    private boolean m_bBroadcast;
    private boolean m_bLoopback;
    private boolean m_bPointToPoint;
    private boolean m_bMulticast;

    private InterfaceInfo(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.m_abyIp = byArray;
        this.m_abyBroadcastIp = byArray2;
        this.m_abyNetmask = byArray3;
        this.m_bUp = bl;
        this.m_bBroadcast = bl2;
        this.m_bLoopback = bl3;
        this.m_bPointToPoint = bl4;
        this.m_bMulticast = bl5;
    }

    public byte[] getIp() {
        return this.m_abyIp;
    }

    public byte[] getBroadcastIp() {
        return this.m_abyBroadcastIp;
    }

    public byte[] getNetmask() {
        return this.m_abyNetmask;
    }

    public boolean isInNetwork(byte[] byArray) {
        if (this.m_abyIp == null || this.m_abyNetmask == null || byArray == null || this.m_abyIp.length != this.m_abyNetmask.length || this.m_abyIp.length != byArray.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if ((byArray[n] & this.m_abyNetmask[n]) != (this.m_abyIp[n] & this.m_abyNetmask[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isUp() {
        return this.m_bUp;
    }

    public boolean isLoopbackRunning() {
        return this.m_bLoopback;
    }

    public boolean isPointToPoint() {
        return this.m_bPointToPoint;
    }

    public boolean isMulticastSupported() {
        return this.m_bMulticast;
    }

    public boolean isBroadcastSupported() {
        return this.m_bBroadcast;
    }

    private static native InterfaceInfo[] nativeGetAll();

    public static InterfaceInfo[] getAll() {
        if (m_bLibLoaded) {
            try {
                return InterfaceInfo.nativeGetAll();
            }
            catch (Throwable throwable) {
                Trace.logError((String)"InterfaceInfo:getAll", (String)"Could Not Access Native Code", (Throwable)throwable);
            }
        } else {
            Trace.logError((String)"InterfaceInfo:getAll", (String)"No Library Loaded");
        }
        return null;
    }

    public static InterfaceInfo get(byte[] byArray) {
        InterfaceInfo[] interfaceInfoArray = InterfaceInfo.getAll();
        if (interfaceInfoArray == null) {
            return null;
        }
        int n = 0;
        while (n < interfaceInfoArray.length) {
            InterfaceInfo interfaceInfo = interfaceInfoArray[n];
            byte[] byArray2 = interfaceInfo.getIp();
            if (byArray2 != null && byArray != null && Arrays.equals(byArray, byArray2)) {
                return interfaceInfo;
            }
            ++n;
        }
        return null;
    }
}

