/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.net;

import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class IpAddress {
    private long m_lIpAddress;

    public IpAddress(String string) throws ExceptionInvalidArgument {
        this.m_lIpAddress = IpAddress.getLong(string);
    }

    public IpAddress(byte[] byArray) throws ExceptionInvalidArgument {
        this.m_lIpAddress = IpAddress.getLong(byArray);
    }

    public IpAddress(long l) throws ExceptionInvalidArgument {
        if (!IpAddress.isValid(l)) {
            throw new ExceptionInvalidArgument();
        }
        this.m_lIpAddress = l;
    }

    public String toString() {
        return this.getString();
    }

    public boolean equals(Object object) {
        if (object instanceof IpAddress) {
            return this.m_lIpAddress == ((IpAddress)object).getLong();
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.m_lIpAddress ^ this.m_lIpAddress >>> 32);
    }

    public String getString() {
        try {
            return IpAddress.getString(this.m_lIpAddress);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            return "";
        }
    }

    public byte[] getBytes() {
        try {
            return IpAddress.getBytes(this.m_lIpAddress);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            return new byte[4];
        }
    }

    public long getLong() {
        return this.m_lIpAddress;
    }

    public boolean isLoopbackAddress() {
        byte by = (byte)(this.m_lIpAddress >> 24 & 0xFFL);
        return by == 127;
    }

    public boolean isZeroAddress() {
        return this.m_lIpAddress == 0L;
    }

    public boolean isAll255Address() {
        return this.m_lIpAddress == 0xFFFFFFFFL;
    }

    public IpAddress getNetworkAddress(IpAddress ipAddress) throws ExceptionInvalidArgument {
        return new IpAddress(IpAddress.getNetworkAddress(this.getLong(), ipAddress.getLong()));
    }

    public IpAddress getBroadcastAddress(IpAddress ipAddress) throws ExceptionInvalidArgument {
        return new IpAddress(IpAddress.getBroadcastAddress(this.getLong(), ipAddress.getLong()));
    }

    public static boolean isValid(String string) {
        try {
            if (string == null || string.length() == 0) {
                return false;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
            String string2 = stringTokenizer.nextToken();
            if (string2.length() > 3) {
                return false;
            }
            int n = Integer.parseInt(string2);
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals(".")) {
                return false;
            }
            String string4 = stringTokenizer.nextToken();
            if (string4.length() > 3) {
                return false;
            }
            int n2 = Integer.parseInt(string4);
            string3 = stringTokenizer.nextToken();
            if (!string3.equals(".")) {
                return false;
            }
            String string5 = stringTokenizer.nextToken();
            if (string5.length() > 3) {
                return false;
            }
            int n3 = Integer.parseInt(string5);
            string3 = stringTokenizer.nextToken();
            if (!string3.equals(".")) {
                return false;
            }
            String string6 = stringTokenizer.nextToken();
            if (string6.length() > 3) {
                return false;
            }
            int n4 = Integer.parseInt(string6);
            if (stringTokenizer.hasMoreTokens()) {
                return false;
            }
            if (n < 0 || n > 255) {
                return false;
            }
            if (n2 < 0 || n2 > 255) {
                return false;
            }
            if (n3 < 0 || n3 > 255) {
                return false;
            }
            return n4 >= 0 && n4 <= 255;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isValid(byte[] byArray) {
        return byArray != null && byArray.length == 4;
    }

    public static boolean isValid(long l) {
        return l >= 0L && l <= 0xFFFFFFFFL;
    }

    public static String getString(long l) throws ExceptionInvalidArgument {
        if (!IpAddress.isValid(l)) {
            throw new ExceptionInvalidArgument();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = (int)(l >> 24 & 0xFFL);
        stringBuffer.append(n);
        stringBuffer.append(".");
        n = (int)(l >> 16 & 0xFFL);
        stringBuffer.append(n);
        stringBuffer.append(".");
        n = (int)(l >> 8 & 0xFFL);
        stringBuffer.append(n);
        stringBuffer.append(".");
        n = (int)(l >> 0 & 0xFFL);
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public static String getString(byte[] byArray) throws ExceptionInvalidArgument {
        if (byArray == null || byArray.length != 4) {
            throw new ExceptionInvalidArgument();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            stringBuffer.append(n2 &= 0xFF);
            stringBuffer.append(".");
            ++n;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static byte[] getBytes(long l) throws ExceptionInvalidArgument {
        if (!IpAddress.isValid(l)) {
            throw new ExceptionInvalidArgument();
        }
        byte[] byArray = new byte[]{(byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 0 & 0xFFL)};
        return byArray;
    }

    public static byte[] getBytes(String string) throws ExceptionInvalidArgument {
        if (!IpAddress.isValid(string)) {
            throw new ExceptionInvalidArgument();
        }
        byte[] byArray = new byte[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        byArray[0] = (byte)Integer.parseInt(stringTokenizer.nextToken());
        byArray[1] = (byte)Integer.parseInt(stringTokenizer.nextToken());
        byArray[2] = (byte)Integer.parseInt(stringTokenizer.nextToken());
        byArray[3] = (byte)Integer.parseInt(stringTokenizer.nextToken());
        return byArray;
    }

    public static long getLong(String string) throws ExceptionInvalidArgument {
        if (!IpAddress.isValid(string)) {
            throw new ExceptionInvalidArgument();
        }
        long l = 0L;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        l += (long)(Integer.parseInt(stringTokenizer.nextToken()) << 24) & 0xFF000000L;
        l += (long)(Integer.parseInt(stringTokenizer.nextToken()) << 16) & 0xFF0000L;
        l += (long)(Integer.parseInt(stringTokenizer.nextToken()) << 8) & 0xFF00L;
        return l += (long)(Integer.parseInt(stringTokenizer.nextToken()) << 0) & 0xFFL;
    }

    public static long getLong(byte[] byArray) throws ExceptionInvalidArgument {
        if (!IpAddress.isValid(byArray)) {
            throw new ExceptionInvalidArgument();
        }
        long l = 0L;
        l += (long)(byArray[0] << 24) & 0xFF000000L;
        l += (long)(byArray[1] << 16) & 0xFF0000L;
        l += (long)(byArray[2] << 8) & 0xFF00L;
        return l += (long)(byArray[3] << 0) & 0xFFL;
    }

    public static String getNetworkAddress(String string, String string2) throws ExceptionInvalidArgument {
        long l = IpAddress.getLong(string);
        long l2 = IpAddress.getLong(string2);
        long l3 = l & l2;
        return IpAddress.getString(l3);
    }

    public static String getHostAddress(String string, String string2) throws ExceptionInvalidArgument {
        long l = IpAddress.getLong(string);
        long l2 = IpAddress.getLong(string2);
        l2 ^= 0xFFFFFFFFFFFFFFFFL;
        long l3 = l & (l2 &= 0xFFFFFFFFL);
        return IpAddress.getString(l3);
    }

    public static String getFirstAddressOnNetwork(String string, String string2) throws ExceptionInvalidArgument {
        long l = IpAddress.getLong(string);
        long l2 = IpAddress.getLong(string2);
        long l3 = (l & l2) + 1L;
        return IpAddress.getString(l3);
    }

    public static String getLastAddressOnNetwork(String string, String string2) throws ExceptionInvalidArgument {
        long l = IpAddress.getLong(string);
        long l2 = IpAddress.getLong(string2);
        long l3 = l & l2;
        l2 ^= 0xFFFFFFFFFFFFFFFFL;
        long l4 = (l3 | (l2 &= 0xFFFFFFFFL)) - 1L;
        return IpAddress.getString(l4);
    }

    public static String getBroadcastAddress(String string, String string2) throws ExceptionInvalidArgument {
        long l = IpAddress.getLong(string);
        long l2 = IpAddress.getLong(string2);
        long l3 = l & l2;
        l2 ^= 0xFFFFFFFFFFFFFFFFL;
        long l4 = l3 | (l2 &= 0xFFFFFFFFL);
        return IpAddress.getString(l4);
    }

    public static long getNetworkAddress(long l, long l2) throws ExceptionInvalidArgument {
        if (!IpAddress.isValid(l)) {
            throw new ExceptionInvalidArgument();
        }
        if (!IpAddress.isValid(l2)) {
            throw new ExceptionInvalidArgument();
        }
        return l & l2;
    }

    public static long getHostAddress(long l, long l2) throws ExceptionInvalidArgument {
        if (!IpAddress.isValid(l)) {
            throw new ExceptionInvalidArgument();
        }
        if (!IpAddress.isValid(l2)) {
            throw new ExceptionInvalidArgument();
        }
        l2 ^= 0xFFFFFFFFFFFFFFFFL;
        return l & (l2 &= 0xFFFFFFFFL);
    }

    public static long getFirstAddressOnNetwork(long l, long l2) throws ExceptionInvalidArgument {
        if (!IpAddress.isValid(l)) {
            throw new ExceptionInvalidArgument();
        }
        if (!IpAddress.isValid(l2)) {
            throw new ExceptionInvalidArgument();
        }
        return (l & l2) + 1L;
    }

    public static long getLastAddressOnNetwork(long l, long l2) throws ExceptionInvalidArgument {
        if (!IpAddress.isValid(l)) {
            throw new ExceptionInvalidArgument();
        }
        if (!IpAddress.isValid(l2)) {
            throw new ExceptionInvalidArgument();
        }
        long l3 = l & l2;
        l2 ^= 0xFFFFFFFFFFFFFFFFL;
        return (l3 | (l2 &= 0xFFFFFFFFL)) - 1L;
    }

    public static long getBroadcastAddress(long l, long l2) throws ExceptionInvalidArgument {
        if (!IpAddress.isValid(l)) {
            throw new ExceptionInvalidArgument();
        }
        if (!IpAddress.isValid(l2)) {
            throw new ExceptionInvalidArgument();
        }
        long l3 = l & l2;
        l2 ^= 0xFFFFFFFFFFFFFFFFL;
        return l3 | (l2 &= 0xFFFFFFFFL);
    }

    public static byte[] getNetworkAddress(byte[] byArray, byte[] byArray2) throws ExceptionInvalidArgument {
        long l = IpAddress.getLong(byArray);
        long l2 = IpAddress.getLong(byArray2);
        long l3 = l & l2;
        return IpAddress.getBytes(l3);
    }

    public static byte[] getHostAddress(byte[] byArray, byte[] byArray2) throws ExceptionInvalidArgument {
        long l = IpAddress.getLong(byArray);
        long l2 = IpAddress.getLong(byArray2);
        l2 ^= 0xFFFFFFFFFFFFFFFFL;
        long l3 = l & (l2 &= 0xFFFFFFFFL);
        return IpAddress.getBytes(l3);
    }

    public static byte[] getFirstAddressOnNetwork(byte[] byArray, byte[] byArray2) throws ExceptionInvalidArgument {
        long l = IpAddress.getLong(byArray);
        long l2 = IpAddress.getLong(byArray2);
        long l3 = (l & l2) + 1L;
        return IpAddress.getBytes(l3);
    }

    public static byte[] getLastAddressOnNetwork(byte[] byArray, byte[] byArray2) throws ExceptionInvalidArgument {
        long l = IpAddress.getLong(byArray);
        long l2 = IpAddress.getLong(byArray2);
        long l3 = l & l2;
        l2 ^= 0xFFFFFFFFFFFFFFFFL;
        long l4 = (l3 | (l2 &= 0xFFFFFFFFL)) - 1L;
        return IpAddress.getBytes(l4);
    }

    public static byte[] getBroadcastAddress(byte[] byArray, byte[] byArray2) throws ExceptionInvalidArgument {
        long l = IpAddress.getLong(byArray);
        long l2 = IpAddress.getLong(byArray2);
        long l3 = l & l2;
        l2 ^= 0xFFFFFFFFFFFFFFFFL;
        long l4 = l3 | (l2 &= 0xFFFFFFFFL);
        return IpAddress.getBytes(l4);
    }
}

