/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.net;

import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MacAddress {
    private byte[] m_abyMacAddress = new byte[6];
    private static final Pattern m_pattern = Pattern.compile("^([0-9A-F][0-9A-F][:-]){5}[0-9A-F][0-9A-F]$", 2);
    private static final String m_szInValidAddress = "00:00:00:00:00:00";

    public MacAddress(String string) throws ExceptionInvalidArgument {
        this.m_abyMacAddress = MacAddress.getBytes(string);
    }

    public MacAddress(byte[] byArray) throws ExceptionInvalidArgument {
        if (!MacAddress.isValid(byArray)) {
            throw new ExceptionInvalidArgument();
        }
        this.m_abyMacAddress = byArray;
    }

    public String getString() {
        try {
            return MacAddress.getString(this.m_abyMacAddress);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            return "";
        }
    }

    public byte[] getBytes() {
        return this.m_abyMacAddress;
    }

    public static boolean isValid(String string) {
        try {
            if (string == null || string.length() != 17) {
                return false;
            }
            Matcher matcher = m_pattern.matcher(string);
            if (matcher.find()) {
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {}
        return false;
    }

    public static boolean isValid(byte[] byArray) {
        String string = null;
        try {
            string = MacAddress.getString(byArray);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            return false;
        }
        return byArray != null && byArray.length == 6 && !string.equals(m_szInValidAddress);
    }

    public static String getString(byte[] byArray) throws ExceptionInvalidArgument {
        if (byArray == null || byArray.length != 6) {
            throw new ExceptionInvalidArgument();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            String string = Integer.toHexString(n2 &= 0xFF);
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuffer.append(string.toUpperCase());
            stringBuffer.append(":");
            ++n;
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static byte[] getBytes(String string) throws ExceptionInvalidArgument {
        if (!MacAddress.isValid(string)) {
            throw new ExceptionInvalidArgument();
        }
        String string2 = ":";
        if (string.charAt(2) == '-') {
            string2 = "-";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        byte[] byArray = new byte[]{(byte)Integer.parseInt(stringTokenizer.nextToken(), 16), (byte)Integer.parseInt(stringTokenizer.nextToken(), 16), (byte)Integer.parseInt(stringTokenizer.nextToken(), 16), (byte)Integer.parseInt(stringTokenizer.nextToken(), 16), (byte)Integer.parseInt(stringTokenizer.nextToken(), 16), (byte)Integer.parseInt(stringTokenizer.nextToken(), 16)};
        return byArray;
    }

    public String toString() {
        return this.getString();
    }
}

