/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrSwitchInfo;
import com.avocent.avworks.services.ConnectionPath;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.util.ResourceManager;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class AbstractTableModelExistingSwitches
extends AbstractTableModel {
    public static final String CNAME = "AbstractTableModelExistingSwitches";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    Vector m_vAvrSwitchInfo = new Vector();
    String[] m_szColumns = new String[]{res.getString("AbstractTableModelExistingSwitches_Name"), res.getString("AbstractTableModelExistingSwitches_Type_1")};

    public int getRowCount() {
        return this.m_vAvrSwitchInfo.size();
    }

    public int getColumnCount() {
        return this.m_szColumns.length;
    }

    public String getColumnName(int n) {
        return this.m_szColumns[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            AvrSwitchInfo avrSwitchInfo = (AvrSwitchInfo)this.m_vAvrSwitchInfo.elementAt(n);
            if (n2 == 0) {
                return ConnectionPath.parseSwitchName((String)avrSwitchInfo.getSwitchName());
            }
            if (n2 == 1) {
                return avrSwitchInfo.getSwitchTypeStr();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public Vector getTableData() {
        return this.m_vAvrSwitchInfo;
    }

    public void setTableData(Vector vector) {
        this.m_vAvrSwitchInfo = vector;
        this.fireTableDataChanged();
    }

    public void addSwitch(AvrSwitchInfo avrSwitchInfo) {
        this.m_vAvrSwitchInfo.addElement(avrSwitchInfo);
        this.fireTableDataChanged();
    }

    public AvrSwitchInfo getSwitch(int n) {
        if (n < 0 || n >= this.m_vAvrSwitchInfo.size()) {
            Trace.logError((String)"AbstractTableModelExistingSwitches:getSwitch", (String)"Invalid Selected Index");
            return null;
        }
        return (AvrSwitchInfo)this.m_vAvrSwitchInfo.elementAt(n);
    }

    public AvrSwitchInfo getSwitch(String string) {
        for (int i = 0; i < this.m_vAvrSwitchInfo.size(); ++i) {
            AvrSwitchInfo avrSwitchInfo = (AvrSwitchInfo)this.m_vAvrSwitchInfo.elementAt(i);
            if (!avrSwitchInfo.getSwitchName().equals(string)) continue;
            return avrSwitchInfo;
        }
        return null;
    }

    public void setSwitch(int n, AvrSwitchInfo avrSwitchInfo) {
        if (n < 0 || n >= this.m_vAvrSwitchInfo.size()) {
            Trace.logError((String)"AbstractTableModelExistingSwitches:getSwitch", (String)"Invalid Selected Index");
            return;
        }
        this.m_vAvrSwitchInfo.setElementAt(avrSwitchInfo, n);
        this.fireTableDataChanged();
    }

    public void deleteSwitch(int n) {
        if (n < 0 || n >= this.m_vAvrSwitchInfo.size()) {
            Trace.logError((String)"AbstractTableModelExistingSwitches:deleteSwitch", (String)"Invalid Index to delete");
            return;
        }
        this.m_vAvrSwitchInfo.removeElementAt(n);
        this.fireTableDataChanged();
    }

    public void deleteSwitch(int[] nArray) throws ExceptionInvalidArgument {
        if (nArray == null) {
            Trace.logError((String)"AbstractTableModelExistingSwitches:deleteSwitch", (String)"The int[] argument was invalid");
            throw new ExceptionInvalidArgument();
        }
        Vector<AvrSwitchInfo> vector = new Vector<AvrSwitchInfo>();
        for (int i = 0; i < this.m_vAvrSwitchInfo.size(); ++i) {
            boolean bl = true;
            for (int j = 0; j < nArray.length; ++j) {
                if (i != nArray[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            vector.addElement((AvrSwitchInfo)this.m_vAvrSwitchInfo.elementAt(i));
        }
        this.m_vAvrSwitchInfo = vector;
        this.fireTableDataChanged();
    }

    public void deleteRipFromSwitch(String string, String string2) {
        for (int i = 0; i < this.m_vAvrSwitchInfo.size(); ++i) {
            AvrSwitchInfo avrSwitchInfo = (AvrSwitchInfo)this.m_vAvrSwitchInfo.elementAt(i);
            if (!avrSwitchInfo.getSwitchName().equals(string2)) continue;
            if (!avrSwitchInfo.isRipAttached(string)) {
                return;
            }
            avrSwitchInfo.deleteAttachedRip(string);
        }
        this.fireTableDataChanged();
    }

    public void addRipToSwitch(String string, String string2) {
        for (int i = 0; i < this.m_vAvrSwitchInfo.size(); ++i) {
            AvrSwitchInfo avrSwitchInfo = (AvrSwitchInfo)this.m_vAvrSwitchInfo.elementAt(i);
            if (!avrSwitchInfo.getSwitchName().equals(string2)) continue;
            avrSwitchInfo.addAttachedRip(string);
        }
        this.fireTableDataChanged();
    }

    class PartiallyComparableObj
    implements Comparable {
        private Object original;

        public PartiallyComparableObj(String[] stringArray) {
            this.original = stringArray;
        }

        public int compareTo(Object object) {
            return this.original.toString().compareTo(object.toString());
        }

        public Object toOriginal() {
            return this.original;
        }
    }

    public static class PartiallyComparableString
    implements Comparable {
        protected String originalStr;
        protected String delimiterStr;
        protected String comparableStr;

        public PartiallyComparableString(String string, String string2) throws NullPointerException {
            if (string == null || string2 == null) {
                throw new NullPointerException("Null param in PartiallyComparableString constructor");
            }
            this.originalStr = string;
            this.delimiterStr = string2;
            this.setComparableStr();
        }

        protected void setComparableStr() {
            int n = this.originalStr.indexOf(this.delimiterStr);
            if (n >= 0 && this.originalStr.length() >= n + 2) {
                this.comparableStr = this.originalStr.substring(n + 1);
                this.comparableStr = this.comparableStr.trim();
            } else {
                this.comparableStr = this.originalStr;
            }
        }

        public int compareTo(Object object) {
            int n = 0;
            try {
                String string = null;
                string = object instanceof PartiallyComparableString ? ((PartiallyComparableString)object).toComparableString() : object.toString();
                n = this.comparableStr.compareTo(string);
            }
            catch (Exception exception) {
                Trace.logError((String)"PartiallyComparableString: ", (String)exception.toString());
            }
            return n;
        }

        public String toComparableString() {
            return this.comparableStr;
        }

        public String toString() {
            return this.originalStr;
        }
    }
}

