/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrAppliance;
import com.avocent.avworks.nmm.avr.AvrApplianceFileIO;
import com.avocent.avworks.nmm.avr.AvrNmmInterface;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.avr.JDialogSendCert;
import com.avocent.avworks.nmm.avr.JDialogToolsUpgradeRipFirmware;
import com.avocent.avworks.nmm.avr.JDialogUpgradeApplianceFirmware;
import com.avocent.avworks.nmm.avr.JPanelGlobalSettings;
import com.avocent.avworks.nmm.avr.JPanelHardwareSettings;
import com.avocent.avworks.nmm.avr.JPanelLicensedOptions;
import com.avocent.avworks.nmm.avr.JPanelLocalUserSettings;
import com.avocent.avworks.nmm.avr.JPanelNTPSettings;
import com.avocent.avworks.nmm.avr.JPanelNetworkSettings;
import com.avocent.avworks.nmm.avr.JPanelRipsSettings;
import com.avocent.avworks.nmm.avr.JPanelSessionsSettings;
import com.avocent.avworks.nmm.avr.JPanelSettingsCascadeSwitches;
import com.avocent.avworks.nmm.avr.JPanelSettingsServers;
import com.avocent.avworks.nmm.avr.JPanelSettingsVersionsRips;
import com.avocent.avworks.nmm.avr.JPanelSnmpSettings;
import com.avocent.avworks.nmm.avr.JPanelStatusAvr;
import com.avocent.avworks.nmm.avr.JPanelTools;
import com.avocent.avworks.nmm.avr.JPanelTrapsSettings;
import com.avocent.avworks.nmm.avr.JPanelUsersSettings;
import com.avocent.avworks.nmm.avr.JPanelVersionsSettings;
import com.avocent.avworks.nmm.avr.authentication.AvrAuthSettingsPanelController;
import com.avocent.avworks.nmm.avr.virtualmedia.VirtualMediaPanelController;
import com.avocent.avworks.nmm.common.AbstractNmmInterface;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.InterfaceAmpPanelController;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.avworks.nmm.common.SnmpHelper;
import com.avocent.avworks.nmm.common.SnmpValueObject;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.AppliancePropertiesDb;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.InterfaceAmpPanel;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogElapsedTime;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.CachedCredentials;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.UsernamePassword;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;

public class AmpControllerAvr
extends AmpController {
    public static final String CNAME = "AmpControllerAvr";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    static ResourceBundle m_rbHelpRes = null;
    private static Object[] RIP = new Object[]{AVWorksBranding.getDsrIqName((boolean)true)};
    private static final Integer REBOOT_REQUIRED_YES_VAL = new Integer(2);
    protected JPanelUsersSettings m_jpusUsersSettings;
    protected JDialogUpgradeApplianceFirmware m_jduafDsrFirmwareUpgrade;
    protected AvrApplianceFileIO m_dafiUserTable;
    protected AvrApplianceFileIO m_dafiConfiguration;
    public static final String TRACE_CONTEXT = "AVR AMP";

    public AmpControllerAvr(AbstractNmmInterface abstractNmmInterface, int n, Frame frame, JDialogElapsedTime jDialogElapsedTime) throws ExceptionConstructorFailed {
        super(n, abstractNmmInterface);
        try {
            this.m_jdetElapsed = jDialogElapsedTime;
            this.m_aAppliance = new AvrAppliance(this.m_acAsmpConnection);
            this.launchAmp(n, frame);
        }
        catch (Exception exception) {
            Trace.logError((String)"AmpController", (String)"Failed to construct AmpControllerCPS.", (Throwable)exception);
            throw new ExceptionConstructorFailed("", (Throwable)exception);
        }
    }

    public void addSettingsPanels() throws ExceptionRequestFailed {
        try {
            int n;
            DefaultMutableTreeNode defaultMutableTreeNode;
            JPanelGlobalSettings jPanelGlobalSettings = new JPanelGlobalSettings(this);
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode = this.addSettingsPanel(jPanelGlobalSettings, this.m_dmtnRootNode);
            this.addSettingsPanel(new JPanelNetworkSettings(this), defaultMutableTreeNode);
            this.addSettingsPanel(new JPanelSessionsSettings(this), defaultMutableTreeNode);
            if (this.isFeatureSupported("AvrNtpSupport")) {
                this.addSettingsPanel(new JPanelNTPSettings(this), defaultMutableTreeNode);
            }
            if (this.isFeatureSupported("VirtualMediaSupport") && (n = this.getApplianceInfo().getProductID()) != 39) {
                this.addSettingsPanel(new VirtualMediaPanelController(this), defaultMutableTreeNode);
            }
            if (this.isFeatureSupported("LDAPAuthenticationSupport")) {
                this.addSettingsPanel((InterfaceAmpPanelController)new AvrAuthSettingsPanelController(this), defaultMutableTreeNode);
            }
            this.m_jpusUsersSettings = new JPanelUsersSettings(this);
            defaultMutableTreeNode = this.addSettingsPanel(this.m_jpusUsersSettings, this.m_dmtnRootNode);
            if (this.isFeatureSupported("OverrideAdminUser")) {
                this.addSettingsPanel(new JPanelLocalUserSettings(this), defaultMutableTreeNode);
            }
            this.addSettingsPanel(new JPanelRipsSettings(this), this.m_dmtnRootNode);
            defaultMutableTreeNode = this.addSettingsPanel(new JPanelSnmpSettings(this), this.m_dmtnRootNode);
            this.addSettingsPanel(new JPanelTrapsSettings(this), defaultMutableTreeNode);
            this.addSettingsPanel(new JPanelSettingsServers(this), this.m_dmtnRootNode);
            this.addSettingsPanel(new JPanelSettingsCascadeSwitches(this), this.m_dmtnRootNode);
            defaultMutableTreeNode = this.addSettingsPanel(new JPanelVersionsSettings(this), this.m_dmtnRootNode);
            this.addSettingsPanel(new JPanelHardwareSettings(this), defaultMutableTreeNode);
            this.addSettingsPanel(new JPanelSettingsVersionsRips(this), defaultMutableTreeNode);
            if (this.isFeatureSupported("LicensedOptionsSupport")) {
                this.addSettingsPanel(new JPanelLicensedOptions(this), this.m_dmtnRootNode);
            }
            this.setActivePanel((InterfaceAmpPanel)jPanelGlobalSettings);
        }
        catch (Exception exception) {
            throw new ExceptionRequestFailed("", (Throwable)exception);
        }
    }

    protected void clearMibMinorVersion() {
        this.m_aAppliance.setReloadData();
    }

    protected void clearMibMajorVersion() {
        this.m_aAppliance.setReloadData();
    }

    public void invalidateUsersSettingsPanel() {
        this.m_jpusUsersSettings.setReloadData();
    }

    void rebootAction(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Tools->Reboot button pressed.");
        String string = MessageFormat.format(res.getString("AmpControllerAvr_Reboot_Warning"), APPLIANCE);
        String string2 = MessageFormat.format(res.getString("AmpControllerAvr_Confirm_Reboot"), APPLIANCE);
        int n = JOptionPaneFixedSize.showConfirmDialog((Component)this.getMainFrame(), (Object)string, (String)string2, (int)0, (int)2);
        if (n == 0) {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        AmpControllerAvr.this.setBusy(true);
                        Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsReboot.0"};
                        Integer n = new Integer(2);
                        Object[] objectArray2 = new Object[]{n};
                        AvrSnmpHelper.set(AmpControllerAvr.this.getAsmpConnection(), objectArray, objectArray2);
                        AmpControllerAvr.this.closeAmp();
                    }
                    catch (Exception exception) {
                        String string = MessageFormat.format(res.getString("AmpControllerAvr_Unable_to_Reboot"), AmpController.APPLIANCE);
                        Message.show((Component)AmpControllerAvr.this.getMainFrame(), (String)(string + " " + exception.getMessage()));
                        AmpControllerAvr.this.setBusy(false);
                    }
                }
            };
            thread.start();
        }
    }

    void upgradeApplianceFirmwareAction(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Tools->Upgrade DSR Firmware button pressed.");
        Thread thread = new Thread(){

            public void run() {
                try {
                    AmpControllerAvr.this.setBusy(true);
                    if (AmpControllerAvr.this.m_jduafDsrFirmwareUpgrade == null) {
                        AmpControllerAvr.this.m_jduafDsrFirmwareUpgrade = new JDialogUpgradeApplianceFirmware(AmpControllerAvr.this);
                    }
                    AmpControllerAvr.this.m_jduafDsrFirmwareUpgrade.showDialog();
                    AmpControllerAvr.this.setBusy(false);
                }
                catch (Exception exception) {
                    String string = MessageFormat.format(res.getString("AmpControllerAvr_Error_with_firmware"), AmpController.APPLIANCE);
                    AmpControllerAvr.this.showException(null, AmpControllerAvr.TRACE_CONTEXT, string, exception);
                    AmpControllerAvr.this.setBusy(false);
                }
            }
        };
        thread.start();
    }

    void jButtonRipFirmware_actionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Tools->Upgrade RIP Firmware button pressed.");
        Thread thread = new Thread(){

            public void run() {
                try {
                    AmpControllerAvr.this.setBusy(true);
                    JDialogToolsUpgradeRipFirmware jDialogToolsUpgradeRipFirmware = new JDialogToolsUpgradeRipFirmware(AmpControllerAvr.this);
                    ((Dialog)((Object)jDialogToolsUpgradeRipFirmware)).setVisible(true);
                    AmpControllerAvr.this.setBusy(false);
                }
                catch (Exception exception) {
                    Trace.logError((String)AmpControllerAvr.TRACE_CONTEXT, (String)"Exception attempting to create JDialogToolsUpgradeRipFirmware.", (Throwable)exception);
                    Message.show((Component)AmpControllerAvr.this.getMainFrame(), (String)exception.getMessage());
                    AmpControllerAvr.this.setBusy(false);
                }
            }
        };
        thread.start();
    }

    void readConfigFileAction(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Tools->Read Config File button pressed.");
        try {
            if (this.m_dafiConfiguration == null) {
                this.m_dafiConfiguration = new AvrApplianceFileIO(this, 1);
            }
            this.m_dafiConfiguration.readFile();
        }
        catch (Exception exception) {
            this.showException(null, TRACE_CONTEXT, res.getString("AmpControllerAvr_Error_reading"), exception);
        }
    }

    void writeConfigFileAction(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Tools->Write Config File button pressed.");
        try {
            if (this.m_dafiConfiguration == null) {
                this.m_dafiConfiguration = new AvrApplianceFileIO(this, 1);
            }
            this.m_dafiConfiguration.writeFile();
        }
        catch (Exception exception) {
            this.showException(null, TRACE_CONTEXT, res.getString("AmpControllerAvr_Error_writing"), exception);
        }
    }

    void readUserDatabaseAction(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Tools->Read User File button pressed.");
        try {
            if (this.m_dafiUserTable == null) {
                this.m_dafiUserTable = new AvrApplianceFileIO(this, 2);
            }
            this.m_dafiUserTable.readFile();
        }
        catch (Exception exception) {
            this.showException(null, TRACE_CONTEXT, res.getString("AmpControllerAvr_Error_reading_user"), exception);
        }
    }

    void writeUserDatabaseAction(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Tools->Write User File button pressed.");
        try {
            if (this.m_dafiUserTable == null) {
                this.m_dafiUserTable = new AvrApplianceFileIO(this, 2);
            }
            this.m_dafiUserTable.writeFile();
        }
        catch (Exception exception) {
            this.showException(null, TRACE_CONTEXT, res.getString("AmpControllerAvr_Error_writing_user"), exception);
        }
    }

    void SendCertificate(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Tools->Send Certificate button pressed.");
        try {
            JDialogSendCert jDialogSendCert = new JDialogSendCert(this, res.getString("JDialogSendCert_Title"), "HelpMe");
            jDialogSendCert.show();
            jDialogSendCert.dispose();
        }
        catch (Exception exception) {
            this.showException(null, TRACE_CONTEXT, res.getString("AmpControllerAvr_Error_writing_user"), exception);
        }
    }

    public boolean checkIfRebootRequired() {
        boolean bl = false;
        if (this.m_acAsmpConnection.isConnected()) {
            boolean bl2;
            block6: {
                bl2 = this.getMainFrame().getGlassPane().isVisible();
                if (!bl2) {
                    this.setBusy(true);
                }
                try {
                    Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsSnmp.dsManagerStatusTable.dsManagerStatusTableEntry.dsManagerStatusTableIPAddress", "avocent.ds.dsManagement.dsSnmp.dsManagerStatusTable.dsManagerStatusTableEntry.dsManagerStatusTableRebootRequired"};
                    InterfaceValueObject[][] interfaceValueObjectArray = AvrSnmpHelper.getTableValues(this.getAsmpConnection(), objectArray);
                    InetAddress inetAddress = this.m_acAsmpConnection.getAsmpSession().getLocalIpAddress();
                    if (inetAddress == null) break block6;
                    String string = inetAddress.getHostName();
                    String string2 = inetAddress.getHostAddress();
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("Checking if reboot required for this manager: " + string + " with IP Address: " + string2 + ".  There are currently (" + interfaceValueObjectArray.length + ") manager status table entries."));
                    for (int i = 0; i < interfaceValueObjectArray.length; ++i) {
                        String string3 = interfaceValueObjectArray[i][0].toString();
                        SnmpValueObject snmpValueObject = (SnmpValueObject)interfaceValueObjectArray[i][1];
                        Integer n = snmpValueObject.getInteger();
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("Found a manager: " + string3 + " in manager status table with reboot required=" + snmpValueObject.toString() + "."));
                        if (!string2.equals(string3) || !n.equals(REBOOT_REQUIRED_YES_VAL)) continue;
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("A change from this manager: " + string3 + " requires that appliance be rebooted."));
                        bl = this.rebootRequest();
                        break;
                    }
                }
                catch (Exception exception) {
                    this.showException(null, TRACE_CONTEXT, null, exception);
                }
            }
            if (!bl2) {
                this.setBusy(false);
            }
        }
        return bl;
    }

    private boolean rebootRequest() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Confirming reboot with user...");
        boolean bl = false;
        String string = MessageFormat.format(res.getString("AmpControllerAvr_Reboot_Required_Warning"), APPLIANCE);
        String string2 = MessageFormat.format(res.getString("AmpControllerAvr_Confirm_Reboot"), APPLIANCE);
        int n = JOptionPaneFixedSize.showConfirmDialog((Component)this.getMainFrame(), (Object)string, (String)string2, (int)0, (int)2);
        if (n == 0) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"User requested reboot...");
            try {
                Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsReboot.0"};
                Integer n2 = new Integer(2);
                Object[] objectArray2 = new Object[]{n2};
                AvrSnmpHelper.set(this.getAsmpConnection(), objectArray, objectArray2);
                bl = true;
            }
            catch (Exception exception) {
                Message.show((Component)this.getMainFrame(), (String)exception.getMessage());
            }
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"User does not want to reboot at this time.");
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Trace.startLogging(null);
            AVWorksService.start();
            AvrNmmInterface avrNmmInterface = new AvrNmmInterface(1, null);
            UsernamePassword usernamePassword = CachedCredentials.getCredentials();
            usernamePassword.setUsernamePassword("Admin", "Admin1");
            AmpControllerAvr ampControllerAvr = new AmpControllerAvr(avrNmmInterface, 3, null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getWindowIdentifier() {
        return "CPS AMP:" + this.m_aiAppliance.getID();
    }

    public JPanel createToolsPanel() throws Exception {
        return new JPanelTools(this);
    }

    public JPanelAmpPanel createStatusPanel() throws Exception {
        return new JPanelStatusAvr(this);
    }

    public SnmpHelper getSnmpHelper() {
        return AvrSnmpHelper.getInstance();
    }

    public String getHelpUrlForId(String string) {
        if (m_rbHelpRes == null) {
            try {
                Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
                m_rbHelpRes = ResourceBundle.getBundle("com.avocent.avworks.nmm.avr.Help");
                Trace.logInfo((String)"Help", (String)"Successfully loaded Help.properties");
            }
            catch (Exception exception) {
                Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.nmm.avr.Help");
                return null;
            }
        }
        return m_rbHelpRes.getString(string);
    }

    public String getResource(String string) {
        String string2 = res.getString(string);
        return string2;
    }

    public String getResource(String string, Object[] objectArray) {
        String string2 = res.getString(string);
        return MessageFormat.format(string2, objectArray);
    }

    public int getLoginTimeout(int n) {
        int n2 = 30;
        try {
            ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo((int)n);
            n2 = AppliancePropertiesDb.getIntegerValue((int)n, (String)"LOGIN_TIMEOUT", (int)30);
            int n3 = ((AvrNmmInterface)this.getNmmInterface()).getAnoymousLoginTimeout(applianceInfo.getAddress());
            if (n2 != n3) {
                AppliancePropertiesDb.setValue((int)n, (String)"LOGIN_TIMEOUT", (int)n3);
                n2 = n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }
}

