/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrRipInfo;
import com.avocent.avworks.nmm.avr.AvrServerInfo;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.avr.InterfaceDsSnmpConstants;
import com.avocent.avworks.nmm.common.MibEnum;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.util.ResourceManager;
import com.avocent.protocols.aidp.AidpSession;
import com.avocent.protocols.snmp.ExceptionUnknownMibName;
import com.avocent.protocols.snmp.ExceptionVarBindIncompatibleSyntax;
import com.avocent.protocols.snmp.Mib;
import com.avocent.protocols.snmp.SnmpRequest;
import com.avocent.protocols.snmp.VarBind;
import com.avocent.protocols.snmp.VarBindList;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Vector;

public class AvrAidpHelper
implements InterfaceDsSnmpConstants {
    protected static String m_szTraceId = "DS AIDP Helper";
    private static Object[] APPLIANCE = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
    private static String UTF8_ENCODING = "UTF-8";
    public static final String CNAME = "AvrAidpHelper";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");

    private AvrAidpHelper() {
    }

    public static AvrServerInfo[] getServerInfo(String string) throws ExceptionRequestFailed {
        try {
            Object[] objectArray;
            Vector<AvrServerInfo> vector;
            block6: {
                int n;
                SnmpRequest snmpRequest;
                block5: {
                    VarBindList varBindList;
                    InetAddress inetAddress = InetAddress.getByName(string);
                    AidpSession aidpSession = new AidpSession(inetAddress);
                    vector = new Vector<AvrServerInfo>();
                    String string2 = "avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.";
                    String string3 = string2 + "dsServerTableIndex.0";
                    String string4 = string2 + "dsServerTableRipId.0";
                    String string5 = string2 + "dsServerTableSwitchChannel.0";
                    String string6 = string2 + "dsServerTableServerName.0";
                    String string7 = string2 + "dsServerTableIndex";
                    while (true) {
                        objectArray = new VarBind(string3);
                        VarBind varBind = new VarBind(string4);
                        VarBind varBind2 = new VarBind(string5);
                        VarBind varBind3 = new VarBind(string6);
                        VarBindList varBindList2 = new VarBindList();
                        varBindList2.addVarBind((VarBind)objectArray);
                        varBindList2.addVarBind(varBind);
                        varBindList2.addVarBind(varBind2);
                        varBindList2.addVarBind(varBind3);
                        snmpRequest = new SnmpRequest(varBindList2, null, "", 161, 0, 0);
                        n = aidpSession.snmpRequest(snmpRequest);
                        if (n != 0 || snmpRequest.getErrorStatus() != 0) break block5;
                        varBindList = snmpRequest.getVarBindList();
                        if (varBindList.size() != 4) break;
                        VarBind varBind4 = varBindList.varbindAt(0);
                        string3 = varBind4.getRelativeName();
                        String string8 = varBind4.getStringValue();
                        Trace.logInfo((String)(m_szTraceId + ":getServerInfo"), (String)("Table Index Name = " + string3 + " Value = " + string8));
                        if (AvrAidpHelper.stillOnTable(string7, string3)) {
                            VarBind varBind5 = varBindList.varbindAt(1);
                            string4 = varBind5.getRelativeName();
                            byte[] byArray = varBind5.getOctetStringValue();
                            String string9 = new String(byArray, UTF8_ENCODING);
                            Trace.logInfo((String)(m_szTraceId + ":getServerInfo"), (String)("RIP ID Name = " + string4 + " Value = " + string9));
                            VarBind varBind6 = varBindList.varbindAt(2);
                            string5 = varBind6.getRelativeName();
                            String string10 = varBind6.getStringValue();
                            Trace.logInfo((String)(m_szTraceId + ":getServerInfo"), (String)("Switch Connected = " + string5 + " Value = " + string10));
                            VarBind varBind7 = varBindList.varbindAt(3);
                            string6 = varBind7.getRelativeName();
                            byte[] byArray2 = varBind7.getOctetStringValue();
                            String string11 = new String(byArray2, UTF8_ENCODING);
                            Trace.logInfo((String)(m_szTraceId + ":getServerInfo"), (String)("Server Name = " + string6 + " Value = " + string11));
                            AvrServerInfo avrServerInfo = new AvrServerInfo(Integer.parseInt(string8), string9, Integer.parseInt(string10), string11, !string10.equals("0"));
                            vector.add(avrServerInfo);
                            varBindList2.removeVarBinds();
                            continue;
                        }
                        break block6;
                        break;
                    }
                    Trace.logError((String)(m_szTraceId + ":getServerInfo"), (String)("<INVALID NUMBER OF BINDINGS RETURNED> Number: " + Integer.toHexString(varBindList.size())));
                    throw new ExceptionRequestFailed();
                }
                Trace.logInfo((String)(m_szTraceId + ":getServerInfo"), (String)("Error requesting Server Info.AIDP Error = " + n + "SNMP Error = " + snmpRequest.getErrorStatusMessage()));
                if (snmpRequest.getErrorStatus() != 2) {
                    throw new ExceptionRequestFailed();
                }
            }
            objectArray = new AvrServerInfo[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            Trace.logError((String)(m_szTraceId + ":getServerInfo"), (String)"Error occured retrieving server information.", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    public static AvrRipInfo[] getRipInfo(String string) throws ExceptionRequestFailed {
        try {
            Object[] objectArray;
            Vector<AvrRipInfo> vector;
            block6: {
                int n;
                SnmpRequest snmpRequest;
                block5: {
                    VarBindList varBindList;
                    InetAddress inetAddress = InetAddress.getByName(string);
                    AidpSession aidpSession = new AidpSession(inetAddress);
                    vector = new Vector<AvrRipInfo>();
                    String string2 = "avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.";
                    String string3 = string2 + "dsPortRipTableIndex.0";
                    String string4 = string2 + "dsPortRipTableInputPort.0";
                    String string5 = string2 + "dsPortRipTableRipId.0";
                    String string6 = string2 + "dsPortRipTableRipType.0";
                    String string7 = string2 + "dsPortRipTableRipStatus.0";
                    String string8 = string2 + "dsPortRipTableSwitchDetected.0";
                    String string9 = string2 + "dsPortRipTableIndex";
                    String string10 = string2 + "dsPortRipTableRipType";
                    String string11 = string2 + "dsPortRipTableRipStatus";
                    while (true) {
                        objectArray = new VarBind(string3);
                        VarBind varBind = new VarBind(string4);
                        VarBind varBind2 = new VarBind(string5);
                        VarBind varBind3 = new VarBind(string6);
                        VarBind varBind4 = new VarBind(string7);
                        VarBind varBind5 = new VarBind(string8);
                        VarBindList varBindList2 = new VarBindList();
                        varBindList2.addVarBind((VarBind)objectArray);
                        varBindList2.addVarBind(varBind);
                        varBindList2.addVarBind(varBind2);
                        varBindList2.addVarBind(varBind3);
                        varBindList2.addVarBind(varBind4);
                        varBindList2.addVarBind(varBind5);
                        snmpRequest = new SnmpRequest(varBindList2, null, "", 161, 0, 0);
                        n = aidpSession.snmpRequest(snmpRequest);
                        if (n != 0 || snmpRequest.getErrorStatus() != 0) break block5;
                        varBindList = snmpRequest.getVarBindList();
                        if (varBindList.size() != 6) break;
                        string3 = varBindList.varbindAt(0).getRelativeName();
                        String string12 = varBindList.varbindAt(0).getStringValue();
                        Trace.logInfo((String)(m_szTraceId + ":getRipInfo"), (String)("Table Index Name = " + string3 + " Value = " + string12));
                        if (AvrAidpHelper.stillOnTable(string9, string3)) {
                            string4 = varBindList.varbindAt(1).getRelativeName();
                            int n2 = varBindList.varbindAt(1).getIntegerValue();
                            Trace.logInfo((String)(m_szTraceId + ":getRipInfo"), (String)("Input Port = " + string4 + "=" + n2));
                            string5 = varBindList.varbindAt(2).getRelativeName();
                            byte[] byArray = varBindList.varbindAt(2).getOctetStringValue();
                            String string13 = new String(byArray, UTF8_ENCODING);
                            Trace.logInfo((String)(m_szTraceId + ":getRipInfo"), (String)("RIP ID = " + string5 + "=" + string13));
                            string6 = varBindList.varbindAt(3).getRelativeName();
                            String string14 = varBindList.varbindAt(3).getStringValue();
                            Trace.logInfo((String)(m_szTraceId + ":getRipInfo"), (String)("RIP Type = " + string6 + "=" + string14));
                            string7 = varBindList.varbindAt(4).getRelativeName();
                            String string15 = varBindList.varbindAt(4).getStringValue();
                            Trace.logInfo((String)(m_szTraceId + ":getRipInfo"), (String)("RIP Status = " + string7 + "=" + string15));
                            string8 = varBindList.varbindAt(5).getRelativeName();
                            String string16 = varBindList.varbindAt(5).getStringValue();
                            Trace.logInfo((String)(m_szTraceId + ":getRipInfo"), (String)("Switch Detected = " + string8 + "=" + string16));
                            String string17 = MibEnum.getEnumForValue((String)string10, (int)Integer.parseInt(string14));
                            String string18 = MibEnum.getEnumForValue((String)string11, (int)Integer.parseInt(string15));
                            AvrRipInfo avrRipInfo = new AvrRipInfo(Integer.parseInt(string12), n2, string13, string17, string18, "", !string16.equals("1"), string13);
                            vector.add(avrRipInfo);
                            varBindList2.removeVarBinds();
                            continue;
                        }
                        break block6;
                        break;
                    }
                    Trace.logError((String)(m_szTraceId + ":getRipInfo"), (String)("<INVALID NUMBER OF BINDINGS RETURNED> Number: " + Integer.toHexString(varBindList.size())));
                    throw new ExceptionRequestFailed();
                }
                Trace.logInfo((String)(m_szTraceId + ":getRipInfo"), (String)("Error requesting Rip Info.AIDP Error = " + n + "SNMP Error = " + snmpRequest.getErrorStatusMessage()));
                if (snmpRequest.getErrorStatus() != 2) {
                    throw new ExceptionRequestFailed();
                }
            }
            objectArray = new AvrRipInfo[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            Trace.logError((String)(m_szTraceId + ":getRipInfo"), (String)"Error occured retrieving Rip information.", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    public static int getApplianceStatus(AidpSession aidpSession) throws ExceptionRequestFailed {
        try {
            VarBind varBind = new VarBind("avocent.ds.dsManagement.dsServer.dsServerStatus.0");
            if (!aidpSession.snmpGet(varBind)) {
                throw new Exception();
            }
            return varBind.getIntegerValue();
        }
        catch (Exception exception) {
            Trace.logError((String)m_szTraceId, (String)("Exception while retrieving appliance status:" + exception.getMessage()), (Throwable)exception);
            String string = res.getString("AvrAidpHelper_ASMP_Request_timed_out_");
            string = MessageFormat.format(string, APPLIANCE);
            throw new ExceptionRequestFailed(string);
        }
    }

    public static int getApplianceStatus(AidpSession aidpSession, int[] nArray) throws Exception {
        try {
            VarBind varBind = new VarBind("avocent.ds.dsManagement.dsServer.dsServerStatus.0");
            VarBindList varBindList = new VarBindList();
            varBindList.addVarBind(varBind);
            SnmpRequest snmpRequest = new SnmpRequest(varBindList, null, "", 160, 0, 0);
            int n = aidpSession.snmpRequest(snmpRequest);
            if (nArray != null && nArray.length > 0) {
                nArray[0] = n;
            }
            varBindList = snmpRequest.getVarBindList();
            varBind = varBindList.varbindAt(0);
            return n == 0 ? varBind.getIntegerValue() : -1;
        }
        catch (ExceptionUnknownMibName exceptionUnknownMibName) {
            Trace.logError((String)m_szTraceId, (String)("Exception: " + exceptionUnknownMibName.getMessage()), (Throwable)exceptionUnknownMibName);
        }
        catch (ExceptionVarBindIncompatibleSyntax exceptionVarBindIncompatibleSyntax) {
            Trace.logError((String)m_szTraceId, (String)("Exception: " + exceptionVarBindIncompatibleSyntax.getMessage()), (Throwable)exceptionVarBindIncompatibleSyntax);
        }
        String string = res.getString("AvrAidpHelper_ASMP_Request_timed_out_");
        string = MessageFormat.format(string, APPLIANCE);
        throw new ExceptionRequestFailed(string);
    }

    public static int getApplianceStatus(String string) throws ExceptionRequestFailed {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            AidpSession aidpSession = new AidpSession(inetAddress);
            return AvrAidpHelper.getApplianceStatus(aidpSession);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            throw exceptionRequestFailed;
        }
        catch (Throwable throwable) {
            Trace.logError((String)m_szTraceId, (String)("Exception: " + throwable.getMessage()), (Throwable)throwable);
            String string2 = res.getString("AvrAidpHelper_ASMP_Request_timed_out_");
            string2 = MessageFormat.format(string2, APPLIANCE);
            throw new ExceptionRequestFailed(string2);
        }
    }

    private static boolean stillOnTable(String string, String string2) {
        return string2.startsWith(string);
    }

    static {
        AvrSnmpHelper.initialize();
        try {
            Mib.register((String)"com.avocent.mibs.MibAvocentDs");
            Mib.register((String)"com.avocent.mibs.MibII");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.logInfo((String)"AvrAidpHelper:static initializer", (String)"got ClassNotFoundException when trying to register mibs");
        }
    }
}

