/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrAsmpHelper;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.avr.InterfaceDsSnmpConstants;
import com.avocent.avworks.nmm.avr.model.AvrLdapSupport;
import com.avocent.avworks.nmm.avr.model.AvrLocalAuthSupport;
import com.avocent.avworks.nmm.avr.model.AvrSnmpSupport;
import com.avocent.avworks.nmm.avr.virtualmedia.VirtualMediaSupport;
import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.AsmpConnection;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceSnmpConstants;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.Port;
import com.avocent.avworks.nmm.common.SnmpHelper;
import com.avocent.avworks.nmm.common.User;
import com.avocent.avworks.nmm.common.UserAccessLevel;
import com.avocent.avworks.nmm.common.model.AuthSupport;
import com.avocent.avworks.nmm.common.model.LdapSupport;
import com.avocent.avworks.nmm.common.model.RadiusSupport;
import com.avocent.avworks.nmm.common.model.SSHSupport;
import com.avocent.avworks.nmm.common.model.SnmpSupport;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;

public class AvrAppliance
extends Appliance
implements InterfaceSnmpConstants,
InterfaceDsSnmpConstants {
    public static final String TRACE_CONTEXT = "AvrAppliance";
    public static final String MIB_MAJOR_VERSION = "MIB_MAJOR_VERSION";
    public static final String MIB_MINOR_VERSION = "MIB_MINOR_VERSION";
    public static final String IS_USER_APPLIANCE_ADMIN = "IS_USER_APPLIANCE_ADMIN";
    protected AvrLdapSupport m_ldapSupport;
    protected SnmpSupport m_snmpSupport;
    protected AuthSupport m_localAuthSupport;
    protected VirtualMediaSupport m_vmSupport;
    protected UserAccessLevel[] m_aualAccessLevels;
    protected boolean m_userLevelDetermined = false;

    public AvrAppliance(AsmpConnection asmpConnection) {
        super(asmpConnection);
    }

    public UserAccessLevel[] getAccessLevelArray() throws Exception {
        return null;
    }

    public String getApplianceAdministratorLabel() {
        return null;
    }

    public Integer getMibMajorVersion() {
        try {
            Object object;
            if (!this.m_snmpValuesLoaded || (object = this.getValue(MIB_MAJOR_VERSION)) == null) {
                this.loadMibValues();
                return this.getIntValue(MIB_MAJOR_VERSION);
            }
            return (Integer)object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Integer getMibMinorVersion() {
        try {
            Object object;
            if (!this.m_snmpValuesLoaded || (object = this.getValue(MIB_MINOR_VERSION)) == null) {
                this.loadMibValues();
                return this.getIntValue(MIB_MINOR_VERSION);
            }
            return (Integer)object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void loadMibValues() throws Exception {
        Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsMibMajorVersion.0", "avocent.ds.dsManagement.dsServer.dsMibMinorVersion.0"};
        InterfaceValueObject[] interfaceValueObjectArray = this.getSnmpValues(objectArray);
        this.setValue(MIB_MAJOR_VERSION, interfaceValueObjectArray[0].getValue());
        this.setValue(MIB_MINOR_VERSION, interfaceValueObjectArray[1].getValue());
        this.m_snmpValuesLoaded = true;
    }

    public boolean isUserApplianceAdmin() {
        try {
            Object object;
            if (!this.m_userLevelDetermined || (object = this.getValue(IS_USER_APPLIANCE_ADMIN)) == null) {
                this.determineUserLevel();
                return this.getBooleanValue(IS_USER_APPLIANCE_ADMIN);
            }
            return (Boolean)object;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void determineUserLevel() throws Exception {
        Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsFileCreationStatus.0"};
        this.setValue(IS_USER_APPLIANCE_ADMIN, Boolean.TRUE);
        this.m_userLevelDetermined = true;
        try {
            InterfaceValueObject[] interfaceValueObjectArray = this.getSnmpValues(objectArray);
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.setValue(IS_USER_APPLIANCE_ADMIN, Boolean.FALSE);
        }
    }

    public String getMacAddress() {
        return AvrAsmpHelper.getMacAddress(this.m_acAsmpConnection);
    }

    public int mapToApplicationAccessLevel(int n) {
        return 0;
    }

    public UserAccessLevel getUserAccessLevel(int n) throws Exception {
        return null;
    }

    public Port[] loadPortTable() throws Exception {
        return null;
    }

    public boolean isSecurityLockoutSupported() {
        boolean bl = false;
        return this.getMibMajorVersion() >= 1 && this.getMibMinorVersion() >= 1;
    }

    public int getSecurityLockoutDuration() throws Exception {
        return 0;
    }

    public void setSecurityLockoutDuration(int n) throws Exception {
    }

    public void unlockUser(String string) throws Exception {
    }

    public User[] loadUserTable() throws Exception {
        return null;
    }

    public void deleteUser(User user) throws Exception {
    }

    public void modifyUser(User user) throws Exception {
    }

    public void addUser(User user) throws Exception {
    }

    public void clearPortAccessList(User user) throws Exception {
    }

    public void setPortAccess(User user, Port port) throws Exception {
    }

    public User newUser() throws ExceptionConstructorFailed {
        return null;
    }

    public String getSysName(boolean bl) throws Exception {
        Object object;
        if (!bl && (object = this.getValue("SNMP_SYS_NAME")) != null) {
            return object.toString();
        }
        object = this.getStringSnmpAttribute("mib-2.system.sysName.0", AvrSnmpHelper.getInstance());
        this.setValue("SNMP_SYS_NAME", object);
        return object;
    }

    public LdapSupport getLdapSupport() {
        if (this.m_ldapSupport == null) {
            this.m_ldapSupport = new AvrLdapSupport(this);
        }
        return this.m_ldapSupport;
    }

    public RadiusSupport getRadiusSupport() {
        return null;
    }

    public SSHSupport getSSHSupport() {
        return null;
    }

    public AuthSupport getLocalAuthSupport() {
        if (this.m_localAuthSupport == null) {
            this.m_localAuthSupport = new AvrLocalAuthSupport(this);
        }
        return this.m_localAuthSupport;
    }

    public SnmpSupport getSnmpSupport() {
        if (this.m_snmpSupport == null) {
            this.m_snmpSupport = new AvrSnmpSupport(this);
        }
        return this.m_snmpSupport;
    }

    public VirtualMediaSupport getVirtualMediaSupport() {
        if (this.m_vmSupport == null) {
            this.m_vmSupport = new VirtualMediaSupport(this);
        }
        return this.m_vmSupport;
    }

    public SnmpHelper getSnmpHelper() {
        return AvrSnmpHelper.getInstance();
    }
}

