/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.avr.InterfaceDsSnmpConstants;
import com.avocent.avworks.nmm.common.AsmpConnection;
import com.avocent.avworks.nmm.common.DiscoverInfo;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceSnmpConstants;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.net.MacAddress;
import com.avocent.lib.util.ResourceManager;
import java.io.IOException;
import java.net.InetAddress;
import java.text.MessageFormat;

public class AvrAsmpHelper
implements InterfaceSnmpConstants,
InterfaceDsSnmpConstants {
    public static final String LOG_CTXT = "AvrAsmpHelper";
    public static final String CNAME = "AsmpConnection";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.common.Res");
    private static Object[] APPLIANCE = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
    private static String UTF8_ENCODING = "UTF-8";
    private AsmpConnection asmpConnection;

    public AvrAsmpHelper(AsmpConnection asmpConnection) {
        this.asmpConnection = asmpConnection;
    }

    public DiscoverInfo discover() throws ExceptionRequestFailed {
        try {
            Object[] objectArray = new Object[]{"mib-2.system.sysObjectID.0", "mib-2.system.sysName.0", "avocent.ds.dsManagement.dsServer.dsLanIPAddress.0", "avocent.ds.dsManagement.dsServer.dsLanSubnetMask.0", "avocent.ds.dsManagement.dsServer.dsLanGateway.0"};
            InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.asmpConnection, objectArray);
            Trace.logInfo((String)CNAME, (String)("ASMP - discovered " + this.asmpConnection.getIpAddress()));
            String string = interfaceValueObjectArray[0].getString();
            String string2 = interfaceValueObjectArray[1].getString();
            IpAddress ipAddress = new IpAddress(interfaceValueObjectArray[2].getString());
            IpAddress ipAddress2 = new IpAddress(interfaceValueObjectArray[3].getString());
            IpAddress ipAddress3 = new IpAddress(interfaceValueObjectArray[4].getString());
            MacAddress macAddress = new MacAddress(this.getMacAddress());
            return new DiscoverInfo(string, string2, macAddress, ipAddress, ipAddress2, ipAddress3);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            throw new ExceptionRequestFailed((Throwable)exceptionInvalidArgument);
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            throw new ExceptionRequestFailed((Throwable)exceptionAsmpRequestFailed);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
            String string = res.getString("AsmpConnection_ASMP_Request_timed_out_");
            string = MessageFormat.format(string, objectArray);
            throw new ExceptionRequestFailed(string, (Throwable)exception);
        }
    }

    public int getApplianceStatus() throws ExceptionRequestFailed {
        return AvrAsmpHelper.getApplianceStatus(this.asmpConnection);
    }

    public String getMacAddress() {
        return AvrAsmpHelper.getMacAddress(this.asmpConnection);
    }

    public static DiscoverInfo discover(InetAddress inetAddress) throws ExceptionRequestFailed {
        Trace.logInfo((String)CNAME, (String)("discover( " + inetAddress + ")"));
        AsmpConnection asmpConnection = new AsmpConnection();
        try {
            asmpConnection.openAnonymousConnection(inetAddress);
            DiscoverInfo discoverInfo = new AvrAsmpHelper(asmpConnection).discover();
            return discoverInfo;
        }
        catch (IOException iOException) {
            Trace.logError((String)CNAME, (String)("discover(" + inetAddress + ")"), (Throwable)iOException);
            throw new ExceptionRequestFailed((Throwable)iOException);
        }
        finally {
            asmpConnection.closeAsmpSession();
        }
    }

    public static int getApplianceStatus(AsmpConnection asmpConnection) throws ExceptionRequestFailed {
        try {
            Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsServerStatus.0"};
            InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(asmpConnection, objectArray);
            Trace.logInfo((String)CNAME, (String)("ASMP - got status from " + asmpConnection.getIpAddress()));
            return interfaceValueObjectArray[0].getInteger();
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)("Exception while retrieving appliance status: " + exception.getMessage()), (Throwable)exception);
            String string = res.getString("AsmpConnection_ASMP_Request_timed_out_");
            string = MessageFormat.format(string, APPLIANCE);
            throw new ExceptionRequestFailed(string);
        }
    }

    public static String getMacAddress(AsmpConnection asmpConnection) {
        String string = null;
        try {
            Object[] objectArray = new Object[]{"mib-2.interfaces.ifTable.ifEntry.ifType", "mib-2.interfaces.ifTable.ifEntry.ifPhysAddress"};
            InterfaceValueObject[][] interfaceValueObjectArray = AvrSnmpHelper.getTableValues(asmpConnection, objectArray);
            Integer n = new Integer(6);
            for (int i = 0; i < interfaceValueObjectArray.length && string == null; ++i) {
                Trace.logInfo((String)LOG_CTXT, (String)("Read I/F type=" + interfaceValueObjectArray[i][0].toString() + "."));
                if (!interfaceValueObjectArray[i][0].getInteger().equals(n)) continue;
                string = interfaceValueObjectArray[i][1].toString();
                Trace.logInfo((String)LOG_CTXT, (String)("Found ethernet interface at I/F index=" + String.valueOf(i + 1) + ".  MAC Address=" + string + "."));
            }
        }
        catch (Exception exception) {
            Trace.logError((String)LOG_CTXT, (String)exception.getMessage(), (Throwable)exception);
        }
        return string;
    }
}

