/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrAidpHelper;
import com.avocent.avworks.nmm.avr.AvrRipInfo;
import com.avocent.avworks.nmm.avr.AvrServerInfo;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.avr.AvrSwitchInfo;
import com.avocent.avworks.nmm.common.AsmpConnection;
import com.avocent.avworks.nmm.common.DatabaseHelper;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksEventBroadcaster;
import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.ConnectionPath;
import com.avocent.avworks.services.ConnectionPathInfo;
import com.avocent.avworks.services.DatabaseSession;
import com.avocent.avworks.services.InterfaceInfo;
import com.avocent.avworks.services.InterfacesDb;
import com.avocent.avworks.services.ProductInfo;
import com.avocent.avworks.services.ProductsDb;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.ServerPropertiesDb;
import com.avocent.avworks.services.ServersDb;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.database.DBaseRequestQueryResults;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionDatabaseInconsistency;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionNotSupported;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.util.ResourceManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class AvrDatabaseHelper
extends DatabaseHelper {
    public static final String CNAME = "AvrDatabaseHelper";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    protected static Hashtable m_htPortCount = new Hashtable();
    protected static Hashtable m_htUserCount;

    public static String getServerName(String string, int n) throws ExceptionRequestFailed {
        CharSequence charSequence;
        DBaseRequestQueryResults dBaseRequestQueryResults = null;
        String string2 = null;
        try {
            charSequence = new StringBuffer();
            charSequence.append("SELECT servers.name FROM interfaces AS L1, SERVERS WHERE").append(" L1.NAME like '").append(string).append("' AND CONN_TYPE=1 AND servers.ID=L1.CONN_ID ");
            int n2 = DatabaseSession.executeQuery((String)charSequence.toString());
            dBaseRequestQueryResults = DatabaseSession.getQueryResults((int)n2, (int)100);
            DatabaseSession.closeQuery((int)n2);
            if (dBaseRequestQueryResults.getRowCount() > 0) {
                string2 = " RIP(" + string + ").";
            } else {
                String string3 = AvrDatabaseHelper.formatChannelName(n);
                charSequence = new StringBuffer();
                charSequence.append("SELECT servers.name FROM interfaces AS L1, INTERFACES AS L2, SERVERS WHERE").append(" L1.NAME like '").append(string).append("' AND L1.CONN_TYPE=2 AND L2.APPLIANCE_ID=L1.CONN_ID AND L2.NAME like '").append(string3).append("' AND servers.ID=L2.CONN_ID ");
                n2 = DatabaseSession.executeQuery((String)charSequence.toString());
                dBaseRequestQueryResults = DatabaseSession.getQueryResults((int)n2, (int)100);
                DatabaseSession.closeQuery((int)n2);
                if (dBaseRequestQueryResults.getRowCount() > 0) {
                    string2 = " RIP/Channel(" + string + "/" + string3 + ").";
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (dBaseRequestQueryResults.getRowCount() == 1) {
            dBaseRequestQueryResults.nextRow();
            charSequence = dBaseRequestQueryResults.getString(1);
            Trace.logInfo((String)CNAME, (String)(" Found server name " + (String)charSequence + " for " + string2));
            return charSequence;
        }
        if (dBaseRequestQueryResults.getRowCount() > 1) {
            Trace.logError((String)CNAME, (String)(" Found multiple server connected to RIP (" + string + ") and channel (" + n + ")."));
            throw new ExceptionRequestFailed();
        }
        return null;
    }

    public static String getServerName(int n, String string, int n2) throws ExceptionRequestFailed {
        int n3 = AvrDatabaseHelper.getInterfaceId(n, string, n2);
        if (n3 <= -1) {
            Trace.logInfo((String)CNAME, (String)" Unable to find server name in database.");
            return null;
        }
        try {
            InterfaceInfo interfaceInfo = InterfacesDb.getInterfaceInfo((int)n3);
            if (interfaceInfo.getConnType() != 1) {
                Trace.logError((String)CNAME, (String)" Interface not connected to a server");
                return null;
            }
            String string2 = ServersDb.getServerName((int)interfaceInfo.getConnID());
            return string2;
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)"Unable to get server name", (Throwable)exception);
            throw new ExceptionRequestFailed((Throwable)exception);
        }
    }

    public static int getServerId(int n, String string, int n2) throws ExceptionRequestFailed {
        int n3 = AvrDatabaseHelper.getInterfaceId(n, string, n2);
        if (n3 <= -1) {
            Trace.logInfo((String)CNAME, (String)" Unable to find server name in database.");
            return -1;
        }
        try {
            InterfaceInfo interfaceInfo = InterfacesDb.getInterfaceInfo((int)n3);
            if (interfaceInfo.getConnType() != 1) {
                Trace.logError((String)CNAME, (String)" Interface not connected to a server");
                return -1;
            }
            return interfaceInfo.getConnID();
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)"Unable to get server name", (Throwable)exception);
            throw new ExceptionRequestFailed((Throwable)exception);
        }
    }

    public static int getInterfaceId(int n, String string, int n2) throws ExceptionRequestFailed {
        DBaseRequestQueryResults dBaseRequestQueryResults = null;
        String string2 = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = "AND APPLIANCE_ID=" + Integer.toString(n);
            stringBuffer.append("SELECT L1.ID FROM interfaces AS L1 WHERE").append(" L1.NAME like '").append(string).append("' AND CONN_TYPE=1 ").append(string3);
            int n3 = DatabaseSession.executeQuery((String)stringBuffer.toString());
            dBaseRequestQueryResults = DatabaseSession.getQueryResults((int)n3, (int)100);
            DatabaseSession.closeQuery((int)n3);
            if (dBaseRequestQueryResults.getRowCount() > 0) {
                string2 = " RIP(" + string + ").";
            } else {
                String string4 = AvrDatabaseHelper.formatChannelName(n2);
                stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT L2.ID FROM interfaces AS L1, INTERFACES AS L2 WHERE").append(" L1.NAME like '").append(string).append("' AND L1.CONN_TYPE=2 AND L2.APPLIANCE_ID=L1.CONN_ID AND L2.NAME like '").append(string4).append("' ").append(string3);
                n3 = DatabaseSession.executeQuery((String)stringBuffer.toString());
                dBaseRequestQueryResults = DatabaseSession.getQueryResults((int)n3, (int)100);
                DatabaseSession.closeQuery((int)n3);
                if (dBaseRequestQueryResults.getRowCount() > 0) {
                    string2 = " RIP/Channel(" + string + "/" + string4 + ").";
                }
            }
        }
        catch (Exception exception) {
            return -1;
        }
        if (dBaseRequestQueryResults.getRowCount() == 1) {
            dBaseRequestQueryResults.nextRow();
            int n4 = dBaseRequestQueryResults.getInt(1);
            Trace.logInfo((String)CNAME, (String)(" Found interface " + n4 + " for " + string2));
            return n4;
        }
        if (dBaseRequestQueryResults.getRowCount() > 1) {
            Trace.logError((String)CNAME, (String)(" Found multiple server connected to RIP (" + string + ") and channel (" + n2 + ")."));
            throw new ExceptionRequestFailed();
        }
        return -1;
    }

    public static String formatChannelName(int n) {
        return "CH" + n;
    }

    public static int getChannelId(String string) {
        int n = 0;
        try {
            String string2 = "CH";
            String string3 = string.substring(string2.length());
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            Trace.logInfo((String)"getChannelId:", (String)"Unable to parse channel ID");
        }
        return n;
    }

    public static boolean isValidChannel(String string, int n) throws ExceptionNoValue, ExceptionDatabaseInconsistency {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT CONN_TYPE, CONN_ID FROM INTERFACES WHERE").append(" INTERFACES.NAME like '").append(string).append("'");
            Trace.logInfo((String)"AvrDatabaseHelper:isValidChannel", (String)("SQL:" + stringBuffer.toString()));
            int n2 = DatabaseSession.executeQuery((String)stringBuffer.toString());
            DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults((int)n2, (int)100);
            DatabaseSession.closeQuery((int)n2);
            if (dBaseRequestQueryResults.getRowCount() == 0) {
                throw new ExceptionNoValue();
            }
            dBaseRequestQueryResults.nextRow();
            int n3 = dBaseRequestQueryResults.getInt(1);
            int n4 = dBaseRequestQueryResults.getInt(2);
            if (n3 != 2) {
                Trace.logInfo((String)CNAME, (String)(string + "-" + n + " not valid, RIP is not attached to a switch."));
                return false;
            }
            int n5 = AvrDatabaseHelper.getInt("APPLIANCES", "PRODUCT_ID", "ID=" + n4, -1);
            if (!AvrDatabaseHelper.isCascadeSwitch(n5)) {
                Trace.logInfo((String)CNAME, (String)(string + "-" + n + " not valid, RIP is not attached to a switch."));
                throw new ExceptionDatabaseInconsistency();
            }
            if (n5 == -1) {
                Trace.logInfo((String)CNAME, (String)("Cannot find switch with appliance id (" + n4 + ") in the APPLIANCES table."));
                return true;
            }
            try {
                int n6 = AvrDatabaseHelper.getSwitchPortCount(n5);
                return n <= n6;
            }
            catch (Exception exception) {
                Trace.logError((String)CNAME, (String)("Unable to determine max channel count for product type (" + n5 + ")."));
                return true;
            }
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)CNAME, (String)("Unable to check for valid channel on " + string + "-" + n + ": " + exceptionRequestFailed.getMessage()), (Throwable)exceptionRequestFailed);
            return true;
        }
    }

    public static int getInt(String string, String string2, String string3, int n) throws ExceptionRequestFailed {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ").append(string2).append(" from ").append(string).append(" where ").append(string3);
        int n2 = DatabaseSession.executeQuery((String)stringBuffer.toString());
        DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults((int)n2, (int)100);
        DatabaseSession.closeQuery((int)n2);
        if (dBaseRequestQueryResults.getRowCount() == 0) {
            return n;
        }
        dBaseRequestQueryResults.nextRow();
        return dBaseRequestQueryResults.getInt(1);
    }

    public static InterfaceInfo getInterfaceObjectFromDB(int n, String string) throws ExceptionNoValue, ExceptionRequestFailed {
        try {
            String string2 = "WHERE (APPLIANCE_ID=" + Integer.toString(n) + ")" + " AND" + " (NAME=" + SqlCmd.quote((String)string) + ")";
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string2);
            if (interfaceInfoArray.length != 1) {
                throw new ExceptionNoValue();
            }
            return interfaceInfoArray[0];
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logError((String)"AvrDatabaseHelper.getInterfaceObjectFromDB()", (String)("Interface Appl#" + n + ", Rip#" + string + " does not exist in the database."), (Throwable)exceptionNoValue);
            throw exceptionNoValue;
        }
    }

    public static boolean doesInterfaceExist(int n, String string) throws ExceptionRequestFailed {
        try {
            String string2 = "WHERE (APPLIANCE_ID=" + Integer.toString(n) + ")" + " AND" + " (NAME=" + SqlCmd.quote((String)string) + ")";
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string2);
            if (interfaceInfoArray.length != 1) {
                throw new ExceptionRequestFailed();
            }
            return true;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logError((String)"AvrDatabaseHelper:doesInterfaceExist", (String)"Interface does not exist in the database.");
            return false;
        }
    }

    public static int getNumConnectedTo(int n, int n2) throws ExceptionRequestFailed {
        try {
            String string = "WHERE (CONN_ID=" + Integer.toString(n) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(n2) + ");";
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string);
            return interfaceInfoArray.length;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logInfo((String)"AvrDatabaseHelper:getNumConnectedTo", (String)"Unable to get interface info.  No Value was available.");
            return 0;
        }
        catch (Exception exception) {
            Trace.logError((String)"AvrDatabaseHelper:getNumConnectedTo", (String)"Unable to get interface info.  Request Failed.");
            throw new ExceptionRequestFailed();
        }
    }

    public static void deleteAppliance(int n, boolean bl) throws ExceptionNotSupported, ExceptionNoValue, ExceptionRequestFailed {
        InterfaceInfo[] interfaceInfoArray;
        Object object;
        ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo((int)n);
        if (applianceInfo.getNmmID() != 1) {
            Trace.logError((String)"AvrDatabaseHelper:deleteAppliance", (String)"Appliance not supported by AVR NMM.");
            throw new ExceptionRequestFailed();
        }
        if (AvrDatabaseHelper.getNumConnectedTo(n, 2) > 1) {
            Trace.logInfo((String)"AvrDatabaseHelper:deleteAppliance", (String)"NOTE : Found an upstream appliance, so don't delete it.");
            return;
        }
        Trace.logInfo((String)CNAME, (String)"reading associated interfaces ");
        try {
            object = "WHERE APPLIANCE_ID=" + Integer.toString(n);
            interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)object);
        }
        catch (ExceptionNoValue exceptionNoValue) {
            AvrDatabaseHelper.doDeleteAppliance(n, applianceInfo);
            return;
        }
        object = new int[interfaceInfoArray.length];
        int n2 = 0;
        for (int i = 0; i < interfaceInfoArray.length; ++i) {
            InterfaceInfo interfaceInfo = interfaceInfoArray[i];
            if (interfaceInfo.getConnType() == 1 && bl) {
                object[n2] = interfaceInfo.getConnID();
                ++n2;
            } else if (interfaceInfo.getConnType() == 2) {
                AvrDatabaseHelper.deleteAppliance(interfaceInfo.getConnID(), bl);
            }
            int[] nArray = new int[]{interfaceInfo.getID()};
            InterfacesDb.delete((int[])nArray);
        }
        if (n2 > 0) {
            int[] nArray = new int[n2];
            System.arraycopy(object, 0, nArray, 0, n2);
            AvrDatabaseHelper.deleteServers((int[])nArray);
        }
        AvrDatabaseHelper.doDeleteAppliance(n, applianceInfo);
    }

    private static void doDeleteAppliance(int n, ApplianceInfo applianceInfo) {
        Trace.logInfo((String)CNAME, (String)("Deleting Appliance #" + n + ", " + applianceInfo));
        int[] nArray = new int[]{n};
        AppliancesDb.delete((int[])nArray);
        if (!AvrDatabaseHelper.isCascadeSwitch(applianceInfo.getProductID())) {
            AVWorksEventBroadcaster.appendDeletedAppliances((UnitInfo[])new UnitInfo[]{applianceInfo});
        }
    }

    public static String[] getChanges(ApplianceInfo applianceInfo, AvrServerInfo[] avrServerInfoArray, AvrRipInfo[] avrRipInfoArray, boolean bl) throws ExceptionRequestFailed {
        Vector<String> vector = new Vector<String>();
        String string = AVWorksBranding.getDsrIqName((boolean)true);
        Object[] objectArray = new Object[]{string};
        try {
            Object object;
            Object object2;
            for (int i = 0; i < avrRipInfoArray.length; ++i) {
                object2 = avrRipInfoArray[i];
                InterfaceInfo interfaceInfo = null;
                if (((AvrRipInfo)object2).getRipStatus().equals(res.getString("AvrDatabaseHelper_Offline")) && !bl) {
                    Trace.logInfo((String)"AvrDatabaseHelper:getChanges", (String)("RIP " + ((AvrRipInfo)object2).getRipID() + " is Offline and we aren't including Offline Rips."));
                    continue;
                }
                try {
                    interfaceInfo = AvrDatabaseHelper.getInterfaceObjectFromDB(applianceInfo.getID(), ((AvrRipInfo)object2).getRipID());
                }
                catch (ExceptionNoValue exceptionNoValue) {
                    vector.add(((AvrRipInfo)object2).getRipID() + MessageFormat.format(res.getString("AvrDatabaseHelper_0_Added"), objectArray));
                    continue;
                }
                object = AvrDatabaseHelper.checkConnTypeChange(interfaceInfo, (AvrRipInfo)object2);
                if (((String)object).length() != 0) {
                    vector.add((String)object);
                    continue;
                }
                Vector vector2 = AvrDatabaseHelper.checkServerNameChange(applianceInfo.getID(), interfaceInfo, (AvrRipInfo)object2, avrServerInfoArray);
                for (int j = 0; j < vector2.size(); ++j) {
                    vector.add((String)vector2.elementAt(j));
                }
            }
            try {
                String string2 = "WHERE APPLIANCE_ID=" + Integer.toString(applianceInfo.getID());
                object2 = InterfacesDb.getInterfaceInfoList((String)string2);
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    if (!AvrDatabaseHelper.doesRipExistInRipTbl(object2[i].getName(), avrRipInfoArray)) {
                        vector.add(object2[i].getName() + MessageFormat.format(res.getString("AvrDatabaseHelper_0_Deleted"), objectArray));
                        continue;
                    }
                    if (bl || (object = AvrDatabaseHelper.getRipFromRipTbl(object2[i].getName(), avrRipInfoArray)) == null || !((AvrRipInfo)object).getRipStatus().equals(res.getString("AvrDatabaseHelper_Offline"))) continue;
                    Trace.logInfo((String)"AvrDatabaseHelper:getChanges", (String)("RIP " + ((AvrRipInfo)object).getRipID() + " is Offline and we aren't including Offline Rips.  Mark as a change."));
                    vector.add(object2[i].getName() + MessageFormat.format(res.getString("AvrDatabaseHelper_Rip_Offline"), objectArray));
                }
            }
            catch (ExceptionNoValue exceptionNoValue) {
                Trace.logInfo((String)"AvrDatabaseHelper:getChanges", (String)"No interfaces found in DB.");
            }
            for (int i = 0; i < avrRipInfoArray.length; ++i) {
                try {
                    Object[] objectArray2;
                    object2 = avrRipInfoArray[i];
                    int n = ((AvrRipInfo)object2).getInputPort() + 1;
                    object = AvrDatabaseHelper.getInterfaceObjectFromDB(applianceInfo.getID(), ((AvrRipInfo)object2).getRipID());
                    int n2 = object.getPortNum();
                    if (n2 == n) continue;
                    if (n2 > 0) {
                        objectArray2 = new Object[]{Integer.toString(n2), Integer.toString(n)};
                        vector.add(((AvrRipInfo)object2).getRipID() + MessageFormat.format(res.getString("AvrDatabaseHelper_Port_Num_Changed"), objectArray2));
                        continue;
                    }
                    if (n2 != 0) continue;
                    objectArray2 = new Object[]{Integer.toString(n)};
                    vector.add(((AvrRipInfo)object2).getRipID() + MessageFormat.format(res.getString("AvrDatabaseHelper_Port_Num_Added_To_Database"), objectArray2));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (vector.size() == 0) {
                return new String[0];
            }
            Object[] objectArray3 = new String[vector.size()];
            vector.copyInto(objectArray3);
            return objectArray3;
        }
        catch (Exception exception) {
            Trace.logError((String)"AvrDatabaseHelper:getChanges", (String)"Error Determining changes.", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    public static boolean doesRipExistInRipTbl(String string, AvrRipInfo[] avrRipInfoArray) {
        boolean bl = false;
        for (int i = 0; i < avrRipInfoArray.length; ++i) {
            AvrRipInfo avrRipInfo = avrRipInfoArray[i];
            if (!avrRipInfo.getRipID().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static AvrRipInfo getRipFromRipTbl(String string, AvrRipInfo[] avrRipInfoArray) {
        for (int i = 0; i < avrRipInfoArray.length; ++i) {
            AvrRipInfo avrRipInfo = avrRipInfoArray[i];
            if (!avrRipInfo.getRipID().equals(string)) continue;
            return avrRipInfo;
        }
        return null;
    }

    public static String checkConnTypeChange(InterfaceInfo interfaceInfo, AvrRipInfo avrRipInfo) {
        String string = AVWorksBranding.getCascadeSwitchName((boolean)true);
        Object[] objectArray = new Object[]{string};
        String string2 = "";
        boolean bl = avrRipInfo.isSwitchDetected();
        int n = interfaceInfo.getConnType();
        if (bl && n == 1) {
            string2 = avrRipInfo.getRipID() + MessageFormat.format(res.getString("AvrDatabaseHelper_0_detected"), objectArray);
        } else if (bl && n == 0) {
            string2 = avrRipInfo.getRipID() + MessageFormat.format(res.getString("AvrDatabaseHelper_0_detected"), objectArray);
        } else if (!bl && n == 2) {
            string2 = avrRipInfo.getRipID() + MessageFormat.format(res.getString("AvrDatabaseHelper_0_no_longer_exists"), objectArray);
        }
        return string2;
    }

    public static Vector checkServerNameChange(int n, InterfaceInfo interfaceInfo, AvrRipInfo avrRipInfo, AvrServerInfo[] avrServerInfoArray) throws ExceptionRequestFailed {
        Vector<String> vector = new Vector<String>();
        String string = AVWorksBranding.getServerName((boolean)true);
        Object[] objectArray = new Object[]{string};
        try {
            boolean bl = avrRipInfo.isSwitchDetected();
            if (!bl) {
                AvrServerInfo avrServerInfo = AvrDatabaseHelper.getServerEntryForRIPFromServerTbl(avrRipInfo.getRipID(), 0, avrServerInfoArray);
                String string2 = avrServerInfo.getServerName();
                String string3 = AvrDatabaseHelper.getServerName(n, avrRipInfo.getRipID(), 0);
                if (string3 == null) {
                    vector.add(avrRipInfo.getRipID() + MessageFormat.format(res.getString("AvrDatabaseHelper_0_Added"), objectArray));
                    return vector;
                }
                if (AvrDatabaseHelper.hasServerNameChanged(string3, string2, avrRipInfo.getRipID(), false)) {
                    if (AVWorksBranding.getBoolean((String)"AvrResyncReplace", (boolean)false)) {
                        vector.add(avrRipInfo.getRipID() + MessageFormat.format(res.getString("AvrDatabaseHelper_0_Replaced"), objectArray));
                    } else {
                        vector.add(avrRipInfo.getRipID() + MessageFormat.format(res.getString("AvrDatabaseHelper_0_name_changed"), objectArray));
                    }
                    return vector;
                }
                if (AvrDatabaseHelper.hasServerNameChanged(string3, string2, avrRipInfo.getRipID(), true)) {
                    vector.add(avrRipInfo.getRipID() + MessageFormat.format(res.getString("AvrDatabaseHelper_0_name_changed"), objectArray));
                }
            } else {
                int n2 = interfaceInfo.getConnID();
                ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo((int)n2);
                int n3 = AvrDatabaseHelper.getSwitchPortCount(applianceInfo.getProductID());
                String string4 = "WHERE (APPLIANCE_ID=" + Integer.toString(n) + ")" + " AND" + " (CONN_ID=" + Integer.toString(n2) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(2) + ")";
                InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string4);
                for (int i = 1; i <= n3; ++i) {
                    Object[] objectArray2;
                    String string5 = AvrDatabaseHelper.getServerName(n, interfaceInfoArray[0].getName(), i);
                    AvrServerInfo avrServerInfo = AvrDatabaseHelper.getServerEntryForRIPFromServerTbl(interfaceInfoArray[0].getName(), i, avrServerInfoArray);
                    String string6 = avrServerInfo.getServerName();
                    if (string5 == null) {
                        objectArray2 = new Object[]{string, AvrDatabaseHelper.formatChannelName(i)};
                        vector.add(avrRipInfo.getRipID() + MessageFormat.format(res.getString("AvrDatabaseHelper_0_Added_for_1"), objectArray2));
                        continue;
                    }
                    objectArray2 = NumberFormat.getInstance();
                    objectArray2.setMinimumIntegerDigits(2);
                    Object[] objectArray3 = new Object[]{string, AvrDatabaseHelper.formatChannelName(i)};
                    if (AvrDatabaseHelper.hasServerNameChanged(string5, string6, interfaceInfoArray[0].getName() + objectArray2.format(i), false)) {
                        if (AVWorksBranding.getBoolean((String)"AvrResyncReplace", (boolean)false)) {
                            vector.add(avrRipInfo.getRipID() + MessageFormat.format(res.getString("AvrDatabaseHelper_0_Replaced_for_1"), objectArray3));
                            continue;
                        }
                        vector.add(avrRipInfo.getRipID() + MessageFormat.format(res.getString("AvrDatabaseHelper_0_name_changed_for_1"), objectArray3));
                        continue;
                    }
                    if (!AvrDatabaseHelper.hasServerNameChanged(string5, string6, interfaceInfoArray[0].getName() + objectArray2.format(i), true)) continue;
                    vector.add(avrRipInfo.getRipID() + MessageFormat.format(res.getString("AvrDatabaseHelper_0_name_changed_for_1"), objectArray3));
                }
            }
            return vector;
        }
        catch (Exception exception) {
            Trace.logError((String)"AvrDatabaseHelper:checkServerNameChange", (String)"Error checking server name change.", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    public static boolean hasServerNameChanged(String string, String string2, String string3, boolean bl) {
        if (string == null || string.length() == 0) {
            return true;
        }
        if (string2.equalsIgnoreCase(string3)) {
            return false;
        }
        if (!string2.equalsIgnoreCase(string)) {
            return true;
        }
        return bl && !string2.equals(string);
    }

    public static AvrServerInfo getServerEntryForRIPFromServerTbl(String string, int n, AvrServerInfo[] avrServerInfoArray) throws ExceptionNoValue {
        for (int i = 0; i < avrServerInfoArray.length; ++i) {
            AvrServerInfo avrServerInfo = avrServerInfoArray[i];
            if (!avrServerInfo.getRipID().equals(string) || avrServerInfo.getChannelID() != n) continue;
            return avrServerInfo;
        }
        throw new ExceptionNoValue();
    }

    public static void resyncAppliance(ApplianceInfo applianceInfo, AvrSwitchInfo[] avrSwitchInfoArray, AvrRipInfo[] avrRipInfoArray, AvrServerInfo[] avrServerInfoArray) throws ExceptionRequestFailed {
        AvrDatabaseHelper.resyncAppliance(applianceInfo, avrSwitchInfoArray, avrRipInfoArray, avrServerInfoArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resyncAppliance(ApplianceInfo applianceInfo, AvrSwitchInfo[] avrSwitchInfoArray, AvrRipInfo[] avrRipInfoArray, AvrServerInfo[] avrServerInfoArray, boolean bl) throws ExceptionRequestFailed {
        boolean bl2 = false;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        boolean bl3 = false;
        int n = applianceInfo.getID();
        try {
            UnitInfo[] unitInfoArray;
            InterfaceInfo[] interfaceInfoArray;
            if (avrSwitchInfoArray != null) {
                if (AvrDatabaseHelper.deleteSwitchesFromDB(applianceInfo.getID(), avrSwitchInfoArray)) {
                    bl2 = true;
                }
            } else {
                avrSwitchInfoArray = new AvrSwitchInfo[]{};
            }
            if (n == 0) {
                try {
                    n = AppliancesDb.add((ApplianceInfo)applianceInfo);
                    applianceInfo.setID(n);
                    bl2 = true;
                    bl3 = true;
                }
                catch (Exception exception) {
                    Trace.logError((String)"AvrDatabaseHelper:resyncAppliance", (String)"Error adding appliance to database.", (Throwable)exception);
                    throw new ExceptionRequestFailed();
                }
            }
            AsmpConnection asmpConnection = new AsmpConnection();
            try {
                asmpConnection.openAnonymousConnection(InetAddress.getByName(applianceInfo.getAddress()));
                if (avrRipInfoArray == null) {
                    avrRipInfoArray = AvrSnmpHelper.getRipInfo(asmpConnection);
                }
                if (avrServerInfoArray == null) {
                    avrServerInfoArray = AvrSnmpHelper.getServerInfo(asmpConnection);
                }
            }
            catch (Exception exception) {
                Trace.logError((String)"AvrDatabaseHelper:resynchAppliance(...)", (String)"Caught exception from ASMP, falling back to AIDP.", (Throwable)exception);
                if (avrRipInfoArray == null) {
                    avrRipInfoArray = AvrAidpHelper.getRipInfo(applianceInfo.getAddress());
                }
                if (avrServerInfoArray == null) {
                    avrServerInfoArray = AvrAidpHelper.getServerInfo(applianceInfo.getAddress());
                }
            }
            finally {
                try {
                    asmpConnection.closeAsmpSession();
                }
                catch (Exception exception) {
                    Trace.logError((String)"AvrDatabaseHelper:resynchAppliance(...)", (String)"Caught exception that could bypass rest of method.", (Throwable)exception);
                }
            }
            for (int i = 0; i < avrRipInfoArray.length; ++i) {
                interfaceInfoArray = avrRipInfoArray[i];
                InterfaceInfo interfaceInfo = null;
                if (interfaceInfoArray.getRipStatus().equals(res.getString("AvrDatabaseHelper_Offline")) && !bl) {
                    Trace.logInfo((String)"AvrDatabaseHelper:resyncAppliance", (String)("RIP " + interfaceInfoArray.getRipID() + " is Offline and we aren't including Offline Rips."));
                    continue;
                }
                try {
                    interfaceInfo = AvrDatabaseHelper.getInterfaceObjectFromDB(n, interfaceInfoArray.getRipID());
                }
                catch (ExceptionNoValue exceptionNoValue) {
                    Trace.logInfo((String)"AvrDatabaseHelper:resyncAppliance", (String)("A new RIP has been added.  RIP ID = " + interfaceInfoArray.getRipID()));
                    AvrDatabaseHelper.addRip(n, (AvrRipInfo)interfaceInfoArray, avrRipInfoArray, avrSwitchInfoArray, avrServerInfoArray, arrayList);
                    bl2 = true;
                    continue;
                }
                if (!AvrDatabaseHelper.resyncRip(n, interfaceInfo, (AvrRipInfo)interfaceInfoArray, avrRipInfoArray, avrSwitchInfoArray, avrServerInfoArray, arrayList, arrayList2, arrayList3)) continue;
                bl2 = true;
            }
            try {
                unitInfoArray = "WHERE APPLIANCE_ID=" + Integer.toString(n);
                interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)unitInfoArray);
                for (int i = 0; i < interfaceInfoArray.length; ++i) {
                    AvrRipInfo avrRipInfo;
                    if (!AvrDatabaseHelper.doesRipExistInRipTbl(interfaceInfoArray[i].getName(), avrRipInfoArray)) {
                        Trace.logInfo((String)"AvrDatabaseHelper:resyncAppliance", (String)("A RIP has been deleted.  RIP ID = " + interfaceInfoArray[i].getName()));
                        AvrDatabaseHelper.deleteRip(interfaceInfoArray[i], arrayList3);
                        bl2 = true;
                        continue;
                    }
                    if (bl || (avrRipInfo = AvrDatabaseHelper.getRipFromRipTbl(interfaceInfoArray[i].getName(), avrRipInfoArray)) == null || !avrRipInfo.getRipStatus().equals(res.getString("AvrDatabaseHelper_Offline"))) continue;
                    Trace.logInfo((String)"AvrDatabaseHelper:resyncAppliance", (String)("A RIP is offline.  RIP ID = " + interfaceInfoArray[i].getName()));
                    AvrDatabaseHelper.deleteRip(interfaceInfoArray[i], arrayList3);
                    bl2 = true;
                }
            }
            catch (ExceptionNoValue exceptionNoValue) {
                Trace.logInfo((String)"AvrDatabaseHelper:resyncAppliance", (String)"No interfaces found in DB.");
            }
            if (bl2) {
                AVWorksEventBroadcaster.fireDatabaseModifiedEvent();
            }
            if (arrayList.size() > 0) {
                unitInfoArray = arrayList.toArray(new UnitInfo[0]);
                AVWorksEventBroadcaster.fireDatabaseServersAddedEvent((UnitInfo[])unitInfoArray);
            }
            if (arrayList2.size() > 0) {
                unitInfoArray = arrayList2.toArray(new UnitInfo[0]);
                AVWorksEventBroadcaster.fireDatabaseServersModifiedEvent((UnitInfo[])unitInfoArray);
            }
            if (arrayList3.size() > 0) {
                unitInfoArray = arrayList3.toArray(new UnitInfo[0]);
                AVWorksEventBroadcaster.appendDeletedServers((UnitInfo[])unitInfoArray);
            }
            AVWorksEventBroadcaster.fireDatabaseServersDeletedEvent();
            if (bl3) {
                AVWorksEventBroadcaster.fireDatabaseAppliancesAddedEvent((UnitInfo[])new UnitInfo[]{applianceInfo});
            }
            if (bl2) {
                AVWorksEventBroadcaster.fireDatabaseApplianceResynchedEvent((UnitInfo)applianceInfo);
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"AvrDatabaseHelper:resyncAppliance", (String)"Error resyncing database.", (Throwable)exception);
            if (bl3) {
                try {
                    AvrDatabaseHelper.deleteAppliance(n, true);
                    try {
                        String string = "WHERE AMP=" + Integer.toString(0);
                        ApplianceInfo[] applianceInfoArray = AppliancesDb.getAllAppliances((String)string);
                        for (int i = 0; i < applianceInfoArray.length; ++i) {
                            int n2 = ConnectionPath.parseSwitchNameForParentID((String)applianceInfoArray[i].getName());
                            if (n2 != n) continue;
                            try {
                                String string2 = "WHERE (CONN_ID=" + Integer.toString(applianceInfoArray[i].getID()) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(2) + ")";
                                InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string2);
                                for (int j = 0; j < interfaceInfoArray.length; ++j) {
                                    InterfaceInfo interfaceInfo = interfaceInfoArray[j];
                                    interfaceInfo.setConnID(0);
                                    interfaceInfo.setConnType(0);
                                    InterfacesDb.modify((InterfaceInfo)interfaceInfo);
                                }
                            }
                            catch (ExceptionNoValue exceptionNoValue) {
                                Trace.logInfo((String)"AvrDatabaseHelper:deleteSwitches", (String)"No interfaces to disassociate.");
                            }
                            AvrDatabaseHelper.deleteAppliance(applianceInfoArray[i].getID(), true);
                        }
                    }
                    catch (ExceptionNoValue exceptionNoValue) {
                        Trace.logInfo((String)"AvrDatabaseHelper:deleteSwitches", (String)"No switch to delete.");
                    }
                }
                catch (Exception exception2) {
                    Trace.logError((String)"AvrDatabaseHelper:resyncAppliance", (String)"Unable to delete the added appliance.");
                }
            }
            throw new ExceptionRequestFailed();
        }
    }

    public static boolean updateServerApplianceIndex(AvrServerInfo[] avrServerInfoArray) {
        boolean bl = false;
        for (int i = 0; i < avrServerInfoArray.length; ++i) {
            AvrServerInfo avrServerInfo = avrServerInfoArray[i];
            try {
                ServerInfo serverInfo = ServersDb.getServerInfo((String)avrServerInfo.getRipID(), (int)avrServerInfo.getChannelID());
                if (serverInfo == null || serverInfo.getApplianceIndex(1) == avrServerInfo.getIndex()) continue;
                ServersDb.setApplinaceMibIndex((int)serverInfo.getID(), (int)avrServerInfo.getIndex());
                bl = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static boolean deleteSwitchesFromDB(int n, AvrSwitchInfo[] avrSwitchInfoArray) throws ExceptionRequestFailed {
        boolean bl = false;
        try {
            String string = "WHERE AMP=" + Integer.toString(0);
            ApplianceInfo[] applianceInfoArray = AppliancesDb.getAllAppliances((String)string);
            for (int i = 0; i < applianceInfoArray.length; ++i) {
                int n2 = ConnectionPath.parseSwitchNameForParentID((String)applianceInfoArray[i].getName());
                if (n2 != n || AvrDatabaseHelper.doesSwitchExist(applianceInfoArray[i].getID(), avrSwitchInfoArray)) continue;
                try {
                    String string2 = "WHERE (CONN_ID=" + Integer.toString(applianceInfoArray[i].getID()) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(2) + ")";
                    InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string2);
                    for (int j = 0; j < interfaceInfoArray.length; ++j) {
                        InterfaceInfo interfaceInfo = interfaceInfoArray[j];
                        interfaceInfo.setConnID(0);
                        interfaceInfo.setConnType(0);
                        InterfacesDb.modify((InterfaceInfo)interfaceInfo);
                    }
                }
                catch (ExceptionNoValue exceptionNoValue) {
                    Trace.logInfo((String)"AvrDatabaseHelper:deleteSwitches", (String)"No interfaces to disassociate.");
                }
                AvrDatabaseHelper.deleteAppliance(applianceInfoArray[i].getID(), true);
                bl = true;
            }
            return bl;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            return false;
        }
        catch (Exception exception) {
            Trace.logError((String)"AvrDatabaseHelper:deleteSwitches", (String)"Error deleting switches from DB");
            throw new ExceptionRequestFailed();
        }
    }

    public static boolean doesSwitchExist(int n, AvrSwitchInfo[] avrSwitchInfoArray) {
        boolean bl = false;
        for (int i = 0; i < avrSwitchInfoArray.length; ++i) {
            AvrSwitchInfo avrSwitchInfo = avrSwitchInfoArray[i];
            if (avrSwitchInfo.getSwitchID() != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static void addRip(int n, AvrRipInfo avrRipInfo, AvrRipInfo[] avrRipInfoArray, AvrSwitchInfo[] avrSwitchInfoArray, AvrServerInfo[] avrServerInfoArray, List list) throws ExceptionRequestFailed {
        try {
            int n2 = InterfacesDb.add((int)n, (String)avrRipInfo.getRipID(), (int)(avrRipInfo.getInputPort() + 1));
            if (!avrRipInfo.isSwitchDetected()) {
                AvrServerInfo avrServerInfo = AvrDatabaseHelper.getServerEntryForRIPFromServerTbl(avrRipInfo.getRipID(), 0, avrServerInfoArray);
                String string = avrServerInfo.getServerName();
                ServerInfo serverInfo = AvrDatabaseHelper.createServerInfoConnRules(string, 1, ConnectionPathInfo.VIDEO_CONNECTION_TYPE, n, avrServerInfo.getIndex(), list);
                InterfaceInfo interfaceInfo = InterfacesDb.getInterfaceInfo((int)n2);
                interfaceInfo.setConnID(serverInfo.getID());
                interfaceInfo.setConnType(1);
                InterfacesDb.modify((InterfaceInfo)interfaceInfo);
            } else {
                AvrSwitchInfo avrSwitchInfo = AvrDatabaseHelper.getSwitchForRip(avrRipInfo.getRipID(), avrSwitchInfoArray);
                if (avrSwitchInfo != null) {
                    Object object;
                    int n3 = avrSwitchInfo.getSwitchID();
                    if (n3 == 0) {
                        if (AppliancesDb.isNameDefined((String)avrSwitchInfo.getSwitchName())) {
                            object = "WHERE (AMP=" + Integer.toString(0) + ")" + " AND" + " (NAME=" + SqlCmd.quote((String)avrSwitchInfo.getSwitchName()) + ")";
                            ApplianceInfo[] applianceInfoArray = AppliancesDb.getAllAppliances((String)object);
                            n3 = applianceInfoArray[0].getID();
                        } else {
                            n3 = AvrDatabaseHelper.addSwitch(n, avrRipInfo.getRipID(), avrRipInfoArray, avrSwitchInfo, avrServerInfoArray, list);
                        }
                    }
                    object = InterfacesDb.getInterfaceInfo((int)n2);
                    object.setConnID(n3);
                    object.setConnType(2);
                    InterfacesDb.modify((InterfaceInfo)object);
                } else {
                    InterfaceInfo interfaceInfo = InterfacesDb.getInterfaceInfo((int)n2);
                    interfaceInfo.setConnID(0);
                    interfaceInfo.setConnType(0);
                    InterfacesDb.modify((InterfaceInfo)interfaceInfo);
                }
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"AvrDatabaseHelper:addRip", (String)"Error adding Rip.", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    private static int addSwitch(int n, String string, AvrRipInfo[] avrRipInfoArray, AvrSwitchInfo avrSwitchInfo, AvrServerInfo[] avrServerInfoArray, List list) throws ExceptionRequestFailed {
        try {
            int n2;
            int n3;
            String string2 = avrSwitchInfo.getSwitchName();
            int n4 = ConnectionPath.parseSwitchNameForParentID((String)string2);
            if (n4 == 0) {
                string2 = ConnectionPath.parseSwitchName((String)avrSwitchInfo.getSwitchName());
                string2 = n + ":" + string2;
            }
            if ((n3 = avrSwitchInfo.getSwitchID()) == 0 && AppliancesDb.isNameDefined((String)string2)) {
                String string3 = "WHERE (AMP=" + Integer.toString(0) + ")" + " AND" + " (NAME=" + SqlCmd.quote((String)string2) + ")";
                ApplianceInfo[] applianceInfoArray = AppliancesDb.getAllAppliances((String)string3);
                n3 = applianceInfoArray[0].getID();
                return n3;
            }
            int n5 = avrSwitchInfo.getSwitchType();
            ProductInfo productInfo = ProductsDb.getProductInfo((int)n5);
            ApplianceInfo applianceInfo = new ApplianceInfo(0, string2, productInfo.getName(), n5, "", "", "", "", productInfo.getNmmID(), false);
            n3 = AppliancesDb.add((ApplianceInfo)applianceInfo);
            int n6 = 0;
            ApplianceInfo applianceInfo2 = AppliancesDb.getApplianceInfo((int)n);
            for (n2 = 0; n2 < avrRipInfoArray.length; ++n2) {
                AvrRipInfo avrRipInfo = avrRipInfoArray[n2];
                if (!avrRipInfo.getRipID().equalsIgnoreCase(string)) continue;
                n6 = avrRipInfo.getInputPort() + 1;
                break;
            }
            n2 = AvrDatabaseHelper.getSwitchPortCount(n5);
            for (int i = 1; i <= n2; ++i) {
                String string4 = AvrDatabaseHelper.formatChannelName(i);
                int n7 = AvrDatabaseHelper.getChannelId(string4);
                int n8 = InterfacesDb.add((int)n3, (String)string4, (int)n7);
                AvrServerInfo avrServerInfo = AvrDatabaseHelper.getServerEntryForRIPFromServerTbl(string, i, avrServerInfoArray);
                String string5 = avrServerInfo.getServerName();
                ServerInfo serverInfo = AvrDatabaseHelper.createServerInfoConnRules(string5, 1, ConnectionPathInfo.VIDEO_CONNECTION_TYPE, n, avrServerInfo.getIndex(), list);
                InterfaceInfo interfaceInfo = InterfacesDb.getInterfaceInfo((int)n8);
                interfaceInfo.setConnID(serverInfo.getID());
                interfaceInfo.setConnType(1);
                InterfacesDb.modify((InterfaceInfo)interfaceInfo);
            }
            return n3;
        }
        catch (Exception exception) {
            Trace.logError((String)"AvrDatabaseHelper:addSwitch", (String)"Error adding Switch.", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    public static AvrSwitchInfo getSwitchForRip(String string, AvrSwitchInfo[] avrSwitchInfoArray) {
        for (int i = 0; i < avrSwitchInfoArray.length; ++i) {
            AvrSwitchInfo avrSwitchInfo = avrSwitchInfoArray[i];
            String[] stringArray = avrSwitchInfo.getAttachedRipIDs();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string.equals(stringArray[j])) continue;
                return avrSwitchInfo;
            }
        }
        return null;
    }

    private static boolean resyncRip(int n, InterfaceInfo interfaceInfo, AvrRipInfo avrRipInfo, AvrRipInfo[] avrRipInfoArray, AvrSwitchInfo[] avrSwitchInfoArray, AvrServerInfo[] avrServerInfoArray, List list, List list2, List list3) throws ExceptionRequestFailed {
        boolean bl = false;
        try {
            Object object;
            Object object2;
            Object object3;
            int n2 = avrRipInfo.getInputPort() + 1;
            int n3 = interfaceInfo.getPortNum();
            if (n3 != n2) {
                interfaceInfo.setPortNum(n2);
                InterfacesDb.modify((InterfaceInfo)interfaceInfo);
                bl = true;
            }
            boolean bl2 = avrRipInfo.isSwitchDetected();
            int n4 = interfaceInfo.getConnType();
            if (bl2 && (n4 == 1 || n4 == 0)) {
                if (n4 == 1) {
                    object3 = ServersDb.getServerInfo((int)interfaceInfo.getConnID());
                    if (AvrDatabaseHelper.deleteServer((int)interfaceInfo.getConnID())) {
                        bl = true;
                        list3.add(object3);
                    }
                }
                if ((object3 = AvrDatabaseHelper.getSwitchForRip(avrRipInfo.getRipID(), avrSwitchInfoArray)) == null) {
                    interfaceInfo.setConnID(0);
                    interfaceInfo.setConnType(0);
                    InterfacesDb.modify((InterfaceInfo)interfaceInfo);
                    bl = true;
                    return bl;
                }
                int n5 = ((AvrSwitchInfo)object3).getSwitchID();
                if (n5 == 0) {
                    if (AppliancesDb.isNameDefined((String)((AvrSwitchInfo)object3).getSwitchName())) {
                        object2 = "WHERE (AMP=" + Integer.toString(0) + ")" + " AND" + " (NAME=" + SqlCmd.quote((String)((AvrSwitchInfo)object3).getSwitchName()) + ")";
                        object = AppliancesDb.getAllAppliances((String)object2);
                        n5 = object[0].getID();
                    } else {
                        n5 = AvrDatabaseHelper.addSwitch(n, avrRipInfo.getRipID(), avrRipInfoArray, (AvrSwitchInfo)object3, avrServerInfoArray, list);
                        interfaceInfo.setConnID(n5);
                        interfaceInfo.setConnType(2);
                        InterfacesDb.modify((InterfaceInfo)interfaceInfo);
                        bl = true;
                        return bl;
                    }
                }
                interfaceInfo.setConnID(n5);
                interfaceInfo.setConnType(2);
                InterfacesDb.modify((InterfaceInfo)interfaceInfo);
                bl = true;
            }
            if (!bl2 && n4 == 2) {
                AvrDatabaseHelper.deleteAppliance(interfaceInfo.getConnID(), true);
                bl = true;
                object3 = AvrDatabaseHelper.getServerEntryForRIPFromServerTbl(avrRipInfo.getRipID(), 0, avrServerInfoArray);
                String string = ((AvrServerInfo)object3).getServerName();
                object2 = AvrDatabaseHelper.createServerInfoConnRules(string, 1, ConnectionPathInfo.VIDEO_CONNECTION_TYPE, n, ((AvrServerInfo)object3).getIndex(), list);
                interfaceInfo.setConnID(object2.getID());
                interfaceInfo.setConnType(1);
                InterfacesDb.modify((InterfaceInfo)interfaceInfo);
                return bl;
            }
            object3 = AvrDatabaseHelper.getInterfaceObjectFromDB(n, avrRipInfo.getRipID());
            n4 = object3.getConnType();
            if (n4 == 0) {
                AvrServerInfo avrServerInfo = AvrDatabaseHelper.getServerEntryForRIPFromServerTbl(avrRipInfo.getRipID(), 0, avrServerInfoArray);
                object2 = avrServerInfo.getServerName();
                object = AvrDatabaseHelper.createServerInfoConnRules((String)object2, 1, ConnectionPathInfo.VIDEO_CONNECTION_TYPE, n, avrServerInfo.getIndex(), list);
                object3.setConnID(object.getID());
                object3.setConnType(1);
                InterfacesDb.modify((InterfaceInfo)object3);
                bl = true;
                return bl;
            }
            if (n4 == 1) {
                AvrServerInfo avrServerInfo = AvrDatabaseHelper.getServerEntryForRIPFromServerTbl(avrRipInfo.getRipID(), 0, avrServerInfoArray);
                object2 = avrServerInfo.getServerName();
                object = AvrDatabaseHelper.getServerName(n, avrRipInfo.getRipID(), 0);
                if (AvrDatabaseHelper.hasServerNameChanged((String)object, (String)object2, avrRipInfo.getRipID(), false)) {
                    if (AVWorksBranding.getBoolean((String)"AvrResyncReplace", (boolean)false)) {
                        ServerInfo serverInfo = ServersDb.getServerInfo((int)ServersDb.getServerId((String)object));
                        if (AvrDatabaseHelper.deleteServer((int)serverInfo.getID())) {
                            list3.add(serverInfo);
                        }
                        ServerInfo serverInfo2 = AvrDatabaseHelper.createServerInfoConnRules((String)object2, 1, ConnectionPathInfo.VIDEO_CONNECTION_TYPE, n, avrServerInfo.getIndex(), list);
                        int n6 = object3.getConnID();
                        object3.setConnID(serverInfo2.getID());
                        object3.setConnType(1);
                        InterfacesDb.modify((InterfaceInfo)object3);
                        ServerPropertiesDb.removeExistingValue((int)n6, (String)"APP_INDEX_1");
                        bl = true;
                    } else {
                        int n7 = object3.getConnID();
                        ServersDb.rename((int)n7, (String)object2);
                        AvrDatabaseHelper.addServerToList(n7, list2);
                        bl = true;
                    }
                } else if (AvrDatabaseHelper.hasServerNameChanged((String)object, (String)object2, avrRipInfo.getRipID(), true)) {
                    int n8 = object3.getConnID();
                    ServersDb.rename((int)n8, (String)object2);
                    AvrDatabaseHelper.addServerToList(n8, list2);
                    bl = true;
                }
                return bl;
            }
            if (n4 == 2) {
                int n9;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                int n10;
                Object object8;
                ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo((int)object3.getConnID());
                object2 = AvrDatabaseHelper.getSwitchForRip(avrRipInfo.getRipID(), avrSwitchInfoArray);
                if (object2 == null) {
                    object3.setConnID(0);
                    object3.setConnType(0);
                    InterfacesDb.modify((InterfaceInfo)object3);
                    bl = true;
                    return bl;
                }
                int n11 = ((AvrSwitchInfo)object2).getSwitchID();
                if (n11 == 0 && AppliancesDb.isNameDefined((String)((AvrSwitchInfo)object2).getSwitchName())) {
                    object8 = "WHERE (AMP=" + Integer.toString(0) + ")" + " AND" + " (NAME=" + SqlCmd.quote((String)((AvrSwitchInfo)object2).getSwitchName()) + ")";
                    ApplianceInfo[] applianceInfoArray = AppliancesDb.getAllAppliances((String)object8);
                    n11 = applianceInfoArray[0].getID();
                }
                if (applianceInfo.getID() != n11) {
                    if (n11 == 0) {
                        n11 = AvrDatabaseHelper.addSwitch(n, avrRipInfo.getRipID(), avrRipInfoArray, (AvrSwitchInfo)object2, avrServerInfoArray, list);
                        object3.setConnID(n11);
                        object3.setConnType(2);
                        InterfacesDb.modify((InterfaceInfo)object3);
                        bl = true;
                        return bl;
                    }
                    object3.setConnID(n11);
                    object3.setConnType(2);
                    InterfacesDb.modify((InterfaceInfo)object3);
                    bl = true;
                }
                if (!(object8 = AppliancesDb.getApplianceInfo((int)n11)).getName().equals(((AvrSwitchInfo)object2).getSwitchName())) {
                    AppliancesDb.rename((int)n11, (String)((AvrSwitchInfo)object2).getSwitchName());
                    bl = true;
                }
                if (object8.getProductID() != ((AvrSwitchInfo)object2).getSwitchType()) {
                    int n12 = AvrDatabaseHelper.getSwitchPortCount(object8.getProductID());
                    int n13 = AvrDatabaseHelper.getSwitchPortCount(((AvrSwitchInfo)object2).getSwitchType());
                    if (n13 < n12) {
                        for (n10 = n13 + 1; n10 <= n12; ++n10) {
                            InterfaceInfo interfaceInfo2;
                            try {
                                interfaceInfo2 = AvrDatabaseHelper.getInterfaceObjectFromDB(object8.getID(), AvrDatabaseHelper.formatChannelName(n10));
                            }
                            catch (ExceptionNoValue exceptionNoValue) {
                                Trace.logInfo((String)"AvrDatabaseHelper:resyncRip", (String)"No interface value");
                                continue;
                            }
                            int n14 = interfaceInfo2.getConnID();
                            object7 = null;
                            try {
                                object7 = ServersDb.getServerInfo((int)n14);
                            }
                            catch (ExceptionNoValue exceptionNoValue) {
                                Trace.logInfo((String)"AvrDatabaseHelper:resyncRip", (String)("No server value " + n14));
                            }
                            catch (ExceptionRequestFailed exceptionRequestFailed) {
                                Trace.logInfo((String)"AvrDatabaseHelper:resyncRip", (String)("No server value " + n14));
                            }
                            if (AvrDatabaseHelper.deleteServer((int)n14)) {
                                bl = true;
                                if (object7 != null) {
                                    list3.add(object7);
                                }
                            }
                            object6 = new int[]{interfaceInfo2.getID()};
                            InterfacesDb.delete((int[])object6);
                            bl = true;
                        }
                    } else if (n13 > n12) {
                        for (n10 = n12 + 1; n10 <= n13; ++n10) {
                            int n15 = InterfacesDb.add((int)object8.getID(), (String)AvrDatabaseHelper.formatChannelName(n10), (int)(avrRipInfo.getInputPort() + 1));
                            object5 = AvrDatabaseHelper.getServerEntryForRIPFromServerTbl(avrRipInfo.getRipID(), n10, avrServerInfoArray);
                            object7 = ((AvrServerInfo)object5).getServerName();
                            object6 = AvrDatabaseHelper.createServerInfoConnRules((String)object7, 1, ConnectionPathInfo.VIDEO_CONNECTION_TYPE, n, ((AvrServerInfo)object5).getIndex(), list);
                            bl = true;
                            object4 = InterfacesDb.getInterfaceInfo((int)n15);
                            object4.setConnID(object6.getID());
                            object4.setConnType(1);
                            InterfacesDb.modify((InterfaceInfo)object4);
                        }
                    }
                    n10 = AvrDatabaseHelper.getSwitchUserCount(object8.getProductID());
                    n9 = AvrDatabaseHelper.getSwitchUserCount(((AvrSwitchInfo)object2).getSwitchType());
                    if (n9 < n10) {
                        AvrDatabaseHelper.disassociateRipsFromSwitchInDB(n, object8.getID(), (AvrSwitchInfo)object2);
                    }
                    object8.setProductID(((AvrSwitchInfo)object2).getSwitchType());
                    object8.setType(((AvrSwitchInfo)object2).getSwitchTypeStr());
                    AppliancesDb.modify((ApplianceInfo)object8);
                    bl = true;
                }
                String string = "WHERE (APPLIANCE_ID=" + Integer.toString(n) + ")" + " AND" + " (CONN_ID=" + Integer.toString(n11) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(2) + ")";
                InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string);
                n10 = AvrDatabaseHelper.getSwitchPortCount(((AvrSwitchInfo)object2).getSwitchType());
                for (n9 = 1; n9 <= n10; ++n9) {
                    object5 = AvrDatabaseHelper.getServerName(n, interfaceInfoArray[0].getName(), n9);
                    object7 = AvrDatabaseHelper.getServerEntryForRIPFromServerTbl(interfaceInfoArray[0].getName(), n9, avrServerInfoArray);
                    object6 = ((AvrServerInfo)object7).getServerName();
                    if (object5 == null) {
                        object4 = AvrDatabaseHelper.getInterfaceObjectFromDB(interfaceInfoArray[0].getConnID(), AvrDatabaseHelper.formatChannelName(n9));
                        ServerInfo serverInfo = AvrDatabaseHelper.createServerInfoConnRules((String)object6, 1, ConnectionPathInfo.VIDEO_CONNECTION_TYPE, n, ((AvrServerInfo)object7).getIndex(), list);
                        object4.setConnID(serverInfo.getID());
                        object4.setConnType(1);
                        InterfacesDb.modify((InterfaceInfo)object4);
                        bl = true;
                        continue;
                    }
                    object4 = NumberFormat.getInstance();
                    ((NumberFormat)object4).setMinimumIntegerDigits(2);
                    if (AvrDatabaseHelper.hasServerNameChanged((String)object5, (String)object6, interfaceInfoArray[0].getName() + ((NumberFormat)object4).format(n9), false)) {
                        if (AVWorksBranding.getBoolean((String)"AvrResyncReplace", (boolean)false)) {
                            ServerInfo serverInfo = ServersDb.getServerInfo((int)ServersDb.getServerId((String)object5));
                            if (AvrDatabaseHelper.deleteServer((int)serverInfo.getID())) {
                                list3.add(serverInfo);
                            }
                            ServerInfo serverInfo3 = AvrDatabaseHelper.createServerInfoConnRules((String)object6, 1, ConnectionPathInfo.VIDEO_CONNECTION_TYPE, n, ((AvrServerInfo)object7).getIndex(), list);
                            int n16 = AvrDatabaseHelper.getInterfaceId(n, interfaceInfoArray[0].getName(), n9);
                            InterfaceInfo interfaceInfo3 = InterfacesDb.getInterfaceInfo((int)n16);
                            interfaceInfo3.setConnID(serverInfo3.getID());
                            interfaceInfo3.setConnType(1);
                            InterfacesDb.modify((InterfaceInfo)interfaceInfo3);
                            bl = true;
                            continue;
                        }
                        int n17 = ServersDb.getServerId((String)object5);
                        ServersDb.rename((int)n17, (String)object6);
                        AvrDatabaseHelper.addServerToList(n17, list2);
                        bl = true;
                        continue;
                    }
                    if (!AvrDatabaseHelper.hasServerNameChanged((String)object5, (String)object6, interfaceInfoArray[0].getName() + ((NumberFormat)object4).format(n9), false)) continue;
                    int n18 = ServersDb.getServerId((String)object5);
                    ServersDb.rename((int)ServersDb.getServerId((String)object5), (String)object6);
                    AvrDatabaseHelper.addServerToList(n18, list2);
                    bl = true;
                }
            }
            return bl;
        }
        catch (Exception exception) {
            Trace.logError((String)"AvrDatabaseHelper:resyncRip", (String)"Error resyncing Rip.", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    private static void disassociateRipsFromSwitchInDB(int n, int n2, AvrSwitchInfo avrSwitchInfo) throws ExceptionRequestFailed {
        try {
            String string = "WHERE (APPLIANCE_ID=" + Integer.toString(n) + ")" + " AND" + " (CONN_ID=" + Integer.toString(n2) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(2) + ")";
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string);
            for (int i = 0; i < interfaceInfoArray.length; ++i) {
                InterfaceInfo interfaceInfo = interfaceInfoArray[i];
                boolean bl = false;
                String[] stringArray = avrSwitchInfo.getAttachedRipIDs();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!interfaceInfo.getName().equals(stringArray[j])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                interfaceInfo.setConnID(0);
                interfaceInfo.setConnType(0);
                InterfacesDb.modify((InterfaceInfo)interfaceInfo);
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"AvrDatabaseHelper:disassociateRipsFromSwitchInDB", (String)"Error disassociating Rips.", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    private static void deleteRip(InterfaceInfo interfaceInfo, List list) throws ExceptionRequestFailed {
        try {
            if (interfaceInfo.getConnType() == 2) {
                AvrDatabaseHelper.deleteAppliance(interfaceInfo.getConnID(), true);
            } else if (interfaceInfo.getConnType() == 1) {
                AvrDatabaseHelper.addServerToList(interfaceInfo.getConnID(), list);
                AvrDatabaseHelper.deleteServer((int)interfaceInfo.getConnID());
            }
            int[] nArray = new int[]{interfaceInfo.getID()};
            InterfacesDb.delete((int[])nArray);
        }
        catch (Exception exception) {
            Trace.logError((String)"AvrDatabaseHelper:deleteRip", (String)"Error deleting Rip.", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    public static boolean isCascadeSwitch(int n) {
        switch (n) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSwitchDetectedButNotAssigned(AvrRipInfo[] avrRipInfoArray, AvrSwitchInfo[] avrSwitchInfoArray, boolean bl) {
        for (int i = 0; i < avrRipInfoArray.length; ++i) {
            AvrSwitchInfo avrSwitchInfo;
            AvrRipInfo avrRipInfo = avrRipInfoArray[i];
            if (avrRipInfo.getRipStatus().equals(res.getString("AvrDatabaseHelper_Offline")) && !bl) {
                Trace.logInfo((String)"AvrDatabaseHelper:isSwitchDetectedButNotAssigned", (String)("RIP " + avrRipInfo.getRipID() + " is Offline and we aren't including Offline Rips."));
                continue;
            }
            if (!avrRipInfo.isSwitchDetected() || (avrSwitchInfo = AvrDatabaseHelper.getSwitchForRip(avrRipInfo.getRipID(), avrSwitchInfoArray)) != null) continue;
            return true;
        }
        return false;
    }

    public static int getSwitchPortCount(int n) throws ExceptionInvalidArgument, ExceptionNoValue {
        if (!AvrDatabaseHelper.isCascadeSwitch(n)) {
            throw new ExceptionInvalidArgument("Requested channel count for no switch type " + n);
        }
        Integer n2 = (Integer)m_htPortCount.get(new Integer(n));
        if (n2 == null) {
            throw new ExceptionNoValue("Missing port count for swtich type " + n);
        }
        return n2;
    }

    public static int getSwitchUserCount(int n) throws ExceptionInvalidArgument, ExceptionNoValue {
        if (!AvrDatabaseHelper.isCascadeSwitch(n)) {
            throw new ExceptionInvalidArgument("Requested channel count for no switch type " + n);
        }
        Integer n2 = (Integer)m_htUserCount.get(new Integer(n));
        if (n2 == null) {
            throw new ExceptionNoValue("Missing user count for swtich type " + n);
        }
        return n2;
    }

    private static ServerInfo createServerInfoConnRules(String string, int n, String string2, int n2, int n3, List list) throws ExceptionRequestFailed {
        ServerInfo serverInfo = DatabaseHelper.createServerInfoConnRules((String)string, (int)n, (String)string2, (int)n2, (int)n3);
        int n4 = serverInfo.getID();
        if (n4 == 0) {
            Trace.logInfo((String)CNAME, (String)"server did not exist, adding to database ...");
            n4 = ServersDb.add((ServerInfo)serverInfo);
            Trace.logInfo((String)CNAME, (String)("... assigned ID " + n4));
            serverInfo.setID(n4);
            Trace.logInfo((String)CNAME, (String)("... adding to list " + list));
            list.add(serverInfo);
        }
        ServerPropertiesDb.setValue((int)n4, (String)("APP_INDEX_" + n), (int)n3);
        return serverInfo;
    }

    private static void addServerToList(int n, List list) {
        try {
            ServerInfo serverInfo = ServersDb.getServerInfo((int)n);
            list.add(serverInfo);
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logError((String)CNAME, (String)exceptionNoValue.getMessage(), (Throwable)exceptionNoValue);
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)CNAME, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
        }
    }

    public static void runCmdLineTool() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        block2: while (true) {
            try {
                while (true) {
                    int n;
                    String string;
                    if ((string = bufferedReader.readLine()).length() <= 0) {
                        continue;
                    }
                    if (string.equalsIgnoreCase("quit")) break block2;
                    int n2 = DatabaseSession.executeQuery((String)string);
                    DBaseRequestQueryResults dBaseRequestQueryResults = DatabaseSession.getQueryResults((int)n2, (int)100);
                    DatabaseSession.closeQuery((int)n2);
                    if (dBaseRequestQueryResults.getRowCount() == 0) continue;
                    Trace.logInfo((String)"AvrDatabaseHelper:runCmdLineTool", (String)"\n");
                    for (n = 0; n < dBaseRequestQueryResults.getColumnCount(); ++n) {
                        Trace.logInfo((String)"AvrDatabaseHelper:runCmdLineTool", (String)(dBaseRequestQueryResults.getColumnLabel(n + 1) + "\t"));
                    }
                    Trace.logInfo((String)"AvrDatabaseHelper:runCmdLineTool", (String)"");
                    while (dBaseRequestQueryResults.nextRow()) {
                        for (n = 0; n < dBaseRequestQueryResults.getColumnCount(); ++n) {
                            Trace.logInfo((String)"AvrDatabaseHelper:runCmdLineTool", (String)(dBaseRequestQueryResults.getString(n + 1) + "\t"));
                        }
                        Trace.logInfo((String)"AvrDatabaseHelper:runCmdLineTool", (String)"");
                    }
                    Trace.logInfo((String)"AvrDatabaseHelper:runCmdLineTool", (String)("  matched " + dBaseRequestQueryResults.getRowCount() + " rows."));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] stringArray) {
        try {
            Trace.startLogging(null);
            AVWorksService.start();
            Trace.logInfo((String)"AvrDatabaseHelper:main", (String)("  InterfacesDb.getCount()=" + InterfacesDb.getCount()));
            String string = "502030010233";
            int[] nArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
            for (int i = 0; i < nArray.length; ++i) {
                Trace.logInfo((String)"AvrDatabaseHelper:main", (String)("  Is valid channel (" + string + "-" + nArray[i] + ") : " + AvrDatabaseHelper.isValidChannel(string, nArray[i])));
                String string2 = AvrDatabaseHelper.getServerName(string, nArray[i]);
                Trace.logInfo((String)"AvrDatabaseHelper:main", (String)("  Server Name (" + string + "-" + nArray[i] + ") : " + string2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        m_htPortCount.put(new Integer(8), new Integer(4));
        m_htPortCount.put(new Integer(9), new Integer(8));
        m_htPortCount.put(new Integer(10), new Integer(16));
        m_htPortCount.put(new Integer(11), new Integer(24));
        m_htPortCount.put(new Integer(12), new Integer(32));
        m_htPortCount.put(new Integer(13), new Integer(4));
        m_htPortCount.put(new Integer(14), new Integer(8));
        m_htPortCount.put(new Integer(15), new Integer(16));
        m_htPortCount.put(new Integer(16), new Integer(24));
        m_htPortCount.put(new Integer(17), new Integer(32));
        m_htPortCount.put(new Integer(18), new Integer(16));
        m_htPortCount.put(new Integer(19), new Integer(6));
        m_htPortCount.put(new Integer(34), new Integer(10));
        m_htUserCount = new Hashtable();
        m_htUserCount.put(new Integer(8), new Integer(1));
        m_htUserCount.put(new Integer(9), new Integer(1));
        m_htUserCount.put(new Integer(10), new Integer(1));
        m_htUserCount.put(new Integer(11), new Integer(1));
        m_htUserCount.put(new Integer(12), new Integer(1));
        m_htUserCount.put(new Integer(13), new Integer(2));
        m_htUserCount.put(new Integer(14), new Integer(2));
        m_htUserCount.put(new Integer(15), new Integer(2));
        m_htUserCount.put(new Integer(16), new Integer(2));
        m_htUserCount.put(new Integer(17), new Integer(2));
        m_htUserCount.put(new Integer(18), new Integer(4));
        m_htUserCount.put(new Integer(19), new Integer(1));
        m_htUserCount.put(new Integer(34), new Integer(1));
    }
}

