/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AmpControllerAvr;
import com.avocent.avworks.nmm.avr.AvrAddApplianceWizard;
import com.avocent.avworks.nmm.avr.AvrAidpHelper;
import com.avocent.avworks.nmm.avr.AvrAsmpHelper;
import com.avocent.avworks.nmm.avr.AvrDatabaseHelper;
import com.avocent.avworks.nmm.avr.AvrServerInfo;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.avr.AvrViewerCmdLinePathInfo;
import com.avocent.avworks.nmm.common.AbstractNmmInterface;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.AsmpConnection;
import com.avocent.avworks.nmm.common.DiscoverInfo;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.AVWorksWindow;
import com.avocent.avworks.services.AVWorksWindowManager;
import com.avocent.avworks.services.ActionItem;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.AppliancePropertiesDb;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.ConnectionPath;
import com.avocent.avworks.services.ConnectionPathInfo;
import com.avocent.avworks.services.InterfaceInfo;
import com.avocent.avworks.services.InterfacesDb;
import com.avocent.avworks.services.ProductInfo;
import com.avocent.avworks.services.Products;
import com.avocent.avworks.services.ProductsDb;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.ServersDb;
import com.avocent.avworks.services.Unit;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionNotSupported;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.LaunchBrowserHelp;
import com.avocent.lib.gui.dialogs.JDialogElapsedTime;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.net.MacAddress;
import com.avocent.lib.util.CachedCredentials;
import com.avocent.lib.util.ResourceManager;
import com.avocent.protocols.aidp.AidpDiscoverInfo;
import com.avocent.protocols.aidp.AidpSession;
import com.avocent.protocols.snmp.Mib;
import com.avocent.protocols.snmp.SnmpRequest;
import com.avocent.protocols.snmp.VarBind;
import com.avocent.protocols.snmp.VarBindList;
import com.avocent.video.videoViewer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class AvrNmmInterface
extends AbstractNmmInterface {
    public static final String CNAME = "AvrNmmInterface";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    public static final int AVR_ACTION_ID_BASE = 1000;
    public static final int CONNECT_VIDEO_ACTION = 1001;
    public static final int SCAN_VIDEO_ACTION = 1002;
    private static final int ENCRYPTION_LEVEL_ENABLED = 2;
    private static final int ENCRYPTION_LEVEL_DES_INDEX = 1;
    private static final int ENCRYPTION_LEVEL_3DES_INDEX = 2;
    private static final int ENCRYPTION_LEVEL_128_INDEX = 3;
    private static final int APPLIANCE_READY = 1;
    private static final String CANCELED_REQUEST = "USER CANCELED REQUEST";
    int m_nCount = 1;
    private static final int MAX_VIDEO_THUMBNAILS = 16;
    private static final int APPLIANCE_ERROR = -1;
    private static final int APPLIANCE_REBOOTING = 2;
    private static final int APPLIANCE_UPGRADING = 3;
    private static final int APPLIANCE_KEYBOARD_MOUSE_ERROR = 4;
    private static final int APPLIANCE_VIDEO_ERROR = 5;
    private static final int APPLIANCE_FIRMWARE_UPGRADE_REJECT_ERROR = 6;
    protected static Hashtable m_htLaunchInProgress = new Hashtable();
    static int m_nScanSessionCntr = 0;

    public AvrNmmInterface(int n, Frame frame) {
        super(n, frame);
    }

    public void initialize() throws ExceptionRequestFailed {
    }

    public boolean newApplianceWizard(int n) throws ExceptionNotSupported, ExceptionRequestFailed {
        return AvrAddApplianceWizard.showWizard(this.m_frameParent, n);
    }

    public ApplianceInfo discover(IpAddress ipAddress, String string) throws ExceptionNoValue, ExceptionNotSupported {
        try {
            return this.discoverViaAsmp(ipAddress);
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)("Could not discover " + ipAddress + " via asmp -- trying aidp"), (Throwable)exception);
            return this.discoverViaAidp(ipAddress, string);
        }
    }

    private ApplianceInfo discoverViaAsmp(IpAddress ipAddress) throws ExceptionRequestFailed, UnknownHostException, ExceptionNoValue {
        InetAddress inetAddress = InetAddress.getByAddress(ipAddress.getBytes());
        return this.makeApplianceInfo(AvrAsmpHelper.discover(inetAddress));
    }

    private ApplianceInfo discoverViaAidp(IpAddress ipAddress, String string) throws ExceptionNoValue, ExceptionNotSupported {
        try {
            InetAddress inetAddress = InetAddress.getByName(ipAddress.getString());
            AidpSession aidpSession = new AidpSession(inetAddress);
            Trace.logInfo((String)"AvrNmmInterface:discover", (String)("Discovering IP Address = " + ipAddress.getString()));
            AidpDiscoverInfo[] aidpDiscoverInfoArray = aidpSession.discover();
            Trace.logInfo((String)"AvrNmmInterface:discover", (String)("Discover completed " + aidpDiscoverInfoArray.length + " unit(s) found"));
            if (aidpDiscoverInfoArray.length != 1) {
                Trace.logError((String)"AvrNmmInterface:discover", (String)("Didn't find a single appliance.  Found = " + aidpDiscoverInfoArray.length));
                throw new ExceptionNoValue();
            }
            DiscoverInfo discoverInfo = new DiscoverInfo(aidpDiscoverInfoArray[0], this.getSysName(aidpSession));
            return this.makeApplianceInfo(discoverInfo);
        }
        catch (Exception exception) {
            Trace.logError((String)"AvrNmmInterface:discover", (String)"Error discovering appliance", (Throwable)exception);
            throw new ExceptionNoValue();
        }
    }

    private ApplianceInfo makeApplianceInfo(DiscoverInfo discoverInfo) throws ExceptionNoValue, ExceptionRequestFailed {
        MacAddress macAddress;
        int n = discoverInfo.getProductID();
        if (this.isProductTypeIgnored(String.valueOf(n))) {
            Trace.logInfo((String)"AvrNmmInterface:discover", (String)("Product Type to be ignored, not discovered [" + n + "]"));
            throw new ExceptionNoValue();
        }
        ProductInfo productInfo = ProductsDb.getProductInfo((int)n);
        if (productInfo.getNmmID() != 1) {
            Trace.logError((String)"avrNmmInterface:discover", (String)("Product ID " + n + " not supported by AVR NMM."));
            throw new ExceptionNoValue();
        }
        if (!productInfo.isAddAllowed()) {
            Trace.logError((String)"avrNmmInterface:discover", (String)("Product Type " + n + " does not support ADD."));
            throw new ExceptionNoValue();
        }
        if (!productInfo.isEnabled()) {
            Trace.logError((String)"avrNmmInterface:discover", (String)("Product Type " + n + " is not enabled."));
            throw new ExceptionNoValue();
        }
        String string = discoverInfo.getName();
        Trace.logInfo((String)CNAME, (String)("Name=" + string));
        if (string.length() == 0) {
            Trace.logInfo((String)"AvrNmmInterface:discover", (String)"SysName was blank");
            macAddress = discoverInfo.getMacAddress();
            String string2 = macAddress.getString().substring(9);
            Trace.logInfo((String)"AvrNmmInterface:discover", (String)("Type=" + productInfo.getName() + " MAC=" + string2));
            string = productInfo.getName() + " " + string2;
            Trace.logInfo((String)"AvrNmmInterface:discover", (String)("Default SysName=" + string));
        }
        string = Unit.getUniqueName((String)string);
        Trace.logInfo((String)CNAME, (String)("Unique Name=" + string));
        macAddress = new ApplianceInfo(0, string, productInfo.getName(), n, "", discoverInfo.getIpAddress().getString(), "", "", productInfo.getNmmID(), true);
        return macAddress;
    }

    private String getSysName(AidpSession aidpSession) throws ExceptionRequestFailed {
        try {
            VarBind varBind = new VarBind("mib-2.system.sysName.0");
            if (aidpSession.snmpGet(varBind)) {
                Trace.logInfo((String)"AvrNmmInterface:getSysName", (String)("sysName.0 = " + varBind.getStringValue()));
                return varBind.getStringValue();
            }
            Trace.logError((String)"AvrNmmInterface:getSysName", (String)"Unable to get sysName.0");
            throw new ExceptionRequestFailed();
        }
        catch (Exception exception) {
            throw new ExceptionRequestFailed();
        }
    }

    public void addAppliance(ApplianceInfo applianceInfo) throws ExceptionNotSupported, ExceptionRequestFailed {
        if (this.isProductTypeIgnored(String.valueOf(applianceInfo.getProductID()))) {
            Trace.logInfo((String)"AvrNmmInterface:addAppliance", (String)("Product Type to be ignored, not added [" + applianceInfo.getType() + "]"));
            throw new ExceptionRequestFailed();
        }
        AvrDatabaseHelper.resyncAppliance(applianceInfo, null, null, null);
    }

    private AvrServerInfo[] getServerInfo(ApplianceInfo applianceInfo) throws ExceptionRequestFailed {
        try {
            Object[] objectArray;
            Vector<AvrServerInfo> vector;
            block5: {
                int n;
                SnmpRequest snmpRequest;
                block4: {
                    VarBindList varBindList;
                    InetAddress inetAddress = InetAddress.getByName(applianceInfo.getAddress());
                    AidpSession aidpSession = new AidpSession(inetAddress);
                    vector = new Vector<AvrServerInfo>();
                    String string = "avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableIndex.0";
                    String string2 = "avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableRipId.0";
                    String string3 = "avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableSwitchChannel.0";
                    String string4 = "avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableServerName.0";
                    String string5 = "avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableIndex";
                    while (true) {
                        objectArray = new VarBind(string);
                        VarBind varBind = new VarBind(string2);
                        VarBind varBind2 = new VarBind(string3);
                        VarBind varBind3 = new VarBind(string4);
                        VarBindList varBindList2 = new VarBindList();
                        varBindList2.addVarBind((VarBind)objectArray);
                        varBindList2.addVarBind(varBind);
                        varBindList2.addVarBind(varBind2);
                        varBindList2.addVarBind(varBind3);
                        snmpRequest = new SnmpRequest(varBindList2, null, "", 161, 0, 0);
                        n = aidpSession.snmpRequest(snmpRequest);
                        if (n != 0 || snmpRequest.getErrorStatus() != 0) break block4;
                        varBindList = snmpRequest.getVarBindList();
                        if (varBindList.size() != 4) break;
                        VarBind varBind4 = varBindList.varbindAt(0);
                        string = varBind4.getName();
                        String string6 = varBind4.getStringValue();
                        Trace.logInfo((String)"avrNmmInterface:getServerInfo", (String)("Table Index Name = " + string + " Value = " + string6));
                        VarBind varBind5 = varBindList.varbindAt(1);
                        string2 = varBind5.getName();
                        String string7 = varBind5.getStringValue();
                        Trace.logInfo((String)"avrNmmInterface:getServerInfo", (String)("RIP ID Name = " + string2 + " Value = " + string7));
                        VarBind varBind6 = varBindList.varbindAt(2);
                        string3 = varBind6.getName();
                        String string8 = varBind6.getStringValue();
                        Trace.logInfo((String)"avrNmmInterface:getServerInfo", (String)("Switch Connected = " + string3 + " Value = " + string8));
                        VarBind varBind7 = varBindList.varbindAt(3);
                        string4 = varBind7.getName();
                        String string9 = varBind7.getStringValue();
                        Trace.logInfo((String)"avrNmmInterface:getServerInfo", (String)("Server Name = " + string4 + " Value = " + string9));
                        if (string.startsWith(string5)) {
                            AvrServerInfo avrServerInfo = new AvrServerInfo(Integer.parseInt(string6), string7, string9, Boolean.getBoolean(string8));
                            vector.add(avrServerInfo);
                            varBindList2.removeVarBinds();
                            continue;
                        }
                        break block5;
                        break;
                    }
                    Trace.logError((String)"avrNmmInterface:getServerInfo", (String)("<INVALID NUMBER OF BINDINGS RETURNED> Number: " + Integer.toHexString(varBindList.size())));
                    throw new ExceptionRequestFailed();
                }
                Trace.logInfo((String)"avrNmmInterface:getServerInfo", (String)("Error requesting Server Info.AIDP Error = " + n + "SNMP Error = " + snmpRequest.getErrorStatusMessage()));
                throw new ExceptionRequestFailed();
            }
            objectArray = new AvrServerInfo[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            Trace.logError((String)"AvrNmmInterface:getServerInfo", (String)"Error occured retrieving server information.", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    public void deleteAppliance(int n, boolean bl) throws ExceptionNotSupported, ExceptionNoValue, ExceptionRequestFailed {
        AvrDatabaseHelper.deleteAppliance(n, bl);
    }

    private int getNumConnectedTo(int n, int n2) throws ExceptionRequestFailed {
        try {
            String string = "WHERE (CONN_ID=" + Integer.toString(n) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(n2) + ");";
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string);
            return interfaceInfoArray.length;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logInfo((String)"avrNmmInterface:getNumConnectedTo", (String)"Unable to get interface info.  No Value was available.");
            return 0;
        }
        catch (Exception exception) {
            Trace.logError((String)"avrNmmInterface:getNumConnectedTo", (String)"Unable to get interface info.  Request Failed.");
            throw new ExceptionRequestFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processAmp(int n) throws ExceptionNotSupported, ExceptionRequestFailed {
        ThreadApplianceAvailable threadApplianceAvailable = null;
        ApplianceInfo applianceInfo = null;
        String string = "appliance_" + n;
        boolean bl = false;
        try {
            try {
                Object object;
                block25: {
                    block26: {
                        Object v;
                        block24: {
                            object = m_htLaunchInProgress;
                            // MONITORENTER : object
                            v = m_htLaunchInProgress.get(string);
                            if (v != null) break block24;
                            try {
                                applianceInfo = AppliancesDb.getApplianceInfo((int)n);
                            }
                            catch (Exception exception) {
                                throw new Exception();
                            }
                            threadApplianceAvailable = new ThreadApplianceAvailable(string, applianceInfo.getName());
                            m_htLaunchInProgress.put(string, threadApplianceAvailable);
                            threadApplianceAvailable.start();
                            // MONITOREXIT : object
                            if (AvrNmmInterface.checkApplianceAvailability(applianceInfo.getAddress(), threadApplianceAvailable, this.m_frameParent)) break block25;
                            break block26;
                        }
                        Trace.logInfo((String)"AVR NMM Interface", (String)"Found launch in progress,  bring existing progress dialog to the front.");
                        bl = true;
                        threadApplianceAvailable = (ThreadApplianceAvailable)v;
                        JDialogElapsedTime jDialogElapsedTime = threadApplianceAvailable.getProgressDialog();
                        if (jDialogElapsedTime != null) {
                            jDialogElapsedTime.toFront();
                        }
                        // MONITOREXIT : object
                        Object var11_17 = null;
                        if (bl) return;
                        Hashtable hashtable = m_htLaunchInProgress;
                        // MONITORENTER : hashtable
                        threadApplianceAvailable.stopThreadAndCloseProgress();
                        m_htLaunchInProgress.remove(string);
                        // MONITOREXIT : hashtable
                        return;
                    }
                    threadApplianceAvailable.stopThreadAndCloseProgress();
                    Object var11_18 = null;
                    if (bl) return;
                    Hashtable hashtable = m_htLaunchInProgress;
                    // MONITORENTER : hashtable
                    threadApplianceAvailable.stopThreadAndCloseProgress();
                    m_htLaunchInProgress.remove(string);
                    // MONITOREXIT : hashtable
                    return;
                }
                this.m_frameParent.setCursor(Cursor.getPredefinedCursor(0));
                if (threadApplianceAvailable.wasCanceled()) {
                    threadApplianceAvailable.stopThreadAndCloseProgress();
                    throw new Exception(CANCELED_REQUEST);
                }
                threadApplianceAvailable.stopThread();
                object = new AmpControllerAvr(this, n, this.m_frameParent, threadApplianceAvailable.getProgressDialog());
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                if (threadApplianceAvailable != null) {
                    threadApplianceAvailable.stopThreadAndCloseProgress();
                }
                String string2 = res.getString("AvrNmmInterface_Appliance_not_available");
                Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true), exceptionRequestFailed.getMessage()};
                string2 = MessageFormat.format(string2, objectArray);
                Message.show((Component)this.m_frameParent, (String)string2);
                Object var11_20 = null;
                if (bl) return;
                Hashtable hashtable = m_htLaunchInProgress;
                // MONITORENTER : hashtable
                threadApplianceAvailable.stopThreadAndCloseProgress();
                m_htLaunchInProgress.remove(string);
                // MONITOREXIT : hashtable
                return;
            }
            catch (ExceptionConstructorFailed exceptionConstructorFailed) {
                Trace.logError((String)"avrNmmInterface:processAmp", (String)"Unable to show Amp. Constructor Failed.", (Throwable)exceptionConstructorFailed);
                throw new ExceptionRequestFailed();
            }
            catch (Exception exception) {
                if (threadApplianceAvailable != null) {
                    threadApplianceAvailable.stopThreadAndCloseProgress();
                }
                if (!exception.getMessage().equals(CANCELED_REQUEST)) {
                    String string3 = res.getString("AvrNmmInterface_Appliance_not_available");
                    Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true), res.getString("AvrNmmInterface_Unknown_error")};
                    string3 = MessageFormat.format(string3, objectArray);
                    Message.show((Component)this.m_frameParent, (String)string3);
                } else {
                    Trace.logInfo((String)"avrNmmInterface:processAmp", (String)exception.getMessage());
                }
                Object var11_21 = null;
                if (bl) return;
                Hashtable hashtable = m_htLaunchInProgress;
                // MONITORENTER : hashtable
                threadApplianceAvailable.stopThreadAndCloseProgress();
                m_htLaunchInProgress.remove(string);
                // MONITOREXIT : hashtable
                return;
            }
            Object var11_19 = null;
            if (bl) return;
            Hashtable hashtable = m_htLaunchInProgress;
            // MONITORENTER : hashtable
            threadApplianceAvailable.stopThreadAndCloseProgress();
            m_htLaunchInProgress.remove(string);
            // MONITOREXIT : hashtable
            return;
        }
        catch (Throwable throwable) {
            Object var11_22 = null;
            if (bl) throw throwable;
            Hashtable hashtable = m_htLaunchInProgress;
            // MONITORENTER : hashtable
            threadApplianceAvailable.stopThreadAndCloseProgress();
            m_htLaunchInProgress.remove(string);
            // MONITOREXIT : hashtable
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processConnectVideo(int n) throws ExceptionRequestFailed {
        ThreadApplianceAvailable threadApplianceAvailable = null;
        Object var3_3 = null;
        String string = "server_" + n;
        boolean bl = false;
        try {
            try {
                Object object;
                Object object2;
                Object object3;
                AvrViewerCmdLinePathInfo[] avrViewerCmdLinePathInfoArray;
                block28: {
                    block29: {
                        block27: {
                            avrViewerCmdLinePathInfoArray = m_htLaunchInProgress;
                            // MONITORENTER : m_htLaunchInProgress
                            object3 = m_htLaunchInProgress.get(string);
                            if (object3 != null) break block27;
                            object2 = null;
                            try {
                                object2 = ServersDb.getServerInfo((int)n);
                            }
                            catch (Exception exception) {
                                throw new Exception();
                            }
                            threadApplianceAvailable = new ThreadApplianceAvailable(string, object2.getName());
                            m_htLaunchInProgress.put(string, threadApplianceAvailable);
                            threadApplianceAvailable.start();
                            Thread.currentThread();
                            Thread.yield();
                            // MONITOREXIT : avrViewerCmdLinePathInfoArray
                            avrViewerCmdLinePathInfoArray = this.getCmdLinePathInfo(n);
                            object3 = "";
                            if (avrViewerCmdLinePathInfoArray == null) break block28;
                            break block29;
                        }
                        bl = true;
                        threadApplianceAvailable = (ThreadApplianceAvailable)object3;
                        JDialogElapsedTime jDialogElapsedTime = threadApplianceAvailable.getProgressDialog();
                        if (jDialogElapsedTime != null) {
                            jDialogElapsedTime.toFront();
                        }
                        // MONITOREXIT : avrViewerCmdLinePathInfoArray
                        Object var23_19 = null;
                        if (bl) return;
                        Hashtable hashtable = m_htLaunchInProgress;
                        // MONITORENTER : hashtable
                        m_htLaunchInProgress.remove(string);
                        // MONITOREXIT : hashtable
                        return;
                    }
                    if (avrViewerCmdLinePathInfoArray.length > 0) {
                        object3 = avrViewerCmdLinePathInfoArray[0].getIpAddress();
                    }
                }
                if (!AvrNmmInterface.checkApplianceVideoAvailability(object3, threadApplianceAvailable, this.m_frameParent)) {
                    threadApplianceAvailable.stopThreadAndCloseProgress();
                    Object var23_20 = null;
                    if (bl) return;
                    Hashtable hashtable = m_htLaunchInProgress;
                    // MONITORENTER : hashtable
                    m_htLaunchInProgress.remove(string);
                    // MONITOREXIT : hashtable
                    return;
                }
                object2 = "conn=AVSP-SSL";
                for (int i = 0; i < avrViewerCmdLinePathInfoArray.length; ++i) {
                    int n2 = this.getLoginTimeout(avrViewerCmdLinePathInfoArray[i].getApplianceID(), false);
                    avrViewerCmdLinePathInfoArray[i].setLoginTimeout(n2);
                }
                String[] stringArray = this.createPathArguments(avrViewerCmdLinePathInfoArray);
                if (stringArray == null) {
                    throw new ExceptionRequestFailed();
                }
                ServerInfo serverInfo = ServersDb.getServerInfo((int)n);
                String string2 = AVWorksBranding.getString((String)"vsvProductName", (String)res.getString("AvrNmmInterface_Video_Session_Viewer"));
                String string3 = "title=\"" + serverInfo.getName() + " - " + string2 + "\"";
                String string4 = "user=" + CachedCredentials.getUsername();
                String string5 = "password=" + CachedCredentials.getPassword();
                String string6 = "application_name=avworks";
                String string7 = "ifaceviewer3=com.avocent.avworks.services.InterfaceViewerAVWorks";
                String string8 = null;
                File file = new File(".");
                if (file != null && file.exists()) {
                    object = LaunchBrowserHelp.pageToURLStr((String)file.getAbsolutePath());
                    object = ((String)object).replaceAll("\"", "");
                    string8 = "helpurl=" + (String)object;
                }
                object = new Vector<String>();
                ((Vector)object).add(string3);
                ((Vector)object).add(string4);
                ((Vector)object).add(string5);
                ((Vector)object).add(string7);
                ((Vector)object).add(object2);
                if (string8 != null) {
                    ((Vector)object).add(string8);
                }
                ((Vector)object).add(string6);
                for (int i = 0; i < stringArray.length; ++i) {
                    ((Vector)object).add(stringArray[i]);
                }
                Object[] objectArray = new String[((Vector)object).size()];
                ((Vector)object).copyInto(objectArray);
                threadApplianceAvailable.stopThreadAndCloseProgress();
                this.m_frameParent.setCursor(Cursor.getPredefinedCursor(0));
                Thread thread = new Thread(new Runnable((String[])objectArray){
                    private final /* synthetic */ String[] val$aszCmdLine;
                    {
                        this.val$aszCmdLine = stringArray;
                    }

                    public void run() {
                        videoViewer.launch((String[])this.val$aszCmdLine, (Frame)AvrNmmInterface.this.m_frameParent);
                    }
                });
                thread.start();
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                if (threadApplianceAvailable != null) {
                    threadApplianceAvailable.stopThreadAndCloseProgress();
                }
                String string9 = res.getString("AvrNmmInterface_Appliance_not_available");
                Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true), exceptionRequestFailed.getMessage()};
                string9 = MessageFormat.format(string9, objectArray);
                Message.show((Component)this.m_frameParent, (String)string9);
                Object var23_22 = null;
                if (bl) return;
                Hashtable hashtable = m_htLaunchInProgress;
                // MONITORENTER : hashtable
                m_htLaunchInProgress.remove(string);
                // MONITOREXIT : hashtable
                return;
            }
            catch (Exception exception) {
                if (threadApplianceAvailable != null) {
                    threadApplianceAvailable.stopThreadAndCloseProgress();
                }
                String string10 = res.getString("AvrNmmInterface_Appliance_not_available");
                Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true), res.getString("AvrNmmInterface_Unknown_error")};
                string10 = MessageFormat.format(string10, objectArray);
                Message.show((Component)this.m_frameParent, (String)string10);
                Object var23_23 = null;
                if (bl) return;
                Hashtable hashtable = m_htLaunchInProgress;
                // MONITORENTER : hashtable
                m_htLaunchInProgress.remove(string);
                // MONITOREXIT : hashtable
                return;
            }
            Object var23_21 = null;
            if (bl) return;
            Hashtable hashtable = m_htLaunchInProgress;
            // MONITORENTER : hashtable
            m_htLaunchInProgress.remove(string);
            // MONITOREXIT : hashtable
            return;
        }
        catch (Throwable throwable) {
            Object var23_24 = null;
            if (bl) throw throwable;
            Hashtable hashtable = m_htLaunchInProgress;
            // MONITORENTER : hashtable
            m_htLaunchInProgress.remove(string);
            // MONITOREXIT : hashtable
            throw throwable;
        }
    }

    public int getLoginTimeout(int n, boolean bl) {
        int n2 = 30;
        try {
            int n3;
            ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo((int)n);
            n2 = AppliancePropertiesDb.getIntegerValue((int)n, (String)"LOGIN_TIMEOUT", (int)30);
            if (!bl && n2 != (n3 = this.getAnoymousLoginTimeout(applianceInfo.getAddress()))) {
                AppliancePropertiesDb.setValue((int)n, (String)"LOGIN_TIMEOUT", (int)n3);
                n2 = n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    private void scanVideo(int[] nArray) throws ExceptionRequestFailed {
        try {
            Object object;
            this.m_frameParent.setCursor(Cursor.getPredefinedCursor(3));
            AvrViewerCmdLinePathInfo[] avrViewerCmdLinePathInfoArray = this.getCmdLinePathInfo(nArray[0]);
            String string = "";
            if (avrViewerCmdLinePathInfoArray != null && avrViewerCmdLinePathInfoArray.length > 0) {
                string = avrViewerCmdLinePathInfoArray[0].getIpAddress();
            }
            String string2 = "conn=AVSP-SSL";
            String string3 = "mode=scan";
            ServerInfo serverInfo = ServersDb.getServerInfo((int)nArray[0]);
            Object[] objectArray = new Object[]{AVWorksBranding.getString((String)"vsvProductName", (String)res.getString("AvrNmmInterface_Video_Session_Viewer"))};
            AVWorksWindow[] aVWorksWindowArray = AVWorksWindowManager.getRegisteredWindows((boolean)true);
            int n = aVWorksWindowArray.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (aVWorksWindowArray[i].getWindowType() != 8) continue;
                ++n2;
            }
            if (n2 == 0) {
                this.m_nCount = 1;
            }
            String string4 = "application_name=avworks";
            String string5 = "title=\"" + res.getString("AvrNmmInterface_SCANVIEW_TITLE") + " " + this.m_nCount++ + "\"";
            String string6 = "user=" + CachedCredentials.getUsername();
            String string7 = "password=" + CachedCredentials.getPassword();
            String string8 = "ifaceviewer3=com.avocent.avworks.services.InterfaceViewerAVWorks";
            Vector<Object> vector = new Vector<Object>();
            vector.add(string3);
            vector.add(string5);
            vector.add(string6);
            vector.add(string7);
            vector.add(string8);
            vector.add(string2);
            vector.add(string4);
            for (int i = 0; i < nArray.length; ++i) {
                int n3;
                avrViewerCmdLinePathInfoArray = this.getCmdLinePathInfo(nArray[i]);
                for (int j = 0; j < avrViewerCmdLinePathInfoArray.length; ++j) {
                    n3 = this.getLoginTimeout(avrViewerCmdLinePathInfoArray[j].getApplianceID(), true);
                    avrViewerCmdLinePathInfoArray[j].setLoginTimeout(n3);
                }
                object = this.createPathArguments(avrViewerCmdLinePathInfoArray);
                if (object == null) {
                    throw new ExceptionRequestFailed();
                }
                for (n3 = 0; n3 < ((Object)object).length; ++n3) {
                    vector.add(object[n3]);
                }
            }
            Object[] objectArray2 = new String[vector.size()];
            vector.copyInto(objectArray2);
            object = new Thread(new Runnable((String[])objectArray2){
                private final /* synthetic */ String[] val$aszCmdLine;
                {
                    this.val$aszCmdLine = stringArray;
                }

                public void run() {
                    videoViewer.launch((String[])this.val$aszCmdLine, (Frame)AvrNmmInterface.this.m_frameParent);
                }
            });
            ((Thread)object).start();
            this.m_frameParent.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            String string = res.getString("AvrNmmInterface_Appliance_not_available");
            Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true), exceptionRequestFailed.getMessage()};
            string = MessageFormat.format(string, objectArray);
            Message.show((Component)this.m_frameParent, (String)string);
            return;
        }
        catch (Exception exception) {
            String string = res.getString("AvrNmmInterface_Appliance_not_available");
            Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true), res.getString("AvrNmmInterface_Unknown_error")};
            string = MessageFormat.format(string, objectArray);
            Message.show((Component)this.m_frameParent, (String)string);
            return;
        }
    }

    private AvrViewerCmdLinePathInfo[] getCmdLinePathInfo(int n) throws ExceptionRequestFailed {
        Vector<Object> vector = new Vector<Object>();
        boolean bl = false;
        try {
            ServerInfo serverInfo = ServersDb.getServerInfo((int)n);
            UnitInfo.CredPolicy credPolicy = serverInfo.getPolicy();
            String string = "WHERE (CONN_ID=" + Integer.toString(n) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(1) + ")";
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string);
            for (int i = 0; i < interfaceInfoArray.length; ++i) {
                Object object;
                InterfaceInfo interfaceInfo = interfaceInfoArray[i];
                int n2 = interfaceInfo.getApplianceID();
                ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo((int)n2);
                if (applianceInfo.getNmmID() != 1) continue;
                if (applianceInfo.isAmpSupported()) {
                    if (credPolicy.getCacheMode() == 1) {
                        credPolicy = applianceInfo.getPolicy();
                    }
                    object = new AvrViewerCmdLinePathInfo(n2, applianceInfo.getAddress(), "", interfaceInfo.getName(), "", n, serverInfo.getName(), credPolicy.getUseCache(), AvrNmmInterface.hasApcp(applianceInfo.getProductID()));
                    vector.add(object);
                    continue;
                }
                object = this.getCmdLinePathInfoForAppliance(n2);
                if (object == null) continue;
                for (int j = 0; j < ((AvrViewerCmdLinePathInfo[])object).length; ++j) {
                    AvrViewerCmdLinePathInfo avrViewerCmdLinePathInfo = object[j];
                    avrViewerCmdLinePathInfo.setChannel(interfaceInfo.getName());
                    avrViewerCmdLinePathInfo.setDeviceID(n);
                    avrViewerCmdLinePathInfo.setServerName(serverInfo.getName());
                    vector.add(avrViewerCmdLinePathInfo);
                }
            }
            if (vector.size() == 0) {
                Trace.logError((String)"avrNmmInterface:getCmdLinePathInfo", (String)"No paths found.");
                throw new ExceptionRequestFailed(res.getString("AvrNmmInterface_Unknown_error"));
            }
            Object[] objectArray = new AvrViewerCmdLinePathInfo[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            Trace.logError((String)"avrNmmInterface:getCmdLinePathInfo", (String)("Unable to get command line path info. Reason: " + exception.getMessage()));
            throw new ExceptionRequestFailed(res.getString("AvrNmmInterface_Unknown_error"));
        }
    }

    private AvrViewerCmdLinePathInfo[] getCmdLinePathInfoForAppliance(int n) throws ExceptionRequestFailed {
        Vector<AvrViewerCmdLinePathInfo> vector = new Vector<AvrViewerCmdLinePathInfo>();
        try {
            String string = "WHERE (CONN_ID=" + Integer.toString(n) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(2) + ")";
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string);
            for (int i = 0; i < interfaceInfoArray.length; ++i) {
                InterfaceInfo interfaceInfo = interfaceInfoArray[i];
                int n2 = interfaceInfo.getApplianceID();
                ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo((int)n2);
                if (applianceInfo.getNmmID() != 1 || !applianceInfo.isAmpSupported()) continue;
                AvrViewerCmdLinePathInfo avrViewerCmdLinePathInfo = new AvrViewerCmdLinePathInfo(n2, applianceInfo.getAddress(), "", interfaceInfo.getName(), "", 0, "", false, AvrNmmInterface.hasApcp(applianceInfo.getProductID()));
                vector.add(avrViewerCmdLinePathInfo);
            }
            Object[] objectArray = new AvrViewerCmdLinePathInfo[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            Trace.logError((String)"avrNmmInterface:getCmdLinePathInfoForAppliance", (String)("Unable to get path info. Reason: " + exception.getMessage()));
            throw new ExceptionRequestFailed();
        }
    }

    private String[] createPathArguments(AvrViewerCmdLinePathInfo[] avrViewerCmdLinePathInfoArray) throws ExceptionRequestFailed {
        if (avrViewerCmdLinePathInfoArray == null) {
            Trace.logError((String)"avrNmmInterface:createPathArguments", (String)"Invalid object passed in.");
            throw new ExceptionRequestFailed();
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < avrViewerCmdLinePathInfoArray.length; ++i) {
            AvrViewerCmdLinePathInfo avrViewerCmdLinePathInfo = avrViewerCmdLinePathInfoArray[i];
            String string = avrViewerCmdLinePathInfo.createPathArgument();
            vector.add(string);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private boolean isEncryptionEnabled(String string) throws ExceptionRequestFailed {
        try {
            Object[] objectArray;
            InetAddress inetAddress = InetAddress.getByName(string);
            AidpSession aidpSession = null;
            AsmpConnection asmpConnection = new AsmpConnection();
            try {
                asmpConnection.openAnonymousConnection(inetAddress);
            }
            catch (IOException iOException) {
                Trace.logError((String)"AvrNmmInterface:isEncryptionEnabled", (String)"Unable To Get AsmpConnectin IOException");
                asmpConnection.closeAsmpSession();
                asmpConnection = null;
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"AvrNmmInterface:isEncryptionEnabled", (String)"Unable To Get AsmpConnectin Request failed.");
                asmpConnection.closeAsmpSession();
                asmpConnection = null;
            }
            if (asmpConnection == null) {
                aidpSession = new AidpSession(inetAddress);
            }
            if (asmpConnection != null) {
                objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl.1", "avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl.2", "avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl.3"};
                InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(asmpConnection, objectArray);
                asmpConnection.closeAsmpSession();
                boolean bl = interfaceValueObjectArray[0].getInteger() == 2 || interfaceValueObjectArray[1].getInteger() == 2 || interfaceValueObjectArray[2].getInteger() == 2;
                return bl;
            }
            objectArray = new VarBind[]{new VarBind("avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl.1"), new VarBind("avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl.2"), new VarBind("avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl.3")};
            if (aidpSession != null && aidpSession.snmpGet((VarBind[])objectArray)) {
                Trace.logInfo((String)"AvrNmmInterface:isEncryptionEnabled", (String)"Successfully retrieved Encryption Level.");
                return objectArray[0].getIntegerValue() == 2 || objectArray[1].getIntegerValue() == 2 || objectArray[2].getIntegerValue() == 2;
            }
            Trace.logError((String)"AvrNmmInterface:isEncryptionEnabled", (String)"Unable to get Encryption Level.");
            Object[] objectArray2 = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
            String string2 = res.getString("AvrNmmInterface_ASMP_Request_timed_out_");
            string2 = MessageFormat.format(string2, objectArray2);
            throw new ExceptionRequestFailed(string2);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
            String string3 = res.getString("AvrNmmInterface_ASMP_Request_timed_out_");
            string3 = MessageFormat.format(string3, objectArray);
            throw new ExceptionRequestFailed(string3);
        }
    }

    public int[] getAnonymousMibVersion(String string) throws ExceptionRequestFailed {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            Object var3_4 = null;
            int[] nArray = new int[2];
            AsmpConnection asmpConnection = new AsmpConnection();
            try {
                asmpConnection.openAnonymousConnection(inetAddress);
                Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsMibMajorVersion.0", "avocent.ds.dsManagement.dsServer.dsMibMinorVersion.0"};
                InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(asmpConnection, objectArray);
                asmpConnection.closeAsmpSession();
                Trace.logInfo((String)"AvrNmmInterface:getAnonymousMibVersion", (String)"ASMP - Successfully retrieved Mib Versions.");
                nArray[0] = interfaceValueObjectArray[0].getInteger();
                nArray[1] = interfaceValueObjectArray[1].getInteger();
                return nArray;
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            }
            catch (IOException iOException) {
                Trace.logError((String)"AvrNmmInterface:getAnonymousMibVersion", (String)"Unable To Get AsmpConnectin IOException");
                asmpConnection.closeAsmpSession();
                asmpConnection = null;
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"AvrNmmInterface:getAnonymousMibVersion", (String)"Unable To Get AsmpConnectin Request failed.");
                asmpConnection.closeAsmpSession();
                asmpConnection = null;
            }
            nArray[0] = 1;
            nArray[1] = 11;
            return nArray;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
            String string2 = res.getString("AvrNmmInterface_ASMP_Request_timed_out_");
            string2 = MessageFormat.format(string2, objectArray);
            throw new ExceptionRequestFailed(string2);
        }
    }

    public int getAnoymousLoginTimeout(String string) throws ExceptionRequestFailed {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            AidpSession aidpSession = null;
            int n = 30;
            AsmpConnection asmpConnection = new AsmpConnection();
            try {
                asmpConnection.openAnonymousConnection(inetAddress);
                Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsLoginTimeout.0"};
                InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(asmpConnection, objectArray);
                asmpConnection.closeAsmpSession();
                Trace.logInfo((String)"AvrNmmInterface:getAnonymousMibVersion", (String)"ASMP - Successfully retrieved Mib Versions.");
                n = interfaceValueObjectArray[0].getInteger();
                return n;
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            }
            catch (IOException iOException) {
                Trace.logError((String)"AvrNmmInterface:getAnonymousMibVersion", (String)"Unable To Get AsmpConnectin IOException");
                asmpConnection.closeAsmpSession();
                asmpConnection = null;
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"AvrNmmInterface:getAnonymousMibVersion", (String)"Unable To Get AsmpConnectin Request failed.");
                asmpConnection.closeAsmpSession();
                asmpConnection = null;
            }
            aidpSession = new AidpSession(inetAddress);
            VarBind[] varBindArray = new VarBind[]{new VarBind("avocent.ds.dsManagement.dsServer.dsLoginTimeout.0")};
            if (aidpSession.snmpGet(varBindArray)) {
                Trace.logInfo((String)"AvrNmmInterface:getAnonymousMibVersion", (String)"Successfully retrieved Mib Versions.");
                n = varBindArray[0].getIntegerValue();
                return n;
            }
            Trace.logError((String)"AvrNmmInterface:getAnonymousMibVersion", (String)"AIDP - Unable to get Login Timeout");
            Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
            String string2 = res.getString("AvrNmmInterface_ASMP_Request_timed_out_");
            string2 = MessageFormat.format(string2, objectArray);
            throw new ExceptionRequestFailed(string2);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
            String string3 = res.getString("AvrNmmInterface_ASMP_Request_timed_out_");
            string3 = MessageFormat.format(string3, objectArray);
            throw new ExceptionRequestFailed(string3);
        }
    }

    public boolean isPropertySupported(int n, String string, String string2) throws ExceptionNotSupported, ExceptionRequestFailed {
        boolean bl = false;
        if (!this.isExplorerUnitType(string)) {
            Trace.logInfo((String)"AvrNmmInterface:isPropertySupported", (String)("ERROR : Invalid Unit Type passed [" + string + "]"));
            throw new ExceptionRequestFailed();
        }
        bl = this.isApplianceType(string) ? false : this.isPropertySupportedByDevice(n, string2);
        return bl;
    }

    private boolean isPropertySupportedByDevice(int n, String string) throws ExceptionNotSupported, ExceptionRequestFailed {
        if (!string.equals("Telnet") && !string.equals("Browser")) {
            Trace.logInfo((String)"AvrNmmInterface:isPropertySupportedByDevice", (String)("Property [" + string + "] not supported by AVR"));
            return false;
        }
        InterfaceInfo[] interfaceInfoArray = null;
        boolean bl = false;
        try {
            String string2 = "WHERE (CONN_ID=" + Integer.toString(n) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(1) + ");";
            interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string2);
            for (int i = 0; i < interfaceInfoArray.length; ++i) {
                int n2 = interfaceInfoArray[i].getApplianceID();
                ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo((int)n2);
                if (applianceInfo.getNmmID() != 1) continue;
                if (string.equals("Browser")) {
                    Trace.logInfo((String)"AvrNmmInterface:isPropertySupportedByDevice", (String)"Browser Property, supported");
                    bl = true;
                } else if (string.equals("Telnet")) {
                    if (AVWorksBranding.getBoolean((String)"TelnetFeature", (boolean)false)) {
                        Trace.logInfo((String)"AvrNmmInterface:isPropertySupportedByDevice", (String)"Telnet Property, supported");
                        bl = true;
                    } else {
                        Trace.logInfo((String)"AvrNmmInterface:isPropertySupportedByDevice", (String)"Telnet Property, not supported, telnet feature not enabled");
                        bl = false;
                    }
                } else {
                    Trace.logInfo((String)"AvrNmmInterface:isPropertySupportedByDevice", (String)("unsupported property " + string));
                    bl = false;
                }
                break;
            }
        }
        catch (ExceptionNoValue exceptionNoValue) {
            if (interfaceInfoArray == null) {
                Trace.logInfo((String)"AvrNmmInterface:isPropertySupportedByDevice", (String)"No connections associated with server.");
                bl = false;
            }
            Trace.logError((String)"AvrNmmInterface:isPropertySupportedByDevice", (String)"Unable to get appliance information.", (Throwable)exceptionNoValue);
            throw new ExceptionRequestFailed();
        }
        return bl;
    }

    public boolean isPropertySupported(String string) {
        if (string.equals("Telnet")) {
            return AVWorksBranding.getBoolean((String)"TelnetFeature", (boolean)false);
        }
        return string.equals("Browser");
    }

    public void performAction(int n, String string, int n2) throws ExceptionNotSupported, ExceptionRequestFailed {
        block9: {
            block8: {
                if (!this.isExplorerUnitType(string)) {
                    Trace.logInfo((String)"AvrNmmInterface:performAction", (String)("ERROR : Invalid Unit Type passed [" + string + "]"));
                    throw new ExceptionRequestFailed();
                }
                if (!this.isApplianceType(string)) break block8;
                switch (n2) {
                    case -1: {
                        this.processAmp(n);
                        break block9;
                    }
                    default: {
                        Trace.logInfo((String)"AvrNmmInterface:performAction", (String)("ERROR : Invalid action for appliance [" + n2 + "]"));
                        throw new ExceptionNotSupported();
                    }
                }
            }
            if (!this.performCommonAction(n, string, n2)) {
                switch (n2) {
                    case 1001: {
                        this.processConnectVideo(n);
                        break;
                    }
                    default: {
                        Trace.logInfo((String)"AvrNmmInterface:performAction", (String)("ERROR : Invalid action for server [" + n2 + "]"));
                        throw new ExceptionNotSupported();
                    }
                }
            }
        }
    }

    public ActionItem[] getActionItems(int n, String string) throws ExceptionNotSupported, ExceptionNoValue, ExceptionRequestFailed {
        Vector vector = new Vector();
        if (!this.isExplorerUnitType(string)) {
            Trace.logInfo((String)"AvrNmmInterface:getActionItems", (String)("ERROR : Invalid Unit Type passed [" + string + "]"));
            throw new ExceptionRequestFailed();
        }
        if (this.isApplianceType(string)) {
            this.getActionItemsForAppliance(n, vector);
        } else {
            this.getActionItemsForDevice(n, vector);
        }
        if (vector.size() == 0) {
            Trace.logInfo((String)"AvrNmmInterface:getActionItems", (String)"NOTE : No actions found for specified unit");
            throw new ExceptionNoValue();
        }
        Object[] objectArray = new ActionItem[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void getActionItemsForAppliance(int n, Vector vector) throws ExceptionRequestFailed {
        ApplianceInfo applianceInfo = null;
        try {
            applianceInfo = AppliancesDb.getApplianceInfo((int)n);
            if (applianceInfo.getNmmID() == 1) {
                vector.add(new ActionItem(-1, 1, true));
            }
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)"AvrNmmInterface:getActionItemsForAppliance", (String)"Unable to get Appliance Information", (Throwable)exceptionRequestFailed);
            throw exceptionRequestFailed;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            Trace.logError((String)"AvrNmmInterface:getActionItemsForAppliance", (String)"Unable to get Appliance Information", (Throwable)exceptionNoValue);
            throw new ExceptionRequestFailed();
        }
        catch (ExceptionConstructorFailed exceptionConstructorFailed) {
            Trace.logError((String)"AvrNmmInterface:getActionItemsForAppliance", (String)"Unable to construct action item", (Throwable)exceptionConstructorFailed);
            throw new ExceptionRequestFailed();
        }
    }

    private void getActionItemsForDevice(int n, Vector vector) throws ExceptionRequestFailed, ExceptionNoValue {
        InterfaceInfo[] interfaceInfoArray = null;
        try {
            String string = "WHERE (CONN_ID=" + Integer.toString(n) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(1) + ");";
            interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string);
            for (int i = 0; i < interfaceInfoArray.length; ++i) {
                int n2 = interfaceInfoArray[i].getApplianceID();
                ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo((int)n2);
                if (applianceInfo.getNmmID() != 1) continue;
                String string2 = AVWorksBranding.getString((String)"ConnectVideoTask", (String)res.getString("AvrNmmInterface_Connect_Video"));
                String string3 = AVWorksBranding.getString((String)"ConnectVideoTip", (String)res.getString("AvrNmmInterface_Connect_Video_Tooltip"));
                ImageIcon imageIcon = AVWorksBranding.getImage((String)"videoActionIcon", null);
                ActionItem actionItem = new ActionItem(1001, 1, imageIcon, string2, string3, true, true, true);
                vector.add(actionItem);
                break;
            }
        }
        catch (ExceptionNoValue exceptionNoValue) {
            if (interfaceInfoArray == null) {
                Trace.logInfo((String)"AvrNmmInterface:getActionItemsForDevice", (String)"No connections associated with server.");
                return;
            }
            Trace.logError((String)"AvrNmmInterface:getActionItemsForDevice", (String)"Unable to get appliance information.", (Throwable)exceptionNoValue);
            throw new ExceptionRequestFailed();
        }
        if (vector.size() <= 0) {
            Trace.logInfo((String)"AvrNmmInterface:getActionItemsForDevice", (String)"No connections to an AVR. No actions provided.");
            return;
        }
        this.getCommonActionItems(n, "Device", this.m_nId, 0, vector);
    }

    public ConnectionPathInfo[] getConnectionPaths(int n) throws ExceptionNotSupported, ExceptionNoValue {
        String[] stringArray = ConnectionPath.getConnectionPaths((int)n, (int)1);
        return this.pathsToConnectionPathInfo(stringArray, ConnectionPathInfo.VIDEO_CONNECTION_TYPE);
    }

    public ConnectionPathInfo[] getConnectionPaths(int n, boolean bl) throws ExceptionNotSupported, ExceptionNoValue {
        String[] stringArray = ConnectionPath.getConnectionPaths((int)n, (boolean)bl, (int)1);
        return this.pathsToConnectionPathInfo(stringArray, ConnectionPathInfo.VIDEO_CONNECTION_TYPE);
    }

    public ConnectionPathInfo[] pathsToConnectionPathInfo(String[] stringArray, String string) {
        ConnectionPathInfo[] connectionPathInfoArray;
        if (stringArray == null) {
            connectionPathInfoArray = new ConnectionPathInfo[]{};
        } else {
            connectionPathInfoArray = new ConnectionPathInfo[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                connectionPathInfoArray[i] = new ConnectionPathInfo(stringArray[i], string);
            }
        }
        return connectionPathInfoArray;
    }

    public void setConnectionPath(ConnectionPathInfo connectionPathInfo, int n) throws ExceptionNotSupported, ExceptionRequestFailed {
        if (connectionPathInfo == null || connectionPathInfo.getDescription() == null || connectionPathInfo.getDescription().length() <= 0) {
            Trace.logInfo((String)"AvrNmmInterface:setConnectionPath", (String)"ERROR : Invalid ConnectionPathInfo");
            throw new ExceptionRequestFailed();
        }
        ConnectionPath.setConnectionPath((String)connectionPathInfo.getDescription(), (int)n);
    }

    public void removeConnectionPath(ConnectionPathInfo connectionPathInfo, int n) throws ExceptionNotSupported, ExceptionRequestFailed {
        if (connectionPathInfo == null || connectionPathInfo.getDescription() == null || connectionPathInfo.getDescription().length() <= 0) {
            Trace.logInfo((String)"AvrNmmInterface:setConnectionPath", (String)"ERROR : Invalid ConnectionPathInfo");
            throw new ExceptionRequestFailed();
        }
        ConnectionPath.removeConnectionPath((String)connectionPathInfo.getDescription(), (int)n);
    }

    public static boolean hasApcp(int n) {
        return Products.isNautilusFamily((int)n);
    }

    public void performAction(int[] nArray, String string, int n) throws ExceptionNotSupported, ExceptionRequestFailed {
        if (!this.isExplorerUnitType(string)) {
            Trace.logInfo((String)"AvrNmmInterface:performAction", (String)("ERROR : Invalid Unit Type passed [" + string + "]"));
            throw new ExceptionRequestFailed();
        }
        if (nArray == null || nArray.length <= 0) {
            Trace.logInfo((String)"AvrNmmInterface:performAction", (String)"ERROR : Invalid Unit Id Array");
            throw new ExceptionRequestFailed();
        }
        if (nArray.length == 1) {
            this.performAction(nArray[0], string, n);
            return;
        }
        if (this.isApplianceType(string)) {
            Trace.logInfo((String)"AvrNmmInterface:performAction", (String)"NOTE : No actions supported for multiple appliances");
            throw new ExceptionNotSupported();
        }
        switch (n) {
            case 1002: {
                this.scanVideo(nArray);
                break;
            }
            default: {
                Trace.logInfo((String)"AvrNmmInterface:performAction", (String)("ERROR : Invalid action for servers [" + n + "]"));
                throw new ExceptionNotSupported();
            }
        }
    }

    public ActionItem[] getActionItems(int[] nArray, String string) throws ExceptionNotSupported, ExceptionNoValue, ExceptionRequestFailed {
        boolean bl = false;
        if (!this.isExplorerUnitType(string)) {
            Trace.logInfo((String)"AvrNmmInterface:getActionItems", (String)("ERROR : Invalid Unit Type passed [" + string + "]"));
            throw new ExceptionRequestFailed();
        }
        if (nArray == null || nArray.length <= 0) {
            Trace.logInfo((String)"AvrNmmInterface:getActionItems", (String)"ERROR : Invalid Unit Id Array");
            throw new ExceptionRequestFailed();
        }
        if (nArray.length == 1) {
            return this.getActionItems(nArray[0], string);
        }
        if (this.isApplianceType(string)) {
            Trace.logInfo((String)"AvrNmmInterface:getActionItems", (String)"NOTE : No actions found for multiple appliances");
            throw new ExceptionNoValue();
        }
        if (nArray.length > 16) {
            Trace.logInfo((String)"AvrNmmInterface:getActionItems", (String)"NOTE : No actions found for more than 16 appliances");
            throw new ExceptionNoValue();
        }
        try {
            InterfaceInfo[] interfaceInfoArray;
            String string2;
            Vector<ActionItem> vector = new Vector<ActionItem>();
            int n = 0;
            block2: for (int i = 0; i < nArray.length; ++i) {
                bl = false;
                string2 = "WHERE (CONN_ID=" + Integer.toString(nArray[i]) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(1) + ");";
                interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string2);
                bl = true;
                for (int j = 0; j < interfaceInfoArray.length; ++j) {
                    int n2 = interfaceInfoArray[j].getApplianceID();
                    ApplianceInfo applianceInfo = AppliancesDb.getApplianceInfo((int)n2);
                    if (applianceInfo.getNmmID() != 1) continue;
                    ++n;
                    continue block2;
                }
            }
            if (n == nArray.length) {
                String string3 = AVWorksBranding.getString((String)"ScanVideoTask", (String)res.getString("AvrNmmInterface_Scan_Video"));
                string2 = AVWorksBranding.getString((String)"ScanVideoTip", (String)res.getString("AvrNmmInterface_Scan_Video_Tooltip"));
                interfaceInfoArray = AVWorksBranding.getImage((String)"scanvideoActionIcon", null);
                ActionItem actionItem = new ActionItem(1002, 1, (ImageIcon)interfaceInfoArray, string3, string2, true, false, true);
                vector.add(actionItem);
            }
            if (vector.size() <= 0) {
                Trace.logInfo((String)"AvrNmmInterface:getActionItems", (String)"NOTE : No actions were available");
                throw new ExceptionNoValue();
            }
            Object[] objectArray = new ActionItem[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            bl = true;
            if (true) {
                Trace.logError((String)"AvrNmmInterface:getActionItems", (String)"One or more servers have no connections");
                throw exceptionNoValue;
            }
            Trace.logError((String)"AvrNmmInterface:getActionItems", (String)"Unable to get appliance associated with connection.", (Throwable)exceptionNoValue);
            throw new ExceptionRequestFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Trace.startLogging(null);
        try {
            AVWorksService.start();
            AvrNmmInterface avrNmmInterface = new AvrNmmInterface(1, null);
        }
        catch (Exception exception) {
            Trace.logError((String)"avrNmmInterface:main", (String)("Error Reason = " + exception.getMessage()));
        }
        finally {
            AVWorksService.shutdown();
        }
    }

    public static int isApplianceAvailable(String string, String[] stringArray) {
        Trace.logInfo((String)CNAME, (String)(" isApplianceAvailable() was called with address:" + string));
        int n = 1;
        Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
        try {
            int[] nArray = new int[1];
            InetAddress inetAddress = InetAddress.getByName(string);
            AidpSession aidpSession = null;
            int n2 = -1;
            String string2 = null;
            AsmpConnection asmpConnection = new AsmpConnection();
            try {
                asmpConnection.openAnonymousConnection(inetAddress);
                Object[] objectArray2 = new Object[]{"avocent.ds.dsManagement.dsServer.dsServerStatus.0"};
                InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(asmpConnection, objectArray2);
                asmpConnection.closeAsmpSession();
                Trace.logInfo((String)"AvrNmmInterface:isApplianceAvailable", (String)"ASMP - Successfully retrieved Server Status.");
                n2 = interfaceValueObjectArray[0].getInteger();
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                Trace.logError((String)"AvrNmmInterface:isApplianceAvailable", (String)"Unable To Get AsmpConnectin IOException");
            }
            catch (IOException iOException) {
                Trace.logError((String)"AvrNmmInterface:isApplianceAvailable", (String)"Unable To Get AsmpConnectin IOException");
                asmpConnection.closeAsmpSession();
                asmpConnection = null;
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)"AvrNmmInterface:isApplianceAvailable", (String)"Unable To Get AsmpConnectin Request failed.");
                asmpConnection.closeAsmpSession();
                asmpConnection = null;
            }
            if (asmpConnection == null) {
                aidpSession = new AidpSession(inetAddress);
                n2 = AvrAidpHelper.getApplianceStatus(aidpSession, nArray);
                Trace.logInfo((String)CNAME, (String)("AIDP - Appliance status = " + n2));
                switch (nArray[0]) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 4097: {
                        Trace.logInfo((String)CNAME, (String)("Request status not used in determining appliance availability (ASMP STATUS=" + nArray[0] + ")."));
                        n = -1;
                        string2 = res.getString("AvrNmmInterface_ASMP_Request_timed_out_");
                        string2 = MessageFormat.format(string2, APPLIANCE);
                        break;
                    }
                    case 5: 
                    case 7: {
                        Trace.logInfo((String)CNAME, (String)("DS appliance assumed to be currently unavailable (ASMP STATUS=" + nArray[0] + ")."));
                        n = -1;
                        string2 = res.getString("AvrNmmInterface_ASMP_General_failure");
                        string2 = MessageFormat.format(string2, objectArray);
                        break;
                    }
                    case 4096: {
                        Trace.logInfo((String)CNAME, (String)("I/O error while requesting appliance status (ASMP STATUS=" + nArray[0] + ")."));
                        n = 1;
                        break;
                    }
                    case 4098: {
                        Trace.logInfo((String)CNAME, (String)("I/O error while requesting appliance status (ASMP STATUS=" + nArray[0] + ")."));
                        n = -1;
                        string2 = res.getString("AvrNmmInterface_ASMP_General_failure");
                        string2 = MessageFormat.format(string2, objectArray);
                        break;
                    }
                    default: {
                        Trace.logInfo((String)CNAME, (String)("Unexpected request status while requesting appliance status(ASMP STATUS=" + nArray[0] + ")."));
                        n = -1;
                        string2 = res.getString("AvrNmmInterface_ASMP_Request_timed_out_");
                        string2 = MessageFormat.format(string2, APPLIANCE);
                    }
                }
            }
            if (n != 1 || nArray[0] != 0) {
                if (stringArray != null && stringArray.length > 0) {
                    stringArray[0] = string2;
                }
                return n;
            }
            switch (n2) {
                case 1: {
                    n = 1;
                    break;
                }
                case 4: {
                    n = 4;
                    break;
                }
                case 5: {
                    n = 5;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 3;
                    break;
                }
                case 6: {
                    n = 6;
                    break;
                }
                default: {
                    n = -1;
                }
            }
            if (n != 1 && stringArray != null && stringArray.length > 0) {
                switch (n) {
                    case 2: {
                        string2 = res.getString("AvrNmmInterface_Appliance_in_reboot");
                        stringArray[0] = string2 = MessageFormat.format(string2, objectArray);
                        break;
                    }
                    case 3: {
                        string2 = res.getString("AvrNmmInterface_Appliance_upgrading");
                        stringArray[0] = string2 = MessageFormat.format(string2, objectArray);
                        break;
                    }
                    case 4: {
                        stringArray[0] = string2 = res.getString("AvrNmmInterface_keyboard_mouse_error");
                        break;
                    }
                    case 5: {
                        stringArray[0] = string2 = res.getString("AvrNmmInterface_Subsystem_error");
                        break;
                    }
                    case 6: {
                        stringArray[0] = string2 = res.getString("AvrNmmInterface_Firmware_rejected_error");
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        stringArray[0] = string2 = res.getString("AvrNmmInterface_Unknown_error");
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Trace.logError((String)"AVRNmmInterface", (String)("Exception: " + throwable.getMessage()), (Throwable)throwable);
            n = -1;
            String string3 = res.getString("AvrNmmInterface_ASMP_Request_timed_out_");
            stringArray[0] = MessageFormat.format(string3, APPLIANCE);
        }
        return n;
    }

    static boolean checkApplianceVideoAvailability(String string, ThreadApplianceAvailable threadApplianceAvailable, Component component) {
        int n = 1;
        String[] stringArray = new String[1];
        n = AvrNmmInterface.isApplianceAvailable(string, stringArray);
        if (n == 1) {
            Trace.logInfo((String)"AvrNmmInterface:checkApplianceVideoAvailability", (String)"Appliance is available to launch a video session.");
            return true;
        }
        Trace.logInfo((String)"AvrNmmInterface:checkApplianceVideoAvailability", (String)("Appliance not available for launching a video session: " + stringArray[0]));
        boolean bl = false;
        if (threadApplianceAvailable != null) {
            threadApplianceAvailable.stopThreadAndCloseProgress();
            bl = threadApplianceAvailable.wasCanceled();
        }
        if (!bl) {
            String string2 = res.getString("AvrNmmInterface_Appliance_not_available");
            Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true), stringArray[0]};
            string2 = MessageFormat.format(string2, objectArray);
            Message.show((Component)component, (String)string2);
        }
        return false;
    }

    static boolean checkApplianceAvailability(String string, ThreadApplianceAvailable threadApplianceAvailable, Component component) {
        int n = 1;
        String[] stringArray = new String[1];
        n = AvrNmmInterface.isApplianceAvailable(string, stringArray);
        if (n == 1 || n == 5 || n == 4 || n == 6) {
            Trace.logInfo((String)"avrNmmInterface:checkApplianceAvailability", (String)"Appliance is available.");
            return true;
        }
        Trace.logInfo((String)"AvrNmmInterface:checkApplianceAvailability", (String)("Appliance not available for launching an AMP session: " + stringArray[0]));
        boolean bl = false;
        if (threadApplianceAvailable != null) {
            threadApplianceAvailable.stopThreadAndCloseProgress();
            bl = threadApplianceAvailable.wasCanceled();
        }
        if (!bl) {
            String string2 = res.getString("AvrNmmInterface_Appliance_not_available");
            Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true), stringArray[0]};
            string2 = MessageFormat.format(string2, objectArray);
            Message.show((Component)component, (String)string2);
        }
        return false;
    }

    static {
        try {
            Mib.register((String)"com.avocent.mibs.MibAvocentDs");
            Mib.register((String)"com.avocent.mibs.MibII");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.logInfo((String)"AvrNmmInterface:static initializer", (String)"got ClassNotFoundException when trying to register mibs");
        }
    }

    class ThreadApplianceAvailable
    extends Thread {
        JDialogElapsedTime m_dlgElapsed;
        boolean m_bStopThread;
        Object m_oKey;
        boolean m_bCanceled;
        String m_szTargetName;

        ThreadApplianceAvailable(Object object, String string) {
            super("Appliance Availability Check");
            this.m_bCanceled = false;
            this.m_oKey = object;
            this.m_szTargetName = string;
            Object[] objectArray = new Object[]{this.m_szTargetName};
            String string2 = MessageFormat.format(res.getString("AvrNmmInterface_Connecting_to_0"), objectArray);
            this.m_dlgElapsed = new JDialogElapsedTime(AvrNmmInterface.this.m_frameParent, res.getString("AvrNmmInterface_ElapsedTime_Title"), string2);
            String string3 = res.getString("AsmpConnection_Opening_AMP");
            String string4 = MessageFormat.format(string3, AmpController.APPLIANCE);
            this.m_dlgElapsed.addMessage("amp_connection_msg", string4);
            this.m_dlgElapsed.pack();
            this.m_dlgElapsed.addListener(new ActionListener(this){
                private final /* synthetic */ ThreadApplianceAvailable this$1;
                {
                    this.this$1 = threadApplianceAvailable;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.m_dlgElapsed.dispose();
                    m_htLaunchInProgress.remove(this.this$1.m_oKey);
                    this.this$1.m_bCanceled = true;
                }
            });
        }

        public void run() {
            try {
                AvrNmmInterface.this.m_frameParent.setCursor(Cursor.getPredefinedCursor(3));
                Thread.sleep(1500L);
                AvrNmmInterface.this.m_frameParent.setCursor(Cursor.getPredefinedCursor(0));
                if (!this.m_bStopThread) {
                    this.m_dlgElapsed.setEnableCancelButton(true);
                    this.m_dlgElapsed.setVisible(true);
                }
            }
            catch (Exception exception) {
                AvrNmmInterface.this.m_frameParent.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        JDialogElapsedTime getProgressDialog() {
            return this.m_dlgElapsed;
        }

        void stopThread() {
            Trace.logInfo((String)"AvrNmmInterface:stopThread", (String)" Stopping ThreadApplianceAvailable.");
            this.m_bStopThread = true;
        }

        void stopThreadAndCloseProgress() {
            Trace.logInfo((String)"AvrNmmInterface:stopThread", (String)" Stopping ThreadApplianceAvailable.");
            if (this.m_dlgElapsed != null) {
                this.m_dlgElapsed.setVisible(false);
                this.m_dlgElapsed.dispose();
            }
            this.m_bStopThread = true;
        }

        boolean wasCanceled() {
            return this.m_bCanceled;
        }
    }
}

