/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.JPanelResyncWizardDetectedChanges;
import com.avocent.avworks.nmm.avr.JPanelResyncWizardEnterSwitchConfig;
import com.avocent.avworks.nmm.avr.JPanelResyncWizardPollingAppliance;
import com.avocent.avworks.nmm.avr.JPanelResyncWizardWarning;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.wizards.InterfaceWizardPanel;
import com.avocent.lib.gui.wizards.JDialogWizard;
import com.avocent.lib.util.ResourceManager;
import java.awt.Frame;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class AvrResyncWizard {
    public static final String CNAME = "AvrResyncWizard";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    public static final int WELCOME_PAGE = 1;
    public static final int WARNING_PAGE = 2;
    public static final int POLLING_APPLIANCE_PAGE = 3;
    public static final int DETECTED_CHANGES_PAGE = 4;
    public static final int ENTER_SWITCH_CONFIG_PAGE = 5;
    public static final int FINISH_PAGE = 6;
    public static final int FINISH_PAGE_UPDATE_DB_PAGE = 7;
    public static final String ASMP_CONNECTION = "ASMP_CONNECTION";

    public static boolean showWizard(AmpController ampController, ApplianceInfo applianceInfo) throws ExceptionRequestFailed {
        Trace.logInfo((String)CNAME, (String)"showWizard");
        String string = AVWorksBranding.getApplianceName((boolean)true);
        Object[] objectArray = new Object[]{string};
        String string2 = MessageFormat.format(res.getString("AvrResyncWizard_Resync_0_Wizard"), objectArray);
        String string3 = AVWorksBranding.getServerName((boolean)true);
        Object[] objectArray2 = new Object[]{string3, string};
        Object[] objectArray3 = new Object[]{string, string3};
        try {
            JDialogWizard jDialogWizard = new JDialogWizard((Frame)ampController.getMainFrame());
            jDialogWizard.putValue((Object)"ApplianceInfo", (Object)applianceInfo);
            jDialogWizard.putValue((Object)ASMP_CONNECTION, (Object)ampController.getAsmpConnection());
            ImageIcon imageIcon = new ImageIcon(JDialogWizard.class.getResource("welcome.gif"));
            jDialogWizard.addWelcomePage(1, 2, string2, MessageFormat.format(res.getString("AvrResyncWizard_Welcome_to_the_Resync"), objectArray), MessageFormat.format(res.getString("AvrResyncWizard_This_wizard_resyncs"), objectArray), imageIcon);
            JPanelResyncWizardWarning jPanelResyncWizardWarning = new JPanelResyncWizardWarning(jDialogWizard, 2, string2);
            jDialogWizard.addInteriorPage(" " + res.getString("AvrResyncWizard_Warning"), MessageFormat.format(res.getString("AvrResyncWizard_The_0_will_be_polled"), objectArray3), null, (InterfaceWizardPanel)jPanelResyncWizardWarning);
            JPanelResyncWizardPollingAppliance jPanelResyncWizardPollingAppliance = new JPanelResyncWizardPollingAppliance(jDialogWizard, 3, string2);
            jDialogWizard.addInteriorPage(MessageFormat.format(res.getString("AvrResyncWizard_Polling_0_"), objectArray), MessageFormat.format(res.getString("AvrResyncWizard_Polling_0_Information"), objectArray2), null, (InterfaceWizardPanel)jPanelResyncWizardPollingAppliance);
            JPanelResyncWizardDetectedChanges jPanelResyncWizardDetectedChanges = new JPanelResyncWizardDetectedChanges(jDialogWizard, 4, string2);
            jDialogWizard.addInteriorPage(res.getString("AvrResyncWizard_Detected_Changes"), MessageFormat.format(res.getString("AvrResyncWizard_Detected_changes_in"), objectArray), null, (InterfaceWizardPanel)jPanelResyncWizardDetectedChanges);
            String string4 = AVWorksBranding.getCascadeSwitchName((boolean)true);
            Object[] objectArray4 = new Object[]{string4};
            Object[] objectArray5 = new Object[]{string4, string};
            JPanelResyncWizardEnterSwitchConfig jPanelResyncWizardEnterSwitchConfig = new JPanelResyncWizardEnterSwitchConfig(jDialogWizard, 5, string2);
            jDialogWizard.addInteriorPage(MessageFormat.format(res.getString("AvrResyncWizard_Enter_0_Information"), objectArray4), MessageFormat.format(res.getString("AvrResyncWizard_Configure_0"), objectArray5), null, (InterfaceWizardPanel)jPanelResyncWizardEnterSwitchConfig);
            jDialogWizard.addCompletionPage(6, string2, imageIcon);
            Trace.logInfo((String)CNAME, (String)"Showing DS Resync Appliance Wizard");
            jDialogWizard.pack();
            jDialogWizard.setVisible(true);
            Trace.logInfo((String)CNAME, (String)"DS Resync Appliance Wizard Done");
            jDialogWizard.dispose();
            return true;
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)"Unable to create Resync Wizard", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Trace.startLogging(null);
        try {
            AVWorksService.start();
            AvrResyncWizard.showWizard(null, null);
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)"Unit Test Error");
        }
        finally {
            AVWorksService.shutdown();
        }
    }
}

