/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrRipInfo;
import com.avocent.avworks.nmm.avr.AvrServerInfo;
import com.avocent.avworks.nmm.avr.InterfaceDsSnmpConstants;
import com.avocent.avworks.nmm.avr.MibEnumAvocentAvr;
import com.avocent.avworks.nmm.common.AsmpConnection;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.MibEnum;
import com.avocent.avworks.nmm.common.MibEnumObject;
import com.avocent.avworks.nmm.common.SnmpHelper;
import com.avocent.avworks.nmm.common.SnmpValueObject;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.exceptions.ExceptionUserCancelled;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.util.ResourceManager;
import com.avocent.protocols.asmp.AsmpErrorStatus;
import com.avocent.protocols.asmp.AsmpFileData;
import com.avocent.protocols.asmp.AsmpFileInfo;
import com.avocent.protocols.asmp.ThreadAsmpSession;
import com.avocent.protocols.snmp.SnmpErrorStatus;
import com.avocent.protocols.snmp.SnmpRequest;
import com.avocent.protocols.snmp.VarBind;
import com.avocent.protocols.snmp.VarBindList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;

public class AvrSnmpHelper
extends SnmpHelper
implements InterfaceDsSnmpConstants {
    public static final String CNAME = "AvrSnmpHelper";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    protected static AvrSnmpHelper m_ashSingleton = new AvrSnmpHelper();

    private AvrSnmpHelper() {
        this.registerOids();
        AvrSnmpHelper.initialize();
        MibEnum.registerEnumerationList((String)"avocent.ds", (MibEnumObject[])MibEnumAvocentAvr.m_aEnumObjects);
    }

    public static void initialize() {
    }

    protected void registerOids() {
        this.mvPut("avocent.ds.dsManagement.dsServer.dsPartNumber.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsSerialNumber.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsLanguage.0", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsLanIPAddress.0", 64, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsLanSubnetMask.0", 64, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsLanGateway.0", 64, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsLanSpeed.0", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsBootpControl.0", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsDhcpControl.0", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsDns.dsDnsServerTable.dsDnsServerTableEntry.dsDnsServerTableAddress.1", 64, false, true);
        this.mvPut("avocent.ds.dsManagement.dsDns.dsDnsServerTable.dsDnsServerTableEntry.dsDnsServerTableAddress.2", 64, false, true);
        this.mvPut("avocent.ds.dsManagement.dsDns.dsDnsServerTable.dsDnsServerTableEntry.dsDnsServerTableAddress.3", 64, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsReboot.0", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsServerStatus.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTableIndex", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTableName", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTablePassword", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTableAccessLevel", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTableLockStatus", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsUser.dsUserName.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsUser.dsUserPassword.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsUser.dsUserAccessLevel.0", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsUser.dsUserLockStatus.0", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsUser.dsUserRipId.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsUser.dsUserChannel.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsUser.dsUpdateUserTableControl.0", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsSession.dsSessionTimeout.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsSession.dsSessionPreemptionTimeout.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsLoginTimeout.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableIndex", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsVideoControl.dsVideoEncryptionTable.dsVideoEncryptionTableEntry.dsVideoEncryptionTableIndex", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsVideoControl.dsVideoEncryptionTable.dsVideoEncryptionTableEntry.dsVideoEncryptionTableControl", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableServerName", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableRipId", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableSwitchChannel", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableAccessControlList", 4, false, false);
        this.mvPut("avocent.ds.dsManagement.dsSnmp.dsSnmpControl.0", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsSnmp.dsReadCommunity.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsSnmp.dsWriteCommunity.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsSnmp.dsTrapCommunity.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsSnmp.dsManagerTable.dsManagerTableEntry.dsManagerTableIPAddress", 64, false, false);
        this.mvPut("avocent.ds.dsManagement.dsSnmp.dsTrapHostTable.dsTrapHostTableEntry.dsTrapHostTableIPAddress", 64, false, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableIndex", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableInputPort", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipId", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipType", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipVendor", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipStatus", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipBootImageVersion", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipAppImageVersion", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipHardwareVersion", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipUpgradeControl", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipUpgradeStatus", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipUpgradeFailReason", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableSwitchDetected", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableKeyboardLayout", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipUpgradable", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipResetControl", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipUpgradeFailCode", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipFPGAVersion", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipName", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableAppVersionAvailable", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsDeleteOffLineRips.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsRipAutomaticUpgrade.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsRipKeyboardLanguage.0", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableIndex", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableVersionAvailable", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableVersionMismatches", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableControl", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableStatus", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableFailReason", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableFailCode", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsSnmp.dsTrapCfgTable.dsTrapCfgTableEntry.dsTrapCfgTableIndex", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsSnmp.dsTrapCfgTable.dsTrapCfgTableEntry.dsTrapCfgTableControl", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsImageFileComponentTable.dsImageFileComponentTableEntry.dsImageFileComponentTableDescription", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsImageFileComponentTable.dsImageFileComponentTableEntry.dsImageFileComponentTableVersion", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsHardwareTable.dsHardwareTableEntry.dsHardwareTableDescription", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsHardwareTable.dsHardwareTableEntry.dsHardwareTableVersion", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl.1", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl.2", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl.3", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl.4", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsVideoControl.dsVideoEncryptionTable.dsVideoEncryptionTableEntry.dsVideoEncryptionTableControl.1", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsVideoControl.dsVideoEncryptionTable.dsVideoEncryptionTableEntry.dsVideoEncryptionTableControl.2", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsVideoControl.dsVideoEncryptionTable.dsVideoEncryptionTableEntry.dsVideoEncryptionTableControl.3", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsVideoControl.dsVideoEncryptionTable.dsVideoEncryptionTableEntry.dsVideoEncryptionTableControl.4", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableIndex", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableUpgradeFileName.1", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableTftpIPAddress.1", 64, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableUpgradeControl.1", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableUpgradeStatus.1", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableUpgradeFailReason.1", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableUpgradeFailCode.1", 64, true, true);
        this.mvPut("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableIndex", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableRipId", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableSwitchChannel", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableServerName", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableUserName", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableDuration", 65, false, false);
        this.mvPut("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableRemoteIPAddress", 64, false, false);
        this.mvPut("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableControl", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableSessionType", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTablePrimarySessionIndex", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsSession.dsSessionTable.dsSessionTableEntry.dsSessionTableStatus", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsCreateNewFileControl.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsCreatedFileName.0", 4, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsFileCreationStatus.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsFileCreationFailReason.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsFileCreationFailCode.0", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsLoadFileControl.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsLoadFileName.0", 4, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsFileLoadStatus.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsFileLoadFailReason.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsFileLoadFailCode.0", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsSnmp.dsManagerStatusTable.dsManagerStatusTableEntry.dsManagerStatusTableIPAddress", 64, false, false);
        this.mvPut("avocent.ds.dsManagement.dsSnmp.dsManagerStatusTable.dsManagerStatusTableEntry.dsManagerStatusTableRebootRequired", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsUserLockDuration.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsMibMajorVersion.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsMibMinorVersion.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsKey.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsTable.dsLicensedOptionsTableEntry.dsLicensedOptionsTableIndex", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsTable.dsLicensedOptionsTableEntry.dsLicensedOptionsTableName", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsTable.dsLicensedOptionsTableEntry.dsLicensedOptionsTableStatus", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsTable.dsLicensedOptionsTableEntry.dsLicensedOptionsTableControl", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsNtp.dsNtpControl.0", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsNtp.dsNtpUpdateInterval.0", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsNtp.dsNtpServerTable.dsNtpServerTableEntry.dsNtpServerTableIndex", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsNtp.dsNtpServerTable.dsNtpServerTableEntry.dsNtpServerTableAddress", 4, false, false, true);
        this.mvPut("avocent.ds.dsManagement.dsNtp.dsNtpServerTable.dsNtpServerTableEntry.dsNtpServerTableStatus", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsNtp.dsNtpServerTable.dsNtpServerTableEntry.dsNtpServerTableError", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapServerTable.dsLdapServerTableEntry.dsLdapServerTableName.1", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapServerTable.dsLdapServerTableEntry.dsLdapServerTablePort.1", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapServerTable.dsLdapServerTableEntry.dsLdapServerTableAccess.1", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapServerTable.dsLdapServerTableEntry.dsLdapServerTableName.2", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapServerTable.dsLdapServerTableEntry.dsLdapServerTablePort.2", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapServerTable.dsLdapServerTableEntry.dsLdapServerTableAccess.2", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapSearchDN.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapSearchPasswd.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapSearchBase.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapSearchUid.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapQueryModeAppliance.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapQueryModeServer.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapGroupContainer.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapGroupContainerMask.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapTargetMask.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapAccessControl.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapAuthenticateOnly.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapSchemaExtensions.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapApplianceDomain.0", 4, false, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapSearchRootDomain.0", 4, false, true);
        this.mvPut("avocent.ds.dsManagement.dsLdap.dsLdapGroupContainerDomain.0", 4, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsAuthenticationTable.dsAuthenticationTableEntry.dsAuthenticationTableOrder.1", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsAuthenticationTable.dsAuthenticationTableEntry.dsAuthenticationTableOrder.2", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsAuthenticationTable.dsAuthenticationTableEntry.dsAuthenticationTableIndex", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsAuthenticationTable.dsAuthenticationTableEntry.dsAuthenticationTableOrder", 2, false, false);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsOverrideUserName.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsServer.dsOverrideUserPassword.0", 4, false, true, true);
        this.mvPut("avocent.ds.dsManagement.dsVideoControl.dsVideoControlSharingAllowed.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsVideoControl.dsVideoControlExclusiveSessionsAllowed.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsVideoControl.dsVideoControlAutomaticSharing.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsVideoControl.dsVideoControlStealthSessionsAllowed.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsVideoControl.dsVideoControlInputControlTimeout.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaLockedToKvmAction.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaReserved.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaPreemptionTimeout.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaAccessMode.0", 2, false, true);
        this.mvPut("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaEncryptionTable.dsVirtualMediaEncryptionTableEntry.dsVirtualMediaEncryptionTableIndex", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaEncryptionTable.dsVirtualMediaEncryptionTableEntry.dsVirtualMediaEncryptionTableControl", 2, true, false);
        this.mvPut("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaEncryptionTable.dsVirtualMediaEncryptionTableEntry.dsVirtualMediaEncryptionTableControl.1", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaEncryptionTable.dsVirtualMediaEncryptionTableEntry.dsVirtualMediaEncryptionTableControl.2", 2, true, true);
        this.mvPut("avocent.ds.dsManagement.dsVirtualMedia.dsVirtualMediaEncryptionTable.dsVirtualMediaEncryptionTableEntry.dsVirtualMediaEncryptionTableControl.3", 2, true, true);
    }

    public static InterfaceValueObject[] getValues(AsmpConnection asmpConnection, Object[] objectArray) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        return AvrSnmpHelper.getValues(asmpConnection, objectArray, "");
    }

    public static InterfaceValueObject[] getValues(AsmpConnection asmpConnection, Object[] objectArray, String string) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        return AvrSnmpHelper.getInstance().getMibValues(asmpConnection, objectArray, string);
    }

    public static InterfaceValueObject[][] getTableValues(AsmpConnection asmpConnection, Object[] objectArray) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        return AvrSnmpHelper.getInstance().getMibTableValues(asmpConnection, objectArray);
    }

    public static void set(AsmpConnection asmpConnection, Object[] objectArray, Object[] objectArray2) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        AvrSnmpHelper.set(asmpConnection, objectArray, objectArray2, "");
    }

    public static void set(AsmpConnection asmpConnection, Object[] objectArray, Object[] objectArray2, String string) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        AvrSnmpHelper.getInstance().setMibValues(asmpConnection, objectArray, objectArray2, string);
    }

    public static void setValues(AsmpConnection asmpConnection, InterfaceValueObject[] interfaceValueObjectArray) throws ExceptionInvalidArgument, ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        if (asmpConnection == null || interfaceValueObjectArray == null || interfaceValueObjectArray.length == 0) {
            String string = "setValues method called with an invalid argument.";
            AvrSnmpHelper.logError((String)string);
            string = res.getString("AvrSnmpHelper_Req_Failed_internal");
            throw new ExceptionInvalidArgument(string);
        }
        try {
            VarBindList varBindList = new VarBindList();
            for (int i = 0; i < interfaceValueObjectArray.length; ++i) {
                VarBind varBind = ((SnmpValueObject)interfaceValueObjectArray[i]).getVarBind();
                varBindList.addVarBind(varBind);
            }
            SnmpRequest snmpRequest = new SnmpRequest(varBindList, null, "", 163, 0, 0);
            AvrSnmpHelper.logSetInfo((String)"setValues", (VarBindList)varBindList, (Object[])interfaceValueObjectArray);
            AvrSnmpHelper.logInfo((String)"Making ASMP Set request.");
            int n = asmpConnection.asmpRequest(snmpRequest);
            if (n != 0 || snmpRequest.getErrorStatus() != 0) {
                if (n != 0) {
                    if (n < 256) {
                        int n2 = snmpRequest.getErrorIndex();
                        String string = "ASMP Set request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n2 + ".";
                        AvrSnmpHelper.logError((String)string);
                        string = AvrSnmpHelper.getErrorStatusMessage((int)snmpRequest.getErrorStatus());
                        throw new ExceptionSnmpRequestFailed(string, snmpRequest.getErrorStatus(), n2);
                    }
                    String string = "ASMP Set request failed. AsmpStatus=" + n + " " + AsmpErrorStatus.getErrorStatusMessage((int)n) + ".";
                    AvrSnmpHelper.logError((String)string);
                    string = AvrSnmpHelper.getErrorStatusMessage((int)n);
                    throw new ExceptionAsmpRequestFailed(string, n);
                }
                if (snmpRequest.getErrorStatus() != 0) {
                    int n3 = snmpRequest.getErrorIndex();
                    String string = "ASMP Set request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n3 + ".";
                    AvrSnmpHelper.logError((String)string);
                    string = SnmpErrorStatus.getErrorStatusMessage((int)snmpRequest.getErrorStatus());
                    throw new ExceptionSnmpRequestFailed(string, snmpRequest.getErrorStatus(), n3);
                }
                String string = "ASMP Set request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + ".";
                AvrSnmpHelper.logError((String)string);
                string = AvrSnmpHelper.getErrorStatusMessage((int)n);
                throw new ExceptionRequestFailed(string);
            }
            AvrSnmpHelper.logInfo((String)"ASMP Set request succeeded.");
        }
        catch (Exception exception) {
            AvrSnmpHelper.logError((String)exception.getMessage(), (Exception)exception);
            String string = exception.getMessage();
            if (string == null || string.trim().length() == 0) {
                string = MessageFormat.format(res.getString("AvrSnmpHelper_Request_Failed_ASMP_communications"), APPLIANCE);
                throw new ExceptionRequestFailed(string);
            }
            throw exception;
        }
    }

    public static void sendFile(ThreadAsmpSession threadAsmpSession, InputStream inputStream, long l, String string) throws ExceptionRequestFailed, ExceptionAsmpRequestFailed, ExceptionUserCancelled {
        try {
            int n;
            block20: {
                int n2 = 2;
                AsmpFileInfo asmpFileInfo = new AsmpFileInfo(string, n2, l);
                int n3 = threadAsmpSession.openWrite(asmpFileInfo);
                if (n3 == 0) {
                    AvrSnmpHelper.logInfo((String)("ASMP openWrite request for remote file (" + string + ") succeeded."));
                    n = 0;
                    int n4 = 0;
                    byte[] byArray = new byte[BLOCK_SIZE];
                    while (true) {
                        int n5;
                        if ((n5 = inputStream.read(byArray, n4, BLOCK_SIZE - n4)) == -1) {
                            if (n4 > 0) {
                                byte[] byArray2 = new byte[n4];
                                System.arraycopy(byArray, 0, byArray2, 0, n4);
                                AvrSnmpHelper.write((ThreadAsmpSession)threadAsmpSession, (int)(++n), (byte[])byArray2);
                            }
                            break block20;
                        }
                        if ((n4 += n5) < BLOCK_SIZE) continue;
                        if (n4 > BLOCK_SIZE) {
                            AvrSnmpHelper.logInfo((String)("Read more than BLOCK_SIZE=" + BLOCK_SIZE + " worth of data from input stream for file: " + string + " (nCurBlockSize=" + n4 + ")."));
                        }
                        AvrSnmpHelper.write((ThreadAsmpSession)threadAsmpSession, (int)(++n), (byte[])byArray);
                        n4 = 0;
                    }
                }
                String string2 = "ASMP openWrite request failed for remote file (" + string + "). AsmpStatus=" + n3;
                AvrSnmpHelper.logError((String)string2);
                string2 = AvrSnmpHelper.getErrorStatusMessage((int)n3);
                throw new ExceptionAsmpRequestFailed(string2, n3);
            }
            AvrSnmpHelper.logInfo((String)("Successfully sent remote file (" + string + ").  Total blocks written=" + n + "."));
            AvrSnmpHelper.closeWrite((ThreadAsmpSession)threadAsmpSession, (String)string);
        }
        catch (IOException iOException) {
            try {
                AvrSnmpHelper.closeWrite((ThreadAsmpSession)threadAsmpSession, (String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (iOException.getMessage().indexOf("cancel") > 0) {
                throw new ExceptionUserCancelled();
            }
            String string3 = "IOException caught reading input stream for  file (" + string + ") to be sent." + "  exception: " + iOException.getMessage();
            AvrSnmpHelper.logError((String)string3);
            string3 = MessageFormat.format(res.getString("AvrSnmpHelper_Write_request_failed2_Appliance0"), APPLIANCE);
            throw new ExceptionRequestFailed(string3);
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            try {
                AvrSnmpHelper.closeWrite((ThreadAsmpSession)threadAsmpSession, (String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string4 = "ExceptionAsmpRequestFailed caught attempting to send remote file (" + string + ").  exception: " + exceptionAsmpRequestFailed.getMessage();
            AvrSnmpHelper.logError((String)string4);
            throw exceptionAsmpRequestFailed;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            try {
                AvrSnmpHelper.closeWrite((ThreadAsmpSession)threadAsmpSession, (String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string5 = "ExceptionRequestFailed caught attempting to send remote file (" + string + ").  exception: " + exceptionRequestFailed.getMessage();
            AvrSnmpHelper.logError((String)string5);
            string5 = exceptionRequestFailed.getMessage();
            if (string5.trim().length() == 0) {
                string5 = res.getString("AvrSnmpHelper_Write_request_failed1_Appliance0");
                string5 = MessageFormat.format(string5, APPLIANCE);
            }
            throw new ExceptionRequestFailed(string5);
        }
        catch (Exception exception) {
            try {
                AvrSnmpHelper.closeWrite((ThreadAsmpSession)threadAsmpSession, (String)string);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            String string6 = "Exception attempting to send remote file (" + string + ").  exception: " + exception.getMessage();
            AvrSnmpHelper.logError((String)string6);
            string6 = res.getString("AvrSnmpHelper_Write_request_failed2_Appliance0");
            string6 = MessageFormat.format(string6, APPLIANCE);
            throw new ExceptionRequestFailed(string6);
        }
    }

    public static void retrieveFile(ThreadAsmpSession threadAsmpSession, OutputStream outputStream, String string) throws ExceptionRequestFailed, ExceptionAsmpRequestFailed {
        try {
            int n;
            block12: {
                AsmpFileInfo asmpFileInfo = new AsmpFileInfo(string);
                int n2 = threadAsmpSession.openRead(asmpFileInfo);
                if (n2 == 0) {
                    Object object;
                    AsmpFileData asmpFileData;
                    long l = asmpFileInfo.getFileSize();
                    AvrSnmpHelper.logInfo((String)("ASMP openRead request for remote file (" + string + ") succeeded.  File size=" + l + "."));
                    n = 0;
                    while ((n2 = threadAsmpSession.read(asmpFileData = new AsmpFileData(++n))) == 0) {
                        AvrSnmpHelper.logInfo((String)("ASMP read request for block=" + n + " succeeded."));
                        object = asmpFileData.getData();
                        outputStream.write((byte[])object);
                        if ((l -= (long)((Object)object).length) > 0L) continue;
                        break block12;
                    }
                    object = "ASMP read request for block=" + n + " failed. AsmpStatus=" + n2;
                    AvrSnmpHelper.logError((String)object);
                    object = AsmpErrorStatus.getErrorStatusMessage((int)n2);
                    throw new ExceptionAsmpRequestFailed((String)object, n2);
                }
                String string2 = "ASMP openRead request failed for remote file (" + string + "). AsmpStatus=" + n2;
                AvrSnmpHelper.logError((String)string2);
                string2 = AvrSnmpHelper.getErrorStatusMessage((int)n2);
                throw new ExceptionAsmpRequestFailed(string2, n2);
            }
            AvrSnmpHelper.logInfo((String)("Successfully retrieved remote file (" + string + ").  Total blocks read=" + n + "."));
            AvrSnmpHelper.closeRead((ThreadAsmpSession)threadAsmpSession, (String)string);
        }
        catch (IOException iOException) {
            try {
                AvrSnmpHelper.closeRead((ThreadAsmpSession)threadAsmpSession, (String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string3 = "IOException caught writing to output stream  while retrieving remote file (" + string + ". exception: " + iOException.getMessage();
            AvrSnmpHelper.logError((String)string3, (Exception)iOException);
            string3 = MessageFormat.format(res.getString("AvrSnmpHelper_Read_request_failed1_Appliance0"), APPLIANCE);
            throw new ExceptionRequestFailed(string3);
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            try {
                AvrSnmpHelper.closeRead((ThreadAsmpSession)threadAsmpSession, (String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string4 = "ExceptionAsmpRequestFailed caught attempting to retrieve remote file (" + string + ").  exception: " + exceptionAsmpRequestFailed.getMessage();
            AvrSnmpHelper.logError((String)string4);
            throw exceptionAsmpRequestFailed;
        }
        catch (Exception exception) {
            try {
                AvrSnmpHelper.closeRead((ThreadAsmpSession)threadAsmpSession, (String)string);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            String string5 = "Exception attempting to retrieve remote file (" + string + ").  exception: " + exception.getMessage();
            AvrSnmpHelper.logError((String)string5, (Exception)exception);
            string5 = res.getString("AvrSnmpHelper_Read_request_failed1_Appliance0");
            string5 = MessageFormat.format(string5, APPLIANCE);
            throw new ExceptionRequestFailed(string5);
        }
    }

    public static long getRemoteFileSize(ThreadAsmpSession threadAsmpSession, String string) throws ExceptionRequestFailed, ExceptionAsmpRequestFailed {
        try {
            AsmpFileInfo asmpFileInfo = new AsmpFileInfo(string);
            int n = threadAsmpSession.openRead(asmpFileInfo);
            if (n == 0) {
                long l = asmpFileInfo.getFileSize();
                AvrSnmpHelper.logInfo((String)("ASMP openRead request for remote file (" + string + ") succeeded.  File size=" + l + "."));
                AvrSnmpHelper.closeRead((ThreadAsmpSession)threadAsmpSession, (String)string);
                return l;
            }
            String string2 = "ASMP openRead request failed for remote file (" + string + "). AsmpStatus=" + n;
            AvrSnmpHelper.logError((String)string2);
            string2 = AvrSnmpHelper.getErrorStatusMessage((int)n);
            throw new ExceptionAsmpRequestFailed(string2, n);
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            String string3 = "ExceptionAsmpRequestFailed caught attempting to open remote file (" + string + ").  exception: " + exceptionAsmpRequestFailed.getMessage();
            AvrSnmpHelper.logError((String)string3);
            throw exceptionAsmpRequestFailed;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            String string4 = "ExceptionRequestFailed caught attempting to open remote file (" + string + ").  exception: " + exceptionRequestFailed.getMessage();
            AvrSnmpHelper.logError((String)string4);
            throw new ExceptionRequestFailed(exceptionRequestFailed.getMessage());
        }
    }

    protected boolean isEmptyRow(VarBindList varBindList) {
        if (varBindList == null) {
            return false;
        }
        try {
            for (int i = 0; i < varBindList.size(); ++i) {
                String string;
                VarBind varBind = varBindList.varbindAt(i);
                String string2 = varBind.getName();
                if (string2.indexOf("dsManagerTable") != -1) {
                    if (string2.indexOf("avocent.ds.dsManagement.dsSnmp.dsManagerTable.dsManagerTableEntry.dsManagerTableIPAddress") == -1) continue;
                    string = varBind.getStringValue();
                    if (!(string = new IpAddress(string).getString()).equals("0.0.0.0")) continue;
                    return true;
                }
                if (string2.indexOf("dsTrapHostTable") != -1) {
                    if (string2.indexOf("avocent.ds.dsManagement.dsSnmp.dsTrapHostTable.dsTrapHostTableEntry.dsTrapHostTableIPAddress") == -1) continue;
                    string = varBind.getStringValue();
                    if (!(string = new IpAddress(string).getString()).equals("0.0.0.0")) continue;
                    return true;
                }
                if (string2.indexOf("dsUserTable") == -1 || string2.indexOf("avocent.ds.dsManagement.dsUser.dsUserTable.dsUserTableEntry.dsUserTableName") == -1 || (string = varBind.getStringValue()).trim().length() != 0) continue;
                return true;
            }
        }
        catch (Exception exception) {
            String string = "Caught exception while checking for empty row (" + exception.getMessage() + ").";
            AvrSnmpHelper.logError((String)string, (Exception)exception);
        }
        return false;
    }

    protected String findEmptyRow(AsmpConnection asmpConnection, Object object) throws ExceptionInvalidArgument, ExceptionSnmpRequestFailed, ExceptionRequestFailed, Exception {
        String string;
        block13: {
            string = null;
            try {
                String string2;
                String string3;
                int n;
                Object[] objectArray = new Object[]{this.getEmptyRowFieldId(object.toString())};
                VarBindList varBindList = this.createVarBindList(objectArray, "");
                if (varBindList.size() != 1) {
                    String string4 = "Size of varbind list=" + varBindList.size() + " returned by createVarBindList method is " + "more than one.";
                    AvrSnmpHelper.logError((String)string4);
                    string4 = res.getString("AvrSnmpHelper_Req_Failed_internal");
                    throw new ExceptionRequestFailed(string4);
                }
                SnmpRequest snmpRequest = new SnmpRequest(varBindList, null, "", 161, 0, 0);
                String string5 = "";
                while (true) {
                    AvrSnmpHelper.logGetInfo((String)"findEmptyRow", (VarBindList)snmpRequest.getVarBindList());
                    AvrSnmpHelper.logInfo((String)"Making ASMP GetNext request.");
                    n = asmpConnection.asmpRequest(snmpRequest);
                    if (n != 0 || snmpRequest.getErrorStatus() != 0) break;
                    AvrSnmpHelper.logInfo((String)"ASMP GetNext request succeeded.");
                    VarBindList varBindList2 = snmpRequest.getVarBindList();
                    if (varBindList2 == null || varBindList2.size() == 0) {
                        AvrSnmpHelper.logInfo((String)"ASMP GetNext response empty--reached end of MIB.");
                        break block13;
                    }
                    if ((varBindList2 = this.reorderPerOriginalRequest(varBindList2, objectArray)).size() != objectArray.length) {
                        AvrSnmpHelper.logInfo((String)"ASMP GetNext reached end of table.");
                        break block13;
                    }
                    string3 = varBindList2.varbindAt(0);
                    string2 = string3.getName();
                    if (string2.equals(string5)) {
                        AvrSnmpHelper.logError((String)("GetNext returned previous OID (" + string2 + ")."));
                        break block13;
                    }
                    string5 = string2;
                    if (this.isEmptyRow(varBindList2)) {
                        string = this.getInstance(varBindList2.varbindAt(0));
                        AvrSnmpHelper.logError((String)("Found empty row with index=" + string));
                        break block13;
                    }
                    snmpRequest.setNewVarBindList(varBindList2);
                }
                if (n == 2) {
                    AvrSnmpHelper.logInfo((String)"ASMP GetNext reached end of MIB.");
                    break block13;
                }
                if (n != 0) {
                    if (n < 256) {
                        int n2 = snmpRequest.getErrorIndex();
                        string2 = "ASMP GetNext request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n2 + ".";
                        AvrSnmpHelper.logError((String)string2);
                        string2 = AvrSnmpHelper.getErrorStatusMessage((int)snmpRequest.getErrorStatus());
                        throw new ExceptionSnmpRequestFailed(string2, snmpRequest.getErrorStatus(), n2);
                    }
                    string3 = "ASMP GetNext request failed. AsmpStatus=" + n + " " + AsmpErrorStatus.getErrorStatusMessage((int)n) + ".";
                    AvrSnmpHelper.logError((String)string3);
                    string3 = AvrSnmpHelper.getErrorStatusMessage((int)n);
                    throw new ExceptionAsmpRequestFailed(string3, n);
                }
                if (snmpRequest.getErrorStatus() != 0) {
                    int n3 = snmpRequest.getErrorIndex();
                    string2 = "ASMP GetNext request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + "), ErrorIndex=" + n3 + ".";
                    AvrSnmpHelper.logError((String)string2);
                    string2 = AvrSnmpHelper.getErrorStatusMessage((int)snmpRequest.getErrorStatus());
                    throw new ExceptionSnmpRequestFailed(string2, snmpRequest.getErrorStatus(), n3);
                }
                string3 = "ASMP GetNext request failed. AsmpStatus=" + n + ", SnmpStatus=" + snmpRequest.getErrorStatus() + " (" + snmpRequest.getErrorStatusMessage() + ".";
                AvrSnmpHelper.logError((String)string3);
                string3 = AvrSnmpHelper.getErrorStatusMessage((int)n);
                throw new ExceptionRequestFailed(string3);
            }
            catch (Exception exception) {
                AvrSnmpHelper.logError((String)exception.getMessage(), (Exception)exception);
                String string6 = exception.getMessage();
                if (string6 == null || string6.trim().length() == 0) {
                    string6 = MessageFormat.format(res.getString("AvrSnmpHelper_Request_Failed_ASMP_communications"), APPLIANCE);
                    throw new ExceptionRequestFailed(string6);
                }
                throw exception;
            }
        }
        return string;
    }

    protected String getEmptyRowFieldId(String string) throws ExceptionInvalidArgument {
        String string2 = null;
        if (string.indexOf("dsManagerTable") != -1) {
            string2 = "avocent.ds.dsManagement.dsSnmp.dsManagerTable.dsManagerTableEntry.dsManagerTableIPAddress";
        } else if (string.indexOf("dsTrapHostTable") != -1) {
            string2 = "avocent.ds.dsManagement.dsSnmp.dsTrapHostTable.dsTrapHostTableEntry.dsTrapHostTableIPAddress";
        } else {
            String string3 = "The table for identifier=" + string + " is not " + "supported by the getEmptyRowFieldId method.";
            AvrSnmpHelper.logError((String)string3);
            string3 = res.getString("AvrSnmpHelper_Req_Failed_internal");
            throw new ExceptionInvalidArgument(string3);
        }
        return string2;
    }

    protected Object getEmptyRowFieldValue(String string) throws ExceptionInvalidArgument {
        String string2 = null;
        if (string.indexOf("dsManagerTable") != -1) {
            string2 = "0.0.0.0";
        } else if (string.indexOf("dsTrapHostTable") != -1) {
            string2 = "0.0.0.0";
        } else {
            String string3 = "The table for identifier=" + string + " is not " + "supported by the getEmptyRowFieldValue method.";
            AvrSnmpHelper.logError((String)string3);
            string3 = res.getString("AvrSnmpHelper_Req_Failed_internal");
            throw new ExceptionInvalidArgument(string3);
        }
        return string2;
    }

    public static AvrSnmpHelper getInstance() {
        return m_ashSingleton;
    }

    public static AvrRipInfo[] getRipInfo(AsmpConnection asmpConnection) throws ExceptionRequestFailed {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("avocent.ds.dsManagement.dsServer.dsMibMajorVersion.0");
            InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(asmpConnection, arrayList.toArray());
            int n = interfaceValueObjectArray[0].getInteger();
            arrayList.clear();
            arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableIndex");
            arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableInputPort");
            arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipId");
            arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipType");
            arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipStatus");
            arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableSwitchDetected");
            if (n < 2) {
                arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableKeyboardLayout");
            }
            InterfaceValueObject[][] interfaceValueObjectArray2 = AvrSnmpHelper.getTableValues(asmpConnection, arrayList.toArray());
            AvrRipInfo[] avrRipInfoArray = new AvrRipInfo[interfaceValueObjectArray2.length];
            for (int i = 0; i < avrRipInfoArray.length; ++i) {
                int n2 = ((SnmpValueObject)interfaceValueObjectArray2[i][0]).getInteger();
                int n3 = ((SnmpValueObject)interfaceValueObjectArray2[i][1]).getInteger();
                int n4 = ((SnmpValueObject)interfaceValueObjectArray2[i][5]).getInteger();
                boolean bl = n4 == 2;
                String string = "";
                if (n < 2) {
                    string = interfaceValueObjectArray2[i][6].toString();
                }
                avrRipInfoArray[i] = new AvrRipInfo(n2, n3, interfaceValueObjectArray2[i][2].toString(), interfaceValueObjectArray2[i][3].toString(), interfaceValueObjectArray2[i][4].toString(), string, bl, interfaceValueObjectArray2[i][2].toString());
            }
            return avrRipInfoArray;
        }
        catch (Exception exception) {
            AvrSnmpHelper.logError((String)":getRipInfo: Error occured retrieving RIP information.", (Exception)exception);
            throw new ExceptionRequestFailed();
        }
    }

    public static AvrServerInfo[] getServerInfo(AsmpConnection asmpConnection) throws ExceptionRequestFailed {
        try {
            Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableIndex", "avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableRipId", "avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableSwitchChannel", "avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableServerName"};
            InterfaceValueObject[][] interfaceValueObjectArray = AvrSnmpHelper.getTableValues(asmpConnection, objectArray);
            AvrServerInfo[] avrServerInfoArray = new AvrServerInfo[interfaceValueObjectArray.length];
            for (int i = 0; i < avrServerInfoArray.length; ++i) {
                int n = ((SnmpValueObject)interfaceValueObjectArray[i][0]).getInteger();
                int n2 = ((SnmpValueObject)interfaceValueObjectArray[i][2]).getInteger();
                boolean bl = n2 != 0;
                avrServerInfoArray[i] = new AvrServerInfo(n, interfaceValueObjectArray[i][1].toString(), n2, interfaceValueObjectArray[i][3].toString(), bl);
            }
            return avrServerInfoArray;
        }
        catch (Exception exception) {
            AvrSnmpHelper.logError((String)":getServerInfo: Error occured retrieving server information.", (Exception)exception);
            throw new ExceptionRequestFailed();
        }
    }
}

