/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.avr.JPanelLicensedOptions;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.components.JTextFieldAvocent;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class JDialogAddLicense
extends JDialogCentered {
    public static final String CNAME = "JDialogAddLicense";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    private static final String TRACE_CONTEXT = "JDialogAddLicense";
    private static final int VALID_KEY_LENGTH = 20;
    private AmpController m_acController = null;
    private JPanelLicensedOptions m_jPanelParent;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel m_jpButtonPanel = new JPanel();
    JButton m_jbOk = new JButton();
    JButton m_jbCancel = new JButton();
    JButton m_jbHelp = new JButton();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel m_jpLicensePanel = new JPanel();
    JLabel[] m_jlDash;
    JTextFieldAvocent[] m_jtfLicense;
    int m_nSegmentNum;
    int m_nSegmentLen;
    int m_nValidKeyLength;

    public JDialogAddLicense(JPanelLicensedOptions jPanelLicensedOptions, AmpController ampController) throws ExceptionConstructorFailed {
        super((Frame)jPanelLicensedOptions.getParentFrame(), true);
        try {
            this.m_jPanelParent = jPanelLicensedOptions;
            this.m_acController = ampController;
            this.m_nSegmentNum = AVWorksBranding.getInteger((String)"LicensedOptionsKeySegments", (int)5);
            this.m_nSegmentLen = AVWorksBranding.getInteger((String)"LicensedOptionsKeyLength", (int)4);
            this.m_nValidKeyLength = this.m_nSegmentNum * this.m_nSegmentLen;
            this.m_jpLicensePanel.setLayout(new GridBagLayout());
            this.m_jlDash = new JLabel[this.m_nSegmentNum - 1];
            for (int i = 0; i < this.m_nSegmentNum - 1; ++i) {
                this.m_jlDash[i] = new JLabel();
                this.m_jlDash[i].setText("-");
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 1, 5, 1), 0, 0);
            this.m_jtfLicense = new JTextFieldAvocent[this.m_nSegmentNum];
            for (int i = 0; i < this.m_nSegmentNum; ++i) {
                this.m_jtfLicense[i] = new JTextFieldAvocent();
                this.m_jtfLicense[i].setColumns(5);
                AbstractDocument abstractDocument = (AbstractDocument)this.m_jtfLicense[i].getDocument();
                abstractDocument.addDocumentListener(new LicenseDocListener(i));
                abstractDocument.setDocumentFilter(new DocumentSizeFilter(this.m_nSegmentLen));
                this.m_jpLicensePanel.add((Component)this.m_jtfLicense[i], gridBagConstraints);
                if (i >= this.m_nSegmentNum - 1) continue;
                this.m_jpLicensePanel.add((Component)this.m_jlDash[i], gridBagConstraints2);
            }
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)"JDialogAddLicense", (String)("Constructor failed with exception: " + exception.getMessage()), (Throwable)exception);
            throw new ExceptionConstructorFailed(exception.getMessage());
        }
    }

    private void jbInit() throws Exception {
        Border border = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
        TitledBorder titledBorder = new TitledBorder(border, res.getString("JDialogAddLicense_License_Key"));
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.m_jbOk.setText(res.getString("JDialogAddLicense_OK"));
        this.m_jbOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogAddLicense.this.m_jbOk_actionPerformed();
            }
        });
        this.m_jbCancel.setText(res.getString("JDialogAddLicense_Cancel"));
        this.m_jbCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogAddLicense.this.m_jbCancel_actionPerformed();
            }
        });
        this.m_jbHelp.setText(res.getString("JDialogAddLicense_Help"));
        this.m_jbHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogAddLicense.this.m_jbHelp_actionPerformed(actionEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                JDialogAddLicense.this.thisKeyPressed(keyEvent);
            }
        });
        this.m_jpButtonPanel.setLayout(this.gridBagLayout2);
        this.setModal(true);
        this.setTitle(res.getString("JDialogAddLicense_Enter_Key"));
        this.setResizable(false);
        this.m_jpLicensePanel.setAlignmentY(0.5f);
        this.m_jpLicensePanel.setAlignmentX(0.5f);
        this.m_jpLicensePanel.setBorder(titledBorder);
        this.getContentPane().add((Component)this.m_jpButtonPanel, new GridBagConstraints(-1, 1, 0, 1, 1.0, 1.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_jpButtonPanel.add((Component)this.m_jbOk, new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_jpButtonPanel.add((Component)this.m_jbCancel, new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_jpButtonPanel.add((Component)this.m_jbHelp, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.m_jpLicensePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void showAdd() {
        Trace.logInfo((String)"JDialogAddLicense", (String)("show called for \"" + this.getTitle() + "\"."));
        ButtonPanel.equalize((JPanel)this.m_jpButtonPanel);
        this.pack();
        for (int i = 0; i < this.m_nSegmentNum; ++i) {
            this.m_jtfLicense[i].setText("");
        }
        this.m_jtfLicense[0].requestFocus();
        this.setLocationRelativeTo((Component)this.m_acController.getMainFrame());
        this.getRootPane().setDefaultButton(this.m_jbOk);
        this.setVisible(true);
    }

    void m_jbHelp_actionPerformed(ActionEvent actionEvent) {
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.nmm.avr.Help");
            Trace.logInfo((String)"Help", (String)"Successfully loaded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.nmm.avr.Help");
        }
        BrowserHelper.showHelpPage((JFrame)((JFrame)this.getOwner()), (String)resourceBundle.getString("IDH_ENTER_LICENSE"));
    }

    void m_jbCancel_actionPerformed() {
        Trace.logInfo((String)"JDialogAddLicense", (String)("Cancel button pressed for \"" + this.getTitle() + "\"."));
        this.setVisible(false);
    }

    void m_jbOk_actionPerformed() {
        Trace.logInfo((String)"JDialogAddLicense", (String)("OK button pressed for \"" + this.getTitle() + "\"."));
        try {
            StringBuffer stringBuffer = new StringBuffer(this.m_nValidKeyLength);
            for (int i = 0; i < this.m_nSegmentNum; ++i) {
                stringBuffer.append(this.m_jtfLicense[i].getText());
            }
            String string = stringBuffer.toString();
            Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsKey.0"};
            Object[] objectArray2 = new Object[]{string};
            AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), objectArray, objectArray2);
            this.setVisible(false);
            Message.show((Component)((Object)this.m_jPanelParent), (String)res.getString("JDialogAddLicense_add_license_successful"));
        }
        catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
            this.showErrorMessage(exceptionSnmpRequestFailed.getMessage());
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.showErrorMessage(exceptionAsmpRequestFailed.getMessage());
        }
        catch (Exception exception) {
            this.showErrorMessage(exception.getMessage());
        }
    }

    private void showErrorMessage(String string) {
        Trace.logError((String)"JDialogAddLicense", (String)string);
        String string2 = res.getString("JDialogAddLicense_key_add_failed");
        Message.show((Component)((Object)this), (String)(string2 + " " + string));
        this.m_jtfLicense[0].requestFocus();
    }

    private void validateKey(String string) throws ExceptionInvalidArgument {
        if (string.length() != 20) {
            Object[] objectArray = new Object[]{String.valueOf(20)};
            String string2 = MessageFormat.format(res.getString("JDialogAddLicense_key_len0"), objectArray);
            throw new ExceptionInvalidArgument(string2);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = Character.toUpperCase(string.charAt(i));
            if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            Trace.logInfo((String)"JDialogAddLicense", (String)"validation on key failed, char is not a number or letter");
            throw new ExceptionInvalidArgument(res.getString("JDialogAddLicense_invalid_key"));
        }
    }

    private void thisKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (!(keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isShiftDown() || n != 27)) {
            Trace.logInfo((String)"JDialogAddLicense", (String)("<ESC> key pressed. \"" + this.getTitle() + "\" hiding dialog."));
            this.setVisible(false);
        }
    }

    private class DocumentSizeFilter
    extends DocumentFilter {
        int maxCharacters;

        public DocumentSizeFilter(int n) {
            this.maxCharacters = n;
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(filterBypass, n, this.filter(filterBypass, string, 0), attributeSet);
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            super.replace(filterBypass, n, n2, this.filter(filterBypass, string, n2), attributeSet);
        }

        private String filter(DocumentFilter.FilterBypass filterBypass, String string, int n) {
            int n2;
            int n3 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                char c = string.charAt(n2);
                if (!Character.isLetterOrDigit(c)) continue;
                stringBuffer.append(c);
            }
            string = stringBuffer.toString().toUpperCase();
            n2 = this.maxCharacters - filterBypass.getDocument().getLength() + n;
            return string.length() > n2 ? string.substring(0, n2) : string;
        }
    }

    class LicenseDocListener
    implements DocumentListener {
        private int index;

        public LicenseDocListener(int n) {
            this.index = n;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            if (document.getLength() == JDialogAddLicense.this.m_nSegmentLen) {
                for (int i = this.index + 1; i < JDialogAddLicense.this.m_nSegmentNum; ++i) {
                    if (JDialogAddLicense.this.m_jtfLicense[i].getText().length() >= JDialogAddLicense.this.m_nSegmentLen) continue;
                    JDialogAddLicense.this.m_jtfLicense[i].requestFocusInWindow();
                    return;
                }
                JDialogAddLicense.this.m_jbOk.requestFocus();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
        }
    }
}

