/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrDatabaseHelper;
import com.avocent.avworks.nmm.avr.AvrSwitchInfo;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.avworks.services.ConnectionPath;
import com.avocent.avworks.services.ProductInfo;
import com.avocent.avworks.services.ProductsDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.components.JComboBoxAvocent;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.renderers.NameValue;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class JDialogCascadeSwitch
extends JDialogCentered {
    public static final String CNAME = "JDialogCascadeSwitch";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    JPanel panel1 = new JPanel();
    JLabel jLabelSwitchName = new JLabel();
    JLabel jLabelSwitchType = new JLabel();
    JTextField jTextFieldSwitchName = new JTextField();
    JComboBoxAvocent jComboBoxSwitchType = new JComboBoxAvocent();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanelButtons = new JPanel();
    JButton jButtonCancel = new JButton();
    JButton jButtonOK = new JButton();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel jPanelDivider = new JPanel();
    private int m_nApplianceID;
    private int m_nProductID;
    private AvrSwitchInfo m_dsswitchinfo;
    private boolean m_bOkPressed = false;
    private String m_szOrigionalName = "";
    private int m_nOrigionalSwitchType = 0;
    private JFrame m_mainFrame;
    String[] m_aszExisting;
    JButton jButtonHelp = new JButton();
    private CascadeSwitchFilter m_switchFilter = new DefaultCascadeSwitchFilter();

    public JDialogCascadeSwitch(Dialog dialog, int n, int n2, AvrSwitchInfo avrSwitchInfo, String[] stringArray) throws ExceptionConstructorFailed {
        super(dialog, "", true);
        this.m_mainFrame = (JFrame)dialog.getParent();
        this.initialize(n, n2, avrSwitchInfo, stringArray);
    }

    public JDialogCascadeSwitch(Frame frame, int n, int n2, AvrSwitchInfo avrSwitchInfo, String[] stringArray) throws ExceptionConstructorFailed {
        super(frame, "", true);
        this.m_mainFrame = (JFrame)frame;
        this.initialize(n, n2, avrSwitchInfo, stringArray);
    }

    private void initialize(int n, int n2, AvrSwitchInfo avrSwitchInfo, String[] stringArray) throws ExceptionConstructorFailed {
        try {
            Object object;
            Serializable serializable;
            String string;
            Trace.logInfo((String)"CascadeSwitchDialog", (String)"Initializing");
            this.m_dsswitchinfo = avrSwitchInfo;
            this.m_nApplianceID = n;
            this.m_nProductID = n2;
            if (stringArray == null) {
                this.m_aszExisting = new String[0];
            } else {
                this.m_aszExisting = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.m_aszExisting[i] = ConnectionPath.parseSwitchName((String)stringArray[i]);
                }
            }
            String string2 = AVWorksBranding.getCascadeSwitchName((boolean)true);
            Object[] objectArray = new Object[]{string2};
            this.jbInit();
            this.getRootPane().setDefaultButton(this.jButtonOK);
            ButtonPanel.equalize((JPanel)this.jPanelButtons);
            this.jTextFieldSwitchName.requestFocus();
            if (avrSwitchInfo == null) {
                Trace.logInfo((String)"CascadeSwitchDialog", (String)"This is an Add dialog");
                string = MessageFormat.format(res.getString("JDialogCascadeSwitch_Add_1"), objectArray);
            } else {
                Trace.logInfo((String)"CascadeSwitchDialog", (String)"This is a Modify dialog");
                this.m_szOrigionalName = avrSwitchInfo.getSwitchName();
                this.m_szOrigionalName = ConnectionPath.parseSwitchName((String)avrSwitchInfo.getSwitchName());
                this.jTextFieldSwitchName.setText(this.m_szOrigionalName);
                this.m_nOrigionalSwitchType = avrSwitchInfo.getSwitchType();
                Trace.logInfo((String)"CascadeSwitchDialog", (String)("Origional SwitchName=" + this.m_szOrigionalName));
                Trace.logInfo((String)"CascadeSwitchDialog", (String)("Origional SwitchType=" + this.m_nOrigionalSwitchType));
                string = MessageFormat.format(res.getString("JDialogCascadeSwitch_Modify_1"), objectArray);
            }
            this.setTitle(string);
            NameValue nameValue = null;
            String string3 = AVWorksBranding.getCascadeSwitchFilterClass();
            if (string3 != null) {
                try {
                    serializable = Class.forName(string3);
                    this.m_switchFilter = (CascadeSwitchFilter)((Class)serializable).newInstance();
                }
                catch (Exception exception) {
                    object = "CascadeSwitchFilter " + string3 + " cannot be instantiated: using default";
                    Trace.logError((String)"CascadeSwitchDialog", (String)object, (Throwable)exception);
                }
            }
            serializable = new Vector();
            object = ProductsDb.getProductList();
            for (int i = 0; i < ((ProductInfo[])object).length; ++i) {
                if (!AvrDatabaseHelper.isCascadeSwitch(object[i].getID()) || !object[i].isEnabled() || !this.m_switchFilter.includeSwitch(object[i])) continue;
                String string4 = object[i].getName();
                Trace.logInfo((String)"CascadeSwitchDialog", (String)("Adding Switch Type " + string4));
                Integer n3 = new Integer(object[i].getID());
                NameValue nameValue2 = new NameValue(string4, (Object)n3);
                ((Vector)serializable).add(nameValue2);
                if (this.m_nOrigionalSwitchType != n3) continue;
                nameValue = nameValue2;
            }
            if (((Vector)serializable).size() > 0) {
                Comparator comparator = new Comparator(){

                    public int compare(Object object, Object object2) {
                        try {
                            if (object instanceof NameValue && object2 instanceof NameValue) {
                                NameValue nameValue = (NameValue)object;
                                NameValue nameValue2 = (NameValue)object2;
                                if (nameValue.getValue() instanceof Integer && nameValue2.getValue() instanceof Integer) {
                                    int n;
                                    int n2;
                                    int n3 = (Integer)nameValue.getValue();
                                    int n4 = (Integer)nameValue2.getValue();
                                    int n5 = AvrDatabaseHelper.getSwitchUserCount(n3);
                                    if (n5 < (n2 = AvrDatabaseHelper.getSwitchUserCount(n4))) {
                                        return -1;
                                    }
                                    if (n5 > n2) {
                                        return 1;
                                    }
                                    int n6 = AvrDatabaseHelper.getSwitchPortCount(n3);
                                    if (n6 < (n = AvrDatabaseHelper.getSwitchPortCount(n4))) {
                                        return -1;
                                    }
                                    if (n6 == n) {
                                        return 0;
                                    }
                                    return 1;
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return 0;
                    }

                    public boolean equals(Object object) {
                        return object == this;
                    }
                };
                Collections.sort(serializable, comparator);
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    this.jComboBoxSwitchType.addItem(((Vector)serializable).elementAt(i));
                }
            }
            if (nameValue == null) {
                this.jComboBoxSwitchType.setSelectedIndex(0);
            } else {
                this.jComboBoxSwitchType.setSelectedItem(nameValue);
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"CascadeSwitchDialog", (String)"Failed to initialize dialog", (Throwable)exception);
            throw new ExceptionConstructorFailed();
        }
        this.pack();
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout1);
        this.jLabelSwitchName.setText(res.getString("JDialogCascadeSwitch_Name_"));
        this.jLabelSwitchType.setText(res.getString("JDialogCascadeSwitch_Type_"));
        this.jButtonCancel.setText(res.getString("JDialogCascadeSwitch_Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogCascadeSwitch.this.jButtonCancel_actionPerformed(actionEvent);
            }
        });
        this.jButtonOK.setText(res.getString("JDialogCascadeSwitch_OK"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogCascadeSwitch.this.jButtonOK_actionPerformed(actionEvent);
            }
        });
        this.jPanelButtons.setLayout(this.gridBagLayout2);
        this.jPanelDivider.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelDivider.setMinimumSize(new Dimension(14, 2));
        this.jPanelDivider.setPreferredSize(new Dimension(14, 2));
        this.setResizable(false);
        this.jButtonHelp.setText(res.getString("JDialogCascadeSwitch_Help"));
        this.jButtonHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogCascadeSwitch.this.jButtonHelp_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jLabelSwitchName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.panel1.add((Component)this.jLabelSwitchType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 11, 0), 0, 0));
        this.panel1.add((Component)this.jTextFieldSwitchName, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(12, 12, 0, 11), 150, 0));
        this.panel1.add((Component)this.jComboBoxSwitchType, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.5, 18, 2, new Insets(12, 12, 11, 11), 0, 0));
        this.panel1.add((Component)this.jPanelButtons, new GridBagConstraints(0, 3, 2, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonOK, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 13, 0, new Insets(12, 12, 11, 0), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 12, 11, 0), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonHelp, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 12, 11, 11), 0, 0));
        this.panel1.add((Component)this.jPanelDivider, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 0, 11), 0, 0));
    }

    void jButtonOK_actionPerformed(ActionEvent actionEvent) {
        try {
            Trace.logInfo((String)"CascadeSwitchDialog", (String)"OK pressed");
            String string = this.jTextFieldSwitchName.getText().trim();
            Trace.logInfo((String)"CascadeSwitchDialog", (String)("New SwitchName=" + string));
            if (string.length() == 0 || string.length() > 32) {
                String string2 = res.getString("JDialogCascadeSwitch_Name_invalid_length");
                Message.show((Component)((Object)this), (String)string2);
                this.jTextFieldSwitchName.grabFocus();
                return;
            }
            for (int i = 0; i < this.m_aszExisting.length; ++i) {
                if (this.m_aszExisting[i].equalsIgnoreCase(this.m_szOrigionalName) || !this.m_aszExisting[i].equalsIgnoreCase(string)) continue;
                String string3 = res.getString("JDialogCascadeSwitch_Name_invalid_exists");
                Message.show((Component)((Object)this), (String)string3);
                this.jTextFieldSwitchName.grabFocus();
                return;
            }
            NameValue nameValue = (NameValue)this.jComboBoxSwitchType.getSelectedItem();
            if (nameValue == null) {
                String string4 = res.getString("JDialogCascadeSwitch_SwitchType_Invalid");
                Message.show((Component)((Object)this), (String)string4);
                this.jComboBoxSwitchType.grabFocus();
                return;
            }
            String string5 = nameValue.getName();
            Integer n = (Integer)nameValue.getValue();
            int n2 = n;
            Trace.logInfo((String)"CascadeSwitchDialog", (String)("New SwitchTypeName=" + string5));
            Trace.logInfo((String)"CascadeSwitchDialog", (String)("New SwitchType=" + n2));
            string = this.m_nApplianceID + ":" + string;
            if (this.m_dsswitchinfo == null) {
                Trace.logInfo((String)"CascadeSwitchDialog", (String)"Add - New SwitchInfo");
                this.m_dsswitchinfo = new AvrSwitchInfo(string, string5, n2, 0, new String[0]);
            } else {
                String[] stringArray;
                Object[] objectArray;
                Object[] objectArray2;
                String[] stringArray2;
                Trace.logInfo((String)"CascadeSwitchDialog", (String)"Modifying - Existing SwitchInfo");
                this.m_dsswitchinfo.setSwitchName(string);
                this.m_dsswitchinfo.setSwitchType(string5);
                this.m_dsswitchinfo.setSwitchType(n2);
                int n3 = AvrDatabaseHelper.getSwitchUserCount(this.m_nOrigionalSwitchType);
                int n4 = AvrDatabaseHelper.getSwitchUserCount(n2);
                if (n4 < n3 && (stringArray2 = this.m_dsswitchinfo.getAttachedRipIDs()).length > n4) {
                    String string6 = AVWorksBranding.getDsrIqName((boolean)false);
                    objectArray2 = new Object[]{string6};
                    objectArray = MessageFormat.format(res.getString("JDialogCascadeSwitch_UserPorts_Decreased"), objectArray2);
                    Message.show((Component)((Object)this), (String)objectArray);
                    stringArray = new String[n4];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = stringArray2[i];
                    }
                    this.m_dsswitchinfo.setAttachedRipIDs(stringArray);
                }
                int n5 = AvrDatabaseHelper.getSwitchPortCount(this.m_nOrigionalSwitchType);
                int n6 = AvrDatabaseHelper.getSwitchPortCount(n2);
                if (n6 < n5) {
                    objectArray2 = AVWorksBranding.getServerName((boolean)false);
                    objectArray = new Object[]{objectArray2};
                    stringArray = MessageFormat.format(res.getString("JDialogCascadeSwitch_Channels_Decreased"), objectArray);
                    Message.show((Component)((Object)this), (String)stringArray);
                }
            }
            this.m_bOkPressed = true;
            this.dispose();
        }
        catch (Exception exception) {
            String string = AVWorksBranding.getCascadeSwitchName((boolean)true);
            Object[] objectArray = new Object[]{string};
            Message.show((Component)((Object)this), (String)MessageFormat.format(res.getString("JDialogCascadeSwitch_Invalid_Configuration"), objectArray));
        }
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        this.cancelDialog();
    }

    private void cancelDialog() {
        this.dispose();
    }

    public boolean wasOkPressed() {
        return this.m_bOkPressed;
    }

    public AvrSwitchInfo getSwitchInfo() throws ExceptionNoValue {
        if (this.m_dsswitchinfo == null) {
            throw new ExceptionNoValue();
        }
        return this.m_dsswitchinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Trace.startLogging(null);
        try {
            AVWorksService.start();
            String[] stringArray2 = new String[]{"SW1", "SW2"};
            Trace.logInfo((String)"CascadeSwitchDialog", (String)"Displaying Add dialog");
            JDialogCascadeSwitch jDialogCascadeSwitch = new JDialogCascadeSwitch((Frame)null, 2, 0, null, stringArray2);
            jDialogCascadeSwitch.show();
            if (jDialogCascadeSwitch.wasOkPressed()) {
                Trace.logInfo((String)"CascadeSwitchDialog", (String)"OK pressed on Add dialog");
                AvrSwitchInfo avrSwitchInfo = jDialogCascadeSwitch.getSwitchInfo();
                Trace.logInfo((String)"CascadeSwitchDialog", (String)("Name" + avrSwitchInfo.getSwitchName()));
                Trace.logInfo((String)"CascadeSwitchDialog", (String)("Type" + avrSwitchInfo.getSwitchType()));
                Trace.logInfo((String)"CascadeSwitchDialog", (String)("ID=" + avrSwitchInfo.getSwitchID()));
                Trace.logInfo((String)"CascadeSwitchDialog", (String)("ProdType=" + avrSwitchInfo.getSwitchTypeStr()));
                String string = avrSwitchInfo.getSwitchName();
                String[] stringArray3 = new String[]{"SW1", "SW2", string};
                JDialogCascadeSwitch jDialogCascadeSwitch2 = new JDialogCascadeSwitch((Frame)null, 2, 0, avrSwitchInfo, stringArray3);
                jDialogCascadeSwitch2.show();
                if (jDialogCascadeSwitch2.wasOkPressed()) {
                    Trace.logInfo((String)"CascadeSwitchDialog", (String)"OK pressed on Modify dialog");
                    AvrSwitchInfo avrSwitchInfo2 = jDialogCascadeSwitch2.getSwitchInfo();
                    Trace.logInfo((String)"CascadeSwitchDialog", (String)("Name" + avrSwitchInfo2.getSwitchName()));
                    Trace.logInfo((String)"CascadeSwitchDialog", (String)("Type" + avrSwitchInfo2.getSwitchType()));
                    Trace.logInfo((String)"CascadeSwitchDialog", (String)("ID=" + avrSwitchInfo2.getSwitchID()));
                    Trace.logInfo((String)"CascadeSwitchDialog", (String)("ProdType=" + avrSwitchInfo2.getSwitchTypeStr()));
                }
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"CascadeSwitchDialog", (String)"Unit Test Error");
        }
        finally {
            AVWorksService.shutdown();
        }
        System.exit(0);
    }

    void jButtonHelp_actionPerformed(ActionEvent actionEvent) {
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.nmm.avr.Help");
            Trace.logInfo((String)"Help", (String)"Successfully loaded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.nmm.avr.Help");
        }
        BrowserHelper.showHelpPage((JFrame)this.m_mainFrame, (String)resourceBundle.getString("IDH_ADD_MODIFY_CASCADE_SWITCH"));
    }

    private class DellCascadeSwitchFilter
    implements CascadeSwitchFilter {
        private boolean m_bVendorSupport = false;
        int[] nDellCascadeList = new int[]{9, 15, 19};
        int[] nAllCascadeList = new int[]{8, 9, 10, 11, 13, 14, 15, 16, 18, 19};

        public DellCascadeSwitchFilter() {
            this.m_bVendorSupport = AVWorksBranding.getInteroperabilityFeature();
        }

        public boolean includeSwitch(ProductInfo productInfo) {
            int[] nArray = new int[]{};
            int n = 0;
            if (this.m_bVendorSupport) {
                nArray = this.nAllCascadeList;
                n = this.nAllCascadeList.length;
            } else {
                nArray = this.nDellCascadeList;
                n = this.nDellCascadeList.length;
            }
            for (int i = 0; i < n; ++i) {
                if (productInfo.getID() != nArray[i]) continue;
                return true;
            }
            return false;
        }
    }

    private class DefaultCascadeSwitchFilter
    implements CascadeSwitchFilter {
        private DefaultCascadeSwitchFilter() {
        }

        public boolean includeSwitch(ProductInfo productInfo) {
            return true;
        }
    }

    public static interface CascadeSwitchFilter {
        public boolean includeSwitch(ProductInfo var1);
    }
}

