/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AmpControllerAvr;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.exceptions.ExceptionUserCancelled;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.components.JTextFieldAvocent;
import com.avocent.lib.gui.dialogs.InputStreamProgressMonitoring;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.JDialogPassword;
import com.avocent.lib.gui.dialogs.JDialogProgress;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.dialogs.OutputStreamProgressMonitoring;
import com.avocent.lib.util.PBEIOStreamFactory;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JDialogFileSelection
extends JDialogCentered {
    private static final boolean USE_PBE_ENCRYPTION = true;
    public static final String CNAME = "JDialogFileSelection";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel m_szActionLabel = new JLabel();
    JTextFieldAvocent m_jtfFileName = new JTextFieldAvocent();
    JButton m_jbBrowseButton = new JButton();
    JPanel m_jpButtonPanel = new JPanel();
    JButton m_jbCloseButton = new JButton();
    JButton m_jbHelpButton = new JButton();
    JButton m_jbActionButton = new JButton();
    public static final String TRACE_CONTEXT = "File Selection Dialog";
    public static final int READ = 2;
    public static final int WRITE = 3;
    public static final int ACTION = 1;
    public static final int CLOSE = 2;
    public static final int HELP = 3;
    protected int m_nMode;
    AmpControllerAvr m_acController;
    protected JFileChooser m_jfcFileChooser;
    JDialogProgress m_jdpProgress;
    protected String m_szHelpSystemKey;
    protected int m_nUserSelection;
    protected String m_szFileType;
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    protected File m_fBaseDirectory;
    protected String m_szLocalFileName;
    protected String m_szRemoteFileName;
    protected char[] m_acPassword;
    protected final String m_szConfigFileHeaderPrefix = "DS Config File";
    protected final String m_szUsersFileHeaderPrefix = "DS Users File";
    protected String m_szHeader;
    protected int m_nFileType;

    public JDialogFileSelection() throws ExceptionConstructorFailed {
        super((Frame)null, "", true);
        try {
            this.jbInit();
            this.m_jbActionButton.setEnabled(false);
            this.getRootPane().setDefaultButton(this.m_jbActionButton);
        }
        catch (Exception exception) {
            String string = res.getString("JDialogFileSelection_Unable_to_contstruct");
            Trace.logError((String)TRACE_CONTEXT, (String)string, (Throwable)exception);
            throw new ExceptionConstructorFailed(string);
        }
    }

    public JDialogFileSelection(AmpControllerAvr ampControllerAvr, String string, String string2, int n, int n2, String string3) throws ExceptionConstructorFailed {
        super((Frame)ampControllerAvr.getMainFrame(), "", true);
        this.m_acController = ampControllerAvr;
        try {
            this.jbInit();
            String string4 = res.getString("JDialogFileSelection_Read");
            String string5 = res.getString("JDialogFileSelection_Write");
            if (string4.length() > string5.length()) {
                this.m_jbActionButton.setText(string4);
            } else {
                this.m_jbActionButton.setText(string5);
            }
            ButtonPanel.equalize((JPanel)this.m_jpButtonPanel);
            this.m_jbActionButton.setEnabled(false);
            this.setResizable(false);
            this.m_nFileType = n;
            if (this.m_nFileType == 1) {
                this.m_szFileType = res.getString("JDialogFileSelection_configuration");
            } else if (this.m_nFileType == 2) {
                this.m_szFileType = res.getString("JDialogFileSelection_user_database");
            } else {
                throw new ExceptionConstructorFailed(res.getString("JDialogFileSelection_Invalid_configuration"));
            }
            this.set(string, string2, this.m_nFileType, n2, string3);
            this.setLocationRelativeTo((Component)this.m_acController.getMainFrame());
            Dimension dimension = this.m_jtfFileName.getPreferredSize();
            this.m_jtfFileName.setPreferredSize(new Dimension(325, (int)dimension.getHeight()));
            this.getRootPane().setDefaultButton(this.m_jbActionButton);
            this.m_jtfFileName.requestFocus();
            this.m_jtfFileName.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    JDialogFileSelection.this.m_jbActionButton.setEnabled(documentEvent.getDocument().getLength() > 0);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    JDialogFileSelection.this.m_jbActionButton.setEnabled(documentEvent.getDocument().getLength() > 0);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    JDialogFileSelection.this.m_jbActionButton.setEnabled(documentEvent.getDocument().getLength() > 0);
                }
            });
            this.setDefaultDirectory();
            Thread thread = new Thread("Create File Chooser Thread"){

                public void run() {
                    JDialogFileSelection.this.m_jbBrowseButton.setEnabled(false);
                    JDialogFileSelection.this.setCursor(Cursor.getPredefinedCursor(3));
                    JDialogFileSelection.this.m_jfcFileChooser = new JFileChooser(JDialogFileSelection.this.m_fBaseDirectory);
                    JDialogFileSelection.this.m_jbBrowseButton.setEnabled(true);
                    JDialogFileSelection.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            };
            thread.start();
            this.m_jtfFileName.requestFocus();
            Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
            String string6 = this.m_nFileType == 1 ? (n2 == 3 ? res.getString("JDialogFileSelection_Write_Configuration") : res.getString("JDialogFileSelection_Read_Configuration")) : (n2 == 3 ? res.getString("JDialogFileSelection_Write_User_Database") : res.getString("JDialogFileSelection_Read_User_Database"));
            string6 = MessageFormat.format(string6, objectArray);
            this.m_jdpProgress = new JDialogProgress((Dialog)((Object)this), string6);
        }
        catch (Exception exception) {
            String string7 = res.getString("JDialogFileSelection_Unable_to_contstruct");
            Trace.logError((String)TRACE_CONTEXT, (String)string7, (Throwable)exception);
            throw new ExceptionConstructorFailed(string7);
        }
    }

    private void jbInit() throws Exception {
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.m_szActionLabel.setText(res.getString("JDialogFileSelection_Save_to_"));
        this.m_jbBrowseButton.setText(res.getString("JDialogFileSelection_Browse_"));
        this.m_jbBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogFileSelection.this.m_jbBrowseButton_actionPerformed(actionEvent);
            }
        });
        this.m_jbCloseButton.setText(res.getString("JDialogFileSelection_Close"));
        this.m_jbCloseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogFileSelection.this.m_jbCloseButton_actionPerformed(actionEvent);
            }
        });
        this.m_jbHelpButton.setText(res.getString("JDialogFileSelection_Help"));
        this.m_jbHelpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogFileSelection.this.m_jbHelpButton_actionPerformed(actionEvent);
            }
        });
        this.m_jbActionButton.setText(res.getString("JDialogFileSelection_Read"));
        this.m_jbActionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogFileSelection.this.m_jbActionButton_actionPerformed(actionEvent);
            }
        });
        this.m_jpButtonPanel.setLayout(this.gridBagLayout2);
        this.jPanel1.add((Component)this.m_szActionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 11, 0), 0, 0));
        this.jPanel1.add((Component)this.m_jtfFileName, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 12, 11, 11), 0, 0));
        this.jPanel1.add((Component)this.m_jbBrowseButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 11, 11), 0, 0));
        this.jPanel1.add((Component)this.m_jpButtonPanel, new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_jpButtonPanel.add((Component)this.m_jbActionButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(12, 12, 11, 11), 0, 0));
        this.m_jpButtonPanel.add((Component)this.m_jbCloseButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(12, 0, 11, 11), 0, 0));
        this.m_jpButtonPanel.add((Component)this.m_jbHelpButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(12, 0, 11, 11), 0, 0));
        this.getContentPane().add((Component)this.jPanel1, "Center");
    }

    private void setDefaultDirectory() {
        String string;
        block2: {
            string = null;
            try {
                string = AVWorksService.getDBasePath();
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                string = System.getProperty("user.home");
                if (string != null) break block2;
                string = ".";
            }
        }
        this.m_fBaseDirectory = new File(string);
    }

    public void set(String string, String string2, int n, int n2, String string3) throws ExceptionRequestFailed {
        this.m_szHelpSystemKey = string3;
        this.m_nFileType = n;
        if (this.m_nFileType == 1) {
            this.m_szFileType = res.getString("JDialogFileSelection_configuration");
        } else if (this.m_nFileType == 2) {
            this.m_szFileType = res.getString("JDialogFileSelection_user_database");
        } else {
            throw new ExceptionRequestFailed(res.getString("JDialogFileSelection_Invalid_configuration"));
        }
        this.setTitle(string);
        this.m_szActionLabel.setText(string2);
        if (n2 == 2) {
            this.m_jbActionButton.setText(res.getString("JDialogFileSelection_Read"));
        } else if (n2 == 3) {
            this.m_jbActionButton.setText(res.getString("JDialogFileSelection_Write"));
        } else {
            throw new ExceptionRequestFailed(res.getString("JDialogFileSelection_Invalid_file"));
        }
        this.m_nMode = n2;
        ButtonPanel.equalize((JPanel)this.m_jpButtonPanel);
        this.m_jbActionButton.setEnabled(this.m_jtfFileName.getText().trim().length() > 0);
    }

    void m_jbActionButton_actionPerformed(ActionEvent actionEvent) {
        String string = this.getFileName().trim();
        boolean bl = false;
        String string2 = null;
        if (string.length() == 0) {
            this.m_jtfFileName.requestFocus();
            string2 = this.m_nMode == 2 ? (this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_empty_write_file_name_1") : res.getString("JDialogFileSelection_empty_write_file_name_2")) : (this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_empty_read_file_name_1") : res.getString("JDialogFileSelection_empty_read_file_name_2"));
            Message.show((Component)((Object)this), (String)string2);
        } else {
            boolean bl2 = bl = this.m_nMode == 2 ? this.canWriteFile(string) : this.canReadFile(string);
        }
        if (bl) {
            this.m_nUserSelection = 1;
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JDialogFileSelection.m_jbActionButton_actionPerformed: m_nUserSelection=" + this.m_nUserSelection));
            this.performAction();
        }
    }

    private void performAction() {
        block10: {
            try {
                Object[] objectArray;
                if (this.m_nMode == 3) {
                    this.m_szRemoteFileName = this.m_nFileType == 1 ? "config00.txt" : "user.txt";
                    this.m_szLocalFileName = this.getFileName();
                    this.m_acPassword = this.getPassword();
                    if (this.m_acPassword != null) {
                        WriteThread writeThread = new WriteThread();
                        writeThread.start();
                    }
                    break block10;
                }
                this.m_szHeader = this.m_nFileType == 1 ? "DS Config File created on (" + new Date() + ")" : "DS Users File created on (" + new Date() + ")";
                this.m_szLocalFileName = this.getFileName();
                this.m_acPassword = this.getPassword();
                if (this.m_acPassword == null) {
                    return;
                }
                if (this.m_jdpProgress == null) {
                    String string = this.m_nFileType == 1 ? res.getString("JDialogFileSelection_Read_Configuration") : res.getString("JDialogFileSelection_Read_User_Database");
                    objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
                    string = MessageFormat.format(string, objectArray);
                    this.m_jdpProgress = new JDialogProgress((Dialog)((Object)this), string);
                } else {
                    this.m_jdpProgress.setTitle(this.m_nFileType == 1 ? res.getString("JDialogFileSelection_Read_Configuration") : res.getString("JDialogFileSelection_Read_User_Database"));
                }
                this.m_jdpProgress.setRange(0, 2);
                this.m_jdpProgress.setValue(0);
                this.m_jdpProgress.setStatusMessage(this.getFileStatusMessage());
                this.m_jdpProgress.pack();
                this.m_jdpProgress.setEnableCancelButton(true);
                this.m_jdpProgress.checkCancelButton();
                this.m_jdpProgress.disableParent();
                this.m_jdpProgress.setVisible(true);
                try {
                    int n = this.m_nFileType == 1 ? 2 : 3;
                    objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsCreateNewFileControl.0"};
                    final Object[] objectArray2 = new Object[]{new Integer(n)};
                    Thread thread = new Thread("Send ASMP Read File Request"){

                        public void run() {
                            try {
                                AvrSnmpHelper.set(JDialogFileSelection.this.m_acController.getAsmpConnection(), objectArray, objectArray2);
                                ThreadCreateMonitor threadCreateMonitor = new ThreadCreateMonitor();
                                threadCreateMonitor.start();
                            }
                            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                                if (JDialogFileSelection.this.isShowing()) {
                                    JDialogFileSelection.this.m_jtfFileName.requestFocus();
                                    String string = null;
                                    string = JDialogFileSelection.this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_Unable_to_Read_File_1") : res.getString("JDialogFileSelection_Unable_to_Read_File_2");
                                    Message.show((Component)JDialogFileSelection.this.m_jdpProgress, (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
                                }
                                JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                                JDialogFileSelection.this.m_jdpProgress.setVisible(false);
                                return;
                            }
                            catch (Exception exception) {
                                if (JDialogFileSelection.this.isShowing()) {
                                    JDialogFileSelection.this.m_jtfFileName.requestFocus();
                                    String string = res.getString("JDialogFileSelection_An_error_has_occured1");
                                    JDialogFileSelection.this.m_acController.showException((Window)JDialogFileSelection.this.m_jdpProgress, null, JDialogFileSelection.TRACE_CONTEXT, string, exception);
                                }
                                JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                                JDialogFileSelection.this.m_jdpProgress.setVisible(false);
                                return;
                            }
                        }
                    };
                    thread.start();
                }
                catch (Exception exception) {
                    if (this.isShowing()) {
                        this.m_jtfFileName.requestFocus();
                        objectArray = res.getString("JDialogFileSelection_An_error_has_occured1");
                        this.m_acController.showException((Window)this.m_jdpProgress, null, TRACE_CONTEXT, (String)objectArray, exception);
                    }
                    this.m_jdpProgress.reEnableParent();
                    this.m_jdpProgress.setVisible(false);
                    return;
                }
            }
            catch (Exception exception) {
                if (!this.isShowing()) break block10;
                this.m_jtfFileName.requestFocus();
                this.m_acController.showException((Window)((Object)this), null, TRACE_CONTEXT, res.getString("JDialogFileSelection_Error_reading_user"), exception);
            }
        }
    }

    public char[] getPassword() throws ExceptionInvalidArgument {
        StringBuffer stringBuffer = new StringBuffer();
        int n = JDialogPassword.showDialog((Dialog)((Object)this), (String)res.getString("JDialogFileSelection_Enter_Password"), (StringBuffer)stringBuffer, (this.m_nMode == 2 ? 1 : 0) != 0);
        return n == 0 ? stringBuffer.toString().toCharArray() : null;
    }

    boolean writeFile(String string) throws ExceptionRequestFailed {
        try {
            InputStream inputStream;
            String string2;
            File file = new File(this.m_szLocalFileName);
            if (!file.exists()) {
                String string3 = null;
                string3 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_Unable_to_write_file_1") : res.getString("JDialogFileSelection_Unable_to_write_file_2");
                throw new ExceptionRequestFailed(string3);
            }
            if (!file.canRead()) {
                String string4 = null;
                string4 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_Unable_to_write_file1_1") : res.getString("JDialogFileSelection_Unable_to_write_file1_2");
                throw new ExceptionRequestFailed(string4);
            }
            if (this.m_jdpProgress == null) {
                string2 = this.m_nFileType == 1 ? res.getString("JDialogFileSelection_Write_Configuration") : res.getString("JDialogFileSelection_Write_User_Database");
                this.m_jdpProgress = new JDialogProgress((Dialog)((Object)this), string2);
            } else {
                this.m_jdpProgress.setTitle(this.m_nFileType == 1 ? res.getString("JDialogFileSelection_Write_Configuration") : res.getString("JDialogFileSelection_Write_User_Database"));
            }
            string2 = new InputStreamProgressMonitoring(file, this.m_jdpProgress);
            try {
                inputStream = PBEIOStreamFactory.getInputStream((char[])this.m_acPassword, (InputStream)((Object)string2));
            }
            catch (IOException iOException) {
                if (this.isShowing()) {
                    this.m_jtfFileName.requestFocus();
                    String string5 = null;
                    string5 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_io_error_writing_file_1") : res.getString("JDialogFileSelection_io_error_writing_file_2");
                    Message.show((Component)this.m_jdpProgress, (String)string5);
                }
                return false;
            }
            catch (Throwable throwable) {
                if (this.isShowing()) {
                    this.m_jtfFileName.requestFocus();
                    String string6 = null;
                    string6 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_gen_error_writing_file_1") : res.getString("JDialogFileSelection_gen_error_writing_file_2");
                    Message.show((Component)this.m_jdpProgress, (String)string6);
                }
                return false;
            }
            this.m_jdpProgress.setValue(0);
            this.m_jdpProgress.setRange(0, 2 * this.m_jdpProgress.getUpperLimit());
            this.m_jdpProgress.setStatusMessage(this.getFileTransferMessage());
            this.m_jdpProgress.pack();
            this.m_jdpProgress.checkCancelButton();
            this.m_jdpProgress.setEnableCancelButton(true);
            this.m_jdpProgress.disableParent();
            this.m_jdpProgress.setVisible(true);
            int n = inputStream.read();
            if (n < 0) {
                String string7 = null;
                string7 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_Failed_to_write_file_0_1") : res.getString("JDialogFileSelection_Failed_to_write_file_0_2");
                throw new ExceptionRequestFailed(string7);
            }
            byte[] byArray = new byte[n];
            inputStream.read(byArray, 0, n);
            String string8 = new String(byArray);
            Trace.logInfo((String)TRACE_CONTEXT, (String)(" file header: \"" + string8 + "\""));
            if (this.m_nFileType == 1 && !string8.startsWith("DS Config File") || this.m_nFileType == 2 && !string8.startsWith("DS Users File")) {
                String string9 = null;
                string9 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_Failed_to_write_file_0_1") : res.getString("JDialogFileSelection_Failed_to_write_file_0_2");
                throw new ExceptionRequestFailed(string9);
            }
            long l = file.length() - 1L - (long)n - 8L;
            AvrSnmpHelper.sendFile(this.m_acController.getAsmpConnection().getAsmpSession(), inputStream, l, string);
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            if (this.isShowing()) {
                this.m_jtfFileName.requestFocus();
                String string10 = null;
                string10 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_Unable_to_Write_File_1") : res.getString("JDialogFileSelection_Unable_to_Write_File_2");
                Message.show((Component)this.m_jdpProgress, (String)(string10 + " " + exceptionAsmpRequestFailed.getMessage()));
            }
            this.m_jdpProgress.reEnableParent();
            this.m_jdpProgress.setVisible(false);
        }
        catch (ExceptionUserCancelled exceptionUserCancelled) {
            this.m_jdpProgress.reEnableParent();
            this.m_jdpProgress.setVisible(false);
        }
        catch (Exception exception) {
            if (this.isShowing()) {
                this.m_jtfFileName.requestFocus();
                String string11 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_Error_while_sending_1") : res.getString("JDialogFileSelection_Error_while_sending_2");
                this.m_acController.showException((Window)this.m_jdpProgress, null, TRACE_CONTEXT, string11, exception);
            }
            this.m_jdpProgress.reEnableParent();
            this.m_jdpProgress.setVisible(false);
        }
        return false;
    }

    boolean loadFile(String string) {
        try {
            Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsLoadFileName.0", "avocent.ds.dsManagement.dsServer.dsLoadFileControl.0"};
            int n = this.m_nFileType == 1 ? 2 : 3;
            Object[] objectArray2 = new Object[]{string, new Integer(n)};
            AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), objectArray, objectArray2);
            ThreadLoadingMonitor threadLoadingMonitor = new ThreadLoadingMonitor();
            threadLoadingMonitor.start();
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            if (this.isShowing()) {
                this.m_jtfFileName.requestFocus();
                String string2 = null;
                string2 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_Unable_to_Write_File_1") : res.getString("JDialogFileSelection_Unable_to_Write_File_2");
                Message.show((Component)this.m_jdpProgress, (String)(string2 + " " + exceptionAsmpRequestFailed.getMessage()));
            }
            this.m_jdpProgress.reEnableParent();
            this.m_jdpProgress.setVisible(false);
            return false;
        }
        catch (Exception exception) {
            if (this.isShowing()) {
                this.m_jtfFileName.requestFocus();
                Message.show((Component)this.m_jdpProgress, (String)(res.getString("JDialogFileSelection_An_error_has_occured") + exception.getMessage()));
            }
            this.m_jdpProgress.reEnableParent();
            this.m_jdpProgress.setVisible(false);
            return false;
        }
    }

    void readFile(String string) {
        try {
            File file = new File(this.m_szLocalFileName);
            long l = AvrSnmpHelper.getRemoteFileSize(this.m_acController.getAsmpConnection().getAsmpSession(), string);
            if (l == 0L) {
                l = 8192L;
            }
            this.m_jdpProgress.setRange(0, (int)(2L * l));
            this.m_jdpProgress.setValue(this.m_jdpProgress.getUpperLimit() / 2);
            OutputStreamProgressMonitoring outputStreamProgressMonitoring = new OutputStreamProgressMonitoring(file, l, this.m_jdpProgress);
            OutputStream outputStream = PBEIOStreamFactory.getOutputStream((char[])this.m_acPassword, (OutputStream)outputStreamProgressMonitoring);
            byte[] byArray = this.m_szHeader.getBytes();
            outputStream.write(byArray.length);
            outputStream.write(byArray);
            AvrSnmpHelper.retrieveFile(this.m_acController.getAsmpConnection().getAsmpSession(), outputStream, string);
            outputStream.flush();
            outputStream.close();
            if (this.isShowing()) {
                String string2 = null;
                string2 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_file_read_succeeded_1") : res.getString("JDialogFileSelection_file_read_succeeded_2");
                Message.show((Component)this.m_jdpProgress, (String)string2);
            }
            this.dispose();
            return;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            if (this.isShowing()) {
                this.m_jtfFileName.requestFocus();
                String string3 = null;
                string3 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_Unable_to_Read_File_1") : res.getString("JDialogFileSelection_Unable_to_Read_File_2");
                Message.show((Component)this.m_jdpProgress, (String)(string3 + " " + exceptionAsmpRequestFailed.getMessage()));
            }
            this.m_jdpProgress.reEnableParent();
            this.m_jdpProgress.setVisible(false);
            return;
        }
        catch (Throwable throwable) {
            if (this.isShowing()) {
                this.m_jtfFileName.requestFocus();
                String string4 = null;
                string4 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_gen_error_read_file_1") : res.getString("JDialogFileSelection_gen_error_read_file_2");
                Trace.logError((String)TRACE_CONTEXT, (String)("Error while reading file: " + throwable.getMessage()), (Throwable)throwable);
                Message.show((Component)this.m_jdpProgress, (String)string4);
            }
            this.m_jdpProgress.reEnableParent();
            this.m_jdpProgress.setVisible(false);
            return;
        }
    }

    public int getLoadingStatus() throws Exception {
        Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsFileLoadStatus.0"};
        InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), objectArray);
        return interfaceValueObjectArray[0].getInteger();
    }

    public int getCreateStatus() throws Exception {
        Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsFileCreationStatus.0"};
        InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), objectArray);
        return interfaceValueObjectArray[0].getInteger();
    }

    public String getLoadingReason() throws Exception {
        int n = this.m_acController.getAppliance().getMibMajorVersion();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n < 2) {
            arrayList.add("avocent.ds.dsManagement.dsServer.dsFileLoadFailReason.0");
        } else {
            arrayList.add("avocent.ds.dsManagement.dsServer.dsFileLoadFailCode.0");
        }
        InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), arrayList.toArray());
        return interfaceValueObjectArray[0].getString();
    }

    public String getCreateReason() throws Exception {
        int n = this.m_acController.getAppliance().getMibMajorVersion();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n < 2) {
            arrayList.add("avocent.ds.dsManagement.dsServer.dsFileCreationFailReason.0");
        } else {
            arrayList.add("avocent.ds.dsManagement.dsServer.dsFileCreationFailCode.0");
        }
        InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), arrayList.toArray());
        return interfaceValueObjectArray[0].getString();
    }

    String getFileTransferMessage() {
        String string = this.m_nMode == 2 ? res.getString("JDialogFileSelection_read_from_the") : res.getString("JDialogFileSelection_written_to_the");
        String string2 = null;
        string2 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? (string.equals(res.getString("JDialogFileSelection_read_from_the")) ? res.getString("JDialogFileSelection__0_is_now_being_1_2_1") : res.getString("JDialogFileSelection__0_is_now_being_1_2_2")) : (string.equals(res.getString("JDialogFileSelection_read_from_the")) ? res.getString("JDialogFileSelection__0_is_now_being_1_2_3") : res.getString("JDialogFileSelection__0_is_now_being_1_2_4"));
        Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
        return MessageFormat.format(string2, objectArray);
    }

    String getFileStatusMessage() {
        String string = this.m_nMode == 2 ? res.getString("JDialogFileSelection_created") : res.getString("JDialogFileSelection_loaded");
        String string2 = null;
        string2 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? (string.equals(res.getString("JDialogFileSelection_created")) ? res.getString("JDialogFileSelection__0_is_now_being_1_in_2") : res.getString("JDialogFileSelection__0_is_now_being_1_in_1")) : (string.equals(res.getString("JDialogFileSelection_created")) ? res.getString("JDialogFileSelection__0_is_now_being_1_in_4") : res.getString("JDialogFileSelection__0_is_now_being_1_in_3"));
        Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
        return MessageFormat.format(string2, objectArray);
    }

    void m_jbCloseButton_actionPerformed(ActionEvent actionEvent) {
        this.m_nUserSelection = 2;
        this.dispose();
    }

    void m_jbHelpButton_actionPerformed(ActionEvent actionEvent) {
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.nmm.avr.Help");
            Trace.logInfo((String)"Help", (String)"Successfully loaded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.nmm.avr.Help");
        }
        BrowserHelper.showHelpPage((JFrame)((JFrame)this.getOwner()), (String)resourceBundle.getString(this.m_szHelpSystemKey));
    }

    void m_jbBrowseButton_actionPerformed(ActionEvent actionEvent) {
        int n;
        Dimension dimension = this.m_jfcFileChooser.getLayout().preferredLayoutSize(this.m_jfcFileChooser);
        this.m_jfcFileChooser.setPreferredSize(dimension);
        int n2 = n = this.m_nMode == 3 ? this.m_jfcFileChooser.showOpenDialog((Component)((Object)this)) : this.m_jfcFileChooser.showSaveDialog((Component)((Object)this));
        if (n == 0) {
            File file = this.m_jfcFileChooser.getSelectedFile();
            this.m_jtfFileName.setText(file.getPath());
            this.m_fBaseDirectory = file.getParentFile();
            this.m_jbActionButton.setEnabled(true);
        }
        this.m_jtfFileName.requestFocus();
    }

    public int showDialog() {
        this.m_nUserSelection = 2;
        if (this.m_jtfFileName.getText().trim().length() == 0) {
            this.m_jtfFileName.setText("");
        }
        this.m_jtfFileName.requestFocus();
        this.getRootPane().setDefaultButton(this.m_jbActionButton);
        this.m_jtfFileName.invalidate();
        this.pack();
        this.setVisible(true);
        return this.m_nUserSelection;
    }

    public String getFileName() {
        String string = this.m_jtfFileName.getText().trim();
        if (string == null || string.length() == 0) {
            return "";
        }
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.m_fBaseDirectory, string);
        }
        return file.getPath();
    }

    private boolean canWriteFile(String string) {
        boolean bl;
        block16: {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Checking write access to file: " + string));
            bl = false;
            try {
                File file = new File(string);
                file = file.getCanonicalFile();
                if (file.exists()) {
                    if (file.isDirectory()) {
                        if (this.isShowing()) {
                            this.m_jtfFileName.requestFocus();
                            String string2 = null;
                            string2 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_write_file_is_directory_1") : res.getString("JDialogFileSelection_write_file_is_directory_2");
                            Message.show((Component)((Object)this), (String)string2);
                        }
                        bl = false;
                    } else if (file.canWrite()) {
                        String string3;
                        String string4 = res.getString("JDialogFileSelection_replace_existing_file");
                        int n = JOptionPaneFixedSize.showConfirmDialog((Component)((Object)this), (Object)string4, (String)(string3 = res.getString("JDialogFileSelection_overwrite_file")), (int)0);
                        bl = n == 0;
                    } else {
                        if (this.isShowing()) {
                            this.m_jtfFileName.requestFocus();
                            String string5 = null;
                            string5 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_access_denied_to_file_1") : res.getString("JDialogFileSelection_access_denied_to_file_2");
                            Message.show((Component)((Object)this), (String)string5);
                        }
                        bl = false;
                    }
                } else if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("Directory does not exists: " + file.getParentFile().getPath()));
                    if (this.isShowing()) {
                        this.m_jtfFileName.requestFocus();
                        String string6 = null;
                        string6 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_no_such_directory_1") : res.getString("JDialogFileSelection_no_such_directory_2");
                        Message.show((Component)((Object)this), (String)string6);
                    }
                    bl = false;
                } else if (file.getParentFile() != null && !file.getParentFile().canWrite()) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("Checking write access to directory: " + file.getParentFile().getPath()));
                    if (this.isShowing()) {
                        this.m_jtfFileName.requestFocus();
                        String string7 = null;
                        string7 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_access_denied_to_directory_1") : res.getString("JDialogFileSelection_access_denied_to_directory_2");
                        Message.show((Component)((Object)this), (String)string7);
                    }
                    bl = false;
                } else {
                    bl = true;
                }
            }
            catch (IOException iOException) {
                bl = false;
                Trace.logError((String)TRACE_CONTEXT, (String)"Error while checking for file write access.", (Throwable)iOException);
                if (!this.isShowing()) break block16;
                this.m_jtfFileName.requestFocus();
                String string8 = null;
                string8 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_unable_to_write2_1") : res.getString("JDialogFileSelection_unable_to_write2_2");
                Message.show((Component)((Object)this), (String)string8);
            }
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Write access to file " + string + " " + (bl ? " confirmed." : "denied or canceled.")));
        this.m_jtfFileName.requestFocus();
        return bl;
    }

    private boolean canReadFile(String string) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Checking read access to file: " + string));
        boolean bl = false;
        File file = new File(string);
        if (!file.exists()) {
            if (this.isShowing()) {
                this.m_jtfFileName.requestFocus();
                String string2 = null;
                string2 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_file_does_not_exist_1") : res.getString("JDialogFileSelection_file_does_not_exist_2");
                Message.show((Component)((Object)this), (String)string2);
            }
            bl = false;
        } else if (file.isDirectory()) {
            if (this.isShowing()) {
                this.m_jtfFileName.requestFocus();
                String string3 = null;
                string3 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_read_file_is_directory_1") : res.getString("JDialogFileSelection_read_file_is_directory_2");
                Message.show((Component)((Object)this), (String)string3);
            }
            bl = false;
        } else if (!file.canRead()) {
            if (this.isShowing()) {
                this.m_jtfFileName.requestFocus();
                String string4 = null;
                string4 = this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_read_access_denied_to_file_1") : res.getString("JDialogFileSelection_read_access_denied_to_file_2");
                Message.show((Component)((Object)this), (String)string4);
            }
            bl = false;
        } else {
            bl = true;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Read access to file " + string + " " + (bl ? " confirmed." : "denied.")));
        this.m_jtfFileName.requestFocus();
        return bl;
    }

    class WriteThread
    extends Thread {
        WriteThread() {
            super("ASMP Write File");
        }

        public void run() {
            try {
                if (!JDialogFileSelection.this.writeFile(JDialogFileSelection.this.m_szRemoteFileName)) {
                    JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                    JDialogFileSelection.this.m_jdpProgress.setVisible(false);
                    return;
                }
                JDialogFileSelection.this.m_jdpProgress.setEnableCancelButton(false);
                JDialogFileSelection.this.loadFile(JDialogFileSelection.this.m_szRemoteFileName);
            }
            catch (Exception exception) {
                if (JDialogFileSelection.this.isShowing()) {
                    JDialogFileSelection.this.m_jtfFileName.requestFocus();
                    String string = null;
                    string = JDialogFileSelection.this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_Error_while_sending_1") : res.getString("JDialogFileSelection_Error_while_sending_2");
                    Object[] objectArray = new Object[]{exception.getMessage()};
                    String string2 = MessageFormat.format(string, objectArray);
                    Message.show((Component)JDialogFileSelection.this.m_jdpProgress, (String)string2);
                }
                JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                JDialogFileSelection.this.m_jdpProgress.setVisible(false);
            }
        }
    }

    class ThreadRetrieveFile
    extends Thread {
        ThreadRetrieveFile() {
            super("ASMP Retrieve File");
        }

        public void run() {
            try {
                Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsCreatedFileName.0"};
                InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(JDialogFileSelection.this.m_acController.getAsmpConnection(), objectArray);
                String string = interfaceValueObjectArray[0].getString();
                Trace.logInfo((String)JDialogFileSelection.TRACE_CONTEXT, (String)("Remote file name: " + string));
                JDialogFileSelection.this.readFile(string);
                JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                JDialogFileSelection.this.m_jdpProgress.setVisible(false);
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                if (JDialogFileSelection.this.isShowing()) {
                    JDialogFileSelection.this.m_jtfFileName.requestFocus();
                    String string = null;
                    string = JDialogFileSelection.this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_Unable_to_Read_File_1") : res.getString("JDialogFileSelection_Unable_to_Read_File_2");
                    String string2 = string + " " + exceptionAsmpRequestFailed.getMessage();
                    Message.show((Component)JDialogFileSelection.this.m_jdpProgress, (String)string2);
                }
                JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                JDialogFileSelection.this.m_jdpProgress.setVisible(false);
            }
            catch (Exception exception) {
                if (JDialogFileSelection.this.isShowing()) {
                    JDialogFileSelection.this.m_jtfFileName.requestFocus();
                    String string = null;
                    string = JDialogFileSelection.this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_Error_while2_1") : res.getString("JDialogFileSelection_Error_while2_2");
                    Object[] objectArray = new Object[]{exception.getMessage()};
                    String string3 = MessageFormat.format(string, objectArray);
                    Message.show((Component)JDialogFileSelection.this.m_jdpProgress, (String)string3);
                }
                JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                JDialogFileSelection.this.m_jdpProgress.setVisible(false);
            }
        }
    }

    class ThreadCreateMonitor
    extends Thread {
        int m_nLastStatus;
        int m_nStatus;
        boolean m_bStopThread;
        String m_szCreateReason;

        ThreadCreateMonitor() {
            super("DS-AMP File Create Monitor");
            this.m_nLastStatus = -1;
            this.m_bStopThread = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!this.m_bStopThread) {
                    CreateMonitorUpdateRunnable createMonitorUpdateRunnable;
                    this.m_nStatus = JDialogFileSelection.this.getCreateStatus();
                    if (this.m_nStatus == 4) {
                        this.m_szCreateReason = JDialogFileSelection.this.getCreateReason();
                    }
                    CreateMonitorUpdateRunnable createMonitorUpdateRunnable2 = createMonitorUpdateRunnable = new CreateMonitorUpdateRunnable();
                    synchronized (createMonitorUpdateRunnable2) {
                        SwingUtilities.invokeLater(createMonitorUpdateRunnable);
                        createMonitorUpdateRunnable.wait();
                    }
                    if (!this.m_bStopThread) {
                        Thread.sleep(2000L);
                        continue;
                    }
                    break;
                }
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                if (JDialogFileSelection.this.isShowing()) {
                    JDialogFileSelection.this.m_jtfFileName.requestFocus();
                    String string = null;
                    string = JDialogFileSelection.this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_Unable_to_Read_File_1") : res.getString("JDialogFileSelection_Unable_to_Read_File_2");
                    Message.show((Component)JDialogFileSelection.this.m_jdpProgress, (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
                }
                JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                JDialogFileSelection.this.m_jdpProgress.setVisible(false);
            }
            catch (Exception exception) {
                if (JDialogFileSelection.this.isShowing()) {
                    JDialogFileSelection.this.m_jtfFileName.requestFocus();
                    String string = res.getString("JDialogFileSelection_Error_while1");
                    JDialogFileSelection.this.m_acController.showException((Window)JDialogFileSelection.this.m_jdpProgress, null, JDialogFileSelection.TRACE_CONTEXT, string, exception);
                }
                JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                JDialogFileSelection.this.m_jdpProgress.setVisible(false);
            }
        }

        class CreateMonitorUpdateRunnable
        implements Runnable {
            CreateMonitorUpdateRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Runnable runnable;
                block14: {
                    try {
                        if (((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jdpProgress.checkCancelButton()) {
                            ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jtfFileName.requestFocus();
                            ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                            ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jdpProgress.setVisible(false);
                            ThreadCreateMonitor.this.m_bStopThread = true;
                        } else {
                            switch (ThreadCreateMonitor.this.m_nStatus) {
                                case 3: {
                                    ThreadCreateMonitor.this.m_bStopThread = true;
                                    ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jdpProgress.setValue(1);
                                    ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jdpProgress.setStatusMessage(JDialogFileSelection.this.getFileTransferMessage());
                                    ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jdpProgress.pack();
                                    runnable = new ThreadRetrieveFile();
                                    ((Thread)runnable).start();
                                    break;
                                }
                                case 2: {
                                    if (ThreadCreateMonitor.this.m_nStatus == ThreadCreateMonitor.this.m_nLastStatus) break;
                                    ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jdpProgress.setStatusMessage(JDialogFileSelection.this.getFileStatusMessage());
                                    ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jdpProgress.pack();
                                    break;
                                }
                                case 4: {
                                    ThreadCreateMonitor.this.m_bStopThread = true;
                                    if (JDialogFileSelection.this.isShowing()) {
                                        ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jtfFileName.requestFocus();
                                        Message.show((Component)((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jdpProgress, (String)(res.getString("JDialogFileSelection_File_creation_failed") + ThreadCreateMonitor.this.m_szCreateReason));
                                    }
                                    ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                                    ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jdpProgress.setVisible(false);
                                    break;
                                }
                                default: {
                                    ThreadCreateMonitor.this.m_bStopThread = true;
                                    if (JDialogFileSelection.this.isShowing()) {
                                        ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jtfFileName.requestFocus();
                                        Message.show((Component)((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jdpProgress, (String)res.getString("JDialogFileSelection_File_creation_monitor"));
                                    }
                                    ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                                    ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jdpProgress.setVisible(false);
                                }
                            }
                            ThreadCreateMonitor.this.m_nLastStatus = ThreadCreateMonitor.this.m_nStatus;
                        }
                    }
                    catch (Exception exception) {
                        ThreadCreateMonitor.this.m_bStopThread = true;
                        if (!JDialogFileSelection.this.isShowing()) break block14;
                        ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_jtfFileName.requestFocus();
                        String string = res.getString("JDialogFileSelection_Error_while1");
                        ((ThreadCreateMonitor)ThreadCreateMonitor.this).JDialogFileSelection.this.m_acController.showException((Window)((Object)JDialogFileSelection.this), null, JDialogFileSelection.TRACE_CONTEXT, string, exception);
                    }
                }
                runnable = this;
                synchronized (runnable) {
                    this.notify();
                }
            }
        }
    }

    class ThreadLoadingMonitor
    extends Thread {
        int m_nLastStatus;
        int m_nStatus;
        boolean m_bStopThread;
        String m_szLoadingReason;

        ThreadLoadingMonitor() {
            super("DS-AMP File Loading Monitor");
            this.m_nLastStatus = -1;
            this.m_bStopThread = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                while (!this.m_bStopThread) {
                    this.m_nStatus = JDialogFileSelection.this.getLoadingStatus();
                    if (this.m_nStatus == 4) {
                        this.m_szLoadingReason = JDialogFileSelection.this.getLoadingReason();
                    }
                    RunnableLoadingMonitorUpdate runnableLoadingMonitorUpdate = new RunnableLoadingMonitorUpdate();
                    Object object = runnableLoadingMonitorUpdate;
                    synchronized (object) {
                        SwingUtilities.invokeLater(runnableLoadingMonitorUpdate);
                        runnableLoadingMonitorUpdate.wait();
                    }
                    if (this.m_nStatus == 3) {
                        if (JDialogFileSelection.this.isShowing()) {
                            object = null;
                            object = JDialogFileSelection.this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_file_write_succeeded_1") : res.getString("JDialogFileSelection_file_write_succeeded_2");
                            Message.show((Component)((Object)JDialogFileSelection.this), (String)object);
                        }
                        JDialogFileSelection.this.dispose();
                        if (JDialogFileSelection.this.m_acController.getMainFrame().isShowing() && JDialogFileSelection.this.m_acController.checkIfRebootRequired()) {
                            JDialogFileSelection.this.m_acController.closeAmp();
                            return;
                        }
                    }
                    if (this.m_bStopThread) return;
                    Thread.sleep(2000L);
                }
                return;
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                if (!JDialogFileSelection.this.isShowing()) return;
                JDialogFileSelection.this.m_jtfFileName.requestFocus();
                String string = null;
                string = JDialogFileSelection.this.m_szFileType.equals(res.getString("JDialogFileSelection_configuration")) ? res.getString("JDialogFileSelection_Unable_to_Write_File_1") : res.getString("JDialogFileSelection_Unable_to_Write_File_2");
                Message.show((Component)((Object)JDialogFileSelection.this), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
                return;
            }
            catch (Exception exception) {
                if (!JDialogFileSelection.this.isShowing()) return;
                JDialogFileSelection.this.m_jtfFileName.requestFocus();
                String string = res.getString("JDialogFileSelection_Error_while_0");
                JDialogFileSelection.this.m_acController.showException((Window)((Object)JDialogFileSelection.this), null, JDialogFileSelection.TRACE_CONTEXT, string, exception);
            }
        }

        class RunnableLoadingMonitorUpdate
        implements Runnable {
            RunnableLoadingMonitorUpdate() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object[] objectArray;
                block15: {
                    try {
                        if (((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress.checkCancelButton()) {
                            if (JDialogFileSelection.this.isShowing()) {
                                ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jtfFileName.requestFocus();
                                Message.show((Component)((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress, (String)res.getString("JDialogFileSelection_File_loading_canceled"));
                            }
                            ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                            ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress.setVisible(false);
                            ThreadLoadingMonitor.this.m_bStopThread = true;
                        } else {
                            switch (ThreadLoadingMonitor.this.m_nStatus) {
                                case 3: {
                                    ThreadLoadingMonitor.this.m_bStopThread = true;
                                    ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress.setValue(((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress.getUpperLimit());
                                    ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                                    ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress.setVisible(false);
                                    ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_acController.invalidateUsersSettingsPanel();
                                    break;
                                }
                                case 2: {
                                    if (ThreadLoadingMonitor.this.m_nStatus == ThreadLoadingMonitor.this.m_nLastStatus) break;
                                    ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress.setStatusMessage(JDialogFileSelection.this.getFileStatusMessage());
                                    ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress.pack();
                                    break;
                                }
                                case 4: {
                                    ThreadLoadingMonitor.this.m_bStopThread = true;
                                    if (JDialogFileSelection.this.isShowing()) {
                                        ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jtfFileName.requestFocus();
                                        objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
                                        String string = res.getString("JDialogFileSelection_Loading_of_file");
                                        string = MessageFormat.format(string, objectArray);
                                        Message.show((Component)((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress, (String)(string + " " + ThreadLoadingMonitor.this.m_szLoadingReason));
                                    }
                                    ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                                    ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress.setVisible(false);
                                    break;
                                }
                                default: {
                                    ThreadLoadingMonitor.this.m_bStopThread = true;
                                    if (JDialogFileSelection.this.isShowing()) {
                                        ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jtfFileName.requestFocus();
                                        Message.show((Component)((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress, (String)res.getString("JDialogFileSelection_File_loading_monitor"));
                                    }
                                    ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress.reEnableParent();
                                    ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jdpProgress.setVisible(false);
                                }
                            }
                            ThreadLoadingMonitor.this.m_nLastStatus = ThreadLoadingMonitor.this.m_nStatus;
                        }
                    }
                    catch (Exception exception) {
                        ThreadLoadingMonitor.this.m_bStopThread = true;
                        if (!JDialogFileSelection.this.isShowing()) break block15;
                        ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_jtfFileName.requestFocus();
                        String string = res.getString("JDialogFileSelection_Error_while_0");
                        ((ThreadLoadingMonitor)ThreadLoadingMonitor.this).JDialogFileSelection.this.m_acController.showException((Window)((Object)JDialogFileSelection.this), null, JDialogFileSelection.TRACE_CONTEXT, string, exception);
                    }
                }
                objectArray = this;
                synchronized (this) {
                    this.notify();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }
    }
}

