/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AmpControllerAvr;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.exceptions.ExceptionUserCancelled;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.components.JTextFieldAvocent;
import com.avocent.lib.gui.dialogs.InputStreamProgressMonitoring;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.JDialogProgress;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.panels.JPanelSizeConstrained;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.StringUtilities;
import com.mindbright.jca.security.cert.CertificateEncodingException;
import com.mindbright.security.x509.X509Certificate;
import com.mindbright.ssh2.SSH2KeyFingerprint;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class JDialogSendCert
extends JDialogCentered {
    public static final String CNAME = "JDialogSendCert";
    protected static final ResourceManager m_res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    public static final String TRACE_CONTEXT = "Send Certificate Dialog";
    private static final Integer DISABLED = new Integer(1);
    private static final Integer ENABLED = new Integer(2);
    AmpControllerAvr m_acController;
    protected JFileChooser m_jfcFileChooser = null;
    protected File m_fBaseDirectory;
    private File m_certificateFile = null;
    private InputStream m_certificateStream = null;
    private JDialogSendCert m_this = this;
    private String m_loadResult = "";
    private final String m_szCertFileName = "cacert.pem";
    private JDialogProgress m_jdpProgress;
    private JLabel jLabel2;
    private JLabel jlFiller;
    private JLabel jlIssuer;
    private JLabel jlUntil;
    private JLabel jlValidity;
    private JPanelSizeConstrained jpscCertificateDetails;
    private JPanelSizeConstrained jpscCertificateFile;
    private JPanelSizeConstrained jspcButtons;
    private JButton m_jbBrowse;
    private JButton m_jbClose;
    private JButton m_jbHelp;
    private JButton m_jbSend;
    private JLabel m_jlMD5;
    private JLabel m_jlSHA;
    private JLabel m_jlSerialNum;
    private JLabel m_jlSubject;
    private JPanel m_jpButtonPanel;
    private JTextFieldAvocent m_jtBubbleBabble;
    private JTextFieldAvocent m_jtFileText;
    private JTextFieldAvocent m_jtIssuer;
    private JTextFieldAvocent m_jtMD5;
    private JTextFieldAvocent m_jtSerialNum;
    private JTextFieldAvocent m_jtSubject;
    private JTextFieldAvocent m_jtValidityFrom;
    private JTextFieldAvocent m_jtValidityTo;

    public JDialogSendCert(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.m_jbSend.setEnabled(false);
    }

    private void initComponents() {
        this.m_jpButtonPanel = new JPanel();
        this.jpscCertificateFile = new JPanelSizeConstrained();
        this.jLabel2 = new JLabel();
        this.m_jbBrowse = new JButton();
        this.m_jtFileText = new JTextFieldAvocent();
        this.jpscCertificateDetails = new JPanelSizeConstrained();
        this.m_jtSubject = new JTextFieldAvocent();
        this.m_jlSubject = new JLabel();
        this.jlValidity = new JLabel();
        this.m_jlSerialNum = new JLabel();
        this.m_jlSHA = new JLabel();
        this.m_jlMD5 = new JLabel();
        this.m_jtIssuer = new JTextFieldAvocent();
        this.jlIssuer = new JLabel();
        this.m_jtSerialNum = new JTextFieldAvocent();
        this.m_jtBubbleBabble = new JTextFieldAvocent();
        this.m_jtMD5 = new JTextFieldAvocent();
        this.m_jtValidityFrom = new JTextFieldAvocent();
        this.jlUntil = new JLabel();
        this.m_jtValidityTo = new JTextFieldAvocent();
        this.jspcButtons = new JPanelSizeConstrained();
        this.m_jbSend = new JButton();
        this.m_jbClose = new JButton();
        this.m_jbHelp = new JButton();
        this.jlFiller = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.m_jpButtonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.m_jpButtonPanel, gridBagConstraints);
        this.jpscCertificateFile.setLayout((LayoutManager)new GridBagLayout());
        this.jpscCertificateFile.setBorder((Border)new TitledBorder(m_res.getString("JDialogSendCert_CertificateFileLabel")));
        this.jpscCertificateFile.setDoubleBuffered(false);
        this.jpscCertificateFile.setMaximumSize(new Dimension(Integer.MAX_VALUE, 70));
        this.jpscCertificateFile.setMinimumSize(new Dimension(200, 100));
        this.jpscCertificateFile.setPreferredSize(new Dimension(850, 90));
        this.jLabel2.setText(ResourceBundle.getBundle("com/avocent/avworks/nmm/avr/Res").getString("JDialogSendCert_FileLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateFile.add((Component)this.jLabel2, (Object)gridBagConstraints);
        this.m_jbBrowse.setText(m_res.getString("JDialogSendCert_Browse"));
        this.m_jbBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogSendCert.this.m_jbBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        this.jpscCertificateFile.add((Component)this.m_jbBrowse, (Object)gridBagConstraints);
        this.m_jtFileText.setEditable(false);
        this.m_jtFileText.setMinimumSize(new Dimension(300, 19));
        this.m_jtFileText.setPreferredSize(new Dimension(1000, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jpscCertificateFile.add((Component)this.m_jtFileText, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jpscCertificateFile, gridBagConstraints);
        this.jpscCertificateDetails.setLayout((LayoutManager)new GridBagLayout());
        this.jpscCertificateDetails.setBorder((Border)new TitledBorder(m_res.getString("JDialogSendCert_CertificateDetailsLabel")));
        this.jpscCertificateDetails.setMinimumSize(new Dimension(200, 200));
        this.jpscCertificateDetails.setPreferredSize(new Dimension(850, 200));
        this.m_jtSubject.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateDetails.add((Component)this.m_jtSubject, (Object)gridBagConstraints);
        this.m_jlSubject.setText(m_res.getString("JDialogSendCert_Subject"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateDetails.add((Component)this.m_jlSubject, (Object)gridBagConstraints);
        this.jlValidity.setText(m_res.getString("JDialogSendCert_Validity"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateDetails.add((Component)this.jlValidity, (Object)gridBagConstraints);
        this.m_jlSerialNum.setText(m_res.getString("JDialogSendCert_Serial"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateDetails.add((Component)this.m_jlSerialNum, (Object)gridBagConstraints);
        this.m_jlSHA.setText(m_res.getString("JDialogSendCert_BubbleBabble"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateDetails.add((Component)this.m_jlSHA, (Object)gridBagConstraints);
        this.m_jlMD5.setText(m_res.getString("JDialogSendCert_MD5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateDetails.add((Component)this.m_jlMD5, (Object)gridBagConstraints);
        this.m_jtIssuer.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateDetails.add((Component)this.m_jtIssuer, (Object)gridBagConstraints);
        this.jlIssuer.setText(m_res.getString("JDialogSendCert_Issuer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateDetails.add((Component)this.jlIssuer, (Object)gridBagConstraints);
        this.m_jtSerialNum.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateDetails.add((Component)this.m_jtSerialNum, (Object)gridBagConstraints);
        this.m_jtBubbleBabble.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateDetails.add((Component)this.m_jtBubbleBabble, (Object)gridBagConstraints);
        this.m_jtMD5.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateDetails.add((Component)this.m_jtMD5, (Object)gridBagConstraints);
        this.m_jtValidityFrom.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateDetails.add((Component)this.m_jtValidityFrom, (Object)gridBagConstraints);
        this.jlUntil.setText(m_res.getString("JDialogSendCert_Until"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateDetails.add((Component)this.jlUntil, (Object)gridBagConstraints);
        this.m_jtValidityTo.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jpscCertificateDetails.add((Component)this.m_jtValidityTo, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jpscCertificateDetails, gridBagConstraints);
        this.jspcButtons.setLayout((LayoutManager)new GridBagLayout());
        this.jspcButtons.setMaximumSize(new Dimension(Integer.MAX_VALUE, 33));
        this.jspcButtons.setMinimumSize(new Dimension(200, 33));
        this.jspcButtons.setPreferredSize(new Dimension(850, 33));
        this.m_jbSend.setText(m_res.getString("JDialogSendCert_Send"));
        this.m_jbSend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogSendCert.this.m_jbSendActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jspcButtons.add((Component)this.m_jbSend, (Object)gridBagConstraints);
        this.m_jbClose.setText(m_res.getString("JDialogSendCert_Close"));
        this.m_jbClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogSendCert.this.m_jbCloseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jspcButtons.add((Component)this.m_jbClose, (Object)gridBagConstraints);
        this.m_jbHelp.setText(m_res.getString("JDialogSendCert_Help"));
        this.m_jbHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogSendCert.this.m_jbHelpActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jspcButtons.add((Component)this.m_jbHelp, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jspcButtons.add((Component)this.jlFiller, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jspcButtons, gridBagConstraints);
    }

    private void m_jbHelpActionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Handling the Help button action for \"" + this.getTitle() + "\"."));
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.nmm.avr.Help");
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Successfully loaded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"FAILED TO LOAD com.avocent.avworks.nmm.avr.Help");
        }
        BrowserHelper.showHelpPage((JFrame)((JFrame)this.getOwner()), (String)resourceBundle.getString("IDH_SEND_SECURITY_CERTIFICATE"));
    }

    private void m_jbSendActionPerformed(ActionEvent actionEvent) {
        String string;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Handling the Send button action for \"" + this.getTitle() + "\"."));
        if (this.m_jdpProgress == null) {
            string = m_res.getString("JDialogSendCert_Manage");
            this.m_jdpProgress = new JDialogProgress((Dialog)((Object)this), string);
        }
        try {
            this.m_certificateStream = new InputStreamProgressMonitoring(this.m_certificateFile, this.m_jdpProgress);
        }
        catch (ExceptionConstructorFailed exceptionConstructorFailed) {
            final String string2 = exceptionConstructorFailed.getMessage();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JDialogSendCert.this.m_jdpProgress.reEnableParent();
                    JDialogSendCert.this.m_jdpProgress.setVisible(false);
                    Message.show((Component)((Object)JDialogSendCert.this.m_this), (String)string2);
                }
            });
            return;
        }
        this.m_jdpProgress.setValue(0);
        string = m_res.getString("JDialogSendCert_Copying_Certificate");
        this.m_jdpProgress.setStatusMessage(string);
        this.m_jdpProgress.pack();
        this.m_jdpProgress.checkCancelButton();
        this.m_jdpProgress.setEnableCancelButton(true);
        this.m_jdpProgress.disableParent();
        this.m_jdpProgress.setVisible(true);
        Thread thread = new Thread(){

            public void run() {
                try {
                    AvrSnmpHelper.sendFile(JDialogSendCert.this.m_acController.getAsmpConnection().getAsmpSession(), JDialogSendCert.this.m_certificateStream, JDialogSendCert.this.m_certificateFile.length(), "cacert.pem");
                    JDialogSendCert.this.m_certificateStream.close();
                }
                catch (IOException iOException) {
                    try {
                        JDialogSendCert.this.m_certificateStream.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    String string = iOException.getMessage();
                    SwingUtilities.invokeLater(new Runnable(this, string){
                        private final /* synthetic */ String val$errMsg;
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$errMsg = string;
                        }

                        public void run() {
                            JDialogSendCert.access$400(6.access$800(this.this$1)).reEnableParent();
                            JDialogSendCert.access$400(6.access$800(this.this$1)).setVisible(false);
                            Message.show((Component)((Object)JDialogSendCert.access$500(6.access$800(this.this$1))), (String)this.val$errMsg);
                        }
                    });
                    return;
                }
                catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                    String string = exceptionAsmpRequestFailed.getMessage();
                    SwingUtilities.invokeLater(new Runnable(this, string){
                        private final /* synthetic */ String val$errMsg;
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$errMsg = string;
                        }

                        public void run() {
                            JDialogSendCert.access$400(6.access$800(this.this$1)).reEnableParent();
                            JDialogSendCert.access$400(6.access$800(this.this$1)).setVisible(false);
                            Message.show((Component)((Object)JDialogSendCert.access$500(6.access$800(this.this$1))), (String)this.val$errMsg);
                        }
                    });
                    return;
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    String string = exceptionRequestFailed.getMessage();
                    SwingUtilities.invokeLater(new Runnable(this, string){
                        private final /* synthetic */ String val$errMsg;
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$errMsg = string;
                        }

                        public void run() {
                            JDialogSendCert.access$400(6.access$800(this.this$1)).reEnableParent();
                            JDialogSendCert.access$400(6.access$800(this.this$1)).setVisible(false);
                            Message.show((Component)((Object)JDialogSendCert.access$500(6.access$800(this.this$1))), (String)this.val$errMsg);
                        }
                    });
                    return;
                }
                catch (ExceptionUserCancelled exceptionUserCancelled) {
                    try {
                        JDialogSendCert.this.m_certificateStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            JDialogSendCert.access$400(6.access$800(this.this$1)).reEnableParent();
                            JDialogSendCert.access$400(6.access$800(this.this$1)).setVisible(false);
                        }
                    });
                    return;
                }
                catch (Exception exception) {
                    String string = exception.getMessage();
                    SwingUtilities.invokeLater(new Runnable(this, string){
                        private final /* synthetic */ String val$errMsg;
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$errMsg = string;
                        }

                        public void run() {
                            JDialogSendCert.access$400(6.access$800(this.this$1)).reEnableParent();
                            JDialogSendCert.access$400(6.access$800(this.this$1)).setVisible(false);
                            Message.show((Component)((Object)JDialogSendCert.access$500(6.access$800(this.this$1))), (String)this.val$errMsg);
                        }
                    });
                    return;
                }
                Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsLoadFileName.0", "avocent.ds.dsManagement.dsServer.dsLoadFileControl.0"};
                Object[] objectArray2 = new Object[]{"cacert.pem", new Integer(4)};
                try {
                    AvrSnmpHelper.set(JDialogSendCert.this.m_acController.getAsmpConnection(), objectArray, objectArray2);
                    int n = 2;
                    while (n == 2) {
                        Thread.sleep(2000L);
                        n = JDialogSendCert.this.getLoadStatus();
                    }
                    switch (n) {
                        case 3: {
                            JDialogSendCert.this.m_loadResult = m_res.getString("JDialogSendCert_Success");
                            break;
                        }
                        case 4: {
                            JDialogSendCert.this.m_loadResult = JDialogSendCert.this.getLoadFailReason();
                            break;
                        }
                        default: {
                            JDialogSendCert.this.m_loadResult = "";
                            Trace.logError((String)JDialogSendCert.TRACE_CONTEXT, (String)"Received an unexpected load status.");
                        }
                    }
                    Message.show((Component)((Object)JDialogSendCert.this.m_this), (String)JDialogSendCert.this.m_loadResult);
                    JDialogSendCert.this.m_jdpProgress.reEnableParent();
                    JDialogSendCert.this.m_jdpProgress.setVisible(false);
                    if (n == 3) {
                        Object[] objectArray3 = new Object[]{"avocent.ds.dsManagement.dsNtp.dsNtpControl.0", "avocent.ds.dsManagement.dsNtp.dsNtpUpdateInterval.0"};
                        InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(JDialogSendCert.this.m_acController.getAsmpConnection(), objectArray3);
                        if (!interfaceValueObjectArray[0].getInteger().equals(ENABLED)) {
                            Message.show((Component)((Object)JDialogSendCert.this.m_this), (String)m_res.getString("JDialogSendCert_NTP_Warning"));
                        }
                    }
                }
                catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                    String string = exceptionAsmpRequestFailed.getMessage();
                    SwingUtilities.invokeLater(new Runnable(this, string){
                        private final /* synthetic */ String val$errMsg;
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$errMsg = string;
                        }

                        public void run() {
                            JDialogSendCert.access$400(6.access$800(this.this$1)).reEnableParent();
                            JDialogSendCert.access$400(6.access$800(this.this$1)).setVisible(false);
                            Message.show((Component)((Object)JDialogSendCert.access$500(6.access$800(this.this$1))), (String)this.val$errMsg);
                        }
                    });
                    return;
                }
                catch (ExceptionUserCancelled exceptionUserCancelled) {
                    String string = exceptionUserCancelled.getMessage();
                    SwingUtilities.invokeLater(new Runnable(this, string){
                        private final /* synthetic */ String val$errMsg;
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$errMsg = string;
                        }

                        public void run() {
                            JDialogSendCert.access$400(6.access$800(this.this$1)).reEnableParent();
                            JDialogSendCert.access$400(6.access$800(this.this$1)).setVisible(false);
                            Message.show((Component)((Object)JDialogSendCert.access$500(6.access$800(this.this$1))), (String)this.val$errMsg);
                        }
                    });
                    return;
                }
                catch (Exception exception) {
                    String string = exception.getMessage();
                    SwingUtilities.invokeLater(new Runnable(this, string){
                        private final /* synthetic */ String val$errMsg;
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$errMsg = string;
                        }

                        public void run() {
                            JDialogSendCert.access$400(6.access$800(this.this$1)).reEnableParent();
                            JDialogSendCert.access$400(6.access$800(this.this$1)).setVisible(false);
                            Message.show((Component)((Object)JDialogSendCert.access$500(6.access$800(this.this$1))), (String)this.val$errMsg);
                        }
                    });
                    return;
                }
            }

            static /* synthetic */ JDialogSendCert access$800(6 var0) {
                return var0.JDialogSendCert.this;
            }
        };
        thread.start();
    }

    public String getLoadFailReason() throws Exception {
        Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsFileLoadFailCode.0"};
        InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), objectArray);
        return interfaceValueObjectArray[0].getString();
    }

    public int getLoadStatus() throws Exception {
        Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsFileLoadStatus.0"};
        InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), objectArray);
        return interfaceValueObjectArray[0].getInteger();
    }

    private void m_jbCloseActionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Handling the Close button action for \"" + this.getTitle() + "\"."));
        this.dispose();
    }

    private void m_jbBrowseActionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Handling the Browse button action for \"" + this.getTitle() + "\"."));
        Dimension dimension = this.m_jfcFileChooser.getLayout().preferredLayoutSize(this.m_jfcFileChooser);
        this.m_jfcFileChooser.setPreferredSize(dimension);
        int n = this.m_jfcFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            File file = this.m_jfcFileChooser.getSelectedFile();
            this.m_jtFileText.setText(file.getPath());
            this.m_fBaseDirectory = file.getParentFile();
            if (!this.displayCertificate(file.getPath())) {
                final String string = m_res.getString("JDialogSendCert_BadFile");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Message.show((Component)((Object)JDialogSendCert.this.m_this), (String)string);
                    }
                });
                this.clearCertificateDetails();
                this.m_jbSend.setEnabled(false);
            } else {
                this.m_certificateFile = new File(file.getPath());
                this.m_jbSend.setEnabled(true);
            }
        }
    }

    protected void clearCertificateDetails() {
        this.m_jtSubject.setText("");
        this.m_jtIssuer.setText("");
        this.m_jtValidityFrom.setText("");
        this.m_jtValidityTo.setText("");
        this.m_jtSerialNum.setText("");
        this.m_jtBubbleBabble.setText("");
        this.m_jtMD5.setText("");
    }

    public JDialogSendCert(AmpControllerAvr ampControllerAvr, String string, String string2) throws ExceptionConstructorFailed {
        super((Frame)ampControllerAvr.getMainFrame(), string, true);
        this.initComponents();
        this.setSize(this.getPreferredSize().width, this.getPreferredSize().height);
        this.setResizable(false);
        this.m_jbSend.setEnabled(false);
        this.m_jtFileText.setText("");
        this.m_acController = ampControllerAvr;
        this.setLocationRelativeTo((Component)this.m_acController.getMainFrame());
        this.getRootPane().setDefaultButton(this.m_jbBrowse);
        this.m_jbBrowse.requestFocus();
        Thread thread = new Thread("Create File Chooser Thread"){

            public void run() {
                JDialogSendCert.this.m_jbBrowse.setEnabled(false);
                JDialogSendCert.this.setCursor(Cursor.getPredefinedCursor(3));
                JDialogSendCert.this.m_jfcFileChooser = new JFileChooser(JDialogSendCert.this.m_fBaseDirectory);
                JDialogSendCert.this.m_jbBrowse.setEnabled(true);
                JDialogSendCert.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        thread.start();
        ButtonPanel.equalize((JPanel)this.m_jpButtonPanel);
        this.pack();
    }

    protected boolean displayCertificate(String string) {
        int n;
        Object object;
        Object[] objectArray;
        Closeable closeable;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Handling the displaying of the certificate information for \"" + this.getTitle() + "\"."));
        this.clearCertificateDetails();
        try {
            closeable = new FileReader(string);
            objectArray = new char[27];
            ((InputStreamReader)closeable).read((char[])objectArray, 0, 27);
            object = new String((char[])objectArray);
            if (!((String)object).equals("-----BEGIN CERTIFICATE-----")) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"Certificate is not in PEM format.");
                ((InputStreamReader)closeable).close();
                return false;
            }
            ((InputStreamReader)closeable).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"displayCertificate (checking PEM format) - FileNotFoundException");
            return false;
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"displayCertificate (checking PEM format) - IOException");
            return false;
        }
        closeable = null;
        objectArray = null;
        try {
            object = new File(string);
            objectArray = new byte[(int)((File)object).length()];
            closeable = new FileInputStream(string);
            n = ((InputStream)closeable).read((byte[])objectArray);
            ((InputStream)closeable).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"displayCertificate - FileNotFoundException");
            return false;
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"displayCertificate - Unable to read buffer");
            return false;
        }
        try {
            object = new String((byte[])objectArray);
            n = ((String)object).indexOf("-----END CERTIFICATE-----");
            object = ((String)object).substring(0, n);
            object = ((String)object).replaceAll("-----BEGIN CERTIFICATE-----", "");
            object = ((String)object).replaceAll("\r\n", "");
            objectArray = StringUtilities.decodeBase64((String)object);
            X509Certificate x509Certificate = new X509Certificate((byte[])objectArray);
            this.m_jtSubject.setText(x509Certificate.getSubjectDN());
            this.m_jtIssuer.setText(x509Certificate.getIssuerDN());
            this.m_jtSerialNum.setText(x509Certificate.getSerialNumber().toString());
            try {
                this.m_jtBubbleBabble.setText(SSH2KeyFingerprint.bubbleBabble((byte[])x509Certificate.getEncoded()));
                this.m_jtMD5.setText(SSH2KeyFingerprint.md5Hex((byte[])x509Certificate.getEncoded()));
            }
            catch (CertificateEncodingException certificateEncodingException) {
                Trace.logError((String)TRACE_CONTEXT, (String)"displayCertificate - CertificateEncodingException");
                return false;
            }
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Trace.logError((String)TRACE_CONTEXT, (String)"displayCertificate - ExceptionInvalidArgument");
            return false;
        }
        try {
            ((InputStream)closeable).close();
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"displayCertificate - IOException");
        }
        try {
            closeable = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"displayCertificate - FileNotFoundException");
            return false;
        }
        try {
            object = CertificateFactory.getInstance("X.509");
            java.security.cert.X509Certificate x509Certificate = (java.security.cert.X509Certificate)((CertificateFactory)object).generateCertificate((InputStream)closeable);
            this.m_jtValidityFrom.setText(x509Certificate.getNotBefore().toString());
            this.m_jtValidityTo.setText(x509Certificate.getNotAfter().toString());
        }
        catch (CertificateException certificateException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"displayCertificate - CertificateException");
        }
        try {
            ((InputStream)closeable).close();
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"displayCertificate - IOException");
        }
        return true;
    }
}

