/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.SnmpValueObject;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.components.JTableAvocent;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.panels.EventTrappingPanel;
import com.avocent.lib.gui.renderers.CheckableItem;
import com.avocent.lib.gui.renderers.NameValue;
import com.avocent.lib.gui.renderers.TableCellRendererCheckBox;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.ThreadContinuous;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class JDialogToolsUpgradeRipFirmware
extends JDialogCentered {
    public static final String CNAME = "JDialogToolsUpgradeRipFirmware";
    private static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    private static Object[] RIP = new Object[]{AVWorksBranding.getDsrIqName((boolean)true)};
    private static final String TRACE_CONTEXT = "AVR AMP:Upgrade RIP Firmware";
    private static int MIN_VISIBLE_ROWS = 2;
    private static final int POLL_INTERVAL_SECONDS = 5;
    private static final String[] m_aszColumnNames_1 = new String[]{res.getString("JDialogToolsUpgradeRipFirmware_Type_1"), res.getString("JDialogToolsUpgradeRipFirmware_Version_Available"), res.getString("JDialogToolsUpgradeRipFirmware_Need_Upgrade"), res.getString("JDialogToolsUpgradeRipFirmware_Last_Status")};
    private static final String[] m_aszColumnNames_2 = new String[]{res.getString("JDialogToolsUpgradeRipFirmware_Type_1"), res.getString("JDialogToolsUpgradeRipFirmware_Need_Upgrade"), res.getString("JDialogToolsUpgradeRipFirmware_Last_Status")};
    private String[] m_aszColumnNames = m_aszColumnNames_1;
    private static final Integer UPGR_READY_VAL = new Integer(1);
    private static final Integer UPGR_INPROGRESS_VAL = new Integer(2);
    private static final Integer REQUEST_UPGRADE = new Integer(2);
    private RipType[] m_upgradeTable;
    private AbstractTableModel m_tableModel;
    private ThreadPollData m_threadPollData;
    private boolean m_bOurUpgradeInProgress = false;
    private boolean m_bAnUpgradeInProgress = false;
    private boolean m_bRequestingUpgrade = false;
    private int m_nMajorMibVersion = 1;
    private Integer[] m_aiSavedVersionMismatches = null;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel m_jlSelectTypes = new JLabel();
    EventTrappingPanel m_jpEventTrapper = new EventTrappingPanel();
    JScrollPane m_jScrollPane = new JScrollPane();
    JTableAvocent m_jTable = new JTableAvocent();
    JPanel m_jpButtonPanel = new JPanel();
    JButton m_jbUpgrade = new JButton();
    JButton m_jbClose = new JButton();
    JButton m_jbHelp = new JButton();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel m_jlWarningMsg = new JLabel();
    JLabel m_jlInProgressMsg = new JLabel();
    JLabel m_jlInProgressFiller = new JLabel();
    protected AmpController m_acController;

    public JDialogToolsUpgradeRipFirmware(AmpController ampController) throws ExceptionConstructorFailed {
        super((Frame)ampController.getMainFrame(), true);
        try {
            this.m_acController = ampController;
            this.jbInit();
            String string = res.getString("JDialogToolsUpgradeRipFirmware_Upgrade_RIP_Firmware");
            string = MessageFormat.format(string, RIP);
            this.setTitle(string);
            this.initialize();
            ButtonPanel.equalize((JPanel)this.m_jpButtonPanel);
            this.pack();
            this.setDefaultCloseOperation(2);
            this.getRootPane().setDefaultButton(this.m_jbUpgrade);
            this.getGlassPane().addMouseListener(new MouseAdapter(){});
            this.getGlassPane().addKeyListener(new KeyAdapter(){});
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Constuctor: Creating and starting data polling thread");
            this.m_threadPollData = new ThreadPollData();
            this.m_threadPollData.start();
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            String string = res.getString("JDialogToolsUpgradeRipFirmware_Unable_to_Upgrade_Rip_Type");
            string = MessageFormat.format(string, RIP);
            throw new ExceptionConstructorFailed(string + " " + exceptionAsmpRequestFailed.getMessage());
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Constructor failed with exception: " + exception.getMessage()), (Throwable)exception);
            this.dispose();
            String string = exception.getMessage();
            if (string == null) {
                string = res.getString("JDialogToolsUpgradeRipFirmware_Unable_to_display_the");
            }
            throw new ExceptionConstructorFailed(string);
        }
    }

    public JDialogToolsUpgradeRipFirmware() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.pack();
    }

    private void jbInit() throws Exception {
        this.m_jlSelectTypes.setText(res.getString("JDialogToolsUpgradeRipFirmware_Select_types_to"));
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.m_jpEventTrapper.setLayout((LayoutManager)new BorderLayout());
        this.m_jbUpgrade.setText(res.getString("JDialogToolsUpgradeRipFirmware_Upgrade"));
        this.m_jbUpgrade.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogToolsUpgradeRipFirmware.this.m_jbUpgrade_actionPerformed(actionEvent);
            }
        });
        this.m_jbClose.setText(res.getString("JDialogToolsUpgradeRipFirmware_Close"));
        this.m_jbClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogToolsUpgradeRipFirmware.this.m_jbClose_actionPerformed(actionEvent);
            }
        });
        this.m_jbHelp.setText(res.getString("JDialogToolsUpgradeRipFirmware_Help"));
        this.m_jbHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogToolsUpgradeRipFirmware.this.m_jbHelp_actionPerformed(actionEvent);
            }
        });
        this.m_jpButtonPanel.setLayout(this.gridBagLayout2);
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JDialogToolsUpgradeRipFirmware.this.this_windowClosing(windowEvent);
            }
        });
        this.m_jlWarningMsg.setText(res.getString("JDialogToolsUpgradeRipFirmware_Warning_Same_types"));
        this.m_jlInProgressMsg.setText(res.getString("JDialogToolsUpgradeRipFirmware_Firmware_upgrade"));
        this.m_jlInProgressFiller.setText("");
        this.m_jScrollPane.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.m_jpButtonPanel.add((Component)this.m_jbUpgrade, new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_jpButtonPanel.add((Component)this.m_jbClose, new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_jpButtonPanel.add((Component)this.m_jbHelp, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.m_jpEventTrapper, new GridBagConstraints(-1, 1, 0, 1, 0.0, 0.7, 10, 1, new Insets(5, 10, 0, 20), 0, 0));
        this.m_jpEventTrapper.add((Component)this.m_jScrollPane, (Object)"Center");
        this.m_jScrollPane.getViewport().add((Component)this.m_jTable, null);
        this.getContentPane().add((Component)this.m_jlSelectTypes, new GridBagConstraints(-1, 0, 0, 1, 0.0, 0.1, 17, 0, new Insets(20, 10, 2, 0), 0, 0));
        this.getContentPane().add((Component)this.m_jlWarningMsg, new GridBagConstraints(-1, 2, 0, 1, 0.0, 0.1, 17, 2, new Insets(0, 10, 5, 0), 1, 1));
        this.getContentPane().add((Component)this.m_jlInProgressMsg, new GridBagConstraints(-1, 3, 0, 1, 0.0, 0.1, 17, 2, new Insets(0, 10, 0, 0), 1, 1));
        this.getContentPane().add((Component)this.m_jlInProgressFiller, new GridBagConstraints(-1, 3, 0, 1, 0.0, 0.1, 10, 1, new Insets(0, 10, 0, 0), 1, 1));
        this.getContentPane().add((Component)this.m_jpButtonPanel, new GridBagConstraints(-1, 4, 0, 1, 1.0, 0.1, 13, 0, new Insets(5, 5, 5, 20), 0, 0));
    }

    private void initialize() throws Exception {
        this.m_jlInProgressFiller.setPreferredSize(this.m_jlInProgressMsg.getPreferredSize());
        this.showInProgressMsg(false);
        this.m_nMajorMibVersion = this.m_acController.getAppliance().getMibMajorVersion();
        if (this.m_nMajorMibVersion >= 2) {
            this.m_aszColumnNames = m_aszColumnNames_2;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableIndex");
        arrayList.add("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableVersionMismatches");
        arrayList.add("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableControl");
        arrayList.add("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableStatus");
        if (this.m_nMajorMibVersion >= 2) {
            arrayList.add("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableFailCode");
        } else {
            arrayList.add("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableFailReason");
            arrayList.add("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableVersionAvailable");
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)"initialize: Retrieving the RIP firmware information.");
        InterfaceValueObject[][] interfaceValueObjectArray = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), arrayList.toArray());
        this.m_bAnUpgradeInProgress = false;
        this.m_upgradeTable = new RipType[interfaceValueObjectArray.length];
        for (int i = 0; i < interfaceValueObjectArray.length; ++i) {
            SnmpValueObject snmpValueObject = (SnmpValueObject)interfaceValueObjectArray[i][0];
            String string = snmpValueObject.toString();
            CheckableItem checkableItem = new CheckableItem(string, false);
            NameValue nameValue = (NameValue)interfaceValueObjectArray[i][3].getValue();
            Integer n = (Integer)nameValue.getValue();
            boolean bl = this.m_bAnUpgradeInProgress = this.m_bAnUpgradeInProgress || n.equals(UPGR_INPROGRESS_VAL);
            if (n.equals(UPGR_READY_VAL)) {
                nameValue.setName("");
            }
            String string2 = "";
            if (interfaceValueObjectArray[i].length > 5) {
                string2 = interfaceValueObjectArray[i][5].toString();
            }
            this.m_upgradeTable[i] = new RipType(snmpValueObject.getInteger(), checkableItem, string2, (Integer)interfaceValueObjectArray[i][1].getValue(), interfaceValueObjectArray[i][2], nameValue, interfaceValueObjectArray[i][4].toString());
        }
        this.setTableBusy(this.m_bAnUpgradeInProgress);
        this.showInProgressMsg(this.m_bAnUpgradeInProgress);
        Trace.logInfo((String)TRACE_CONTEXT, (String)"initialize: Loading the values into the table for display.");
        this.initializeTable();
        this.m_jbUpgrade.setEnabled(false);
    }

    private void initializeTable() {
        this.m_tableModel = this.createTableModel();
        this.m_jTable.setModel((TableModel)this.m_tableModel);
        this.m_jTable.setShowGrid(false);
        this.m_jTable.setRowSelectionAllowed(false);
        this.m_jTable.getTableHeader().setReorderingAllowed(false);
        this.m_jTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                CheckableItem checkableItem;
                int n = JDialogToolsUpgradeRipFirmware.this.m_jTable.rowAtPoint(mouseEvent.getPoint());
                if (n > -1 && n < JDialogToolsUpgradeRipFirmware.this.m_upgradeTable.length && (checkableItem = JDialogToolsUpgradeRipFirmware.this.m_upgradeTable[n].getType()) != null && JDialogToolsUpgradeRipFirmware.this.m_upgradeTable[n].getVersMismatches() != 0) {
                    checkableItem.setSelected(!checkableItem.isSelected());
                    Rectangle rectangle = JDialogToolsUpgradeRipFirmware.this.m_jTable.getCellRect(n, 0, true);
                    JDialogToolsUpgradeRipFirmware.this.m_jTable.repaint(rectangle);
                    JDialogToolsUpgradeRipFirmware.this.setUpgradeButtonState();
                }
            }
        });
        TableCellRendererCheckBox tableCellRendererCheckBox = new TableCellRendererCheckBox();
        TableColumn tableColumn = this.m_jTable.getColumn((Object)this.m_aszColumnNames[0]);
        tableColumn.setCellRenderer((TableCellRenderer)tableCellRendererCheckBox);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)component;
                defaultTableCellRenderer.setOpaque(true);
                defaultTableCellRenderer.setBorder(DefaultTableCellRenderer.noFocusBorder);
                defaultTableCellRenderer.setBackground(jTable.getBackground());
                defaultTableCellRenderer.setForeground(jTable.getForeground());
                return defaultTableCellRenderer;
            }
        };
        for (int i = 1; i < this.m_aszColumnNames.length; ++i) {
            tableColumn = this.m_jTable.getColumn((Object)this.m_aszColumnNames[i]);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
        }
        this.setTableSize();
    }

    private AbstractTableModel createTableModel() {
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            public int getColumnCount() {
                return JDialogToolsUpgradeRipFirmware.this.m_aszColumnNames.length;
            }

            public int getRowCount() {
                return JDialogToolsUpgradeRipFirmware.this.m_upgradeTable == null ? 0 : JDialogToolsUpgradeRipFirmware.this.m_upgradeTable.length;
            }

            public String getColumnName(int n) {
                return JDialogToolsUpgradeRipFirmware.this.m_aszColumnNames[n];
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public Object getValueAt(int n, int n2) {
                Object var3_3 = null;
                if (n > -1 && n < JDialogToolsUpgradeRipFirmware.this.m_upgradeTable.length) {
                    void var3_9;
                    RipType ripType = JDialogToolsUpgradeRipFirmware.this.m_upgradeTable[n];
                    if (n2 == 0) {
                        CheckableItem checkableItem = ripType.getType();
                        return var3_9;
                    }
                    if (n2 == 1 && JDialogToolsUpgradeRipFirmware.this.m_nMajorMibVersion < 2) {
                        String string = ripType.getAvailableVers();
                        return var3_9;
                    }
                    if (n2 == 2 && JDialogToolsUpgradeRipFirmware.this.m_nMajorMibVersion < 2 || n2 == 1 && JDialogToolsUpgradeRipFirmware.this.m_nMajorMibVersion >= 2) {
                        if (JDialogToolsUpgradeRipFirmware.this.m_bAnUpgradeInProgress && JDialogToolsUpgradeRipFirmware.this.m_aiSavedVersionMismatches != null && n < JDialogToolsUpgradeRipFirmware.this.m_aiSavedVersionMismatches.length) {
                            Integer n3 = JDialogToolsUpgradeRipFirmware.this.m_aiSavedVersionMismatches[n];
                            return var3_9;
                        }
                        Integer n4 = ripType.getVersMismatches();
                        return var3_9;
                    }
                    if (n2 == 3 && JDialogToolsUpgradeRipFirmware.this.m_nMajorMibVersion < 2 || n2 == 2 && JDialogToolsUpgradeRipFirmware.this.m_nMajorMibVersion >= 2) {
                        NameValue nameValue = ripType.getUpgradeStatus();
                        return var3_9;
                    }
                    String string = String.valueOf(JDialogToolsUpgradeRipFirmware.this.m_aszColumnNames.length - 1);
                    throw new RuntimeException("Invalid column index (" + n2 + ">" + string + ")");
                }
                String string = String.valueOf(JDialogToolsUpgradeRipFirmware.this.m_upgradeTable.length - 1);
                throw new RuntimeException("Invalid row index (" + n + ">" + string + ")");
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        return abstractTableModel;
    }

    private void setTableSize() {
        int n = this.m_jTable.getRowHeight() + 5;
        int n2 = Math.max(MIN_VISIBLE_ROWS, this.m_upgradeTable.length);
        int n3 = (n2 + 1) * n;
        Dimension dimension = this.m_jScrollPane.getPreferredSize();
        dimension.setSize((int)Math.ceil(dimension.getWidth()), n3);
        this.m_jScrollPane.setPreferredSize(dimension);
    }

    private void updateDynamicInfo() {
        if (this.isShowing() && !this.m_bRequestingUpgrade) {
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableIndex");
                arrayList.add("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableVersionMismatches");
                arrayList.add("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableControl");
                arrayList.add("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableStatus");
                if (this.m_nMajorMibVersion >= 2) {
                    arrayList.add("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableFailCode");
                } else {
                    arrayList.add("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableFailReason");
                    arrayList.add("avocent.ds.dsManagement.dsPort.dsRipUpgradeTable.dsRipUpgradeTableEntry.dsRipUpgradeTableVersionAvailable");
                }
                InterfaceValueObject[][] interfaceValueObjectArray = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), arrayList.toArray());
                boolean bl = false;
                final RipType[] ripTypeArray = new RipType[interfaceValueObjectArray.length];
                for (int i = 0; i < interfaceValueObjectArray.length; ++i) {
                    SnmpValueObject snmpValueObject = (SnmpValueObject)interfaceValueObjectArray[i][0];
                    String string = snmpValueObject.toString();
                    CheckableItem checkableItem = new CheckableItem(string, false);
                    NameValue nameValue = (NameValue)interfaceValueObjectArray[i][3].getValue();
                    Integer n = (Integer)nameValue.getValue();
                    boolean bl2 = bl = bl || n.equals(UPGR_INPROGRESS_VAL);
                    if (n.equals(UPGR_READY_VAL)) {
                        nameValue.setName("");
                    }
                    String string2 = "";
                    if (interfaceValueObjectArray[i].length > 5) {
                        string2 = interfaceValueObjectArray[i][5].toString();
                    }
                    ripTypeArray[i] = new RipType(snmpValueObject.getInteger(), checkableItem, string2, (Integer)interfaceValueObjectArray[i][1].getValue(), interfaceValueObjectArray[i][2], nameValue, interfaceValueObjectArray[i][4].toString());
                }
                this.m_bAnUpgradeInProgress = bl;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int n;
                        Vector<Integer> vector = new Vector<Integer>(JDialogToolsUpgradeRipFirmware.this.m_upgradeTable.length);
                        for (n = 0; n < JDialogToolsUpgradeRipFirmware.this.m_upgradeTable.length; ++n) {
                            if (!JDialogToolsUpgradeRipFirmware.this.m_upgradeTable[n].isSelected()) continue;
                            vector.addElement(JDialogToolsUpgradeRipFirmware.this.m_upgradeTable[n].getIndex());
                        }
                        JDialogToolsUpgradeRipFirmware.access$402(JDialogToolsUpgradeRipFirmware.this, ripTypeArray);
                        for (n = 0; n < JDialogToolsUpgradeRipFirmware.this.m_upgradeTable.length; ++n) {
                            if (!vector.contains(JDialogToolsUpgradeRipFirmware.this.m_upgradeTable[n].getIndex())) continue;
                            JDialogToolsUpgradeRipFirmware.this.m_upgradeTable[n].setSelected(true);
                        }
                        JDialogToolsUpgradeRipFirmware.this.showInProgressMsg(JDialogToolsUpgradeRipFirmware.this.m_bAnUpgradeInProgress);
                        if (!JDialogToolsUpgradeRipFirmware.this.m_bAnUpgradeInProgress) {
                            if (JDialogToolsUpgradeRipFirmware.this.m_bOurUpgradeInProgress) {
                                JDialogToolsUpgradeRipFirmware.this.m_bOurUpgradeInProgress = false;
                                String string = res.getString("JDialogToolsUpgradeRipFirmware_Upgrade_completed");
                                Message.show((Component)((Object)JDialogToolsUpgradeRipFirmware.this), (String)string);
                                for (int i = 0; i < JDialogToolsUpgradeRipFirmware.this.m_upgradeTable.length; ++i) {
                                    JDialogToolsUpgradeRipFirmware.this.m_upgradeTable[i].setSelected(false);
                                }
                            }
                            JDialogToolsUpgradeRipFirmware.this.setTableBusy(false);
                        }
                        JDialogToolsUpgradeRipFirmware.this.m_tableModel.fireTableDataChanged();
                    }
                });
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                if (this.isShowing() && !this.m_bRequestingUpgrade) {
                    String string = res.getString("JDialogToolsUpgradeRipFirmware_Unable_to_Read_Rip_Type");
                    if (this.m_bOurUpgradeInProgress) {
                        string = res.getString("JDialogToolsUpgradeRipFirmware_Unable_to_Upgrade_Rip_Type");
                    }
                    string = MessageFormat.format(string, RIP);
                    Message.show((Component)((Object)this), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
                }
                this.m_threadPollData.stopThread();
                this.dispose();
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("Exception updating dynamic info. " + exception.getMessage()), (Throwable)exception);
                if (this.isShowing() && !this.m_bRequestingUpgrade) {
                    this.m_acController.showException(null, TRACE_CONTEXT, "", (Throwable)exception);
                }
                this.m_threadPollData.stopThread();
                this.dispose();
            }
        }
    }

    private void showInProgressMsg(boolean bl) {
        this.m_jlInProgressMsg.setVisible(bl);
        this.m_jlInProgressFiller.setVisible(!bl);
    }

    private void m_jbUpgrade_actionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JDialogToolsUpgradeRipFirmware: Upgrade button pressed.");
        for (int i = 0; i < this.m_upgradeTable.length; ++i) {
            if (!this.m_upgradeTable[i].isSelected() || this.m_upgradeTable[i].getVersMismatches() != 0) continue;
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Upgrade requested for RIP type: " + this.m_upgradeTable[i].getType().toString() + ", but the version mismatches == 0 now."));
            String string = res.getString("JDialogToolsUpgradeRipFirmware_Rip_upgrade_not_needed");
            Message.show((Component)((Object)this), (String)string);
            for (int j = 0; j < this.m_upgradeTable.length; ++j) {
                if (this.m_upgradeTable[j].getVersMismatches() != 0) continue;
                this.m_upgradeTable[j].setSelected(false);
            }
            this.m_tableModel.fireTableDataChanged();
            return;
        }
        this.setBusy(true);
        this.setTableBusy(true);
        Thread thread = new Thread(){

            public void run() {
                try {
                    JDialogToolsUpgradeRipFirmware.this.m_threadPollData.suspendThread();
                    JDialogToolsUpgradeRipFirmware.this.m_bRequestingUpgrade = true;
                    Integer[] integerArray = new Integer[JDialogToolsUpgradeRipFirmware.this.m_upgradeTable.length];
                    for (int i = 0; i < JDialogToolsUpgradeRipFirmware.this.m_upgradeTable.length; ++i) {
                        integerArray[i] = JDialogToolsUpgradeRipFirmware.this.m_upgradeTable[i].getVersMismatches();
                        if (!JDialogToolsUpgradeRipFirmware.this.m_upgradeTable[i].isSelected()) continue;
                        Trace.logInfo((String)JDialogToolsUpgradeRipFirmware.TRACE_CONTEXT, (String)("Upgrade requested for RIP type: " + JDialogToolsUpgradeRipFirmware.this.m_upgradeTable[i].getType().toString() + "..."));
                        JDialogToolsUpgradeRipFirmware.this.m_upgradeTable[i].getUpgradeStatus().setName("");
                        InterfaceValueObject[] interfaceValueObjectArray = new InterfaceValueObject[]{JDialogToolsUpgradeRipFirmware.this.m_upgradeTable[i].getUpgradeControl()};
                        interfaceValueObjectArray[0].setValue((Object)REQUEST_UPGRADE);
                        AvrSnmpHelper.setValues(JDialogToolsUpgradeRipFirmware.this.m_acController.getAsmpConnection(), interfaceValueObjectArray);
                        JDialogToolsUpgradeRipFirmware.this.m_bOurUpgradeInProgress = true;
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 11 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                11.access$1800(this.this$1).m_jbUpgrade.setEnabled(false);
                            }
                        });
                    }
                    JDialogToolsUpgradeRipFirmware.access$902(JDialogToolsUpgradeRipFirmware.this, integerArray);
                    JDialogToolsUpgradeRipFirmware.this.setBusy(false);
                    JDialogToolsUpgradeRipFirmware.this.m_bRequestingUpgrade = false;
                    if (JDialogToolsUpgradeRipFirmware.this.isShowing()) {
                        11.sleep(5000L);
                        JDialogToolsUpgradeRipFirmware.this.m_threadPollData.resumeThread();
                    }
                }
                catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                    Trace.logError((String)JDialogToolsUpgradeRipFirmware.TRACE_CONTEXT, (String)("Attempt to upgrade failed with exception: " + exceptionAsmpRequestFailed.getMessage()), (Throwable)exceptionAsmpRequestFailed);
                    if (JDialogToolsUpgradeRipFirmware.this.isShowing()) {
                        String string = res.getString("JDialogToolsUpgradeRipFirmware_Unable_to_Upgrade_Rip_Type");
                        string = MessageFormat.format(string, RIP);
                        Message.show((Component)((Object)JDialogToolsUpgradeRipFirmware.this), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
                        if (JDialogToolsUpgradeRipFirmware.this.isShowing()) {
                            JDialogToolsUpgradeRipFirmware.this.m_threadPollData.resumeThread();
                        }
                        JDialogToolsUpgradeRipFirmware.this.m_bRequestingUpgrade = false;
                    }
                    JDialogToolsUpgradeRipFirmware.this.dispose();
                }
                catch (Exception exception) {
                    Trace.logError((String)JDialogToolsUpgradeRipFirmware.TRACE_CONTEXT, (String)("Attempt to upgrade failed with exception: " + exception.getMessage()), (Throwable)exception);
                    if (JDialogToolsUpgradeRipFirmware.this.isShowing()) {
                        JDialogToolsUpgradeRipFirmware.this.m_acController.showException(null, JDialogToolsUpgradeRipFirmware.TRACE_CONTEXT, "", (Throwable)exception);
                        if (JDialogToolsUpgradeRipFirmware.this.isShowing()) {
                            JDialogToolsUpgradeRipFirmware.this.m_threadPollData.resumeThread();
                        }
                        JDialogToolsUpgradeRipFirmware.this.m_bRequestingUpgrade = false;
                    }
                    JDialogToolsUpgradeRipFirmware.this.dispose();
                }
            }

            static /* synthetic */ JDialogToolsUpgradeRipFirmware access$1800(11 var0) {
                return var0.JDialogToolsUpgradeRipFirmware.this;
            }
        };
        thread.start();
    }

    private void m_jbClose_actionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Close pressed. \"" + this.getTitle() + "\" dialog is closing..."));
        this.m_threadPollData.stopThread();
        this.dispose();
    }

    private void m_jbHelp_actionPerformed(ActionEvent actionEvent) {
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.nmm.avr.Help");
            Trace.logInfo((String)"Help", (String)"Successfully loaoded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.nmm.avr.Help");
        }
        BrowserHelper.showHelpPage((JFrame)((JFrame)this.getOwner()), (String)resourceBundle.getString("IDH_UPGRADE_RIP_FIRMWARE"));
    }

    public boolean doEscape() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("<ESC> key pressed. \"" + this.getTitle() + "\" dialog is closing..."));
        this.m_threadPollData.stopThread();
        return false;
    }

    private void this_windowClosing(WindowEvent windowEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("\"" + this.getTitle() + "\" dialog is closing..."));
        this.m_threadPollData.stopThread();
        this.dispose();
    }

    private void setTableBusy(boolean bl) {
        final boolean bl2 = bl;
        Runnable runnable = new Runnable(){

            public void run() {
                if (bl2) {
                    JDialogToolsUpgradeRipFirmware.this.m_jpEventTrapper.enableEventTrapping();
                    JDialogToolsUpgradeRipFirmware.this.m_jpEventTrapper.setCursor(Cursor.getPredefinedCursor(3));
                } else {
                    JDialogToolsUpgradeRipFirmware.this.m_jpEventTrapper.disableEventTrapping();
                    JDialogToolsUpgradeRipFirmware.this.m_jpEventTrapper.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    void setBusy(boolean bl) {
        final Component component = this.getGlassPane();
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (bl2) {
                    component.setVisible(true);
                    JDialogToolsUpgradeRipFirmware.this.setCursor(Cursor.getPredefinedCursor(3));
                } else {
                    component.setVisible(false);
                    JDialogToolsUpgradeRipFirmware.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    private void setUpgradeButtonState() {
        if (!this.m_bOurUpgradeInProgress) {
            boolean bl = false;
            for (int i = 0; i < this.m_upgradeTable.length; ++i) {
                bl = bl || this.m_upgradeTable[i].isSelected();
            }
            this.m_jbUpgrade.setEnabled(bl);
        }
    }

    static /* synthetic */ RipType[] access$402(JDialogToolsUpgradeRipFirmware jDialogToolsUpgradeRipFirmware, RipType[] ripTypeArray) {
        jDialogToolsUpgradeRipFirmware.m_upgradeTable = ripTypeArray;
        return ripTypeArray;
    }

    static /* synthetic */ Integer[] access$902(JDialogToolsUpgradeRipFirmware jDialogToolsUpgradeRipFirmware, Integer[] integerArray) {
        jDialogToolsUpgradeRipFirmware.m_aiSavedVersionMismatches = integerArray;
        return integerArray;
    }

    class RipType {
        Integer m_iIndex;
        CheckableItem m_ciRipType;
        String m_szAvailableVers;
        Integer m_iVersMismatches;
        InterfaceValueObject m_ivoUpgradeControl;
        NameValue m_nvUpgradeStatus;
        String m_szUpgradeFailureReason;
        boolean m_bUpgradeInProgress;

        RipType(Integer n, CheckableItem checkableItem, String string, Integer n2, InterfaceValueObject interfaceValueObject, NameValue nameValue, String string2) {
            this.m_iIndex = n;
            this.m_ciRipType = checkableItem;
            this.m_szAvailableVers = string;
            this.m_iVersMismatches = n2;
            this.m_ivoUpgradeControl = interfaceValueObject;
            this.m_nvUpgradeStatus = nameValue;
            this.m_szUpgradeFailureReason = string2;
            this.m_bUpgradeInProgress = false;
        }

        public Integer getIndex() {
            return this.m_iIndex;
        }

        public void setSelected(boolean bl) {
            this.m_ciRipType.setSelected(bl);
        }

        public boolean isSelected() {
            return this.m_ciRipType.isSelected();
        }

        public CheckableItem getType() {
            return this.m_ciRipType;
        }

        public void setAvailableVers(String string) {
            this.m_szAvailableVers = string;
        }

        public String getAvailableVers() {
            return this.m_szAvailableVers;
        }

        public void setVersMismatches(Integer n) {
            this.m_iVersMismatches = n;
        }

        public Integer getVersMismatches() {
            return this.m_iVersMismatches;
        }

        public InterfaceValueObject getUpgradeControl() {
            return this.m_ivoUpgradeControl;
        }

        public void setUpgradeStatus(NameValue nameValue) {
            this.m_nvUpgradeStatus = nameValue;
        }

        public NameValue getUpgradeStatus() {
            return this.m_nvUpgradeStatus;
        }

        public void setUpgradeFailureReason(String string) {
            this.m_szUpgradeFailureReason = string;
        }

        public String getUpgradeFailureReason() {
            return this.m_szUpgradeFailureReason;
        }

        public void setUpgradeInProgress(boolean bl) {
            this.m_bUpgradeInProgress = bl;
        }

        public boolean isUpgradeInProgress() {
            return this.m_bUpgradeInProgress;
        }
    }

    class ThreadPollData
    extends ThreadContinuous {
        private boolean m_bThreadSuspended;

        ThreadPollData() {
            super(5000L);
            this.m_bThreadSuspended = false;
        }

        protected void performTask() {
            if (!this.m_bThreadSuspended) {
                JDialogToolsUpgradeRipFirmware.this.updateDynamicInfo();
            }
        }

        public void suspendThread() {
            Trace.logInfo((String)JDialogToolsUpgradeRipFirmware.TRACE_CONTEXT, (String)"ThreadPollData: thread suspended.");
            this.m_bThreadSuspended = true;
        }

        public void resumeThread() {
            Trace.logInfo((String)JDialogToolsUpgradeRipFirmware.TRACE_CONTEXT, (String)"ThreadPollData: thread resumed.");
            this.m_bThreadSuspended = false;
        }
    }
}

