/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AmpControllerAvr;
import com.avocent.avworks.nmm.avr.AvrAidpHelper;
import com.avocent.avworks.nmm.avr.AvrAsmpHelper;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.common.AsmpConnection;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceSnmpClient;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.avworks.nmm.common.PanelTreePathPair;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksService;
import com.avocent.avworks.services.BrowserHelper;
import com.avocent.avworks.services.FlashFileHeader;
import com.avocent.avworks.services.InterfaceAmpPanel;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.exceptions.ExceptionUserCancelled;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.dialogs.InputStreamProgressMonitoring;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.JDialogProgress;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.util.ResourceManager;
import com.avocent.protocols.aidp.AidpSession;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JDialogUpgradeApplianceFirmware
extends JDialogCentered
implements InterfaceSnmpClient {
    public static final String CNAME = "JDialogUpgradeApplianceFirmware";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    JPanel m_jPanelFileSelect = new JPanel();
    JPanel m_jPanelSelect = new JPanel();
    JPanel m_jPanelSubSelect = new JPanel();
    JLabel m_jlServerIPLabel = new JLabel();
    JTextField m_jtfServerIP = new JTextField();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout contentLayout = new GridBagLayout();
    JLabel m_jlFilrmwareFilenameLabel = new JLabel();
    JTextField m_jtfFilrmwareFilename = new JTextField();
    JLabel m_jLabelLoadFrom = new JLabel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JRadioButton m_jRadioTftp = new JRadioButton();
    JRadioButton m_jRadioAsmp = new JRadioButton();
    ButtonGroup m_fileSelectGroup = new ButtonGroup();
    JPanel m_jpButtonPanel = new JPanel();
    JButton m_jbUpgradeButton = new JButton();
    JButton m_jbHelpButton = new JButton();
    JButton m_jbCloseButton = new JButton();
    JSeparator m_jlLine = new JSeparator();
    JPanel m_jpFileSelectCardPanel = new JPanel();
    CardLayout m_clFileSelectLayout = new CardLayout();
    JPanel m_jpAsmpFirmwareFile = new JPanel();
    JLabel m_jlAsmpFirmwareFileLabel = new JLabel();
    JTextField m_jtfAsmpFirmwareFilename = new JTextField();
    JButton m_jbfAsmpFileBrowse = new JButton();
    JPanel m_jpMessagePanel = new JPanel();
    CardLayout m_clMessagePanelLayoutManager = new CardLayout();
    JLabel jLabelUpgradeFailedReason = new JLabel();
    protected JFileChooser m_jfcFileChooser;
    protected File m_fBaseDirectory;
    public static final String TRACE_CONTEXT = "Upgrade Firmware Dialog";
    public static final int TIMER_INTERVAL = 1000;
    AmpControllerAvr m_acController;
    protected AidpSession m_asAidpSession;
    protected AsmpConnection m_acAnonAsmpConnection;
    protected boolean m_bRebootInProgress = false;
    protected ThreadUpgradeMonitor m_tumUpgradeMonitor;
    protected ThreadRebootMonitor m_trmRebootMonitor;
    protected static final String UPGRADE_READY = "upgrade_ready";
    protected static final String UPGRADE_IN_PROGRESS_TFTP = "upgrade_in_progress";
    protected static final String UPGRADE_IN_PROGRESS_ASMP = "upgrade_in_progress";
    protected static final String UPGRADE_SUCCEEDED = "upgrade_succeeded";
    protected static final String UPGRADE_FAILED = "upgrade_failed";
    protected static final String REBOOT_IN_PROGRESS = "reboot_in_progress";
    protected static final String REBOOT_KEYBOARD_FAILED = "reboot_keyboard_failure";
    protected static final String REBOOT_SUBSYSTEM = "reboot_subsystem_upgrade";
    protected static final String REBOOT_VIDEO_FAILED = "reboot_video_failure";
    protected static final String REBOOT_READY = "reboot_has_completed";
    protected static final String UNEXPECTED_STATUS = "unexpected_status";
    protected static final String WAITING_MESSAGE = "waiting";
    protected static final String PREVIOUS_FW_LOADED = "previous_fw_loaded";
    protected static final String DOWNLOADING = "download_in_progress";
    public static final String EMPTY_MESSAGE = "empty_message";
    private static Object[] APPLIANCE = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
    public static final String TITLE = MessageFormat.format(res.getString("JDialogUpgradeApplianceFirmware_Upgrade_RIP_Firmware"), APPLIANCE);
    private int m_nUpgradeMessageCount = 0;
    private int m_nRebootMessageCount = 0;
    private boolean SIMULATE_UPGRADE = false;
    protected static final int WAITING = -5;
    public static final String TFTP = "TFTP_Panel";
    public static final String ASMP = "ASMP_Panel";
    private String m_szFileName = "firmware.txt";
    JDialogProgress m_jdpProgress;
    InputStream m_firmwareStream = null;
    File m_firmwareFile = null;
    JDialogUpgradeApplianceFirmware m_this;

    public JDialogUpgradeApplianceFirmware() throws ExceptionConstructorFailed {
        this(null);
    }

    public JDialogUpgradeApplianceFirmware(AmpControllerAvr ampControllerAvr) throws ExceptionConstructorFailed {
        super((Frame)ampControllerAvr.getMainFrame(), TITLE, true);
        try {
            this.jbInit();
            this.m_this = this;
            this.m_acController = ampControllerAvr;
            this.setResizable(false);
            Dimension dimension = this.m_jtfFilrmwareFilename.getPreferredSize();
            this.m_jtfFilrmwareFilename.setPreferredSize(new Dimension(300, (int)Math.ceil(dimension.getHeight())));
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    JDialogUpgradeApplianceFirmware.this.checkCloseWindow();
                }
            });
            ButtonPanel.equalize((JPanel)this.m_jpButtonPanel);
            this.getRootPane().setDefaultButton(this.m_jbUpgradeButton);
            this.pack();
            int n = this.m_acController.getAppliance().getMibMajorVersion();
            this.mibSpecificSetup();
            this.setDefaultDirectory();
        }
        catch (Exception exception) {
            String string = res.getString("JDialogUpgradeApplianceFirmware_Failed_to_construct1");
            Trace.logError((String)this.getTraceContext(), (String)string, (Throwable)exception);
            throw new ExceptionConstructorFailed(string);
        }
    }

    void mibSpecificSetup() {
        if (!this.m_acController.getAppliance().hasMinMibVersion(2, 0)) {
            this.m_clFileSelectLayout.show(this.m_jpFileSelectCardPanel, TFTP);
            this.m_jtfServerIP.requestFocus();
            this.m_jRadioTftp.getModel().setSelected(true);
            this.m_jRadioAsmp.getModel().setEnabled(false);
            this.m_jRadioTftp.getModel().setEnabled(true);
        } else {
            this.m_clFileSelectLayout.show(this.m_jpFileSelectCardPanel, ASMP);
            this.m_jtfAsmpFirmwareFilename.requestFocus();
            this.m_jRadioAsmp.getModel().setSelected(true);
            this.m_jRadioTftp.getModel().setEnabled(true);
            this.m_jRadioAsmp.getModel().setEnabled(true);
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.contentLayout);
        this.m_jLabelLoadFrom.setText(res.getString("JDialogUpgradeApplianceFirmware_Load_From"));
        this.m_jRadioTftp.setText(res.getString("JDialogUpgradeApplianceFirmware_Tftp"));
        this.m_jRadioTftp.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JDialogUpgradeApplianceFirmware.this.m_jRadioTftp_stateChanged(changeEvent);
            }
        });
        this.m_jRadioAsmp.setText(res.getString("JDialogUpgradeApplianceFirmware_Asmp"));
        this.m_fileSelectGroup.add(this.m_jRadioTftp);
        this.m_fileSelectGroup.add(this.m_jRadioAsmp);
        this.m_jPanelSubSelect.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.m_jPanelSubSelect, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 12, 0, 10), 0, 0));
        this.m_jPanelSelect.setLayout(this.gridBagLayout3);
        this.m_jPanelSubSelect.add((Component)this.m_jPanelSelect, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_jPanelSelect.add((Component)this.m_jLabelLoadFrom, new GridBagConstraints(0, 0, 1, 1, 0.1, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_jPanelSelect.add((Component)this.m_jRadioTftp, new GridBagConstraints(1, 0, 1, 1, 0.6, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.m_jPanelSelect.add((Component)this.m_jRadioAsmp, new GridBagConstraints(2, 0, 1, 1, 0.6, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.m_jPanelSubSelect.add((Component)new JPanel(), new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.m_jbUpgradeButton.setText(res.getString("JDialogUpgradeApplianceFirmware_Upgrade"));
        this.m_jbUpgradeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogUpgradeApplianceFirmware.this.m_jbUpgradeButton_actionPerformed(actionEvent);
            }
        });
        this.m_jbHelpButton.setText(res.getString("JDialogUpgradeApplianceFirmware_Help"));
        this.m_jbHelpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogUpgradeApplianceFirmware.this.m_jbHelpButton_actionPerformed(actionEvent);
            }
        });
        this.m_jbCloseButton.setText(res.getString("JDialogUpgradeApplianceFirmware_Close"));
        this.m_jbCloseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogUpgradeApplianceFirmware.this.m_jbCloseButton_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.m_jlLine, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 12, 5, 10), 0, 0));
        this.m_jpFileSelectCardPanel.setLayout(this.m_clFileSelectLayout);
        this.getContentPane().add((Component)this.m_jpFileSelectCardPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 12, 0, 10), 0, 0));
        this.m_jlServerIPLabel.setText(res.getString("JDialogUpgradeApplianceFirmware_TFTP_Server_IP"));
        this.m_jlFilrmwareFilenameLabel.setText(res.getString("JDialogUpgradeApplianceFirmware_Firmware_Filename_"));
        this.m_jPanelFileSelect.setLayout(this.gridBagLayout1);
        this.m_jpFileSelectCardPanel.add((Component)this.m_jPanelFileSelect, TFTP);
        this.m_jPanelFileSelect.add((Component)this.m_jlServerIPLabel, new GridBagConstraints(0, 0, 1, 1, 0.1, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_jPanelFileSelect.add((Component)this.m_jtfServerIP, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.m_jPanelFileSelect.add((Component)new JPanel(), new GridBagConstraints(2, 0, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.m_jPanelFileSelect.add((Component)this.m_jlFilrmwareFilenameLabel, new GridBagConstraints(0, 1, 1, 1, 0.1, 1.0, 17, 2, new Insets(8, 0, 0, 0), 0, 0));
        this.m_jPanelFileSelect.add((Component)this.m_jtfFilrmwareFilename, new GridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 17, 2, new Insets(8, 5, 0, 0), 0, 0));
        this.m_jbfAsmpFileBrowse.setText(res.getString("JDialogUpgradeApplianceFirmware_Browse"));
        this.m_jlAsmpFirmwareFileLabel.setText(res.getString("JDialogUpgradeApplianceFirmware_Firmware_Filename_"));
        this.m_jbfAsmpFileBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogUpgradeApplianceFirmware.this.m_jbfAsmpFileBrowse_actionPerformed(actionEvent);
            }
        });
        this.m_jpAsmpFirmwareFile.setLayout(new GridBagLayout());
        this.m_jpFileSelectCardPanel.add((Component)this.m_jpAsmpFirmwareFile, ASMP);
        this.m_jpAsmpFirmwareFile.add((Component)this.m_jlAsmpFirmwareFileLabel, new GridBagConstraints(0, 0, 1, 1, 0.1, 1.0, 17, 2, new Insets(0, 0, 12, 0), 0, 0));
        this.m_jpAsmpFirmwareFile.add((Component)this.m_jtfAsmpFirmwareFilename, new GridBagConstraints(1, 0, 3, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 12, 0), 0, 0));
        this.m_jpAsmpFirmwareFile.add((Component)new JLabel(" "), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_jpAsmpFirmwareFile.add((Component)this.m_jbfAsmpFileBrowse, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_jpMessagePanel.setLayout(this.m_clMessagePanelLayoutManager);
        this.getContentPane().add((Component)this.m_jpMessagePanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(8, 12, 0, 10), 0, 0));
        this.m_jpMessagePanel.add((Component)new JPanel(), EMPTY_MESSAGE);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(-1, -1, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        JLabel jLabel = new JLabel(res.getString("JDialogUpgradeApplianceFirmware_Error_upgrading"));
        jLabel.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(-1, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(4, 0, 0, 0), 0, 0);
        this.jLabelUpgradeFailedReason = new JLabel(res.getString("JDialogUpgradeApplianceFirmware_Reason") + res.getString("JDialogUpgradeApplianceFirmware_Reason") + res.getString("MibEnumAvocentAvr_ENUM_imageUpgradeBadType") + res.getString("JDialogUpgradeApplianceFirmware_Reason"));
        this.jLabelUpgradeFailedReason.setHorizontalAlignment(2);
        jPanel.add((Component)this.jLabelUpgradeFailedReason, gridBagConstraints);
        this.m_jpMessagePanel.add((Component)jPanel, UPGRADE_FAILED);
        this.setupUpgradeMessage(UPGRADE_READY, res.getString("JDialogUpgradeApplianceFirmware_image_update_ready"));
        this.setupUpgradeMessage("upgrade_in_progress", res.getString("JDialogUpgradeApplianceFirmware_TFTP_update_is"));
        this.setupUpgradeMessage("upgrade_in_progress", res.getString("JDialogUpgradeApplianceFirmware_ASMP_copy"));
        this.setupUpgradeMessage(UPGRADE_SUCCEEDED, res.getString("JDialogUpgradeApplianceFirmware_Firmware_File_Transfer_Complete"));
        this.setupUpgradeMessage(UNEXPECTED_STATUS, res.getString("JDialogUpgradeApplianceFirmware_Unexpected_appliance"));
        String string = res.getString("JDialogUpgradeApplianceFirmware_Reboot_has_completed");
        string = MessageFormat.format(string, APPLIANCE);
        this.setupUpgradeMessage(REBOOT_READY, string);
        this.setupRebootMessage(WAITING_MESSAGE, res.getString("JDialogUpgradeApplianceFirmware_reboot_waiting"));
        this.setupRebootMessage(REBOOT_IN_PROGRESS, res.getString("JDialogUpgradeApplianceFirmware_Reboot_status_In"));
        this.setupRebootMessage(REBOOT_SUBSYSTEM, res.getString("JDialogUpgradeApplianceFirmware_Reboot_status"));
        this.setupUpgradeMessage(REBOOT_VIDEO_FAILED, res.getString("JDialogUpgradeApplianceFirmware_Reboot_status_Video"));
        this.setupUpgradeMessage(REBOOT_KEYBOARD_FAILED, res.getString("JDialogUpgradeApplianceFirmware_Reboot_status1"));
        string = res.getString("JDialogUpgradeApplianceFirmware_Old_Firwmare_loaded");
        string = MessageFormat.format(string, APPLIANCE);
        this.setupUpgradeMessage(PREVIOUS_FW_LOADED, string);
        this.m_clMessagePanelLayoutManager.show(this.m_jpMessagePanel, EMPTY_MESSAGE);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 2, new Insets(10, 0, 5, 10), 0, 0));
        jPanel.add((Component)new JLabel(" "), new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_jpButtonPanel, new GridBagConstraints(1, 0, 1, 1, 0.1, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_jpButtonPanel.add((Component)this.m_jbUpgradeButton, null);
        this.m_jpButtonPanel.add((Component)this.m_jbCloseButton, null);
        this.m_jpButtonPanel.add((Component)this.m_jbHelpButton, null);
    }

    void m_jRadioTftp_stateChanged(ChangeEvent changeEvent) {
        if (this.m_jRadioTftp.getModel().isSelected()) {
            this.m_clFileSelectLayout.show(this.m_jpFileSelectCardPanel, TFTP);
            this.m_jtfServerIP.requestFocus();
        } else {
            this.m_clFileSelectLayout.show(this.m_jpFileSelectCardPanel, ASMP);
            this.m_jtfAsmpFirmwareFilename.requestFocus();
        }
    }

    private void setupUpgradeMessage(String string, String string2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(-1, -1, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        JLabel jLabel = new JLabel(string2);
        jLabel.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(-1, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(4, 0, 0, 0), 0, 0);
        JLabel jLabel2 = new JLabel(" ");
        jLabel2.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.m_jpMessagePanel.add((Component)jPanel, string);
    }

    private void setupRebootMessage(String string, String string2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(-1, -1, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
        JLabel jLabel = new JLabel(string2);
        jLabel.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(-1, -1, 0, 1, 1.0, 0.0, 17, 2, new Insets(4, 0, 0, 0), 0, 0);
        String string3 = res.getString("JDialogUpgradeApplianceFirmware_WARNING_Do_NOT_power");
        string3 = MessageFormat.format(string3, APPLIANCE);
        JLabel jLabel2 = new JLabel(string3);
        jLabel2.setForeground(Color.red);
        jLabel2.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.m_jpMessagePanel.add((Component)jPanel, string);
    }

    public void showDialog() {
        boolean bl = false;
        try {
            Object object;
            InterfaceValueObject[] interfaceValueObjectArray;
            if (this.getUpgradeStatus() == 2) {
                String string = res.getString("JDialogUpgradeApplianceFirmware_Appliance_firmware");
                string = MessageFormat.format(string, APPLIANCE);
                Message.show((Component)this.m_acController.getMainFrame(), (String)string);
                bl = true;
                return;
            }
            Vector vector = this.m_acController.getPanelList();
            boolean bl2 = false;
            for (int i = 0; i < vector.size(); ++i) {
                interfaceValueObjectArray = (InterfaceValueObject[])vector.elementAt(i);
                object = interfaceValueObjectArray.getPanel();
                if (!object.isModified()) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                String string = res.getString("JDialogUpgradeApplianceFirmware_Firmware_upgrade_warning");
                string = MessageFormat.format(string, APPLIANCE);
                int n = JOptionPaneFixedSize.showConfirmDialog((Component)this.m_acController.getMainFrame(), (Object)string, (String)TITLE, (int)0);
                if (n == 1 || n == -1) {
                    return;
                }
            }
            Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableTftpIPAddress.1", "avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableUpgradeFileName.1"};
            try {
                interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), objectArray);
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                String string = res.getString("JDialogUpgradeApplianceFirmware_Unable_to_Upgrade_Appliance");
                string = MessageFormat.format(string, APPLIANCE);
                Message.show((Component)this.m_acController.getMainFrame(), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
                return;
            }
            catch (Exception exception) {
                this.m_acController.showException(null, this.getTraceContext(), res.getString("JDialogUpgradeApplianceFirmware_Error_while_JDUAF"), exception);
                return;
            }
            if (interfaceValueObjectArray.length != 2) {
                this.m_acController.showInternalError();
                return;
            }
            object = interfaceValueObjectArray[0].getString();
            IpAddress ipAddress = new IpAddress((String)object);
            if (ipAddress.isLoopbackAddress() || ipAddress.isZeroAddress()) {
                object = "";
            }
            Object object2 = object;
            String string = interfaceValueObjectArray[1].getString();
            Runnable runnable = new Runnable(){

                public void run() {
                    JDialogUpgradeApplianceFirmware.this.setLocationRelativeTo((Component)JDialogUpgradeApplianceFirmware.this.m_acController.getMainFrame());
                    JDialogUpgradeApplianceFirmware.this.setVisible(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
            runnable = new Runnable((String)object2, string){
                private final /* synthetic */ String val$szfTftpIp;
                private final /* synthetic */ String val$szfFirmwareFile;
                {
                    this.val$szfTftpIp = string;
                    this.val$szfFirmwareFile = string2;
                }

                public void run() {
                    JDialogUpgradeApplianceFirmware.this.m_jtfServerIP.setText(this.val$szfTftpIp);
                    JDialogUpgradeApplianceFirmware.this.m_jtfFilrmwareFilename.setText(this.val$szfFirmwareFile);
                    JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, JDialogUpgradeApplianceFirmware.EMPTY_MESSAGE);
                    JDialogUpgradeApplianceFirmware.this.enableDialog(true);
                    JDialogUpgradeApplianceFirmware.this.m_jtfServerIP.requestFocus();
                }
            };
            SwingUtilities.invokeLater(runnable);
            if (this.m_acController.getAppliance().hasMinMibVersion(2, 0) && this.m_jfcFileChooser == null) {
                this.createFileChooser();
            }
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            String string = res.getString("JDialogUpgradeApplianceFirmware_Unable_to_Upgrade_Appliance");
            string = MessageFormat.format(string, APPLIANCE);
            Message.show((Component)this.m_acController.getMainFrame(), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
        }
        catch (Exception exception) {
            this.m_acController.showException(null, this.getTraceContext(), res.getString("JDialogUpgradeApplianceFirmware_Error_upgrading"), exception);
        }
    }

    void m_jbUpgradeButton_actionPerformed(ActionEvent actionEvent) {
        if (this.m_jRadioAsmp.getModel().isSelected()) {
            this.upgradeFirmwareAsmp(actionEvent);
        } else {
            this.upgradeFirmwareTftp(actionEvent);
        }
    }

    void upgradeFirmwareTftp(ActionEvent actionEvent) {
        Object[] objectArray;
        try {
            objectArray = new IpAddress(this.m_jtfServerIP.getText().trim());
            if (objectArray.isLoopbackAddress()) {
                Message.show((Component)((Object)this), (String)res.getString("JDialogUpgradeApplianceFirmware_Invalid_IP_Loopback"));
                this.m_jtfServerIP.requestFocus();
                return;
            }
            if (objectArray.isZeroAddress()) {
                Message.show((Component)((Object)this), (String)res.getString("JDialogUpgradeApplianceFirmware_Invalid_IP_0"));
                this.m_jtfServerIP.requestFocus();
                return;
            }
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Message.show((Component)((Object)this), (String)res.getString("JDialogUpgradeApplianceFirmware_Invalid_IP_Address"));
            this.m_jtfServerIP.requestFocus();
            return;
        }
        try {
            JPanelAmpPanel.validateString((JTextField)this.m_jtfFilrmwareFilename, (JLabel)this.m_jlFilrmwareFilenameLabel, (int)1, (int)255);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Message.show((Component)((Object)this), (String)exceptionInvalidArgument.getMessage());
            this.m_jtfFilrmwareFilename.requestFocus();
            return;
        }
        this.enableDialog(false);
        objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableTftpIPAddress.1", "avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableUpgradeFileName.1", "avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableUpgradeControl.1"};
        final Object[] objectArray2 = new Object[]{this.m_jtfServerIP.getText(), this.m_jtfFilrmwareFilename.getText(), new Integer(2)};
        Thread thread = new Thread("Send Upgrade Appliance Firmware Request"){

            public void run() {
                try {
                    AvrSnmpHelper.set(JDialogUpgradeApplianceFirmware.this.m_acController.getAsmpConnection(), objectArray, objectArray2);
                    if (JDialogUpgradeApplianceFirmware.this.m_tumUpgradeMonitor != null && JDialogUpgradeApplianceFirmware.this.m_tumUpgradeMonitor.isAlive()) {
                        JDialogUpgradeApplianceFirmware.this.m_tumUpgradeMonitor.m_bStopThread = true;
                    }
                    JDialogUpgradeApplianceFirmware.this.m_tumUpgradeMonitor = new ThreadUpgradeMonitor();
                    JDialogUpgradeApplianceFirmware.this.m_tumUpgradeMonitor.start();
                }
                catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                    if (JDialogUpgradeApplianceFirmware.this.isShowing()) {
                        String string = res.getString("JDialogUpgradeApplianceFirmware_Unable_to_Upgrade_Appliance");
                        string = MessageFormat.format(string, APPLIANCE);
                        Message.show((Component)((Object)JDialogUpgradeApplianceFirmware.this), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
                        JDialogUpgradeApplianceFirmware.this.enableDialog(true);
                    }
                    return;
                }
                catch (Exception exception) {
                    if (JDialogUpgradeApplianceFirmware.this.isShowing()) {
                        String string = res.getString("JDialogUpgradeApplianceFirmware_Exception_while_JDUAF");
                        JDialogUpgradeApplianceFirmware.this.m_acController.showException(null, JDialogUpgradeApplianceFirmware.this.getTraceContext(), string, exception);
                        JDialogUpgradeApplianceFirmware.this.enableDialog(true);
                    }
                    return;
                }
            }
        };
        thread.start();
    }

    void upgradeFirmwareAsmp(ActionEvent actionEvent) {
        Object object;
        try {
            JPanelAmpPanel.validateString((JTextField)this.m_jtfAsmpFirmwareFilename, (JLabel)this.m_jlAsmpFirmwareFileLabel, (int)1, (int)255);
            this.m_firmwareFile = new File(this.m_jtfAsmpFirmwareFilename.getText());
            if (!this.m_firmwareFile.exists()) {
                Message.show((Component)((Object)this), (String)res.getString("JDialogUpgradeApplianceFirmware_Error_File_Not_Found"));
                this.m_jtfAsmpFirmwareFilename.requestFocus();
                return;
            }
            this.m_firmwareStream = new FileInputStream(this.m_firmwareFile);
            object = new FlashFileHeader(this.m_firmwareStream);
            int n = object.getProductFamilyCode();
            int n2 = object.getProductOEMCode();
            String string = object.getVersion();
            long l = this.m_firmwareFile.length();
            this.m_firmwareStream.close();
            int n3 = this.m_acController.getApplianceInfo().getProductID();
            if (!object.isFirmwareFileCompatable(n3)) {
                Message.show((Component)((Object)this), (String)res.getString("JDialogUpgradeApplianceFirmware_NotCompatable"));
                this.m_jtfAsmpFirmwareFilename.requestFocus();
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                this.m_firmwareStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Message.show((Component)((Object)this), (String)res.getString("JDialogUpgradeApplianceFirmware_Error_File_Not_Found"));
            this.m_jtfAsmpFirmwareFilename.requestFocus();
            return;
        }
        catch (IOException iOException) {
            try {
                this.m_firmwareStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Message.show((Component)((Object)this), (String)res.getString("JDialogUpgradeApplianceFirmware_Error_FileHeader"));
            this.m_jtfAsmpFirmwareFilename.requestFocus();
            return;
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            try {
                this.m_firmwareStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Message.show((Component)((Object)this), (String)exceptionInvalidArgument.getMessage());
            this.m_jtfAsmpFirmwareFilename.requestFocus();
            return;
        }
        this.enableDialog(false);
        try {
            if (this.m_jdpProgress == null) {
                object = res.getString("JDialogUpgradeApplianceFirmware_Manage_0_");
                Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
                object = MessageFormat.format((String)object, objectArray);
                this.m_jdpProgress = new JDialogProgress((Dialog)((Object)this), (String)object);
            }
            this.m_firmwareStream = new InputStreamProgressMonitoring(this.m_firmwareFile, this.m_jdpProgress);
            this.m_jdpProgress.setValue(0);
            object = res.getString("JDialogUpgradeApplianceFirmware_Transfer_Firmware");
            Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
            object = MessageFormat.format((String)object, objectArray);
            this.m_jdpProgress.setStatusMessage((String)object);
            this.m_jdpProgress.pack();
            this.m_jdpProgress.checkCancelButton();
            this.m_jdpProgress.setEnableCancelButton(true);
            this.m_jdpProgress.disableParent();
            this.m_jdpProgress.setVisible(true);
            Thread thread = new Thread(){

                public void run() {
                    try {
                        AvrSnmpHelper.sendFile(JDialogUpgradeApplianceFirmware.this.m_acController.getAsmpConnection().getAsmpSession(), JDialogUpgradeApplianceFirmware.this.m_firmwareStream, JDialogUpgradeApplianceFirmware.this.m_firmwareFile.length(), JDialogUpgradeApplianceFirmware.this.m_szFileName);
                        JDialogUpgradeApplianceFirmware.this.m_firmwareStream.close();
                    }
                    catch (IOException iOException) {
                        try {
                            JDialogUpgradeApplianceFirmware.this.m_firmwareStream.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        String string = iOException.getMessage();
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$errMsg;
                            private final /* synthetic */ 10 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$errMsg = string;
                            }

                            public void run() {
                                10.access$200(this.this$1).m_jdpProgress.reEnableParent();
                                10.access$200(this.this$1).m_jdpProgress.setVisible(false);
                                10.access$200(this.this$1).enableDialog(true);
                                Message.show((Component)((Object)10.access$200(this.this$1).m_this), (String)this.val$errMsg);
                            }
                        });
                        return;
                    }
                    catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                        String string = exceptionAsmpRequestFailed.getMessage();
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$errMsg;
                            private final /* synthetic */ 10 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$errMsg = string;
                            }

                            public void run() {
                                10.access$200(this.this$1).m_jdpProgress.reEnableParent();
                                10.access$200(this.this$1).m_jdpProgress.setVisible(false);
                                10.access$200(this.this$1).enableDialog(true);
                                Message.show((Component)((Object)10.access$200(this.this$1).m_this), (String)this.val$errMsg);
                            }
                        });
                        return;
                    }
                    catch (ExceptionRequestFailed exceptionRequestFailed) {
                        String string = exceptionRequestFailed.getMessage();
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$errMsg;
                            private final /* synthetic */ 10 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$errMsg = string;
                            }

                            public void run() {
                                10.access$200(this.this$1).m_jdpProgress.reEnableParent();
                                10.access$200(this.this$1).m_jdpProgress.setVisible(false);
                                10.access$200(this.this$1).enableDialog(true);
                                Message.show((Component)((Object)10.access$200(this.this$1).m_this), (String)this.val$errMsg);
                            }
                        });
                        return;
                    }
                    catch (ExceptionUserCancelled exceptionUserCancelled) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 10 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                10.access$200(this.this$1).m_jdpProgress.reEnableParent();
                                10.access$200(this.this$1).m_jdpProgress.setVisible(false);
                                10.access$200(this.this$1).enableDialog(true);
                            }
                        });
                        return;
                    }
                    catch (Exception exception) {
                        String string = exception.getMessage();
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$errMsg;
                            private final /* synthetic */ 10 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$errMsg = string;
                            }

                            public void run() {
                                10.access$200(this.this$1).m_jdpProgress.reEnableParent();
                                10.access$200(this.this$1).m_jdpProgress.setVisible(false);
                                10.access$200(this.this$1).enableDialog(true);
                                Message.show((Component)((Object)10.access$200(this.this$1).m_this), (String)this.val$errMsg);
                            }
                        });
                        return;
                    }
                    JDialogUpgradeApplianceFirmware.this.m_jdpProgress.reEnableParent();
                    JDialogUpgradeApplianceFirmware.this.m_jdpProgress.setVisible(false);
                    JDialogUpgradeApplianceFirmware.this.enableDialog(false);
                    Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableUpgradeFileName.1", "avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableUpgradeControl.1"};
                    Object[] objectArray2 = new Object[]{JDialogUpgradeApplianceFirmware.this.m_szFileName, new Integer(3)};
                    try {
                        AvrSnmpHelper.set(JDialogUpgradeApplianceFirmware.this.m_acController.getAsmpConnection(), objectArray, objectArray2);
                        if (JDialogUpgradeApplianceFirmware.this.m_tumUpgradeMonitor != null && JDialogUpgradeApplianceFirmware.this.m_tumUpgradeMonitor.isAlive()) {
                            JDialogUpgradeApplianceFirmware.this.m_tumUpgradeMonitor.m_bStopThread = true;
                        }
                        JDialogUpgradeApplianceFirmware.this.m_tumUpgradeMonitor = new ThreadUpgradeMonitor();
                        JDialogUpgradeApplianceFirmware.this.m_tumUpgradeMonitor.start();
                    }
                    catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                        if (JDialogUpgradeApplianceFirmware.this.isShowing()) {
                            String string = res.getString("JDialogUpgradeApplianceFirmware_Unable_to_Upgrade_Appliance");
                            string = MessageFormat.format(string, APPLIANCE);
                            Message.show((Component)((Object)JDialogUpgradeApplianceFirmware.this), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
                            JDialogUpgradeApplianceFirmware.this.enableDialog(true);
                        }
                        return;
                    }
                    catch (Exception exception) {
                        if (JDialogUpgradeApplianceFirmware.this.isShowing()) {
                            String string = res.getString("JDialogUpgradeApplianceFirmware_Exception_while_JDUAF");
                            JDialogUpgradeApplianceFirmware.this.m_acController.showException(null, JDialogUpgradeApplianceFirmware.this.getTraceContext(), string, exception);
                            JDialogUpgradeApplianceFirmware.this.enableDialog(true);
                        }
                        return;
                    }
                }

                static /* synthetic */ JDialogUpgradeApplianceFirmware access$200(10 var0) {
                    return var0.JDialogUpgradeApplianceFirmware.this;
                }
            };
            thread.start();
        }
        catch (ExceptionConstructorFailed exceptionConstructorFailed) {
            Message.show((Component)((Object)this), (String)exceptionConstructorFailed.getMessage());
            this.m_jtfAsmpFirmwareFilename.requestFocus();
            this.enableDialog(true);
            return;
        }
    }

    void m_jbHelpButton_actionPerformed(ActionEvent actionEvent) {
        ResourceBundle resourceBundle = null;
        try {
            Trace.logInfo((String)"Help", (String)"Loading Help.properties resource bundle");
            resourceBundle = ResourceBundle.getBundle("com.avocent.avworks.nmm.avr.Help");
            Trace.logInfo((String)"Help", (String)"Successfully loaded Help.properties");
        }
        catch (Exception exception) {
            Trace.logError((String)"Help", (String)"FAILED TO LOAD com.avocent.avworks.nmm.avr.Help");
        }
        BrowserHelper.showHelpPage((JFrame)((JFrame)this.getOwner()), (String)resourceBundle.getString("IDH_UPGRADE_APPLIANCE_FIRMWARE"));
    }

    void checkCloseWindow() {
        boolean bl = true;
        if (this.m_bRebootInProgress) {
            int n = JOptionPaneFixedSize.showConfirmDialog((Component)((Object)this), (Object)res.getString("JDialogUpgradeApplianceFirmware_Confirm_Cancel_Reboot_Monitor"), (String)res.getString("JDialogUpgradeApplianceFirmware_Confirm_Cancel"), (int)0, (int)2);
            boolean bl2 = bl = n == 0;
        }
        if (bl) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Upgrade Appliance Firmware dialog is closing.");
            this.closeDialog();
            if (this.m_acAnonAsmpConnection != null) {
                try {
                    this.m_acAnonAsmpConnection.closeAsmpSession();
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)CNAME, (String)"Unable to close ASMP session", (Throwable)exceptionRequestFailed);
                }
            }
            if (this.m_bRebootInProgress) {
                this.m_acController.closeAmp();
            }
        }
    }

    public void closeDialog() {
        this.dispose();
        if (this.m_trmRebootMonitor != null) {
            this.m_trmRebootMonitor.m_bStopThread = true;
        }
        if (this.m_tumUpgradeMonitor != null) {
            this.m_tumUpgradeMonitor.m_bStopThread = true;
        }
    }

    void m_jbCloseButton_actionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"Cancel button pressed.");
        this.checkCloseWindow();
    }

    public boolean doEscape() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("<ESC> key pressed. \"" + this.getTitle() + "\" dialog is closing..."));
        this.checkCloseWindow();
        return true;
    }

    protected int getUpgradeStatus() throws Exception {
        if (this.SIMULATE_UPGRADE) {
            ++this.m_nUpgradeMessageCount;
            if (this.m_nUpgradeMessageCount < 2) {
                return 1;
            }
            if (this.m_nUpgradeMessageCount < 4) {
                return 2;
            }
            if (this.m_nUpgradeMessageCount < 5) {
                return 3;
            }
            this.m_nUpgradeMessageCount = 0;
            return 4;
        }
        Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableUpgradeStatus.1"};
        InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), objectArray);
        int n = interfaceValueObjectArray[0].getInteger();
        Trace.logInfo((String)TRACE_CONTEXT, (String)(" Appliance Update Status: " + n));
        return n;
    }

    protected int getRebootStatus() throws Exception {
        if (this.SIMULATE_UPGRADE) {
            ++this.m_nRebootMessageCount;
            if (this.m_nRebootMessageCount < 2) {
                return 2;
            }
            if (this.m_nRebootMessageCount < 4) {
                return 3;
            }
            if (this.m_nRebootMessageCount < 5) {
                return 6;
            }
            this.m_nRebootMessageCount = 0;
            return 1;
        }
        if (this.m_acController.getAppliance().hasMinMibVersion(2, 0)) {
            try {
                int n = AvrAsmpHelper.getApplianceStatus(this.getAnonymousAsmpConnection());
                Trace.logInfo((String)TRACE_CONTEXT, (String)(" Appliance Reboot Status: " + n));
                return n;
            }
            catch (Exception exception) {
                this.m_acAnonAsmpConnection = null;
                String string = res.getString("JDialogUpgradeApplianceFirmware_ASMP_Request_timed_out_");
                string = MessageFormat.format(string, APPLIANCE);
                throw new ExceptionRequestFailed(string);
            }
        }
        int n = AvrAidpHelper.getApplianceStatus(this.getAidpSession());
        Trace.logInfo((String)TRACE_CONTEXT, (String)(" Appliance Reboot Status: " + n));
        return n;
    }

    private synchronized AidpSession getAidpSession() {
        if (this.m_asAidpSession == null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Openning AIDP connection.");
            this.m_asAidpSession = new AidpSession(this.m_acController.getIpAddress());
        }
        return this.m_asAidpSession;
    }

    private synchronized AsmpConnection getAnonymousAsmpConnection() throws ExceptionRequestFailed {
        if (this.m_acAnonAsmpConnection == null) {
            AsmpConnection asmpConnection = new AsmpConnection();
            try {
                asmpConnection.openAnonymousConnection(this.m_acController.getIpAddress());
                this.m_acAnonAsmpConnection = asmpConnection;
            }
            catch (IOException iOException) {
                Trace.logError((String)CNAME, (String)"getAnonymousAsmpConnection", (Throwable)iOException);
                this.m_acAnonAsmpConnection = null;
                throw new ExceptionRequestFailed((Throwable)iOException);
            }
        }
        return this.m_acAnonAsmpConnection;
    }

    protected String getUpgradeReason() throws Exception {
        int n = this.m_acController.getAppliance().getMibMajorVersion();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n < 2) {
            arrayList.add("avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableUpgradeFailReason.1");
        } else {
            arrayList.add("avocent.ds.dsManagement.dsServer.dsImageFileTable.dsImageFileTableEntry.dsImageFileTableUpgradeFailCode.1");
        }
        InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), arrayList.toArray());
        String string = interfaceValueObjectArray[0].getString();
        Trace.logInfo((String)TRACE_CONTEXT, (String)(" Upgrade reason string:" + string));
        return string;
    }

    void rebootAppliance() throws Exception {
        this.m_bRebootInProgress = true;
        if (!this.SIMULATE_UPGRADE) {
            Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsReboot.0"};
            Object[] objectArray2 = new Object[]{new Integer(2)};
            AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), objectArray, objectArray2);
        }
        this.m_acController.closeAsmpSession();
        this.m_trmRebootMonitor = new ThreadRebootMonitor();
        this.m_trmRebootMonitor.start();
    }

    void enableDialog(boolean bl) {
        this.m_jbUpgradeButton.setEnabled(bl);
        if (this.m_jRadioAsmp.getModel().isSelected()) {
            this.m_jtfAsmpFirmwareFilename.setEnabled(bl);
            this.m_jbfAsmpFileBrowse.setEnabled(bl && this.m_jfcFileChooser != null);
        } else {
            this.m_jtfFilrmwareFilename.setEnabled(bl);
            this.m_jtfServerIP.setEnabled(bl);
        }
        if (this.m_acController.getAppliance().hasMinMibVersion(2, 0)) {
            this.m_jRadioTftp.getModel().setEnabled(bl);
            this.m_jRadioAsmp.getModel().setEnabled(bl);
        } else {
            this.m_jRadioTftp.getModel().setEnabled(true);
            this.m_jRadioAsmp.getModel().setEnabled(false);
        }
        if (bl) {
            this.m_jbUpgradeButton.requestFocus();
        }
        if (bl) {
            this.getRootPane().setDefaultButton(this.m_jbUpgradeButton);
        } else {
            this.getRootPane().setDefaultButton(this.m_jbCloseButton);
            this.m_jbCloseButton.requestFocus();
        }
    }

    boolean openAsmpSession() {
        try {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Attempting to open the ASMP connection.");
            return this.m_acController.getAsmpConnection().openConnection(this.m_acController.getIpAddress(), (Component)((Object)this), null, true) == 1;
        }
        catch (Throwable throwable) {
            Trace.logError((String)TRACE_CONTEXT, (String)" ASMP session was not created.", (Throwable)throwable);
            return false;
        }
    }

    public void setErrorFieldFocus(int n) {
        switch (n) {
            case 0: {
                this.m_jtfServerIP.requestFocus();
                break;
            }
            case 1: {
                this.m_jtfFilrmwareFilename.requestFocus();
            }
        }
    }

    public String getTraceContext() {
        return "AVR AMP Upgrade Firmware";
    }

    void m_jbfAsmpFileBrowse_actionPerformed(ActionEvent actionEvent) {
        Dimension dimension = this.m_jfcFileChooser.getLayout().preferredLayoutSize(this.m_jfcFileChooser);
        this.m_jfcFileChooser.setPreferredSize(dimension);
        int n = this.m_jfcFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            File file = this.m_jfcFileChooser.getSelectedFile();
            this.m_jtfAsmpFirmwareFilename.setText(file.getPath());
            this.m_fBaseDirectory = file.getParentFile();
            this.m_jbfAsmpFileBrowse.setEnabled(true);
        }
        this.m_jtfAsmpFirmwareFilename.requestFocus();
    }

    private void setDefaultDirectory() {
        String string;
        block2: {
            string = null;
            try {
                string = AVWorksService.getDBasePath();
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                string = System.getProperty("user.home");
                if (string != null) break block2;
                string = ".";
            }
        }
        this.m_fBaseDirectory = new File(string);
    }

    void createFileChooser() {
        Thread thread = new Thread("Create File Chooser Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 16 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            16.access$500(this.this$1).m_jbfAsmpFileBrowse.setEnabled(false);
                            16.access$500(this.this$1).setCursor(Cursor.getPredefinedCursor(3));
                        }
                    });
                    JDialogUpgradeApplianceFirmware.this.m_jfcFileChooser = new JFileChooser(JDialogUpgradeApplianceFirmware.this.m_fBaseDirectory);
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 16 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            16.access$500(this.this$1).m_jbfAsmpFileBrowse.setEnabled(true);
                            16.access$500(this.this$1).setCursor(Cursor.getPredefinedCursor(0));
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }

            static /* synthetic */ JDialogUpgradeApplianceFirmware access$500(16 var0) {
                return var0.JDialogUpgradeApplianceFirmware.this;
            }
        };
        thread.start();
    }

    class ThreadRebootMonitor
    extends Thread {
        int m_nLastStatus;
        int m_nStatus;
        boolean m_bStopThread;
        boolean m_bOpenAsmpSession;

        ThreadRebootMonitor() {
            super("Reboot Monitor");
            this.m_nLastStatus = -1;
            this.m_bStopThread = false;
            this.m_bOpenAsmpSession = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                boolean bl = false;
                RebootStatusMonitorRunnable rebootStatusMonitorRunnable = new RebootStatusMonitorRunnable();
                while (!this.m_bStopThread) {
                    try {
                        this.m_nStatus = JDialogUpgradeApplianceFirmware.this.getRebootStatus();
                        if (!(bl || this.m_nStatus != 2 && this.m_nStatus != 3)) {
                            bl = true;
                            Trace.logInfo((String)JDialogUpgradeApplianceFirmware.TRACE_CONTEXT, (String)" Detected start of reboot with first startup related appliance status.");
                        }
                        if (!bl) {
                            this.m_nStatus = -5;
                            Trace.logInfo((String)JDialogUpgradeApplianceFirmware.TRACE_CONTEXT, (String)" Status switched to WAITING.");
                        }
                    }
                    catch (ExceptionRequestFailed exceptionRequestFailed) {
                        Trace.logError((String)JDialogUpgradeApplianceFirmware.TRACE_CONTEXT, (String)("Exception: " + exceptionRequestFailed.getMessage()), (Throwable)exceptionRequestFailed);
                        bl = true;
                        Trace.logInfo((String)JDialogUpgradeApplianceFirmware.TRACE_CONTEXT, (String)" Detected start of reboot with first apparent UDP timeout.");
                    }
                    Object object = rebootStatusMonitorRunnable;
                    synchronized (object) {
                        SwingUtilities.invokeLater(rebootStatusMonitorRunnable);
                        rebootStatusMonitorRunnable.wait();
                    }
                    if (this.m_bOpenAsmpSession) {
                        if (!JDialogUpgradeApplianceFirmware.this.openAsmpSession()) {
                            Trace.logError((String)JDialogUpgradeApplianceFirmware.TRACE_CONTEXT, (String)" ASMP session was not created after firmware upgrade, the AMP will close.");
                            this.m_bStopThread = true;
                            if (JDialogUpgradeApplianceFirmware.this.isShowing()) {
                                object = res.getString("JDialogUpgradeApplianceFirmware_Request_Failed_ASMP_communications");
                                Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true)};
                                object = MessageFormat.format((String)object, objectArray);
                                Message.show((Component)((Object)JDialogUpgradeApplianceFirmware.this), (String)object);
                            }
                            JDialogUpgradeApplianceFirmware.this.closeDialog();
                            JDialogUpgradeApplianceFirmware.this.m_acController.closeAmp();
                        } else {
                            JDialogUpgradeApplianceFirmware.this.m_acController.resetAmp();
                            JDialogUpgradeApplianceFirmware.this.mibSpecificSetup();
                            Trace.logInfo((String)JDialogUpgradeApplianceFirmware.TRACE_CONTEXT, (String)"ASMP connection was successful, marking all panels as uninitialized and unmodified");
                            JDialogUpgradeApplianceFirmware.this.enableDialog(true);
                        }
                    }
                    if (!this.m_bStopThread) {
                        Thread.sleep(1000L);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                if (JDialogUpgradeApplianceFirmware.this.isShowing()) {
                    JDialogUpgradeApplianceFirmware.this.m_acController.showException(null, JDialogUpgradeApplianceFirmware.this.getTraceContext(), res.getString("JDialogUpgradeApplianceFirmware_reboot_error"), exception);
                }
                this.m_bStopThread = true;
                JDialogUpgradeApplianceFirmware.this.closeDialog();
                JDialogUpgradeApplianceFirmware.this.m_acController.closeAmp();
            }
        }

        class RebootStatusMonitorRunnable
        implements Runnable {
            boolean bFirmwareRejected = false;

            RebootStatusMonitorRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block18: {
                    try {
                        if (ThreadRebootMonitor.this.m_nStatus != ThreadRebootMonitor.this.m_nLastStatus) {
                            ThreadRebootMonitor.this.m_nLastStatus = ThreadRebootMonitor.this.m_nStatus;
                            switch (ThreadRebootMonitor.this.m_nStatus) {
                                case -5: {
                                    Trace.logInfo((String)JDialogUpgradeApplianceFirmware.TRACE_CONTEXT, (String)" Waiting for reboot to start.");
                                    ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, JDialogUpgradeApplianceFirmware.WAITING_MESSAGE);
                                    break;
                                }
                                case 1: {
                                    Trace.logInfo((String)JDialogUpgradeApplianceFirmware.TRACE_CONTEXT, (String)"ASMP connection was successful, marking all panels as uninitialized and unmodified");
                                    Vector vector = ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_acController.getPanelList();
                                    boolean bl = false;
                                    for (int i = 0; i < vector.size(); ++i) {
                                        PanelTreePathPair panelTreePathPair = (PanelTreePathPair)vector.elementAt(i);
                                        InterfaceAmpPanel interfaceAmpPanel = panelTreePathPair.getPanel();
                                        Trace.logInfo((String)JDialogUpgradeApplianceFirmware.TRACE_CONTEXT, (String)("Setting panel to uninitialized and unmodified = " + interfaceAmpPanel.getPanelTitle()));
                                        interfaceAmpPanel.setIsModified(false);
                                        interfaceAmpPanel.setPanelState(101);
                                    }
                                    ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_acController.clearMibMajorVersion();
                                    ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_acController.clearMibMinorVersion();
                                    if (this.bFirmwareRejected) {
                                        ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, JDialogUpgradeApplianceFirmware.PREVIOUS_FW_LOADED);
                                        this.bFirmwareRejected = false;
                                    } else {
                                        ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, JDialogUpgradeApplianceFirmware.REBOOT_READY);
                                    }
                                    ThreadRebootMonitor.this.m_bStopThread = true;
                                    ThreadRebootMonitor.this.m_bOpenAsmpSession = true;
                                    ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_bRebootInProgress = false;
                                    break;
                                }
                                case 2: {
                                    ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, JDialogUpgradeApplianceFirmware.REBOOT_IN_PROGRESS);
                                    break;
                                }
                                case 3: {
                                    ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, JDialogUpgradeApplianceFirmware.REBOOT_SUBSYSTEM);
                                    break;
                                }
                                case 4: {
                                    ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, JDialogUpgradeApplianceFirmware.REBOOT_KEYBOARD_FAILED);
                                    ThreadRebootMonitor.this.m_bStopThread = true;
                                    ThreadRebootMonitor.this.m_bOpenAsmpSession = true;
                                    ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_bRebootInProgress = false;
                                    ThreadRebootMonitor.this.m_bOpenAsmpSession = true;
                                    break;
                                }
                                case 5: {
                                    ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, JDialogUpgradeApplianceFirmware.REBOOT_VIDEO_FAILED);
                                    ThreadRebootMonitor.this.m_bStopThread = true;
                                    ThreadRebootMonitor.this.m_bOpenAsmpSession = true;
                                    ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_bRebootInProgress = false;
                                    ThreadRebootMonitor.this.m_bOpenAsmpSession = true;
                                    break;
                                }
                                case 6: {
                                    Trace.logInfo((String)JDialogUpgradeApplianceFirmware.TRACE_CONTEXT, (String)"Firmware rejected during reboot.");
                                    ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, JDialogUpgradeApplianceFirmware.WAITING_MESSAGE);
                                    String string = MessageFormat.format(res.getString("JDialogUpgradeApplianceFirmware_New_Firmware_rejected"), APPLIANCE);
                                    Message.show((Component)((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_acController.getMainFrame(), (String)string);
                                    ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_bRebootInProgress = true;
                                    this.bFirmwareRejected = true;
                                    break;
                                }
                                default: {
                                    Trace.logError((String)JDialogUpgradeApplianceFirmware.this.getTraceContext(), (String)"Unexpected status message.");
                                    ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, JDialogUpgradeApplianceFirmware.UNEXPECTED_STATUS);
                                    ThreadRebootMonitor.this.m_bStopThread = true;
                                    ThreadRebootMonitor.this.m_bOpenAsmpSession = true;
                                    ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_bRebootInProgress = false;
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        ThreadRebootMonitor.this.m_bStopThread = true;
                        ThreadRebootMonitor.this.m_bOpenAsmpSession = true;
                        ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_bRebootInProgress = false;
                        if (!JDialogUpgradeApplianceFirmware.this.isShowing()) break block18;
                        String string = res.getString("JDialogUpgradeApplianceFirmware_reboot_error");
                        ((ThreadRebootMonitor)ThreadRebootMonitor.this).JDialogUpgradeApplianceFirmware.this.m_acController.showException(null, JDialogUpgradeApplianceFirmware.this.getTraceContext(), string, exception);
                    }
                }
                RebootStatusMonitorRunnable rebootStatusMonitorRunnable = this;
                synchronized (rebootStatusMonitorRunnable) {
                    this.notify();
                }
            }
        }
    }

    class ThreadUpgradeMonitor
    extends Thread {
        int m_nLastStatus;
        int m_nStatus;
        String m_szReason;
        boolean m_bStopThread;
        boolean m_bRebootAppliance;

        ThreadUpgradeMonitor() {
            super("Firmware Upgrade Monitor");
            this.m_nLastStatus = -1;
            this.m_szReason = null;
            this.m_bStopThread = false;
            this.m_bRebootAppliance = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            try {
                while (!this.m_bStopThread) {
                    this.m_nStatus = JDialogUpgradeApplianceFirmware.this.getUpgradeStatus();
                    if (this.m_nStatus == 4) {
                        this.m_szReason = JDialogUpgradeApplianceFirmware.this.getUpgradeReason();
                        if (this.m_szReason == null) {
                            this.m_szReason = res.getString("JDialogUpgradeApplianceFirmware_firmware_upgrade_failed");
                        }
                    }
                    UpgradeStatusMonitorRunnable upgradeStatusMonitorRunnable = new UpgradeStatusMonitorRunnable();
                    object = upgradeStatusMonitorRunnable;
                    synchronized (object) {
                        SwingUtilities.invokeLater(upgradeStatusMonitorRunnable);
                        upgradeStatusMonitorRunnable.wait();
                    }
                    if (!this.m_bStopThread) {
                        Thread.sleep(1000L);
                        continue;
                    }
                    break;
                }
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                if (JDialogUpgradeApplianceFirmware.this.isShowing()) {
                    object = res.getString("JDialogUpgradeApplianceFirmware_Unable_to_Upgrade_Appliance");
                    object = MessageFormat.format((String)object, APPLIANCE);
                    Message.show((Component)((Object)JDialogUpgradeApplianceFirmware.this), (String)((String)object + " " + exceptionAsmpRequestFailed.getMessage()));
                }
                JDialogUpgradeApplianceFirmware.this.closeDialog();
            }
            catch (Exception exception) {
                if (JDialogUpgradeApplianceFirmware.this.isShowing()) {
                    JDialogUpgradeApplianceFirmware.this.m_acController.showException(null, JDialogUpgradeApplianceFirmware.this.getTraceContext(), res.getString("JDialogUpgradeApplianceFirmware_Error_while_polling"), exception);
                }
                JDialogUpgradeApplianceFirmware.this.closeDialog();
            }
            if (this.m_bRebootAppliance) {
                try {
                    JDialogUpgradeApplianceFirmware.this.rebootAppliance();
                }
                catch (Exception exception) {
                    if (JDialogUpgradeApplianceFirmware.this.isShowing()) {
                        object = res.getString("JDialogUpgradeApplianceFirmware_Unable_to_Reboot");
                        object = MessageFormat.format((String)object, APPLIANCE);
                        Message.show((Component)JDialogUpgradeApplianceFirmware.this.m_acController.getMainFrame(), (String)((String)object + " " + exception.getMessage()));
                    }
                    JDialogUpgradeApplianceFirmware.this.closeDialog();
                    JDialogUpgradeApplianceFirmware.this.m_acController.closeAmp();
                }
            }
        }

        class UpgradeStatusMonitorRunnable
        implements Runnable {
            UpgradeStatusMonitorRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                block17: {
                    try {
                        if (ThreadUpgradeMonitor.this.m_nStatus != ThreadUpgradeMonitor.this.m_nLastStatus) {
                            ThreadUpgradeMonitor.this.m_nLastStatus = ThreadUpgradeMonitor.this.m_nStatus;
                            switch (ThreadUpgradeMonitor.this.m_nStatus) {
                                case 1: {
                                    ((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, JDialogUpgradeApplianceFirmware.UPGRADE_READY);
                                    break;
                                }
                                case 2: {
                                    if (((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jRadioAsmp.getModel().isSelected()) {
                                        ((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, "upgrade_in_progress");
                                        break;
                                    }
                                    ((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, "upgrade_in_progress");
                                    break;
                                }
                                case 3: {
                                    ThreadUpgradeMonitor.this.m_bStopThread = true;
                                    ((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, JDialogUpgradeApplianceFirmware.UPGRADE_SUCCEEDED);
                                    object = res.getString("JDialogUpgradeApplianceFirmware_Firmware_file_has");
                                    object = MessageFormat.format((String)object, APPLIANCE);
                                    String string = res.getString("JDialogUpgradeApplianceFirmware_Confirm_Reboot");
                                    string = MessageFormat.format(string, APPLIANCE);
                                    int n = JOptionPaneFixedSize.showConfirmDialog((Component)((Object)JDialogUpgradeApplianceFirmware.this), (Object)object, (String)string, (int)0);
                                    if (n == 0) {
                                        ThreadUpgradeMonitor.this.m_bRebootAppliance = true;
                                        break;
                                    }
                                    JDialogUpgradeApplianceFirmware.this.enableDialog(true);
                                    break;
                                }
                                case 4: {
                                    ThreadUpgradeMonitor.this.m_bStopThread = true;
                                    ThreadUpgradeMonitor.this.m_szReason = ThreadUpgradeMonitor.this.m_szReason.trim();
                                    int n = ThreadUpgradeMonitor.this.m_szReason.length();
                                    if (ThreadUpgradeMonitor.this.m_szReason != null && n != 0) {
                                        if (ThreadUpgradeMonitor.this.m_szReason.charAt(n - 1) != '.') {
                                            ThreadUpgradeMonitor.this.m_szReason = ThreadUpgradeMonitor.this.m_szReason + ".";
                                        }
                                        ThreadUpgradeMonitor.this.m_szReason = res.getString("JDialogUpgradeApplianceFirmware_Reason") + " " + ThreadUpgradeMonitor.this.m_szReason;
                                        ((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.jLabelUpgradeFailedReason.setText(ThreadUpgradeMonitor.this.m_szReason);
                                    } else {
                                        ((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.jLabelUpgradeFailedReason.setText(" ");
                                    }
                                    ((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, JDialogUpgradeApplianceFirmware.UPGRADE_FAILED);
                                    JDialogUpgradeApplianceFirmware.this.enableDialog(true);
                                    break;
                                }
                                default: {
                                    ThreadUpgradeMonitor.this.m_bStopThread = true;
                                    object = res.getString("JDialogUpgradeApplianceFirmware_Error_unexpected");
                                    Trace.logError((String)JDialogUpgradeApplianceFirmware.TRACE_CONTEXT, (String)((String)object + " (status=" + ThreadUpgradeMonitor.this.m_nStatus + ")."));
                                    ((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.m_clMessagePanelLayoutManager.show(((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.m_jpMessagePanel, JDialogUpgradeApplianceFirmware.UNEXPECTED_STATUS);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        ThreadUpgradeMonitor.this.m_bStopThread = true;
                        JDialogUpgradeApplianceFirmware.this.enableDialog(true);
                        if (!JDialogUpgradeApplianceFirmware.this.isShowing()) break block17;
                        String string = res.getString("JDialogUpgradeApplianceFirmware_Error_while_polling");
                        ((ThreadUpgradeMonitor)ThreadUpgradeMonitor.this).JDialogUpgradeApplianceFirmware.this.m_acController.showException(null, JDialogUpgradeApplianceFirmware.this.getTraceContext(), string, exception);
                    }
                }
                object = this;
                synchronized (object) {
                    this.notify();
                }
            }
        }
    }
}

