/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrAidpHelper;
import com.avocent.avworks.nmm.avr.AvrAppliance;
import com.avocent.avworks.nmm.avr.AvrRipInfo;
import com.avocent.avworks.nmm.avr.AvrServerInfo;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.common.AsmpConnection;
import com.avocent.avworks.nmm.common.DiscoverInfo;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.ProductInfo;
import com.avocent.avworks.services.Products;
import com.avocent.avworks.services.ProductsDb;
import com.avocent.avworks.services.Unit;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.JWrappingLabel;
import com.avocent.lib.gui.wizards.InterfaceWizardPanel;
import com.avocent.lib.gui.wizards.JDialogWizard;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.net.MacAddress;
import com.avocent.lib.util.ResourceManager;
import com.avocent.protocols.aidp.AidpDiscoverInfo;
import com.avocent.protocols.aidp.AidpSession;
import com.avocent.protocols.snmp.VarBind;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.InetAddress;
import java.text.MessageFormat;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class JPanelAddWizardConfiguringNew
extends JPanel
implements InterfaceWizardPanel {
    public static final String TRACE_CTXT = "Add Appliance Wizard";
    public static final String CNAME = "JPanelAddWizardConfiguringNew";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    private JDialogWizard m_dialogWizard = null;
    private int m_nID = -1;
    private String m_szTitle = "";
    AsmpConnection m_anonymousAsmpConnection;
    private Object[] m_aoProductType = new Object[]{"<PRODUCT TYPE>"};
    JWrappingLabel jWrappingLabel1 = new JWrappingLabel();
    JWrappingLabel jWrappingLabel2 = new JWrappingLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JProgressBar jProgressBar1 = new JProgressBar();
    protected final ConnectionCompletion m_ConnectionCompletion = new ConnectionCompletion();

    public JPanelAddWizardConfiguringNew(JDialogWizard jDialogWizard, int n, String string) throws ExceptionConstructorFailed {
        this.m_dialogWizard = jDialogWizard;
        this.m_nID = n;
        this.m_szTitle = string;
        this.m_aoProductType = (Object[])this.m_dialogWizard.getValue((Object)"ProductType");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)"DsAddWizard", (String)"Unable to initialize panel");
            throw new ExceptionConstructorFailed();
        }
        this.onInit();
    }

    void jbInit() throws Exception {
        String string = AVWorksBranding.getApplianceName((boolean)true);
        Object[] objectArray = new Object[]{string};
        this.jWrappingLabel1.setText(MessageFormat.format(res.getString("JPanelAddWizardConfiguringNew_Updating_IP"), objectArray));
        this.setLayout(this.gridBagLayout1);
        this.jWrappingLabel2.setText(res.getString("JPanelAddWizardConfiguringNew_Please_wait_"));
        this.add((Component)this.jWrappingLabel1, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jWrappingLabel2, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 18, 2, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.jProgressBar1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.5, 11, 0, new Insets(12, 0, 0, 0), 150, 0));
    }

    public String getTitle() {
        return this.m_szTitle;
    }

    public int getID() {
        return this.m_nID;
    }

    public void onInit() {
    }

    public void onSetActive() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Trace.logInfo((String)"DsAddWizard", (String)"Locate Existing Page Set Active");
                JPanelAddWizardConfiguringNew.this.m_dialogWizard.setWizardButtons(8);
                JPanelAddWizardConfiguringNew.this.m_dialogWizard.setDefaultButton(8);
                try {
                    JPanelAddWizardConfiguringNew.this.jProgressBar1.setMinimum(0);
                    JPanelAddWizardConfiguringNew.this.jProgressBar1.setMaximum(100);
                    JPanelAddWizardConfiguringNew.this.jProgressBar1.setValue(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                IpAddress ipAddress = (IpAddress)JPanelAddWizardConfiguringNew.this.m_dialogWizard.getValue((Object)"IpAddress");
                IpAddress ipAddress2 = (IpAddress)JPanelAddWizardConfiguringNew.this.m_dialogWizard.getValue((Object)"Network");
                IpAddress ipAddress3 = (IpAddress)JPanelAddWizardConfiguringNew.this.m_dialogWizard.getValue((Object)"SubnetMask");
                IpAddress ipAddress4 = (IpAddress)JPanelAddWizardConfiguringNew.this.m_dialogWizard.getValue((Object)"Gateway");
                AidpDiscoverInfo aidpDiscoverInfo = (AidpDiscoverInfo)JPanelAddWizardConfiguringNew.this.m_dialogWizard.getValue((Object)"SelectedAppliance");
                MacAddress macAddress = aidpDiscoverInfo.getMacAddress();
                ProductInfo productInfo = (ProductInfo)JPanelAddWizardConfiguringNew.this.m_dialogWizard.getValue((Object)"ProductInfo");
                String string = AVWorksBranding.getApplianceName((boolean)true);
                Object[] objectArray = new Object[]{string};
                Thread thread = new Thread(new Runnable(this, macAddress, ipAddress, ipAddress3, ipAddress4, ipAddress2, productInfo, objectArray){
                    private final /* synthetic */ MacAddress val$macaddr;
                    private final /* synthetic */ IpAddress val$ipaAppliance;
                    private final /* synthetic */ IpAddress val$ipaMask;
                    private final /* synthetic */ IpAddress val$ipaGateway;
                    private final /* synthetic */ IpAddress val$ipaNetwork;
                    private final /* synthetic */ ProductInfo val$productInfo;
                    private final /* synthetic */ Object[] val$aoApplianceNameSingular;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$macaddr = macAddress;
                        this.val$ipaAppliance = ipAddress;
                        this.val$ipaMask = ipAddress2;
                        this.val$ipaGateway = ipAddress3;
                        this.val$ipaNetwork = ipAddress4;
                        this.val$productInfo = productInfo;
                        this.val$aoApplianceNameSingular = objectArray;
                    }

                    public void run() {
                        Trace.logInfo((String)"DsAddWizard", (String)"Configure New Appliance Thread created");
                        try {
                            AidpDiscoverInfo aidpDiscoverInfo = new AidpDiscoverInfo(0, this.val$macaddr, this.val$ipaAppliance, this.val$ipaMask, this.val$ipaGateway);
                            AidpSession aidpSession = new AidpSession(this.val$ipaNetwork.getLong(), this.val$ipaMask.getLong());
                            JPanelAddWizardConfiguringNew.access$200(1.access$100(this.this$1), 25);
                            Trace.logInfo((String)"DsAddWizard", (String)"Testing New Configuration");
                            int n = aidpSession.testIpConfiguration(aidpDiscoverInfo);
                            JPanelAddWizardConfiguringNew.access$200(1.access$100(this.this$1), 50);
                            if (n == 0) {
                                Trace.logInfo((String)"DsAddWizard", (String)"Test IP address successful, setting address...");
                                n = aidpSession.setIpConfiguration(aidpDiscoverInfo);
                                JPanelAddWizardConfiguringNew.access$200(1.access$100(this.this$1), 50);
                                if (n == 0) {
                                    boolean bl;
                                    Trace.logInfo((String)"DsAddWizard", (String)"Set IP address successful");
                                    if (Products.isNautilusFamily((int)this.val$productInfo.getID())) {
                                        1.access$100(this.this$1).waitForApplianceViaAsmp(this.val$ipaAppliance);
                                    } else {
                                        1.access$100(this.this$1).waitForAppliance(this.val$ipaAppliance);
                                    }
                                    JPanelAddWizardConfiguringNew.access$200(1.access$100(this.this$1), 85);
                                    Trace.logInfo((String)"DsAddWizard", (String)"Appliance Ready.  Get the appliance information.");
                                    boolean bl2 = bl = Products.isNautilusFamily((int)this.val$productInfo.getID()) ? 1.access$100(this.this$1).getApplianceInfoViaAsmp(this.val$ipaAppliance.getString()) : 1.access$100(this.this$1).getApplianceInfo(this.val$ipaAppliance.getString());
                                    if (bl) {
                                        JPanelAddWizardConfiguringNew.access$000(1.access$100(this.this$1)).showPage(7);
                                        return;
                                    }
                                    Trace.logError((String)"DsAddWizard", (String)"Unable to get appliance information");
                                    JPanelAddWizardConfiguringNew.access$000(1.access$100(this.this$1)).putValue((Object)"FinishHeader", (Object)MessageFormat.format(res.getString("JPanelAddWizardConfiguringNew_New_Wizard_Unsuccessful"), this.val$aoApplianceNameSingular));
                                    JPanelAddWizardConfiguringNew.access$000(1.access$100(this.this$1)).putValue((Object)"FinishExclamation", (Object)new Boolean(true));
                                    JPanelAddWizardConfiguringNew.access$000(1.access$100(this.this$1)).putValue((Object)"FinishStatus", (Object)MessageFormat.format(res.getString("JPanelAddWizardConfiguringNew_Unable_to_save_new_appliance"), this.val$aoApplianceNameSingular));
                                    JPanelAddWizardConfiguringNew.access$000(1.access$100(this.this$1)).putValue((Object)"FinishClose", (Object)res.getString("JPanelAddWizardConfiguringNew_Click_Finish_to_exit_"));
                                    JPanelAddWizardConfiguringNew.access$000(1.access$100(this.this$1)).putValue((Object)"FinishButtons", (Object)new Integer(4));
                                    JPanelAddWizardConfiguringNew.access$000(1.access$100(this.this$1)).showPage(13);
                                    return;
                                }
                                Trace.logError((String)"DsAddWizard", (String)("Set IP address failed. AIDP ErrorStatus=" + n));
                            } else {
                                Trace.logError((String)"DsAddWizard", (String)("Test IP address failed. AIDP ErrorStatus=" + n));
                            }
                            throw new ExceptionRequestFailed();
                        }
                        catch (Exception exception) {
                            Trace.logError((String)"DsAddWizard", (String)"Unable to set IP address. AIDP Exception", (Throwable)exception);
                            JPanelAddWizardConfiguringNew.access$000(1.access$100(this.this$1)).putValue((Object)"FinishHeader", (Object)MessageFormat.format(res.getString("JPanelAddWizardConfiguringNew_New_Wizard_Unsuccessful"), this.val$aoApplianceNameSingular));
                            JPanelAddWizardConfiguringNew.access$000(1.access$100(this.this$1)).putValue((Object)"FinishExclamation", (Object)new Boolean(true));
                            JPanelAddWizardConfiguringNew.access$000(1.access$100(this.this$1)).putValue((Object)"FinishStatus", (Object)MessageFormat.format(res.getString("JPanelAddWizardConfiguringNew_Unable_to_configure"), this.val$aoApplianceNameSingular));
                            JPanelAddWizardConfiguringNew.access$000(1.access$100(this.this$1)).putValue((Object)"FinishClose", (Object)res.getString("JPanelAddWizardConfiguringNew_Click_Finish_to_exit_"));
                            JPanelAddWizardConfiguringNew.access$000(1.access$100(this.this$1)).putValue((Object)"FinishButtons", (Object)new Integer(4));
                            JPanelAddWizardConfiguringNew.access$000(1.access$100(this.this$1)).showPage(13);
                            return;
                        }
                    }
                });
                Trace.logInfo((String)"DsAddWizard", (String)"Starting Search Existing Thread");
                thread.start();
            }

            static /* synthetic */ JPanelAddWizardConfiguringNew access$100(1 var0) {
                return var0.JPanelAddWizardConfiguringNew.this;
            }
        });
    }

    void waitForApplianceViaAsmp(IpAddress ipAddress) throws Exception {
        String string = null;
        if (this.m_dialogWizard.isCanceled()) {
            Trace.logInfo((String)TRACE_CTXT, (String)"User Cancel Wizard, prior to AnonASMP conn");
            return;
        }
        this.m_anonymousAsmpConnection = new AsmpConnection();
        InetAddress inetAddress = InetAddress.getByName(ipAddress.getString());
        this.m_ConnectionCompletion.reset();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                while (JPanelAddWizardConfiguringNew.this.jProgressBar1.getValue() + 3 <= 75 && !JPanelAddWizardConfiguringNew.this.m_ConnectionCompletion.waitUntilConnectionComplete(1000)) {
                    JPanelAddWizardConfiguringNew.this.setProgress(JPanelAddWizardConfiguringNew.this.jProgressBar1.getValue() + 3);
                }
                Trace.logInfo((String)JPanelAddWizardConfiguringNew.TRACE_CTXT, (String)"Progress Thread Completed.");
            }
        }, "ConfigNewWizardUpdateProgress");
        thread.start();
        this.m_anonymousAsmpConnection.openAnonymousConnection(inetAddress, 5, 2000);
        this.m_ConnectionCompletion.connectionComplete();
        this.setProgress(75);
        AvrAppliance avrAppliance = new AvrAppliance(this.m_anonymousAsmpConnection);
        this.m_dialogWizard.putValue((Object)"anonymous_asmp_session", (Object)this.m_anonymousAsmpConnection);
        this.m_dialogWizard.putValue((Object)"appliance", (Object)avrAppliance);
        if (this.m_dialogWizard.isCanceled()) {
            Trace.logInfo((String)TRACE_CTXT, (String)"User Cancel Wizard, prior to sysObjectId get");
            return;
        }
        Trace.logInfo((String)TRACE_CTXT, (String)"Polling for sysObjectId to see if the appliance is ready.");
        string = avrAppliance.getSysObjectId();
    }

    void waitForAppliance(IpAddress ipAddress) throws Exception {
        Trace.logInfo((String)"DsAddWizard", (String)"Creating AIDP session to specific appliance");
        InetAddress inetAddress = InetAddress.getByName(ipAddress.getString());
        AidpSession aidpSession = new AidpSession(inetAddress);
        Trace.logInfo((String)"DsAddWizard", (String)"Appliance AIDP session created");
        for (int i = 0; i < 30; ++i) {
            try {
                this.setProgress(50 + i);
                Trace.logInfo((String)"DsAddWizard", (String)"Sleep 1 seconds to wait for the appliance.");
                Thread.sleep(1000L);
                Trace.logInfo((String)"DsAddWizard", (String)"Polling dsServerStatus to see if the appliance is ready.");
                VarBind varBind = new VarBind("avocent.ds.dsManagement.dsServer.dsServerStatus.0");
                if (!aidpSession.snmpGet(varBind)) {
                    Trace.logInfo((String)"DsAddWizard", (String)"Unable to obtain dsServerStatus");
                    continue;
                }
                int n = varBind.getIntegerValue();
                Trace.logInfo((String)"DsAddWizard", (String)("dsServerStatus Value is " + n));
                if (i < 5) {
                    Trace.logInfo((String)"DsAddWizard", (String)"Try again. Always wait minimum of 6 seconds");
                    continue;
                }
                if (n == 1) {
                    Trace.logInfo((String)"DsAddWizard", (String)"Appliance is ready");
                    break;
                }
                Trace.logInfo((String)"DsAddWizard", (String)"Appliance is NOT ready yet. Sleep 2 seconds");
                continue;
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CTXT, (String)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void setProgress(int n) {
        final int n2 = n;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    JPanelAddWizardConfiguringNew.this.jProgressBar1.setValue(n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public int onNext() {
        Trace.logError((String)"DsAddWizard", (String)"onNext");
        return -1;
    }

    public int onBack() {
        Trace.logError((String)"DsAddWizard", (String)"onBack");
        return -1;
    }

    public boolean onFinish() {
        Trace.logError((String)"DsAddWizard", (String)"onFinish");
        return true;
    }

    public void onDestroy() {
        Trace.logInfo((String)"DsAddWizard", (String)"onDestroy");
    }

    public boolean getApplianceInfo(String string) {
        try {
            AvrRipInfo[] avrRipInfoArray;
            MacAddress macAddress;
            InetAddress inetAddress = InetAddress.getByName(string);
            Trace.logInfo((String)"DsAddWizard", (String)("Searching for existing DSR at" + inetAddress.getHostAddress()));
            AidpSession aidpSession = new AidpSession(inetAddress);
            AidpDiscoverInfo[] aidpDiscoverInfoArray = aidpSession.discover();
            if (aidpDiscoverInfoArray.length == 0) {
                Trace.logError((String)"DsAddWizard", (String)"No DSRs found");
                return false;
            }
            if (aidpDiscoverInfoArray.length != 1) {
                Trace.logError((String)"DsAddWizard", (String)("Too many DSRs found. NumFound=" + aidpDiscoverInfoArray.length));
                return false;
            }
            Trace.logInfo((String)"DsAddWizard", (String)("Found Appliance MAC=" + aidpDiscoverInfoArray[0].getMacAddress().getString()));
            Trace.logInfo((String)"DsAddWizard", (String)("AIDP Model=" + aidpDiscoverInfoArray[0].getModel()));
            int n = Products.getProductIDForModelType((int)aidpDiscoverInfoArray[0].getModel());
            Trace.logInfo((String)"DsAddWizard", (String)("Product ID =" + n));
            ProductInfo productInfo = ProductsDb.getProductInfo((int)n);
            Trace.logInfo((String)"DsAddWizard", (String)("Product Type =" + productInfo.getName()));
            if (productInfo.getNmmID() != 1) {
                Trace.logError((String)"DsAddWizard", (String)"Product ID not supported by AVR NMM.");
                return false;
            }
            if (!productInfo.isAddAllowed()) {
                Trace.logError((String)"DsAddWizard", (String)"Product Type does not support ADD.");
                return false;
            }
            if (!productInfo.isEnabled()) {
                Trace.logError((String)"DsAddWizard", (String)"Product Type is not enabled.");
                return false;
            }
            VarBind varBind = new VarBind("mib-2.system.sysName.0");
            if (!aidpSession.snmpGet(varBind)) {
                Trace.logError((String)"DsAddWizard", (String)"Unable to obtain appliance MIB-II system vars");
                return false;
            }
            String string2 = varBind.getStringValue();
            Trace.logInfo((String)"DsAddWizard", (String)("Appliance Name=" + string2));
            if (string2.length() == 0) {
                Trace.logInfo((String)"DsAddWizard", (String)"SysName was blank");
                macAddress = aidpDiscoverInfoArray[0].getMacAddress();
                avrRipInfoArray = macAddress.getString().substring(9);
                Trace.logInfo((String)"DsAddWizard", (String)("Type=" + productInfo.getName() + " MAC=" + (String)avrRipInfoArray));
                string2 = productInfo.getName() + " " + (String)avrRipInfoArray;
                Trace.logInfo((String)"DsAddWizard", (String)("Default SysName=" + string2));
            }
            string2 = Unit.getUniqueName((String)string2);
            Trace.logInfo((String)"DsAddWizard", (String)("Unique Appliance Name=" + string2));
            macAddress = new ApplianceInfo(0, string2, productInfo.getName(), n, "", string, "", "", productInfo.getNmmID(), true);
            this.m_dialogWizard.putValue((Object)"ApplianceInfo", (Object)macAddress);
            avrRipInfoArray = AvrAidpHelper.getRipInfo(string);
            this.m_dialogWizard.putValue((Object)"RipInfo", (Object)avrRipInfoArray);
            AvrServerInfo[] avrServerInfoArray = AvrAidpHelper.getServerInfo(string);
            this.m_dialogWizard.putValue((Object)"ServerInfo", (Object)avrServerInfoArray);
            return true;
        }
        catch (Exception exception) {
            Trace.logError((String)"DsAddWizard", (String)"Error obtaining information from applianace", (Throwable)exception);
            return false;
        }
    }

    public boolean getApplianceInfoViaAsmp(String string) {
        try {
            AvrRipInfo[] avrRipInfoArray;
            MacAddress macAddress;
            InetAddress inetAddress = InetAddress.getByName(string);
            AvrAppliance avrAppliance = (AvrAppliance)this.m_dialogWizard.getValue((Object)"appliance");
            Trace.logInfo((String)"DsAddWizard", (String)("Searching for existing AVR at" + string));
            DiscoverInfo discoverInfo = avrAppliance.discover();
            int n = discoverInfo.getProductID();
            Trace.logInfo((String)"DsAddWizard", (String)("Product ID =" + n));
            ProductInfo productInfo = ProductsDb.getProductInfo((int)n);
            Trace.logInfo((String)"DsAddWizard", (String)("Product Type =" + productInfo.getName()));
            if (productInfo.getNmmID() != 1) {
                Trace.logError((String)"DsAddWizard", (String)"Product ID not supported by AVR NMM.");
                return false;
            }
            if (!productInfo.isAddAllowed()) {
                Trace.logError((String)"DsAddWizard", (String)"Product Type does not support ADD.");
                return false;
            }
            if (!productInfo.isEnabled()) {
                Trace.logError((String)"DsAddWizard", (String)"Product Type is not enabled.");
                return false;
            }
            String string2 = avrAppliance.getSysName(true);
            Trace.logInfo((String)"DsAddWizard", (String)("Appliance Name=" + string2));
            if (string2.length() == 0) {
                Trace.logInfo((String)"DsAddWizard", (String)"SysName was blank");
                macAddress = discoverInfo.getMacAddress();
                avrRipInfoArray = macAddress.getString().substring(9);
                Trace.logInfo((String)"DsAddWizard", (String)("Type=" + productInfo.getName() + " MAC=" + (String)avrRipInfoArray));
                string2 = productInfo.getName() + " " + (String)avrRipInfoArray;
                Trace.logInfo((String)"DsAddWizard", (String)("Default SysName=" + string2));
            }
            string2 = Unit.getUniqueName((String)string2);
            Trace.logInfo((String)"DsAddWizard", (String)("Unique Appliance Name=" + string2));
            macAddress = new ApplianceInfo(0, string2, productInfo.getName(), n, "", string, "", "", productInfo.getNmmID(), true);
            this.m_dialogWizard.putValue((Object)"ApplianceInfo", (Object)macAddress);
            avrRipInfoArray = AvrSnmpHelper.getRipInfo(this.m_anonymousAsmpConnection);
            this.m_dialogWizard.putValue((Object)"RipInfo", (Object)avrRipInfoArray);
            AvrServerInfo[] avrServerInfoArray = AvrSnmpHelper.getServerInfo(this.m_anonymousAsmpConnection);
            this.m_dialogWizard.putValue((Object)"ServerInfo", (Object)avrServerInfoArray);
            return true;
        }
        catch (Exception exception) {
            Trace.logError((String)"DsAddWizard", (String)"Error obtaining information from applianace", (Throwable)exception);
            return false;
        }
    }

    class ConnectionCompletion {
        private boolean m_bConnectionComplete = false;

        public synchronized void reset() {
            Trace.logInfo((String)JPanelAddWizardConfiguringNew.TRACE_CTXT, (String)"Resetting Connection Complete");
            this.m_bConnectionComplete = false;
        }

        public synchronized boolean waitUntilConnectionComplete(int n) {
            Trace.logInfo((String)JPanelAddWizardConfiguringNew.TRACE_CTXT, (String)"Checking if Connection Completed.");
            if (this.m_bConnectionComplete) {
                Trace.logInfo((String)JPanelAddWizardConfiguringNew.TRACE_CTXT, (String)"Connection Complete, no wait.");
                return this.m_bConnectionComplete;
            }
            try {
                Trace.logInfo((String)JPanelAddWizardConfiguringNew.TRACE_CTXT, (String)"Waiting for connection to complete.");
                this.wait(n);
            }
            catch (InterruptedException interruptedException) {
                Trace.logInfo((String)JPanelAddWizardConfiguringNew.TRACE_CTXT, (String)"Wait on Connection Interrupted...");
            }
            return this.m_bConnectionComplete;
        }

        public synchronized void connectionComplete() {
            Trace.logInfo((String)JPanelAddWizardConfiguringNew.TRACE_CTXT, (String)"Marking Connection Complete");
            this.m_bConnectionComplete = true;
            this.notifyAll();
        }
    }
}

