/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.services.AppliancesDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.components.JTextFieldIPAddress;
import com.avocent.lib.gui.components.JWrappingLabel;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.wizards.InterfaceWizardPanel;
import com.avocent.lib.gui.wizards.JDialogWizard;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JPanelAddWizardEnterExistingConfig
extends JPanel
implements InterfaceWizardPanel {
    public static final String CNAME = "JPanelAddWizardEnterExistingConfig";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    JWrappingLabel jWrappingLabel1 = new JWrappingLabel();
    JWrappingLabel jWrappingLabel2 = new JWrappingLabel();
    JLabel jLabelIpAddress = new JLabel();
    JTextFieldIPAddress jTextFieldIpAddress = new JTextFieldIPAddress(1);
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JDialogWizard m_dialogWizard = null;
    private int m_nID = -1;
    private String m_szTitle = "";
    private Object[] m_aoProductType = new Object[]{"<PRODUCT TYPE>"};

    public JPanelAddWizardEnterExistingConfig(JDialogWizard jDialogWizard, int n, String string) throws ExceptionConstructorFailed {
        Trace.logInfo((String)"DsNewApplianceWizard", (String)"Creating EnterExistingConfig Panel");
        this.m_dialogWizard = jDialogWizard;
        this.m_nID = n;
        this.m_szTitle = string;
        this.m_aoProductType = (Object[])this.m_dialogWizard.getValue((Object)"ProductType");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)"DsNewApplianceWizard", (String)"Unable to initialize panel");
            throw new ExceptionConstructorFailed();
        }
        this.onInit();
    }

    void jbInit() throws Exception {
        this.jWrappingLabel1.setText(MessageFormat.format(res.getString("JPanelAddWizardEnterExistingConfig_Wizard_will_locate"), this.m_aoProductType));
        this.setLayout(this.gridBagLayout1);
        this.jWrappingLabel2.setText(MessageFormat.format(res.getString("JPanelAddWizardEnterExistingConfig_Enter_the_IP"), this.m_aoProductType));
        this.jLabelIpAddress.setText(res.getString("JPanelAddWizardEnterExistingConfig_IP_Address_"));
        this.add((Component)this.jWrappingLabel1, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jWrappingLabel2, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabelIpAddress, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(17, 17, 0, 0), 0, 0));
        this.add((Component)this.jTextFieldIpAddress, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.5, 18, 0, new Insets(17, 12, 0, 0), 120, 0));
    }

    public String getTitle() {
        return this.m_szTitle;
    }

    public int getID() {
        return this.m_nID;
    }

    public void onInit() {
        Trace.logInfo((String)"DsNewApplianceWizard", (String)"onInit EnterExistingConfig Panel");
    }

    public void onSetActive() {
        Trace.logInfo((String)"DsNewApplianceWizard", (String)"onSetActive EnterExistingConfig Panel");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanelAddWizardEnterExistingConfig.this.m_dialogWizard.setWizardButtons(11);
                JPanelAddWizardEnterExistingConfig.this.m_dialogWizard.setDefaultButton(2);
                JPanelAddWizardEnterExistingConfig.this.jTextFieldIpAddress.grabFocus();
            }
        });
    }

    public int onNext() {
        IpAddress ipAddress;
        Trace.logInfo((String)"DsNewApplianceWizard", (String)"onNext EnterExistingConfig Panel");
        try {
            ipAddress = this.jTextFieldIpAddress.getIpAddress();
            long l = ipAddress.getLong();
        }
        catch (Exception exception) {
            Trace.logError((String)"DsNewApplianceWizard", (String)"onNext Invalid Address", (Throwable)exception);
            return 8;
        }
        try {
            if (AppliancesDb.isAddressDefined((String)ipAddress.getString())) {
                Trace.logError((String)"DsNewApplianceWizard", (String)"onNext Invalid Address (DBase)");
                String string = res.getString("JPanelAddWizardEnterExistingConfig_Invalid_IP_ExistDb");
                Message.invokeLater((Component)this, (String)string, (Component)this.jTextFieldIpAddress);
                return 8;
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"DsNewApplianceWizard", (String)"Unable to determine if IP Address is a duplicate", (Throwable)exception);
            String string = res.getString("JPanelAddWizardEnterExistingConfig_Invalid_IP_ExistDb");
            Message.invokeLater((Component)this, (String)string, (Component)this.jTextFieldIpAddress);
            return 8;
        }
        this.m_dialogWizard.putValue((Object)"IpAddress", (Object)ipAddress);
        Trace.logInfo((String)"DsNewApplianceWizard", (String)"onNext Goto LocateExisting Panel");
        return 9;
    }

    public int onBack() {
        return this.m_dialogWizard.getPreviousPageID();
    }

    public boolean onFinish() {
        return true;
    }

    public void onDestroy() {
    }
}

