/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.services.AppliancesDb;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.JTextFieldIPAddress;
import com.avocent.lib.gui.components.JWrappingLabel;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.wizards.InterfaceWizardPanel;
import com.avocent.lib.gui.wizards.JDialogWizard;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class JPanelAddWizardEnterNewConfig
extends JPanel
implements InterfaceWizardPanel {
    public static final String CNAME = "JPanelAddWizardEnterNewConfig";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    private JDialogWizard m_dialogWizard = null;
    private int m_nID = -1;
    private String m_szTitle = "";
    private Object[] m_aoProductType = new Object[]{"<PRODUCT TYPE>"};
    JWrappingLabel jWrappingLabel1 = new JWrappingLabel();
    JWrappingLabel jWrappingLabel2 = new JWrappingLabel();
    JLabel jLabelIpAddress = new JLabel();
    JLabel jLabelSubnetMask = new JLabel();
    JLabel jLabelGateway = new JLabel();
    JTextFieldIPAddress jTextFieldIpAddress = new JTextFieldIPAddress(3);
    JTextFieldIPAddress jTextFieldSubnetMask = new JTextFieldIPAddress(7);
    JTextFieldIPAddress jTextFieldGateway = new JTextFieldIPAddress(18);
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    String m_szValidateErrorReason = "";

    public JPanelAddWizardEnterNewConfig(JDialogWizard jDialogWizard, int n, String string) throws ExceptionConstructorFailed {
        this.m_dialogWizard = jDialogWizard;
        this.m_nID = n;
        this.m_szTitle = string;
        this.m_aoProductType = (Object[])this.m_dialogWizard.getValue((Object)"ProductType");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)"Wizard", (String)"Unable to initialize panel");
            throw new ExceptionConstructorFailed();
        }
        this.onInit();
    }

    void jbInit() throws Exception {
        this.jWrappingLabel1.setText(MessageFormat.format(res.getString("JPanelAddWizardEnterNewConfig_This_wizard_will_locate_new"), this.m_aoProductType));
        this.setLayout(this.gridBagLayout1);
        this.jWrappingLabel2.setText(MessageFormat.format(res.getString("JPanelAddWizardEnterNewConfig_Then_enter_the_address"), this.m_aoProductType));
        this.jLabelIpAddress.setText(res.getString("JPanelAddWizardEnterNewConfig_IP_Address_"));
        this.jLabelSubnetMask.setText(res.getString("JPanelAddWizardEnterNewConfig_Subnet_Mask_"));
        this.jLabelGateway.setText(res.getString("JPanelAddWizardEnterNewConfig_Gateway_"));
        this.jTextFieldGateway.setPreferredSize(new Dimension(150, 21));
        this.jTextFieldGateway.setName(res.getString("JPanelAddWizardEnterNewConfig_Gateway"));
        this.jTextFieldSubnetMask.setPreferredSize(new Dimension(150, 21));
        this.jTextFieldSubnetMask.setName(res.getString("JPanelAddWizardEnterNewConfig_Subnet_Mask"));
        this.jTextFieldIpAddress.setPreferredSize(new Dimension(150, 21));
        this.jTextFieldIpAddress.setName(res.getString("JPanelAddWizardEnterNewConfig_IP_Address"));
        this.add((Component)this.jWrappingLabel1, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jWrappingLabel2, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabelIpAddress, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(17, 17, 0, 0), 0, 0));
        this.add((Component)this.jLabelSubnetMask, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 17, 0, 0), 0, 0));
        this.add((Component)this.jLabelGateway, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 17, 0, 0), 0, 0));
        this.add((Component)this.jTextFieldIpAddress, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 17, 0, new Insets(17, 12, 0, 0), 0, 0));
        this.add((Component)this.jTextFieldSubnetMask, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.add((Component)this.jTextFieldGateway, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.5, 18, 0, new Insets(12, 12, 11, 0), 0, 0));
    }

    public String getTitle() {
        return this.m_szTitle;
    }

    public int getID() {
        return this.m_nID;
    }

    public void onInit() {
        this.jTextFieldGateway.setText("0.0.0.0");
    }

    public void onSetActive() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanelAddWizardEnterNewConfig.this.m_dialogWizard.setWizardButtons(11);
                JPanelAddWizardEnterNewConfig.this.m_dialogWizard.setDefaultButton(2);
                JPanelAddWizardEnterNewConfig.this.jTextFieldIpAddress.grabFocus();
            }
        });
    }

    public int onNext() {
        try {
            Trace.logInfo((String)"DsNewApplianceWizard", (String)"Verifying IP Address Field");
            IpAddress ipAddress = this.jTextFieldIpAddress.getIpAddress();
            Trace.logInfo((String)"DsNewApplianceWizard", (String)("IP Address is " + ipAddress));
            Trace.logInfo((String)"DsNewApplianceWizard", (String)"Verifying Subnet Mask Address Field");
            IpAddress ipAddress2 = this.jTextFieldSubnetMask.getIpAddress();
            Trace.logInfo((String)"DsNewApplianceWizard", (String)("SubnetMaxk is " + ipAddress2));
            Trace.logInfo((String)"DsNewApplianceWizard", (String)"Verifying Gateway Address Field");
            IpAddress ipAddress3 = this.jTextFieldGateway.getIpAddress();
            Trace.logInfo((String)"DsNewApplianceWizard", (String)("Gateway is    " + ipAddress3));
            try {
                if (AppliancesDb.isAddressDefined((String)ipAddress.getString())) {
                    Object[] objectArray = new Object[]{res.getString("JPanelAddWizardEnterNewConfig_IP_Address")};
                    String string = MessageFormat.format(res.getString("JPanelAddWizardEnterNewConfig_The_0_field_is_not3"), objectArray);
                    Trace.logError((String)"DsNewApplianceWizard", (String)string);
                    Message.invokeLater((Component)this, (String)string, (Component)this.jTextFieldIpAddress);
                    return 3;
                }
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                // empty catch block
            }
            if (!this.isValidForSubnet(res.getString("JPanelAddWizardEnterNewConfig_IP_Address"), ipAddress, ipAddress2, (JTextField)this.jTextFieldIpAddress)) {
                return 3;
            }
            IpAddress ipAddress4 = ipAddress.getNetworkAddress(ipAddress2);
            Trace.logInfo((String)"DsNewApplianceWizard", (String)("Network is    " + ipAddress4));
            if (!ipAddress3.isZeroAddress()) {
                if (!this.isValidForSubnet(res.getString("JPanelAddWizardEnterNewConfig_Gateway"), ipAddress3, ipAddress2, (JTextField)this.jTextFieldGateway)) {
                    return 3;
                }
                if (ipAddress.equals((Object)ipAddress3)) {
                    String string = res.getString("JPanelAddWizardEnterNewConfig_IP_Same_Gateway");
                    Trace.logError((String)"DsNewApplianceWizard", (String)string);
                    Message.invokeLater((Component)this, (String)string, (Component)this.jTextFieldSubnetMask);
                    return 3;
                }
                if (!ipAddress4.equals((Object)ipAddress3.getNetworkAddress(ipAddress2))) {
                    String string = res.getString("JPanelAddWizardEnterNewConfig_IP_Gateway_Network");
                    Trace.logError((String)"DsNewApplianceWizard", (String)string);
                    Message.invokeLater((Component)this, (String)string, (Component)this.jTextFieldGateway);
                    return 3;
                }
            }
            this.m_dialogWizard.putValue((Object)"IpAddress", (Object)ipAddress);
            this.m_dialogWizard.putValue((Object)"SubnetMask", (Object)ipAddress2);
            this.m_dialogWizard.putValue((Object)"Gateway", (Object)ipAddress3);
            this.m_dialogWizard.putValue((Object)"Network", (Object)ipAddress4);
            return 4;
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Trace.logInfo((String)"DsNewApplianceWizard", (String)"Error Verifying");
            return 3;
        }
    }

    public int onBack() {
        return this.m_dialogWizard.getPreviousPageID();
    }

    public boolean onFinish() {
        return true;
    }

    public void onDestroy() {
    }

    public boolean isValidForSubnet(String string, IpAddress ipAddress, IpAddress ipAddress2, JTextField jTextField) {
        try {
            if (ipAddress.equals((Object)ipAddress2)) {
                Object[] objectArray = new Object[]{string};
                String string2 = MessageFormat.format(res.getString("JPanelAddWizardEnterNewConfig_The_0_field_is_not4"), objectArray);
                Trace.logError((String)"DsNewApplianceWizard", (String)string2);
                Message.invokeLater((Component)this, (String)string2, (Component)jTextField);
                return false;
            }
            if (ipAddress.equals((Object)ipAddress.getNetworkAddress(ipAddress2))) {
                Object[] objectArray = new Object[]{string};
                String string3 = MessageFormat.format(res.getString("JPanelAddWizardEnterNewConfig_The_0_field_is_not5"), objectArray);
                Trace.logError((String)"DsNewApplianceWizard", (String)string3);
                Message.invokeLater((Component)this, (String)string3, (Component)jTextField);
                return false;
            }
            if (ipAddress.equals((Object)ipAddress.getBroadcastAddress(ipAddress2))) {
                Object[] objectArray = new Object[]{string};
                String string4 = MessageFormat.format(res.getString("JPanelAddWizardEnterNewConfig_The_0_field_is_not6"), objectArray);
                Trace.logError((String)"DsNewApplianceWizard", (String)string4);
                Message.invokeLater((Component)this, (String)string4, (Component)jTextField);
                return false;
            }
            return true;
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Trace.logError((String)"DsNewApplianceWizard", (String)"Invalid Argument Exception", (Throwable)exceptionInvalidArgument);
            Object[] objectArray = new Object[]{string};
            String string5 = MessageFormat.format(res.getString("JPanelAddWizardEnterNewConfig_The_0_field_is_not"), objectArray);
            Message.invokeLater((Component)this, (String)string5, (Component)jTextField);
            return false;
        }
    }
}

