/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrAidpHelper;
import com.avocent.avworks.nmm.avr.AvrAsmpHelper;
import com.avocent.avworks.nmm.avr.AvrRipInfo;
import com.avocent.avworks.nmm.avr.AvrServerInfo;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.common.AsmpConnection;
import com.avocent.avworks.nmm.common.DiscoverInfo;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.ProductInfo;
import com.avocent.avworks.services.Unit;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.JWrappingLabel;
import com.avocent.lib.gui.wizards.InterfaceWizardPanel;
import com.avocent.lib.gui.wizards.JDialogWizard;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.net.MacAddress;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.ThreadContinuous;
import com.avocent.protocols.aidp.AidpDiscoverInfo;
import com.avocent.protocols.aidp.AidpSession;
import com.avocent.protocols.snmp.VarBind;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.net.InetAddress;
import java.text.MessageFormat;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class JPanelAddWizardLocateExisting
extends JPanel
implements InterfaceWizardPanel {
    public static final String CNAME = "JPanelAddWizardLocateExisting";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    JWrappingLabel jWrappingLabel1 = new JWrappingLabel();
    JWrappingLabel jWrappingLabel2 = new JWrappingLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JProgressBar jProgressBar1 = new JProgressBar();
    private JDialogWizard m_dialogWizard = null;
    private int m_nID = -1;
    private String m_szTitle = "";
    private Object[] m_aoProductType = new Object[]{"<PRODUCT TYPE>"};

    public JPanelAddWizardLocateExisting(JDialogWizard jDialogWizard, int n, String string) throws ExceptionConstructorFailed {
        this.m_dialogWizard = jDialogWizard;
        this.m_nID = n;
        this.m_szTitle = string;
        this.m_aoProductType = (Object[])this.m_dialogWizard.getValue((Object)"ProductType");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)"DsAddWizard", (String)"Unable to initialize panel");
            throw new ExceptionConstructorFailed();
        }
        this.onInit();
    }

    void jbInit() throws Exception {
        this.jWrappingLabel1.setText(MessageFormat.format(res.getString("JPanelAddWizardLocateExisting_Search_Appliance_InProgress"), this.m_aoProductType));
        this.setLayout(this.gridBagLayout1);
        this.jWrappingLabel2.setText(res.getString("JPanelAddWizardLocateExisting_Please_wait_"));
        this.add((Component)this.jWrappingLabel1, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jWrappingLabel2, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 18, 2, new Insets(12, 0, 0, 0), 0, 0));
        this.add((Component)this.jProgressBar1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.5, 11, 0, new Insets(12, 0, 0, 0), 150, 0));
    }

    public String getTitle() {
        return this.m_szTitle;
    }

    public int getID() {
        return this.m_nID;
    }

    public void onInit() {
    }

    public void onSetActive() {
        Trace.logInfo((String)"DsAddWizard", (String)"Locate Existing Page Set Active");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanelAddWizardLocateExisting.this.m_dialogWizard.setWizardButtons(8);
                JPanelAddWizardLocateExisting.this.m_dialogWizard.setDefaultButton(8);
                JPanelAddWizardLocateExisting.this.setStatusMessage(MessageFormat.format(res.getString("JPanelAddWizardLocateExisting_Search_Appliance_InProgress"), JPanelAddWizardLocateExisting.this.m_aoProductType));
                try {
                    JPanelAddWizardLocateExisting.this.jProgressBar1.setMinimum(0);
                    JPanelAddWizardLocateExisting.this.jProgressBar1.setMaximum(15);
                    JPanelAddWizardLocateExisting.this.jProgressBar1.setValue(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                IpAddress ipAddress = (IpAddress)JPanelAddWizardLocateExisting.this.m_dialogWizard.getValue((Object)"IpAddress");
                Thread thread = new Thread(new ApplianceLocator(ipAddress.getString()));
                Trace.logInfo((String)"DsAddWizard", (String)"Starting Search Existing Thread");
                thread.start();
            }
        });
    }

    public int onNext() {
        return -1;
    }

    public int onBack() {
        return -1;
    }

    public boolean onFinish() {
        return true;
    }

    public void onDestroy() {
        Trace.logInfo((String)"DsAddWizard", (String)"onDestroy");
    }

    public void setStatusMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanelAddWizardLocateExisting.this.jWrappingLabel1.setText(string);
            }
        });
    }

    public void setProgress(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    int n2 = JPanelAddWizardLocateExisting.this.jProgressBar1.getMaximum();
                    if (n <= n2) {
                        Trace.logInfo((String)"DsAddWizard", (String)("Progress=" + n));
                        JPanelAddWizardLocateExisting.this.jProgressBar1.setValue(n);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    class ThreadProgress
    extends ThreadContinuous {
        private int m_nCurrentProgress;

        public ThreadProgress() {
            super(1000L);
            this.m_nCurrentProgress = 0;
        }

        protected void performTask() {
            JPanelAddWizardLocateExisting.this.setProgress(this.m_nCurrentProgress++);
        }
    }

    class ApplianceLocator
    implements Runnable {
        String m_szApplianceAddress;

        public ApplianceLocator(String string) {
            this.m_szApplianceAddress = string;
        }

        public void run() {
            Trace.logInfo((String)"DsAddWizard", (String)"Locate Existing search thread started");
            ThreadProgress threadProgress = new ThreadProgress();
            Trace.logInfo((String)"DsAddWizard", (String)"Starting Search Progress Thread");
            threadProgress.start();
            this.getApplianceInfo(this.m_szApplianceAddress);
            threadProgress.stopThread();
            Trace.logInfo((String)"DsAddWizard", (String)"Locate Existing search thread stopped");
        }

        public boolean getApplianceInfo(String string) {
            Trace.logInfo((String)"DsAddWizard", (String)("Searching for existing DSR at " + string));
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                try {
                    return this.discoverViaAsmp(inetAddress);
                }
                catch (Exception exception) {
                    return this.discoverViaAidp(inetAddress);
                }
            }
            catch (Exception exception) {
                Trace.logError((String)"DsAddWizard", (String)"Error obtaining information from applinace", (Throwable)exception);
                JPanelAddWizardLocateExisting.this.m_dialogWizard.showPage(10);
                return false;
            }
        }

        private boolean discoverViaAsmp(InetAddress inetAddress) throws Exception {
            AsmpConnection asmpConnection = new AsmpConnection();
            try {
                asmpConnection.openAnonymousConnection(inetAddress);
            }
            catch (Exception exception) {
                asmpConnection.closeAsmpSession();
                throw new ExceptionRequestFailed((Throwable)exception);
            }
            AvrAsmpHelper avrAsmpHelper = new AvrAsmpHelper(asmpConnection);
            if (this.getApplianceInfo(avrAsmpHelper.discover())) {
                AvrRipInfo[] avrRipInfoArray = AvrSnmpHelper.getRipInfo(asmpConnection);
                JPanelAddWizardLocateExisting.this.m_dialogWizard.putValue((Object)"RipInfo", (Object)avrRipInfoArray);
                AvrServerInfo[] avrServerInfoArray = AvrSnmpHelper.getServerInfo(asmpConnection);
                JPanelAddWizardLocateExisting.this.m_dialogWizard.putValue((Object)"ServerInfo", (Object)avrServerInfoArray);
                JPanelAddWizardLocateExisting.this.m_dialogWizard.showPage(11);
                asmpConnection.closeAsmpSession();
                return true;
            }
            asmpConnection.closeAsmpSession();
            return false;
        }

        private boolean discoverViaAidp(InetAddress inetAddress) throws IOException, ExceptionRequestFailed {
            AidpSession aidpSession = new AidpSession(inetAddress);
            AidpDiscoverInfo[] aidpDiscoverInfoArray = aidpSession.discover();
            if (aidpDiscoverInfoArray.length == 0) {
                Trace.logInfo((String)"DsAddWizard", (String)"NOTE: NO DSRs WERE FOUND");
                JPanelAddWizardLocateExisting.this.m_dialogWizard.showPage(10);
                return false;
            }
            if (aidpDiscoverInfoArray.length != 1) {
                Trace.logError((String)"DsAddWizard", (String)("Too many DSRs found. NumFound=" + aidpDiscoverInfoArray.length));
                JPanelAddWizardLocateExisting.this.m_dialogWizard.showPage(10);
                return false;
            }
            try {
                VarBind varBind = new VarBind("mib-2.system.sysName.0");
                if (!aidpSession.snmpGet(varBind)) {
                    Trace.logError((String)"DsAddWizard", (String)"Unable to obtain appliance MIB-II system vars");
                    JPanelAddWizardLocateExisting.this.m_dialogWizard.showPage(10);
                    return false;
                }
                String string = varBind.getStringValue();
                if (this.getApplianceInfo(new DiscoverInfo(aidpDiscoverInfoArray[0], string))) {
                    AvrRipInfo[] avrRipInfoArray = AvrAidpHelper.getRipInfo(aidpDiscoverInfoArray[0].getIpAddress().toString());
                    JPanelAddWizardLocateExisting.this.m_dialogWizard.putValue((Object)"RipInfo", (Object)avrRipInfoArray);
                    AvrServerInfo[] avrServerInfoArray = AvrAidpHelper.getServerInfo(aidpDiscoverInfoArray[0].getIpAddress().toString());
                    JPanelAddWizardLocateExisting.this.m_dialogWizard.putValue((Object)"ServerInfo", (Object)avrServerInfoArray);
                    JPanelAddWizardLocateExisting.this.m_dialogWizard.showPage(11);
                    return true;
                }
                return false;
            }
            catch (Exception exception) {
                Trace.logError((String)JPanelAddWizardLocateExisting.CNAME, (String)("discoverViaAidp(" + inetAddress + ")"), (Throwable)exception);
                throw new ExceptionRequestFailed((Throwable)exception);
            }
        }

        private boolean getApplianceInfo(DiscoverInfo discoverInfo) throws IOException, ExceptionRequestFailed {
            MacAddress macAddress;
            ProductInfo productInfo = (ProductInfo)JPanelAddWizardLocateExisting.this.m_dialogWizard.getValue((Object)"ProductInfo");
            String string = AVWorksBranding.getApplianceName((boolean)true);
            Object[] objectArray = new Object[]{string};
            Trace.logInfo((String)"DsAddWizard", (String)("Product ID=" + discoverInfo.getProductID()));
            try {
                if (discoverInfo.getProductID() != productInfo.getID()) {
                    Trace.logInfo((String)"DsAddWizard", (String)("Unit found, not correct type Found Type=" + discoverInfo.getProductID() + " Adding Type=" + productInfo.getID()));
                    throw new ExceptionRequestFailed();
                }
            }
            catch (Exception exception) {
                JPanelAddWizardLocateExisting.this.m_dialogWizard.putValue((Object)"FinishHeader", (Object)MessageFormat.format(res.getString("JPanelAddWizardLocateExisting_New_Wizard_Unsuccessful"), objectArray));
                JPanelAddWizardLocateExisting.this.m_dialogWizard.putValue((Object)"FinishExclamation", (Object)new Boolean(true));
                JPanelAddWizardLocateExisting.this.m_dialogWizard.putValue((Object)"FinishStatus", (Object)MessageFormat.format(res.getString("JPanelAddWizardLocateExisting_A_unit_responded_but_not_type"), JPanelAddWizardLocateExisting.this.m_aoProductType));
                JPanelAddWizardLocateExisting.this.m_dialogWizard.putValue((Object)"FinishClose", (Object)res.getString("JPanelAddWizardLocateExisting_Click_Finish_to_exit_"));
                JPanelAddWizardLocateExisting.this.m_dialogWizard.putValue((Object)"FinishButtons", (Object)new Integer(5));
                JPanelAddWizardLocateExisting.this.m_dialogWizard.showPage(13);
                return false;
            }
            MacAddress macAddress2 = discoverInfo.getMacAddress();
            JPanelAddWizardLocateExisting.this.m_dialogWizard.putValue((Object)"MacAddress", (Object)macAddress2);
            JPanelAddWizardLocateExisting.this.setStatusMessage(MessageFormat.format(res.getString("JPanelAddWizardLocateExisting_Found_Appliance"), JPanelAddWizardLocateExisting.this.m_aoProductType));
            Trace.logInfo((String)"DsAddWizard", (String)("Found Appliance MAC=" + discoverInfo.getMacAddress().getString()));
            Trace.logInfo((String)"DsAddWizard", (String)("Product ID =" + productInfo.getID()));
            Trace.logInfo((String)"DsAddWizard", (String)("Product Type =" + productInfo.getName()));
            String string2 = discoverInfo.getName();
            Trace.logInfo((String)"DsAddWizard", (String)("Appliance Name=" + string2));
            JPanelAddWizardLocateExisting.this.setStatusMessage(MessageFormat.format(res.getString("JPanelAddWizardLocateExisting_Reading_Appliance_info"), JPanelAddWizardLocateExisting.this.m_aoProductType));
            if (string2.length() == 0) {
                Trace.logInfo((String)"DsAddWizard", (String)"SysName was blank");
                macAddress = discoverInfo.getMacAddress();
                String string3 = macAddress.getString().substring(9);
                Trace.logInfo((String)"DsAddWizard", (String)("Type=" + productInfo.getName() + " MAC=" + string3));
                string2 = productInfo.getName() + " " + string3;
                Trace.logInfo((String)"DsAddWizard", (String)("Default SysName=" + string2));
            }
            string2 = Unit.getUniqueName((String)string2);
            Trace.logInfo((String)"DsAddWizard", (String)("Unique Appliance Name=" + string2));
            macAddress = new ApplianceInfo(0, string2, productInfo.getName(), productInfo.getID(), "", discoverInfo.getIpAddress().toString(), "", "", productInfo.getNmmID(), true);
            JPanelAddWizardLocateExisting.this.m_dialogWizard.putValue((Object)"ApplianceInfo", (Object)macAddress);
            return true;
        }
    }
}

