/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrDatabaseHelper;
import com.avocent.avworks.nmm.avr.AvrRipInfo;
import com.avocent.avworks.nmm.avr.AvrServerInfo;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.components.JWrappingLabel;
import com.avocent.lib.gui.wizards.InterfaceWizardPanel;
import com.avocent.lib.gui.wizards.JDialogWizard;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JPanelAddWizardNewConfigOk
extends JPanel
implements InterfaceWizardPanel {
    public static final String CNAME = "JPanelAddWizardNewConfigOk";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    JWrappingLabel jWrappingLabel1 = new JWrappingLabel();
    JWrappingLabel jWrappingLabel2 = new JWrappingLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JDialogWizard m_dialogWizard = null;
    private int m_nID = -1;
    private String m_szTitle = "";
    private Object[] m_aoProductType = new Object[]{"<PRODUCT TYPE>"};

    public JPanelAddWizardNewConfigOk(JDialogWizard jDialogWizard, int n, String string) throws ExceptionConstructorFailed {
        this.m_dialogWizard = jDialogWizard;
        this.m_nID = n;
        this.m_szTitle = string;
        this.m_aoProductType = (Object[])this.m_dialogWizard.getValue((Object)"ProductType");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)"DsAddWizard", (String)"Unable to initialize ExistingFound page");
            throw new ExceptionConstructorFailed();
        }
        this.onInit();
    }

    void jbInit() throws Exception {
        this.jWrappingLabel1.setText(MessageFormat.format(res.getString("JPanelAddWizardNewConfigOk_The_IP_configuration"), this.m_aoProductType));
        this.setLayout(this.gridBagLayout1);
        this.jWrappingLabel2.setText(res.getString("JPanelAddWizardNewConfigOk_To_continue_press"));
        this.add((Component)this.jWrappingLabel1, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jWrappingLabel2, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 18, 2, new Insets(12, 12, 0, 0), 0, 0));
    }

    public String getTitle() {
        return this.m_szTitle;
    }

    public int getID() {
        return this.m_nID;
    }

    public void onInit() {
    }

    public void onSetActive() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Trace.logInfo((String)"DsAddWizard", (String)"Existing Found Page Set Active");
                JPanelAddWizardNewConfigOk.this.m_dialogWizard.setWizardButtons(10);
                JPanelAddWizardNewConfigOk.this.m_dialogWizard.setDefaultButton(2);
            }
        });
    }

    public int onNext() {
        Trace.logInfo((String)"DsAddWizard", (String)"Existing Found Page On Next");
        String string = AVWorksBranding.getApplianceName((boolean)true);
        Object[] objectArray = new Object[]{string};
        ApplianceInfo applianceInfo = (ApplianceInfo)this.m_dialogWizard.getValue((Object)"ApplianceInfo");
        AvrRipInfo[] avrRipInfoArray = (AvrRipInfo[])this.m_dialogWizard.getValue((Object)"RipInfo");
        AvrServerInfo[] avrServerInfoArray = (AvrServerInfo[])this.m_dialogWizard.getValue((Object)"ServerInfo");
        Trace.logInfo((String)"DsAddWizard", (String)"Are any cascaded switches attached to appliance");
        boolean bl = false;
        for (int i = 0; i < avrRipInfoArray.length; ++i) {
            if (avrRipInfoArray[i].isSwitchDetected() && avrRipInfoArray[i].getRipStatus().equals(res.getString("JPanelAddWizardNewConfigOk_Online"))) {
                Trace.logInfo((String)"DsAddWizard", (String)("RIP " + avrRipInfoArray[i].getRipID() + " HAS SWITCH"));
                bl = true;
                continue;
            }
            Trace.logInfo((String)"DsAddWizard", (String)("RIP " + avrRipInfoArray[i].getRipID() + " NO SWITCH"));
            Trace.logInfo((String)"DsAddWizard", (String)("RIP " + avrRipInfoArray[i].getRipID() + " SWITCH DETECTED = " + avrRipInfoArray[i].isSwitchDetected()));
            Trace.logInfo((String)"DsAddWizard", (String)("RIP " + avrRipInfoArray[i].getRipID() + " STATUS = " + avrRipInfoArray[i].getRipStatus()));
        }
        if (bl) {
            Trace.logInfo((String)"DsAddWizard", (String)"Some cascade switches detected so goto Cascade Switch page");
            return 12;
        }
        Trace.logInfo((String)"DsAddWizard", (String)"No cascade switches detected. Add the appliance");
        try {
            AvrDatabaseHelper.resyncAppliance(applianceInfo, null, avrRipInfoArray, avrServerInfoArray);
            this.m_dialogWizard.putValue((Object)"FinishStatus", (Object)MessageFormat.format(res.getString("JPanelAddWizardNewConfigOk_Appliance_was_successfuly"), this.m_aoProductType));
            this.m_dialogWizard.putValue((Object)"FinishHeader", (Object)MessageFormat.format(res.getString("JPanelAddWizardNewConfigOk_Completing_the_New"), objectArray));
            this.m_dialogWizard.putValue((Object)"FinishExclamation", (Object)new Boolean(false));
            this.m_dialogWizard.putValue((Object)"FinishClose", (Object)res.getString("JPanelAddWizardNewConfigOk_To_close_wizard_Finish"));
            this.m_dialogWizard.putValue((Object)"FinishButtons", (Object)new Integer(4));
        }
        catch (Exception exception) {
            this.m_dialogWizard.putValue((Object)"FinishStatus", (Object)MessageFormat.format(res.getString("JPanelAddWizardNewConfigOk_The_wizard_did_not"), this.m_aoProductType));
            this.m_dialogWizard.putValue((Object)"FinishHeader", (Object)MessageFormat.format(res.getString("JPanelAddWizardNewConfigOk_New_Wizard_Unsuccessful"), objectArray));
            this.m_dialogWizard.putValue((Object)"FinishExclamation", (Object)new Boolean(true));
            this.m_dialogWizard.putValue((Object)"FinishClose", (Object)res.getString("JPanelAddWizardNewConfigOk_Click_Back_to_retry"));
            this.m_dialogWizard.putValue((Object)"FinishButtons", (Object)new Integer(5));
        }
        return 13;
    }

    public int onBack() {
        return this.m_dialogWizard.getPreviousPageID();
    }

    public boolean onFinish() {
        return true;
    }

    public void onDestroy() {
    }
}

