/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AmpControllerAvr;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.avr.JDialogAddLicense;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.avworks.nmm.common.MibEnum;
import com.avocent.avworks.nmm.common.MibEnumObject;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.components.JTableAvocent;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class JPanelLicensedOptions
extends JPanelAmpPanel {
    public static final String TRACE_CONTEXT = "Licensed Options Panel";
    public static final String CNAME = "JPanelLicensedOptions";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    private InterfaceValueObject[][] m_licensedOptions = null;
    private int LICENSED_OPTION_NAME_INDEX = 0;
    private int LICENSED_OPTION_NAME_STATUS = 1;
    private int LICENSED_OPTION_INDEX = 2;
    private MibEnumObject[] m_licensedOptionStatusEnum = null;
    private LicensedOptionsTableModel m_tmLicensedOptions = null;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout m_gridBagLayout2 = new GridBagLayout();
    JPanel m_jpMainPanel = new JPanel();
    JLabel m_jLabelFiller = new JLabel();
    JTableAvocent m_jtOptionsTable = new JTableAvocent();
    JScrollPane m_jspOptionsScrollPane = new JScrollPane();
    JPanel jm_jpButtonPanel = new JPanel();
    JButton m_jbAddButton = new JButton();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JButton m_jbDeleteButton = new JButton();

    public JPanelLicensedOptions(AmpControllerAvr ampControllerAvr) throws ExceptionConstructorFailed {
        super((AmpController)ampControllerAvr, res.getString("JPanelLicensedOptions_License"), res.getString("JPanelLicensedOptions_License"), res.getString("JPanelLicensedOptions_Specify_License"), "IDH_SETTINGS_LICENSED_OPTIONS");
        try {
            this.jbInit();
            this.m_jbAddButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JPanelLicensedOptions.this.addActionPerformed();
                }
            });
            this.m_jbDeleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JPanelLicensedOptions.this.deleteActionPerformed();
                }
            });
            this.m_tmLicensedOptions = new LicensedOptionsTableModel();
            this.m_jtOptionsTable.setModel((TableModel)this.m_tmLicensedOptions);
            this.m_jtOptionsTable.setAutoResizeMode(4);
            this.m_jtOptionsTable.setColumnSelectionAllowed(false);
            this.m_jtOptionsTable.getTableHeader().setReorderingAllowed(false);
            this.m_jtOptionsTable.setShowGrid(false);
            this.m_jtOptionsTable.setIntercellSpacing(new Dimension(0, 0));
            this.m_jtOptionsTable.setShowVerticalLines(false);
            this.m_jtOptionsTable.getSelectionModel().addListSelectionListener(new LicensedOptionsTableSelectionListener());
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Constructor failed with exception: " + exception.getMessage()), (Throwable)exception);
            throw new ExceptionConstructorFailed(exception.getMessage());
        }
    }

    public JPanelLicensedOptions() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.m_jpMainPanel.setLayout(this.m_gridBagLayout2);
        this.m_jspOptionsScrollPane.getViewport().setBackground(Color.white);
        this.m_jbAddButton.setText(res.getString("JPanelLicensedOptions_Add_"));
        this.jm_jpButtonPanel.setLayout(this.gridBagLayout2);
        this.m_jbDeleteButton.setText(res.getString("JPanelLicensedOptions_Delete"));
        this.setMinimumSize(new Dimension(257, 186));
        this.setPreferredSize(new Dimension(356, 186));
        this.add(this.m_jpMainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 57));
        this.m_jpMainPanel.add((Component)this.m_jLabelFiller, new GridBagConstraints(-1, 2, 0, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_jpMainPanel.add((Component)this.m_jspOptionsScrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(15, 15, 15, 15), 0, 0));
        this.getContentPane().add((Component)this.jm_jpButtonPanel, new GridBagConstraints(1, 0, 1, 1, 0.1, 1.0, 18, 2, new Insets(20, 5, 5, 5), 0, 0));
        this.m_jspOptionsScrollPane.getViewport().setBackground(UIManager.getColor("window"));
        this.m_jspOptionsScrollPane.getViewport().add((Component)this.m_jtOptionsTable, null);
        this.jm_jpButtonPanel.add((Component)this.m_jbAddButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jm_jpButtonPanel.add((Component)this.m_jbDeleteButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public boolean onKillActive() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"onKillActive() called for Licensed Options");
        return false;
    }

    public boolean onSetActive() {
        super.onSetActive();
        return true;
    }

    protected boolean initialize() {
        ButtonPanel.equalize((JPanel)this.jm_jpButtonPanel);
        this.m_jbDeleteButton.setEnabled(false);
        try {
            this.getAndSetLicensedOptions();
            return true;
        }
        catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
            this.m_nErrorStatus = exceptionSnmpRequestFailed.getErrorCode();
            Trace.logError((String)TRACE_CONTEXT, (String)exceptionSnmpRequestFailed.getMessage(), (Throwable)exceptionSnmpRequestFailed);
            return false;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            Trace.logError((String)TRACE_CONTEXT, (String)exceptionAsmpRequestFailed.getMessage(), (Throwable)exceptionAsmpRequestFailed);
            return false;
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    private void getAndSetLicensedOptions() throws ExceptionAsmpRequestFailed, ExceptionSnmpRequestFailed, Exception {
        try {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Getting table values for Licensed Options");
            this.m_licensedOptionStatusEnum = MibEnum.getEnumObjectsForOID((String)"avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsTable.dsLicensedOptionsTableEntry.dsLicensedOptionsTableStatus");
            Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsTable.dsLicensedOptionsTableEntry.dsLicensedOptionsTableName", "avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsTable.dsLicensedOptionsTableEntry.dsLicensedOptionsTableStatus", "avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsTable.dsLicensedOptionsTableEntry.dsLicensedOptionsTableIndex"};
            this.m_licensedOptions = null;
            this.m_licensedOptions = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), objectArray);
            int n = this.m_licensedOptions.length;
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Retrieved Licensed Options, number of options = " + n));
            this.m_acController.getAppliance().setValue((Object)"LDAP_AUTH_LICENSED", (Object)new Boolean(false));
            for (int i = 0; i < n; ++i) {
                Integer n2 = (Integer)this.m_licensedOptions[i][this.LICENSED_OPTION_INDEX].getValue();
                if (n2 != 1) continue;
                Integer n3 = (Integer)this.m_licensedOptions[i][this.LICENSED_OPTION_NAME_STATUS].getValue();
                int n4 = n3;
                if (n4 == 2) {
                    this.m_acController.getAppliance().setValue((Object)"LDAP_AUTH_LICENSED", (Object)new Boolean(true));
                }
                if (n4 != 3) continue;
                this.m_acController.getAppliance().setValue((Object)"LDAP_AUTH_LICENSED", (Object)new Boolean(false));
                this.m_licensedOptions = null;
            }
            this.m_tmLicensedOptions.fireTableDataChanged();
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Updated the Licensed Options table with latest data");
        }
        catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)exceptionSnmpRequestFailed.getMessage(), (Throwable)exceptionSnmpRequestFailed);
            throw exceptionSnmpRequestFailed;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)exceptionAsmpRequestFailed.getMessage(), (Throwable)exceptionAsmpRequestFailed);
            throw exceptionAsmpRequestFailed;
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            throw exception;
        }
    }

    private void addActionPerformed() {
        try {
            JDialogAddLicense jDialogAddLicense = new JDialogAddLicense(this, this.m_acController);
            jDialogAddLicense.showAdd();
            this.getAndSetLicensedOptions();
        }
        catch (Exception exception) {
            String string = "Exception while attempting to add Licensed Option.  " + exception.getMessage();
            Trace.logError((String)TRACE_CONTEXT, (String)string, (Throwable)exception);
            string = res.getString("JPanelLicensedOptions_License_Option_Add_Failed");
            Message.show((Component)((Object)this), (String)string);
        }
    }

    private void deleteActionPerformed() {
        try {
            int n = JOptionPane.showConfirmDialog((Component)this.m_acController.getMainFrame(), res.getString("JPanelLicensedOptions_Are_you_sure_delete_option"), res.getString("JPanelLicensedOptions_Confirm_Deletion"), 0);
            if (n == 0) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"User Selected to delete license option");
                Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsTable.dsLicensedOptionsTableEntry.dsLicensedOptionsTableControl"};
                Object[] objectArray2 = new Object[]{new Integer(1)};
                String string = "1";
                AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), objectArray, objectArray2, string);
                this.getAndSetLicensedOptions();
            }
        }
        catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)exceptionSnmpRequestFailed.getMessage());
            Message.show((Component)((Object)this), (String)exceptionSnmpRequestFailed.getMessage());
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)exceptionAsmpRequestFailed.getMessage());
            Message.show((Component)((Object)this), (String)exceptionAsmpRequestFailed.getMessage());
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage());
            Message.show((Component)((Object)this), (String)exception.getMessage());
        }
    }

    private class LicensedOptionsTableSelectionListener
    implements ListSelectionListener {
        private LicensedOptionsTableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = JPanelLicensedOptions.this.m_jtOptionsTable.getSelectedRow();
            if (n == -1) {
                JPanelLicensedOptions.this.m_jbDeleteButton.setEnabled(false);
                return;
            }
            int n2 = JPanelLicensedOptions.this.m_jtOptionsTable.getSelectedColumn();
            String string = (String)JPanelLicensedOptions.this.m_jtOptionsTable.getValueAt(n, JPanelLicensedOptions.this.LICENSED_OPTION_NAME_STATUS);
            if (string.equalsIgnoreCase(res.getString("JPanelLicensedOptions_Yes"))) {
                JPanelLicensedOptions.this.m_jbDeleteButton.setEnabled(true);
            } else {
                JPanelLicensedOptions.this.m_jbDeleteButton.setEnabled(false);
            }
        }
    }

    class LicensedOptionsTableModel
    extends AbstractTableModel {
        String[] m_szColumnName = new String[]{res.getString("JPanelLicensedOptions_Option_Name"), res.getString("JPanelLicensedOptions_Option_Enabled")};

        LicensedOptionsTableModel() {
        }

        public int getColumnCount() {
            return this.m_szColumnName.length;
        }

        public int getRowCount() {
            if (JPanelLicensedOptions.this.m_licensedOptions != null) {
                return JPanelLicensedOptions.this.m_licensedOptions.length;
            }
            return 0;
        }

        public String getColumnName(int n) {
            return this.m_szColumnName[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == JPanelLicensedOptions.this.LICENSED_OPTION_NAME_STATUS) {
                int n3 = Integer.parseInt(JPanelLicensedOptions.this.m_licensedOptions[n][JPanelLicensedOptions.this.LICENSED_OPTION_NAME_STATUS].toString());
                if (n3 == 3) {
                    return "";
                }
                String string = JPanelLicensedOptions.this.m_licensedOptionStatusEnum[--n3].getStrValue();
                return string;
            }
            if (JPanelLicensedOptions.this.m_licensedOptions != null) {
                return JPanelLicensedOptions.this.m_licensedOptions[n][JPanelLicensedOptions.this.LICENSED_OPTION_NAME_INDEX];
            }
            return "";
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

