/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AmpControllerAvr;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.gui.components.JTextFieldAvocent;
import com.avocent.lib.gui.components.JWrappingLabel;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JPanelLocalUserSettings
extends JPanelAmpPanel {
    public static final String CNAME = "JPanelLocalUserSettings";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    JPanel m_jpMainPanel = new JPanel(new GridBagLayout());
    JLabel m_jlFiller = new JLabel(" ");
    JLabel m_jlUser = new JLabel(res.getString("JPanelLocalUserSettings_UsernameLabel_"));
    JLabel m_jlPass = new JLabel(res.getString("JPanelLocalUserSettings_PasswordLabel_"));
    JLabel m_jlPass2 = new JLabel(res.getString("JPanelLocalUserSettings_VerifyPasswordLabel_"));
    JTextFieldAvocent m_jtfUser = new JTextFieldAvocent();
    JPasswordField m_pwPass = new JPasswordField();
    JPasswordField m_pwPass2 = new JPasswordField();
    private DocumentListener docListener = null;
    JPanel m_notePanel = new JPanel();
    JWrappingLabel m_noteLabel = new JWrappingLabel(res.getString("JPanelLocalUserSettings_Note"));

    public JPanelLocalUserSettings(AmpControllerAvr ampControllerAvr) throws ExceptionConstructorFailed {
        super((AmpController)ampControllerAvr, res.getString("JPanelLocalUserSettings_PanelLabel"), res.getString("JPanelLocalUserSettings_Users") + " - " + res.getString("JPanelLocalUserSettings_PanelLabel"), res.getString("JPanelLocalUserSettings_PanelDescription"), "IDH_SETTINGS_TAB_USERS_LOCAL");
        this.getContentPane().setVisible(false);
        try {
            this.jbInit();
            this.m_noteLabel.setColumns(40);
        }
        catch (Exception exception) {
            this.logError("Constructor failed with exception: " + exception.getMessage(), exception);
            throw new ExceptionConstructorFailed(exception.getMessage());
        }
    }

    void jbInit() throws Exception {
        this.m_jtfUser.setColumns(16);
        this.m_pwPass.setColumns(16);
        this.m_pwPass2.setColumns(16);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(-1, -1, 0, 1, 0.0, 0.0, 10, 2, new Insets(5, 10, 5, 5), 0, 0);
        this.m_jpMainPanel.add((Component)this.m_jlUser, gridBagConstraints);
        this.m_jpMainPanel.add((Component)this.m_jtfUser, gridBagConstraints2);
        this.m_jpMainPanel.add((Component)this.m_jlPass, gridBagConstraints);
        this.m_jpMainPanel.add((Component)this.m_pwPass, gridBagConstraints2);
        this.m_jpMainPanel.add((Component)this.m_jlPass2, gridBagConstraints);
        this.m_jpMainPanel.add((Component)this.m_pwPass2, gridBagConstraints2);
        this.m_noteLabel.setFont(new Font("Dialog", 1, 11));
        this.setLayout(new GridBagLayout());
        this.add(this.m_jpMainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_notePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.m_notePanel.add((Component)this.m_noteLabel, new GridBagConstraints(-1, -1, 0, 1, 0.0, 1.0, 18, 0, new Insets(0, 10, 5, 10), 0, 0));
    }

    public boolean onKillActive() {
        this.logInfo("onKillActive() was called.");
        if (this.m_nState == 103) {
            try {
                if (this.isModified()) {
                    this.validateInputFields();
                }
                return false;
            }
            catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                Message.show((Component)this.m_acController.getMainFrame(), (String)exceptionInvalidArgument.getMessage());
                return true;
            }
            catch (Exception exception) {
                this.m_acController.showException(null, this.getTraceContext(), "", (Throwable)exception);
                return true;
            }
        }
        return false;
    }

    protected boolean initialize() {
        this.getContentPane().setVisible(this.m_acController.getAppliance().isUserApplianceAdmin());
        try {
            this.removeEventListeners();
            Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsServer.dsOverrideUserName.0", "avocent.ds.dsManagement.dsServer.dsOverrideUserPassword.0"};
            InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), objectArray);
            this.m_jtfUser.setText(interfaceValueObjectArray[0].toString());
            this.m_pwPass.setText(interfaceValueObjectArray[1].toString());
            this.m_pwPass2.setText(interfaceValueObjectArray[1].toString());
            this.addEventListeners();
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            return false;
        }
        catch (Exception exception) {
            this.logError(exception.getMessage(), exception);
            return false;
        }
    }

    protected boolean applyValues() {
        Object[] objectArray = new String[]{"avocent.ds.dsManagement.dsServer.dsOverrideUserName.0", "avocent.ds.dsManagement.dsServer.dsOverrideUserPassword.0"};
        Object[] objectArray2 = new Object[]{this.m_jtfUser.getText().trim(), this.m_pwPass.getText().trim()};
        try {
            this.validateInputFields();
            AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), objectArray, objectArray2);
            return true;
        }
        catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
            this.m_nErrorStatus = exceptionSnmpRequestFailed.getErrorCode();
            this.logError(exceptionSnmpRequestFailed.getMessage(), (Exception)((Object)exceptionSnmpRequestFailed));
            this.m_szErrorLabel = null;
            this.setErrorFieldFocus(objectArray, exceptionSnmpRequestFailed.getErrorIndex() - 1);
            String string = "";
            if (this.m_szErrorLabel != null) {
                Object[] objectArray3 = new String[]{this.m_szErrorLabel};
                string = JPanelLocalUserSettings.getResourceString((ResourceManager)res, (String)"JPanelLocalUserSettings_Apply_Failed", (Object[])objectArray3);
            } else {
                string = res.getString("JPanelLocalUserSettings_Network_Apply_Failed");
            }
            Message.show((Component)this.m_acController.getMainFrame(), (String)(string + " " + exceptionSnmpRequestFailed.getMessage()));
            return false;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            String string = res.getString("JPanelLocalUserSettings_Network_Apply_Failed");
            Message.show((Component)this.m_acController.getMainFrame(), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
            return false;
        }
        catch (Exception exception) {
            this.logError(exception.getMessage(), exception);
            Message.show((Component)this.m_acController.getMainFrame(), (String)exception.getMessage());
            return false;
        }
    }

    private void addEventListeners() {
        this.docListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                JPanelLocalUserSettings.this.setIsModified(true);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                JPanelLocalUserSettings.this.setIsModified(true);
            }
        };
        this.m_jtfUser.getDocument().addDocumentListener(this.docListener);
        this.m_pwPass.getDocument().addDocumentListener(this.docListener);
        this.m_pwPass2.getDocument().addDocumentListener(this.docListener);
    }

    private void validateInputFields() throws ExceptionInvalidArgument {
        JPanelLocalUserSettings.validateString((JTextField)this.m_jtfUser, (JLabel)this.m_jlUser, (int)1, (int)16, (boolean)true);
        JPanelLocalUserSettings.validateString((JTextField)this.m_pwPass, (JLabel)this.m_jlPass, (int)5, (int)16, (boolean)true);
        String string = this.m_pwPass.getText().trim();
        String string2 = this.m_pwPass2.getText().trim();
        if (!string.equals(string2)) {
            String string3 = res.getString("JPanelLocalUserSettings_PasswordMismatch");
            this.m_pwPass2.requestFocusInWindow();
            throw new ExceptionInvalidArgument(string3);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLowerCase(c)) {
                bl2 = true;
                continue;
            }
            if (Character.isUpperCase(c)) {
                bl = true;
                continue;
            }
            if (!Character.isDigit(c)) continue;
            bl3 = true;
        }
        if (!(bl && bl2 && bl3)) {
            String string4 = res.getString("JPanelLocalUserSettings_PasswordComplexity");
            this.m_pwPass.requestFocusInWindow();
            throw new ExceptionInvalidArgument(string4);
        }
    }

    private void removeEventListeners() {
        this.logInfo("removeEventListeners() was called.");
        if (this.docListener != null) {
            this.m_jtfUser.getDocument().removeDocumentListener(this.docListener);
            this.m_pwPass.getDocument().removeDocumentListener(this.docListener);
            this.m_pwPass2.getDocument().removeDocumentListener(this.docListener);
            this.docListener = null;
        }
    }

    private void setErrorFieldFocus(Object[] objectArray, int n) {
        if (n > -1 && n < objectArray.length) {
            if (objectArray[n].equals("avocent.ds.dsManagement.dsServer.dsOverrideUserName.0")) {
                this.m_szErrorLabel = this.m_jlUser.getText();
                this.m_jtfUser.requestFocus();
            } else if (objectArray[n].equals("avocent.ds.dsManagement.dsServer.dsOverrideUserPassword.0")) {
                this.m_szErrorLabel = this.m_jlPass.getText();
                this.m_pwPass2.requestFocus();
            } else {
                this.m_szErrorLabel = null;
                this.logError("Unknown error index=" + n);
            }
            this.m_szErrorLabel = JPanelLocalUserSettings.removeColon((String)this.m_szErrorLabel);
        }
    }
}

