/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.JTextFieldAvocent;
import com.avocent.lib.gui.components.JTextFieldIPAddress;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.renderers.NameValue;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.ThreadContinuous;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JPanelNTPSettings
extends JPanelAmpPanel {
    public static final String CNAME = "JPanelNTPSettings";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    private DocumentListener m_docListener = null;
    private KeyListener m_keyListener = null;
    private ItemListener m_itemListener = null;
    private static final Integer DISABLED = new Integer(1);
    private static final Integer ENABLED = new Integer(2);
    private static final String PRIMARY = "1";
    private static final String SECONDARY = "2";
    private ThreadPollData m_threadPollData;
    private boolean m_bNoRecentErrors = false;
    private static final int APPLY_DELAY = 500;
    private final Integer NTP_NOT_ATTEMPTED = new Integer(1);
    private final Integer NTP_FAILED = new Integer(4);
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JCheckBox m_cbNtpEnabled = new JCheckBox();
    JPanel m_jpMainPanel = new JPanel();
    JLabel m_jlNtpServer = new JLabel();
    JTextFieldIPAddress m_jtfPrimaryServer = new JTextFieldIPAddress();
    JLabel m_jlPrimaryStatus = new JLabel();
    JTextFieldIPAddress m_jtfSecondaryServer = new JTextFieldIPAddress();
    JLabel m_jlSecondaryStatus = new JLabel();
    JLabel m_jlUpdate = new JLabel();
    JTextFieldAvocent m_jtfUpdate = new JTextFieldAvocent();
    JLabel m_jlFiller = new JLabel();

    public JPanelNTPSettings(AmpController ampController) throws ExceptionConstructorFailed {
        super(ampController, res.getString("JPanelNTPSettings_NTP"), res.getString("JPanelNTPSettings_Global") + " - " + res.getString("JPanelNTPSettings_NTP"), res.getString("JPanelNTPSettings_Specify_NTP"), "IDH_SETTINGS_TAB_GLOBAL_NTP");
        this.m_jpMainPanel.setVisible(false);
        try {
            this.jbInit();
            this.m_jtfPrimaryServer.setStyle(1);
        }
        catch (Exception exception) {
            this.logError("Constructor failed with exception: " + exception.getMessage(), exception);
            throw new ExceptionConstructorFailed(exception.getMessage());
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.m_jpMainPanel.setLayout(this.gridBagLayout2);
        this.m_jlNtpServer.setText(res.getString("JPanelNTPSettings_NTP_"));
        this.m_jlUpdate.setText(res.getString("JPanelNTPSettings_Update_"));
        this.m_cbNtpEnabled.setText(res.getString("JPanelNTPSettings_Enable_NTP"));
        this.m_jtfPrimaryServer.setColumns(12);
        this.m_jtfPrimaryServer.setName(res.getString("JPanelNTPSettings_Primary"));
        this.m_jtfSecondaryServer.setColumns(12);
        this.m_jtfSecondaryServer.setName(res.getString("JPanelNTPSettings_Secondary"));
        this.m_jtfUpdate.setColumns(4);
        this.m_jpMainPanel.add((Component)this.m_cbNtpEnabled, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.m_jpMainPanel.add((Component)this.m_jlNtpServer, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 35, 5, 5), 0, 0));
        this.m_jpMainPanel.add((Component)this.m_jtfPrimaryServer, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.m_jpMainPanel.add((Component)this.m_jlPrimaryStatus, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.m_jpMainPanel.add((Component)this.m_jtfSecondaryServer, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.m_jpMainPanel.add((Component)this.m_jlSecondaryStatus, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.m_jpMainPanel.add((Component)this.m_jlUpdate, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 35, 5, 5), 0, 0));
        this.m_jpMainPanel.add((Component)this.m_jtfUpdate, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.add(this.m_jpMainPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_jlFiller, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.1, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean onKillActive() {
        this.logInfo("onKillActive() was called.");
        if (this.m_nState != 103) {
            return false;
        }
        try {
            if (this.validateInputFields()) {
                Trace.logInfo((String)"AVR AMP panel", (String)"Suspending polling thread");
                this.m_threadPollData.suspendThread();
                return false;
            }
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            Message.show((Component)((Object)this), (String)exceptionInvalidArgument.getMessage());
        }
        catch (Exception exception) {
            this.m_acController.showException(null, this.getTraceContext(), "", (Throwable)exception);
        }
        return true;
    }

    public boolean onSetActive() {
        super.onSetActive();
        if (this.m_nState == 103) {
            Trace.logInfo((String)"AVR AMP panel", (String)"Resuming polling thread");
            this.m_threadPollData.resumeThread();
            this.m_threadPollData.interrupt();
        }
        return true;
    }

    public void onDestroy() {
        this.logInfo("onDestroy() was called.");
        if (this.m_nState == 103) {
            Trace.logInfo((String)"AVR AMP panel", (String)"Stopping polling thread");
            this.m_threadPollData.stopThread();
        }
        this.m_nState = 104;
    }

    protected boolean initialize() {
        InterfaceValueObject[] interfaceValueObjectArray;
        Object[] objectArray;
        this.removeEventListeners();
        this.m_jpMainPanel.setVisible(this.m_acController.getAppliance().isUserApplianceAdmin());
        try {
            objectArray = new Object[]{"avocent.ds.dsManagement.dsNtp.dsNtpControl.0", "avocent.ds.dsManagement.dsNtp.dsNtpUpdateInterval.0"};
            interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), objectArray);
            this.m_cbNtpEnabled.setSelected(interfaceValueObjectArray[0].getInteger().equals(ENABLED));
            this.m_jtfUpdate.setText(interfaceValueObjectArray[1].toString());
            this.logInfo("Setting values to " + interfaceValueObjectArray);
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            return false;
        }
        catch (Exception exception) {
            this.logError(exception.getMessage(), exception);
            return false;
        }
        try {
            objectArray = new Object[]{"avocent.ds.dsManagement.dsNtp.dsNtpServerTable.dsNtpServerTableEntry.dsNtpServerTableAddress"};
            interfaceValueObjectArray = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), objectArray);
            this.m_jtfPrimaryServer.setText(this.displayIPAddress(interfaceValueObjectArray[0][0].toString()));
            this.m_jtfSecondaryServer.setText(this.displayIPAddress(interfaceValueObjectArray[1][0].toString()));
            this.enablePanel(this.m_cbNtpEnabled.isSelected());
            this.addEventListeners();
            Trace.logInfo((String)"AVR AMP panel", (String)"initialize: Creating and starting data polling thread.");
            this.m_threadPollData = new ThreadPollData();
            this.m_threadPollData.start();
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            return false;
        }
        catch (Exception exception) {
            this.logError(exception.getMessage(), exception);
            return false;
        }
    }

    protected boolean applyValues() {
        block16: {
            List<Object> list = new ArrayList<String>();
            List<Object> list2 = new ArrayList<Integer>();
            try {
                if (!this.validateInputFields()) break block16;
                try {
                    if (this.m_cbNtpEnabled.isSelected()) {
                        list.add("avocent.ds.dsManagement.dsNtp.dsNtpControl.0");
                        list2.add(ENABLED);
                        list.add("avocent.ds.dsManagement.dsNtp.dsNtpUpdateInterval.0");
                        list2.add(Integer.valueOf(this.m_jtfUpdate.getText().trim()));
                    } else {
                        list.add("avocent.ds.dsManagement.dsNtp.dsNtpControl.0");
                        list2.add(DISABLED);
                    }
                    AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), list.toArray(), list2.toArray());
                    if (!this.m_cbNtpEnabled.isSelected()) {
                        Thread.currentThread();
                        Thread.sleep(500L);
                        this.updateStatus();
                        this.setIsModified(false);
                        return true;
                    }
                }
                catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
                    String string;
                    this.logError(exceptionSnmpRequestFailed.getMessage(), (Exception)((Object)exceptionSnmpRequestFailed));
                    this.m_nErrorStatus = exceptionSnmpRequestFailed.getErrorCode();
                    if (exceptionSnmpRequestFailed.getErrorIndex() == 2) {
                        this.m_szErrorLabel = this.m_jlUpdate.getText();
                        this.m_jtfUpdate.requestFocusInWindow();
                        Object[] objectArray = new String[]{this.m_szErrorLabel};
                        string = JPanelNTPSettings.getResourceString((ResourceManager)res, (String)"JPanelNTPSettings_NTP_Apply_Failed", (Object[])objectArray) + " " + exceptionSnmpRequestFailed.getMessage();
                    } else {
                        string = res.getString("JPanelNTPSettings_Generic_Apply_Failed");
                    }
                    Message.show((Component)((Object)this), (String)string);
                    return false;
                }
                String string = PRIMARY;
                try {
                    list = Arrays.asList("avocent.ds.dsManagement.dsNtp.dsNtpServerTable.dsNtpServerTableEntry.dsNtpServerTableAddress");
                    list2 = Arrays.asList(this.readIPAddress((JTextFieldAvocent)this.m_jtfPrimaryServer));
                    AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), list.toArray(), list2.toArray(), string);
                }
                catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
                    this.logError(exceptionSnmpRequestFailed.getMessage(), (Exception)((Object)exceptionSnmpRequestFailed));
                    this.m_nErrorStatus = exceptionSnmpRequestFailed.getErrorCode();
                    this.m_szErrorLabel = res.getString("JPanelNTPSettings_Primary");
                    this.m_jtfPrimaryServer.requestFocus();
                    Object[] objectArray = new String[]{this.m_szErrorLabel};
                    String string2 = JPanelNTPSettings.getResourceString((ResourceManager)res, (String)"JPanelNTPSettings_NTP_Apply_Failed", (Object[])objectArray);
                    Message.show((Component)((Object)this), (String)(string2 + " " + exceptionSnmpRequestFailed.getMessage()));
                    return false;
                }
                string = SECONDARY;
                try {
                    list2 = Arrays.asList(this.readIPAddress((JTextFieldAvocent)this.m_jtfSecondaryServer));
                    AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), list.toArray(), list2.toArray(), string);
                }
                catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
                    this.logError(exceptionSnmpRequestFailed.getMessage(), (Exception)((Object)exceptionSnmpRequestFailed));
                    this.m_nErrorStatus = exceptionSnmpRequestFailed.getErrorCode();
                    this.m_szErrorLabel = res.getString("JPanelNTPSettings_Secondary");
                    this.m_jtfSecondaryServer.requestFocus();
                    Object[] objectArray = new String[]{this.m_szErrorLabel};
                    String string3 = JPanelNTPSettings.getResourceString((ResourceManager)res, (String)"JPanelNTPSettings_NTP_Apply_Failed", (Object[])objectArray);
                    Message.show((Component)((Object)this), (String)(string3 + " " + exceptionSnmpRequestFailed.getMessage()));
                    return false;
                }
                Thread.currentThread();
                Thread.sleep(500L);
                this.updateStatus();
                this.setIsModified(false);
                return true;
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
                this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
                String string = res.getString("JPanelNTPSettings_NTP_Apply_Failed");
                Message.show((Component)((Object)this), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                this.logError(exceptionRequestFailed.getMessage(), (Exception)((Object)exceptionRequestFailed));
                Message.show((Component)((Object)this), (String)res.getString("JPanelNTPSettings_Req_Failed_internal"));
            }
            catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                this.logError(exceptionInvalidArgument.getMessage(), (Exception)((Object)exceptionInvalidArgument));
            }
            catch (Exception exception) {
                this.logError(exception.getMessage(), exception);
                Message.show((Component)((Object)this), (String)res.getString("JPanelNTPSettings_Req_Failed_internal"));
            }
        }
        return false;
    }

    private boolean validateInputFields() throws ExceptionInvalidArgument {
        if (this.m_cbNtpEnabled.isSelected()) {
            JPanelNTPSettings.validateInt((JTextField)this.m_jtfUpdate, (JLabel)this.m_jlUpdate, (int)0, (int)99);
            if (this.m_jtfPrimaryServer.isDataValid() && this.m_jtfSecondaryServer.isDataValid()) {
                if (this.readIPAddress((JTextFieldAvocent)this.m_jtfPrimaryServer).equals(this.readIPAddress((JTextFieldAvocent)this.m_jtfSecondaryServer))) {
                    this.m_jtfSecondaryServer.requestFocusInWindow();
                    Message.show((Component)((Object)this), (String)res.getString("JPanelNTPSettings_Duplicate_Value_Error"));
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private String readIPAddress(JTextFieldAvocent jTextFieldAvocent) {
        String string = jTextFieldAvocent.getText().trim();
        return string.length() > 0 ? string : "0.0.0.0";
    }

    private String displayIPAddress(String string) {
        return string.equals("0.0.0.0") ? "" : string;
    }

    private void addEventListeners() {
        this.m_docListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                JPanelNTPSettings.this.setIsModified(true);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                JPanelNTPSettings.this.setIsModified(true);
            }
        };
        this.m_keyListener = new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c != '\b' && (c < '0' || c > '9')) {
                    keyEvent.consume();
                } else {
                    JPanelNTPSettings.this.setIsModified(true);
                }
            }
        };
        this.m_itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JPanelNTPSettings.this.enablePanel(itemEvent.getStateChange() == 1);
                JPanelNTPSettings.this.setIsModified(true);
            }
        };
        this.m_jtfPrimaryServer.getDocument().addDocumentListener(this.m_docListener);
        this.m_jtfSecondaryServer.getDocument().addDocumentListener(this.m_docListener);
        this.m_jtfUpdate.addKeyListener(this.m_keyListener);
        this.m_cbNtpEnabled.addItemListener(this.m_itemListener);
    }

    private void enablePanel(boolean bl) {
        this.m_jlNtpServer.setEnabled(bl);
        this.m_jtfPrimaryServer.setEnabled(bl);
        this.m_jtfSecondaryServer.setEnabled(bl);
        this.m_jlUpdate.setEnabled(bl);
        this.m_jtfUpdate.setEnabled(bl);
        this.m_jlPrimaryStatus.setEnabled(bl);
        this.m_jlSecondaryStatus.setEnabled(bl);
    }

    private void removeEventListeners() {
        if (this.m_docListener != null) {
            this.m_jtfPrimaryServer.getDocument().removeDocumentListener(this.m_docListener);
            this.m_jtfSecondaryServer.getDocument().removeDocumentListener(this.m_docListener);
            this.m_docListener = null;
        }
        if (this.m_keyListener != null) {
            this.m_jtfUpdate.removeKeyListener(this.m_keyListener);
            this.m_keyListener = null;
        }
        if (this.m_itemListener != null) {
            this.m_cbNtpEnabled.removeItemListener(this.m_itemListener);
            this.m_itemListener = null;
        }
    }

    private void setErrorFieldFocus(Object[] objectArray, int n) {
        if (n > -1 && n < objectArray.length) {
            if (objectArray[n].equals("avocent.ds.dsManagement.dsNtp.dsNtpUpdateInterval.0")) {
                this.m_szErrorLabel = this.m_jlUpdate.getText();
                this.m_jtfUpdate.requestFocusInWindow();
            } else {
                this.m_szErrorLabel = null;
                this.logError("Unknown error index=" + n);
            }
            this.m_szErrorLabel = JPanelNTPSettings.removeColon((String)this.m_szErrorLabel);
        }
    }

    private void updateStatus() {
        block4: {
            try {
                Object[] objectArray = new Object[]{"avocent.ds.dsManagement.dsNtp.dsNtpServerTable.dsNtpServerTableEntry.dsNtpServerTableStatus", "avocent.ds.dsManagement.dsNtp.dsNtpServerTable.dsNtpServerTableEntry.dsNtpServerTableError"};
                InterfaceValueObject[][] interfaceValueObjectArray = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), objectArray);
                this.logInfo("Primary Status is " + interfaceValueObjectArray[0][0] + ":" + interfaceValueObjectArray[0][1]);
                this.logInfo("Secondary Status is " + interfaceValueObjectArray[1][0] + ":" + interfaceValueObjectArray[1][1]);
                if (this.m_jtfSecondaryServer.getText().equalsIgnoreCase("")) {
                    interfaceValueObjectArray[1][0].setValue((Object)new NameValue("", (Object)this.NTP_NOT_ATTEMPTED));
                }
                this.setStatusField(this.m_jlPrimaryStatus, interfaceValueObjectArray[0]);
                this.setStatusField(this.m_jlSecondaryStatus, interfaceValueObjectArray[1]);
                this.m_bNoRecentErrors = true;
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
                this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            }
            catch (Exception exception) {
                if (!this.m_bNoRecentErrors) break block4;
                this.m_bNoRecentErrors = false;
                Trace.logError((String)this.getTraceContext(), (String)exception.getMessage(), (Throwable)exception);
                String string = res.getString("JPanelNTPSettings_Unable_to_update_ntp_status") + " " + exception.getMessage();
                this.m_acController.showException(null, null, null, (Throwable)new ExceptionRequestFailed(string, (Throwable)exception));
            }
        }
    }

    private void setStatusField(final JLabel jLabel, InterfaceValueObject[] interfaceValueObjectArray) throws Exception {
        Integer n = interfaceValueObjectArray[0].getInteger();
        final String string = interfaceValueObjectArray[0].toString();
        final String string2 = n.equals(this.NTP_FAILED) ? ": " + interfaceValueObjectArray[1].toString() : "";
        Runnable runnable = new Runnable(){

            public void run() {
                jLabel.setText(string + string2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    class ThreadPollData
    extends ThreadContinuous {
        private static final int POLL_INTERVAL = 15;
        private boolean m_bThreadSuspended;
        private Map m_mStatus;
        private Map m_mError;

        ThreadPollData() {
            super("CCM NTP Poll", 15000L);
            this.m_bThreadSuspended = false;
            this.m_mStatus = new HashMap();
            this.m_mError = new HashMap();
        }

        protected void performTask() {
            if (!this.m_bThreadSuspended) {
                JPanelNTPSettings.this.updateStatus();
            }
        }

        public void suspendThread() {
            Trace.logInfo((String)"AVR AMP panel", (String)"ThreadPollData: thread suspended.");
            this.m_bThreadSuspended = true;
        }

        public void resumeThread() {
            Trace.logInfo((String)"AVR AMP panel", (String)"ThreadPollData: thread resumed.");
            this.m_bThreadSuspended = false;
        }
    }
}

