/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AmpControllerAvr;
import com.avocent.avworks.nmm.avr.AvrAsmpHelper;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksEventBroadcaster;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.gui.components.JComboBoxAvocent;
import com.avocent.lib.gui.components.JTextFieldAvocent;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.renderers.NameValue;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JPanelNetworkSettings
extends JPanelAmpPanel {
    public static final String CNAME = "JPanelNetworkSettings";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    public static final int NUM_SERVERS = 3;
    private static final Integer BOOTP_DISABLED_VAL = new Integer(1);
    private LanSpeedItemListener m_lanSpeedItemListener = null;
    private BootpItemListener m_bootpItemListener = null;
    private boolean m_bDNSSupport = false;
    private AmpControllerAvr m_acController;
    private int m_bootMethod;
    private boolean m_bIsApplianceAdmin;
    public static final int DHCP = 2;
    public static final int BOOTP = 3;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout m_gridBagLayout2 = new GridBagLayout();
    JPanel m_jpMainPanel = new JPanel();
    JLabel m_jlIpAddress = new JLabel();
    JTextFieldAvocent m_jtfIpAddress = new JTextFieldAvocent();
    JLabel m_jlSubnetMask = new JLabel();
    JTextFieldAvocent m_jtfSubnetMask = new JTextFieldAvocent();
    JLabel m_jlGateway = new JLabel();
    JTextFieldAvocent m_jtfGateway = new JTextFieldAvocent();
    JLabel m_jlMacAddress = new JLabel();
    JTextFieldAvocent m_jtfMacAddress = new JTextFieldAvocent();
    JLabel m_jlLanSpeed = new JLabel();
    JComboBoxAvocent m_jcbLanSpeed = new JComboBoxAvocent();
    JLabel m_jlBootp = new JLabel();
    JComboBoxAvocent m_jcbBootp = new JComboBoxAvocent();
    JLabel m_jLabelFiller = new JLabel();
    JLabel m_jlApplName = new JLabel();
    JTextFieldAvocent m_jtfApplName = new JTextFieldAvocent();
    JLabel m_jlDNS = new JLabel();
    JTextFieldAvocent[] m_ajtfDNSServer = new JTextFieldAvocent[3];
    JPanel m_jpDNSPanel = new JPanel();
    private DocumentListener docListener = null;
    private DNSListener[] dnsListener = new DNSListener[3];

    public JPanelNetworkSettings(AmpControllerAvr ampControllerAvr) throws ExceptionConstructorFailed {
        super((AmpController)ampControllerAvr, res.getString("JPanelNetworkSettings_Network"), res.getString("JPanelNetworkSettings_Global") + " - " + res.getString("JPanelNetworkSettings_Network"), res.getString("JPanelNetworkSettings_Specify_network"), "IDH_SETTINGS_TAB_GLOBAL_NETWORK");
        this.m_jpMainPanel.setVisible(false);
        this.m_acController = ampControllerAvr;
        this.m_bIsApplianceAdmin = this.m_acController.getAppliance().isUserApplianceAdmin();
        for (int i = 0; i < 3; ++i) {
            this.m_ajtfDNSServer[i] = new JTextFieldAvocent();
        }
        try {
            int n;
            AvrSnmpHelper avrSnmpHelper = AvrSnmpHelper.getInstance();
            NameValue[] nameValueArray = avrSnmpHelper.getMibEnumPairs("avocent.ds.dsManagement.dsServer.dsLanSpeed.0");
            for (n = 0; n < nameValueArray.length; ++n) {
                this.m_jcbLanSpeed.addItem((Object)nameValueArray[n]);
            }
            nameValueArray = avrSnmpHelper.getMibEnumPairs("avocent.ds.dsManagement.dsServer.dsBootpControl.0");
            for (n = 0; n < nameValueArray.length; ++n) {
                this.m_jcbBootp.addItem((Object)nameValueArray[n]);
            }
            this.jbInit();
            this.m_acController.getAppliance().addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (JPanelNetworkSettings.this.m_nState != 101) {
                        if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("SNMP_SYS_NAME")) {
                            JPanelNetworkSettings.this.m_jtfApplName.setText(propertyChangeEvent.getNewValue().toString());
                        }
                        if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("LDAP_AUTH_LICENSED")) {
                            JPanelNetworkSettings.this.m_nState = 101;
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            this.logError("Constructor failed with exception: " + exception.getMessage(), exception);
            throw new ExceptionConstructorFailed(exception.getMessage());
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.m_jpMainPanel.setLayout(this.m_gridBagLayout2);
        this.m_jlIpAddress.setText(res.getString("JPanelNetworkSettings_IP_Address_"));
        this.m_jlSubnetMask.setText(res.getString("JPanelNetworkSettings_Subnet_Mask_"));
        this.m_jlGateway.setText(res.getString("JPanelNetworkSettings_Gateway_"));
        this.m_jlMacAddress.setText(res.getString("JPanelNetworkSettings_MAC_Address_"));
        this.m_jtfMacAddress.setEditable(false);
        this.m_jlLanSpeed.setText(res.getString("JPanelNetworkSettings_LAN_Speed_"));
        this.m_jlBootp.setText(res.getString("JPanelNetworkSettings_Bootp_"));
        this.m_jlApplName.setText(res.getString("JPanelNetworkSettings_Name_"));
        this.m_jtfApplName.setEditable(false);
        this.m_jlDNS.setText(res.getString("JPanelNetworkSettings_DNSServers_"));
        this.m_jtfIpAddress.setColumns(10);
        this.m_jtfSubnetMask.setColumns(10);
        this.m_jtfGateway.setColumns(10);
        this.m_jtfIpAddress.setEditable(this.m_bIsApplianceAdmin);
        this.m_jtfSubnetMask.setEditable(this.m_bIsApplianceAdmin);
        this.m_jtfGateway.setEditable(this.m_bIsApplianceAdmin);
        this.m_jcbLanSpeed.setEnabled(this.m_bIsApplianceAdmin);
        this.m_jcbBootp.setEnabled(this.m_bIsApplianceAdmin);
        this.m_jtfIpAddress.setMinimumSize(this.m_jtfIpAddress.getPreferredSize());
        this.m_jtfSubnetMask.setMinimumSize(this.m_jtfSubnetMask.getPreferredSize());
        this.m_jtfGateway.setMinimumSize(this.m_jtfGateway.getPreferredSize());
        BoxLayout boxLayout = new BoxLayout(this.m_jpDNSPanel, 1);
        this.m_jpDNSPanel.setLayout(boxLayout);
        for (int i = 0; i < 3; ++i) {
            this.m_jpDNSPanel.add((Component)this.m_ajtfDNSServer[i]);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 5), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 5, 5), 0, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints(-1, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 5), 0, 0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints(-1, -1, 1, 2, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 5), 0, 0);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints(-1, -1, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 5, 5), 0, 0);
        this.m_jpMainPanel.add((Component)this.m_jlApplName, gridBagConstraints);
        this.m_jpMainPanel.add((Component)this.m_jtfApplName, gridBagConstraints5);
        this.m_jpMainPanel.add((Component)this.m_jlIpAddress, gridBagConstraints);
        this.m_jpMainPanel.add((Component)this.m_jtfIpAddress, gridBagConstraints3);
        this.m_jpMainPanel.add((Component)this.m_jlMacAddress, gridBagConstraints);
        this.m_jpMainPanel.add((Component)this.m_jtfMacAddress, gridBagConstraints5);
        this.m_jpMainPanel.add((Component)this.m_jlSubnetMask, gridBagConstraints);
        this.m_jpMainPanel.add((Component)this.m_jtfSubnetMask, gridBagConstraints3);
        this.m_jpMainPanel.add((Component)this.m_jlLanSpeed, gridBagConstraints);
        this.m_jpMainPanel.add((Component)this.m_jcbLanSpeed, gridBagConstraints5);
        this.m_jpMainPanel.add((Component)this.m_jlGateway, gridBagConstraints);
        this.m_jpMainPanel.add((Component)this.m_jtfGateway, gridBagConstraints3);
        this.m_jpMainPanel.add((Component)this.m_jlBootp, gridBagConstraints);
        this.m_jpMainPanel.add((Component)this.m_jcbBootp, gridBagConstraints5);
        this.m_jpMainPanel.add((Component)this.m_jlDNS, gridBagConstraints2);
        this.m_jpMainPanel.add((Component)this.m_jpDNSPanel, gridBagConstraints4);
        this.add(this.m_jpMainPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_jLabelFiller, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean onKillActive() {
        this.logInfo("onKillActive() was called.");
        if (this.m_nState == 103) {
            try {
                this.validateInputFields();
                return false;
            }
            catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                Message.show((Component)this.m_acController.getMainFrame(), (String)exceptionInvalidArgument.getMessage());
                return true;
            }
            catch (Exception exception) {
                this.m_acController.showException(null, this.getTraceContext(), "", exception);
                return true;
            }
        }
        return false;
    }

    protected boolean initialize() {
        this.m_jpMainPanel.setVisible(true);
        try {
            String string;
            int n;
            Object object;
            Object object2;
            Object[] objectArray;
            Serializable serializable;
            Appliance appliance = this.m_acController.getAppliance();
            this.m_bootMethod = !appliance.hasMinMibVersion(2, 0) || AVWorksBranding.getBoolean((String)"AVR_BOOTP_ONLY", (boolean)true) ? 3 : 2;
            this.removeEventListeners();
            this.m_bDNSSupport = this.m_acController.isFeatureSupported("ConfigureDNSServers");
            if (this.m_bDNSSupport && this.m_acController.getAppliance().isUserApplianceAdmin()) {
                serializable = (Boolean)this.m_acController.getAppliance().getValue((Object)"LDAP_AUTH_LICENSED");
                if (serializable == null && this.m_acController.isFeatureSupported("LDAPAuthenticationSupport")) {
                    Trace.logInfo((String)"AVR AMP panel", (String)"Getting ldap license option");
                    objectArray = new Object[]{"avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsTable.dsLicensedOptionsTableEntry.dsLicensedOptionsTableIndex", "avocent.ds.dsManagement.dsLicensedOptions.dsLicensedOptionsTable.dsLicensedOptionsTableEntry.dsLicensedOptionsTableStatus"};
                    object2 = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), objectArray);
                    Trace.logInfo((String)"AVR AMP panel", (String)("Retrieved Licensed Options, number of options = " + ((InterfaceValueObject[][])object2).length));
                    Integer n2 = new Integer(1);
                    int n3 = n2;
                    for (int i = 0; i < ((InterfaceValueObject[][])object2).length; ++i) {
                        object = (Integer)object2[i][0].getValue();
                        n = (Integer)object;
                        if (n != n3) continue;
                        Integer n4 = (Integer)object2[i][1].getValue();
                        int n5 = n4;
                        if (n5 == 2) {
                            serializable = new Boolean(true);
                            this.m_acController.getAppliance().setValue((Object)"LDAP_AUTH_LICENSED", (Object)new Boolean(true));
                            continue;
                        }
                        serializable = new Boolean(false);
                        this.m_acController.getAppliance().setValue((Object)"LDAP_AUTH_LICENSED", (Object)new Boolean(false));
                    }
                }
                if (serializable == null || !((Boolean)serializable).booleanValue()) {
                    this.m_bDNSSupport = false;
                }
            } else {
                this.m_bDNSSupport = false;
            }
            this.m_jlDNS.setVisible(this.m_bDNSSupport);
            this.m_jpDNSPanel.setVisible(this.m_bDNSSupport);
            this.m_jlBootp.setText(res.getString(CNAME + (this.m_bootMethod == 3 ? "_Bootp_" : "_Dhcp_")));
            if (!appliance.hasMinMibVersion(2, 0)) {
                serializable = AvrSnmpHelper.getInstance();
                objectArray = serializable.getMibEnumPairs("avocent.ds.dsManagement.dsServer.dsLanSpeed.0");
                object2 = res.getString("MibEnumAvocentAvr_ENUM_1_Gbps_full_duplex");
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i].getName() != object2) continue;
                    this.m_jcbLanSpeed.removeItem(objectArray[i]);
                }
            }
            serializable = new ArrayList<String>(10);
            serializable.add("mib-2.system.sysName.0");
            serializable.add("avocent.ds.dsManagement.dsServer.dsLanIPAddress.0");
            serializable.add("avocent.ds.dsManagement.dsServer.dsLanSubnetMask.0");
            serializable.add("avocent.ds.dsManagement.dsServer.dsLanGateway.0");
            serializable.add("avocent.ds.dsManagement.dsServer.dsLanSpeed.0");
            if (this.m_bootMethod == 3) {
                serializable.add("avocent.ds.dsManagement.dsServer.dsBootpControl.0");
            } else {
                serializable.add("avocent.ds.dsManagement.dsServer.dsDhcpControl.0");
            }
            int n6 = 0;
            int n7 = -1;
            if (this.m_bDNSSupport) {
                serializable.add("avocent.ds.dsManagement.dsDns.dsDnsServerTable.dsDnsServerTableEntry.dsDnsServerTableAddress.1");
                serializable.add("avocent.ds.dsManagement.dsDns.dsDnsServerTable.dsDnsServerTableEntry.dsDnsServerTableAddress.2");
                serializable.add("avocent.ds.dsManagement.dsDns.dsDnsServerTable.dsDnsServerTableEntry.dsDnsServerTableAddress.3");
                n7 = 6 + n6;
                n6 += 3;
            }
            Object[] objectArray2 = serializable.toArray();
            InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), objectArray2);
            object = this.m_acController.getAppliance().getAmpValue((Object)"SNMP_SYS_NAME");
            this.m_jtfApplName.setText(object == null ? interfaceValueObjectArray[0].toString() : object.toString());
            this.m_jtfIpAddress.setText(interfaceValueObjectArray[1].toString());
            this.m_jtfSubnetMask.setText(interfaceValueObjectArray[2].toString());
            this.m_jtfGateway.setText(interfaceValueObjectArray[3].toString());
            this.m_jcbLanSpeed.setSelectedItem(interfaceValueObjectArray[4].getValue());
            this.m_jcbBootp.setSelectedItem(interfaceValueObjectArray[5].getValue());
            if (this.m_bDNSSupport) {
                int n8;
                n = 0;
                for (n8 = 0; n8 < 3; ++n8) {
                    String string2 = interfaceValueObjectArray[n7 + n8].toString();
                    if (string2.trim().equals("0.0.0.0")) continue;
                    this.m_ajtfDNSServer[n++].setText(string2);
                }
                for (n8 = n; n8 < 3; ++n8) {
                    this.m_ajtfDNSServer[n8].setText("");
                }
            }
            if ((string = AvrAsmpHelper.getMacAddress(this.m_acController.getAsmpConnection())) == null) {
                throw new Exception("Failed to get MAC Address--ethernet interface not found.");
            }
            this.m_jtfMacAddress.setText(string);
            this.m_acController.getAppliance().setValue((Object)"SNMP_SYS_NAME", (Object)interfaceValueObjectArray[0].toString());
            this.setFieldAccess();
            this.addEventListeners();
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            return false;
        }
        catch (Exception exception) {
            this.logError(exception.getMessage(), exception);
            return false;
        }
    }

    protected boolean applyValues() {
        Object[] objectArray;
        boolean bl = this.isBootpDisabled();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_bootMethod == 3) {
            arrayList.add("avocent.ds.dsManagement.dsServer.dsBootpControl.0");
        } else {
            arrayList.add("avocent.ds.dsManagement.dsServer.dsDhcpControl.0");
        }
        try {
            this.validateInputFields();
            if (bl) {
                objectArray = new Object[]{BOOTP_DISABLED_VAL};
                AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), arrayList.toArray(), objectArray);
            }
        }
        catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
            this.m_nErrorStatus = exceptionSnmpRequestFailed.getErrorCode();
            this.logError(exceptionSnmpRequestFailed.getMessage(), (Exception)((Object)exceptionSnmpRequestFailed));
            this.m_szErrorLabel = null;
            this.setErrorFieldFocus(arrayList.toArray(), exceptionSnmpRequestFailed.getErrorIndex() - 1);
            String string = "";
            if (this.m_szErrorLabel != null) {
                Object[] objectArray2 = new String[]{this.m_szErrorLabel};
                string = JPanelNetworkSettings.getResourceString((ResourceManager)res, (String)"JPanelNetworkSettings_Apply_Failed", (Object[])objectArray2);
            } else {
                string = res.getString("JPanelNetworkSettings_Network_Apply_Failed");
            }
            Message.show((Component)this.m_acController.getMainFrame(), (String)(string + " " + exceptionSnmpRequestFailed.getMessage()));
            return false;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            String string = res.getString("JPanelNetworkSettings_Network_Apply_Failed");
            Message.show((Component)this.m_acController.getMainFrame(), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
            return false;
        }
        catch (Exception exception) {
            Message.show((Component)this.m_acController.getMainFrame(), (String)exception.getMessage());
            return false;
        }
        objectArray = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        try {
            if (bl) {
                objectArray.add("avocent.ds.dsManagement.dsServer.dsLanIPAddress.0");
                arrayList2.add(this.m_jtfIpAddress.getText());
                objectArray.add("avocent.ds.dsManagement.dsServer.dsLanSubnetMask.0");
                arrayList2.add(this.m_jtfSubnetMask.getText());
                objectArray.add("avocent.ds.dsManagement.dsServer.dsLanGateway.0");
                arrayList2.add(this.m_jtfGateway.getText());
                objectArray.add("avocent.ds.dsManagement.dsServer.dsLanSpeed.0");
                arrayList2.add(this.m_jcbLanSpeed.getSelectedItem());
                if (this.m_bDNSSupport) {
                    objectArray.add("avocent.ds.dsManagement.dsDns.dsDnsServerTable.dsDnsServerTableEntry.dsDnsServerTableAddress.1");
                    if (this.m_ajtfDNSServer[0].getText().length() != 0) {
                        arrayList2.add(this.m_ajtfDNSServer[0].getText());
                    } else {
                        arrayList2.add("0.0.0.0");
                    }
                    objectArray.add("avocent.ds.dsManagement.dsDns.dsDnsServerTable.dsDnsServerTableEntry.dsDnsServerTableAddress.2");
                    if (this.m_ajtfDNSServer[1].getText().length() != 0) {
                        arrayList2.add(this.m_ajtfDNSServer[1].getText());
                    } else {
                        arrayList2.add("0.0.0.0");
                    }
                    objectArray.add("avocent.ds.dsManagement.dsDns.dsDnsServerTable.dsDnsServerTableEntry.dsDnsServerTableAddress.3");
                    if (this.m_ajtfDNSServer[2].getText().length() != 0) {
                        arrayList2.add(this.m_ajtfDNSServer[2].getText());
                    } else {
                        arrayList2.add("0.0.0.0");
                    }
                }
            } else {
                objectArray.add("avocent.ds.dsManagement.dsServer.dsLanSpeed.0");
                arrayList2.add(this.m_jcbLanSpeed.getSelectedItem());
                if (this.m_bootMethod == 3) {
                    objectArray.add("avocent.ds.dsManagement.dsServer.dsBootpControl.0");
                } else {
                    objectArray.add("avocent.ds.dsManagement.dsServer.dsDhcpControl.0");
                }
                arrayList2.add(this.m_jcbBootp.getSelectedItem());
            }
            AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), objectArray.toArray(), arrayList2.toArray());
            int n = this.m_acController.getApplianceInfo().getID();
            AppliancesDb.setIPAddress((int)n, (String)this.m_jtfIpAddress.getText());
            UnitInfo[] unitInfoArray = new UnitInfo[]{AppliancesDb.getApplianceInfo((int)n)};
            AVWorksEventBroadcaster.fireDatabaseAppliancesModifiedEvent((UnitInfo[])unitInfoArray);
            this.setReloadData();
            return true;
        }
        catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
            this.m_nErrorStatus = exceptionSnmpRequestFailed.getErrorCode();
            this.logError(exceptionSnmpRequestFailed.getMessage(), (Exception)((Object)exceptionSnmpRequestFailed));
            this.m_szErrorLabel = null;
            this.setErrorFieldFocus(objectArray.toArray(), exceptionSnmpRequestFailed.getErrorIndex() - 1);
            String string = "";
            if (this.m_szErrorLabel != null) {
                Object[] objectArray3 = new String[]{this.m_szErrorLabel};
                string = JPanelNetworkSettings.getResourceString((ResourceManager)res, (String)"JPanelNetworkSettings_Apply_Failed", (Object[])objectArray3);
            } else {
                string = res.getString("JPanelNetworkSettings_Network_Apply_Failed");
            }
            Message.show((Component)this.m_acController.getMainFrame(), (String)(string + " " + exceptionSnmpRequestFailed.getMessage()));
            return false;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            String string = res.getString("JPanelNetworkSettings_Network_Apply_Failed");
            Message.show((Component)this.m_acController.getMainFrame(), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
            return false;
        }
        catch (Exception exception) {
            Message.show((Component)this.m_acController.getMainFrame(), (String)exception.getMessage());
            return false;
        }
    }

    private void validateInputFields() throws ExceptionInvalidArgument {
        if (this.isBootpDisabled()) {
            JPanelNetworkSettings.validateIpAddress((JTextField)this.m_jtfIpAddress, (JLabel)this.m_jlIpAddress);
            JPanelNetworkSettings.validateIpAddress((JTextField)this.m_jtfSubnetMask, (JLabel)this.m_jlSubnetMask);
            JPanelNetworkSettings.validateIpAddress((JTextField)this.m_jtfGateway, (JLabel)this.m_jlGateway, (boolean)true);
            if (this.m_bDNSSupport) {
                for (int i = 0; i < 3; ++i) {
                    if (this.m_ajtfDNSServer[i].getText().trim().length() <= 0) continue;
                    JPanelNetworkSettings.validateIpAddress((JTextField)this.m_ajtfDNSServer[i], (JLabel)this.m_jlDNS, (boolean)true);
                    for (int j = i - 1; j >= 0; --j) {
                        if (!this.m_ajtfDNSServer[i].getText().equals(this.m_ajtfDNSServer[j].getText())) continue;
                        this.m_ajtfDNSServer[i].requestFocus();
                        String string = res.getString("JPanelNetworkSettings_DupDNS");
                        throw new ExceptionInvalidArgument(string);
                    }
                }
            }
        }
    }

    private void setFieldAccess() {
        boolean bl = this.isBootpDisabled();
        this.m_jtfIpAddress.setEditable(bl & this.m_bIsApplianceAdmin);
        this.m_jtfSubnetMask.setEditable(bl & this.m_bIsApplianceAdmin);
        this.m_jtfGateway.setEditable(bl & this.m_bIsApplianceAdmin);
        if (this.m_bDNSSupport) {
            for (int i = 0; i < 3; ++i) {
                this.m_ajtfDNSServer[i].setEditable(bl);
            }
        }
    }

    private boolean isBootpDisabled() {
        NameValue nameValue = (NameValue)this.m_jcbBootp.getSelectedItem();
        Integer n = (Integer)nameValue.getValue();
        return n.equals(BOOTP_DISABLED_VAL);
    }

    private void addEventListeners() {
        this.docListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                JPanelNetworkSettings.this.setIsModified(true);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                JPanelNetworkSettings.this.setIsModified(true);
            }
        };
        this.m_jtfIpAddress.getDocument().addDocumentListener(this.docListener);
        this.m_jtfSubnetMask.getDocument().addDocumentListener(this.docListener);
        this.m_jtfGateway.getDocument().addDocumentListener(this.docListener);
        if (this.m_bDNSSupport) {
            for (int i = 0; i < 3; ++i) {
                this.dnsListener[i] = new DNSListener(i);
                this.m_ajtfDNSServer[i].getDocument().addDocumentListener(this.dnsListener[i]);
            }
        }
        this.m_lanSpeedItemListener = new LanSpeedItemListener();
        this.m_jcbLanSpeed.addItemListener((ItemListener)this.m_lanSpeedItemListener);
        this.m_bootpItemListener = new BootpItemListener();
        this.m_jcbBootp.addItemListener((ItemListener)this.m_bootpItemListener);
    }

    private void removeEventListeners() {
        this.logInfo("removeEventListeners() was called.");
        if (this.m_lanSpeedItemListener != null) {
            this.m_jcbLanSpeed.removeItemListener((ItemListener)this.m_lanSpeedItemListener);
            this.m_lanSpeedItemListener = null;
        }
        if (this.m_bootpItemListener != null) {
            this.m_jcbBootp.removeItemListener((ItemListener)this.m_bootpItemListener);
            this.m_bootpItemListener = null;
        }
        if (this.docListener != null) {
            this.m_jtfIpAddress.getDocument().removeDocumentListener(this.docListener);
            this.m_jtfSubnetMask.getDocument().removeDocumentListener(this.docListener);
            this.m_jtfGateway.getDocument().removeDocumentListener(this.docListener);
            this.docListener = null;
            if (this.m_bDNSSupport) {
                for (int i = 0; i < 3; ++i) {
                    this.m_ajtfDNSServer[i].getDocument().removeDocumentListener(this.dnsListener[i]);
                    this.dnsListener[i] = null;
                }
            }
        }
    }

    private void setErrorFieldFocus(Object[] objectArray, int n) {
        if (n > -1 && n < objectArray.length) {
            if (objectArray[n].equals("avocent.ds.dsManagement.dsServer.dsLanIPAddress.0")) {
                this.m_szErrorLabel = this.m_jlIpAddress.getText();
                this.m_jtfIpAddress.requestFocus();
            } else if (objectArray[n].equals("avocent.ds.dsManagement.dsServer.dsLanSubnetMask.0")) {
                this.m_szErrorLabel = this.m_jlSubnetMask.getText();
                this.m_jtfSubnetMask.requestFocus();
            } else if (objectArray[n].equals("avocent.ds.dsManagement.dsServer.dsLanGateway.0")) {
                this.m_szErrorLabel = this.m_jlGateway.getText();
                this.m_jtfGateway.requestFocus();
            } else if (objectArray[n].equals("avocent.ds.dsManagement.dsServer.dsLanSpeed.0")) {
                this.m_szErrorLabel = this.m_jlLanSpeed.getText();
                this.m_jcbLanSpeed.requestFocus();
            } else if (objectArray[n].equals("avocent.ds.dsManagement.dsServer.dsBootpControl.0")) {
                this.m_szErrorLabel = this.m_jlBootp.getText();
                this.m_jcbBootp.requestFocus();
            } else if (objectArray[n].equals("avocent.ds.dsManagement.dsServer.dsDhcpControl.0")) {
                this.m_szErrorLabel = this.m_jlBootp.getText();
                this.m_jcbBootp.requestFocus();
            } else if (objectArray[n].equals("avocent.ds.dsManagement.dsDns.dsDnsServerTable.dsDnsServerTableEntry.dsDnsServerTableAddress.1")) {
                this.m_szErrorLabel = this.m_jlDNS.getText();
                this.m_ajtfDNSServer[0].requestFocus();
            } else if (objectArray[n].equals("avocent.ds.dsManagement.dsDns.dsDnsServerTable.dsDnsServerTableEntry.dsDnsServerTableAddress.2")) {
                this.m_szErrorLabel = this.m_jlDNS.getText();
                this.m_ajtfDNSServer[1].requestFocus();
            } else if (objectArray[n].equals("avocent.ds.dsManagement.dsDns.dsDnsServerTable.dsDnsServerTableEntry.dsDnsServerTableAddress.3")) {
                this.m_szErrorLabel = this.m_jlDNS.getText();
                this.m_ajtfDNSServer[2].requestFocus();
            } else {
                this.m_szErrorLabel = null;
                this.logError("Unknown error index=" + n);
            }
            this.m_szErrorLabel = JPanelNetworkSettings.removeColon((String)this.m_szErrorLabel);
        }
    }

    private class DNSListener
    implements DocumentListener {
        private int index;

        public DNSListener(int n) {
            this.index = n;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            JPanelNetworkSettings.this.setIsModified(true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            JPanelNetworkSettings.this.setIsModified(true);
        }
    }

    class BootpItemListener
    implements ItemListener {
        BootpItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JPanelNetworkSettings.this.setFieldAccess();
            JPanelNetworkSettings.this.setIsModified(true);
        }
    }

    class LanSpeedItemListener
    implements ItemListener {
        LanSpeedItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JPanelNetworkSettings.this.setIsModified(true);
        }
    }
}

