/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AbstractTableModelExistingSwitches;
import com.avocent.avworks.nmm.avr.AvrDatabaseHelper;
import com.avocent.avworks.nmm.avr.AvrRipInfo;
import com.avocent.avworks.nmm.avr.AvrServerInfo;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.components.JTableAvocent;
import com.avocent.lib.gui.components.JWrappingLabel;
import com.avocent.lib.gui.renderers.TableCellRendererNoFocus;
import com.avocent.lib.gui.wizards.InterfaceWizardPanel;
import com.avocent.lib.gui.wizards.JDialogWizard;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class JPanelResyncWizardDetectedChanges
extends JPanel
implements InterfaceWizardPanel {
    public static final String CNAME = "JPanelResyncWizardDetectedChanges";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    private static final int INITIAL_SORT_COLUMN_NUM = 0;
    private static final int AVCT_STD_TABLE_FEATURE_LEVEL = 1;
    private JDialogWizard m_dialogWizard = null;
    private int m_nID = -1;
    private String m_szTitle = "";
    private boolean m_bSwitchDetected = false;
    JWrappingLabel jWrappingLabel1 = new JWrappingLabel();
    JTableAvocent jTableDetectedChanges = new JTableAvocent();
    JScrollPane jScrollPaneDetectedChanges = new JScrollPane();
    JWrappingLabel jWrappingLabel2 = new JWrappingLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    TableCellRendererNoFocus m_cellRendererNoFocus = new TableCellRendererNoFocus();

    public JPanelResyncWizardDetectedChanges(JDialogWizard jDialogWizard, int n, String string) throws ExceptionConstructorFailed {
        this.m_dialogWizard = jDialogWizard;
        this.m_nID = n;
        this.m_szTitle = string;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)"Wizard", (String)"Unable to initialize panel");
            throw new ExceptionConstructorFailed();
        }
        this.onInit();
        this.m_dialogWizard.pack();
    }

    void jbInit() throws Exception {
        this.jWrappingLabel1.setText(res.getString("JPanelResyncWizardDetectedChanges_The_following_changes"));
        this.setLayout(this.gridBagLayout1);
        this.jScrollPaneDetectedChanges.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.jScrollPaneDetectedChanges.setPreferredSize(new Dimension(200, 120));
        this.jWrappingLabel2.setText(res.getString("JPanelResyncWizardDetectedChanges_To_update_the"));
        this.jTableDetectedChanges.setBackground(UIManager.getColor("Table.background"));
        this.add((Component)this.jWrappingLabel1, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jWrappingLabel2, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 18, 2, new Insets(12, 0, 50, 0), 0, 0));
        this.add((Component)this.jScrollPaneDetectedChanges, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPaneDetectedChanges.getViewport().add((Component)this.jTableDetectedChanges, null);
    }

    public String getTitle() {
        return this.m_szTitle;
    }

    public int getID() {
        return this.m_nID;
    }

    public void onInit() {
        this.jTableDetectedChanges.setRowSelectionAllowed(false);
        this.jTableDetectedChanges.getTableHeader().setReorderingAllowed(false);
        this.jTableDetectedChanges.setShowGrid(false);
    }

    public void onSetActive() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object object;
                String[] stringArray;
                JPanelResyncWizardDetectedChanges.this.m_dialogWizard.setWizardButtons(11);
                JPanelResyncWizardDetectedChanges.this.m_dialogWizard.setDefaultButton(2);
                if (JPanelResyncWizardDetectedChanges.this.wasSwitchDetected()) {
                    stringArray = AVWorksBranding.getCascadeSwitchName((boolean)false);
                    object = new Object[]{stringArray};
                    JPanelResyncWizardDetectedChanges.this.jWrappingLabel2.setText(MessageFormat.format(res.getString("JPanelResyncWizardDetectedChanges_To_configure_0_click"), (Object[])object));
                }
                stringArray = (String[])JPanelResyncWizardDetectedChanges.this.m_dialogWizard.getValue((Object)"Changes");
                JPanelResyncWizardDetectedChanges.this.jTableDetectedChanges.setModel((TableModel)new AbstractTableModelChanges(stringArray));
                object = JPanelResyncWizardDetectedChanges.this.jTableDetectedChanges.getColumnModel();
                for (int i = 0; i < object.getColumnCount(); ++i) {
                    object.getColumn(i).setCellRenderer((TableCellRenderer)JPanelResyncWizardDetectedChanges.this.m_cellRendererNoFocus);
                }
                JPanelResyncWizardDetectedChanges.this.jTableDetectedChanges.setAvctStdTableFeatures(1);
                JPanelResyncWizardDetectedChanges.this.jTableDetectedChanges.enableAvctStdTableFeatures();
                JPanelResyncWizardDetectedChanges.this.jTableDetectedChanges.sortTableData(0);
            }
        });
    }

    public int onNext() {
        if (this.wasSwitchDetected()) {
            return 5;
        }
        String string = AVWorksBranding.getApplianceName((boolean)true);
        Object[] objectArray = new Object[]{string};
        ApplianceInfo applianceInfo = (ApplianceInfo)this.m_dialogWizard.getValue((Object)"ApplianceInfo");
        AvrRipInfo[] avrRipInfoArray = (AvrRipInfo[])this.m_dialogWizard.getValue((Object)"AvrRipInfo");
        AvrServerInfo[] avrServerInfoArray = (AvrServerInfo[])this.m_dialogWizard.getValue((Object)"AvrServerInfo");
        Boolean bl = (Boolean)this.m_dialogWizard.getValue((Object)"IncludeOfflineRips");
        try {
            AvrDatabaseHelper.resyncAppliance(applianceInfo, null, avrRipInfoArray, avrServerInfoArray, bl);
            this.m_dialogWizard.putValue((Object)"FinishHeader", (Object)MessageFormat.format(res.getString("JPanelResyncWizardDetectedChanges_Completing_the_Resync_Wizard"), objectArray));
            this.m_dialogWizard.putValue((Object)"FinishExclamation", (Object)new Boolean(false));
            this.m_dialogWizard.putValue((Object)"FinishStatus", (Object)res.getString("JPanelResyncWizardDetectedChanges_The_database_was"));
            this.m_dialogWizard.putValue((Object)"FinishClose", (Object)res.getString("JPanelResyncWizardDetectedChanges_Click_Finish_to_exit_"));
            this.m_dialogWizard.putValue((Object)"FinishButtons", (Object)new Integer(4));
            return 6;
        }
        catch (Exception exception) {
            Trace.logError((String)"AvrResyncWizard:Detected Changes Page", (String)"Error updating database", (Throwable)exception);
            this.m_dialogWizard.putValue((Object)"FinishHeader", (Object)MessageFormat.format(res.getString("JPanelResyncWizardDetectedChanges_Resync_Wizard_Unsuccessful"), objectArray));
            this.m_dialogWizard.putValue((Object)"FinishExclamation", (Object)new Boolean(true));
            this.m_dialogWizard.putValue((Object)"FinishStatus", (Object)res.getString("JPanelResyncWizardDetectedChanges_There_was_an_error_database"));
            this.m_dialogWizard.putValue((Object)"FinishClose", (Object)res.getString("JPanelResyncWizardDetectedChanges_Click_Back_to_retry"));
            this.m_dialogWizard.putValue((Object)"FinishButtons", (Object)new Integer(5));
            return 6;
        }
    }

    private boolean wasSwitchDetected() {
        AvrRipInfo[] avrRipInfoArray = (AvrRipInfo[])this.m_dialogWizard.getValue((Object)"AvrRipInfo");
        Boolean bl = (Boolean)this.m_dialogWizard.getValue((Object)"IncludeOfflineRips");
        boolean bl2 = bl;
        for (int i = 0; i < avrRipInfoArray.length; ++i) {
            if (avrRipInfoArray[i].getRipStatus().equals(res.getString("JPanelResyncWizardDetectedChanges_Offline")) && !bl2 || !avrRipInfoArray[i].isSwitchDetected()) continue;
            return true;
        }
        return false;
    }

    public int onBack() {
        return this.m_dialogWizard.getPreviousPageID();
    }

    public boolean onFinish() {
        return true;
    }

    public void onDestroy() {
    }

    public class AbstractTableModelChanges
    extends AbstractTableModel {
        String[] m_aszChanges;
        String szRipNameSingular = AVWorksBranding.getDsrIqName((boolean)true);
        Object[] aoRipName = new Object[]{this.szRipNameSingular};
        String[] m_szColumns = new String[]{this.szRipNameSingular, res.getString("JPanelResyncWizardDetectedChanges_Change")};
        protected final String delimiter = ":";

        public AbstractTableModelChanges() {
            this(new String[0]);
        }

        public AbstractTableModelChanges(String[] stringArray) throws IllegalArgumentException {
            if (stringArray == null) {
                throw new IllegalArgumentException("Null param in constructor not accepted");
            }
            this.m_aszChanges = stringArray;
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return this.m_szColumns.length;
        }

        public Object getValueAt(int n, int n2) {
            try {
                String string = this.m_aszChanges[n];
                int n3 = string.indexOf(58);
                if (n3 == -1) {
                    return "";
                }
                String string2 = string.substring(0, n3).trim();
                String string3 = string.substring(n3 + 1).trim();
                if (n2 == 0) {
                    return string2;
                }
                if (n2 == 1) {
                    return string3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "";
        }

        public int getRowCount() {
            return this.m_aszChanges.length;
        }

        public String getColumnName(int n) {
            return this.m_szColumns[n];
        }

        class PartiallyComparableString2
        extends AbstractTableModelExistingSwitches.PartiallyComparableString {
            PartiallyComparableString2(String string, String string2) throws NullPointerException {
                super(string, string2);
            }

            protected void setComparableStr() {
                int n = this.originalStr.indexOf(this.delimiterStr);
                if (n >= 0 && n < this.originalStr.length()) {
                    this.comparableStr = this.originalStr.substring(0, n);
                    this.comparableStr = this.comparableStr.trim();
                }
            }
        }
    }
}

