/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AmpControllerAvr;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.avr.JDialogModifyKeyboardLayout;
import com.avocent.avworks.nmm.avr.JPanelUsersSettings;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.Appliance;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.JTableAvocent;
import com.avocent.lib.gui.components.TableModelColumnSorted;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.renderers.NameValue;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.ThreadContinuous;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class JPanelRipsSettings
extends JPanelAmpPanel {
    public static final String CNAME = "JPanelRipsSettings";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    protected static int INITIAL_SORT_COLUMN_NUM = 1;
    protected static int AVCT_TABLE_FEATURE_LEVEL = 1;
    private static final int POLL_INTERVAL_SECONDS = 5;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTableAvocent m_jtRipTable;
    JPanel jPanel1 = new JPanel();
    JButton m_jbClearOffline = new JButton();
    JButton m_jbSIPModifyName = new JButton();
    JButton m_jbSIPModifyLang = new JButton();
    protected boolean[] m_bNameChanged;
    protected boolean m_bLayoutChanged;
    protected InterfaceValueObject m_ivoKeyboardLanguage;
    protected boolean m_modifyKeyboardFlag = false;
    protected JDialogModifyKeyboardLayout m_jdKeyboardLayoutDialog;
    protected String m_szTraceMessage;
    protected RipStatusIcon m_iiRipOnlineIcon;
    protected RipStatusIcon m_iiRipUpdatingIcon;
    protected RipStatusIcon m_iiRipOfflineIcon;
    protected ThreadRipTableUpdater m_trtuTableUpdateThread;
    private RipTableModel m_tmRipModel;
    private TableModelColumnSorted m_tcmsSortableModel;
    private AmpControllerAvr m_acController;
    protected boolean m_bTableColumnsSized = false;

    public JPanelRipsSettings(AmpControllerAvr ampControllerAvr) throws ExceptionConstructorFailed {
        super((AmpController)ampControllerAvr, AVWorksBranding.getDsrIqName((boolean)false), AVWorksBranding.getDsrIqName((boolean)false), "", "IDH_SETTINGS_TAB_RIPS");
        this.m_acController = ampControllerAvr;
        try {
            String string = res.getString("JPanelRipsSettings_Configure_0_settings");
            Object[] objectArray = new Object[]{AVWorksBranding.getDsrIqName((boolean)true)};
            this.m_szDescription = MessageFormat.format(string, objectArray);
            URL uRL = ((Object)((Object)this)).getClass().getResource("ripoffline.gif");
            URL uRL2 = ((Object)((Object)this)).getClass().getResource("riponline.gif");
            URL uRL3 = ((Object)((Object)this)).getClass().getResource("ripupgrading.gif");
            this.m_iiRipOfflineIcon = uRL != null ? new RipStatusIcon(3, uRL) : new RipStatusIcon(3);
            this.m_iiRipOnlineIcon = uRL2 != null ? new RipStatusIcon(1, uRL2) : new RipStatusIcon(1);
            this.m_iiRipUpdatingIcon = uRL3 != null ? new RipStatusIcon(2, uRL3) : new RipStatusIcon(2);
            this.createPanel();
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    this.setBorder(DefaultTableCellRenderer.noFocusBorder);
                    if (object instanceof ImageIcon) {
                        this.setHorizontalAlignment(2);
                        this.setIcon((ImageIcon)object);
                        this.setText("");
                    } else {
                        this.setHorizontalAlignment(2);
                        this.setIcon(null);
                        this.setText(object.toString());
                    }
                    return this;
                }
            };
            this.m_jtRipTable.setDefaultRenderer(ImageIcon.class, (TableCellRenderer)defaultTableCellRenderer);
            this.m_jtRipTable.setDefaultRenderer(String.class, (TableCellRenderer)defaultTableCellRenderer);
            this.m_szTraceMessage = "AVR AMP RIP Settings";
        }
        catch (Exception exception) {
            String string = res.getString("JPanelRipsSettings_Failed_to_construct");
            Object[] objectArray = new Object[]{AVWorksBranding.getDsrIqName((boolean)true)};
            string = MessageFormat.format(string, objectArray);
            Trace.logError((String)CNAME, (String)"ctor(Amp)", (Throwable)exception);
            throw new ExceptionConstructorFailed(string, (Throwable)exception);
        }
    }

    private void createPanel() throws Exception {
        this.m_jtRipTable = new JTableAvocent(AVCT_TABLE_FEATURE_LEVEL);
        this.m_jtRipTable.setColumnSelectionAllowed(false);
        this.m_jtRipTable.setRowSelectionAllowed(false);
        this.m_jtRipTable.setShowGrid(false);
        this.m_jtRipTable.getTableHeader().setReorderingAllowed(false);
        this.m_tmRipModel = new RipTableModel();
        this.m_tcmsSortableModel = new TableModelColumnSorted((TableModel)this.m_tmRipModel, (JTable)this.m_jtRipTable);
        this.m_tcmsSortableModel.sortByColumn(1, false);
        this.jbInit();
        this.m_jtRipTable.setSelectionMode(0);
        this.m_jtRipTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = JPanelRipsSettings.this.m_jtRipTable.getSelectedRowCount() > 0;
                JPanelRipsSettings.this.m_jbSIPModifyName.setEnabled(bl);
            }
        });
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.jScrollPane1.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.jScrollPane1.setPreferredSize(new Dimension(300, 300));
        this.m_jbSIPModifyName.setVisible(true);
        this.m_jbSIPModifyName.setEnabled(false);
        this.m_jbSIPModifyName.setText(res.getString("JPanelRipsSettings_Modify"));
        this.m_jbSIPModifyName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelRipsSettings.this.m_jbSIPModifyName_actionPerformed(actionEvent);
            }
        });
        this.m_jbSIPModifyLang.setText(res.getString("JPanelRipsSettings_Keyboard_Layout"));
        this.m_jbSIPModifyLang.setVisible(true);
        this.m_jbSIPModifyLang.setEnabled(true);
        this.m_jbSIPModifyLang.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelRipsSettings.this.m_jbSIPModifyLanguage_actionPerformed(actionEvent);
            }
        });
        this.m_jbClearOffline.setText(res.getString("JPanelRipsSettings_Clear_Offline"));
        this.m_jbClearOffline.setEnabled(true);
        this.m_jbClearOffline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelRipsSettings.this.clearOfflineRipsAction();
            }
        });
        this.add(this.jScrollPane1, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_jbSIPModifyName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.add(this.m_jbClearOffline, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.add(this.m_jbSIPModifyLang, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 10, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.m_jtRipTable, null);
    }

    public boolean initialize() {
        this.m_tmRipModel.fireTableStructureChanged();
        this.m_tcmsSortableModel.packAllColumns(2);
        boolean bl = this.m_acController.isFeatureSupported("ClearOfflineRips");
        this.m_jbClearOffline.setVisible(bl);
        this.m_jbSIPModifyLang.setVisible(this.m_acController.getAppliance().hasMinMibVersion(2, 0));
        this.m_jbSIPModifyName.setVisible(false);
        this.m_jtRipTable.setRowSelectionAllowed(false);
        this.m_bTableColumnsSized = false;
        try {
            if (this.m_trtuTableUpdateThread != null) {
                this.m_trtuTableUpdateThread.stopThread();
            }
            this.m_trtuTableUpdateThread = new ThreadRipTableUpdater();
            try {
                if (!this.isModified()) {
                    this.m_ivoKeyboardLanguage = this.getLanguage();
                }
                this.m_tmRipModel.loadRipTable();
            }
            catch (Exception exception) {
                Trace.logError((String)CNAME, (String)"initialize", (Throwable)exception);
                throw new ExceptionAsmpRequestFailed();
            }
            this.m_trtuTableUpdateThread.start();
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            return false;
        }
        catch (Exception exception) {
            String string = res.getString("JPanelRipsSettings_Unable_to_initialize_JPRS");
            Object[] objectArray = new Object[]{AVWorksBranding.getDsrIqName((boolean)true)};
            string = MessageFormat.format(string, objectArray);
            this.logError(string, exception);
            return false;
        }
    }

    public void onDestroy() {
        this.logInfo("onDestroy() was called.");
        if (this.m_nState == 103) {
            this.m_trtuTableUpdateThread.stopThread();
        }
        this.m_nState = 104;
    }

    public boolean onSetActive() {
        this.m_nState = 101;
        return super.onSetActive();
    }

    public boolean onKillActive() {
        this.logInfo("JPanelRipsSettings.onKillActive() was called.");
        this.m_trtuTableUpdateThread.stopThread();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOfflineRipsAction() {
        if (this.m_trtuTableUpdateThread != null) {
            this.m_trtuTableUpdateThread.suspendThread();
        }
        Object[] objectArray = new Object[]{AVWorksBranding.getDsrIqName((boolean)false), AVWorksBranding.getApplianceName((boolean)true), AVWorksBranding.getServerName((boolean)false), AVWorksBranding.getServerName((boolean)false), AVWorksBranding.getDsrIqName((boolean)false)};
        String string = MessageFormat.format(res.getString("JPanelRipsSettings_Clear_Offline_Confirm"), objectArray);
        int n = JOptionPane.showConfirmDialog((Component)this.m_acController.getMainFrame(), string, res.getString("JPanelRipsSettings_Clear_Offline_Confirm_Title"), 0);
        if (n == 0) {
            Trace.logInfo((String)"AVR AMP panel", (String)"User Selected to clear offline rips ");
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Object[] objectArray2 = new Object[]{"avocent.ds.dsManagement.dsPort.dsDeleteOffLineRips.0"};
                Object[] objectArray3 = new Integer[]{new Integer(2)};
                AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), objectArray2, objectArray3);
            }
            catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
                this.showClearOfflineRequestError((Exception)((Object)exceptionSnmpRequestFailed));
            }
            catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                this.showClearOfflineRequestError((Exception)((Object)exceptionAsmpRequestFailed));
            }
            catch (Exception exception) {
                Message.show((Component)((Object)this), (String)exception.getMessage());
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        } else {
            Trace.logInfo((String)"AVR AMP panel", (String)"User Selected not to clear offline rips ");
        }
        this.m_trtuTableUpdateThread.resumeThread();
        this.m_trtuTableUpdateThread.interrupt();
    }

    private void showClearOfflineRequestError(Exception exception) {
        Trace.logError((String)"AVR AMP panel", (String)exception.getMessage(), (Throwable)exception);
        Object[] objectArray = new Object[]{AVWorksBranding.getDsrIqName((boolean)false)};
        String string = MessageFormat.format(res.getString("JPanelRipsSettings_Clear_Offline_Failed"), objectArray);
        Message.show((Component)((Object)this), (String)(string + exception.getMessage()));
    }

    protected InterfaceValueObject getLanguage() {
        InterfaceValueObject interfaceValueObject = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.m_acController.getAppliance().hasMinMibVersion(2, 0)) {
                arrayList.add("avocent.ds.dsManagement.dsPort.dsRipKeyboardLanguage.0");
            } else {
                arrayList.add("avocent.ds.dsManagement.dsServer.dsLanguage.0");
            }
            InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), arrayList.toArray());
            if (!this.m_modifyKeyboardFlag) {
                interfaceValueObject = interfaceValueObjectArray[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return interfaceValueObject;
    }

    public boolean applyValues() {
        try {
            ArrayList arrayList = new ArrayList();
            InterfaceValueObject[] interfaceValueObjectArray = new InterfaceValueObject[]{this.m_ivoKeyboardLanguage};
            AvrSnmpHelper.setValues(this.m_acController.getAsmpConnection(), interfaceValueObjectArray);
            this.m_bIsModified = false;
            this.m_bLayoutChanged = false;
            this.m_bTableColumnsSized = false;
            return true;
        }
        catch (Exception exception) {
            this.m_acController.showException(null, this.getTraceContext(), null, exception);
            return false;
        }
    }

    void m_jbSIPModifyName_actionPerformed(ActionEvent actionEvent) {
    }

    void m_jbSIPModifyLanguage_actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.m_jdKeyboardLayoutDialog == null) {
                this.m_jdKeyboardLayoutDialog = new JDialogModifyKeyboardLayout(this);
            }
            this.m_modifyKeyboardFlag = true;
            InterfaceValueObject interfaceValueObject = this.m_ivoKeyboardLanguage;
            this.m_jdKeyboardLayoutDialog.showLanguage(interfaceValueObject);
            if (this.m_jdKeyboardLayoutDialog.layoutChanged()) {
                this.m_bLayoutChanged = true;
                this.setIsModified(true);
                this.m_ivoKeyboardLanguage = interfaceValueObject;
                this.m_modifyKeyboardFlag = false;
                this.m_tcmsSortableModel.fireTableDataChanged();
            }
            this.m_modifyKeyboardFlag = false;
        }
        catch (Exception exception) {
            this.logError(res.getString("JPanelRipsSettings_Unable_to_modify"), exception);
        }
    }

    private Rip getSelectedRip() {
        int n = this.m_jtRipTable.getSelectedRow();
        int n2 = this.m_tcmsSortableModel.getSortedRowIndexAt(n);
        return this.m_tmRipModel.getRip(n2);
    }

    public String getTraceContext() {
        return this.m_szTraceMessage;
    }

    private void resizeTableColumnWidths() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (!JPanelRipsSettings.this.m_bTableColumnsSized) {
                    JTableAvocent jTableAvocent = JPanelRipsSettings.this.m_jtRipTable;
                    JPanelUsersSettings.TableColumnPacker tableColumnPacker = new JPanelUsersSettings.TableColumnPacker((JTable)jTableAvocent);
                    int n = 2;
                    tableColumnPacker.packAllColumns(n);
                    JPanelRipsSettings.this.m_bTableColumnsSized = true;
                }
            }
        };
        if (!this.m_bTableColumnsSized) {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    class RipStatusIcon
    extends ImageIcon
    implements Comparable,
    Cloneable {
        static final int ONLINE = 1;
        static final int UPGRADING = 2;
        static final int OFFLINE = 3;
        URL url;
        protected int m_nState;

        public RipStatusIcon(int n) {
            this.m_nState = n;
        }

        public RipStatusIcon(int n, URL uRL) {
            super(uRL);
            this.m_nState = n;
            this.url = uRL;
        }

        public Object clone() throws NullPointerException {
            if (this.url == null) {
                throw new NullPointerException("URL object has null value");
            }
            return new RipStatusIcon(this.m_nState, this.url);
        }

        public int compareTo(Object object) {
            if (object instanceof RipStatusIcon) {
                RipStatusIcon ripStatusIcon = (RipStatusIcon)object;
                if (ripStatusIcon.m_nState > this.m_nState) {
                    return -1;
                }
                if (ripStatusIcon.m_nState < this.m_nState) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }

    class ThreadRipTableUpdater
    extends ThreadContinuous {
        protected boolean m_bSuspendThread;

        ThreadRipTableUpdater() {
            super(5000L);
            this.m_bSuspendThread = false;
        }

        public void suspendThread() {
            Trace.logInfo((String)"AVR AMP panel", (String)"ThreadRipTableUpdater: thread suspended.");
            this.m_bSuspendThread = true;
        }

        public void resumeThread() {
            Trace.logInfo((String)"AVR AMP panel", (String)"ThreadRipTableUpdater: thread resumed.");
            this.m_bSuspendThread = false;
        }

        public void performTask() {
            if (!this.m_bSuspendThread) {
                try {
                    try {
                        if (!JPanelRipsSettings.this.isModified() && !JPanelRipsSettings.this.m_modifyKeyboardFlag) {
                            JPanelRipsSettings.this.m_ivoKeyboardLanguage = JPanelRipsSettings.this.getLanguage();
                        }
                        JPanelRipsSettings.this.m_tmRipModel.loadRipTable();
                    }
                    catch (Exception exception) {
                        Trace.logError((String)exception.toString(), (String)"");
                        throw new ExceptionAsmpRequestFailed();
                    }
                }
                catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
                    JPanelRipsSettings.this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
                    String string = AVWorksBranding.getDsrIqName((boolean)true);
                    String string2 = res.getString("JPanelRipsSettings_Unable_to_update_rip_status");
                    Object[] objectArray = new Object[]{string, exceptionAsmpRequestFailed.getMessage()};
                    String string3 = exceptionAsmpRequestFailed.getMessage();
                    if (string3 == null || string3.trim().equals("")) {
                        string2 = res.getString("JPanelRipsSettings_Unable_to_update_rip_status_1");
                        objectArray = new Object[]{string};
                    }
                    string2 = MessageFormat.format(string2, objectArray);
                    ExceptionRequestFailed exceptionRequestFailed = new ExceptionRequestFailed(string2);
                    JPanelRipsSettings.this.m_acController.showException(null, null, null, exceptionRequestFailed);
                    JPanelRipsSettings.this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
                }
                catch (Exception exception) {
                    String string = res.getString("JPanelRipsSettings_Unable_to_update_rip_status_1");
                    JPanelRipsSettings.this.logError("Unable to update rip table status.", exception);
                    Object[] objectArray = new Object[]{AVWorksBranding.getDsrIqName((boolean)true)};
                    string = MessageFormat.format(string, objectArray);
                    ExceptionRequestFailed exceptionRequestFailed = new ExceptionRequestFailed(string);
                    JPanelRipsSettings.this.m_acController.showException(null, null, null, exceptionRequestFailed);
                }
            }
        }
    }

    class RipTableModel
    extends AbstractTableModel {
        private Rip[] m_arList = new Rip[0];
        String[] m_aszColumnName = new String[]{res.getString("JPanelRipsSettings_Status"), res.getString("JPanelRipsSettings_Port"), res.getString("JPanelRipsSettings_ID"), res.getString("JPanelRipsSettings_Type_1"), res.getString("JPanelRipsSettings_Keyboard_Layout")};

        RipTableModel() {
        }

        public int getColumnCount() {
            return this.m_aszColumnName.length;
        }

        public int getRowCount() {
            return this.m_arList == null ? 0 : this.m_arList.length;
        }

        public Class getColumnClass(int n) {
            Class clazz = n == 0 ? (class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = JPanelRipsSettings.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon) : (class$java$lang$String == null ? (class$java$lang$String = JPanelRipsSettings.class$("java.lang.String")) : class$java$lang$String);
            return clazz;
        }

        public String getColumnName(int n) {
            return this.m_aszColumnName[n];
        }

        public Object getValueAt(int n, int n2) {
            Rip rip = this.m_arList[n];
            if (n2 == 0) {
                if (!rip.isOnline()) {
                    return JPanelRipsSettings.this.m_iiRipOfflineIcon;
                }
                if (rip.isUpgradeInProgress()) {
                    return JPanelRipsSettings.this.m_iiRipUpdatingIcon;
                }
                return JPanelRipsSettings.this.m_iiRipOnlineIcon;
            }
            if (n2 == 1) {
                Integer n3 = rip.getPortNumber();
                return new Integer(n3 + 1);
            }
            if (n2 == 2) {
                return rip.getRipId();
            }
            if (n2 == 3) {
                return rip.getType();
            }
            if (n2 == 4) {
                if (JPanelRipsSettings.this.m_ivoKeyboardLanguage != null) {
                    return (NameValue)JPanelRipsSettings.this.m_ivoKeyboardLanguage.getValue();
                }
                if (rip.getKeyboardLayout() != null) {
                    return rip.getKeyboardLayout();
                }
                return new String("");
            }
            throw new RuntimeException(res.getString("JPanelRipsSettings_Req_Failed_internal"));
        }

        public Rip getRip(int n) {
            return this.m_arList[n];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void loadRipTable() throws Exception {
            Rip rip;
            InterfaceValueObject[][] interfaceValueObjectArray;
            Appliance appliance;
            block19: {
                ArrayList<String> arrayList = new ArrayList<String>();
                appliance = JPanelRipsSettings.this.m_acController.getAppliance();
                arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipId");
                arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipType");
                arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipName");
                if (!appliance.hasMinMibVersion(2, 0)) {
                    arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableKeyboardLayout");
                }
                arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableInputPort");
                arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipStatus");
                arrayList.add("avocent.ds.dsManagement.dsPort.dsPortRipTable.dsPortRipTableEntry.dsPortRipTableRipUpgradeStatus");
                interfaceValueObjectArray = null;
                interfaceValueObjectArray = AvrSnmpHelper.getTableValues(JPanelRipsSettings.this.m_acController.getAsmpConnection(), arrayList.toArray());
                if (interfaceValueObjectArray == null) {
                    throw new Exception("DsSnmpHelper.getTableValues() returns null.");
                }
                rip = null;
                if (interfaceValueObjectArray != null) break block19;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                interfaceValueObjectArray = AvrSnmpHelper.getTableValues(JPanelRipsSettings.this.m_acController.getAsmpConnection(), arrayList.toArray());
                {
                    break block19;
                    catch (Exception exception) {
                        Trace.logError((String)exception.toString(), (String)"", (Throwable)exception);
                        rip = null;
                        if (interfaceValueObjectArray != null) break block19;
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        interfaceValueObjectArray = AvrSnmpHelper.getTableValues(JPanelRipsSettings.this.m_acController.getAsmpConnection(), arrayList.toArray());
                    }
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    if (interfaceValueObjectArray == null) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        interfaceValueObjectArray = AvrSnmpHelper.getTableValues(JPanelRipsSettings.this.m_acController.getAsmpConnection(), arrayList.toArray());
                    }
                    throw throwable;
                }
            }
            Rip[] ripArray = new Rip[interfaceValueObjectArray.length];
            for (int i = 0; i < interfaceValueObjectArray.length; ++i) {
                rip = null;
                rip = !appliance.hasMinMibVersion(2, 0) ? new Rip(interfaceValueObjectArray[i][0].getString(), interfaceValueObjectArray[i][1], interfaceValueObjectArray[i][2], interfaceValueObjectArray[i][3], interfaceValueObjectArray[i][4], interfaceValueObjectArray[i][5], interfaceValueObjectArray[i][6]) : new Rip(interfaceValueObjectArray[i][0].getString(), interfaceValueObjectArray[i][1], interfaceValueObjectArray[i][2], null, interfaceValueObjectArray[i][3], interfaceValueObjectArray[i][4], interfaceValueObjectArray[i][5]);
                ripArray[i] = rip;
            }
            Rip[] ripArray2 = this.m_arList;
            synchronized (this.m_arList) {
                this.m_arList = ripArray;
                boolean bl = false;
                for (int i = 0; i < this.m_arList.length; ++i) {
                    Rip rip2 = this.m_arList[i];
                    if (rip2.isOnline() || rip2.isUpgradeInProgress()) continue;
                    bl = true;
                    break;
                }
                JPanelRipsSettings.this.m_jbClearOffline.setEnabled(bl);
                // ** MonitorExit[var5_14] (shouldn't be in output)
                JPanelRipsSettings.this.m_bNameChanged = new boolean[interfaceValueObjectArray.length];
                for (int i = 0; i < JPanelRipsSettings.this.m_bNameChanged.length; ++i) {
                    JPanelRipsSettings.this.m_bNameChanged[i] = false;
                }
                JPanelRipsSettings.this.m_bLayoutChanged = false;
                try {
                    JPanelRipsSettings.this.resizeTableColumnWidths();
                }
                catch (Exception exception) {
                    Trace.logError((String)exception.toString(), (String)"");
                }
                this.fireTableDataChanged();
                return;
            }
        }
    }

    class Rip {
        String m_szId;
        InterfaceValueObject m_ivoType;
        InterfaceValueObject m_ivoRipName;
        InterfaceValueObject m_ivoKeyboardLayout;
        InterfaceValueObject m_ivoPortNumber;
        InterfaceValueObject m_nvRipStatus;
        InterfaceValueObject m_nvRipUpgradeStatus;

        Rip(String string, InterfaceValueObject interfaceValueObject, InterfaceValueObject interfaceValueObject2, InterfaceValueObject interfaceValueObject3, InterfaceValueObject interfaceValueObject4, InterfaceValueObject interfaceValueObject5, InterfaceValueObject interfaceValueObject6) throws ExceptionConstructorFailed {
            this.m_szId = string;
            this.m_ivoType = interfaceValueObject;
            this.m_ivoRipName = interfaceValueObject2;
            this.m_ivoKeyboardLayout = interfaceValueObject3;
            this.m_ivoPortNumber = interfaceValueObject4;
            this.m_nvRipStatus = interfaceValueObject5;
            this.m_nvRipUpgradeStatus = interfaceValueObject6;
        }

        public String getRipId() {
            return this.m_szId;
        }

        public void setRipId(String string) {
            this.m_szId = string;
        }

        public NameValue getType() {
            return (NameValue)this.m_ivoType.getValue();
        }

        public void setType(NameValue nameValue) {
            this.m_ivoType.setValue((Object)nameValue);
        }

        public NameValue getKeyboardLayout() {
            return (NameValue)this.m_ivoKeyboardLayout.getValue();
        }

        public void setKeyboardLayout(NameValue nameValue) {
            this.m_ivoKeyboardLayout.setValue((Object)nameValue);
        }

        public Integer getPortNumber() {
            return (Integer)this.m_ivoPortNumber.getValue();
        }

        public void setPortNumber(Integer n) {
            this.m_ivoPortNumber.setValue((Object)n);
        }

        public NameValue getRipUpgradeStatus() {
            return (NameValue)this.m_nvRipUpgradeStatus.getValue();
        }

        public InterfaceValueObject getRipName() {
            return this.m_ivoRipName;
        }

        public void setRipName(InterfaceValueObject interfaceValueObject) {
            this.m_ivoRipName = interfaceValueObject;
        }

        public void setRipUpgradeStatus(NameValue nameValue) {
            this.m_nvRipUpgradeStatus.setValue((Object)nameValue);
        }

        public NameValue getRipStatus() {
            return (NameValue)this.m_nvRipStatus.getValue();
        }

        public void setRipStatus(NameValue nameValue) {
            this.m_nvRipStatus.setValue((Object)nameValue);
        }

        public boolean isUpgradeInProgress() {
            Integer n = (Integer)this.getRipUpgradeStatus().getValue();
            return n == 2;
        }

        public boolean isOnline() {
            Integer n = (Integer)this.getRipStatus().getValue();
            return n == 3;
        }
    }
}

