/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AmpControllerAvr;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.ExceptionSnmpRequestFailed;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AppliancePropertiesDb;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.gui.components.JComboBoxAvocent;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.renderers.NameValue;
import com.avocent.lib.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class JPanelSessionsSettings
extends JPanelAmpPanel {
    public static final String CNAME = "JPanelSessionsSettings";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    private final Integer TIMEOUT_DISABLED_VAL = new Integer(0);
    private final Integer TIMEOUT_DEFAULT_PREEMPTION_VAL = new Integer(30);
    private final Integer SESSION_MIN_TIMEOUT = new Integer(1);
    private final Integer SESSION_MAX_TIMEOUT = new Integer(60);
    private final int SESSION_START_TIMEOUT = 10;
    private final int SESSION_END_TIMEOUT = this.SESSION_MAX_TIMEOUT;
    private final int SESSION_TIMEOUT_INCREMENT = 5;
    private final Integer PREEMPTION_MIN_TIMEOUT = new Integer(5);
    private final Integer PREEMPTION_MAX_TIMEOUT = new Integer(120);
    private final int PREEMPTION_START_TIMEOUT = 5;
    private final Integer LOGIN_TIMEOUT_START = new Integer(20);
    private final Integer LOGIN_TIMEOUT_END = new Integer(120);
    private final int LOGIN_TIMEOUT_INCREMENT = 10;
    private final int PREEMPTION_END_TIMEOUT = this.PREEMPTION_MAX_TIMEOUT;
    private final int ENCRYPTION_DISABLED = 1;
    private final int ENCRYPTION_ENABLED = 2;
    private final Integer SHARING_DISABLED = new Integer(1);
    private final Integer SHARING_ENABLED = new Integer(2);
    private boolean m_bPreemptionWarningSupported = false;
    private boolean m_bConnectionSharingSupported = false;
    private boolean m_bVideoEncSupported = false;
    private boolean m_bLoginTimeout = false;
    private MinutesItemListener m_ilMinutes = null;
    private AmpControllerAvr m_acController;
    private int m_nMibMajorVersion = 1;
    EncryptionLevelItemListener elItemListener = null;
    EnableItemL m_LEnableItem = null;
    ShareModeL m_LShareMode = null;
    GridBagLayout m_gridBagLayout1 = new GridBagLayout();
    GridBagLayout m_gridBagLayout2 = new GridBagLayout();
    GridBagLayout m_gridBagLayout3 = new GridBagLayout();
    GridBagLayout m_gridBagLayout4 = new GridBagLayout();
    GridBagLayout m_gridBagLayout5 = new GridBagLayout();
    GridBagLayout m_gridBagLayout6 = new GridBagLayout();
    GridBagLayout m_gridBagLayout7 = new GridBagLayout();
    GridBagLayout m_gridBagLayout8 = new GridBagLayout();
    JPanel m_jpTopPanel = new JPanel();
    JLabel m_jLabelMinutes = new JLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JCheckBox m_jCheckBoxEnabled = new JCheckBox();
    JComboBoxAvocent m_jComboBoxMinutes = new JComboBoxAvocent();
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    TitledBorder titledBorder3;
    TitledBorder titledBorder4;
    TitledBorder preemptionTitledBorder;
    JPanel m_jpEncryption = new JPanel();
    JPanel m_jpEncLabels = new JPanel();
    JPanel m_jpEncChoice = new JPanel();
    JLabel m_jlVideoEncryp = new JLabel();
    JPanel m_jpVideoEncryp = new JPanel();
    JLabel m_jlKBMEncryp = new JLabel();
    JPanel m_jpKBMEncryp = new JPanel();
    JCheckBox m_cbVideo128 = new JCheckBox();
    JCheckBox m_cbVideoDES = new JCheckBox();
    JCheckBox m_cbVideo3DES = new JCheckBox();
    JCheckBox m_cbKBM128 = new JCheckBox();
    JCheckBox m_cbKBMDES = new JCheckBox();
    JCheckBox m_cbKBM3DES = new JCheckBox();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel m_jpPreemption = new JPanel();
    JCheckBox m_jcbPreemptionEnable = new JCheckBox();
    JComboBoxAvocent m_jComboBoxPreemptionSeconds = new JComboBoxAvocent();
    JLabel m_jlPreemptionSeconds = new JLabel();
    JCheckBox m_cbEnableSharing = new JCheckBox();
    JCheckBox m_cbAutoSharing = new JCheckBox();
    JCheckBox m_cbExclusive = new JCheckBox();
    JCheckBox m_cbStealth = new JCheckBox();
    JPanel m_jpConnectionSharing = new JPanel();
    TitledBorder m_tbConnectionSharing;
    JLabel m_jlInCtrlTO = new JLabel();
    JLabel m_jlSeconds = new JLabel();
    JComboBoxAvocent m_kbInCtrlTO = new JComboBoxAvocent();
    ArrayList m_alInCTO = new ArrayList();
    JLabel m_jlFiller = new JLabel();
    NumberFormat m_nf = NumberFormat.getInstance();
    JPanel m_jpTimeouts = new JPanel();
    TitledBorder m_tbTimeouts;
    JLabel m_jlLoginTimeout = new JLabel();
    JLabel m_jlTimeoutSeconds = new JLabel();
    JComboBoxAvocent m_jComboBoxTimeoutSeconds = new JComboBoxAvocent();
    JLabel m_jlFiller2 = new JLabel();
    LoginTimeoutL m_logTimeoutListener = null;

    public JPanelSessionsSettings(AmpControllerAvr ampControllerAvr) throws ExceptionConstructorFailed {
        super((AmpController)ampControllerAvr, res.getString("JPanelSessionsSettings_Sessions"), res.getString("JPanelSessionsSettings_Global") + " - " + res.getString("JPanelSessionsSettings_Sessions"), res.getString("JPanelSessionsSettings_Specify_video_session"), "IDH_SETTINGS_TAB_GLOBAL_SESSIONS");
        this.m_nf.setParseIntegerOnly(false);
        this.m_nf.setMinimumFractionDigits(1);
        this.m_acController = ampControllerAvr;
        this.getContentPane().setVisible(false);
        try {
            this.jbInit();
            this.setFieldAccess();
        }
        catch (Exception exception) {
            this.logError("Constructor failed with exception: " + exception.getMessage(), exception);
            throw new ExceptionConstructorFailed(exception.getMessage());
        }
    }

    void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)));
        this.setLayout(this.m_gridBagLayout1);
        this.m_jpTopPanel.setLayout(this.m_gridBagLayout2);
        this.m_jLabelMinutes.setText(res.getString("JPanelSessionsSettings_Minutes"));
        this.m_jpTopPanel.setBorder(this.titledBorder1);
        this.m_jCheckBoxEnabled.setText(res.getString("JPanelSessionsSettings_Enabled"));
        this.m_jComboBoxMinutes.setEditable(true);
        this.titledBorder1.setTitle(res.getString("JPanelSessionsSettings_Video_session_timeout"));
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)));
        this.titledBorder2.setTitle(res.getString("JPanelSessionsSettings_Encryption_Title"));
        this.titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)));
        this.titledBorder3.setTitle(res.getString("JPanelSessionsSettings_Enc_Title_Video"));
        this.m_jpEncryption.setBorder(this.titledBorder2);
        this.m_jpEncryption.setLayout(this.m_gridBagLayout3);
        this.m_jpEncLabels.setLayout(this.m_gridBagLayout3);
        this.m_jpEncChoice.setLayout(this.m_gridBagLayout3);
        this.m_jlVideoEncryp.setText(res.getString("JPanelSessionsSettings_Enc_Title_Video"));
        this.m_jpVideoEncryp.setLayout(this.m_gridBagLayout4);
        this.titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)));
        this.titledBorder4.setTitle(res.getString("JPanelSessionsSettings_Enc_Title_KeyboardMouse"));
        this.m_jlKBMEncryp.setText(res.getString("JPanelSessionsSettings_Enc_Title_KeyboardMouse"));
        this.m_jpKBMEncryp.setLayout(this.m_gridBagLayout5);
        this.m_cbVideo128.setBorder(null);
        this.m_cbVideo128.setText(res.getString("JPanelSessionsSettings_ENUM_128"));
        this.m_cbVideoDES.setBorder(null);
        this.m_cbVideoDES.setText(res.getString("JPanelSessionsSettings_ENUM_DES"));
        this.m_cbVideo3DES.setBorder(null);
        this.m_cbVideo3DES.setText(res.getString("JPanelSessionsSettings_ENUM_3DES"));
        this.m_cbKBM128.setBorder(null);
        this.m_cbKBM128.setText(res.getString("JPanelSessionsSettings_ENUM_128"));
        this.m_cbKBMDES.setBorder(null);
        this.m_cbKBMDES.setText(res.getString("JPanelSessionsSettings_ENUM_DES"));
        this.m_cbKBM3DES.setBorder(null);
        this.m_cbKBM3DES.setText(res.getString("JPanelSessionsSettings_ENUM_3DES"));
        this.preemptionTitledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)));
        this.preemptionTitledBorder.setTitle(res.getString("JPanelSessionsSettings_Video_Session_Preemption_Timeout"));
        this.m_jpPreemption.setLayout(this.m_gridBagLayout6);
        this.m_jcbPreemptionEnable.setText(res.getString("JPanelSessionsSettings_Preemption_Enabled"));
        this.m_jpPreemption.setBorder(this.preemptionTitledBorder);
        this.m_jComboBoxPreemptionSeconds.setEditable(true);
        this.m_jlPreemptionSeconds.setText(res.getString("JPanelSessionsSettings_Seconds"));
        this.m_jpConnectionSharing.setVisible(false);
        this.m_jpConnectionSharing.setLayout(this.m_gridBagLayout7);
        this.m_tbConnectionSharing = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)));
        this.m_tbConnectionSharing.setTitle(res.getString("JPanelSessionsSettings_Video_Title_Connection"));
        this.m_jpConnectionSharing.setBorder(this.m_tbConnectionSharing);
        this.m_cbEnableSharing.setText(res.getString("JPanelSessionsSettings_Video_EnableSharing"));
        this.m_cbAutoSharing.setText(res.getString("JPanelSessionsSettings_Video_AutoSharing"));
        this.m_cbExclusive.setText(res.getString("JPanelSessionsSettings_Video_ExConnections"));
        this.m_cbStealth.setText(res.getString("JPanelSessionsSettings_Video_StealthConnections"));
        this.add(this.m_jpTopPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(4, 11, 0, 0), 0, 0));
        this.m_jpTopPanel.add((Component)this.m_jCheckBoxEnabled, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 20, 5, 0), 0, 0));
        this.m_jpTopPanel.add((Component)this.m_jComboBoxMinutes, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.m_jpTopPanel.add((Component)this.m_jLabelMinutes, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_jpPreemption, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(4, 11, 0, 0), 0, 0));
        this.m_jpPreemption.add((Component)this.m_jcbPreemptionEnable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 20, 5, 0), 0, 0));
        this.m_jpPreemption.add((Component)this.m_jComboBoxPreemptionSeconds, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 20, 5, 0), 0, 0));
        this.m_jpPreemption.add((Component)this.m_jlPreemptionSeconds, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.m_jpEncLabels.add((Component)this.m_jlVideoEncryp, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.m_jpVideoEncryp.add((Component)this.m_cbVideo128, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 5, 0), 0, 0));
        this.m_jpVideoEncryp.add((Component)this.m_cbVideoDES, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 5, 0), 0, 0));
        this.m_jpVideoEncryp.add((Component)this.m_cbVideo3DES, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 5, 0), 0, 0));
        this.m_jpEncChoice.add((Component)this.m_jpVideoEncryp, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_jpEncLabels.add((Component)this.m_jlKBMEncryp, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.m_jpKBMEncryp.add((Component)this.m_cbKBM128, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 5, 0), 0, 0));
        this.m_jpKBMEncryp.add((Component)this.m_cbKBMDES, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 5, 0), 0, 0));
        this.m_jpKBMEncryp.add((Component)this.m_cbKBM3DES, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 5, 0), 0, 0));
        this.m_jpEncChoice.add((Component)this.m_jpKBMEncryp, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_jpEncryption, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(4, 11, 0, 0), 0, 0));
        this.m_jpEncryption.add((Component)this.m_jpEncLabels, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 0), 0, 0));
        this.m_jpEncryption.add((Component)this.m_jpEncChoice, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_jlInCtrlTO.setText(res.getString("JPanelSessionsSettings_Connection_Sharing_InCtrlTO"));
        this.m_jlSeconds.setText(res.getString("JPanelSessionsSettings_Connection_Sharing_Seconds"));
        this.m_kbInCtrlTO.setEditable(false);
        this.add(this.m_jpConnectionSharing, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(4, 11, 0, 0), 0, 0));
        this.m_jpConnectionSharing.add((Component)this.m_cbEnableSharing, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 20, 4, 0), 0, 0));
        this.m_jpConnectionSharing.add((Component)this.m_cbAutoSharing, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(4, 0, 4, 0), 0, 0));
        this.m_jpConnectionSharing.add((Component)this.m_cbExclusive, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 20, 4, 0), 0, 0));
        this.m_jpConnectionSharing.add((Component)this.m_cbStealth, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(4, 0, 4, 0), 0, 0));
        this.m_jpConnectionSharing.add((Component)this.m_jlInCtrlTO, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 24, 4, 0), 0, 0));
        this.m_jpConnectionSharing.add((Component)this.m_kbInCtrlTO, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 4, 0), 0, 0));
        this.m_jpConnectionSharing.add((Component)this.m_jlSeconds, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 5, 4, 0), 0, 0));
        this.m_jpTimeouts.setVisible(false);
        this.m_jpTimeouts.setLayout(this.m_gridBagLayout8);
        this.m_tbTimeouts = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)));
        this.m_tbTimeouts.setTitle(res.getString("JPanelSessionsSettings_Login_Timeout"));
        this.m_jpTimeouts.setBorder(this.m_tbTimeouts);
        this.m_jlTimeoutSeconds.setText(res.getString("JPanelSessionsSettings_Login_Timeout_Seconds"));
        this.m_jlFiller2.setText(" ");
        this.m_jComboBoxTimeoutSeconds.setEditable(true);
        this.add(this.m_jpTimeouts, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(4, 11, 0, 0), 0, 0));
        this.m_jpTimeouts.add((Component)this.m_jComboBoxTimeoutSeconds, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        this.m_jpTimeouts.add((Component)this.m_jlTimeoutSeconds, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(this.m_jlFiller, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean onKillActive() {
        this.logInfo("onKillActive() was called.");
        if (this.m_nState == 103) {
            try {
                this.validateInputFields();
                return false;
            }
            catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                Message.show((Component)((Object)this), (String)exceptionInvalidArgument.getMessage());
                return true;
            }
            catch (Exception exception) {
                this.m_acController.showException(null, this.getTraceContext(), "", exception);
                return true;
            }
        }
        return false;
    }

    protected boolean initialize() {
        this.getContentPane().setVisible(this.m_acController.getAppliance().isUserApplianceAdmin());
        try {
            Serializable serializable;
            InterfaceValueObject[] interfaceValueObjectArray;
            Integer n;
            int n2;
            this.m_nMibMajorVersion = this.m_acController.getAppliance().getMibMajorVersion();
            this.m_bPreemptionWarningSupported = this.m_acController.isFeatureSupported("PreemptionWarningFeature");
            this.m_bConnectionSharingSupported = this.m_acController.isFeatureSupported("ConnectionSharing");
            this.m_bVideoEncSupported = this.m_nMibMajorVersion >= 2;
            this.m_jpPreemption.setVisible(this.m_bPreemptionWarningSupported);
            this.m_jpVideoEncryp.setVisible(this.m_bVideoEncSupported);
            this.m_jlVideoEncryp.setVisible(this.m_bVideoEncSupported);
            this.m_bLoginTimeout = this.m_acController.isFeatureSupported("LoginTimeoutSupport");
            this.m_jpTimeouts.setVisible(this.m_bLoginTimeout);
            this.removeEventListeners();
            for (n2 = 10; n2 <= this.SESSION_END_TIMEOUT; n2 += 5) {
                this.m_jComboBoxMinutes.addItem((Object)String.valueOf(n2));
            }
            for (n2 = 5; n2 <= this.PREEMPTION_END_TIMEOUT; n2 += 5) {
                this.m_jComboBoxPreemptionSeconds.addItem((Object)String.valueOf(n2));
            }
            for (long i = 1L; i <= 50L; ++i) {
                this.m_alInCTO.add(String.valueOf((double)i / 10.0));
                this.m_kbInCtrlTO.addItem((Object)this.m_nf.format((double)i / 10.0));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("avocent.ds.dsManagement.dsSession.dsSessionTimeout.0");
            if (this.m_bPreemptionWarningSupported) {
                arrayList.add("avocent.ds.dsManagement.dsSession.dsSessionPreemptionTimeout.0");
            }
            if ((n = (Integer)(interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), arrayList.toArray()))[0].getValue()).equals(this.TIMEOUT_DISABLED_VAL)) {
                this.m_jCheckBoxEnabled.setSelected(false);
            } else {
                this.m_jCheckBoxEnabled.setSelected(true);
                this.m_jComboBoxMinutes.setSelectedItem((Object)interfaceValueObjectArray[0].toString());
            }
            if (this.m_bPreemptionWarningSupported) {
                serializable = (Integer)interfaceValueObjectArray[1].getValue();
                if (((Integer)serializable).equals(this.TIMEOUT_DISABLED_VAL)) {
                    this.m_jcbPreemptionEnable.setSelected(false);
                    this.m_jComboBoxPreemptionSeconds.setSelectedItem((Object)this.TIMEOUT_DEFAULT_PREEMPTION_VAL.toString());
                } else {
                    this.m_jcbPreemptionEnable.setSelected(true);
                    this.m_jComboBoxPreemptionSeconds.setSelectedItem((Object)interfaceValueObjectArray[1].toString());
                }
            }
            this.setFieldAccess();
            serializable = new ArrayList();
            ((ArrayList)serializable).add("avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableIndex");
            ((ArrayList)serializable).add("avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl");
            InterfaceValueObject[][] interfaceValueObjectArray2 = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), ((ArrayList)serializable).toArray());
            this.setKBMEncryptionLevels(interfaceValueObjectArray2);
            if (this.m_bConnectionSharingSupported) {
                arrayList.clear();
                arrayList.add("avocent.ds.dsManagement.dsVideoControl.dsVideoControlSharingAllowed.0");
                arrayList.add("avocent.ds.dsManagement.dsVideoControl.dsVideoControlAutomaticSharing.0");
                arrayList.add("avocent.ds.dsManagement.dsVideoControl.dsVideoControlExclusiveSessionsAllowed.0");
                arrayList.add("avocent.ds.dsManagement.dsVideoControl.dsVideoControlStealthSessionsAllowed.0");
                arrayList.add("avocent.ds.dsManagement.dsVideoControl.dsVideoControlInputControlTimeout.0");
                InterfaceValueObject[] interfaceValueObjectArray3 = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), arrayList.toArray());
                this.m_cbEnableSharing.setSelected(interfaceValueObjectArray3[0].getInteger().compareTo(this.SHARING_ENABLED) == 0);
                this.m_cbAutoSharing.setEnabled(this.m_cbEnableSharing.isSelected());
                this.m_cbExclusive.setEnabled(this.m_cbEnableSharing.isSelected());
                this.m_cbStealth.setEnabled(this.m_cbEnableSharing.isSelected());
                this.m_kbInCtrlTO.setEnabled(this.m_cbEnableSharing.isSelected());
                this.m_cbAutoSharing.setSelected(interfaceValueObjectArray3[1].getInteger().compareTo(this.SHARING_ENABLED) == 0);
                this.m_cbExclusive.setSelected(interfaceValueObjectArray3[2].getInteger().compareTo(this.SHARING_ENABLED) == 0);
                this.m_cbStealth.setSelected(interfaceValueObjectArray3[3].getInteger().compareTo(this.SHARING_ENABLED) == 0);
                String string = String.valueOf(interfaceValueObjectArray3[4].getInteger().doubleValue() / 10.0);
                int n3 = this.m_alInCTO.indexOf(string);
                this.m_kbInCtrlTO.setSelectedIndex(n3);
                this.m_jpConnectionSharing.setVisible(true);
            }
            if (this.m_bVideoEncSupported) {
                ((ArrayList)serializable).clear();
                ((ArrayList)serializable).add("avocent.ds.dsManagement.dsVideoControl.dsVideoEncryptionTable.dsVideoEncryptionTableEntry.dsVideoEncryptionTableIndex");
                ((ArrayList)serializable).add("avocent.ds.dsManagement.dsVideoControl.dsVideoEncryptionTable.dsVideoEncryptionTableEntry.dsVideoEncryptionTableControl");
                interfaceValueObjectArray2 = AvrSnmpHelper.getTableValues(this.m_acController.getAsmpConnection(), ((ArrayList)serializable).toArray());
                this.setVideoEncryptionLevels(interfaceValueObjectArray2);
            }
            if (this.m_bLoginTimeout) {
                arrayList.clear();
                arrayList.add("avocent.ds.dsManagement.dsServer.dsLoginTimeout.0");
                interfaceValueObjectArray = AvrSnmpHelper.getValues(this.m_acController.getAsmpConnection(), arrayList.toArray());
                for (int i = this.LOGIN_TIMEOUT_START.intValue(); i <= this.LOGIN_TIMEOUT_END; i += 10) {
                    this.m_jComboBoxTimeoutSeconds.addItem((Object)Integer.toString(i));
                }
                this.m_jComboBoxTimeoutSeconds.setSelectedItem((Object)interfaceValueObjectArray[0].toString());
            }
            this.addEventListeners();
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            return false;
        }
        catch (Exception exception) {
            this.logError(exception.getMessage(), exception);
            return false;
        }
    }

    protected boolean applyValues() {
        this.logInfo("applyValues called in JPanelSessionSettings");
        boolean bl = this.checkKBMEncryptionSelection();
        if (!bl) {
            this.logInfo("returning false applyValues without saving because no encryption level enabled");
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("avocent.ds.dsManagement.dsSession.dsSessionTimeout.0");
        arrayList.add("avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl.1");
        arrayList.add("avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl.2");
        arrayList.add("avocent.ds.dsManagement.dsServer.dsKeyboardMouseEncryptionTable.dsKeyboardMouseEncryptionTableEntry.dsKeyboardMouseEncryptionTableControl.3");
        if (this.m_bPreemptionWarningSupported) {
            arrayList.add("avocent.ds.dsManagement.dsSession.dsSessionPreemptionTimeout.0");
        }
        if (this.m_bVideoEncSupported) {
            arrayList.add("avocent.ds.dsManagement.dsVideoControl.dsVideoEncryptionTable.dsVideoEncryptionTableEntry.dsVideoEncryptionTableControl.1");
            arrayList.add("avocent.ds.dsManagement.dsVideoControl.dsVideoEncryptionTable.dsVideoEncryptionTableEntry.dsVideoEncryptionTableControl.2");
            arrayList.add("avocent.ds.dsManagement.dsVideoControl.dsVideoEncryptionTable.dsVideoEncryptionTableEntry.dsVideoEncryptionTableControl.3");
        }
        if (this.m_bConnectionSharingSupported) {
            arrayList.add("avocent.ds.dsManagement.dsVideoControl.dsVideoControlSharingAllowed.0");
            if (this.m_cbEnableSharing.isSelected()) {
                arrayList.add("avocent.ds.dsManagement.dsVideoControl.dsVideoControlAutomaticSharing.0");
                arrayList.add("avocent.ds.dsManagement.dsVideoControl.dsVideoControlExclusiveSessionsAllowed.0");
                arrayList.add("avocent.ds.dsManagement.dsVideoControl.dsVideoControlStealthSessionsAllowed.0");
                arrayList.add("avocent.ds.dsManagement.dsVideoControl.dsVideoControlInputControlTimeout.0");
            }
        }
        try {
            Number number;
            String string;
            this.validateInputFields();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            if (this.m_jCheckBoxEnabled.isSelected()) {
                string = (String)this.m_jComboBoxMinutes.getSelectedItem();
                number = Integer.valueOf(string);
                arrayList2.add((Integer)number);
            } else {
                arrayList2.add(this.TIMEOUT_DISABLED_VAL);
            }
            arrayList2.add(this.m_cbKBMDES.isSelected() ? new Integer(2) : new Integer(1));
            arrayList2.add(this.m_cbKBM3DES.isSelected() ? new Integer(2) : new Integer(1));
            arrayList2.add(this.m_cbKBM128.isSelected() ? new Integer(2) : new Integer(1));
            if (this.m_bPreemptionWarningSupported) {
                if (this.m_jcbPreemptionEnable.isSelected()) {
                    string = (String)this.m_jComboBoxPreemptionSeconds.getSelectedItem();
                    number = Integer.valueOf(string);
                    arrayList2.add((Integer)number);
                } else {
                    arrayList2.add(this.TIMEOUT_DISABLED_VAL);
                }
            }
            if (this.m_bVideoEncSupported) {
                arrayList2.add(this.m_cbVideoDES.isSelected() ? new Integer(2) : new Integer(1));
                arrayList2.add(this.m_cbVideo3DES.isSelected() ? new Integer(2) : new Integer(1));
                arrayList2.add(this.m_cbVideo128.isSelected() ? new Integer(2) : new Integer(1));
            }
            if (this.m_bConnectionSharingSupported) {
                arrayList2.add(this.m_cbEnableSharing.isSelected() ? this.SHARING_ENABLED : this.SHARING_DISABLED);
                if (this.m_cbEnableSharing.isSelected()) {
                    arrayList2.add(this.m_cbAutoSharing.isSelected() ? this.SHARING_ENABLED : this.SHARING_DISABLED);
                    arrayList2.add(this.m_cbExclusive.isSelected() ? this.SHARING_ENABLED : this.SHARING_DISABLED);
                    arrayList2.add(this.m_cbStealth.isSelected() ? this.SHARING_ENABLED : this.SHARING_DISABLED);
                    int n = this.m_kbInCtrlTO.getSelectedIndex();
                    number = Double.valueOf((String)this.m_alInCTO.get(n));
                    double d = (Double)number * 10.0;
                    arrayList2.add(new Integer(new Double(d).intValue()));
                }
            }
            if (this.m_bLoginTimeout) {
                arrayList.add("avocent.ds.dsManagement.dsServer.dsLoginTimeout.0");
                String string2 = (String)this.m_jComboBoxTimeoutSeconds.getSelectedItem();
                number = Integer.valueOf(string2);
                arrayList2.add((Integer)number);
            }
            AvrSnmpHelper.set(this.m_acController.getAsmpConnection(), arrayList.toArray(), arrayList2.toArray());
            if (this.m_bLoginTimeout) {
                String string3 = (String)this.m_jComboBoxTimeoutSeconds.getSelectedItem();
                AppliancePropertiesDb.setValue((int)this.m_acController.getApplianceInfo().getID(), (String)"LOGIN_TIMEOUT", (String)string3);
            }
            return true;
        }
        catch (ExceptionSnmpRequestFailed exceptionSnmpRequestFailed) {
            this.m_nErrorStatus = exceptionSnmpRequestFailed.getErrorCode();
            this.logError(exceptionSnmpRequestFailed.getMessage(), (Exception)((Object)exceptionSnmpRequestFailed));
            this.m_szErrorLabel = null;
            this.setErrorFieldFocus(arrayList.toArray(), exceptionSnmpRequestFailed.getErrorIndex() - 1);
            String string = "";
            if (this.m_szErrorLabel != null) {
                Object[] objectArray = new String[]{this.m_szErrorLabel};
                string = JPanelSessionsSettings.getResourceString((ResourceManager)res, (String)"JPanelSessionsSettings_Apply_Failed", (Object[])objectArray);
            } else {
                string = res.getString("JPanelSessionsSettings_Sessions_Apply_Failed");
            }
            Message.show((Component)((Object)this), (String)(string + " " + exceptionSnmpRequestFailed.getMessage()));
            return false;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            String string = res.getString("JPanelSessionsSettings_Sessions_Apply_Failed");
            Message.show((Component)((Object)this), (String)(string + " " + exceptionAsmpRequestFailed.getMessage()));
            return false;
        }
        catch (Exception exception) {
            Message.show((Component)((Object)this), (String)exception.getMessage());
            return false;
        }
    }

    private void validateInputFields() throws ExceptionInvalidArgument {
        int n;
        String string;
        if (this.m_jCheckBoxEnabled.isSelected()) {
            try {
                string = (String)this.m_jComboBoxMinutes.getSelectedItem();
                n = Integer.parseInt(string);
                if (n < this.SESSION_MIN_TIMEOUT || n > this.SESSION_MAX_TIMEOUT) {
                    this.m_jComboBoxMinutes.requestFocus();
                    Object[] objectArray = new Object[]{JPanelSessionsSettings.removeColon((String)this.m_jLabelMinutes.getText()), this.SESSION_MIN_TIMEOUT, this.SESSION_MAX_TIMEOUT};
                    String string2 = JPanelSessionsSettings.getResourceString((ResourceManager)res, (String)"JPanelSessionsSettings_Timeout_value_entered", (Object[])objectArray);
                    throw new ExceptionInvalidArgument(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.m_jComboBoxMinutes.requestFocus();
                Object[] objectArray = new Object[]{JPanelSessionsSettings.removeColon((String)this.m_jLabelMinutes.getText()), this.SESSION_MIN_TIMEOUT, this.SESSION_MAX_TIMEOUT};
                String string3 = JPanelSessionsSettings.getResourceString((ResourceManager)res, (String)"JPanelSessionsSettings_Timeout_value_entered", (Object[])objectArray);
                throw new ExceptionInvalidArgument(string3);
            }
        }
        if (this.m_bPreemptionWarningSupported && this.m_jcbPreemptionEnable.isSelected()) {
            try {
                string = (String)this.m_jComboBoxPreemptionSeconds.getSelectedItem();
                n = Integer.parseInt(string);
                if (n < this.PREEMPTION_MIN_TIMEOUT || n > this.PREEMPTION_MAX_TIMEOUT) {
                    this.m_jComboBoxPreemptionSeconds.requestFocus();
                    Object[] objectArray = new Object[]{JPanelSessionsSettings.removeColon((String)this.m_jlPreemptionSeconds.getText()), this.PREEMPTION_MIN_TIMEOUT, this.PREEMPTION_MAX_TIMEOUT};
                    String string4 = JPanelSessionsSettings.getResourceString((ResourceManager)res, (String)"JPanelSessionsSettings_Timeout_value_entered", (Object[])objectArray);
                    throw new ExceptionInvalidArgument(string4);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.m_jComboBoxPreemptionSeconds.requestFocus();
                Object[] objectArray = new Object[]{JPanelSessionsSettings.removeColon((String)this.m_jlPreemptionSeconds.getText())};
                String string5 = JPanelSessionsSettings.getResourceString((ResourceManager)res, (String)"JPanelSessionsSettings_Timeout_value_must_be", (Object[])objectArray);
                throw new ExceptionInvalidArgument(string5);
            }
        }
        if (this.m_bLoginTimeout) {
            try {
                string = (String)this.m_jComboBoxTimeoutSeconds.getSelectedItem();
                n = Integer.parseInt(string);
                if (n < this.LOGIN_TIMEOUT_START || n > this.LOGIN_TIMEOUT_END) {
                    this.m_jComboBoxTimeoutSeconds.requestFocus();
                    Object[] objectArray = new Object[]{JPanelSessionsSettings.removeColon((String)this.m_jlTimeoutSeconds.getText()), this.LOGIN_TIMEOUT_START, this.LOGIN_TIMEOUT_END};
                    String string6 = JPanelSessionsSettings.getResourceString((ResourceManager)res, (String)"JPanelSessionsSettings_Timeout_value_entered", (Object[])objectArray);
                    throw new ExceptionInvalidArgument(string6);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.m_jComboBoxTimeoutSeconds.requestFocus();
                Object[] objectArray = new Object[]{JPanelSessionsSettings.removeColon((String)this.m_jlTimeoutSeconds.getText()), this.LOGIN_TIMEOUT_START, this.LOGIN_TIMEOUT_END};
                String string7 = JPanelSessionsSettings.getResourceString((ResourceManager)res, (String)"JPanelSessionsSettings_Timeout_value_must_be", (Object[])objectArray);
                throw new ExceptionInvalidArgument(string7);
            }
        }
    }

    private void setKBMEncryptionLevels(InterfaceValueObject[][] interfaceValueObjectArray) throws Exception {
        if (interfaceValueObjectArray.length != 3) {
            throw new Exception(res.getString("JPanelSessionsSettings_ENUM_Encryption_init_eror"));
        }
        NameValue nameValue = (NameValue)interfaceValueObjectArray[0][1].getValue();
        if ((Integer)nameValue.getValue() == 2) {
            this.m_cbKBMDES.setSelected(true);
        } else {
            this.m_cbKBMDES.setSelected(false);
        }
        nameValue = (NameValue)interfaceValueObjectArray[1][1].getValue();
        if ((Integer)nameValue.getValue() == 2) {
            this.m_cbKBM3DES.setSelected(true);
        } else {
            this.m_cbKBM3DES.setSelected(false);
        }
        nameValue = (NameValue)interfaceValueObjectArray[2][1].getValue();
        if ((Integer)nameValue.getValue() == 2) {
            this.m_cbKBM128.setSelected(true);
        } else {
            this.m_cbKBM128.setSelected(false);
        }
    }

    private void setVideoEncryptionLevels(InterfaceValueObject[][] interfaceValueObjectArray) throws Exception {
        if (interfaceValueObjectArray.length != 3) {
            throw new Exception(res.getString("JPanelSessionsSettings_ENUM_Encryption_init_eror"));
        }
        NameValue nameValue = (NameValue)interfaceValueObjectArray[0][1].getValue();
        if ((Integer)nameValue.getValue() == 2) {
            this.m_cbVideoDES.setSelected(true);
        } else {
            this.m_cbVideoDES.setSelected(false);
        }
        nameValue = (NameValue)interfaceValueObjectArray[1][1].getValue();
        if ((Integer)nameValue.getValue() == 2) {
            this.m_cbVideo3DES.setSelected(true);
        } else {
            this.m_cbVideo3DES.setSelected(false);
        }
        nameValue = (NameValue)interfaceValueObjectArray[2][1].getValue();
        if ((Integer)nameValue.getValue() == 2) {
            this.m_cbVideo128.setSelected(true);
        } else {
            this.m_cbVideo128.setSelected(false);
        }
    }

    private void addEventListeners() {
        this.m_LEnableItem = new EnableItemL();
        this.m_jCheckBoxEnabled.addItemListener(this.m_LEnableItem);
        this.m_jcbPreemptionEnable.addItemListener(this.m_LEnableItem);
        this.m_ilMinutes = new MinutesItemListener();
        this.m_jComboBoxMinutes.addItemListener((ItemListener)this.m_ilMinutes);
        this.m_jComboBoxPreemptionSeconds.addItemListener((ItemListener)this.m_ilMinutes);
        this.elItemListener = new EncryptionLevelItemListener();
        this.m_cbKBMDES.addItemListener(this.elItemListener);
        this.m_cbKBM3DES.addItemListener(this.elItemListener);
        this.m_cbKBM128.addItemListener(this.elItemListener);
        if (this.m_bVideoEncSupported) {
            this.m_cbVideoDES.addItemListener(this.m_LEnableItem);
            this.m_cbVideo3DES.addItemListener(this.m_LEnableItem);
            this.m_cbVideo128.addItemListener(this.m_LEnableItem);
        }
        if (this.m_bConnectionSharingSupported) {
            this.m_LShareMode = new ShareModeL();
            this.m_cbEnableSharing.addItemListener(this.m_LShareMode);
            this.m_cbAutoSharing.addItemListener(this.m_LEnableItem);
            this.m_cbExclusive.addItemListener(this.m_LEnableItem);
            this.m_cbStealth.addItemListener(this.m_LEnableItem);
            this.m_kbInCtrlTO.addItemListener((ItemListener)this.m_LEnableItem);
        }
        TimeoutKeyListener timeoutKeyListener = new TimeoutKeyListener();
        ((JTextField)this.m_jComboBoxMinutes.getEditor().getEditorComponent()).addKeyListener(timeoutKeyListener);
        ((JTextField)this.m_jComboBoxPreemptionSeconds.getEditor().getEditorComponent()).addKeyListener(timeoutKeyListener);
        ((JTextField)this.m_kbInCtrlTO.getEditor().getEditorComponent()).addKeyListener(timeoutKeyListener);
        if (this.m_bLoginTimeout) {
            this.m_logTimeoutListener = new LoginTimeoutL();
            this.m_jComboBoxTimeoutSeconds.addItemListener((ItemListener)this.m_logTimeoutListener);
            ((JTextField)this.m_jComboBoxTimeoutSeconds.getEditor().getEditorComponent()).addKeyListener(timeoutKeyListener);
        }
    }

    private void removeEventListeners() {
        int n;
        this.logInfo("removing listeners from components");
        if (this.m_ilMinutes != null) {
            this.m_jComboBoxMinutes.removeItemListener((ItemListener)this.m_ilMinutes);
            this.m_jComboBoxPreemptionSeconds.removeItemListener((ItemListener)this.m_ilMinutes);
            this.m_ilMinutes = null;
        }
        if (this.m_LEnableItem != null) {
            this.m_jCheckBoxEnabled.removeItemListener(this.m_LEnableItem);
            this.m_jcbPreemptionEnable.removeItemListener(this.m_LEnableItem);
            this.m_cbVideoDES.removeItemListener(this.m_LEnableItem);
            this.m_cbVideo3DES.removeItemListener(this.m_LEnableItem);
            this.m_cbVideo128.removeItemListener(this.m_LEnableItem);
            this.m_LEnableItem = null;
        }
        if (this.m_LShareMode != null) {
            this.m_cbEnableSharing.removeItemListener(this.m_LShareMode);
            this.m_LShareMode = null;
        }
        if (this.elItemListener != null) {
            this.m_cbKBMDES.removeItemListener(this.elItemListener);
            this.m_cbKBM3DES.removeItemListener(this.elItemListener);
            this.m_cbKBM128.removeItemListener(this.elItemListener);
            this.elItemListener = null;
        }
        KeyListener[] keyListenerArray = this.m_jComboBoxMinutes.getEditor().getEditorComponent().getKeyListeners();
        for (n = 0; n < keyListenerArray.length; ++n) {
            this.m_jComboBoxMinutes.getEditor().getEditorComponent().removeKeyListener(keyListenerArray[n]);
        }
        keyListenerArray = this.m_jComboBoxPreemptionSeconds.getEditor().getEditorComponent().getKeyListeners();
        for (n = 0; n < keyListenerArray.length; ++n) {
            this.m_jComboBoxPreemptionSeconds.getEditor().getEditorComponent().removeKeyListener(keyListenerArray[n]);
        }
        keyListenerArray = this.m_kbInCtrlTO.getEditor().getEditorComponent().getKeyListeners();
        for (n = 0; n < keyListenerArray.length; ++n) {
            this.m_kbInCtrlTO.getEditor().getEditorComponent().removeKeyListener(keyListenerArray[n]);
        }
        if (this.m_bLoginTimeout) {
            this.m_jComboBoxTimeoutSeconds.removeItemListener((ItemListener)this.m_logTimeoutListener);
            this.m_logTimeoutListener = null;
        }
    }

    private void setFieldAccess() {
        boolean bl = this.m_jCheckBoxEnabled.isSelected();
        this.m_jComboBoxMinutes.setEnabled(bl);
        bl = this.m_jcbPreemptionEnable.isSelected();
        this.m_jComboBoxPreemptionSeconds.setEnabled(bl);
    }

    private void setErrorFieldFocus(Object[] objectArray, int n) {
        if (n > -1 && n < objectArray.length) {
            if (objectArray[n].equals("avocent.ds.dsManagement.dsSession.dsSessionTimeout.0")) {
                this.m_szErrorLabel = this.m_jLabelMinutes.getText();
                this.m_jComboBoxMinutes.requestFocus();
            } else {
                this.m_szErrorLabel = null;
                this.logError("Unknown error index=" + n);
            }
            this.m_szErrorLabel = JPanelSessionsSettings.removeColon((String)this.m_szErrorLabel);
        }
    }

    private boolean checkKBMEncryptionSelection() {
        if (!(this.m_cbKBM128.isSelected() || this.m_cbKBMDES.isSelected() || this.m_cbKBM3DES.isSelected())) {
            Object[] objectArray = new Object[]{AVWorksBranding.getString((String)"vsvProductName", (String)res.getString("JPanelSessionsSettings_Video_Session_Viewer"))};
            String string = MessageFormat.format(res.getString("JPanelSessionsSettings_ENUM_Encryption_error"), objectArray);
            Message.show((Component)this.m_acController.getMainFrame(), (String)string);
            this.logInfo("no encryption levels are selected, disable the apply and ok buttons");
            this.m_bIsModified = false;
            return false;
        }
        return true;
    }

    class LoginTimeoutL
    implements ItemListener {
        LoginTimeoutL() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JPanelSessionsSettings.this.setIsModified(true);
        }
    }

    class ShareModeL
    implements ItemListener {
        ShareModeL() {
        }

        public final void itemStateChanged(ItemEvent itemEvent) {
            JPanelSessionsSettings.this.m_cbAutoSharing.setEnabled(JPanelSessionsSettings.this.m_cbEnableSharing.isSelected());
            JPanelSessionsSettings.this.m_cbExclusive.setEnabled(JPanelSessionsSettings.this.m_cbEnableSharing.isSelected());
            JPanelSessionsSettings.this.m_cbStealth.setEnabled(JPanelSessionsSettings.this.m_cbEnableSharing.isSelected());
            JPanelSessionsSettings.this.m_kbInCtrlTO.setEnabled(JPanelSessionsSettings.this.m_cbEnableSharing.isSelected());
            JPanelSessionsSettings.this.setIsModified(true);
        }
    }

    class EnableItemL
    implements ItemListener {
        EnableItemL() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JPanelSessionsSettings.this.setFieldAccess();
            JPanelSessionsSettings.this.setIsModified(true);
        }
    }

    class EncryptionLevelItemListener
    implements ItemListener {
        EncryptionLevelItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = JPanelSessionsSettings.this.checkKBMEncryptionSelection();
            if (bl) {
                JPanelSessionsSettings.this.setIsModified(true);
            } else {
                JCheckBox jCheckBox = (JCheckBox)itemEvent.getItem();
                jCheckBox.setSelected(true);
            }
        }
    }

    class MinutesItemListener
    implements ItemListener {
        MinutesItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JPanelSessionsSettings.this.setIsModified(true);
        }
    }

    class TimeoutKeyListener
    implements KeyListener {
        TimeoutKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            JPanelSessionsSettings.this.setIsModified(true);
        }

        public void keyReleased(KeyEvent keyEvent) {
            JPanelSessionsSettings.this.setIsModified(true);
        }

        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (c != '\b' && c != '.') {
                if (c < '0' || c > '9') {
                    keyEvent.consume();
                }
                JPanelSessionsSettings.this.setIsModified(true);
            }
        }
    }
}

