/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AbstractTableModelAssignSwitches;
import com.avocent.avworks.nmm.avr.AbstractTableModelExistingSwitches;
import com.avocent.avworks.nmm.avr.AvrAssignSwitchInfo;
import com.avocent.avworks.nmm.avr.AvrDatabaseHelper;
import com.avocent.avworks.nmm.avr.AvrRipInfo;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.avr.AvrSwitchInfo;
import com.avocent.avworks.nmm.avr.JComboBoxCellRenderer;
import com.avocent.avworks.nmm.avr.JDialogCascadeSwitch;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.ExceptionAsmpRequestFailed;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksEventBroadcaster;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.ConnectionPath;
import com.avocent.avworks.services.InterfaceAVWorksEventBroadcasterListener;
import com.avocent.avworks.services.InterfaceInfo;
import com.avocent.avworks.services.InterfacesDb;
import com.avocent.avworks.services.ProductInfo;
import com.avocent.avworks.services.ProductsDb;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.ServersDb;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.JTableAvocent;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.renderers.DefaultTableCellRendererIconName;
import com.avocent.lib.gui.renderers.TableCellRendererNoFocus;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class JPanelSettingsCascadeSwitches
extends JPanelAmpPanel
implements InterfaceAVWorksEventBroadcasterListener {
    public static final String CNAME = "JPanelSettingsCascadeSwitches";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    protected static int INITIAL_SORT_COLUMN_NUM = 0;
    protected static int AVCT_STD_TABLE_FEATURE_LEVEL = 1;
    JLabel jLabelAssignSwitch = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JLabel jLabelExistingSwitches = new JLabel();
    JScrollPane jScrollPane2 = new JScrollPane();
    JButton jButtonModify = new JButton();
    JButton jButtonDelete = new JButton();
    JButton jButtonAdd = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    AbstractTableModelExistingSwitches m_atmes = new AbstractTableModelExistingSwitches();
    AbstractTableModelAssignSwitches m_atmas = new AbstractTableModelAssignSwitches();
    JTableAvocent jTableAssignSwitches = new JTableAvocent((TableModel)this.m_atmas);
    JTableAvocent jTableExistingSwitches = new JTableAvocent((TableModel)this.m_atmes);
    private static final int TABLE_ROW_HEIGHT = 24;
    private static final int TABLE_ROW_MARGIN = 5;
    JComboBoxCellRenderer m_jcbCellRenderer = new JComboBoxCellRenderer();
    JComboBoxCellRenderer m_jcbCellRendererEdit = new JComboBoxCellRenderer();
    private CellRendererItemListener cellRendererItemListener = null;
    private AvrRipInfo[] m_adri;
    private ExistingSwitchesSelectionListener existingSwitchListener = null;

    public JPanelSettingsCascadeSwitches() throws ExceptionConstructorFailed {
        super(null, AVWorksBranding.getCascadeSwitchName((boolean)false), AVWorksBranding.getCascadeSwitchName((boolean)false), "", "IDH_SETTINGS_TAB_CASCADE_SWITCHES");
        try {
            String string = res.getString("JPanelSettingsCascadeSwitches_Configure_0_");
            Object[] objectArray = new Object[]{AVWorksBranding.getCascadeSwitchName((boolean)false)};
            this.m_szDescription = MessageFormat.format(string, objectArray);
            this.jbInit();
        }
        catch (Exception exception) {
            String string = res.getString("JPanelSettingsCascadeSwitches_Failed_to_construct");
            Object[] objectArray = new Object[]{AVWorksBranding.getCascadeSwitchName((boolean)false)};
            string = MessageFormat.format(string, objectArray);
            this.logError(string, exception);
            throw new ExceptionConstructorFailed(string);
        }
    }

    public JPanelSettingsCascadeSwitches(AmpController ampController) throws ExceptionConstructorFailed {
        super(ampController, AVWorksBranding.getCascadeSwitchName((boolean)false), AVWorksBranding.getCascadeSwitchName((boolean)false), "", "IDH_SETTINGS_TAB_CASCADE_SWITCHES");
        try {
            String string = res.getString("JPanelSettingsCascadeSwitches_Configure_0_");
            Object[] objectArray = new Object[]{AVWorksBranding.getCascadeSwitchName((boolean)false)};
            this.m_szDescription = MessageFormat.format(string, objectArray);
            this.jbInit();
        }
        catch (Exception exception) {
            String string = res.getString("JPanelSettingsCascadeSwitches_Failed_to_construct");
            Object[] objectArray = new Object[]{AVWorksBranding.getCascadeSwitchName((boolean)false)};
            string = MessageFormat.format(string, objectArray);
            this.logError(string, exception);
            throw new ExceptionConstructorFailed(string);
        }
    }

    public void createPanelComponents() throws Exception {
        this.setupExistingSwitchesTable();
        this.setupAssignSwitchesTable();
        int[] nArray = new int[]{10, 3, 2, 13};
        AVWorksEventBroadcaster.addListener((InterfaceAVWorksEventBroadcasterListener)this, (int[])nArray);
    }

    private void setupExistingSwitchesTable() {
        this.jTableExistingSwitches.getTableHeader().setReorderingAllowed(false);
        this.jTableExistingSwitches.setShowGrid(false);
        this.jTableExistingSwitches.setIntercellSpacing(new Dimension(0, 0));
        this.existingSwitchListener = new ExistingSwitchesSelectionListener();
        this.jTableExistingSwitches.getSelectionModel().addListSelectionListener(this.existingSwitchListener);
    }

    private void setupAssignSwitchesTable() {
        this.jTableAssignSwitches.setRowSelectionAllowed(false);
        this.jTableAssignSwitches.getTableHeader().setReorderingAllowed(false);
        this.jTableAssignSwitches.setShowGrid(false);
        this.jTableAssignSwitches.setIntercellSpacing(new Dimension(0, 0));
        this.jTableAssignSwitches.setRowHeight(24);
        this.jTableAssignSwitches.setRowMargin(5);
        TableColumn tableColumn = this.jTableAssignSwitches.getColumnModel().getColumn(3);
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(0);
        this.jTableAssignSwitches.setAutoResizeMode(1);
        tableColumn.setCellRenderer((TableCellRenderer)new DefaultTableCellRendererIconName());
        TableColumn tableColumn2 = this.jTableAssignSwitches.getColumnModel().getColumn(2);
        tableColumn2.setCellRenderer(this.m_jcbCellRenderer);
        tableColumn2.setCellEditor(new DefaultCellEditor(this.m_jcbCellRendererEdit));
        TableCellRendererNoFocus tableCellRendererNoFocus = new TableCellRendererNoFocus();
        TableColumn tableColumn3 = this.jTableAssignSwitches.getColumnModel().getColumn(1);
        tableColumn3.setCellRenderer((TableCellRenderer)tableCellRendererNoFocus);
        TableColumn tableColumn4 = this.jTableAssignSwitches.getColumnModel().getColumn(0);
        tableColumn4.setCellRenderer((TableCellRenderer)tableCellRendererNoFocus);
        this.cellRendererItemListener = new CellRendererItemListener();
        this.m_jcbCellRendererEdit.addItemListener(this.cellRendererItemListener);
    }

    private void jbInit() throws Exception {
        String string = AVWorksBranding.getCascadeSwitchName((boolean)true);
        Object[] objectArray = new Object[]{string};
        String string2 = MessageFormat.format(res.getString("JPanelSettingsCascadeSwitches_Assign_Switch0_"), objectArray);
        this.jLabelAssignSwitch.setText(string2);
        this.getContentPane().setLayout(this.gridBagLayout1);
        String string3 = AVWorksBranding.getCascadeSwitchName((boolean)false);
        Object[] objectArray2 = new Object[]{string3};
        string2 = MessageFormat.format(res.getString("JPanelSettingsCascadeSwitches_Existing_Switches0_"), objectArray2);
        this.jLabelExistingSwitches.setText(string2);
        this.jButtonModify.setMargin(new Insets(0, 5, 0, 5));
        this.jButtonModify.setText(res.getString("JPanelSettingsCascadeSwitches_Modify_"));
        this.jButtonDelete.setMargin(new Insets(0, 5, 0, 5));
        this.jButtonDelete.setText(res.getString("JPanelSettingsCascadeSwitches_Delete"));
        this.jButtonAdd.setMargin(new Insets(0, 5, 0, 5));
        this.jButtonAdd.setText(res.getString("JPanelSettingsCascadeSwitches_Add_"));
        this.jScrollPane2.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.jScrollPane2.setPreferredSize(new Dimension(350, 40));
        this.jScrollPane1.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.jScrollPane1.setPreferredSize(new Dimension(350, 40));
        this.jTableAssignSwitches.setBackground(UIManager.getColor("Table.background"));
        this.jTableExistingSwitches.setBackground(UIManager.getColor("Table.background"));
        this.getContentPane().add((Component)this.jLabelAssignSwitch, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 247), 0, 0));
        this.getContentPane().add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 2, 1, 0.5, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.jTableAssignSwitches, null);
        this.getContentPane().add((Component)this.jLabelExistingSwitches, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 0, 0, 227), 0, 0));
        this.getContentPane().add((Component)this.jScrollPane2, new GridBagConstraints(0, 3, 1, 3, 0.5, 0.0, 18, 1, new Insets(0, 0, 0, 11), 0, 0));
        this.jScrollPane2.getViewport().add((Component)this.jTableExistingSwitches, null);
        this.getContentPane().add((Component)this.jButtonAdd, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jButtonDelete, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(1, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jButtonModify, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(1, 0, 0, 0), 0, 0));
        this.jTableAssignSwitches.setAvctStdTableFeatures(AVCT_STD_TABLE_FEATURE_LEVEL);
        this.jTableAssignSwitches.enableAvctStdTableFeatures();
        this.jTableExistingSwitches.setAvctStdTableFeatures(AVCT_STD_TABLE_FEATURE_LEVEL);
        this.jTableExistingSwitches.enableAvctStdTableFeatures();
    }

    public boolean initialize() {
        try {
            this.removeEventListeners();
            this.createPanelComponents();
            Vector vector = this.getSwitchesFromDB(this.m_acController.getApplianceInfo());
            this.m_atmes.setTableData(vector);
            this.updateAssignSwitchTable(true);
            this.jButtonModify.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
            this.enableDisableAddButton();
            this.jTableAssignSwitches.sortTableData(INITIAL_SORT_COLUMN_NUM);
            this.jTableExistingSwitches.sortTableData(INITIAL_SORT_COLUMN_NUM);
            this.addEventListeners();
            return true;
        }
        catch (ExceptionAsmpRequestFailed exceptionAsmpRequestFailed) {
            this.m_nErrorStatus = exceptionAsmpRequestFailed.getErrorCode();
            this.logError(exceptionAsmpRequestFailed.getMessage(), (Exception)((Object)exceptionAsmpRequestFailed));
            return false;
        }
        catch (Exception exception) {
            this.logError(exception.getMessage(), exception);
            return false;
        }
    }

    protected boolean applyValues() {
        boolean bl = false;
        ArrayList<ApplianceInfo> arrayList = new ArrayList<ApplianceInfo>();
        try {
            int n;
            Object object;
            String string;
            Object object2;
            Object object3;
            Vector vector = this.m_atmes.getTableData();
            boolean bl2 = false;
            Vector<AvrAssignSwitchInfo[]> vector2 = new Vector<AvrAssignSwitchInfo[]>();
            for (int i = 0; i < vector.size(); ++i) {
                object3 = (AvrSwitchInfo)vector.elementAt(i);
                if (object3.getAttachedRipIDs().length == 0) {
                    bl2 = true;
                    continue;
                }
                vector2.addElement((AvrAssignSwitchInfo[])object3);
            }
            if (bl2) {
                String string2 = AVWorksBranding.getCascadeSwitchName((boolean)true);
                object3 = AVWorksBranding.getDsrIqName((boolean)false);
                Object[] objectArray = new Object[]{string2, object3, string2};
                object2 = new Object[]{string2};
                string = MessageFormat.format(res.getString("JPanelSettingsCascadeSwitches_Switch_Not_Assigned"), objectArray);
                object = MessageFormat.format(res.getString("JPanelSettingsCascadeSwitches_Switch_Not_Assigned_Title"), (Object[])object2);
                n = JOptionPaneFixedSize.showConfirmDialog((Component)this.getParent(), (Object)string, (String)object, (int)0, (int)2);
                if (n != 0) {
                    return false;
                }
            }
            Object[] objectArray = new AvrSwitchInfo[vector2.size()];
            vector2.copyInto(objectArray);
            this.m_atmes.setTableData(vector2);
            if (objectArray != null) {
                if (AvrDatabaseHelper.deleteSwitchesFromDB(this.m_acController.getApplianceInfo().getID(), (AvrSwitchInfo[])objectArray)) {
                    bl = true;
                }
            } else {
                objectArray = new AvrSwitchInfo[]{};
            }
            object3 = this.m_atmas.getTableData();
            for (int i = 0; i < ((AvrAssignSwitchInfo[])object3).length; ++i) {
                object2 = object3[i];
                string = AvrDatabaseHelper.getInterfaceObjectFromDB(this.m_acController.getApplianceInfo().getID(), ((AvrAssignSwitchInfo)object2).getRipID());
                object = AvrDatabaseHelper.getSwitchForRip(((AvrAssignSwitchInfo)object2).getRipID(), (AvrSwitchInfo[])objectArray);
                if (object != null) {
                    int n2;
                    int n3;
                    Object object4;
                    n = ((AvrSwitchInfo)object).getSwitchID();
                    if (n == 0) {
                        if (AppliancesDb.isNameDefined((String)((AvrSwitchInfo)object).getSwitchName())) {
                            object4 = "WHERE (AMP=" + Integer.toString(0) + ")" + " AND" + " (NAME=" + SqlCmd.quote((String)((AvrSwitchInfo)object).getSwitchName()) + ")";
                            ApplianceInfo[] applianceInfoArray = AppliancesDb.getAllAppliances((String)object4);
                            n = applianceInfoArray[0].getID();
                        } else {
                            int n4 = ((AvrSwitchInfo)object).getSwitchType();
                            ProductInfo productInfo = ProductsDb.getProductInfo((int)n4);
                            ApplianceInfo applianceInfo = new ApplianceInfo(0, ((AvrSwitchInfo)object).getSwitchName(), productInfo.getName(), n4, "", "", "", "", productInfo.getNmmID(), false);
                            n = AppliancesDb.add((ApplianceInfo)applianceInfo);
                            bl = true;
                            n3 = AvrDatabaseHelper.getSwitchPortCount(n4);
                            for (n2 = 1; n2 <= n3; ++n2) {
                                InterfacesDb.add((int)n, (String)AvrDatabaseHelper.formatChannelName(n2));
                            }
                        }
                    }
                    if (!(object4 = AppliancesDb.getApplianceInfo((int)n)).getName().equals(((AvrSwitchInfo)object).getSwitchName())) {
                        AppliancesDb.rename((int)n, (String)((AvrSwitchInfo)object).getSwitchName());
                        object4 = AppliancesDb.getApplianceInfo((int)n);
                        arrayList.add((ApplianceInfo)object4);
                        bl = true;
                    }
                    if (object4.getProductID() != ((AvrSwitchInfo)object).getSwitchType()) {
                        int n5 = AvrDatabaseHelper.getSwitchPortCount(object4.getProductID());
                        int n6 = AvrDatabaseHelper.getSwitchPortCount(((AvrSwitchInfo)object).getSwitchType());
                        if (n6 < n5) {
                            for (n3 = n6 + 1; n3 <= n5; ++n3) {
                                Object object5;
                                InterfaceInfo interfaceInfo;
                                try {
                                    interfaceInfo = AvrDatabaseHelper.getInterfaceObjectFromDB(object4.getID(), AvrDatabaseHelper.formatChannelName(n3));
                                }
                                catch (ExceptionNoValue exceptionNoValue) {
                                    Trace.logInfo((String)"JPanelSettingsCascadeSwitches:applyValues", (String)"No interface value");
                                    continue;
                                }
                                try {
                                    object5 = ServersDb.getServerInfo((int)interfaceInfo.getConnID());
                                    if (AvrDatabaseHelper.deleteServer((int)interfaceInfo.getConnID())) {
                                        bl = true;
                                        AVWorksEventBroadcaster.appendDeletedServers((UnitInfo[])new UnitInfo[]{object5});
                                    }
                                }
                                catch (ExceptionNoValue exceptionNoValue) {
                                    Trace.logInfo((String)"JPanelSettingsCascadeSwitches:applyValues", (String)"No matching server for interface");
                                }
                                object5 = new int[1];
                                object5[0] = (ServerInfo)interfaceInfo.getID();
                                InterfacesDb.delete((int[])object5);
                                arrayList.add((ApplianceInfo)object4);
                                bl = true;
                            }
                        } else if (n6 > n5) {
                            for (n3 = n5 + 1; n3 <= n6; ++n3) {
                                n2 = InterfacesDb.add((int)object4.getID(), (String)AvrDatabaseHelper.formatChannelName(n3));
                                arrayList.add((ApplianceInfo)object4);
                                bl = true;
                            }
                        }
                        object4.setProductID(((AvrSwitchInfo)object).getSwitchType());
                        object4.setType(((AvrSwitchInfo)object).getSwitchTypeStr());
                        AppliancesDb.modify((ApplianceInfo)object4);
                        bl = true;
                    }
                    string.setConnID(n);
                    string.setConnType(2);
                    InterfacesDb.modify((InterfaceInfo)string);
                    bl = true;
                    continue;
                }
                if (string.getConnType() != 2) continue;
                string.setConnID(0);
                string.setConnType(0);
                InterfacesDb.modify((InterfaceInfo)string);
                bl = true;
            }
            if (bl) {
                UnitInfo[] unitInfoArray = this.removedDuplicatesAppliances(arrayList);
                AVWorksEventBroadcaster.fireDatabaseAppliancesModifiedEvent((UnitInfo[])unitInfoArray);
                AVWorksEventBroadcaster.fireDatabaseServersDeletedEvent();
                AVWorksEventBroadcaster.fireDatabaseModifiedEvent();
            }
            return true;
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)exception.getMessage(), (Throwable)exception);
            Message.show((Component)((Object)this), (String)res.getString("JPanelSettingsCascadeSwitches_There_was_an_error"));
            return false;
        }
    }

    private UnitInfo[] removedDuplicatesAppliances(ArrayList arrayList) {
        UnitInfo unitInfo;
        int n;
        Object[] objectArray = arrayList.toArray();
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            ApplianceInfo applianceInfo = (ApplianceInfo)objectArray[i];
            for (n = i + 1; n < objectArray.length && applianceInfo != null; ++n) {
                unitInfo = (ApplianceInfo)objectArray[n];
                if (applianceInfo.getID() != unitInfo.getID()) continue;
                objectArray[n] = null;
            }
            if (applianceInfo == null) continue;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        UnitInfo[] unitInfoArray = new UnitInfo[n2];
        int n3 = 0;
        for (n = 0; n < objectArray.length; ++n) {
            unitInfo = (UnitInfo)objectArray[n];
            if (unitInfo == null) continue;
            unitInfoArray[n3++] = unitInfo;
        }
        return unitInfoArray;
    }

    public void onDestroy() {
        this.logInfo("onDestroy() was called.");
        try {
            AVWorksEventBroadcaster.removeListener((InterfaceAVWorksEventBroadcasterListener)this);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
    }

    public Vector getSwitchesFromDB(ApplianceInfo applianceInfo) throws ExceptionNoValue, ExceptionRequestFailed {
        Vector<AvrSwitchInfo> vector = new Vector<AvrSwitchInfo>();
        try {
            String string = "WHERE AMP=" + Integer.toString(0);
            ApplianceInfo[] applianceInfoArray = AppliancesDb.getAllAppliances((String)string);
            for (int i = 0; i < applianceInfoArray.length; ++i) {
                Object object;
                int n = ConnectionPath.parseSwitchNameForParentID((String)applianceInfoArray[i].getName());
                if (n != applianceInfo.getID()) continue;
                Vector<String> vector2 = new Vector<String>();
                Object[] objectArray = new String[]{};
                try {
                    object = "WHERE (APPLIANCE_ID=" + Integer.toString(applianceInfo.getID()) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(2) + ")" + " AND" + " (CONN_ID=" + Integer.toString(applianceInfoArray[i].getID()) + ")";
                    InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)object);
                    for (int j = 0; j < interfaceInfoArray.length; ++j) {
                        vector2.add(interfaceInfoArray[j].getName());
                    }
                    objectArray = new String[vector2.size()];
                    vector2.copyInto(objectArray);
                }
                catch (ExceptionNoValue exceptionNoValue) {
                    Trace.logInfo((String)"JPanelResyncWizardEnterSwitchConfig:getSwitchesFromDB", (String)"No interfaces connected to switch.");
                }
                object = new AvrSwitchInfo(applianceInfoArray[i].getName(), applianceInfoArray[i].getType(), applianceInfoArray[i].getProductID(), applianceInfoArray[i].getID(), (String[])objectArray);
                vector.add((AvrSwitchInfo)object);
            }
            return vector;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            return vector;
        }
        catch (Exception exception) {
            Trace.logError((String)"JPanelResyncWizardEnterSwitchConfig:getSwitchesFromDB", (String)"Error getting switches from db.");
            throw new ExceptionRequestFailed();
        }
    }

    public AvrAssignSwitchInfo[] getAssignedSwitches(AvrRipInfo[] avrRipInfoArray) throws ExceptionRequestFailed {
        Vector vector = this.m_atmes.getTableData();
        Object[] objectArray = new AvrSwitchInfo[vector.size()];
        vector.copyInto(objectArray);
        Vector<AvrAssignSwitchInfo> vector2 = new Vector<AvrAssignSwitchInfo>();
        try {
            String string = "WHERE APPLIANCE_ID=" + Integer.toString(this.m_acController.getApplianceInfo().getID());
            InterfaceInfo[] interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string);
            for (int i = 0; i < interfaceInfoArray.length; ++i) {
                InterfaceInfo interfaceInfo = interfaceInfoArray[i];
                if (interfaceInfo.getConnType() != 2) continue;
                String string2 = res.getString("JPanelSettingsCascadeSwitches_None");
                AvrSwitchInfo avrSwitchInfo = AvrDatabaseHelper.getSwitchForRip(interfaceInfo.getName(), (AvrSwitchInfo[])objectArray);
                if (avrSwitchInfo != null) {
                    string2 = avrSwitchInfo.getSwitchName();
                }
                AvrRipInfo avrRipInfo = AvrDatabaseHelper.getRipFromRipTbl(interfaceInfo.getName(), avrRipInfoArray);
                String string3 = "";
                if (avrRipInfo != null) {
                    string3 = String.valueOf(avrRipInfo.getInputPort() + 1);
                }
                AvrAssignSwitchInfo avrAssignSwitchInfo = new AvrAssignSwitchInfo(string3, interfaceInfo.getName(), string2, false);
                vector2.add(avrAssignSwitchInfo);
            }
            Object[] objectArray2 = new AvrAssignSwitchInfo[vector2.size()];
            vector2.copyInto(objectArray2);
            return objectArray2;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            AvrAssignSwitchInfo[] avrAssignSwitchInfoArray = new AvrAssignSwitchInfo[]{};
            return avrAssignSwitchInfoArray;
        }
    }

    private void populateAssignSwitchCombo() {
        Vector vector = this.m_atmes.getTableData();
        String[] stringArray = new String[vector.size() + 1];
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            AvrSwitchInfo avrSwitchInfo = (AvrSwitchInfo)vector.elementAt(i);
            stringArray[i] = string = ConnectionPath.parseSwitchName((String)avrSwitchInfo.getSwitchName());
        }
        stringArray[vector.size()] = res.getString("JPanelSettingsCascadeSwitches_None");
        this.m_jcbCellRenderer.addItems(stringArray);
        this.m_jcbCellRendererEdit.addItems(stringArray);
        this.m_atmas.fireTableDataChanged();
    }

    private void updateAssignSwitchTable(boolean bl) throws ExceptionRequestFailed {
        if (bl) {
            this.m_adri = AvrSnmpHelper.getRipInfo(this.m_acController.getAsmpConnection());
        }
        AvrAssignSwitchInfo[] avrAssignSwitchInfoArray = this.getAssignedSwitches(this.m_adri);
        this.m_atmas.setTableData(avrAssignSwitchInfoArray);
        this.populateAssignSwitchCombo();
    }

    private void enableDisableAddButton() {
        try {
            AvrAssignSwitchInfo[] avrAssignSwitchInfoArray = this.getAssignedSwitches(this.m_adri);
            if (avrAssignSwitchInfoArray.length > 0) {
                this.jButtonAdd.setEnabled(true);
            } else {
                this.jButtonAdd.setEnabled(false);
            }
        }
        catch (Exception exception) {
            Trace.logError((String)exception.getMessage(), (String)"Unable to get the assigned switches for the Rip interfaces.");
            this.jButtonAdd.setEnabled(false);
        }
    }

    void jButtonAdd_actionPerformed(ActionEvent actionEvent) {
        try {
            AvrSwitchInfo avrSwitchInfo;
            Vector vector = this.m_atmes.getTableData();
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                avrSwitchInfo = (AvrSwitchInfo)vector.elementAt(i);
                stringArray[i] = avrSwitchInfo.getSwitchName();
            }
            JDialogCascadeSwitch jDialogCascadeSwitch = new JDialogCascadeSwitch((Frame)this.m_acController.getMainFrame(), this.m_acController.getApplianceInfo().getID(), this.m_acController.getApplianceInfo().getProductID(), null, stringArray);
            jDialogCascadeSwitch.setLocationRelativeTo((Component)((Object)this));
            jDialogCascadeSwitch.show();
            if (jDialogCascadeSwitch.wasOkPressed()) {
                avrSwitchInfo = jDialogCascadeSwitch.getSwitchInfo();
                this.m_atmes.addSwitch(avrSwitchInfo);
                this.populateAssignSwitchCombo();
                this.setIsModified(true);
            }
        }
        catch (Exception exception) {
            String string = AVWorksBranding.getCascadeSwitchName((boolean)true);
            Object[] objectArray = new Object[]{string};
            String string2 = MessageFormat.format(res.getString("JPanelSettingsCascadeSwitches_Unable_to_display_the_Add"), objectArray);
            Message.show((Component)this.getParent(), (String)string2);
        }
    }

    void jButtonModify_actionPerformed(ActionEvent actionEvent) {
        try {
            AvrSwitchInfo avrSwitchInfo;
            int n;
            Vector vector = this.m_atmes.getTableData();
            String[] stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                avrSwitchInfo = (AvrSwitchInfo)vector.elementAt(n);
                stringArray[n] = avrSwitchInfo.getSwitchName();
            }
            n = this.jTableExistingSwitches.getSelectedRow();
            n = this.jTableExistingSwitches.mapIndex(n);
            avrSwitchInfo = this.m_atmes.getSwitch(n);
            JDialogCascadeSwitch jDialogCascadeSwitch = new JDialogCascadeSwitch((Frame)this.m_acController.getMainFrame(), this.m_acController.getApplianceInfo().getID(), this.m_acController.getApplianceInfo().getProductID(), avrSwitchInfo, stringArray);
            jDialogCascadeSwitch.setLocationRelativeTo((Component)((Object)this));
            jDialogCascadeSwitch.show();
            if (jDialogCascadeSwitch.wasOkPressed()) {
                AvrSwitchInfo avrSwitchInfo2 = jDialogCascadeSwitch.getSwitchInfo();
                this.m_atmes.setSwitch(n, avrSwitchInfo2);
                this.updateAssignSwitchTable(false);
                this.setIsModified(true);
            }
        }
        catch (Exception exception) {
            String string = AVWorksBranding.getCascadeSwitchName((boolean)true);
            Object[] objectArray = new Object[]{string};
            String string2 = MessageFormat.format(res.getString("JPanelSettingsCascadeSwitches_Unable_to_display_the1"), objectArray);
            Message.show((Component)this.getParent(), (String)string2);
        }
    }

    void jButtonDelete_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.jTableExistingSwitches.getSelectedRows();
        if (nArray.length == 0) {
            Trace.logInfo((String)"JPanelResyncWizardEnterSwitchConfig:delete", (String)"no entries selected");
            return;
        }
        try {
            int n;
            Object object;
            Object object2;
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.jTableExistingSwitches.mapIndex(nArray[i]);
                object2 = this.m_atmes.getSwitch(n2);
                object = ((AvrSwitchInfo)object2).getAttachedRipIDs();
                if (((String[])object).length <= 0) continue;
                bl = true;
                break;
            }
            String string = AVWorksBranding.getCascadeSwitchName((boolean)false);
            Object[] objectArray = new Object[]{string};
            object2 = MessageFormat.format(res.getString("JPanelSettingsCascadeSwitches_Are_you_sure_you_want_to_delete_selected1"), objectArray);
            if (bl) {
                object = AVWorksBranding.getDsrIqName((boolean)false);
                String string2 = AVWorksBranding.getServerName((boolean)false);
                String string3 = AVWorksBranding.getCascadeSwitchName((boolean)true);
                Object[] objectArray2 = new Object[]{string, object, string3, string2, string3};
                object2 = MessageFormat.format(res.getString("JPanelSettingsCascadeSwitches_Are_you_sure_you_want_to_delete_selected2"), objectArray2);
            }
            if ((n = JOptionPaneFixedSize.showConfirmDialog((Component)this.getParent(), (Object)object2, (String)res.getString("JPanelSettingsCascadeSwitches_Delete"), (int)0)) != 0) {
                return;
            }
            this.m_atmes.deleteSwitch(nArray);
            this.updateAssignSwitchTable(false);
            this.setIsModified(true);
        }
        catch (Exception exception) {
            String string = AVWorksBranding.getCascadeSwitchName((boolean)false);
            Object[] objectArray = new Object[]{string};
            String string4 = MessageFormat.format(res.getString("JPanelSettingsCascadeSwitches_Unable_to_delete_the"), objectArray);
            Message.show((Component)this.getParent(), (String)string4);
        }
    }

    public void doHandleEvent(Object object, int n) {
        Trace.logInfo((String)"CascadeSwitchesEventListenerInterface:doHandleEvent", (String)("Received event ID=" + n));
        if (this.isVisible()) {
            this.initialize();
        } else {
            this.m_nState = 101;
        }
    }

    public boolean doesModifyAppliance() {
        return false;
    }

    private void addEventListeners() {
        this.jButtonModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelSettingsCascadeSwitches.this.jButtonModify_actionPerformed(actionEvent);
            }
        });
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelSettingsCascadeSwitches.this.jButtonDelete_actionPerformed(actionEvent);
            }
        });
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelSettingsCascadeSwitches.this.jButtonAdd_actionPerformed(actionEvent);
            }
        });
    }

    private void removeEventListeners() throws Exception {
        int n;
        this.logInfo("removeEventListeners() was called.");
        AVWorksEventBroadcaster.removeListener((InterfaceAVWorksEventBroadcasterListener)this);
        this.jTableExistingSwitches.getSelectionModel().removeListSelectionListener(this.existingSwitchListener);
        this.existingSwitchListener = null;
        if (this.cellRendererItemListener != null) {
            this.m_jcbCellRendererEdit.removeItemListener(this.cellRendererItemListener);
            this.cellRendererItemListener = null;
        }
        ActionListener[] actionListenerArray = this.jButtonModify.getActionListeners();
        for (n = 0; n < actionListenerArray.length; ++n) {
            this.jButtonModify.removeActionListener(actionListenerArray[n]);
        }
        actionListenerArray = this.jButtonDelete.getActionListeners();
        for (n = 0; n < actionListenerArray.length; ++n) {
            this.jButtonDelete.removeActionListener(actionListenerArray[n]);
        }
        actionListenerArray = this.jButtonAdd.getActionListeners();
        for (n = 0; n < actionListenerArray.length; ++n) {
            this.jButtonAdd.removeActionListener(actionListenerArray[n]);
        }
    }

    class CellRendererItemListener
    implements ItemListener {
        CellRendererItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                int n = JPanelSettingsCascadeSwitches.this.jTableAssignSwitches.getEditingRow();
                int n2 = JPanelSettingsCascadeSwitches.this.jTableAssignSwitches.getEditingColumn();
                if (n != -1 && n2 != -1) {
                    int n3 = JPanelSettingsCascadeSwitches.this.jTableAssignSwitches.getSelectedRow();
                    n3 = JPanelSettingsCascadeSwitches.this.jTableAssignSwitches.mapIndex(n3);
                    AvrAssignSwitchInfo avrAssignSwitchInfo = JPanelSettingsCascadeSwitches.this.m_atmas.getAssignedSwitchEntry(n3);
                    try {
                        if (((String)itemEvent.getItem()).equals(res.getString("JPanelSettingsCascadeSwitches_None"))) {
                            String string = avrAssignSwitchInfo.getAssignedSwitch();
                            int n4 = string.indexOf(58);
                            if (n4 == -1) {
                                string = JPanelSettingsCascadeSwitches.this.m_acController.getApplianceInfo().getID() + ":" + string;
                            }
                            JPanelSettingsCascadeSwitches.this.m_atmes.deleteRipFromSwitch(avrAssignSwitchInfo.getRipID(), string);
                            JPanelSettingsCascadeSwitches.this.setIsModified(true);
                            return;
                        }
                        String string = JPanelSettingsCascadeSwitches.this.m_acController.getApplianceInfo().getID() + ":" + (String)itemEvent.getItem();
                        AvrSwitchInfo avrSwitchInfo = JPanelSettingsCascadeSwitches.this.m_atmes.getSwitch(string);
                        int n5 = AvrDatabaseHelper.getSwitchUserCount(avrSwitchInfo.getSwitchType());
                        String[] stringArray = avrSwitchInfo.getAttachedRipIDs();
                        if (stringArray.length >= n5) {
                            JPanelSettingsCascadeSwitches.this.jTableAssignSwitches.getCellEditor().cancelCellEditing();
                            String string2 = AVWorksBranding.getDsrIqName((boolean)false);
                            String string3 = AVWorksBranding.getCascadeSwitchName((boolean)true);
                            Object[] objectArray = new Object[]{string2, string3};
                            String string4 = MessageFormat.format(res.getString("JPanelSettingsCascadeSwitches_The_maximum_number_attached"), objectArray);
                            Message.show((Component)JPanelSettingsCascadeSwitches.this.getParent(), (String)string4);
                            return;
                        }
                        if (!avrAssignSwitchInfo.getAssignedSwitch().equals(res.getString("JPanelSettingsCascadeSwitches_None"))) {
                            String string5 = avrAssignSwitchInfo.getAssignedSwitch();
                            int n6 = string5.indexOf(58);
                            if (n6 == -1) {
                                string5 = JPanelSettingsCascadeSwitches.this.m_acController.getApplianceInfo().getID() + ":" + string5;
                            }
                            JPanelSettingsCascadeSwitches.this.m_atmes.deleteRipFromSwitch(avrAssignSwitchInfo.getRipID(), string5);
                        }
                        JPanelSettingsCascadeSwitches.this.m_atmes.addRipToSwitch(avrAssignSwitchInfo.getRipID(), string);
                        JPanelSettingsCascadeSwitches.this.setIsModified(true);
                    }
                    catch (Exception exception) {
                        JPanelSettingsCascadeSwitches.this.jTableAssignSwitches.getCellEditor().cancelCellEditing();
                        Trace.logError((String)"JPanelResyncWizardEnterSwitchConfig:itemStateChanged", (String)"Error getting user count for switch.");
                        String string = AVWorksBranding.getDsrIqName((boolean)true);
                        String string6 = AVWorksBranding.getCascadeSwitchName((boolean)true);
                        Object[] objectArray = new Object[]{string, string6};
                        String string7 = MessageFormat.format(res.getString("JPanelSettingsCascadeSwitches_Unable_to_attach_the"), objectArray);
                        Message.show((Component)JPanelSettingsCascadeSwitches.this.getParent(), (String)string7);
                        return;
                    }
                }
            }
        }
    }

    class ExistingSwitchesSelectionListener
    implements ListSelectionListener {
        ExistingSwitchesSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = JPanelSettingsCascadeSwitches.this.jTableExistingSwitches.getSelectedRowCount();
            if (n == 0) {
                JPanelSettingsCascadeSwitches.this.jButtonModify.setEnabled(false);
                JPanelSettingsCascadeSwitches.this.jButtonDelete.setEnabled(false);
            } else if (n == 1) {
                JPanelSettingsCascadeSwitches.this.jButtonModify.setEnabled(true);
                JPanelSettingsCascadeSwitches.this.jButtonDelete.setEnabled(true);
            } else if (n > 1) {
                JPanelSettingsCascadeSwitches.this.jButtonModify.setEnabled(false);
                JPanelSettingsCascadeSwitches.this.jButtonDelete.setEnabled(true);
            }
        }
    }
}

