/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.avworks.nmm.avr;

import com.avocent.avworks.nmm.avr.AvrNmmInterface;
import com.avocent.avworks.nmm.avr.AvrResyncWizard;
import com.avocent.avworks.nmm.avr.AvrSnmpHelper;
import com.avocent.avworks.nmm.avr.AvrViewerCmdLinePathInfo;
import com.avocent.avworks.nmm.avr.JDialogModifyServerName;
import com.avocent.avworks.nmm.common.AmpController;
import com.avocent.avworks.nmm.common.InterfaceValueObject;
import com.avocent.avworks.nmm.common.JDialogMultipleConnectionWarning;
import com.avocent.avworks.nmm.common.JPanelAmpPanel;
import com.avocent.avworks.services.AVWorksBranding;
import com.avocent.avworks.services.AVWorksEventBroadcaster;
import com.avocent.avworks.services.ApplianceInfo;
import com.avocent.avworks.services.ApplianceInterface;
import com.avocent.avworks.services.AppliancesDb;
import com.avocent.avworks.services.ConnectionPath;
import com.avocent.avworks.services.InterfaceAVWorksEventBroadcasterListener;
import com.avocent.avworks.services.InterfaceInfo;
import com.avocent.avworks.services.InterfacesDb;
import com.avocent.avworks.services.ServerInfo;
import com.avocent.avworks.services.ServersDb;
import com.avocent.avworks.services.SwingWorker;
import com.avocent.avworks.services.UnitInfo;
import com.avocent.lib.database.SqlCmd;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.LaunchBrowserHelp;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.components.JTableAvocent;
import com.avocent.lib.gui.components.TableModelColumnSorted;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.renderers.TableCellRendererNoFocus;
import com.avocent.lib.util.CachedCredentials;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.videoViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class JPanelSettingsServers
extends JPanelAmpPanel
implements InterfaceAVWorksEventBroadcasterListener {
    public static final String CNAME = "JPanelSettingsServers";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.avworks.nmm.avr.Res");
    protected static int INITIAL_SORT_COLUMN_NUM = 0;
    protected static int AVCT_STD_TABLE_FEATURE_LEVEL = 1;
    JScrollPane m_jScrollPaneServers = new JScrollPane();
    JPanel m_jPanelButtons = new JPanel();
    JButton m_jButtonResync = new JButton();
    JButton m_jButtonModifyName = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    private static final int ENCRYPTION_LEVEL_ENABLED = 2;
    private static final int TABLE_ROW_HEIGHT = 24;
    private static final int TABLE_ROW_MARGIN = 5;
    TableModelServers m_atmssp = new TableModelServers();
    JTableAvocent m_jTableServers = new JTableAvocent(AVCT_STD_TABLE_FEATURE_LEVEL);
    TableModelColumnSorted m_tmcs = new TableModelColumnSorted((TableModel)this.m_atmssp, (JTable)this.m_jTableServers);
    final CellRendererConnectionPath m_dtcrConnectionPath = new CellRendererConnectionPath();
    JDialogModifyServerName m_jdModifyNameDialog = null;
    JDialogMultipleConnectionWarning m_jdMultipleConnectionDialog = null;

    public JPanelSettingsServers() throws ExceptionConstructorFailed {
        super(null, AVWorksBranding.getServerName((boolean)false), AVWorksBranding.getServerName((boolean)false), "", "IDH_SETTINGS_TAB_SERVERS");
        try {
            String string = res.getString("JPanelSettingsServers_0_connections");
            Object[] objectArray = new Object[]{AVWorksBranding.getServerName((boolean)true)};
            this.m_szDescription = MessageFormat.format(string, objectArray);
            this.createPanelComponents();
        }
        catch (Exception exception) {
            String string = res.getString("JPanelSettingsServers_Failed_to_construct");
            Object[] objectArray = new Object[]{AVWorksBranding.getServerName((boolean)false)};
            string = MessageFormat.format(string, objectArray);
            this.logError(string, exception);
            throw new ExceptionConstructorFailed(string);
        }
    }

    public JPanelSettingsServers(AmpController ampController) throws ExceptionConstructorFailed {
        super(ampController, AVWorksBranding.getServerName((boolean)false), AVWorksBranding.getServerName((boolean)false), "", "IDH_SETTINGS_TAB_SERVERS");
        try {
            String string = res.getString("JPanelSettingsServers_0_connections");
            Object[] objectArray = new Object[]{AVWorksBranding.getServerName((boolean)true)};
            this.m_szDescription = MessageFormat.format(string, objectArray);
            this.createPanelComponents();
        }
        catch (Exception exception) {
            String string = res.getString("JPanelSettingsServers_Failed_to_construct");
            Object[] objectArray = new Object[]{AVWorksBranding.getServerName((boolean)false)};
            string = MessageFormat.format(string, objectArray);
            this.logError(string, exception);
            throw new ExceptionConstructorFailed(string);
        }
    }

    public void createPanelComponents() throws Exception {
        this.jbInit();
        this.setupTable();
        ButtonPanel.equalize((JPanel)this.m_jPanelButtons);
        this.validate();
        this.m_jButtonModifyName.setEnabled(false);
        this.m_jTableServers.setSelectionMode(0);
        this.m_jTableServers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = JPanelSettingsServers.this.m_jTableServers.getSelectedRowCount() > 0;
                JPanelSettingsServers.this.m_jButtonModifyName.setEnabled(bl);
            }
        });
        int[] nArray = new int[]{5, 10, 3, 2, 8};
        AVWorksEventBroadcaster.addListener((InterfaceAVWorksEventBroadcasterListener)this, (int[])nArray);
    }

    private void setupTable() {
        this.m_jTableServers.setRowSelectionAllowed(false);
        this.m_jTableServers.getTableHeader().setReorderingAllowed(false);
        this.m_jTableServers.setShowGrid(false);
        this.m_jTableServers.setRowHeight(24);
        this.m_jTableServers.setRowMargin(5);
        this.m_jTableServers.setInitialSortColumn(INITIAL_SORT_COLUMN_NUM);
        this.m_jTableServers.doInitialColumnSorting();
        TableColumn tableColumn = this.m_jTableServers.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.m_jTableServers.getColumnModel().getColumn(1);
        TableCellRendererNoFocus tableCellRendererNoFocus = new TableCellRendererNoFocus();
        tableColumn.setCellRenderer(this.m_dtcrConnectionPath);
        this.createTableMouseListeners();
    }

    private void createTableMouseListeners() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() != 16) {
                    Trace.logInfo((String)"JPanelSettingsServers:mousePressed", (String)("Modifiers = " + mouseEvent.getModifiers()));
                    return;
                }
                Point point = mouseEvent.getPoint();
                int n = JPanelSettingsServers.this.m_jTableServers.columnAtPoint(point);
                int n2 = JPanelSettingsServers.this.m_jTableServers.rowAtPoint(point);
                if (n == 0 && JPanelSettingsServers.this.m_dtcrConnectionPath.isMouseOverCellText()) {
                    int n3 = JPanelSettingsServers.this.m_tmcs.getSortedRowIndexAt(n2);
                    ConnectionPathInfo connectionPathInfo = JPanelSettingsServers.this.m_atmssp.getConnectionPathAtIndex(n3);
                    Thread thread = new Thread(new Runnable(this, connectionPathInfo){
                        private final /* synthetic */ ConnectionPathInfo val$sscpi;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$sscpi = connectionPathInfo;
                        }

                        public void run() {
                            JPanelSettingsServers.access$200(2.access$100(this.this$1), this.val$sscpi);
                        }
                    });
                    thread.start();
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                JPanelSettingsServers.this.getContentPane().setCursor(Cursor.getPredefinedCursor(0));
                JPanelSettingsServers.this.m_dtcrConnectionPath.setMouseOverRowCol(-1, -1);
                JPanelSettingsServers.this.m_dtcrConnectionPath.setMouseOverCellText(false);
                JPanelSettingsServers.this.m_jTableServers.repaint();
            }

            static /* synthetic */ JPanelSettingsServers access$100(2 var0) {
                return var0.JPanelSettingsServers.this;
            }
        };
        this.m_jTableServers.addMouseListener((MouseListener)mouseAdapter);
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = JPanelSettingsServers.this.m_jTableServers.columnAtPoint(point);
                int n2 = JPanelSettingsServers.this.m_jTableServers.rowAtPoint(point);
                if (n == 0) {
                    JPanelSettingsServers.this.m_dtcrConnectionPath.setMouseOverRowCol(n2, n, point);
                    JPanelSettingsServers.this.m_jTableServers.repaint();
                    if (JPanelSettingsServers.this.m_dtcrConnectionPath.isMouseOverCellText()) {
                        JPanelSettingsServers.this.getContentPane().setCursor(Cursor.getPredefinedCursor(12));
                        JPanelSettingsServers.this.m_dtcrConnectionPath.setMouseOverCellText(false);
                    } else {
                        JPanelSettingsServers.this.m_dtcrConnectionPath.setMouseOverCellText(false);
                        JPanelSettingsServers.this.getContentPane().setCursor(Cursor.getPredefinedCursor(0));
                    }
                } else {
                    JPanelSettingsServers.this.getContentPane().setCursor(Cursor.getPredefinedCursor(0));
                    JPanelSettingsServers.this.m_dtcrConnectionPath.setMouseOverRowCol(-1, -1);
                    JPanelSettingsServers.this.m_dtcrConnectionPath.setMouseOverCellText(false);
                    JPanelSettingsServers.this.m_jTableServers.repaint();
                }
            }
        };
        this.m_jTableServers.addMouseMotionListener((MouseMotionListener)mouseMotionAdapter);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout2);
        this.m_jPanelButtons.setLayout(this.gridBagLayout1);
        this.m_jButtonResync.setText(res.getString("JPanelSettingsServers_Resync"));
        this.m_jButtonResync.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelSettingsServers.this.m_jButtonResync_actionPerformed(actionEvent);
            }
        });
        this.m_jButtonModifyName.setText(res.getString("JPanelSettingsServers_Modify"));
        this.m_jButtonModifyName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelSettingsServers.this.m_jButtonModifyName_actionPerformed(actionEvent);
            }
        });
        this.m_jScrollPaneServers.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.m_jScrollPaneServers.setPreferredSize(new Dimension(300, 300));
        this.m_jTableServers.setBackground(UIManager.getColor("Table.background"));
        this.add(this.m_jScrollPaneServers, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.m_jScrollPaneServers.getViewport().add((Component)this.m_jTableServers, null);
        this.add(this.m_jPanelButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 15), 0, 0));
        this.m_jPanelButtons.add((Component)this.m_jButtonResync, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.m_jPanelButtons.add((Component)this.m_jButtonModifyName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 5, 0), 0, 0));
    }

    public boolean initialize() {
        boolean bl = this.m_acController.getAppliance().hasMinMibVersion(2, 0);
        this.m_jButtonModifyName.setVisible(bl);
        this.m_jTableServers.setRowSelectionAllowed(bl);
        try {
            this.m_atmssp.getConnectionPathInformation();
        }
        catch (Exception exception) {
            Trace.logError((String)"JPanelSettingsServer", (String)"initialize()", (Throwable)exception);
            return false;
        }
        return true;
    }

    public boolean applyValues() {
        try {
            UnitInfo[] unitInfoArray;
            ArrayList arrayList = this.m_atmssp.getModifiedServers();
            ArrayList<ServerInfo> arrayList2 = new ArrayList<ServerInfo>();
            HashMap<ServerInfo, ServerInfo> hashMap = new HashMap<ServerInfo, ServerInfo>();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ServerInfo serverInfo;
                unitInfoArray = (UnitInfo[])iterator.next();
                if (unitInfoArray.getNameValue() == null) continue;
                InterfaceValueObject[] interfaceValueObjectArray = new InterfaceValueObject[]{unitInfoArray.getNameValue()};
                AvrSnmpHelper.setValues(this.m_acController.getAsmpConnection(), interfaceValueObjectArray);
                if (unitInfoArray.isServerMerged()) {
                    serverInfo = ServersDb.getServerInfo((int)unitInfoArray.getServerDbID());
                    int n = serverInfo.getApplianceIndex(1);
                    ServersDb.delete((int[])new int[]{unitInfoArray.getServerDbID()});
                    InterfacesDb.merge((int)unitInfoArray.getServerDbID(), (int)unitInfoArray.getNewServerDbId());
                    ServerInfo serverInfo2 = ServersDb.getServerInfo((int)unitInfoArray.getNewServerDbId());
                    serverInfo2.setApplianceIndex(1, n);
                    if (serverInfo != null) {
                        hashMap.put(serverInfo, serverInfo2);
                    }
                } else {
                    ServersDb.rename((int)unitInfoArray.getServerDbID(), (String)interfaceValueObjectArray[0].getValue().toString());
                    serverInfo = ServersDb.getServerInfo((int)unitInfoArray.getServerDbID());
                    if (serverInfo != null) {
                        arrayList2.add(serverInfo);
                    }
                }
                unitInfoArray.setDbName(interfaceValueObjectArray[0].getValue().toString());
                unitInfoArray.setNewServerName(null);
                unitInfoArray.setNameValue(null);
            }
            if (!arrayList2.isEmpty()) {
                unitInfoArray = new UnitInfo[arrayList2.size()];
                for (int i = 0; i < unitInfoArray.length; ++i) {
                    unitInfoArray[i] = (UnitInfo)arrayList2.get(i);
                }
                AVWorksEventBroadcaster.fireDatabaseServersModifiedEvent((UnitInfo[])unitInfoArray);
            }
            if (!hashMap.isEmpty()) {
                AVWorksEventBroadcaster.fireDatabaseServersMergedEvent(hashMap);
            }
            return true;
        }
        catch (Exception exception) {
            this.m_acController.showException(null, this.getTraceContext(), null, (Throwable)exception);
            return false;
        }
    }

    public void onDestroy() {
        this.logInfo("onDestroy() was called.");
        try {
            AVWorksEventBroadcaster.removeListener((InterfaceAVWorksEventBroadcasterListener)this);
        }
        catch (ExceptionInvalidArgument exceptionInvalidArgument) {
            // empty catch block
        }
    }

    private String[] getServersFromDB() throws ExceptionRequestFailed {
        try {
            ServerInfo[] serverInfoArray = ServersDb.getServerList();
            String[] stringArray = new String[serverInfoArray.length + 1];
            for (int i = 0; i < serverInfoArray.length; ++i) {
                stringArray[i] = serverInfoArray[i].getName();
            }
            stringArray[serverInfoArray.length] = res.getString("JPanelSettingsServers_None");
            return stringArray;
        }
        catch (ExceptionNoValue exceptionNoValue) {
            String[] stringArray = new String[]{res.getString("JPanelSettingsServers_None")};
            return stringArray;
        }
    }

    private boolean doesSwitchAlreadyExist(Vector vector, String string) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            ConnectionPathInfo connectionPathInfo = (ConnectionPathInfo)vector.elementAt(i);
            if (!connectionPathInfo.getConnectionPath().startsWith(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void launchVideo(ConnectionPathInfo connectionPathInfo) {
        try {
            Object object;
            CharSequence charSequence;
            this.m_acController.setBusy(true);
            String string = this.m_acController.getApplianceInfo().getAddress();
            if (!AvrNmmInterface.checkApplianceVideoAvailability(string, null, (Component)this.m_acController.getMainFrame())) {
                this.m_acController.setBusy(false);
                return;
            }
            String string2 = "conn=AVSP-SSL";
            this.m_acController.setBusy(false);
            String string3 = "";
            if (connectionPathInfo.getServerDbName() != res.getString("JPanelSettingsServers_None")) {
                string3 = connectionPathInfo.getServerDbName();
            } else {
                string3 = connectionPathInfo.getConnectionPath();
                charSequence = new StringBuffer();
                for (int i = 0; i < string3.length(); ++i) {
                    if (string3.charAt(i) == '\u27a1') {
                        ((StringBuffer)charSequence).append('-');
                        ((StringBuffer)charSequence).append('>');
                        continue;
                    }
                    ((StringBuffer)charSequence).append(string3.charAt(i));
                }
                string3 = ((StringBuffer)charSequence).toString();
            }
            charSequence = AVWorksBranding.getString((String)"vsvProductName", (String)res.getString("JPanelSettingsServers_Video_Session_Viewer"));
            String string4 = "title=\"" + string3 + " - " + (String)charSequence + "\"";
            String string5 = "user=" + CachedCredentials.getUsername();
            String string6 = "password=" + CachedCredentials.getPassword();
            String string7 = "application_name=avworks";
            String string8 = "ifaceviewer3=com.avocent.avworks.services.InterfaceViewerAVWorks";
            String[] stringArray = this.createPathArguments(connectionPathInfo);
            String string9 = null;
            File file = new File("help");
            if (file != null && file.exists()) {
                object = LaunchBrowserHelp.pageToURLStr((String)file.getAbsolutePath());
                object = ((String)object).replaceAll("\"", "");
                string9 = "helpurl=" + (String)object;
            }
            object = new Vector<String>();
            ((Vector)object).add(string4);
            ((Vector)object).add(string5);
            ((Vector)object).add(string6);
            ((Vector)object).add(string8);
            ((Vector)object).add(string2);
            ((Vector)object).add(string7);
            if (string9 != null) {
                ((Vector)object).add(string9);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                ((Vector)object).add(stringArray[i]);
                Trace.logInfo((String)"ServersSettings:launchVideo", (String)("Launching video Path = " + stringArray[i]));
            }
            Object[] objectArray = new String[((Vector)object).size()];
            ((Vector)object).copyInto(objectArray);
            videoViewer.launch((String[])objectArray, (Frame)this.m_acController.getMainFrame());
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            this.m_acController.setBusy(false);
            String string = res.getString("JPanelSettingsServers_Appliance_not_available");
            Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true), exceptionRequestFailed.getMessage()};
            string = MessageFormat.format(string, objectArray);
            Message.show((Component)this.m_acController.getMainFrame(), (String)string);
            return;
        }
        catch (Exception exception) {
            this.m_acController.setBusy(false);
            String string = res.getString("JPanelSettingsServers_Appliance_not_available");
            Object[] objectArray = new Object[]{AVWorksBranding.getApplianceName((boolean)true), res.getString("JPanelSettingsServers_Unknown_error")};
            string = MessageFormat.format(string, objectArray);
            Message.show((Component)this.m_acController.getMainFrame(), (String)string);
            return;
        }
    }

    private String[] createPathArguments(ConnectionPathInfo connectionPathInfo) throws ExceptionRequestFailed {
        Vector<AvrViewerCmdLinePathInfo> vector = new Vector<AvrViewerCmdLinePathInfo>();
        try {
            String string;
            AvrViewerCmdLinePathInfo avrViewerCmdLinePathInfo;
            Object object;
            Object object2;
            UnitInfo.CredPolicy credPolicy;
            int n;
            ApplianceInfo applianceInfo = this.m_acController.getApplianceInfo();
            int n2 = this.m_acController.getLoginTimeout(applianceInfo.getID());
            String string2 = connectionPathInfo.getServerDbName();
            if (string2.equals(res.getString("JPanelSettingsServers_None"))) {
                string2 = "";
                n = 0;
                credPolicy = applianceInfo.getPolicy();
            } else {
                object2 = "WHERE NAME=" + SqlCmd.quote((String)string2);
                object = ServersDb.getServerList((String)object2);
                if (((ServerInfo[])object).length != 1) {
                    throw new ExceptionRequestFailed();
                }
                n = object[0].getID();
                credPolicy = object[0].getPolicy();
                if (credPolicy.getCacheMode() == 1) {
                    credPolicy = applianceInfo.getPolicy();
                }
            }
            if (!connectionPathInfo.isSwitch()) {
                avrViewerCmdLinePathInfo = new AvrViewerCmdLinePathInfo(applianceInfo.getID(), applianceInfo.getAddress(), "", connectionPathInfo.getConnectionPath(), "", n, string2, credPolicy.getUseCache(), AvrNmmInterface.hasApcp(applianceInfo.getProductID()));
                avrViewerCmdLinePathInfo.setLoginTimeout(n2);
                vector.add(avrViewerCmdLinePathInfo);
            } else {
                object2 = this.getSwitchChanNum(connectionPathInfo.getConnectionPath());
                object = connectionPathInfo.getInterfacesConnectedToSwitch();
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    string = (String)((Vector)object).elementAt(i);
                    avrViewerCmdLinePathInfo = new AvrViewerCmdLinePathInfo(applianceInfo.getID(), applianceInfo.getAddress(), "", string, (String)object2, n, string2, credPolicy.getUseCache(), AvrNmmInterface.hasApcp(applianceInfo.getProductID()));
                    avrViewerCmdLinePathInfo.setLoginTimeout(n2);
                    vector.add(avrViewerCmdLinePathInfo);
                }
            }
            object2 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                AvrViewerCmdLinePathInfo avrViewerCmdLinePathInfo2 = (AvrViewerCmdLinePathInfo)vector.elementAt(i);
                string = avrViewerCmdLinePathInfo2.createPathArgument();
                ((Vector)object2).add(string);
            }
            Object[] objectArray = new String[((Vector)object2).size()];
            ((Vector)object2).copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            Trace.logError((String)"JPanelSettingsServers:createPathArguments", (String)"Error creating paths", (Throwable)exception);
            throw new ExceptionRequestFailed();
        }
    }

    private String getSwitchChanNum(String string) throws ExceptionRequestFailed {
        String string2 = "";
        int n = string.lastIndexOf("\u27a1");
        if (n == -1) {
            Trace.logError((String)"JPanelSettingsServers:createPathArguments", (String)"Error parsing path.");
            throw new ExceptionRequestFailed();
        }
        String string3 = string.substring(n + 1).trim();
        if (string3.length() == 0) {
            Trace.logError((String)"JPanelSettingsServers:createPathArguments", (String)"Empty Names.");
            throw new ExceptionRequestFailed();
        }
        for (int i = 0; i < string3.length(); ++i) {
            char c = string3.charAt(i);
            if (!Character.isDigit(c)) continue;
            string2 = string3.substring(i);
            break;
        }
        return string2;
    }

    void m_jButtonResync_actionPerformed(ActionEvent actionEvent) {
        this.doActionResyncButton();
    }

    void m_jButtonModifyName_actionPerformed(ActionEvent actionEvent) {
        Object object;
        int n = this.m_jTableServers.getSelectedRow();
        int n2 = this.m_tmcs.getSortedRowIndexAt(n);
        final ConnectionPathInfo connectionPathInfo = this.m_atmssp.getConnectionPathAtIndex(n2);
        if (connectionPathInfo.getServerMibIndex() <= 0) {
            String string = res.getString("JPanelSettingsServers_No_Appliance_Record");
            Message.show((Component)((Object)this), (String)string);
            return;
        }
        try {
            object = ConnectionPath.getConnectionPaths((int)connectionPathInfo.getServerDbID());
            int n3 = this.m_acController.getApplianceInfo().getID();
            String string = AppliancesDb.getApplianceInfo((int)n3).getName();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (string.equals(object[i])) continue;
                arrayList.add(object[i]);
            }
            if (arrayList.size() > 0 && this.popMultipleConnectionDialog(arrayList)) {
                return;
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"JPanelSettingsServer.ModifyActionPerformed", (String)exception.getMessage(), (Throwable)exception);
        }
        this.m_acController.setBusy(true);
        object = new SwingWorker(){

            public Object construct() {
                try {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add("avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableRipId");
                    arrayList.add("avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableSwitchChannel");
                    arrayList.add("avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableServerName");
                    InterfaceValueObject[] interfaceValueObjectArray = AvrSnmpHelper.getValues(JPanelSettingsServers.this.m_acController.getAsmpConnection(), arrayList.toArray(), Integer.toString(connectionPathInfo.getServerMibIndex()));
                    String string = interfaceValueObjectArray[0].getString();
                    int n = interfaceValueObjectArray[1].getInteger();
                    if (string.compareTo(connectionPathInfo.getRipId()) == 0 && n == connectionPathInfo.getSwitchChannel()) {
                        return interfaceValueObjectArray[2];
                    }
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }

            public void finished() {
                JPanelSettingsServers.this.m_acController.setBusy(false);
                JPanelSettingsServers.this.popModifyNameDialog(this.get());
            }
        };
        object.start();
    }

    private boolean popMultipleConnectionDialog(List list) {
        String[] stringArray = list.toArray(new String[list.size()]);
        try {
            if (this.m_jdMultipleConnectionDialog == null) {
                this.m_jdMultipleConnectionDialog = new JDialogMultipleConnectionWarning((JPanelAmpPanel)this);
            }
            this.m_jdMultipleConnectionDialog.showServer(stringArray);
            return this.m_jdMultipleConnectionDialog.userCancelled();
        }
        catch (Exception exception) {
            Trace.logError((String)"JPanelSettingsServers:popModifyNameDialog", (String)"Error on Dialog.", (Throwable)exception);
            return false;
        }
    }

    public void popModifyNameDialog(Object object) {
        if (object == null) {
            String string = res.getString("JPanelSettingsServers_No_Appliance_Record");
            Message.show((Component)((Object)this), (String)string);
            return;
        }
        int n = this.m_jTableServers.getSelectedRow();
        int n2 = this.m_tmcs.getSortedRowIndexAt(n);
        ConnectionPathInfo connectionPathInfo = this.m_atmssp.getConnectionPathAtIndex(n2);
        connectionPathInfo.setNameValue((InterfaceValueObject)object);
        try {
            if (this.m_jdModifyNameDialog == null) {
                this.m_jdModifyNameDialog = new JDialogModifyServerName(this);
            }
            this.m_jdModifyNameDialog.showServer(connectionPathInfo);
            if (this.m_jdModifyNameDialog.NameChanged()) {
                this.setIsModified(true);
                this.m_tmcs.fireTableRowsUpdated(n, n);
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"JPanelSettingsServers:popModifyNameDialog", (String)"Error on Dialog.");
        }
    }

    private void doActionResyncButton() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    AvrResyncWizard.showWizard(JPanelSettingsServers.this.m_acController, JPanelSettingsServers.this.m_acController.getApplianceInfo());
                }
                catch (Exception exception) {
                    String string = res.getString("JPanelSettingsServers_Could_not_start_the");
                    Message.show((Component)JPanelSettingsServers.this.m_acController.getMainFrame(), (String)string);
                }
            }
        });
        thread.start();
    }

    public void doHandleEvent(Object object, int n) {
        Trace.logInfo((String)"ServersEventListenerInterface:doHandleEvent", (String)("Received event ID=" + n));
        if (this.isVisible()) {
            try {
                this.m_atmssp.getConnectionPathInformation();
            }
            catch (Exception exception) {
                Trace.logError((String)"JPanelSettingsServer", (String)("doHandleEvent(" + object + "," + n + ")"), (Throwable)exception);
            }
        } else {
            this.m_nState = 101;
        }
    }

    public boolean checkServerNameInModel(String string) {
        ConnectionPathInfo connectionPathInfo;
        ArrayList arrayList = this.m_atmssp.getModifiedServers();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            connectionPathInfo = (ConnectionPathInfo)iterator.next();
            if (connectionPathInfo.getDisplayName().compareToIgnoreCase(string) != 0) continue;
            return true;
        }
        arrayList = this.m_atmssp.getUnmodifiedServers();
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            connectionPathInfo = (ConnectionPathInfo)iterator.next();
            if (connectionPathInfo.getDisplayName().compareToIgnoreCase(string) != 0 && connectionPathInfo.getServerDbName().compareToIgnoreCase(string) != 0) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ void access$200(JPanelSettingsServers jPanelSettingsServers, ConnectionPathInfo connectionPathInfo) {
        jPanelSettingsServers.launchVideo(connectionPathInfo);
    }

    public class TableModelServers
    extends AbstractTableModel {
        String szServerPluralName = AVWorksBranding.getServerName((boolean)false);
        private String[] m_aszColumnHeaders = new String[]{res.getString("JPanelSettingsServers_Connections"), this.szServerPluralName};
        ArrayList m_asscpiConnections = new ArrayList();

        public int getRowCount() {
            return this.m_asscpiConnections.size();
        }

        public int getColumnCount() {
            return this.m_aszColumnHeaders.length;
        }

        public String getColumnName(int n) {
            if (n < 0 || n >= this.m_aszColumnHeaders.length) {
                Trace.logInfo((String)"AbstractTableModelServersSettingsPanel:getColumnName", (String)"Invalid column requested");
                return "";
            }
            return this.m_aszColumnHeaders[n];
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.m_asscpiConnections.get(n);
                }
                default: {
                    String string = "";
                    try {
                        string = this.m_asscpiConnections.get(n).toString();
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        Trace.logError((String)"AbstractTableModelServersSettingsPanel", (String)indexOutOfBoundsException.toString());
                        string = "Processing Error";
                    }
                    return string;
                }
                case 1: 
            }
            return ((ConnectionPathInfo)this.m_asscpiConnections.get(n)).getDisplayName();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    try {
                        if (object instanceof ConnectionPathInfo) {
                            ConnectionPathInfo connectionPathInfo = (ConnectionPathInfo)object;
                            this.setTableData(connectionPathInfo, n);
                            break;
                        }
                        String string = "Table column data not set .. unknow data type.";
                        Trace.logError((String)string, (String)"setValueAt() for first column failed");
                    }
                    catch (RuntimeException runtimeException) {
                        Trace.logError((String)"", (String)runtimeException.toString());
                    }
                    break;
                }
                case 1: {
                    ((ConnectionPathInfo)this.m_asscpiConnections.get(n)).setDbName((String)object);
                }
            }
        }

        private void setTableData(ConnectionPathInfo connectionPathInfo, int n) throws IndexOutOfBoundsException, NullPointerException {
            this.m_asscpiConnections.set(n, connectionPathInfo);
        }

        private ConnectionPathInfo getConnectionPathAtIndex(int n) {
            return (ConnectionPathInfo)this.m_asscpiConnections.get(n);
        }

        private void getConnectionPathInformation() throws ExceptionRequestFailed {
            Vector<Object> vector = new Vector<Object>();
            Vector<String> vector2 = new Vector<String>();
            ApplianceInfo applianceInfo = null;
            InterfaceInfo[] interfaceInfoArray = null;
            try {
                applianceInfo = JPanelSettingsServers.this.m_acController.getApplianceInfo();
                String string = "WHERE APPLIANCE_ID=" + Integer.toString(applianceInfo.getID());
                interfaceInfoArray = InterfacesDb.getInterfaceInfoList((String)string);
            }
            catch (ExceptionNoValue exceptionNoValue) {
                this.m_asscpiConnections.clear();
                this.fireTableDataChanged();
                return;
            }
            catch (Exception exception) {
                Trace.logError((String)"JPanelSettings:getConnectionPathInformation", (String)"Unable to get appliance interfaces.");
                throw new ExceptionRequestFailed((Throwable)exception);
            }
            try {
                for (int i = 0; i < interfaceInfoArray.length; ++i) {
                    Object object;
                    Object object2;
                    InterfaceInfo interfaceInfo = interfaceInfoArray[i];
                    if (interfaceInfo.getConnType() == 0) {
                        object2 = new ConnectionPathInfo(interfaceInfo.getName(), res.getString("JPanelSettingsServers_None"), false, interfaceInfo.getPortNum(), "", 0, vector2, interfaceInfo.getConnID(), -1);
                        vector.add(object2);
                        continue;
                    }
                    if (interfaceInfo.getConnType() == 1) {
                        object2 = ServersDb.getServerInfo((int)interfaceInfo.getConnID());
                        object = new ConnectionPathInfo(interfaceInfo.getName(), object2.getName(), false, interfaceInfo.getPortNum(), interfaceInfo.getName(), 0, vector2, interfaceInfo.getConnID(), object2.getApplianceIndex(1));
                        vector.add(object);
                        continue;
                    }
                    if (interfaceInfo.getConnType() != 2) continue;
                    object2 = AppliancesDb.getApplianceInfo((int)interfaceInfo.getConnID());
                    object = object2.getName();
                    if (JPanelSettingsServers.this.doesSwitchAlreadyExist(vector, (String)(object = ConnectionPath.parseSwitchName((String)object)))) continue;
                    String string = "WHERE (APPLIANCE_ID=" + Integer.toString(applianceInfo.getID()) + ")" + " AND" + " (CONN_ID=" + Integer.toString(interfaceInfo.getConnID()) + ")" + " AND" + " (CONN_TYPE=" + Integer.toString(2) + ")";
                    InterfaceInfo[] interfaceInfoArray2 = InterfacesDb.getInterfaceInfoList((String)string);
                    for (int j = 0; j < interfaceInfoArray2.length; ++j) {
                        vector2.add(interfaceInfoArray2[j].getName());
                    }
                    String string2 = "WHERE APPLIANCE_ID=" + Integer.toString(interfaceInfo.getConnID());
                    InterfaceInfo[] interfaceInfoArray3 = InterfacesDb.getInterfaceInfoList((String)string2);
                    for (int j = 0; j < interfaceInfoArray3.length; ++j) {
                        Object object3;
                        InterfaceInfo interfaceInfo2 = interfaceInfoArray3[j];
                        if (interfaceInfo2.getConnType() == 0) {
                            object3 = new ConnectionPathInfo((String)object + "\u27a1" + interfaceInfo2.getName(), res.getString("JPanelSettingsServers_None"), true, interfaceInfo.getPortNum(), interfaceInfo.getName(), interfaceInfo2.getPortNum(), vector2, interfaceInfo.getConnID(), -1);
                            vector.add(object3);
                            continue;
                        }
                        if (interfaceInfo2.getConnType() != 1) continue;
                        object3 = ServersDb.getServerInfo((int)interfaceInfo2.getConnID());
                        ConnectionPathInfo connectionPathInfo = new ConnectionPathInfo((String)object + "\u27a1" + interfaceInfo2.getName(), object3.getName(), true, interfaceInfo.getPortNum(), interfaceInfo.getName(), interfaceInfo2.getPortNum(), vector2, interfaceInfo2.getConnID(), object3.getApplianceIndex(1));
                        vector.add(connectionPathInfo);
                    }
                    vector2.removeAllElements();
                }
                this.m_asscpiConnections.clear();
                this.m_asscpiConnections.addAll(vector);
                this.fireTableDataChanged();
            }
            catch (Exception exception) {
                Trace.logError((String)"JPanelSettings:getConnectionPathInformation", (String)"Unable to get connection paths");
                throw new ExceptionRequestFailed((Throwable)exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void readServersTable() throws Exception {
            ConnectionPathInfo connectionPathInfo;
            InterfaceValueObject[][] interfaceValueObjectArray;
            block14: {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableIndex");
                arrayList.add("avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableRipId");
                arrayList.add("avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableSwitchChannel");
                arrayList.add("avocent.ds.dsManagement.dsServer.dsServerTable.dsServerTableEntry.dsServerTableServerName");
                interfaceValueObjectArray = null;
                interfaceValueObjectArray = AvrSnmpHelper.getTableValues(JPanelSettingsServers.this.m_acController.getAsmpConnection(), arrayList.toArray());
                if (interfaceValueObjectArray == null) {
                    throw new Exception("DsSnmpHelper.getTableValues() returns null.");
                }
                connectionPathInfo = null;
                if (interfaceValueObjectArray != null) break block14;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                interfaceValueObjectArray = AvrSnmpHelper.getTableValues(JPanelSettingsServers.this.m_acController.getAsmpConnection(), arrayList.toArray());
                {
                    break block14;
                    catch (Exception exception) {
                        Trace.logError((String)exception.toString(), (String)"", (Throwable)exception);
                        connectionPathInfo = null;
                        if (interfaceValueObjectArray != null) break block14;
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        interfaceValueObjectArray = AvrSnmpHelper.getTableValues(JPanelSettingsServers.this.m_acController.getAsmpConnection(), arrayList.toArray());
                    }
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    if (interfaceValueObjectArray == null) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        interfaceValueObjectArray = AvrSnmpHelper.getTableValues(JPanelSettingsServers.this.m_acController.getAsmpConnection(), arrayList.toArray());
                    }
                    throw throwable;
                }
            }
            ArrayList arrayList = this.m_asscpiConnections;
            synchronized (arrayList) {
                for (int i = 0; i < interfaceValueObjectArray.length; ++i) {
                    connectionPathInfo = this.findPath(0, interfaceValueObjectArray[i][1].getString(), interfaceValueObjectArray[i][2].getInteger());
                    if (connectionPathInfo == null) continue;
                    connectionPathInfo.setNameValue(interfaceValueObjectArray[i][3]);
                }
            }
        }

        private ConnectionPathInfo findPath(int n, String string, int n2) {
            if (this.m_asscpiConnections != null && this.m_asscpiConnections.size() > 0) {
                for (int i = 0; i < this.m_asscpiConnections.size(); ++i) {
                    ConnectionPathInfo connectionPathInfo = (ConnectionPathInfo)this.m_asscpiConnections.get(i);
                    if (connectionPathInfo.getRipId().compareTo(string) != 0 || connectionPathInfo.getSwitchChannel() != n2) continue;
                    return connectionPathInfo;
                }
            }
            return null;
        }

        protected ArrayList getModifiedServers() {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.m_asscpiConnections.size(); ++i) {
                if (!((ConnectionPathInfo)this.m_asscpiConnections.get(i)).isNameModified()) continue;
                arrayList.add(this.m_asscpiConnections.get(i));
            }
            return arrayList;
        }

        protected ArrayList getUnmodifiedServers() {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.m_asscpiConnections.size(); ++i) {
                if (((ConnectionPathInfo)this.m_asscpiConnections.get(i)).isNameModified()) continue;
                arrayList.add(this.m_asscpiConnections.get(i));
            }
            return arrayList;
        }
    }

    class ConnectionPathInfo
    implements Comparable {
        String m_szConnectionPath;
        String m_szServerDbName;
        boolean m_bIsSwitch;
        Vector m_vInterfacesConnectedToSwitch;
        private boolean m_bNameModified = false;
        private String m_szNewName = null;
        private InterfaceValueObject m_ivoServerName;
        private int m_nPortID = 0;
        private String m_szRipID = "";
        private int m_nSwitchChannel = 0;
        private int m_nServerDbId;
        private int m_nNewServerDbId;
        private int m_nServerMibIdx;

        public ConnectionPathInfo(String string, String string2, boolean bl, int n, String string3, int n2, Vector vector, int n3, int n4) {
            this.m_szConnectionPath = string;
            this.m_szServerDbName = string2;
            this.m_bIsSwitch = bl;
            this.m_vInterfacesConnectedToSwitch = (Vector)vector.clone();
            this.m_nPortID = n;
            this.m_szRipID = string3;
            this.m_nSwitchChannel = n2;
            this.m_nServerDbId = n3;
            this.m_nServerMibIdx = n4;
            this.m_ivoServerName = null;
        }

        public String getConnectionPath() {
            return this.m_szConnectionPath;
        }

        public void setConnectionPath(String string) {
            this.m_szConnectionPath = string;
        }

        public String getServerDbName() {
            return this.m_szServerDbName;
        }

        public String getRipId() {
            return this.m_szRipID;
        }

        public int getServerDbID() {
            return this.m_nServerDbId;
        }

        public int getSwitchChannel() {
            return this.m_nSwitchChannel;
        }

        public void setNewServerName(String string) {
            this.setNewServerName(string, 0);
        }

        public void setNewServerName(String string, int n) {
            if (string != null) {
                this.m_szNewName = string;
                this.m_bNameModified = true;
                this.m_nNewServerDbId = n;
                if (this.m_ivoServerName != null) {
                    this.m_ivoServerName.setValue((Object)string);
                }
            } else {
                this.m_szNewName = "";
                this.m_bNameModified = false;
                this.m_nNewServerDbId = 0;
            }
        }

        public boolean isSwitch() {
            return this.m_bIsSwitch;
        }

        public Vector getInterfacesConnectedToSwitch() {
            return this.m_vInterfacesConnectedToSwitch;
        }

        public String getConnectionPathText() {
            String string = null;
            if (this.isSwitch()) {
                try {
                    String string2;
                    ApplianceInterface applianceInterface = ConnectionPath.getApplianceInterface((String)this.getConnectionPath());
                    String string3 = ConnectionPath.parseSwitchName((String)applianceInterface.getApplianceName());
                    String string4 = applianceInterface.getInterfaceName();
                    string = string2 = string3 + "\u27a1" + string4;
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logInfo((String)"DefaultTableCellRendererConnectionPath:get...()", (String)"Unable to get ApplianceInterface.");
                    string = this.getConnectionPath();
                }
                catch (RuntimeException runtimeException) {
                    Trace.logError((String)"DefaultTableCellRendererConnectionPath:get...()", (String)runtimeException.toString());
                }
            } else {
                string = this.getConnectionPath();
            }
            return string;
        }

        public String toString() {
            String string = this.getConnectionPathText();
            if (string == null) {
                Trace.logError((String)"ConnnectionPathInfo:", (String)"Unable to obtain path info from getConnectionPathText()");
                string = "Path = " + this.m_szConnectionPath + "Server = " + this.m_szServerDbName + "isSwitch = " + this.m_bIsSwitch + "other info = " + this.m_vInterfacesConnectedToSwitch.toString();
            }
            return string;
        }

        public int compareTo(Object object) throws RuntimeException {
            int n = 0;
            if (object instanceof ConnectionPathInfo) {
                n = this.toString().compareTo(object.toString());
            } else {
                throw new IllegalArgumentException("Non-ConnectionPathInfo class type");
            }
            return n;
        }

        public void setDbName(String string) {
            this.m_szServerDbName = string;
        }

        public boolean isNameModified() {
            return this.m_bNameModified;
        }

        public void setNameValue(InterfaceValueObject interfaceValueObject) {
            this.m_ivoServerName = interfaceValueObject;
        }

        public InterfaceValueObject getNameValue() {
            if (this.m_szNewName != null && this.m_bNameModified && this.m_ivoServerName != null) {
                this.m_ivoServerName.setValue((Object)this.m_szNewName);
            }
            return this.m_ivoServerName;
        }

        public String getServerAppName() {
            if (this.m_ivoServerName == null) {
                return "";
            }
            return this.m_ivoServerName.getValue().toString();
        }

        public String getDisplayName() {
            if (this.m_szNewName != null && this.m_bNameModified) {
                return this.m_szNewName;
            }
            return this.m_szServerDbName;
        }

        public int getServerMibIndex() {
            return this.m_nServerMibIdx;
        }

        public boolean isServerMerged() {
            return this.m_nNewServerDbId != 0;
        }

        public int getNewServerDbId() {
            return this.m_nNewServerDbId;
        }
    }

    public class CellRendererConnectionPath
    extends DefaultTableCellRenderer {
        private Point m_Point = new Point(-1, -1);
        private int m_nMouseOverRow = -1;
        private int m_nMouseOverCol = -1;
        private int m_nRow = 0;
        private int m_nCol = 0;
        private boolean m_bIsMouseOverCellText = false;
        private ImageIcon m_iiConnect = null;

        public CellRendererConnectionPath() {
            this.setForeground(Color.blue);
            this.setFont(this.getFont().deriveFont(0));
            this.m_iiConnect = AVWorksBranding.getImage((String)"videoApplicationIcon", null);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof String) {
                this.setText((String)object);
            } else if (object instanceof ConnectionPathInfo) {
                String string = "";
                ConnectionPathInfo connectionPathInfo = (ConnectionPathInfo)object;
                string = connectionPathInfo.toString();
                this.setText(string);
            } else {
                this.setText(object.toString());
            }
            this.setIcon(this.m_iiConnect);
            this.m_nRow = n;
            this.m_nCol = n2;
            return this;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            Rectangle rectangle = this.getBounds();
            String string = this.getText();
            int n = this.getIcon().getIconWidth() + 5;
            int n2 = rectangle.y;
            int n3 = fontMetrics.getHeight() + 2;
            int n4 = n + fontMetrics.stringWidth(this.getText());
            Rectangle rectangle2 = new Rectangle(0, n2, n4, n3 - n2 + rectangle.y);
            if (this.getText().length() > 0 && this.m_nRow == this.m_nMouseOverRow && this.m_nCol == this.m_nMouseOverCol && rectangle2.contains(this.m_Point)) {
                graphics.drawLine(n, rectangle2.height - 3, n4, rectangle2.height - 3);
                String string2 = AVWorksBranding.getString((String)"ConnectVideoTip", (String)res.getString("JPanelSettingsServers_Connect_Video_Tooltip"));
                this.setToolTipText(string2);
                this.m_bIsMouseOverCellText = true;
            }
        }

        public void setMouseOverRowCol(int n, int n2) {
            this.m_nMouseOverRow = n;
            this.m_nMouseOverCol = n2;
        }

        public void setMouseOverRowCol(int n, int n2, Point point) {
            this.m_nMouseOverRow = n;
            this.m_nMouseOverCol = n2;
            this.m_Point = point;
        }

        public boolean isMouseOverCellText() {
            return this.m_bIsMouseOverCellText;
        }

        public void setMouseOverCellText(boolean bl) {
            this.m_bIsMouseOverCellText = bl;
        }
    }
}

